:: Author: Manuel de la Pena <manuel@canonical.com>
::
:: Copyright 2010 Canonical Ltd.
::
:: This program is free software: you can redistribute it and/or modify it
:: under the terms of the GNU General Public License version 3, as published
:: by the Free Software Foundation.
::
:: This program is distributed in the hope that it will be useful, but
:: WITHOUT ANY WARRANTY; without even the implied warranties of
:: MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
:: PURPOSE.  See the GNU General Public License for more details.
::
:: You should have received a copy of the GNU General Public License along
:: with this program.  If not, see <http://www.gnu.org/licenses/>.
@ECHO off
:: We could have Python 2.6 or 2.7 on Windows. In order to check availability,
:: we should first check for 2.7, and run the tests, otherwise fall back to 2.6.
SET PYTHONPATH=""
:: This is very annoying; FOR /F will work differently depending on the output
:: of reg which is not consistent between OS versions (XP, 7). We must choose
:: the tokens according to OS version.
SET PYTHONPATHTOKENS=3
VER | FIND "XP" > nul
IF %ERRORLEVEL% == 0 SET PYTHONPATHTOKENS=4
ECHO Checking if python 2.7 is in the system
:: Look for python 2.7
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Python\PythonCore\2.7\InstallPath /ve') DO @SET PYTHONPATH=%%A
IF NOT %PYTHONPATH% == "" GOTO :PYTHONPRESENT
ECHO Checking if python 2.6 is in the system
:: we do not have python 2.7 in the system, try to find 2.6
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Python\PythonCore\2.6\InstallPath /ve') DO @SET PYTHONPATH=%%A
IF NOT %PYTHONPATH% == "" GOTO :PYTHONPRESENT

:: we do not have python (2.6 or 2.7) this could hapen in the case  that the
:: user installed the 32version in a 64 machine, let check if the software was installed in the wow key

:: Look for python 2.7 in WoW64
ECHO Checking if python 2.7 32 is in the system
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Wow6432Node\Python\PythonCore\2.7\InstallPath /ve') DO @SET PYTHONPATH=%%A
IF NOT %PYTHONPATH% == "" GOTO :PYTHONPRESENT
ECHO Checking if python 2.6 32 is in the system
:: we do not have python 2.7 in the system, try to find 2.6
FOR /F "tokens=%PYTHONPATHTOKENS%" %%A IN ('REG QUERY HKLM\Software\Wow6432Node\Python\PythonCore\2.6\InstallPath /ve') DO @SET PYTHONPATH=%%A
IF NOT %PYTHONPATH% == "" GOTO :PYTHONPRESENT

ECHO Please ensure you have python installed
GOTO :END


:PYTHONPRESENT
ECHO Python found, executing the tests...
:: execute the tests with a number of ignored linux only modules
"%PYTHONPATH%\python.exe" "%PYTHONPATH%\Scripts\u1trial" -c ubuntu_sso -i "test_gui.py, test_linux.py, test_txsecrets.py"
"%PYTHONPATH%\python.exe" "%PYTHONPATH%\Scripts\u1lint" ubuntu_sso
:: test for style if we can, if pep8 is not present, move to the end
IF EXIST "%PYTHONPATH%Scripts\pep8.exe"
"%PYTHONPATH%\Scripts\pep8.exe" --repeat ubuntu_sso
ELSE
ECHO Style checks were not done
:: Delete the temp folders
RMDIR /s /q _trial_temp
RMDIR /s /q .coverage
:END