#!/usr/bin/env php
<?
	/**
	 * Human / Tangerine Theme for Firefox creation script.
	 *
	 * This script will build a new JAR file containing the latest
	 * icons and graphics stored on the build system.
	 *
	 * Prerequisites (software):
	 * - Human, Tangerine and Tango icon sets
	 * - PHP
	 * - Imagemagick
	 * - Inkscape
	 * - JAR utility
	 * - "file"
	 * 
	 * Translated to Ubuntu (Debian) packages this list becomes:
	 * ubuntu-artwork
	 * tangerine-icon-theme
	 * tango-icon-theme
	 * php5-cli
	 * imagemagick
	 * inkscape
	 * java-gcj-compat
	 * file
	 *
	 * This script was written for use with Ubuntu 6.06 Dapper Drake,
	 * (c) 2006, Frank Schoep.
	 */
	 
	// required functions
	require_once "imagefunctions.php";
	
	// initializaiton and cleanup
	require_once "initialize.php";
	require_once "debugfunctions.php";
	
	// build environment sanity check
	require_once "checkenvironment.php";

	// image creation scripts
	require_once "createtoolbar.php";
	require_once "createmiscbuttons.php";
	require_once "creategobutton.php";
	require_once "createpreferences.php";
	require_once "createbookmarks.php";
	require_once "createglobalicons.php";
	require_once "createconsole.php";
	require_once "createfilepicker.php";
	require_once "createhelp.php";
	require_once "createdownloads.php";
	require_once "createextensions.php";
	require_once "createshared.php";
	require_once "createupdate.php";
	require_once "createpreview.php";

	/**
	 * Create a full theme.
	 */
	function createTheme($themedesc) {
		// initialize the theme		
		initialize($themedesc);
		
		// start generating images
		createToolbars('classic/browser/');
		createMiscButtons('classic/browser/');
		patchTabClose();
		createGoButton('classic/browser/');
		createPreferences('classic/browser/preferences/');
		patchPreferences();
		createBookmarks('classic/browser/bookmarks/');	
		createGlobalIcons('classic/global/icons/');
		createConsole('classic/global/console/');
		createFilepicker('classic/global/');
		createHelp('classic/help/');
		createDownloads('classic/mozapps/downloads/');
		createExtensions('classic/mozapps/extensions/');
		createShared('classic/mozapps/shared/');
		createUpdate('classic/mozapps/update/');
		createPreview('classic/', 'classic/mozapps/shared/');
	
		// finish generation
		finish();
	}

	/**
	 * Main entry point, create the themes.
	 */
	checkEnvironment();
	 
	createTheme(HUMAN);
	createTheme(TANGERINE);
	createTheme(TANGO);
	
	cleanupTempFiles();
	
?>