/******************************************************************************
 * $Id: port-forwarding.h 5585 2008-04-11 17:01:13Z charles $
 *
 * Copyright (c) 2005-2008 Transmission authors and contributors
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *****************************************************************************/

#ifndef SHARED_H
#define SHARED_H 1

#include "transmission.h"

typedef struct tr_shared tr_shared;

tr_shared* tr_sharedInit            ( tr_handle *, int isEnabled, int publicPort );
void       tr_sharedShuttingDown    ( tr_shared * );
void       tr_sharedSetPort         ( tr_shared *, int publicPort );
void       tr_sharedTraversalEnable ( tr_shared *, int isEnabled );
int        tr_sharedGetPublicPort   ( const tr_shared * s );
int        tr_sharedTraversalStatus ( const tr_shared * );

#endif
