%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%% Graduate Student Sample CV Template %%%%%%%%%
%%%%%%%%%%%% Written By: Anagha Kumar %%%%%%%%%%%%

% I tried to write a generic resume template for graduate students. Naturally, 
% I tried to make it as generic as possible since I cannot possibly come up with every section and subsection 
% imaginable. Regardless, this should serve as a helpful template for those graduate students writing an 
% academic CV. The goal is to create a flexible template that can be customized based on each specific
% individual's needs. I have uploaded a generic CV as a demonstration of how this document class works. 

\NeedsTeXFormat{LaTeX2e}
\ProvidesClass{gradstudentresume}
\LoadClassWithOptions{article}
\RequirePackage{anysize}
% it goes left, right, top, bottom
\marginsize{0.75in}{0.75in}{0in}{1in}

\pagestyle{plain} % because I think pages on CVs should be numbered 

\newcommand{\sectionrule}{\noindent\hfil\rule{\textwidth}{.6pt}\hfil 
\vspace{2mm}}

%% I know latex has smallskip, medskip etc. but I think it is important to have fine control over your output and define your own skips
\newcommand{\smallspace}{\vspace{1mm}}
\newcommand{\medspace}{\vspace{3mm}}
\newcommand{\largespace}{\vspace{5mm}}

\newcommand{\degree}[4]{\noindent{\textbf{{#1}}} \hfill{#2}\\ \textit{#3} \hfill{#4}}
\newcommand{\sectionheading}[1]{\noindent{\large{\sc{#1}}} \\ \sectionrule}
\newcommand{\subsectionheading}[1]{\noindent {\sc{#1}} \vspace{1mm}}
\newcommand{\subsubsectionheading}[3]{\noindent\textbf{#1} \hfill{#2}\\ \textit{#3}}

\newenvironment{wrapped}
{ \begin{itemize}
    \setlength{\itemsep}{0pt}}
{ \end{itemize}} 

\newcommand{\contact}[5] {{\Large{\sc{#1}}} \\ \normalsize {\textit{Address}: {#2} \\ \textit{Telephone}: {#3} \\ \textit{Email}: {#4} \\ \textit{Website}: {#5}}}
% The parameters are name, address, telephone number, email, and website. 

\newenvironment{info}
{\begin{center}}
{\end{center}
\vspace{5mm}}

\newcommand{\reference}[7]{\textbf{#1} \\ {#2} \hfill{Telephone: {#3}} \\ {#4} \hfill{Email: {#5}} \\ {#6} \\ {#7}}
% The parameters are name, title, telephone number, department, email, school, and address line 2. 



