<?xml version="1.0" encoding="UTF-8"?>
<!--
 !  bibhtml.xslt
 !
 ! Part of bibhtml, version 1.3, released 2006 October 31
 ! See <http://purl.org/nxg/dist/bibhtml>
 !
 ! This sample script processes an XML file which contains elements like
 ! <span class='cite'>citation</span>, extracting each of the `citation'
 ! strings and emitting a .aux file which, once a \bibdata line has been
 ! appended, is suitable for processing with BibTeX.  Adapt or extend as
 ! appropriate.
 !
 ! $Revision: 1.1 $
 !-->
<x:stylesheet xmlns:x="http://www.w3.org/1999/XSL/Transform"
                version="1.0"
                exclude-result-prefixes="h"
                xmlns:h="http://www.w3.org/1999/xhtml">

  <x:output method="xml"
            version="1.0"
            doctype-public="-//W3C//DTD XHTML 1.0 Strict//EN"
            doctype-system="http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd"
            omit-xml-declaration="yes"/>

  <x:template match="/">
    <x:apply-templates select="//h:span[@class='cite']"/>
    <x:call-template name="make-tex-command">
      <x:with-param name="command">bibstyle</x:with-param>
      <x:with-param name="content">plainhtml</x:with-param>
    </x:call-template>
  </x:template>

  <x:template match="h:span[@class='cite']">
    <x:call-template name="make-tex-command">
      <x:with-param name="command">citation</x:with-param>
      <x:with-param name="content">
        <x:copy-of select="."/>
      </x:with-param>
    </x:call-template>
  </x:template>

  <x:template name="make-tex-command">
    <x:param name="command"/>
    <x:param name="content"/>
    <x:text>\</x:text>
    <x:value-of select="$command"/>
    <x:text>{</x:text>
    <x:value-of select="$content"/>
    <x:text>}
</x:text>
  </x:template>

</x:stylesheet>
