/* This file is part of Strigi Desktop Search
 *
 * Copyright (C) 2006 Jos van den Oever <jos@vandenoever.info>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; see the file COPYING.LIB.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */
#include "hitsview.h"
#include <qlabel.h>
#include <qtimer.h>
#include <qmessagebox.h>
#include <qapplication.h>
#include "strigilineedit.h"

HitsView::HitsView(StrigiLineEdit* p) : QPopupMenu(p), parent(p) {
    hasmouse = false;
}
void
HitsView::showEvent(QShowEvent *) {
    move();
}
void
HitsView::move() {
    QPoint pp(parent->mapToGlobal(QPoint(0, 0)));
    if (pp.y() > height()) {
        pp.setY(pp.y()-height());
    } else {
        pp.setY(pp.y()+parent->height());
    }
    int dw = QApplication::desktop()->width();
    if (pp.x() + width() > dw) {
        pp.setX(pp.x() + parent->width() - width());
    }
    QPopupMenu::move(pp);
}
void
HitsView::enterEvent(QEvent*) {
    hasmouse = true;
}
void
HitsView::leaveEvent(QEvent*) {
    hasmouse = false;
    QTimer::singleShot( 200, parent, SLOT(hideMenu()) );
}
void
HitsView::keyPressEvent(QKeyEvent *e) {
    if (count()
        && ((e->key() == Qt::Key_Up && isItemActive(0))
        || (e->key() == Qt::Key_Down && isItemActive(count()-1)))) {
        setActiveItem(-1);
        parent->setFocus();
        return;
    }
    QPopupMenu::keyPressEvent(e);
}
