/* page-view.c generated by valac 0.20.1, the Vala compiler
 * generated from page-view.vala, do not modify */

/*
 * Copyright (C) 2009-2011 Canonical Ltd.
 * Author: Robert Ancell <robert.ancell@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <string.h>
#include <stdlib.h>
#include <cairo.h>
#include <gobject/gvaluecollector.h>


#define TYPE_CROP_LOCATION (crop_location_get_type ())

#define TYPE_PAGE_VIEW (page_view_get_type ())
#define PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_VIEW, PageView))
#define PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_VIEW, PageViewClass))
#define IS_PAGE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_VIEW))
#define IS_PAGE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_VIEW))
#define PAGE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_VIEW, PageViewClass))

typedef struct _PageView PageView;
typedef struct _PageViewClass PageViewClass;
typedef struct _PageViewPrivate PageViewPrivate;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_SCAN_DIRECTION (scan_direction_get_type ())
#define _page_unref0(var) ((var == NULL) ? NULL : (var = (page_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecPageView ParamSpecPageView;

typedef enum  {
	CROP_LOCATION_NONE = 0,
	CROP_LOCATION_MIDDLE,
	CROP_LOCATION_TOP,
	CROP_LOCATION_BOTTOM,
	CROP_LOCATION_LEFT,
	CROP_LOCATION_RIGHT,
	CROP_LOCATION_TOP_LEFT,
	CROP_LOCATION_TOP_RIGHT,
	CROP_LOCATION_BOTTOM_LEFT,
	CROP_LOCATION_BOTTOM_RIGHT
} CropLocation;

struct _PageView {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PageViewPrivate * priv;
};

struct _PageViewClass {
	GTypeClass parent_class;
	void (*finalize) (PageView *self);
};

typedef enum  {
	SCAN_DIRECTION_TOP_TO_BOTTOM,
	SCAN_DIRECTION_LEFT_TO_RIGHT,
	SCAN_DIRECTION_BOTTOM_TO_TOP,
	SCAN_DIRECTION_RIGHT_TO_LEFT
} ScanDirection;

struct _PageViewPrivate {
	Page* page;
	GdkPixbuf* image;
	gboolean selected;
	gint border_width;
	gboolean update_image;
	ScanDirection scan_direction;
	gint scan_line;
	gint width;
	gint height;
	gint x_offset;
	gint y_offset;
	CropLocation crop_location;
	gdouble selected_crop_px;
	gdouble selected_crop_py;
	gint selected_crop_x;
	gint selected_crop_y;
	gint selected_crop_w;
	gint selected_crop_h;
	GdkCursorType cursor;
	gint animate_n_segments;
	gint animate_segment;
	guint animate_timeout;
};

struct _ParamSpecPageView {
	GParamSpec parent_instance;
};


static gpointer page_view_parent_class = NULL;

GType crop_location_get_type (void) G_GNUC_CONST;
gpointer page_view_ref (gpointer instance);
void page_view_unref (gpointer instance);
GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page_view (GValue* value, gpointer v_object);
void value_take_page_view (GValue* value, gpointer v_object);
gpointer value_get_page_view (const GValue* value);
GType page_view_get_type (void) G_GNUC_CONST;
gpointer page_ref (gpointer instance);
void page_unref (gpointer instance);
GParamSpec* param_spec_page (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_page (GValue* value, gpointer v_object);
void value_take_page (GValue* value, gpointer v_object);
gpointer value_get_page (const GValue* value);
GType page_get_type (void) G_GNUC_CONST;
GType scan_direction_get_type (void) G_GNUC_CONST;
#define PAGE_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PAGE_VIEW, PageViewPrivate))
enum  {
	PAGE_VIEW_DUMMY_PROPERTY
};
static void page_view_page_pixels_changed_cb (PageView* self, Page* p);
static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self);
static void page_view_page_size_changed_cb (PageView* self, Page* p);
static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self);
static void page_view_page_overlay_changed_cb (PageView* self, Page* p);
static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self);
static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self);
static void page_view_scan_direction_changed_cb (PageView* self, Page* p);
static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self);
PageView* page_view_new (Page* page);
PageView* page_view_construct (GType object_type, Page* page);
Page* page_view_get_page (PageView* self);
void page_view_set_selected (PageView* self, gboolean selected);
gboolean page_view_get_selected (PageView* self);
void page_view_set_x_offset (PageView* self, gint offset);
void page_view_set_y_offset (PageView* self, gint offset);
gint page_view_get_x_offset (PageView* self);
gint page_view_get_y_offset (PageView* self);
static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample);
static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1);
ScanDirection page_get_scan_direction (Page* self);
gint page_get_scan_width (Page* self);
gint page_get_scan_height (Page* self);
gint page_get_depth (Page* self);
gint page_get_n_channels (Page* self);
guchar* page_get_pixels (Page* self, int* result_length1);
gint page_get_rowstride (Page* self);
static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset);
static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line);
gint page_get_width (Page* self);
gint page_get_height (Page* self);
gboolean page_has_data (Page* self);
static gint page_view_get_preview_width (PageView* self);
static gint page_view_get_preview_height (PageView* self);
static void page_view_update_page_view (PageView* self);
gint page_get_scan_line (Page* self);
static gint page_view_page_to_screen_x (PageView* self, gint x);
static gint page_view_page_to_screen_y (PageView* self, gint y);
static gint page_view_screen_to_page_x (PageView* self, gint x);
static gint page_view_screen_to_page_y (PageView* self, gint y);
static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y);
gboolean page_has_crop (Page* self);
void page_get_crop (Page* self, gint* x, gint* y, gint* width, gint* height);
gchar* page_get_named_crop (Page* self);
void page_view_button_press (PageView* self, gint x, gint y);
void page_view_motion (PageView* self, gint x, gint y);
void page_move_crop (Page* self, gint x, gint y);
void page_set_custom_crop (Page* self, gint width, gint height);
void page_view_button_release (PageView* self, gint x, gint y);
GdkCursorType page_view_get_cursor (PageView* self);
static gboolean page_view_animation_cb (PageView* self);
static void page_view_update_animation (PageView* self);
gboolean page_is_scanning (Page* self);
static gboolean _page_view_animation_cb_gsource_func (gpointer self);
void page_view_render (PageView* self, cairo_t* context);
void page_view_set_width (PageView* self, gint width);
void page_view_set_height (PageView* self, gint height);
gint page_view_get_width (PageView* self);
gint page_view_get_height (PageView* self);
static void page_view_finalize (PageView* obj);


GType crop_location_get_type (void) {
	static volatile gsize crop_location_type_id__volatile = 0;
	if (g_once_init_enter (&crop_location_type_id__volatile)) {
		static const GEnumValue values[] = {{CROP_LOCATION_NONE, "CROP_LOCATION_NONE", "none"}, {CROP_LOCATION_MIDDLE, "CROP_LOCATION_MIDDLE", "middle"}, {CROP_LOCATION_TOP, "CROP_LOCATION_TOP", "top"}, {CROP_LOCATION_BOTTOM, "CROP_LOCATION_BOTTOM", "bottom"}, {CROP_LOCATION_LEFT, "CROP_LOCATION_LEFT", "left"}, {CROP_LOCATION_RIGHT, "CROP_LOCATION_RIGHT", "right"}, {CROP_LOCATION_TOP_LEFT, "CROP_LOCATION_TOP_LEFT", "top-left"}, {CROP_LOCATION_TOP_RIGHT, "CROP_LOCATION_TOP_RIGHT", "top-right"}, {CROP_LOCATION_BOTTOM_LEFT, "CROP_LOCATION_BOTTOM_LEFT", "bottom-left"}, {CROP_LOCATION_BOTTOM_RIGHT, "CROP_LOCATION_BOTTOM_RIGHT", "bottom-right"}, {0, NULL, NULL}};
		GType crop_location_type_id;
		crop_location_type_id = g_enum_register_static ("CropLocation", values);
		g_once_init_leave (&crop_location_type_id__volatile, crop_location_type_id);
	}
	return crop_location_type_id__volatile;
}


static void _page_view_page_pixels_changed_cb_page_pixels_changed (Page* _sender, gpointer self) {
#line 85 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_page_pixels_changed_cb (self, _sender);
#line 217 "page-view.c"
}


static void _page_view_page_size_changed_cb_page_size_changed (Page* _sender, gpointer self) {
#line 86 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_page_size_changed_cb (self, _sender);
#line 224 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_crop_changed (Page* _sender, gpointer self) {
#line 87 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_page_overlay_changed_cb (self, _sender);
#line 231 "page-view.c"
}


static void _page_view_page_overlay_changed_cb_page_scan_line_changed (Page* _sender, gpointer self) {
#line 88 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_page_overlay_changed_cb (self, _sender);
#line 238 "page-view.c"
}


static void _page_view_scan_direction_changed_cb_page_scan_direction_changed (Page* _sender, gpointer self) {
#line 89 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_scan_direction_changed_cb (self, _sender);
#line 245 "page-view.c"
}


static gpointer _page_ref0 (gpointer self) {
#line 75 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return self ? page_ref (self) : NULL;
#line 252 "page-view.c"
}


PageView* page_view_construct (GType object_type, Page* page) {
	PageView* self = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
	Page* _tmp2_;
	Page* _tmp3_;
	Page* _tmp4_;
	Page* _tmp5_;
	Page* _tmp6_;
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (page != NULL, NULL);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self = (PageView*) g_type_create_instance (object_type);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = page;
#line 75 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = _page_ref0 (_tmp0_);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_page_unref0 (self->priv->page);
#line 75 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->page = _tmp1_;
#line 76 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page;
#line 76 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_connect (_tmp2_, "pixels-changed", (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 77 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page;
#line 77 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_connect (_tmp3_, "size-changed", (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 78 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = page;
#line 78 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_connect (_tmp4_, "crop-changed", (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 79 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp5_ = page;
#line 79 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_connect (_tmp5_, "scan-line-changed", (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 80 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = page;
#line 80 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_connect (_tmp6_, "scan-direction-changed", (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return self;
#line 299 "page-view.c"
}


PageView* page_view_new (Page* page) {
#line 73 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return page_view_construct (TYPE_PAGE_VIEW, page);
#line 306 "page-view.c"
}


Page* page_view_get_page (PageView* self) {
	Page* result = NULL;
	Page* _tmp0_;
	Page* _tmp1_;
#line 92 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 94 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->page;
#line 94 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = _page_ref0 (_tmp0_);
#line 94 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp1_;
#line 94 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 324 "page-view.c"
}


void page_view_set_selected (PageView* self, gboolean selected) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp9_;
	gboolean _tmp10_;
#line 97 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->selected;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp2_) {
#line 341 "page-view.c"
		gboolean _tmp3_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp3_ = selected;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp1_ = _tmp3_;
#line 347 "page-view.c"
	} else {
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp1_ = FALSE;
#line 351 "page-view.c"
	}
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = _tmp1_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp4_) {
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp0_ = TRUE;
#line 359 "page-view.c"
	} else {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		gboolean _tmp8_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp6_ = self->priv->selected;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (!_tmp6_) {
#line 368 "page-view.c"
			gboolean _tmp7_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp7_ = selected;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp5_ = !_tmp7_;
#line 374 "page-view.c"
		} else {
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp5_ = FALSE;
#line 378 "page-view.c"
		}
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp8_ = _tmp5_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp0_ = _tmp8_;
#line 384 "page-view.c"
	}
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = _tmp0_;
#line 99 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp9_) {
#line 100 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 392 "page-view.c"
	}
#line 101 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = selected;
#line 101 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->selected = _tmp10_;
#line 102 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 400 "page-view.c"
}


gboolean page_view_get_selected (PageView* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 105 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 107 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->selected;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 107 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 415 "page-view.c"
}


void page_view_set_x_offset (PageView* self, gint offset) {
	gint _tmp0_;
#line 110 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = offset;
#line 112 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->x_offset = _tmp0_;
#line 427 "page-view.c"
}


void page_view_set_y_offset (PageView* self, gint offset) {
	gint _tmp0_;
#line 115 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 117 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = offset;
#line 117 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->y_offset = _tmp0_;
#line 439 "page-view.c"
}


gint page_view_get_x_offset (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 120 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->x_offset;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 122 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 454 "page-view.c"
}


gint page_view_get_y_offset (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 125 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 127 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->y_offset;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 127 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 469 "page-view.c"
}


static guchar page_view_get_sample (PageView* self, guchar* pixels, int pixels_length1, gint offset, gint x, gint depth, gint sample) {
	guchar result = '\0';
#line 130 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, '\0');
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = (guchar) 0xFF;
#line 133 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 481 "page-view.c"
}


static void page_view_get_pixel (PageView* self, Page* page, gint x, gint y, guchar* pixel, int pixel_length1) {
	Page* _tmp0_;
	ScanDirection _tmp1_ = 0;
	Page* _tmp18_;
	gint _tmp19_ = 0;
	gint depth;
	Page* _tmp20_;
	gint _tmp21_ = 0;
	gint n_channels;
	Page* _tmp22_;
	gint _tmp23_ = 0;
	guchar* _tmp24_ = NULL;
	guchar* pixels;
	gint pixels_length1;
	gint _pixels_size_;
	Page* _tmp25_;
	gint _tmp26_ = 0;
	gint _tmp27_;
	gint offset;
	gboolean _tmp28_ = FALSE;
	gint _tmp29_;
	gboolean _tmp31_;
	guchar* _tmp102_;
	gint _tmp102__length1;
	guchar* _tmp103_;
	gint _tmp103__length1;
	gint _tmp104_;
	gint _tmp105_;
	gint _tmp106_;
	gint _tmp107_;
	gint _tmp108_;
	guchar _tmp109_ = '\0';
	guchar _tmp110_;
	guchar* _tmp111_;
	gint _tmp111__length1;
	guchar* _tmp112_;
	gint _tmp112__length1;
	gint _tmp113_;
	gint _tmp114_;
	gint _tmp115_;
	gint _tmp116_;
	gint _tmp117_;
	guchar _tmp118_ = '\0';
	guchar _tmp119_;
	guchar* _tmp120_;
	gint _tmp120__length1;
	guchar* _tmp121_;
	gint _tmp121__length1;
	gint _tmp122_;
	gint _tmp123_;
	gint _tmp124_;
	gint _tmp125_;
	gint _tmp126_;
	guchar _tmp127_ = '\0';
	guchar _tmp128_;
#line 136 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 136 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = page;
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_get_scan_direction (_tmp0_);
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	switch (_tmp1_) {
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 552 "page-view.c"
		{
#line 141 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 556 "page-view.c"
		}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 560 "page-view.c"
		{
			Page* _tmp2_;
			gint _tmp3_ = 0;
			gint _tmp4_;
			Page* _tmp5_;
			gint _tmp6_ = 0;
			gint _tmp7_;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp2_ = page;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp3_ = page_get_scan_width (_tmp2_);
#line 143 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp4_ = x;
#line 143 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			x = (_tmp3_ - _tmp4_) - 1;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp5_ = page;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp6_ = page_get_scan_height (_tmp5_);
#line 144 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp7_ = y;
#line 144 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			y = (_tmp6_ - _tmp7_) - 1;
#line 145 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 586 "page-view.c"
		}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 590 "page-view.c"
		{
			gint _tmp8_;
			gint t;
			Page* _tmp9_;
			gint _tmp10_ = 0;
			gint _tmp11_;
			gint _tmp12_;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp8_ = x;
#line 147 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			t = _tmp8_;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp9_ = page;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp10_ = page_get_scan_width (_tmp9_);
#line 148 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp11_ = y;
#line 148 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			x = (_tmp10_ - _tmp11_) - 1;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp12_ = t;
#line 149 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			y = _tmp12_;
#line 150 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 616 "page-view.c"
		}
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 620 "page-view.c"
		{
			gint _tmp13_;
			gint t;
			gint _tmp14_;
			Page* _tmp15_;
			gint _tmp16_ = 0;
			gint _tmp17_;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp13_ = x;
#line 152 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			t = _tmp13_;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp14_ = y;
#line 153 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			x = _tmp14_;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp15_ = page;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp16_ = page_get_scan_height (_tmp15_);
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp17_ = t;
#line 154 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			y = (_tmp16_ - _tmp17_) - 1;
#line 155 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 646 "page-view.c"
		}
		default:
#line 138 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		break;
#line 651 "page-view.c"
	}
#line 158 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp18_ = page;
#line 158 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp19_ = page_get_depth (_tmp18_);
#line 158 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	depth = _tmp19_;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp20_ = page;
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp21_ = page_get_n_channels (_tmp20_);
#line 159 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	n_channels = _tmp21_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp22_ = page;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp24_ = page_get_pixels (_tmp22_, &_tmp23_);
#line 160 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	pixels = _tmp24_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	pixels_length1 = _tmp23_;
#line 160 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_pixels_size_ = pixels_length1;
#line 161 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp25_ = page;
#line 161 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp26_ = page_get_rowstride (_tmp25_);
#line 161 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp27_ = y;
#line 161 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	offset = _tmp26_ * _tmp27_;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp29_ = depth;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp29_ == 8) {
#line 687 "page-view.c"
		gint _tmp30_;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp30_ = n_channels;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp28_ = _tmp30_ == 3;
#line 693 "page-view.c"
	} else {
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp28_ = FALSE;
#line 697 "page-view.c"
	}
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp31_ = _tmp28_;
#line 164 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp31_) {
#line 703 "page-view.c"
		gint _tmp32_;
		gint _tmp33_;
		gint _tmp34_;
		gint o;
		guchar* _tmp35_;
		gint _tmp35__length1;
		guchar* _tmp36_;
		gint _tmp36__length1;
		gint _tmp37_;
		guchar _tmp38_;
		guchar _tmp39_;
		guchar* _tmp40_;
		gint _tmp40__length1;
		guchar* _tmp41_;
		gint _tmp41__length1;
		gint _tmp42_;
		guchar _tmp43_;
		guchar _tmp44_;
		guchar* _tmp45_;
		gint _tmp45__length1;
		guchar* _tmp46_;
		gint _tmp46__length1;
		gint _tmp47_;
		guchar _tmp48_;
		guchar _tmp49_;
#line 166 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp32_ = offset;
#line 166 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp33_ = x;
#line 166 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp34_ = n_channels;
#line 166 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		o = _tmp32_ + (_tmp33_ * _tmp34_);
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp35_ = pixel;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp35__length1 = pixel_length1;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp36_ = pixels;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp36__length1 = pixels_length1;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp37_ = o;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp38_ = _tmp36_[_tmp37_];
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp35_[0] = _tmp38_;
#line 167 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp39_ = _tmp35_[0];
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40_ = pixel;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40__length1 = pixel_length1;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp41_ = pixels;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp41__length1 = pixels_length1;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp42_ = o;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp43_ = _tmp41_[_tmp42_ + 1];
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40_[1] = _tmp43_;
#line 168 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp44_ = _tmp40_[1];
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp45_ = pixel;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp45__length1 = pixel_length1;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46_ = pixels;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46__length1 = pixels_length1;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp47_ = o;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp48_ = _tmp46_[_tmp47_ + 2];
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp45_[2] = _tmp48_;
#line 169 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp49_ = _tmp45_[2];
#line 170 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 787 "page-view.c"
	} else {
		gboolean _tmp50_ = FALSE;
		gint _tmp51_;
		gboolean _tmp53_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp51_ = depth;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp51_ == 8) {
#line 796 "page-view.c"
			gint _tmp52_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp52_ = n_channels;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp50_ = _tmp52_ == 1;
#line 802 "page-view.c"
		} else {
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp50_ = FALSE;
#line 806 "page-view.c"
		}
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp53_ = _tmp50_;
#line 172 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp53_) {
#line 812 "page-view.c"
			guchar* _tmp54_;
			gint _tmp54__length1;
			guchar* _tmp55_;
			gint _tmp55__length1;
			guchar* _tmp56_;
			gint _tmp56__length1;
			guchar* _tmp57_;
			gint _tmp57__length1;
			gint _tmp58_;
			gint _tmp59_;
			guchar _tmp60_;
			guchar _tmp61_;
			guchar _tmp62_;
			guchar _tmp63_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp54_ = pixel;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp54__length1 = pixel_length1;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp55_ = pixel;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp55__length1 = pixel_length1;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp56_ = pixel;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp56__length1 = pixel_length1;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp57_ = pixels;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp57__length1 = pixels_length1;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp58_ = offset;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp59_ = x;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp60_ = _tmp57_[_tmp58_ + _tmp59_];
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp56_[2] = _tmp60_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp61_ = _tmp56_[2];
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp55_[1] = _tmp61_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp62_ = _tmp55_[1];
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp54_[0] = _tmp62_;
#line 174 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp63_ = _tmp54_[0];
#line 175 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			return;
#line 863 "page-view.c"
		} else {
			gboolean _tmp64_ = FALSE;
			gint _tmp65_;
			gboolean _tmp67_;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp65_ = depth;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			if (_tmp65_ == 1) {
#line 872 "page-view.c"
				gint _tmp66_;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp66_ = n_channels;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp64_ = _tmp66_ == 1;
#line 878 "page-view.c"
			} else {
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp64_ = FALSE;
#line 882 "page-view.c"
			}
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp67_ = _tmp64_;
#line 179 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			if (_tmp67_) {
#line 888 "page-view.c"
				gint _tmp68_;
				gint _tmp69_;
				gint o;
				gint _tmp70_ = 0;
				guchar* _tmp71_;
				gint _tmp71__length1;
				gint _tmp72_;
				guchar _tmp73_;
				gint _tmp74_;
				guchar* _tmp75_;
				gint _tmp75__length1;
				guchar* _tmp76_;
				gint _tmp76__length1;
				guchar* _tmp77_;
				gint _tmp77__length1;
				gint _tmp78_;
				guchar _tmp79_;
				guchar _tmp80_;
				guchar _tmp81_;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp68_ = offset;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp69_ = x;
#line 181 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				o = _tmp68_ + (_tmp69_ / 8);
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp71_ = pixels;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp71__length1 = pixels_length1;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp72_ = o;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp73_ = _tmp71_[_tmp72_];
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp74_ = x;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (((gint) (_tmp73_ & (0x80 >> (_tmp74_ % 8)))) != 0) {
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp70_ = 0x00;
#line 928 "page-view.c"
				} else {
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp70_ = 0xFF;
#line 932 "page-view.c"
				}
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp75_ = pixel;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp75__length1 = pixel_length1;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp76_ = pixel;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp76__length1 = pixel_length1;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp77_ = pixel;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp77__length1 = pixel_length1;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp78_ = _tmp70_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp77_[2] = (guchar) _tmp78_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp79_ = _tmp77_[2];
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp76_[1] = _tmp79_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp80_ = _tmp76_[1];
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp75_[0] = _tmp80_;
#line 182 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp81_ = _tmp75_[0];
#line 183 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				return;
#line 962 "page-view.c"
			} else {
				gboolean _tmp82_ = FALSE;
				gint _tmp83_;
				gboolean _tmp85_;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp83_ = depth;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp83_ == 2) {
#line 971 "page-view.c"
					gint _tmp84_;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp84_ = n_channels;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp82_ = _tmp84_ == 1;
#line 977 "page-view.c"
				} else {
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp82_ = FALSE;
#line 981 "page-view.c"
				}
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp85_ = _tmp82_;
#line 187 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp85_) {
#line 987 "page-view.c"
					gint _tmp86_[4] = {0};
					gint block_shift[4];
					gint _tmp87_;
					gint _tmp88_;
					gint o;
					guchar* _tmp89_;
					gint _tmp89__length1;
					gint _tmp90_;
					guchar _tmp91_;
					gint _tmp92_;
					gint _tmp93_;
					gint sample;
					gint _tmp94_;
					guchar* _tmp95_;
					gint _tmp95__length1;
					guchar* _tmp96_;
					gint _tmp96__length1;
					guchar* _tmp97_;
					gint _tmp97__length1;
					gint _tmp98_;
					guchar _tmp99_;
					guchar _tmp100_;
					guchar _tmp101_;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp86_[0] = 6;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp86_[1] = 4;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp86_[2] = 2;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp86_[3] = 0;
#line 189 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					memcpy (block_shift, _tmp86_, 4 * sizeof (gint));
#line 191 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp87_ = offset;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp88_ = x;
#line 191 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					o = _tmp87_ + (_tmp88_ / 4);
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp89_ = pixels;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp89__length1 = pixels_length1;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp90_ = o;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp91_ = _tmp89_[_tmp90_];
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp92_ = x;
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp93_ = block_shift[_tmp92_ % 4];
#line 192 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					sample = (_tmp91_ >> _tmp93_) & 0x3;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp94_ = sample;
#line 193 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					sample = (_tmp94_ * 255) / 3;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp95_ = pixel;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp95__length1 = pixel_length1;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp96_ = pixel;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp96__length1 = pixel_length1;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp97_ = pixel;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp97__length1 = pixel_length1;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp98_ = sample;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp97_[2] = (guchar) _tmp98_;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp99_ = _tmp97_[2];
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp96_[1] = _tmp99_;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp100_ = _tmp96_[1];
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp95_[0] = _tmp100_;
#line 195 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp101_ = _tmp95_[0];
#line 196 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					return;
#line 1073 "page-view.c"
				}
			}
		}
	}
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp102_ = pixel;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp102__length1 = pixel_length1;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp103_ = pixels;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp103__length1 = pixels_length1;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp104_ = offset;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp105_ = x;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp106_ = depth;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp107_ = x;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp108_ = n_channels;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp109_ = page_view_get_sample (self, _tmp103_, _tmp103__length1, _tmp104_, _tmp105_, _tmp106_, _tmp107_ * _tmp108_);
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp102_[0] = _tmp109_;
#line 200 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp110_ = _tmp102_[0];
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp111_ = pixel;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp111__length1 = pixel_length1;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp112_ = pixels;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp112__length1 = pixels_length1;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp113_ = offset;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp114_ = x;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp115_ = depth;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp116_ = x;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp117_ = n_channels;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp118_ = page_view_get_sample (self, _tmp112_, _tmp112__length1, _tmp113_, _tmp114_, _tmp115_, (_tmp116_ * _tmp117_) + 1);
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp111_[1] = _tmp118_;
#line 201 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp119_ = _tmp111_[1];
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp120_ = pixel;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp120__length1 = pixel_length1;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp121_ = pixels;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp121__length1 = pixels_length1;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp122_ = offset;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp123_ = x;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp124_ = depth;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp125_ = x;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp126_ = n_channels;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp127_ = page_view_get_sample (self, _tmp121_, _tmp121__length1, _tmp122_, _tmp123_, _tmp124_, (_tmp125_ * _tmp126_) + 2);
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp120_[2] = _tmp127_;
#line 202 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp128_ = _tmp120_[2];
#line 1150 "page-view.c"
}


static void page_view_set_pixel (PageView* self, Page* page, gdouble l, gdouble r, gdouble t, gdouble b, guchar* output, int output_length1, gint offset) {
	gdouble _tmp0_;
	gint L;
	gint _tmp1_;
	gdouble _tmp2_;
	gdouble _tmp4_;
	gint R;
	gdouble _tmp5_;
	gint T;
	gint _tmp6_;
	gdouble _tmp7_;
	gdouble _tmp9_;
	gint B;
	gdouble red;
	gdouble green;
	gdouble blue;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gdouble _tmp12_;
	gdouble _tmp13_;
	gboolean _tmp16_;
	gboolean _tmp23_;
	gboolean _tmp293_ = FALSE;
	gdouble _tmp294_;
	gint _tmp295_;
	gboolean _tmp298_;
	gboolean _tmp320_ = FALSE;
	gdouble _tmp321_;
	gint _tmp322_;
	gboolean _tmp325_;
	gboolean _tmp347_ = FALSE;
	gdouble _tmp348_;
	gint _tmp349_;
	gboolean _tmp352_;
	gboolean _tmp374_ = FALSE;
	gdouble _tmp375_;
	gint _tmp376_;
	gboolean _tmp379_;
	gdouble _tmp401_;
	gdouble _tmp402_;
	gdouble _tmp403_;
	gdouble _tmp404_;
	gdouble scale;
	guchar* _tmp405_;
	gint _tmp405__length1;
	gint _tmp406_;
	gdouble _tmp407_;
	gdouble _tmp408_;
	guchar _tmp409_;
	guchar* _tmp410_;
	gint _tmp410__length1;
	gint _tmp411_;
	gdouble _tmp412_;
	gdouble _tmp413_;
	guchar _tmp414_;
	guchar* _tmp415_;
	gint _tmp415__length1;
	gint _tmp416_;
	gdouble _tmp417_;
	gdouble _tmp418_;
	guchar _tmp419_;
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 205 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 251 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = l;
#line 251 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	L = (gint) _tmp0_;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = L;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = l;
#line 252 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (((gdouble) _tmp1_) != _tmp2_) {
#line 1229 "page-view.c"
		gint _tmp3_;
#line 253 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp3_ = L;
#line 253 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		L = _tmp3_ + 1;
#line 1235 "page-view.c"
	}
#line 254 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = r;
#line 254 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	R = (gint) _tmp4_;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp5_ = t;
#line 255 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	T = (gint) _tmp5_;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = T;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = t;
#line 256 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (((gdouble) _tmp6_) != _tmp7_) {
#line 1251 "page-view.c"
		gint _tmp8_;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp8_ = T;
#line 257 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		T = _tmp8_ + 1;
#line 1257 "page-view.c"
	}
#line 258 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = b;
#line 258 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	B = (gint) _tmp9_;
#line 260 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	red = 0.0;
#line 261 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	green = 0.0;
#line 262 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	blue = 0.0;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = r;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp13_ = l;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if ((_tmp12_ - _tmp13_) <= 1.0) {
#line 1275 "page-view.c"
		gdouble _tmp14_;
		gdouble _tmp15_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp14_ = r;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp15_ = l;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp11_ = ((gint) _tmp14_) == ((gint) _tmp15_);
#line 1284 "page-view.c"
	} else {
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp11_ = FALSE;
#line 1288 "page-view.c"
	}
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp16_ = _tmp11_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp16_) {
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp10_ = TRUE;
#line 1296 "page-view.c"
	} else {
		gboolean _tmp17_ = FALSE;
		gdouble _tmp18_;
		gdouble _tmp19_;
		gboolean _tmp22_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp18_ = b;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp19_ = t;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if ((_tmp18_ - _tmp19_) <= 1.0) {
#line 1308 "page-view.c"
			gdouble _tmp20_;
			gdouble _tmp21_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp20_ = b;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp21_ = t;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp17_ = ((gint) _tmp20_) == ((gint) _tmp21_);
#line 1317 "page-view.c"
		} else {
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp17_ = FALSE;
#line 1321 "page-view.c"
		}
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp22_ = _tmp17_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp10_ = _tmp22_;
#line 1327 "page-view.c"
	}
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp23_ = _tmp10_;
#line 273 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp23_) {
#line 1333 "page-view.c"
		gboolean _tmp24_ = FALSE;
		gdouble _tmp25_;
		gdouble _tmp26_;
		gboolean _tmp29_;
		gint _tmp45_;
		gint _tmp46_;
		gdouble _tmp173_;
		gdouble _tmp174_;
		gdouble _tmp175_;
		gdouble _tmp176_;
		gdouble scale;
		guchar* _tmp177_;
		gint _tmp177__length1;
		gint _tmp178_;
		gdouble _tmp179_;
		gdouble _tmp180_;
		guchar _tmp181_;
		guchar* _tmp182_;
		gint _tmp182__length1;
		gint _tmp183_;
		gdouble _tmp184_;
		gdouble _tmp185_;
		guchar _tmp186_;
		guchar* _tmp187_;
		gint _tmp187__length1;
		gint _tmp188_;
		gdouble _tmp189_;
		gdouble _tmp190_;
		guchar _tmp191_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp25_ = l;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp26_ = r;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (((gint) _tmp25_) == ((gint) _tmp26_)) {
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp24_ = TRUE;
#line 1371 "page-view.c"
		} else {
			gdouble _tmp27_;
			gdouble _tmp28_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp27_ = t;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp28_ = b;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp24_ = ((gint) _tmp27_) == ((gint) _tmp28_);
#line 1381 "page-view.c"
		}
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp29_ = _tmp24_;
#line 276 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp29_) {
#line 1387 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp30_;
			gdouble _tmp31_;
			gdouble _tmp32_;
			guchar* _tmp33_;
			gint _tmp33__length1;
			gint _tmp34_;
			guchar _tmp35_;
			guchar _tmp36_;
			guchar* _tmp37_;
			gint _tmp37__length1;
			gint _tmp38_;
			guchar _tmp39_;
			guchar _tmp40_;
			guchar* _tmp41_;
			gint _tmp41__length1;
			gint _tmp42_;
			guchar _tmp43_;
			guchar _tmp44_;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp30_ = page;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp31_ = l;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp32_ = t;
#line 279 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			page_view_get_pixel (self, _tmp30_, (gint) _tmp31_, (gint) _tmp32_, p, 3);
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp33_ = output;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp33__length1 = output_length1;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp34_ = offset;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp35_ = p[0];
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp33_[_tmp34_] = _tmp35_;
#line 280 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp36_ = _tmp33_[_tmp34_];
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp37_ = output;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp37__length1 = output_length1;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp38_ = offset;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp39_ = p[1];
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp37_[_tmp38_ + 1] = _tmp39_;
#line 281 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp40_ = _tmp37_[_tmp38_ + 1];
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp41_ = output;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp41__length1 = output_length1;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp42_ = offset;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp43_ = p[2];
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp41_[_tmp42_ + 2] = _tmp43_;
#line 282 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp44_ = _tmp41_[_tmp42_ + 2];
#line 283 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			return;
#line 1453 "page-view.c"
		}
#line 287 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp45_ = L;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46_ = R;
#line 287 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp45_ > _tmp46_) {
#line 1461 "page-view.c"
			guchar p[3] = {0};
			Page* _tmp47_;
			gint _tmp48_;
			gint _tmp49_;
			gdouble _tmp50_;
			guchar _tmp51_;
			gdouble _tmp52_;
			gdouble _tmp53_;
			gint _tmp54_;
			gdouble _tmp55_;
			gdouble _tmp56_;
			guchar _tmp57_;
			gdouble _tmp58_;
			gdouble _tmp59_;
			gint _tmp60_;
			gdouble _tmp61_;
			gdouble _tmp62_;
			guchar _tmp63_;
			gdouble _tmp64_;
			gdouble _tmp65_;
			gint _tmp66_;
			gdouble _tmp67_;
			Page* _tmp89_;
			gint _tmp90_;
			gint _tmp91_;
			gdouble _tmp92_;
			guchar _tmp93_;
			gdouble _tmp94_;
			gdouble _tmp95_;
			gdouble _tmp96_;
			gint _tmp97_;
			gdouble _tmp98_;
			guchar _tmp99_;
			gdouble _tmp100_;
			gdouble _tmp101_;
			gdouble _tmp102_;
			gint _tmp103_;
			gdouble _tmp104_;
			guchar _tmp105_;
			gdouble _tmp106_;
			gdouble _tmp107_;
			gdouble _tmp108_;
			gint _tmp109_;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp47_ = page;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp48_ = R;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp49_ = T;
#line 290 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			page_view_get_pixel (self, _tmp47_, _tmp48_, _tmp49_ - 1, p, 3);
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp50_ = red;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp51_ = p[0];
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp52_ = r;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp53_ = l;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp54_ = T;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp55_ = t;
#line 291 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			red = _tmp50_ + ((_tmp51_ * (_tmp52_ - _tmp53_)) * (_tmp54_ - _tmp55_));
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp56_ = green;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp57_ = p[1];
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp58_ = r;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp59_ = l;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp60_ = T;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp61_ = t;
#line 292 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			green = _tmp56_ + ((_tmp57_ * (_tmp58_ - _tmp59_)) * (_tmp60_ - _tmp61_));
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp62_ = blue;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp63_ = p[2];
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp64_ = r;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp65_ = l;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp66_ = T;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp67_ = t;
#line 293 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			blue = _tmp62_ + ((_tmp63_ * (_tmp64_ - _tmp65_)) * (_tmp66_ - _tmp67_));
#line 1555 "page-view.c"
			{
				gint _tmp68_;
				gint y;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp68_ = T;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y = _tmp68_;
#line 1563 "page-view.c"
				{
					gboolean _tmp69_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp69_ = TRUE;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					while (TRUE) {
#line 1570 "page-view.c"
						gboolean _tmp70_;
						gint _tmp72_;
						gint _tmp73_;
						Page* _tmp74_;
						gint _tmp75_;
						gint _tmp76_;
						gdouble _tmp77_;
						guchar _tmp78_;
						gdouble _tmp79_;
						gdouble _tmp80_;
						gdouble _tmp81_;
						guchar _tmp82_;
						gdouble _tmp83_;
						gdouble _tmp84_;
						gdouble _tmp85_;
						guchar _tmp86_;
						gdouble _tmp87_;
						gdouble _tmp88_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp70_ = _tmp69_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						if (!_tmp70_) {
#line 1593 "page-view.c"
							gint _tmp71_;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp71_ = y;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							y = _tmp71_ + 1;
#line 1599 "page-view.c"
						}
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp69_ = FALSE;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp72_ = y;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp73_ = B;
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						if (!(_tmp72_ < _tmp73_)) {
#line 294 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							break;
#line 1611 "page-view.c"
						}
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp74_ = page;
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp75_ = R;
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp76_ = y;
#line 296 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						page_view_get_pixel (self, _tmp74_, _tmp75_, _tmp76_, p, 3);
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp77_ = red;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp78_ = p[0];
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp79_ = r;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp80_ = l;
#line 297 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						red = _tmp77_ + (_tmp78_ * (_tmp79_ - _tmp80_));
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp81_ = green;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp82_ = p[1];
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp83_ = r;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp84_ = l;
#line 298 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						green = _tmp81_ + (_tmp82_ * (_tmp83_ - _tmp84_));
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp85_ = blue;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp86_ = p[2];
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp87_ = r;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp88_ = l;
#line 299 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						blue = _tmp85_ + (_tmp86_ * (_tmp87_ - _tmp88_));
#line 1651 "page-view.c"
					}
				}
			}
#line 301 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp89_ = page;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp90_ = R;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp91_ = B;
#line 301 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			page_view_get_pixel (self, _tmp89_, _tmp90_, _tmp91_, p, 3);
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp92_ = red;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp93_ = p[0];
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp94_ = r;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp95_ = l;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp96_ = b;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp97_ = B;
#line 302 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			red = _tmp92_ + ((_tmp93_ * (_tmp94_ - _tmp95_)) * (_tmp96_ - _tmp97_));
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp98_ = green;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp99_ = p[1];
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp100_ = r;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp101_ = l;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp102_ = b;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp103_ = B;
#line 303 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			green = _tmp98_ + ((_tmp99_ * (_tmp100_ - _tmp101_)) * (_tmp102_ - _tmp103_));
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp104_ = blue;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp105_ = p[2];
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp106_ = r;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp107_ = l;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp108_ = b;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp109_ = B;
#line 304 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			blue = _tmp104_ + ((_tmp105_ * (_tmp106_ - _tmp107_)) * (_tmp108_ - _tmp109_));
#line 1705 "page-view.c"
		} else {
			guchar p[3] = {0};
			Page* _tmp110_;
			gint _tmp111_;
			gint _tmp112_;
			gdouble _tmp113_;
			guchar _tmp114_;
			gdouble _tmp115_;
			gdouble _tmp116_;
			gint _tmp117_;
			gdouble _tmp118_;
			gdouble _tmp119_;
			guchar _tmp120_;
			gdouble _tmp121_;
			gdouble _tmp122_;
			gint _tmp123_;
			gdouble _tmp124_;
			gdouble _tmp125_;
			guchar _tmp126_;
			gdouble _tmp127_;
			gdouble _tmp128_;
			gint _tmp129_;
			gdouble _tmp130_;
			Page* _tmp152_;
			gint _tmp153_;
			gint _tmp154_;
			gdouble _tmp155_;
			guchar _tmp156_;
			gdouble _tmp157_;
			gdouble _tmp158_;
			gdouble _tmp159_;
			gint _tmp160_;
			gdouble _tmp161_;
			guchar _tmp162_;
			gdouble _tmp163_;
			gdouble _tmp164_;
			gdouble _tmp165_;
			gint _tmp166_;
			gdouble _tmp167_;
			guchar _tmp168_;
			gdouble _tmp169_;
			gdouble _tmp170_;
			gdouble _tmp171_;
			gint _tmp172_;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp110_ = page;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp111_ = L;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp112_ = B;
#line 310 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			page_view_get_pixel (self, _tmp110_, _tmp111_ - 1, _tmp112_, p, 3);
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp113_ = red;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp114_ = p[0];
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp115_ = b;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp116_ = t;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp117_ = L;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp118_ = l;
#line 311 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			red = _tmp113_ + ((_tmp114_ * (_tmp115_ - _tmp116_)) * (_tmp117_ - _tmp118_));
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp119_ = green;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp120_ = p[1];
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp121_ = b;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp122_ = t;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp123_ = L;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp124_ = l;
#line 312 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			green = _tmp119_ + ((_tmp120_ * (_tmp121_ - _tmp122_)) * (_tmp123_ - _tmp124_));
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp125_ = blue;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp126_ = p[2];
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp127_ = b;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp128_ = t;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp129_ = L;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp130_ = l;
#line 313 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			blue = _tmp125_ + ((_tmp126_ * (_tmp127_ - _tmp128_)) * (_tmp129_ - _tmp130_));
#line 1800 "page-view.c"
			{
				gint _tmp131_;
				gint x;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp131_ = L;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x = _tmp131_;
#line 1808 "page-view.c"
				{
					gboolean _tmp132_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp132_ = TRUE;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					while (TRUE) {
#line 1815 "page-view.c"
						gboolean _tmp133_;
						gint _tmp135_;
						gint _tmp136_;
						Page* _tmp137_;
						gint _tmp138_;
						gint _tmp139_;
						gdouble _tmp140_;
						guchar _tmp141_;
						gdouble _tmp142_;
						gdouble _tmp143_;
						gdouble _tmp144_;
						guchar _tmp145_;
						gdouble _tmp146_;
						gdouble _tmp147_;
						gdouble _tmp148_;
						guchar _tmp149_;
						gdouble _tmp150_;
						gdouble _tmp151_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp133_ = _tmp132_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						if (!_tmp133_) {
#line 1838 "page-view.c"
							gint _tmp134_;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp134_ = x;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							x = _tmp134_ + 1;
#line 1844 "page-view.c"
						}
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp132_ = FALSE;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp135_ = x;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp136_ = R;
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						if (!(_tmp135_ < _tmp136_)) {
#line 314 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							break;
#line 1856 "page-view.c"
						}
#line 315 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp137_ = page;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp138_ = x;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp139_ = B;
#line 315 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						page_view_get_pixel (self, _tmp137_, _tmp138_, _tmp139_, p, 3);
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp140_ = red;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp141_ = p[0];
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp142_ = b;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp143_ = t;
#line 316 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						red = _tmp140_ + (_tmp141_ * (_tmp142_ - _tmp143_));
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp144_ = green;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp145_ = p[1];
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp146_ = b;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp147_ = t;
#line 317 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						green = _tmp144_ + (_tmp145_ * (_tmp146_ - _tmp147_));
#line 318 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp148_ = blue;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp149_ = p[2];
#line 318 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp150_ = b;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp151_ = t;
#line 318 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						blue = _tmp148_ + (_tmp149_ * (_tmp150_ - _tmp151_));
#line 1896 "page-view.c"
					}
				}
			}
#line 320 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp152_ = page;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp153_ = R;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp154_ = B;
#line 320 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			page_view_get_pixel (self, _tmp152_, _tmp153_, _tmp154_, p, 3);
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp155_ = red;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp156_ = p[0];
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp157_ = b;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp158_ = t;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp159_ = r;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp160_ = R;
#line 321 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			red = _tmp155_ + ((_tmp156_ * (_tmp157_ - _tmp158_)) * (_tmp159_ - _tmp160_));
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp161_ = green;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp162_ = p[1];
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp163_ = b;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp164_ = t;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp165_ = r;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp166_ = R;
#line 322 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			green = _tmp161_ + ((_tmp162_ * (_tmp163_ - _tmp164_)) * (_tmp165_ - _tmp166_));
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp167_ = blue;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp168_ = p[2];
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp169_ = b;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp170_ = t;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp171_ = r;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp172_ = R;
#line 323 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			blue = _tmp167_ + ((_tmp168_ * (_tmp169_ - _tmp170_)) * (_tmp171_ - _tmp172_));
#line 1950 "page-view.c"
		}
#line 326 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp173_ = r;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp174_ = l;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp175_ = b;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp176_ = t;
#line 326 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		scale = 1.0 / ((_tmp173_ - _tmp174_) * (_tmp175_ - _tmp176_));
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp177_ = output;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp177__length1 = output_length1;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp178_ = offset;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp179_ = red;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp180_ = scale;
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp177_[_tmp178_] = (guchar) ((_tmp179_ * _tmp180_) + 0.5);
#line 327 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp181_ = _tmp177_[_tmp178_];
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp182_ = output;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp182__length1 = output_length1;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp183_ = offset;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp184_ = green;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp185_ = scale;
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp182_[_tmp183_ + 1] = (guchar) ((_tmp184_ * _tmp185_) + 0.5);
#line 328 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp186_ = _tmp182_[_tmp183_ + 1];
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp187_ = output;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp187__length1 = output_length1;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp188_ = offset;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp189_ = blue;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp190_ = scale;
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp187_[_tmp188_ + 2] = (guchar) ((_tmp189_ * _tmp190_) + 0.5);
#line 329 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp191_ = _tmp187_[_tmp188_ + 2];
#line 330 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 2006 "page-view.c"
	}
	{
		gint _tmp192_;
		gint x;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp192_ = L;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		x = _tmp192_;
#line 2015 "page-view.c"
		{
			gboolean _tmp193_;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp193_ = TRUE;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			while (TRUE) {
#line 2022 "page-view.c"
				gboolean _tmp194_;
				gint _tmp196_;
				gint _tmp197_;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp194_ = _tmp193_;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!_tmp194_) {
#line 2030 "page-view.c"
					gint _tmp195_;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp195_ = x;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					x = _tmp195_ + 1;
#line 2036 "page-view.c"
				}
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp193_ = FALSE;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp196_ = x;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp197_ = R;
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!(_tmp196_ < _tmp197_)) {
#line 334 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					break;
#line 2048 "page-view.c"
				}
				{
					gint _tmp198_;
					gint y;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp198_ = T;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					y = _tmp198_;
#line 2057 "page-view.c"
					{
						gboolean _tmp199_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp199_ = TRUE;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						while (TRUE) {
#line 2064 "page-view.c"
							gboolean _tmp200_;
							gint _tmp202_;
							gint _tmp203_;
							guchar p[3] = {0};
							Page* _tmp204_;
							gint _tmp205_;
							gint _tmp206_;
							gdouble _tmp207_;
							guchar _tmp208_;
							gdouble _tmp209_;
							guchar _tmp210_;
							gdouble _tmp211_;
							guchar _tmp212_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp200_ = _tmp199_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							if (!_tmp200_) {
#line 2082 "page-view.c"
								gint _tmp201_;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp201_ = y;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								y = _tmp201_ + 1;
#line 2088 "page-view.c"
							}
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp199_ = FALSE;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp202_ = y;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp203_ = B;
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							if (!(_tmp202_ < _tmp203_)) {
#line 336 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								break;
#line 2100 "page-view.c"
							}
#line 339 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp204_ = page;
#line 339 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp205_ = x;
#line 339 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp206_ = y;
#line 339 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							page_view_get_pixel (self, _tmp204_, _tmp205_, _tmp206_, p, 3);
#line 340 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp207_ = red;
#line 340 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp208_ = p[0];
#line 340 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							red = _tmp207_ + _tmp208_;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp209_ = green;
#line 341 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp210_ = p[1];
#line 341 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							green = _tmp209_ + _tmp210_;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp211_ = blue;
#line 342 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp212_ = p[2];
#line 342 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							blue = _tmp211_ + _tmp212_;
#line 2128 "page-view.c"
						}
					}
				}
			}
		}
	}
	{
		gint _tmp213_;
		gint x;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp213_ = L;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		x = _tmp213_;
#line 2142 "page-view.c"
		{
			gboolean _tmp214_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp214_ = TRUE;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			while (TRUE) {
#line 2149 "page-view.c"
				gboolean _tmp215_;
				gint _tmp217_;
				gint _tmp218_;
				gdouble _tmp219_;
				gint _tmp220_;
				gdouble _tmp236_;
				gint _tmp237_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp215_ = _tmp214_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!_tmp215_) {
#line 2161 "page-view.c"
					gint _tmp216_;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp216_ = x;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					x = _tmp216_ + 1;
#line 2167 "page-view.c"
				}
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp214_ = FALSE;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp217_ = x;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp218_ = R;
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!(_tmp217_ < _tmp218_)) {
#line 347 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					break;
#line 2179 "page-view.c"
				}
#line 349 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp219_ = t;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp220_ = T;
#line 349 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp219_ != ((gdouble) _tmp220_)) {
#line 2187 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp221_;
					gint _tmp222_;
					gint _tmp223_;
					gdouble _tmp224_;
					guchar _tmp225_;
					gint _tmp226_;
					gdouble _tmp227_;
					gdouble _tmp228_;
					guchar _tmp229_;
					gint _tmp230_;
					gdouble _tmp231_;
					gdouble _tmp232_;
					guchar _tmp233_;
					gint _tmp234_;
					gdouble _tmp235_;
#line 352 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp221_ = page;
#line 352 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp222_ = x;
#line 352 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp223_ = T;
#line 352 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					page_view_get_pixel (self, _tmp221_, _tmp222_, _tmp223_ - 1, p, 3);
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp224_ = red;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp225_ = p[0];
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp226_ = T;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp227_ = t;
#line 353 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					red = _tmp224_ + (_tmp225_ * (_tmp226_ - _tmp227_));
#line 354 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp228_ = green;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp229_ = p[1];
#line 354 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp230_ = T;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp231_ = t;
#line 354 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					green = _tmp228_ + (_tmp229_ * (_tmp230_ - _tmp231_));
#line 355 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp232_ = blue;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp233_ = p[2];
#line 355 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp234_ = T;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp235_ = t;
#line 355 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					blue = _tmp232_ + (_tmp233_ * (_tmp234_ - _tmp235_));
#line 2242 "page-view.c"
				}
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp236_ = b;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp237_ = B;
#line 358 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp236_ != ((gdouble) _tmp237_)) {
#line 2250 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp238_;
					gint _tmp239_;
					gint _tmp240_;
					gdouble _tmp241_;
					guchar _tmp242_;
					gdouble _tmp243_;
					gint _tmp244_;
					gdouble _tmp245_;
					guchar _tmp246_;
					gdouble _tmp247_;
					gint _tmp248_;
					gdouble _tmp249_;
					guchar _tmp250_;
					gdouble _tmp251_;
					gint _tmp252_;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp238_ = page;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp239_ = x;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp240_ = B;
#line 361 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					page_view_get_pixel (self, _tmp238_, _tmp239_, _tmp240_, p, 3);
#line 362 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp241_ = red;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp242_ = p[0];
#line 362 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp243_ = b;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp244_ = B;
#line 362 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					red = _tmp241_ + (_tmp242_ * (_tmp243_ - _tmp244_));
#line 363 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp245_ = green;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp246_ = p[1];
#line 363 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp247_ = b;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp248_ = B;
#line 363 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					green = _tmp245_ + (_tmp246_ * (_tmp247_ - _tmp248_));
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp249_ = blue;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp250_ = p[2];
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp251_ = b;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp252_ = B;
#line 364 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					blue = _tmp249_ + (_tmp250_ * (_tmp251_ - _tmp252_));
#line 2305 "page-view.c"
				}
			}
		}
	}
	{
		gint _tmp253_;
		gint y;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp253_ = T;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		y = _tmp253_;
#line 2317 "page-view.c"
		{
			gboolean _tmp254_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp254_ = TRUE;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			while (TRUE) {
#line 2324 "page-view.c"
				gboolean _tmp255_;
				gint _tmp257_;
				gint _tmp258_;
				gdouble _tmp259_;
				gint _tmp260_;
				gdouble _tmp276_;
				gint _tmp277_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp255_ = _tmp254_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!_tmp255_) {
#line 2336 "page-view.c"
					gint _tmp256_;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp256_ = y;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					y = _tmp256_ + 1;
#line 2342 "page-view.c"
				}
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp254_ = FALSE;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp257_ = y;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp258_ = B;
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!(_tmp257_ < _tmp258_)) {
#line 369 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					break;
#line 2354 "page-view.c"
				}
#line 371 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp259_ = l;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp260_ = L;
#line 371 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp259_ != ((gdouble) _tmp260_)) {
#line 2362 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp261_;
					gint _tmp262_;
					gint _tmp263_;
					gdouble _tmp264_;
					guchar _tmp265_;
					gint _tmp266_;
					gdouble _tmp267_;
					gdouble _tmp268_;
					guchar _tmp269_;
					gint _tmp270_;
					gdouble _tmp271_;
					gdouble _tmp272_;
					guchar _tmp273_;
					gint _tmp274_;
					gdouble _tmp275_;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp261_ = page;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp262_ = L;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp263_ = y;
#line 374 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					page_view_get_pixel (self, _tmp261_, _tmp262_ - 1, _tmp263_, p, 3);
#line 375 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp264_ = red;
#line 375 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp265_ = p[0];
#line 375 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp266_ = L;
#line 375 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp267_ = l;
#line 375 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					red = _tmp264_ + (_tmp265_ * (_tmp266_ - _tmp267_));
#line 376 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp268_ = green;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp269_ = p[1];
#line 376 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp270_ = L;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp271_ = l;
#line 376 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					green = _tmp268_ + (_tmp269_ * (_tmp270_ - _tmp271_));
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp272_ = blue;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp273_ = p[2];
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp274_ = L;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp275_ = l;
#line 377 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					blue = _tmp272_ + (_tmp273_ * (_tmp274_ - _tmp275_));
#line 2417 "page-view.c"
				}
#line 380 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp276_ = r;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp277_ = R;
#line 380 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (_tmp276_ != ((gdouble) _tmp277_)) {
#line 2425 "page-view.c"
					guchar p[3] = {0};
					Page* _tmp278_;
					gint _tmp279_;
					gint _tmp280_;
					gdouble _tmp281_;
					guchar _tmp282_;
					gdouble _tmp283_;
					gint _tmp284_;
					gdouble _tmp285_;
					guchar _tmp286_;
					gdouble _tmp287_;
					gint _tmp288_;
					gdouble _tmp289_;
					guchar _tmp290_;
					gdouble _tmp291_;
					gint _tmp292_;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp278_ = page;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp279_ = R;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp280_ = y;
#line 383 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					page_view_get_pixel (self, _tmp278_, _tmp279_, _tmp280_, p, 3);
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp281_ = red;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp282_ = p[0];
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp283_ = r;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp284_ = R;
#line 384 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					red = _tmp281_ + (_tmp282_ * (_tmp283_ - _tmp284_));
#line 385 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp285_ = green;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp286_ = p[1];
#line 385 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp287_ = r;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp288_ = R;
#line 385 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					green = _tmp285_ + (_tmp286_ * (_tmp287_ - _tmp288_));
#line 386 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp289_ = blue;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp290_ = p[2];
#line 386 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp291_ = r;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp292_ = R;
#line 386 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					blue = _tmp289_ + (_tmp290_ * (_tmp291_ - _tmp292_));
#line 2480 "page-view.c"
				}
			}
		}
	}
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp294_ = l;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp295_ = L;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp294_ != ((gdouble) _tmp295_)) {
#line 2491 "page-view.c"
		gdouble _tmp296_;
		gint _tmp297_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp296_ = t;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp297_ = T;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp293_ = _tmp296_ != ((gdouble) _tmp297_);
#line 2500 "page-view.c"
	} else {
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp293_ = FALSE;
#line 2504 "page-view.c"
	}
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp298_ = _tmp293_;
#line 391 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp298_) {
#line 2510 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp299_;
		gint _tmp300_;
		gint _tmp301_;
		gdouble _tmp302_;
		guchar _tmp303_;
		gint _tmp304_;
		gdouble _tmp305_;
		gint _tmp306_;
		gdouble _tmp307_;
		gdouble _tmp308_;
		guchar _tmp309_;
		gint _tmp310_;
		gdouble _tmp311_;
		gint _tmp312_;
		gdouble _tmp313_;
		gdouble _tmp314_;
		guchar _tmp315_;
		gint _tmp316_;
		gdouble _tmp317_;
		gint _tmp318_;
		gdouble _tmp319_;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp299_ = page;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp300_ = L;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp301_ = T;
#line 394 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_get_pixel (self, _tmp299_, _tmp300_ - 1, _tmp301_ - 1, p, 3);
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp302_ = red;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp303_ = p[0];
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp304_ = L;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp305_ = l;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp306_ = T;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp307_ = t;
#line 395 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		red = _tmp302_ + ((_tmp303_ * (_tmp304_ - _tmp305_)) * (_tmp306_ - _tmp307_));
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp308_ = green;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp309_ = p[1];
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp310_ = L;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp311_ = l;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp312_ = T;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp313_ = t;
#line 396 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		green = _tmp308_ + ((_tmp309_ * (_tmp310_ - _tmp311_)) * (_tmp312_ - _tmp313_));
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp314_ = blue;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp315_ = p[2];
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp316_ = L;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp317_ = l;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp318_ = T;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp319_ = t;
#line 397 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		blue = _tmp314_ + ((_tmp315_ * (_tmp316_ - _tmp317_)) * (_tmp318_ - _tmp319_));
#line 2583 "page-view.c"
	}
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp321_ = r;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp322_ = R;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp321_ != ((gdouble) _tmp322_)) {
#line 2591 "page-view.c"
		gdouble _tmp323_;
		gint _tmp324_;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp323_ = t;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp324_ = T;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp320_ = _tmp323_ != ((gdouble) _tmp324_);
#line 2600 "page-view.c"
	} else {
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp320_ = FALSE;
#line 2604 "page-view.c"
	}
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp325_ = _tmp320_;
#line 399 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp325_) {
#line 2610 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp326_;
		gint _tmp327_;
		gint _tmp328_;
		gdouble _tmp329_;
		guchar _tmp330_;
		gdouble _tmp331_;
		gint _tmp332_;
		gint _tmp333_;
		gdouble _tmp334_;
		gdouble _tmp335_;
		guchar _tmp336_;
		gdouble _tmp337_;
		gint _tmp338_;
		gint _tmp339_;
		gdouble _tmp340_;
		gdouble _tmp341_;
		guchar _tmp342_;
		gdouble _tmp343_;
		gint _tmp344_;
		gint _tmp345_;
		gdouble _tmp346_;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp326_ = page;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp327_ = R;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp328_ = T;
#line 402 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_get_pixel (self, _tmp326_, _tmp327_, _tmp328_ - 1, p, 3);
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp329_ = red;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp330_ = p[0];
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp331_ = r;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp332_ = R;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp333_ = T;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp334_ = t;
#line 403 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		red = _tmp329_ + ((_tmp330_ * (_tmp331_ - _tmp332_)) * (_tmp333_ - _tmp334_));
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp335_ = green;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp336_ = p[1];
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp337_ = r;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp338_ = R;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp339_ = T;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp340_ = t;
#line 404 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		green = _tmp335_ + ((_tmp336_ * (_tmp337_ - _tmp338_)) * (_tmp339_ - _tmp340_));
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp341_ = blue;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp342_ = p[2];
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp343_ = r;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp344_ = R;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp345_ = T;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp346_ = t;
#line 405 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		blue = _tmp341_ + ((_tmp342_ * (_tmp343_ - _tmp344_)) * (_tmp345_ - _tmp346_));
#line 2683 "page-view.c"
	}
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp348_ = r;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp349_ = R;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp348_ != ((gdouble) _tmp349_)) {
#line 2691 "page-view.c"
		gdouble _tmp350_;
		gint _tmp351_;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp350_ = b;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp351_ = B;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp347_ = _tmp350_ != ((gdouble) _tmp351_);
#line 2700 "page-view.c"
	} else {
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp347_ = FALSE;
#line 2704 "page-view.c"
	}
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp352_ = _tmp347_;
#line 407 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp352_) {
#line 2710 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp353_;
		gint _tmp354_;
		gint _tmp355_;
		gdouble _tmp356_;
		guchar _tmp357_;
		gdouble _tmp358_;
		gint _tmp359_;
		gdouble _tmp360_;
		gint _tmp361_;
		gdouble _tmp362_;
		guchar _tmp363_;
		gdouble _tmp364_;
		gint _tmp365_;
		gdouble _tmp366_;
		gint _tmp367_;
		gdouble _tmp368_;
		guchar _tmp369_;
		gdouble _tmp370_;
		gint _tmp371_;
		gdouble _tmp372_;
		gint _tmp373_;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp353_ = page;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp354_ = R;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp355_ = B;
#line 410 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_get_pixel (self, _tmp353_, _tmp354_, _tmp355_, p, 3);
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp356_ = red;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp357_ = p[0];
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp358_ = r;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp359_ = R;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp360_ = b;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp361_ = B;
#line 411 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		red = _tmp356_ + ((_tmp357_ * (_tmp358_ - _tmp359_)) * (_tmp360_ - _tmp361_));
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp362_ = green;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp363_ = p[1];
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp364_ = r;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp365_ = R;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp366_ = b;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp367_ = B;
#line 412 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		green = _tmp362_ + ((_tmp363_ * (_tmp364_ - _tmp365_)) * (_tmp366_ - _tmp367_));
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp368_ = blue;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp369_ = p[2];
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp370_ = r;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp371_ = R;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp372_ = b;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp373_ = B;
#line 413 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		blue = _tmp368_ + ((_tmp369_ * (_tmp370_ - _tmp371_)) * (_tmp372_ - _tmp373_));
#line 2783 "page-view.c"
	}
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp375_ = l;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp376_ = L;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp375_ != ((gdouble) _tmp376_)) {
#line 2791 "page-view.c"
		gdouble _tmp377_;
		gint _tmp378_;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp377_ = b;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp378_ = B;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp374_ = _tmp377_ != ((gdouble) _tmp378_);
#line 2800 "page-view.c"
	} else {
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp374_ = FALSE;
#line 2804 "page-view.c"
	}
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp379_ = _tmp374_;
#line 415 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp379_) {
#line 2810 "page-view.c"
		guchar p[3] = {0};
		Page* _tmp380_;
		gint _tmp381_;
		gint _tmp382_;
		gdouble _tmp383_;
		guchar _tmp384_;
		gint _tmp385_;
		gdouble _tmp386_;
		gdouble _tmp387_;
		gint _tmp388_;
		gdouble _tmp389_;
		guchar _tmp390_;
		gint _tmp391_;
		gdouble _tmp392_;
		gdouble _tmp393_;
		gint _tmp394_;
		gdouble _tmp395_;
		guchar _tmp396_;
		gint _tmp397_;
		gdouble _tmp398_;
		gdouble _tmp399_;
		gint _tmp400_;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp380_ = page;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp381_ = L;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp382_ = B;
#line 418 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_get_pixel (self, _tmp380_, _tmp381_ - 1, _tmp382_, p, 3);
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp383_ = red;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp384_ = p[0];
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp385_ = L;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp386_ = l;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp387_ = b;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp388_ = B;
#line 419 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		red = _tmp383_ + ((_tmp384_ * (_tmp385_ - _tmp386_)) * (_tmp387_ - _tmp388_));
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp389_ = green;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp390_ = p[1];
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp391_ = L;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp392_ = l;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp393_ = b;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp394_ = B;
#line 420 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		green = _tmp389_ + ((_tmp390_ * (_tmp391_ - _tmp392_)) * (_tmp393_ - _tmp394_));
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp395_ = blue;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp396_ = p[2];
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp397_ = L;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp398_ = l;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp399_ = b;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp400_ = B;
#line 421 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		blue = _tmp395_ + ((_tmp396_ * (_tmp397_ - _tmp398_)) * (_tmp399_ - _tmp400_));
#line 2883 "page-view.c"
	}
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp401_ = r;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp402_ = l;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp403_ = b;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp404_ = t;
#line 425 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	scale = 1.0 / ((_tmp401_ - _tmp402_) * (_tmp403_ - _tmp404_));
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp405_ = output;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp405__length1 = output_length1;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp406_ = offset;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp407_ = red;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp408_ = scale;
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp405_[_tmp406_] = (guchar) ((_tmp407_ * _tmp408_) + 0.5);
#line 426 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp409_ = _tmp405_[_tmp406_];
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp410_ = output;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp410__length1 = output_length1;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp411_ = offset;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp412_ = green;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp413_ = scale;
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp410_[_tmp411_ + 1] = (guchar) ((_tmp412_ * _tmp413_) + 0.5);
#line 427 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp414_ = _tmp410_[_tmp411_ + 1];
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp415_ = output;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp415__length1 = output_length1;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp416_ = offset;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp417_ = blue;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp418_ = scale;
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp415_[_tmp416_ + 2] = (guchar) ((_tmp417_ * _tmp418_) + 0.5);
#line 428 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp419_ = _tmp415_[_tmp416_ + 2];
#line 2937 "page-view.c"
}


static void page_view_update_preview (PageView* self, Page* page, GdkPixbuf** output_image, gint output_width, gint output_height, ScanDirection scan_direction, gint old_scan_line, gint scan_line) {
	Page* _tmp0_;
	gint _tmp1_ = 0;
	gint input_width;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	gint input_height;
	gint L = 0;
	gint R = 0;
	gint T = 0;
	gint B = 0;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	GdkPixbuf* _tmp6_;
	gboolean _tmp10_;
	gboolean _tmp14_;
	gint _tmp56_;
	gint _tmp57_;
	gint _tmp59_;
	gint _tmp60_;
	gint _tmp62_;
	gint _tmp63_;
	gint _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	gint _tmp67_;
	GdkPixbuf* _tmp68_;
	GdkPixbuf* _tmp69_;
	guint8* _tmp70_ = NULL;
	guchar* output;
	gint output_length1;
	gint _output_size_;
	GdkPixbuf* _tmp71_;
	gint _tmp72_ = 0;
	gint output_rowstride;
	GdkPixbuf* _tmp73_;
	gint _tmp74_ = 0;
	gint output_n_channels;
	Page* _tmp75_;
	gboolean _tmp76_ = FALSE;
#line 431 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 431 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (page != NULL);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = page;
#line 434 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_get_width (_tmp0_);
#line 434 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	input_width = _tmp1_;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page;
#line 435 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 435 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	input_height = _tmp3_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = *output_image;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp6_ == NULL) {
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = TRUE;
#line 3003 "page-view.c"
	} else {
		GdkPixbuf* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp7_ = *output_image;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp8_ = gdk_pixbuf_get_width (_tmp7_);
#line 440 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp9_ = output_width;
#line 440 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = _tmp8_ != _tmp9_;
#line 3016 "page-view.c"
	}
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = _tmp5_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp10_) {
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp4_ = TRUE;
#line 3024 "page-view.c"
	} else {
		GdkPixbuf* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp11_ = *output_image;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp12_ = gdk_pixbuf_get_height (_tmp11_);
#line 441 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp13_ = output_height;
#line 441 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp4_ = _tmp12_ != _tmp13_;
#line 3037 "page-view.c"
	}
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp14_ = _tmp4_;
#line 439 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp14_) {
#line 3043 "page-view.c"
		gint _tmp15_;
		gint _tmp16_;
		GdkPixbuf* _tmp17_;
		gint _tmp18_;
		gint _tmp19_;
#line 443 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp15_ = output_width;
#line 443 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp16_ = output_height;
#line 443 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp17_ = gdk_pixbuf_new (GDK_COLORSPACE_RGB, FALSE, 8, _tmp15_, _tmp16_);
#line 443 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_object_unref0 (*output_image);
#line 443 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		*output_image = _tmp17_;
#line 450 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		L = 0;
#line 451 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp18_ = output_width;
#line 451 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		R = _tmp18_ - 1;
#line 452 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		T = 0;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp19_ = output_height;
#line 453 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		B = _tmp19_ - 1;
#line 3071 "page-view.c"
	} else {
		ScanDirection _tmp20_;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp20_ = scan_direction;
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		switch (_tmp20_) {
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 3080 "page-view.c"
			{
				gint _tmp21_;
				gint _tmp22_;
				gint _tmp23_;
				gint _tmp24_;
				gint _tmp25_;
				gint _tmp26_;
				gint _tmp27_;
#line 461 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				L = 0;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp21_ = output_width;
#line 462 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				R = _tmp21_ - 1;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp22_ = old_scan_line;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp23_ = output_height;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp24_ = input_height;
#line 463 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				T = (gint) ((((gdouble) _tmp22_) * _tmp23_) / _tmp24_);
#line 464 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp25_ = scan_line;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp26_ = output_height;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp27_ = input_height;
#line 464 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				B = (gint) (((((gdouble) _tmp25_) * _tmp26_) / _tmp27_) + 0.5);
#line 465 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 3113 "page-view.c"
			}
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 3117 "page-view.c"
			{
				gint _tmp28_;
				gint _tmp29_;
				gint _tmp30_;
				gint _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _tmp34_;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp28_ = old_scan_line;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp29_ = output_width;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp30_ = input_width;
#line 467 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				L = (gint) ((((gdouble) _tmp28_) * _tmp29_) / _tmp30_);
#line 468 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp31_ = scan_line;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp32_ = output_width;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp33_ = input_width;
#line 468 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				R = (gint) (((((gdouble) _tmp31_) * _tmp32_) / _tmp33_) + 0.5);
#line 469 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				T = 0;
#line 470 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp34_ = output_height;
#line 470 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				B = _tmp34_ - 1;
#line 471 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 3150 "page-view.c"
			}
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 3154 "page-view.c"
			{
				gint _tmp35_;
				gint _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gint _tmp39_;
				gint _tmp40_;
				gint _tmp41_;
				gint _tmp42_;
				gint _tmp43_;
#line 473 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				L = 0;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp35_ = output_width;
#line 474 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				R = _tmp35_ - 1;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp36_ = input_height;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp37_ = scan_line;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp38_ = output_height;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp39_ = input_height;
#line 475 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				T = (gint) ((((gdouble) (_tmp36_ - _tmp37_)) * _tmp38_) / _tmp39_);
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp40_ = input_height;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp41_ = old_scan_line;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp42_ = output_height;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp43_ = input_height;
#line 476 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				B = (gint) (((((gdouble) (_tmp40_ - _tmp41_)) * _tmp42_) / _tmp43_) + 0.5);
#line 477 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 3193 "page-view.c"
			}
#line 458 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 3197 "page-view.c"
			{
				gint _tmp44_;
				gint _tmp45_;
				gint _tmp46_;
				gint _tmp47_;
				gint _tmp48_;
				gint _tmp49_;
				gint _tmp50_;
				gint _tmp51_;
				gint _tmp52_;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp44_ = input_width;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp45_ = scan_line;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp46_ = output_width;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp47_ = input_width;
#line 479 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				L = (gint) ((((gdouble) (_tmp44_ - _tmp45_)) * _tmp46_) / _tmp47_);
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp48_ = input_width;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp49_ = old_scan_line;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp50_ = output_width;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp51_ = input_width;
#line 480 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				R = (gint) (((((gdouble) (_tmp48_ - _tmp49_)) * _tmp50_) / _tmp51_) + 0.5);
#line 481 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				T = 0;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp52_ = output_height;
#line 482 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				B = _tmp52_ - 1;
#line 483 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 3236 "page-view.c"
			}
			default:
			{
				gint _tmp53_;
				gint _tmp54_;
				gint _tmp55_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				T = 0;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp53_ = T;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				B = _tmp53_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp54_ = B;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				R = _tmp54_;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp55_ = R;
#line 485 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				L = _tmp55_;
#line 486 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 3259 "page-view.c"
			}
		}
	}
#line 491 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp56_ = R;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp57_ = output_width;
#line 491 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp56_ >= _tmp57_) {
#line 3269 "page-view.c"
		gint _tmp58_;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp58_ = output_width;
#line 492 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		R = _tmp58_ - 1;
#line 3275 "page-view.c"
	}
#line 493 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp59_ = B;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp60_ = output_height;
#line 493 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp59_ >= _tmp60_) {
#line 3283 "page-view.c"
		gint _tmp61_;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp61_ = output_height;
#line 494 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		B = _tmp61_ - 1;
#line 3289 "page-view.c"
	}
#line 496 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp62_ = L;
#line 496 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (_tmp62_ >= 0);
#line 497 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp63_ = R;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp64_ = output_width;
#line 497 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (_tmp63_ < _tmp64_);
#line 498 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp65_ = T;
#line 498 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (_tmp65_ >= 0);
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp66_ = B;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp67_ = output_height;
#line 499 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (_tmp66_ < _tmp67_);
#line 500 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp68_ = *output_image;
#line 500 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (_tmp68_ != NULL);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp69_ = *output_image;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp70_ = gdk_pixbuf_get_pixels (_tmp69_);
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	output = _tmp70_;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	output_length1 = -1;
#line 502 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_output_size_ = output_length1;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp71_ = *output_image;
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp72_ = gdk_pixbuf_get_rowstride (_tmp71_);
#line 503 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	output_rowstride = _tmp72_;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp73_ = *output_image;
#line 504 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp74_ = gdk_pixbuf_get_n_channels (_tmp73_);
#line 504 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	output_n_channels = _tmp74_;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp75_ = page;
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp76_ = page_has_data (_tmp75_);
#line 506 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (!_tmp76_) {
#line 3343 "page-view.c"
		{
			gint _tmp77_;
			gint x;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp77_ = L;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			x = _tmp77_;
#line 3351 "page-view.c"
			{
				gboolean _tmp78_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp78_ = TRUE;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				while (TRUE) {
#line 3358 "page-view.c"
					gboolean _tmp79_;
					gint _tmp81_;
					gint _tmp82_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp79_ = _tmp78_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					if (!_tmp79_) {
#line 3366 "page-view.c"
						gint _tmp80_;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp80_ = x;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						x = _tmp80_ + 1;
#line 3372 "page-view.c"
					}
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp78_ = FALSE;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp81_ = x;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp82_ = R;
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					if (!(_tmp81_ <= _tmp82_)) {
#line 508 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						break;
#line 3384 "page-view.c"
					}
					{
						gint _tmp83_;
						gint y;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp83_ = T;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						y = _tmp83_;
#line 3393 "page-view.c"
						{
							gboolean _tmp84_;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp84_ = TRUE;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							while (TRUE) {
#line 3400 "page-view.c"
								gboolean _tmp85_;
								gint _tmp87_;
								gint _tmp88_;
								gint _tmp89_;
								gint _tmp90_;
								gint _tmp91_;
								gint _tmp92_;
								gint o;
								guchar* _tmp93_;
								gint _tmp93__length1;
								gint _tmp94_;
								guchar* _tmp95_;
								gint _tmp95__length1;
								gint _tmp96_;
								guchar* _tmp97_;
								gint _tmp97__length1;
								gint _tmp98_;
								guchar _tmp99_;
								guchar _tmp100_;
								guchar _tmp101_;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp85_ = _tmp84_;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								if (!_tmp85_) {
#line 3425 "page-view.c"
									gint _tmp86_;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
									_tmp86_ = y;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
									y = _tmp86_ + 1;
#line 3431 "page-view.c"
								}
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp84_ = FALSE;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp87_ = y;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp88_ = B;
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								if (!(_tmp87_ <= _tmp88_)) {
#line 509 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
									break;
#line 3443 "page-view.c"
								}
#line 511 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp89_ = output_rowstride;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp90_ = y;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp91_ = x;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp92_ = output_n_channels;
#line 511 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								o = (_tmp89_ * _tmp90_) + (_tmp91_ * _tmp92_);
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp93_ = output;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp93__length1 = output_length1;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp94_ = o;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp95_ = output;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp95__length1 = output_length1;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp96_ = o;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp97_ = output;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp97__length1 = output_length1;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp98_ = o;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp97_[_tmp98_ + 2] = (guchar) 0xFF;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp99_ = _tmp97_[_tmp98_ + 2];
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp95_[_tmp96_ + 1] = _tmp99_;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp100_ = _tmp95_[_tmp96_ + 1];
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp93_[_tmp94_] = _tmp100_;
#line 512 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp101_ = _tmp93_[_tmp94_];
#line 3485 "page-view.c"
							}
						}
					}
				}
			}
		}
#line 514 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 3494 "page-view.c"
	}
	{
		gint _tmp102_;
		gint x;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp102_ = L;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		x = _tmp102_;
#line 3503 "page-view.c"
		{
			gboolean _tmp103_;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp103_ = TRUE;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			while (TRUE) {
#line 3510 "page-view.c"
				gboolean _tmp104_;
				gint _tmp106_;
				gint _tmp107_;
				gint _tmp108_;
				gint _tmp109_;
				gint _tmp110_;
				gdouble l;
				gint _tmp111_;
				gint _tmp112_;
				gint _tmp113_;
				gdouble r;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp104_ = _tmp103_;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!_tmp104_) {
#line 3526 "page-view.c"
					gint _tmp105_;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp105_ = x;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					x = _tmp105_ + 1;
#line 3532 "page-view.c"
				}
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp103_ = FALSE;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp106_ = x;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp107_ = R;
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				if (!(_tmp106_ <= _tmp107_)) {
#line 518 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					break;
#line 3544 "page-view.c"
				}
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp108_ = x;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp109_ = input_width;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp110_ = output_width;
#line 520 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				l = (((gdouble) _tmp108_) * _tmp109_) / _tmp110_;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp111_ = x;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp112_ = input_width;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp113_ = output_width;
#line 521 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				r = (((gdouble) (_tmp111_ + 1)) * _tmp112_) / _tmp113_;
#line 3562 "page-view.c"
				{
					gint _tmp114_;
					gint y;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp114_ = T;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					y = _tmp114_;
#line 3570 "page-view.c"
					{
						gboolean _tmp115_;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp115_ = TRUE;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						while (TRUE) {
#line 3577 "page-view.c"
							gboolean _tmp116_;
							gint _tmp118_;
							gint _tmp119_;
							gint _tmp120_;
							gint _tmp121_;
							gint _tmp122_;
							gdouble t;
							gint _tmp123_;
							gint _tmp124_;
							gint _tmp125_;
							gdouble b;
							Page* _tmp126_;
							gdouble _tmp127_;
							gdouble _tmp128_;
							gdouble _tmp129_;
							gdouble _tmp130_;
							guchar* _tmp131_;
							gint _tmp131__length1;
							gint _tmp132_;
							gint _tmp133_;
							gint _tmp134_;
							gint _tmp135_;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp116_ = _tmp115_;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							if (!_tmp116_) {
#line 3604 "page-view.c"
								gint _tmp117_;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								_tmp117_ = y;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								y = _tmp117_ + 1;
#line 3610 "page-view.c"
							}
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp115_ = FALSE;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp118_ = y;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp119_ = B;
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							if (!(_tmp118_ <= _tmp119_)) {
#line 523 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
								break;
#line 3622 "page-view.c"
							}
#line 525 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp120_ = y;
#line 525 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp121_ = input_height;
#line 525 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp122_ = output_height;
#line 525 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							t = (((gdouble) _tmp120_) * _tmp121_) / _tmp122_;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp123_ = y;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp124_ = input_height;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp125_ = output_height;
#line 526 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							b = (((gdouble) (_tmp123_ + 1)) * _tmp124_) / _tmp125_;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp126_ = page;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp127_ = l;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp128_ = r;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp129_ = t;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp130_ = b;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp131_ = output;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp131__length1 = output_length1;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp132_ = output_rowstride;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp133_ = y;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp134_ = x;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							_tmp135_ = output_n_channels;
#line 528 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
							page_view_set_pixel (self, _tmp126_, _tmp127_, _tmp128_, _tmp129_, _tmp130_, _tmp131_, _tmp131__length1, (_tmp132_ * _tmp133_) + (_tmp134_ * _tmp135_));
#line 3664 "page-view.c"
						}
					}
				}
			}
		}
	}
}


static gint page_view_get_preview_width (PageView* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 535 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->width;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 537 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3688 "page-view.c"
}


static gint page_view_get_preview_height (PageView* self) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_;
#line 540 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->height;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->border_width;
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_ - (_tmp1_ * 2);
#line 542 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3706 "page-view.c"
}


static void page_view_update_page_view (PageView* self) {
	gboolean _tmp0_;
	gint _tmp1_;
	gint old_scan_line;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	gint scan_line;
	ScanDirection _tmp4_;
	Page* _tmp5_;
	ScanDirection _tmp6_ = 0;
	ScanDirection left_steps;
	gboolean _tmp7_ = FALSE;
	ScanDirection _tmp8_;
	gboolean _tmp10_;
	Page* _tmp11_;
	ScanDirection _tmp12_ = 0;
	Page* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	Page* _tmp16_;
	ScanDirection _tmp17_ = 0;
	gint _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
#line 545 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 547 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->update_image;
#line 547 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (!_tmp0_) {
#line 548 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 3742 "page-view.c"
	}
#line 550 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->scan_line;
#line 550 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	old_scan_line = _tmp1_;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->page;
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_get_scan_line (_tmp2_);
#line 551 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	scan_line = _tmp3_;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = self->priv->scan_direction;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp5_ = self->priv->page;
#line 554 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = page_get_scan_direction (_tmp5_);
#line 554 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	left_steps = _tmp4_ - _tmp6_;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = left_steps;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp8_ != 0) {
#line 3766 "page-view.c"
		GdkPixbuf* _tmp9_;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp9_ = self->priv->image;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp7_ = _tmp9_ != NULL;
#line 3772 "page-view.c"
	} else {
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp7_ = FALSE;
#line 3776 "page-view.c"
	}
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = _tmp7_;
#line 555 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp10_) {
#line 556 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_object_unref0 (self->priv->image);
#line 556 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->image = NULL;
#line 3786 "page-view.c"
	}
#line 557 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp11_ = self->priv->page;
#line 557 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = page_get_scan_direction (_tmp11_);
#line 557 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->scan_direction = _tmp12_;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp13_ = self->priv->page;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp14_ = page_view_get_preview_width (self);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp15_ = page_view_get_preview_height (self);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp16_ = self->priv->page;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp17_ = page_get_scan_direction (_tmp16_);
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp18_ = old_scan_line;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp19_ = scan_line;
#line 559 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_update_preview (self, _tmp13_, &self->priv->image, _tmp14_, _tmp15_, _tmp17_, _tmp18_, _tmp19_);
#line 565 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = FALSE;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp20_ = scan_line;
#line 566 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->scan_line = _tmp20_;
#line 3816 "page-view.c"
}


static gint page_view_page_to_screen_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
#line 569 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = x;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_view_get_preview_width (self);
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->page;
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_get_width (_tmp2_);
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp3_) + 0.5);
#line 571 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3840 "page-view.c"
}


static gint page_view_page_to_screen_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	gint _tmp1_ = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
#line 574 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = y;
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->page;
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_get_height (_tmp2_);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp1_) / _tmp3_) + 0.5);
#line 576 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3864 "page-view.c"
}


static gint page_view_screen_to_page_x (PageView* self, gint x) {
	gint result = 0;
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 579 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = x;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->page;
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_view_get_preview_width (self);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp2_) / _tmp3_) + 0.5);
#line 581 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3888 "page-view.c"
}


static gint page_view_screen_to_page_y (PageView* self, gint y) {
	gint result = 0;
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
#line 584 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = y;
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->page;
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = page_view_get_preview_height (self);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = (gint) (((((gdouble) _tmp0_) * _tmp2_) / _tmp3_) + 0.5);
#line 586 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 3912 "page-view.c"
}


static CropLocation page_view_get_crop_location (PageView* self, gint x, gint y) {
	CropLocation result = 0;
	Page* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp2_;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gint _tmp7_;
	gint _tmp8_ = 0;
	gint dx;
	gint _tmp9_;
	gint _tmp10_ = 0;
	gint dy;
	gint _tmp11_;
	gint _tmp12_ = 0;
	gint dw;
	gint _tmp13_;
	gint _tmp14_ = 0;
	gint dh;
	gint _tmp15_;
	gint _tmp16_;
	gint ix;
	gint _tmp17_;
	gint _tmp18_;
	gint iy;
	gboolean _tmp19_ = FALSE;
	gboolean _tmp20_ = FALSE;
	gboolean _tmp21_ = FALSE;
	gint _tmp22_;
	gboolean _tmp25_;
	gboolean _tmp27_;
	gboolean _tmp30_;
	Page* _tmp31_;
	gchar* _tmp32_ = NULL;
	gchar* name;
	const gchar* _tmp33_;
	gint crop_border;
	gint _tmp34_;
	gint _tmp35_;
	gint _tmp37_;
	gint _tmp38_;
	gboolean _tmp40_ = FALSE;
	gint _tmp41_;
	gint _tmp42_;
	gboolean _tmp45_;
	gboolean _tmp46_ = FALSE;
	gint _tmp47_;
	gint _tmp48_;
	gint _tmp49_;
	gboolean _tmp52_;
	gboolean _tmp53_ = FALSE;
	gint _tmp54_;
	gint _tmp55_;
	gboolean _tmp59_;
	gboolean _tmp60_ = FALSE;
	gint _tmp61_;
	gint _tmp62_;
	gint _tmp63_;
	gboolean _tmp67_;
	gint _tmp68_;
	gint _tmp69_;
	gint _tmp70_;
	gint _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gint _tmp76_;
	gint _tmp77_;
#line 589 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 591 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->page;
#line 591 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_has_crop (_tmp0_);
#line 591 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (!_tmp1_) {
#line 592 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = 0;
#line 592 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4003 "page-view.c"
	}
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->page;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_get_crop (_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cx = _tmp3_;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cy = _tmp4_;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cw = _tmp5_;
#line 595 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	ch = _tmp6_;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = cx;
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = page_view_page_to_screen_x (self, _tmp7_);
#line 596 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dx = _tmp8_;
#line 597 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = cy;
#line 597 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = page_view_page_to_screen_y (self, _tmp9_);
#line 597 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dy = _tmp10_;
#line 598 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp11_ = cw;
#line 598 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = page_view_page_to_screen_x (self, _tmp11_);
#line 598 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dw = _tmp12_;
#line 599 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp13_ = ch;
#line 599 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp14_ = page_view_page_to_screen_y (self, _tmp13_);
#line 599 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dh = _tmp14_;
#line 600 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp15_ = x;
#line 600 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp16_ = dx;
#line 600 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	ix = _tmp15_ - _tmp16_;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp17_ = y;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp18_ = dy;
#line 601 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	iy = _tmp17_ - _tmp18_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp22_ = ix;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp22_ < 0) {
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp21_ = TRUE;
#line 4059 "page-view.c"
	} else {
		gint _tmp23_;
		gint _tmp24_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp23_ = ix;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp24_ = dw;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp21_ = _tmp23_ > _tmp24_;
#line 4069 "page-view.c"
	}
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp25_ = _tmp21_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp25_) {
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp20_ = TRUE;
#line 4077 "page-view.c"
	} else {
		gint _tmp26_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp26_ = iy;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp20_ = _tmp26_ < 0;
#line 4084 "page-view.c"
	}
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp27_ = _tmp20_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp27_) {
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp19_ = TRUE;
#line 4092 "page-view.c"
	} else {
		gint _tmp28_;
		gint _tmp29_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp28_ = iy;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp29_ = dh;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp19_ = _tmp28_ > _tmp29_;
#line 4102 "page-view.c"
	}
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp30_ = _tmp19_;
#line 603 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp30_) {
#line 604 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_NONE;
#line 604 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4112 "page-view.c"
	}
#line 607 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp31_ = self->priv->page;
#line 607 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp32_ = page_get_named_crop (_tmp31_);
#line 607 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	name = _tmp32_;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp33_ = name;
#line 608 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp33_ != NULL) {
#line 609 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_MIDDLE;
#line 609 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 609 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4130 "page-view.c"
	}
#line 612 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	crop_border = 20;
#line 613 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp34_ = dw;
#line 613 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp35_ = crop_border;
#line 613 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp34_ < (_tmp35_ * 3)) {
#line 4140 "page-view.c"
		gint _tmp36_;
#line 614 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp36_ = dw;
#line 614 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		crop_border = _tmp36_ / 3;
#line 4146 "page-view.c"
	}
#line 615 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp37_ = dh;
#line 615 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp38_ = crop_border;
#line 615 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp37_ < (_tmp38_ * 3)) {
#line 4154 "page-view.c"
		gint _tmp39_;
#line 616 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp39_ = dh;
#line 616 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		crop_border = _tmp39_ / 3;
#line 4160 "page-view.c"
	}
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp41_ = ix;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp42_ = crop_border;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp41_ < _tmp42_) {
#line 4168 "page-view.c"
		gint _tmp43_;
		gint _tmp44_;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp43_ = iy;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp44_ = crop_border;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40_ = _tmp43_ < _tmp44_;
#line 4177 "page-view.c"
	} else {
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40_ = FALSE;
#line 4181 "page-view.c"
	}
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp45_ = _tmp40_;
#line 619 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp45_) {
#line 620 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_TOP_LEFT;
#line 620 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 620 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4193 "page-view.c"
	}
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp47_ = ix;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp48_ = dw;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp49_ = crop_border;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp47_ > (_tmp48_ - _tmp49_)) {
#line 4203 "page-view.c"
		gint _tmp50_;
		gint _tmp51_;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp50_ = iy;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp51_ = crop_border;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46_ = _tmp50_ < _tmp51_;
#line 4212 "page-view.c"
	} else {
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46_ = FALSE;
#line 4216 "page-view.c"
	}
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp52_ = _tmp46_;
#line 622 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp52_) {
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_TOP_RIGHT;
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 623 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4228 "page-view.c"
	}
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp54_ = ix;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp55_ = crop_border;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp54_ < _tmp55_) {
#line 4236 "page-view.c"
		gint _tmp56_;
		gint _tmp57_;
		gint _tmp58_;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp56_ = iy;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp57_ = dh;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp58_ = crop_border;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp53_ = _tmp56_ > (_tmp57_ - _tmp58_);
#line 4248 "page-view.c"
	} else {
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp53_ = FALSE;
#line 4252 "page-view.c"
	}
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp59_ = _tmp53_;
#line 625 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp59_) {
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_LEFT;
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 626 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4264 "page-view.c"
	}
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp61_ = ix;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp62_ = dw;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp63_ = crop_border;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp61_ > (_tmp62_ - _tmp63_)) {
#line 4274 "page-view.c"
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp66_;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp64_ = iy;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp65_ = dh;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp66_ = crop_border;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp60_ = _tmp64_ > (_tmp65_ - _tmp66_);
#line 4286 "page-view.c"
	} else {
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp60_ = FALSE;
#line 4290 "page-view.c"
	}
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp67_ = _tmp60_;
#line 628 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp67_) {
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM_RIGHT;
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 629 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4302 "page-view.c"
	}
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp68_ = ix;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp69_ = crop_border;
#line 632 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp68_ < _tmp69_) {
#line 633 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_LEFT;
#line 633 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 633 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4316 "page-view.c"
	}
#line 635 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp70_ = ix;
#line 635 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp71_ = dw;
#line 635 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp72_ = crop_border;
#line 635 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp70_ > (_tmp71_ - _tmp72_)) {
#line 636 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_RIGHT;
#line 636 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 636 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4332 "page-view.c"
	}
#line 638 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp73_ = iy;
#line 638 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp74_ = crop_border;
#line 638 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp73_ < _tmp74_) {
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_TOP;
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 639 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4346 "page-view.c"
	}
#line 641 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp75_ = iy;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp76_ = dh;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp77_ = crop_border;
#line 641 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp75_ > (_tmp76_ - _tmp77_)) {
#line 642 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		result = CROP_LOCATION_BOTTOM;
#line 642 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_g_free0 (name);
#line 642 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return result;
#line 4362 "page-view.c"
	}
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = CROP_LOCATION_MIDDLE;
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_g_free0 (name);
#line 645 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 4370 "page-view.c"
}


void page_view_button_press (PageView* self, gint x, gint y) {
	CropLocation location = 0;
	gint _tmp0_;
	gint _tmp1_;
	CropLocation _tmp2_ = 0;
	CropLocation _tmp3_;
#line 648 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = x;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = y;
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 653 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	location = _tmp2_;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = location;
#line 654 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp3_ != CROP_LOCATION_NONE) {
#line 4394 "page-view.c"
		CropLocation _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		Page* _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
#line 656 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp4_ = location;
#line 656 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->crop_location = _tmp4_;
#line 657 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = x;
#line 657 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_px = (gdouble) _tmp5_;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp6_ = y;
#line 658 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_py = (gdouble) _tmp6_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp7_ = self->priv->page;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_get_crop (_tmp7_, &_tmp8_, &_tmp9_, &_tmp10_, &_tmp11_);
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_x = _tmp8_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_y = _tmp9_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_w = _tmp10_;
#line 659 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->selected_crop_h = _tmp11_;
#line 4427 "page-view.c"
	}
}


void page_view_motion (PageView* self, gint x, gint y) {
	gint _tmp0_;
	gint _tmp1_;
	CropLocation _tmp2_ = 0;
	CropLocation location;
	GdkCursorType cursor = 0;
	CropLocation _tmp3_;
	CropLocation _tmp4_;
	Page* _tmp6_;
	gint _tmp7_ = 0;
	gint pw;
	Page* _tmp8_;
	gint _tmp9_ = 0;
	gint ph;
	gint cx = 0;
	gint cy = 0;
	gint cw = 0;
	gint ch = 0;
	Page* _tmp10_;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	gint _tmp15_;
	gdouble _tmp16_;
	gint _tmp17_ = 0;
	gint dx;
	gint _tmp18_;
	gdouble _tmp19_;
	gint _tmp20_ = 0;
	gint dy;
	gint _tmp21_;
	gint new_x;
	gint _tmp22_;
	gint new_y;
	gint _tmp23_;
	gint new_w;
	gint _tmp24_;
	gint new_h;
	gint _tmp25_ = 0;
	gint min_size;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	CropLocation _tmp28_;
	gboolean _tmp30_;
	gboolean _tmp32_;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	CropLocation _tmp43_;
	gboolean _tmp45_;
	gboolean _tmp47_;
	gboolean _tmp56_ = FALSE;
	gboolean _tmp57_ = FALSE;
	CropLocation _tmp58_;
	gboolean _tmp60_;
	gboolean _tmp62_;
	gboolean _tmp75_ = FALSE;
	gboolean _tmp76_ = FALSE;
	CropLocation _tmp77_;
	gboolean _tmp79_;
	gboolean _tmp81_;
	CropLocation _tmp94_;
	CropLocation _tmp115_;
	gboolean _tmp120_ = FALSE;
	gboolean _tmp121_ = FALSE;
	CropLocation _tmp122_;
	gboolean _tmp124_;
	gboolean _tmp126_;
	gboolean _tmp131_ = FALSE;
	gboolean _tmp132_ = FALSE;
	CropLocation _tmp133_;
	gboolean _tmp135_;
	gboolean _tmp137_;
	gboolean _tmp142_ = FALSE;
	gboolean _tmp143_ = FALSE;
	CropLocation _tmp144_;
	gboolean _tmp146_;
	gboolean _tmp148_;
	gboolean _tmp151_ = FALSE;
	gboolean _tmp152_ = FALSE;
	CropLocation _tmp153_;
	gboolean _tmp155_;
	gboolean _tmp157_;
	Page* _tmp160_;
	gint _tmp161_;
	gint _tmp162_;
	gboolean _tmp163_ = FALSE;
	gint _tmp164_;
	gint _tmp165_;
	gboolean _tmp168_;
#line 666 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = x;
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = y;
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_view_get_crop_location (self, _tmp0_, _tmp1_);
#line 668 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	location = _tmp2_;
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = location;
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	switch (_tmp3_) {
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_MIDDLE:
#line 4538 "page-view.c"
		{
#line 673 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_HAND1;
#line 674 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4544 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_TOP:
#line 4548 "page-view.c"
		{
#line 676 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_TOP_SIDE;
#line 677 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4554 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_BOTTOM:
#line 4558 "page-view.c"
		{
#line 679 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_BOTTOM_SIDE;
#line 680 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4564 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_LEFT:
#line 4568 "page-view.c"
		{
#line 682 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_LEFT_SIDE;
#line 683 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4574 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_RIGHT:
#line 4578 "page-view.c"
		{
#line 685 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_RIGHT_SIDE;
#line 686 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4584 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_TOP_LEFT:
#line 4588 "page-view.c"
		{
#line 688 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_TOP_LEFT_CORNER;
#line 689 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4594 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_TOP_RIGHT:
#line 4598 "page-view.c"
		{
#line 691 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_TOP_RIGHT_CORNER;
#line 692 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4604 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_LEFT:
#line 4608 "page-view.c"
		{
#line 694 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_BOTTOM_LEFT_CORNER;
#line 695 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4614 "page-view.c"
		}
#line 670 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		case CROP_LOCATION_BOTTOM_RIGHT:
#line 4618 "page-view.c"
		{
#line 697 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_BOTTOM_RIGHT_CORNER;
#line 698 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4624 "page-view.c"
		}
		default:
		{
#line 700 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			cursor = GDK_ARROW;
#line 701 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			break;
#line 4632 "page-view.c"
		}
	}
#line 704 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = self->priv->crop_location;
#line 704 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp4_ == CROP_LOCATION_NONE) {
#line 4639 "page-view.c"
		GdkCursorType _tmp5_;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = cursor;
#line 706 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->cursor = _tmp5_;
#line 707 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 4647 "page-view.c"
	}
#line 711 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = self->priv->page;
#line 711 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = page_get_width (_tmp6_);
#line 711 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	pw = _tmp7_;
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = self->priv->page;
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = page_get_height (_tmp8_);
#line 712 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	ph = _tmp9_;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = self->priv->page;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_get_crop (_tmp10_, &_tmp11_, &_tmp12_, &_tmp13_, &_tmp14_);
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cx = _tmp11_;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cy = _tmp12_;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cw = _tmp13_;
#line 714 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	ch = _tmp14_;
#line 716 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp15_ = x;
#line 716 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp16_ = self->priv->selected_crop_px;
#line 716 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp17_ = page_view_screen_to_page_x (self, _tmp15_ - ((gint) _tmp16_));
#line 716 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dx = _tmp17_;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp18_ = y;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp19_ = self->priv->selected_crop_py;
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp20_ = page_view_screen_to_page_y (self, _tmp18_ - ((gint) _tmp19_));
#line 717 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	dy = _tmp20_;
#line 719 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp21_ = self->priv->selected_crop_x;
#line 719 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	new_x = _tmp21_;
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp22_ = self->priv->selected_crop_y;
#line 720 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	new_y = _tmp22_;
#line 721 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp23_ = self->priv->selected_crop_w;
#line 721 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	new_w = _tmp23_;
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp24_ = self->priv->selected_crop_h;
#line 722 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	new_h = _tmp24_;
#line 725 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp25_ = page_view_screen_to_page_x (self, 15);
#line 725 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	min_size = _tmp25_;
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp28_ = self->priv->crop_location;
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp28_ == CROP_LOCATION_TOP_LEFT) {
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp27_ = TRUE;
#line 4715 "page-view.c"
	} else {
		CropLocation _tmp29_;
#line 727 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp29_ = self->priv->crop_location;
#line 727 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp27_ = _tmp29_ == CROP_LOCATION_LEFT;
#line 4722 "page-view.c"
	}
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp30_ = _tmp27_;
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp30_) {
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp26_ = TRUE;
#line 4730 "page-view.c"
	} else {
		CropLocation _tmp31_;
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp31_ = self->priv->crop_location;
#line 728 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp26_ = _tmp31_ == CROP_LOCATION_BOTTOM_LEFT;
#line 4737 "page-view.c"
	}
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp32_ = _tmp26_;
#line 726 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp32_) {
#line 4743 "page-view.c"
		gint _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _tmp38_;
		gint _tmp39_;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp33_ = dx;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp34_ = new_w;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp35_ = min_size;
#line 730 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp33_ > (_tmp34_ - _tmp35_)) {
#line 4757 "page-view.c"
			gint _tmp36_;
			gint _tmp37_;
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp36_ = new_w;
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp37_ = min_size;
#line 731 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = _tmp36_ - _tmp37_;
#line 4766 "page-view.c"
		}
#line 732 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp38_ = new_x;
#line 732 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp39_ = dx;
#line 732 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if ((_tmp38_ + _tmp39_) < 0) {
#line 4774 "page-view.c"
			gint _tmp40_;
#line 733 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp40_ = new_x;
#line 733 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = -_tmp40_;
#line 4780 "page-view.c"
		}
	}
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp43_ = self->priv->crop_location;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp43_ == CROP_LOCATION_TOP_LEFT) {
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp42_ = TRUE;
#line 4789 "page-view.c"
	} else {
		CropLocation _tmp44_;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp44_ = self->priv->crop_location;
#line 736 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp42_ = _tmp44_ == CROP_LOCATION_TOP;
#line 4796 "page-view.c"
	}
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp45_ = _tmp42_;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp45_) {
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp41_ = TRUE;
#line 4804 "page-view.c"
	} else {
		CropLocation _tmp46_;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp46_ = self->priv->crop_location;
#line 737 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp41_ = _tmp46_ == CROP_LOCATION_TOP_RIGHT;
#line 4811 "page-view.c"
	}
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp47_ = _tmp41_;
#line 735 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp47_) {
#line 4817 "page-view.c"
		gint _tmp48_;
		gint _tmp49_;
		gint _tmp50_;
		gint _tmp53_;
		gint _tmp54_;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp48_ = dy;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp49_ = new_h;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp50_ = min_size;
#line 739 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp48_ > (_tmp49_ - _tmp50_)) {
#line 4831 "page-view.c"
			gint _tmp51_;
			gint _tmp52_;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp51_ = new_h;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp52_ = min_size;
#line 740 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = _tmp51_ - _tmp52_;
#line 4840 "page-view.c"
		}
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp53_ = new_y;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp54_ = dy;
#line 741 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if ((_tmp53_ + _tmp54_) < 0) {
#line 4848 "page-view.c"
			gint _tmp55_;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp55_ = new_y;
#line 742 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = -_tmp55_;
#line 4854 "page-view.c"
		}
	}
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp58_ = self->priv->crop_location;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp58_ == CROP_LOCATION_TOP_RIGHT) {
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp57_ = TRUE;
#line 4863 "page-view.c"
	} else {
		CropLocation _tmp59_;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp59_ = self->priv->crop_location;
#line 746 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp57_ = _tmp59_ == CROP_LOCATION_RIGHT;
#line 4870 "page-view.c"
	}
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp60_ = _tmp57_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp60_) {
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp56_ = TRUE;
#line 4878 "page-view.c"
	} else {
		CropLocation _tmp61_;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp61_ = self->priv->crop_location;
#line 747 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp56_ = _tmp61_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4885 "page-view.c"
	}
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp62_ = _tmp56_;
#line 745 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp62_) {
#line 4891 "page-view.c"
		gint _tmp63_;
		gint _tmp64_;
		gint _tmp65_;
		gint _tmp68_;
		gint _tmp69_;
		gint _tmp70_;
		gint _tmp71_;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp63_ = dx;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp64_ = min_size;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp65_ = new_w;
#line 749 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp63_ < (_tmp64_ - _tmp65_)) {
#line 4907 "page-view.c"
			gint _tmp66_;
			gint _tmp67_;
#line 750 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp66_ = min_size;
#line 750 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp67_ = new_w;
#line 750 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = _tmp66_ - _tmp67_;
#line 4916 "page-view.c"
		}
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp68_ = new_x;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp69_ = new_w;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp70_ = dx;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp71_ = pw;
#line 751 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (((_tmp68_ + _tmp69_) + _tmp70_) > _tmp71_) {
#line 4928 "page-view.c"
			gint _tmp72_;
			gint _tmp73_;
			gint _tmp74_;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp72_ = pw;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp73_ = new_x;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp74_ = new_w;
#line 752 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = (_tmp72_ - _tmp73_) - _tmp74_;
#line 4940 "page-view.c"
		}
	}
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp77_ = self->priv->crop_location;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp77_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp76_ = TRUE;
#line 4949 "page-view.c"
	} else {
		CropLocation _tmp78_;
#line 755 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp78_ = self->priv->crop_location;
#line 755 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp76_ = _tmp78_ == CROP_LOCATION_BOTTOM;
#line 4956 "page-view.c"
	}
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp79_ = _tmp76_;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp79_) {
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp75_ = TRUE;
#line 4964 "page-view.c"
	} else {
		CropLocation _tmp80_;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp80_ = self->priv->crop_location;
#line 756 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp75_ = _tmp80_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 4971 "page-view.c"
	}
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp81_ = _tmp75_;
#line 754 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp81_) {
#line 4977 "page-view.c"
		gint _tmp82_;
		gint _tmp83_;
		gint _tmp84_;
		gint _tmp87_;
		gint _tmp88_;
		gint _tmp89_;
		gint _tmp90_;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp82_ = dy;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp83_ = min_size;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp84_ = new_h;
#line 758 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp82_ < (_tmp83_ - _tmp84_)) {
#line 4993 "page-view.c"
			gint _tmp85_;
			gint _tmp86_;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp85_ = min_size;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp86_ = new_h;
#line 759 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = _tmp85_ - _tmp86_;
#line 5002 "page-view.c"
		}
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp87_ = new_y;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp88_ = new_h;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp89_ = dy;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp90_ = ph;
#line 760 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (((_tmp87_ + _tmp88_) + _tmp89_) > _tmp90_) {
#line 5014 "page-view.c"
			gint _tmp91_;
			gint _tmp92_;
			gint _tmp93_;
#line 761 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp91_ = ph;
#line 761 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp92_ = new_y;
#line 761 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp93_ = new_h;
#line 761 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = (_tmp91_ - _tmp92_) - _tmp93_;
#line 5026 "page-view.c"
		}
	}
#line 763 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp94_ = self->priv->crop_location;
#line 763 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp94_ == CROP_LOCATION_MIDDLE) {
#line 5033 "page-view.c"
		gint _tmp95_;
		gint _tmp96_;
		gint _tmp97_;
		gint _tmp98_;
		gint _tmp102_;
		gint _tmp103_;
		gint _tmp105_;
		gint _tmp106_;
		gint _tmp107_;
		gint _tmp108_;
		gint _tmp112_;
		gint _tmp113_;
#line 765 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp95_ = new_x;
#line 765 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp96_ = dx;
#line 765 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp97_ = new_w;
#line 765 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp98_ = pw;
#line 765 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (((_tmp95_ + _tmp96_) + _tmp97_) > _tmp98_) {
#line 5056 "page-view.c"
			gint _tmp99_;
			gint _tmp100_;
			gint _tmp101_;
#line 766 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp99_ = pw;
#line 766 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp100_ = new_x;
#line 766 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp101_ = new_w;
#line 766 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = (_tmp99_ - _tmp100_) - _tmp101_;
#line 5068 "page-view.c"
		}
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp102_ = new_x;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp103_ = dx;
#line 767 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if ((_tmp102_ + _tmp103_) < 0) {
#line 5076 "page-view.c"
			gint _tmp104_;
#line 768 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp104_ = new_x;
#line 768 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dx = -_tmp104_;
#line 5082 "page-view.c"
		}
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp105_ = new_y;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp106_ = dy;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp107_ = new_h;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp108_ = ph;
#line 769 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (((_tmp105_ + _tmp106_) + _tmp107_) > _tmp108_) {
#line 5094 "page-view.c"
			gint _tmp109_;
			gint _tmp110_;
			gint _tmp111_;
#line 770 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp109_ = ph;
#line 770 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp110_ = new_y;
#line 770 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp111_ = new_h;
#line 770 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = (_tmp109_ - _tmp110_) - _tmp111_;
#line 5106 "page-view.c"
		}
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp112_ = new_y;
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp113_ = dy;
#line 771 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if ((_tmp112_ + _tmp113_) < 0) {
#line 5114 "page-view.c"
			gint _tmp114_;
#line 772 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp114_ = new_y;
#line 772 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			dy = -_tmp114_;
#line 5120 "page-view.c"
		}
	}
#line 776 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp115_ = self->priv->crop_location;
#line 776 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp115_ == CROP_LOCATION_MIDDLE) {
#line 5127 "page-view.c"
		gint _tmp116_;
		gint _tmp117_;
		gint _tmp118_;
		gint _tmp119_;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp116_ = new_x;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp117_ = dx;
#line 778 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_x = _tmp116_ + _tmp117_;
#line 779 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp118_ = new_y;
#line 779 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp119_ = dy;
#line 779 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_y = _tmp118_ + _tmp119_;
#line 5144 "page-view.c"
	}
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp122_ = self->priv->crop_location;
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp122_ == CROP_LOCATION_TOP_LEFT) {
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp121_ = TRUE;
#line 5152 "page-view.c"
	} else {
		CropLocation _tmp123_;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp123_ = self->priv->crop_location;
#line 782 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp121_ = _tmp123_ == CROP_LOCATION_LEFT;
#line 5159 "page-view.c"
	}
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp124_ = _tmp121_;
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp124_) {
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp120_ = TRUE;
#line 5167 "page-view.c"
	} else {
		CropLocation _tmp125_;
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp125_ = self->priv->crop_location;
#line 783 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp120_ = _tmp125_ == CROP_LOCATION_BOTTOM_LEFT;
#line 5174 "page-view.c"
	}
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp126_ = _tmp120_;
#line 781 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp126_) {
#line 5180 "page-view.c"
		gint _tmp127_;
		gint _tmp128_;
		gint _tmp129_;
		gint _tmp130_;
#line 785 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp127_ = new_x;
#line 785 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp128_ = dx;
#line 785 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_x = _tmp127_ + _tmp128_;
#line 786 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp129_ = new_w;
#line 786 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp130_ = dx;
#line 786 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_w = _tmp129_ - _tmp130_;
#line 5197 "page-view.c"
	}
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp133_ = self->priv->crop_location;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp133_ == CROP_LOCATION_TOP_LEFT) {
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp132_ = TRUE;
#line 5205 "page-view.c"
	} else {
		CropLocation _tmp134_;
#line 789 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp134_ = self->priv->crop_location;
#line 789 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp132_ = _tmp134_ == CROP_LOCATION_TOP;
#line 5212 "page-view.c"
	}
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp135_ = _tmp132_;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp135_) {
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp131_ = TRUE;
#line 5220 "page-view.c"
	} else {
		CropLocation _tmp136_;
#line 790 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp136_ = self->priv->crop_location;
#line 790 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp131_ = _tmp136_ == CROP_LOCATION_TOP_RIGHT;
#line 5227 "page-view.c"
	}
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp137_ = _tmp131_;
#line 788 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp137_) {
#line 5233 "page-view.c"
		gint _tmp138_;
		gint _tmp139_;
		gint _tmp140_;
		gint _tmp141_;
#line 792 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp138_ = new_y;
#line 792 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp139_ = dy;
#line 792 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_y = _tmp138_ + _tmp139_;
#line 793 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp140_ = new_h;
#line 793 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp141_ = dy;
#line 793 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_h = _tmp140_ - _tmp141_;
#line 5250 "page-view.c"
	}
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp144_ = self->priv->crop_location;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp144_ == CROP_LOCATION_TOP_RIGHT) {
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp143_ = TRUE;
#line 5258 "page-view.c"
	} else {
		CropLocation _tmp145_;
#line 797 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp145_ = self->priv->crop_location;
#line 797 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp143_ = _tmp145_ == CROP_LOCATION_RIGHT;
#line 5265 "page-view.c"
	}
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp146_ = _tmp143_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp146_) {
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp142_ = TRUE;
#line 5273 "page-view.c"
	} else {
		CropLocation _tmp147_;
#line 798 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp147_ = self->priv->crop_location;
#line 798 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp142_ = _tmp147_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5280 "page-view.c"
	}
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp148_ = _tmp142_;
#line 796 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp148_) {
#line 5286 "page-view.c"
		gint _tmp149_;
		gint _tmp150_;
#line 799 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp149_ = new_w;
#line 799 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp150_ = dx;
#line 799 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_w = _tmp149_ + _tmp150_;
#line 5295 "page-view.c"
	}
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp153_ = self->priv->crop_location;
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp153_ == CROP_LOCATION_BOTTOM_LEFT) {
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp152_ = TRUE;
#line 5303 "page-view.c"
	} else {
		CropLocation _tmp154_;
#line 801 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp154_ = self->priv->crop_location;
#line 801 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp152_ = _tmp154_ == CROP_LOCATION_BOTTOM;
#line 5310 "page-view.c"
	}
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp155_ = _tmp152_;
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp155_) {
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp151_ = TRUE;
#line 5318 "page-view.c"
	} else {
		CropLocation _tmp156_;
#line 802 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp156_ = self->priv->crop_location;
#line 802 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp151_ = _tmp156_ == CROP_LOCATION_BOTTOM_RIGHT;
#line 5325 "page-view.c"
	}
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp157_ = _tmp151_;
#line 800 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp157_) {
#line 5331 "page-view.c"
		gint _tmp158_;
		gint _tmp159_;
#line 803 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp158_ = new_h;
#line 803 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp159_ = dy;
#line 803 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		new_h = _tmp158_ + _tmp159_;
#line 5340 "page-view.c"
	}
#line 805 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp160_ = self->priv->page;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp161_ = new_x;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp162_ = new_y;
#line 805 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_move_crop (_tmp160_, _tmp161_, _tmp162_);
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp164_ = new_w;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp165_ = cw;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp164_ != _tmp165_) {
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp163_ = TRUE;
#line 5358 "page-view.c"
	} else {
		gint _tmp166_;
		gint _tmp167_;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp166_ = new_h;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp167_ = ch;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp163_ = _tmp166_ != _tmp167_;
#line 5368 "page-view.c"
	}
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp168_ = _tmp163_;
#line 808 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp168_) {
#line 5374 "page-view.c"
		Page* _tmp169_;
		gint _tmp170_;
		gint _tmp171_;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp169_ = self->priv->page;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp170_ = new_w;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp171_ = new_h;
#line 809 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_set_custom_crop (_tmp169_, _tmp170_, _tmp171_);
#line 5386 "page-view.c"
	}
}


void page_view_button_release (PageView* self, gint x, gint y) {
#line 812 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 815 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->crop_location = CROP_LOCATION_NONE;
#line 816 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 5398 "page-view.c"
}


GdkCursorType page_view_get_cursor (PageView* self) {
	GdkCursorType result = 0;
	GdkCursorType _tmp0_;
#line 819 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 821 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->cursor;
#line 821 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 821 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 5413 "page-view.c"
}


static gboolean page_view_animation_cb (PageView* self) {
	gboolean result = FALSE;
	gint _tmp0_;
	gint _tmp1_;
#line 824 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 826 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->animate_segment;
#line 826 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->animate_n_segments;
#line 826 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->animate_segment = (_tmp0_ + 1) % _tmp1_;
#line 827 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 828 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = TRUE;
#line 828 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 5435 "page-view.c"
}


static gboolean _page_view_animation_cb_gsource_func (gpointer self) {
	gboolean result;
	result = page_view_animation_cb (self);
#line 844 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 5444 "page-view.c"
}


static void page_view_update_animation (PageView* self) {
	gboolean animate = FALSE;
	gboolean is_animating = FALSE;
	gboolean _tmp0_ = FALSE;
	Page* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp5_;
	guint _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
#line 831 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->page;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_is_scanning (_tmp1_);
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp2_) {
#line 5467 "page-view.c"
		Page* _tmp3_;
		gboolean _tmp4_ = FALSE;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp3_ = self->priv->page;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp4_ = page_has_data (_tmp3_);
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp0_ = !_tmp4_;
#line 5476 "page-view.c"
	} else {
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp0_ = FALSE;
#line 5480 "page-view.c"
	}
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp5_ = _tmp0_;
#line 835 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	animate = _tmp5_;
#line 836 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = self->priv->animate_timeout;
#line 836 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	is_animating = _tmp6_ != ((guint) 0);
#line 837 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = animate;
#line 837 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = is_animating;
#line 837 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp7_ == _tmp8_) {
#line 838 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 5498 "page-view.c"
	}
#line 840 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = animate;
#line 840 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp9_) {
#line 5504 "page-view.c"
		guint _tmp10_;
#line 842 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->animate_segment = 0;
#line 843 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp10_ = self->priv->animate_timeout;
#line 843 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp10_ == ((guint) 0)) {
#line 5512 "page-view.c"
			guint _tmp11_ = 0U;
#line 844 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp11_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 150, _page_view_animation_cb_gsource_func, page_view_ref (self), page_view_unref);
#line 844 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			self->priv->animate_timeout = _tmp11_;
#line 5518 "page-view.c"
		}
	} else {
		guint _tmp12_;
#line 848 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp12_ = self->priv->animate_timeout;
#line 848 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp12_ != ((guint) 0)) {
#line 5526 "page-view.c"
			guint _tmp13_;
#line 849 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp13_ = self->priv->animate_timeout;
#line 849 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			g_source_remove (_tmp13_);
#line 5532 "page-view.c"
		}
#line 850 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		self->priv->animate_timeout = (guint) 0;
#line 5536 "page-view.c"
	}
}


void page_view_render (PageView* self, cairo_t* context) {
	gint _tmp0_ = 0;
	gint w;
	gint _tmp1_ = 0;
	gint h;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	gint _tmp8_;
	cairo_t* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	cairo_t* _tmp16_;
	cairo_t* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	cairo_t* _tmp20_;
	GdkPixbuf* _tmp21_;
	cairo_t* _tmp22_;
	gboolean _tmp23_ = FALSE;
	Page* _tmp24_;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp28_;
	gboolean _tmp70_ = FALSE;
	Page* _tmp71_;
	gboolean _tmp72_ = FALSE;
	gboolean _tmp75_;
	Page* _tmp115_;
	gboolean _tmp116_ = FALSE;
#line 854 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 854 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (context != NULL);
#line 856 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_update_animation (self);
#line 857 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_update_page_view (self);
#line 859 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = page_view_get_preview_width (self);
#line 859 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	w = _tmp0_;
#line 860 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = page_view_get_preview_height (self);
#line 860 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	h = _tmp1_;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = context;
#line 862 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_set_line_width (_tmp2_, (gdouble) 1);
#line 863 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = context;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = self->priv->x_offset;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp5_ = self->priv->y_offset;
#line 863 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_translate (_tmp3_, (gdouble) _tmp4_, (gdouble) _tmp5_);
#line 866 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = context;
#line 866 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_set_source_rgb (_tmp6_, (gdouble) 0, (gdouble) 0, (gdouble) 0);
#line 867 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = context;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = self->priv->border_width;
#line 867 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_set_line_width (_tmp7_, (gdouble) _tmp8_);
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp9_ = context;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = self->priv->border_width;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp11_ = self->priv->border_width;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = self->priv->width;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp13_ = self->priv->border_width;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp14_ = self->priv->height;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp15_ = self->priv->border_width;
#line 868 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_rectangle (_tmp9_, ((gdouble) _tmp10_) / 2, ((gdouble) _tmp11_) / 2, (gdouble) (_tmp12_ - _tmp13_), (gdouble) (_tmp14_ - _tmp15_));
#line 872 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp16_ = context;
#line 872 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_stroke (_tmp16_);
#line 875 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp17_ = context;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp18_ = self->priv->border_width;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp19_ = self->priv->border_width;
#line 875 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_translate (_tmp17_, (gdouble) _tmp18_, (gdouble) _tmp19_);
#line 876 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp20_ = context;
#line 876 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp21_ = self->priv->image;
#line 876 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	gdk_cairo_set_source_pixbuf (_tmp20_, _tmp21_, (gdouble) 0, (gdouble) 0);
#line 877 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp22_ = context;
#line 877 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	cairo_paint (_tmp22_);
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp24_ = self->priv->page;
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp25_ = page_is_scanning (_tmp24_);
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp25_) {
#line 5659 "page-view.c"
		Page* _tmp26_;
		gboolean _tmp27_ = FALSE;
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp26_ = self->priv->page;
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp27_ = page_has_data (_tmp26_);
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp23_ = !_tmp27_;
#line 5668 "page-view.c"
	} else {
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp23_ = FALSE;
#line 5672 "page-view.c"
	}
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp28_ = _tmp23_;
#line 880 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp28_) {
#line 5678 "page-view.c"
		gdouble outer_radius = 0.0;
		gint _tmp29_;
		gint _tmp30_;
		gint _tmp33_;
		gdouble arc;
		gdouble _tmp34_;
		gdouble _tmp35_;
		gdouble _tmp36_ = 0.0;
		gdouble x;
		gdouble _tmp37_;
		gdouble _tmp38_;
		gdouble _tmp39_ = 0.0;
		gdouble y;
		gdouble _tmp40_;
		gdouble _tmp41_;
		gdouble _tmp42_;
		gdouble _tmp43_;
		gdouble _tmp44_ = 0.0;
		gdouble inner_radius;
		gdouble offset;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp29_ = w;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp30_ = h;
#line 883 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (_tmp29_ > _tmp30_) {
#line 5705 "page-view.c"
			gint _tmp31_;
#line 884 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp31_ = w;
#line 884 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			outer_radius = 0.15 * _tmp31_;
#line 5711 "page-view.c"
		} else {
			gint _tmp32_;
#line 886 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			_tmp32_ = h;
#line 886 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			outer_radius = 0.15 * _tmp32_;
#line 5718 "page-view.c"
		}
#line 887 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp33_ = self->priv->animate_n_segments;
#line 887 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		arc = G_PI / _tmp33_;
#line 890 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp34_ = outer_radius;
#line 890 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp35_ = arc;
#line 890 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp36_ = sin (_tmp35_);
#line 890 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		x = _tmp34_ * _tmp36_;
#line 891 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp37_ = outer_radius;
#line 891 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp38_ = arc;
#line 891 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp39_ = cos (_tmp38_);
#line 891 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		y = _tmp37_ * (_tmp39_ - 1.0);
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp40_ = x;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp41_ = x;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp42_ = y;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp43_ = y;
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp44_ = sqrt ((_tmp40_ * _tmp41_) + (_tmp42_ * _tmp43_));
#line 892 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		inner_radius = 0.6 * _tmp44_;
#line 894 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		offset = 0.0;
#line 5754 "page-view.c"
		{
			gint i;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			i = 0;
#line 5759 "page-view.c"
			{
				gboolean _tmp45_;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp45_ = TRUE;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				while (TRUE) {
#line 5766 "page-view.c"
					gboolean _tmp46_;
					gint _tmp50_;
					gint _tmp51_;
					gint _tmp52_;
					gdouble _tmp53_;
					gdouble _tmp54_;
					gdouble _tmp55_ = 0.0;
					gint _tmp56_;
					gdouble _tmp57_;
					gdouble _tmp58_;
					gdouble _tmp59_ = 0.0;
					cairo_t* _tmp60_;
					gdouble _tmp61_;
					gdouble _tmp62_;
					gdouble _tmp63_;
					gint _tmp64_;
					gint _tmp65_;
					cairo_t* _tmp68_;
					cairo_t* _tmp69_;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp46_ = _tmp45_;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					if (!_tmp46_) {
#line 5790 "page-view.c"
						gint _tmp47_;
						gdouble _tmp48_;
						gdouble _tmp49_;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp47_ = i;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						i = _tmp47_ + 1;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp48_ = offset;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp49_ = arc;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						offset = _tmp48_ + (_tmp49_ * 2);
#line 5804 "page-view.c"
					}
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp45_ = FALSE;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp50_ = i;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp51_ = self->priv->animate_n_segments;
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					if (!(_tmp50_ < _tmp51_)) {
#line 895 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						break;
#line 5816 "page-view.c"
					}
#line 897 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp52_ = w;
#line 897 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp53_ = outer_radius;
#line 897 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp54_ = offset;
#line 897 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp55_ = sin (_tmp54_);
#line 897 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					x = (_tmp52_ / 2) + (_tmp53_ * _tmp55_);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp56_ = h;
#line 898 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp57_ = outer_radius;
#line 898 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp58_ = offset;
#line 898 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp59_ = cos (_tmp58_);
#line 898 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					y = (_tmp56_ / 2) - (_tmp57_ * _tmp59_);
#line 899 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp60_ = context;
#line 899 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp61_ = x;
#line 899 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp62_ = y;
#line 899 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp63_ = inner_radius;
#line 899 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					cairo_arc (_tmp60_, _tmp61_, _tmp62_, _tmp63_, (gdouble) 0, 2 * G_PI);
#line 901 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp64_ = i;
#line 901 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp65_ = self->priv->animate_segment;
#line 901 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					if (_tmp64_ == _tmp65_) {
#line 5854 "page-view.c"
						cairo_t* _tmp66_;
						cairo_t* _tmp67_;
#line 903 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp66_ = context;
#line 903 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						cairo_set_source_rgb (_tmp66_, 0.75, 0.75, 0.75);
#line 904 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						_tmp67_ = context;
#line 904 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
						cairo_fill_preserve (_tmp67_);
#line 5865 "page-view.c"
					}
#line 907 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp68_ = context;
#line 907 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					cairo_set_source_rgb (_tmp68_, 0.5, 0.5, 0.5);
#line 908 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					_tmp69_ = context;
#line 908 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
					cairo_stroke (_tmp69_);
#line 5875 "page-view.c"
				}
			}
		}
	}
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp71_ = self->priv->page;
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp72_ = page_is_scanning (_tmp71_);
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp72_) {
#line 5886 "page-view.c"
		Page* _tmp73_;
		gint _tmp74_ = 0;
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp73_ = self->priv->page;
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp74_ = page_get_scan_line (_tmp73_);
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp70_ = _tmp74_ > 0;
#line 5895 "page-view.c"
	} else {
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp70_ = FALSE;
#line 5899 "page-view.c"
	}
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp75_ = _tmp70_;
#line 913 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp75_) {
#line 5905 "page-view.c"
		Page* _tmp76_;
		gint _tmp77_ = 0;
		gint scan_line;
		gdouble s = 0.0;
		gdouble x1 = 0.0;
		gdouble y1 = 0.0;
		gdouble x2 = 0.0;
		gdouble y2 = 0.0;
		Page* _tmp78_;
		ScanDirection _tmp79_ = 0;
		cairo_t* _tmp107_;
		gdouble _tmp108_;
		gdouble _tmp109_;
		cairo_t* _tmp110_;
		gdouble _tmp111_;
		gdouble _tmp112_;
		cairo_t* _tmp113_;
		cairo_t* _tmp114_;
#line 915 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp76_ = self->priv->page;
#line 915 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp77_ = page_get_scan_line (_tmp76_);
#line 915 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		scan_line = _tmp77_;
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp78_ = self->priv->page;
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp79_ = page_get_scan_direction (_tmp78_);
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		switch (_tmp79_) {
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_TOP_TO_BOTTOM:
#line 5938 "page-view.c"
			{
				gint _tmp80_;
				gint _tmp81_ = 0;
				gdouble _tmp82_;
				gint _tmp83_;
				gdouble _tmp84_;
#line 922 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp80_ = scan_line;
#line 922 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp81_ = page_view_page_to_screen_y (self, _tmp80_);
#line 922 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				s = (gdouble) _tmp81_;
#line 923 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x1 = (gdouble) 0;
#line 923 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp82_ = s;
#line 923 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y1 = _tmp82_ + 0.5;
#line 924 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp83_ = w;
#line 924 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x2 = (gdouble) _tmp83_;
#line 924 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp84_ = s;
#line 924 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y2 = _tmp84_ + 0.5;
#line 925 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 5967 "page-view.c"
			}
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_BOTTOM_TO_TOP:
#line 5971 "page-view.c"
			{
				gint _tmp85_;
				gint _tmp86_ = 0;
				gint _tmp87_;
				gdouble _tmp88_;
				gint _tmp89_;
				gint _tmp90_;
				gdouble _tmp91_;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp85_ = scan_line;
#line 927 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp86_ = page_view_page_to_screen_y (self, _tmp85_);
#line 927 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				s = (gdouble) _tmp86_;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x1 = (gdouble) 0;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp87_ = h;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp88_ = s;
#line 928 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y1 = (_tmp87_ - _tmp88_) + 0.5;
#line 929 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp89_ = w;
#line 929 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x2 = (gdouble) _tmp89_;
#line 929 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp90_ = h;
#line 929 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp91_ = s;
#line 929 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y2 = (_tmp90_ - _tmp91_) + 0.5;
#line 930 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 6006 "page-view.c"
			}
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_LEFT_TO_RIGHT:
#line 6010 "page-view.c"
			{
				gint _tmp92_;
				gint _tmp93_ = 0;
				gdouble _tmp94_;
				gdouble _tmp95_;
				gint _tmp96_;
#line 932 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp92_ = scan_line;
#line 932 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp93_ = page_view_page_to_screen_x (self, _tmp92_);
#line 932 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				s = (gdouble) _tmp93_;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp94_ = s;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x1 = _tmp94_ + 0.5;
#line 933 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y1 = (gdouble) 0;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp95_ = s;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x2 = _tmp95_ + 0.5;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp96_ = h;
#line 934 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y2 = (gdouble) _tmp96_;
#line 935 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 6039 "page-view.c"
			}
#line 919 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			case SCAN_DIRECTION_RIGHT_TO_LEFT:
#line 6043 "page-view.c"
			{
				gint _tmp97_;
				gint _tmp98_ = 0;
				gint _tmp99_;
				gdouble _tmp100_;
				gint _tmp101_;
				gdouble _tmp102_;
				gint _tmp103_;
#line 937 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp97_ = scan_line;
#line 937 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp98_ = page_view_page_to_screen_x (self, _tmp97_);
#line 937 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				s = (gdouble) _tmp98_;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp99_ = w;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp100_ = s;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x1 = (_tmp99_ - _tmp100_) + 0.5;
#line 938 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y1 = (gdouble) 0;
#line 939 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp101_ = w;
#line 939 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp102_ = s;
#line 939 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x2 = (_tmp101_ - _tmp102_) + 0.5;
#line 939 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp103_ = h;
#line 939 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y2 = (gdouble) _tmp103_;
#line 940 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 6078 "page-view.c"
			}
			default:
			{
				gdouble _tmp104_;
				gdouble _tmp105_;
				gdouble _tmp106_;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y2 = (gdouble) 0;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp104_ = y2;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x2 = _tmp104_;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp105_ = x2;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				y1 = _tmp105_;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				_tmp106_ = y1;
#line 942 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				x1 = _tmp106_;
#line 943 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
				break;
#line 6101 "page-view.c"
			}
		}
#line 946 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp107_ = context;
#line 946 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp108_ = x1;
#line 946 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp109_ = y1;
#line 946 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_move_to (_tmp107_, _tmp108_, _tmp109_);
#line 947 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp110_ = context;
#line 947 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp111_ = x2;
#line 947 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp112_ = y2;
#line 947 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_line_to (_tmp110_, _tmp111_, _tmp112_);
#line 948 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp113_ = context;
#line 948 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_set_source_rgb (_tmp113_, 1.0, 0.0, 0.0);
#line 949 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp114_ = context;
#line 949 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_stroke (_tmp114_);
#line 6128 "page-view.c"
	}
#line 953 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp115_ = self->priv->page;
#line 953 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp116_ = page_has_crop (_tmp115_);
#line 953 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp116_) {
#line 6136 "page-view.c"
		gint x = 0;
		gint y = 0;
		gint crop_width = 0;
		gint crop_height = 0;
		Page* _tmp117_;
		gint _tmp118_ = 0;
		gint _tmp119_ = 0;
		gint _tmp120_ = 0;
		gint _tmp121_ = 0;
		gint _tmp122_;
		gint _tmp123_ = 0;
		gint dx;
		gint _tmp124_;
		gint _tmp125_ = 0;
		gint dy;
		gint _tmp126_;
		gint _tmp127_ = 0;
		gint dw;
		gint _tmp128_;
		gint _tmp129_ = 0;
		gint dh;
		cairo_t* _tmp130_;
		gint _tmp131_;
		gint _tmp132_;
		cairo_t* _tmp133_;
		cairo_t* _tmp134_;
		gint _tmp135_;
		gint _tmp136_;
		gint _tmp137_;
		gint _tmp138_;
		cairo_t* _tmp139_;
		cairo_t* _tmp140_;
		cairo_t* _tmp141_;
		cairo_t* _tmp142_;
		gint _tmp143_;
		gint _tmp144_;
		gint _tmp145_;
		gint _tmp146_;
		cairo_t* _tmp147_;
		cairo_t* _tmp148_;
		cairo_t* _tmp149_;
		gint _tmp150_;
		gint _tmp151_;
		gint _tmp152_;
		gint _tmp153_;
		cairo_t* _tmp154_;
		cairo_t* _tmp155_;
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp117_ = self->priv->page;
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_get_crop (_tmp117_, &_tmp118_, &_tmp119_, &_tmp120_, &_tmp121_);
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		x = _tmp118_;
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		y = _tmp119_;
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		crop_width = _tmp120_;
#line 956 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		crop_height = _tmp121_;
#line 958 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp122_ = x;
#line 958 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp123_ = page_view_page_to_screen_x (self, _tmp122_);
#line 958 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dx = _tmp123_;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp124_ = y;
#line 959 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp125_ = page_view_page_to_screen_y (self, _tmp124_);
#line 959 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dy = _tmp125_;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp126_ = crop_width;
#line 960 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp127_ = page_view_page_to_screen_x (self, _tmp126_);
#line 960 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dw = _tmp127_;
#line 961 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp128_ = crop_height;
#line 961 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp129_ = page_view_page_to_screen_y (self, _tmp128_);
#line 961 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dh = _tmp129_;
#line 964 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp130_ = context;
#line 964 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp131_ = w;
#line 964 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp132_ = h;
#line 964 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_rectangle (_tmp130_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp131_, (gdouble) _tmp132_);
#line 965 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp133_ = context;
#line 965 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_new_sub_path (_tmp133_);
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp134_ = context;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp135_ = dx;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp136_ = dy;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp137_ = dw;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp138_ = dh;
#line 966 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_rectangle (_tmp134_, (gdouble) _tmp135_, (gdouble) _tmp136_, (gdouble) _tmp137_, (gdouble) _tmp138_);
#line 967 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp139_ = context;
#line 967 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_set_fill_rule (_tmp139_, CAIRO_FILL_RULE_EVEN_ODD);
#line 968 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp140_ = context;
#line 968 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_set_source_rgba (_tmp140_, 0.25, 0.25, 0.25, 0.2);
#line 969 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp141_ = context;
#line 969 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_fill (_tmp141_);
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp142_ = context;
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp143_ = dx;
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp144_ = dy;
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp145_ = dw;
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp146_ = dh;
#line 972 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_rectangle (_tmp142_, _tmp143_ - 1.5, _tmp144_ - 1.5, (gdouble) (_tmp145_ + 3), (gdouble) (_tmp146_ + 3));
#line 973 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp147_ = context;
#line 973 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_set_source_rgb (_tmp147_, 1.0, 1.0, 1.0);
#line 974 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp148_ = context;
#line 974 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_stroke (_tmp148_);
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp149_ = context;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp150_ = dx;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp151_ = dy;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp152_ = dw;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp153_ = dh;
#line 975 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_rectangle (_tmp149_, _tmp150_ - 0.5, _tmp151_ - 0.5, (gdouble) (_tmp152_ + 1), (gdouble) (_tmp153_ + 1));
#line 976 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp154_ = context;
#line 976 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_set_source_rgb (_tmp154_, 0.0, 0.0, 0.0);
#line 977 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp155_ = context;
#line 977 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		cairo_stroke (_tmp155_);
#line 6296 "page-view.c"
	}
}


void page_view_set_width (PageView* self, gint width) {
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	Page* _tmp3_;
	gint _tmp4_ = 0;
	gint height;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
#line 981 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = width;
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->page;
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_get_height (_tmp1_);
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = self->priv->page;
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = page_get_width (_tmp3_);
#line 984 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	height = (gint) ((((gdouble) _tmp0_) * _tmp2_) / _tmp4_);
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = self->priv->width;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = width;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp6_ == _tmp7_) {
#line 6334 "page-view.c"
		gint _tmp8_;
		gint _tmp9_;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp8_ = self->priv->height;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp9_ = height;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = _tmp8_ == _tmp9_;
#line 6343 "page-view.c"
	} else {
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = FALSE;
#line 6347 "page-view.c"
	}
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = _tmp5_;
#line 985 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp10_) {
#line 986 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 6355 "page-view.c"
	}
#line 988 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp11_ = width;
#line 988 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->width = _tmp11_;
#line 989 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = height;
#line 989 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->height = _tmp12_;
#line 992 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 994 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 995 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6371 "page-view.c"
}


void page_view_set_height (PageView* self, gint height) {
	gint _tmp0_;
	Page* _tmp1_;
	gint _tmp2_ = 0;
	Page* _tmp3_;
	gint _tmp4_ = 0;
	gint width;
	gboolean _tmp5_ = FALSE;
	gint _tmp6_;
	gint _tmp7_;
	gboolean _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
#line 998 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = height;
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp1_ = self->priv->page;
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = page_get_width (_tmp1_);
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp3_ = self->priv->page;
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = page_get_height (_tmp3_);
#line 1001 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	width = (gint) ((((gdouble) _tmp0_) * _tmp2_) / _tmp4_);
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = self->priv->width;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp7_ = width;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp6_ == _tmp7_) {
#line 6408 "page-view.c"
		gint _tmp8_;
		gint _tmp9_;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp8_ = self->priv->height;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp9_ = height;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = _tmp8_ == _tmp9_;
#line 6417 "page-view.c"
	} else {
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		_tmp5_ = FALSE;
#line 6421 "page-view.c"
	}
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp10_ = _tmp5_;
#line 1002 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (_tmp10_) {
#line 1003 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return;
#line 6429 "page-view.c"
	}
#line 1005 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp11_ = width;
#line 1005 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->width = _tmp11_;
#line 1006 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp12_ = height;
#line 1006 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->height = _tmp12_;
#line 1009 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1011 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1012 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6445 "page-view.c"
}


gint page_view_get_width (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 1015 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->width;
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 1017 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 6460 "page-view.c"
}


gint page_view_get_height (PageView* self) {
	gint result = 0;
	gint _tmp0_;
#line 1020 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 1022 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->height;
#line 1022 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	result = _tmp0_;
#line 1022 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return result;
#line 6475 "page-view.c"
}


static void page_view_page_pixels_changed_cb (PageView* self, Page* p) {
#line 1025 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1025 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1028 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1029 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6488 "page-view.c"
}


static void page_view_page_size_changed_cb (PageView* self, Page* p) {
#line 1032 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1032 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1035 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1036 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1037 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6503 "page-view.c"
}


static void page_view_page_overlay_changed_cb (PageView* self, Page* p) {
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1040 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1042 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6514 "page-view.c"
}


static void page_view_scan_direction_changed_cb (PageView* self, Page* p) {
#line 1045 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (self != NULL);
#line 1045 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (p != NULL);
#line 1048 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 1049 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "size-changed");
#line 1050 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_emit_by_name (self, "changed");
#line 6529 "page-view.c"
}


static void value_page_view_init (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	value->data[0].v_pointer = NULL;
#line 6536 "page-view.c"
}


static void value_page_view_free_value (GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_unref (value->data[0].v_pointer);
#line 6545 "page-view.c"
	}
}


static void value_page_view_copy_value (const GValue* src_value, GValue* dest_value) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (src_value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dest_value->data[0].v_pointer = page_view_ref (src_value->data[0].v_pointer);
#line 6555 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		dest_value->data[0].v_pointer = NULL;
#line 6559 "page-view.c"
	}
}


static gpointer value_page_view_peek_pointer (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6567 "page-view.c"
}


static gchar* value_page_view_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (collect_values[0].v_pointer) {
#line 6574 "page-view.c"
		PageView* object;
		object = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		if (object->parent_instance.g_class == NULL) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6581 "page-view.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 6585 "page-view.c"
		}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = page_view_ref (object);
#line 6589 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6593 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return NULL;
#line 6597 "page-view.c"
}


static gchar* value_page_view_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	PageView** object_p;
	object_p = collect_values[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (!object_p) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 6608 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (!value->data[0].v_pointer) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		*object_p = NULL;
#line 6614 "page-view.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		*object_p = value->data[0].v_pointer;
#line 6618 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		*object_p = page_view_ref (value->data[0].v_pointer);
#line 6622 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return NULL;
#line 6626 "page-view.c"
}


GParamSpec* param_spec_page_view (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecPageView* spec;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return G_PARAM_SPEC (spec);
#line 6640 "page-view.c"
}


gpointer value_get_page_view (const GValue* value) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW), NULL);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return value->data[0].v_pointer;
#line 6649 "page-view.c"
}


void value_set_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_ref (value->data[0].v_pointer);
#line 6669 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6673 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_unref (old);
#line 6679 "page-view.c"
	}
}


void value_take_page_view (GValue* value, gpointer v_object) {
	PageView* old;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	old = value->data[0].v_pointer;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (v_object) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PAGE_VIEW));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = v_object;
#line 6698 "page-view.c"
	} else {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		value->data[0].v_pointer = NULL;
#line 6702 "page-view.c"
	}
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (old) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		page_view_unref (old);
#line 6708 "page-view.c"
	}
}


static void page_view_class_init (PageViewClass * klass) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	page_view_parent_class = g_type_class_peek_parent (klass);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	PAGE_VIEW_CLASS (klass)->finalize = page_view_finalize;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_type_class_add_private (klass, sizeof (PageViewPrivate));
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_new ("size_changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_new ("changed", TYPE_PAGE_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 6724 "page-view.c"
}


static void page_view_instance_init (PageView * self) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv = PAGE_VIEW_GET_PRIVATE (self);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->image = NULL;
#line 36 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->border_width = 1;
#line 39 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->update_image = TRUE;
#line 64 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->cursor = GDK_ARROW;
#line 66 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->priv->animate_n_segments = 7;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self->ref_count = 1;
#line 6743 "page-view.c"
}


static void page_view_finalize (PageView* obj) {
	PageView * self;
	Page* _tmp0_;
	guint _tmp1_ = 0U;
	Page* _tmp2_;
	guint _tmp3_ = 0U;
	Page* _tmp4_;
	guint _tmp5_ = 0U;
	Page* _tmp6_;
	guint _tmp7_ = 0U;
	Page* _tmp8_;
	guint _tmp9_ = 0U;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PAGE_VIEW, PageView);
#line 85 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp0_ = self->priv->page;
#line 85 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_parse_name ("pixels-changed", TYPE_PAGE, &_tmp1_, NULL, FALSE);
#line 85 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp0_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _page_view_page_pixels_changed_cb_page_pixels_changed, self);
#line 86 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp2_ = self->priv->page;
#line 86 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_parse_name ("size-changed", TYPE_PAGE, &_tmp3_, NULL, FALSE);
#line 86 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _page_view_page_size_changed_cb_page_size_changed, self);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp4_ = self->priv->page;
#line 87 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_parse_name ("crop-changed", TYPE_PAGE, &_tmp5_, NULL, FALSE);
#line 87 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp4_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp5_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_crop_changed, self);
#line 88 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp6_ = self->priv->page;
#line 88 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_parse_name ("scan-line-changed", TYPE_PAGE, &_tmp7_, NULL, FALSE);
#line 88 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp6_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp7_, 0, NULL, (GCallback) _page_view_page_overlay_changed_cb_page_scan_line_changed, self);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_tmp8_ = self->priv->page;
#line 89 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_parse_name ("scan-direction-changed", TYPE_PAGE, &_tmp9_, NULL, FALSE);
#line 89 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_signal_handlers_disconnect_matched (_tmp8_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp9_, 0, NULL, (GCallback) _page_view_scan_direction_changed_cb_page_scan_direction_changed, self);
#line 29 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_page_unref0 (self->priv->page);
#line 32 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	_g_object_unref0 (self->priv->image);
#line 6795 "page-view.c"
}


GType page_view_get_type (void) {
	static volatile gsize page_view_type_id__volatile = 0;
	if (g_once_init_enter (&page_view_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_page_view_init, value_page_view_free_value, value_page_view_copy_value, value_page_view_peek_pointer, "p", value_page_view_collect_value, "p", value_page_view_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (PageViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) page_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PageView), 0, (GInstanceInitFunc) page_view_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType page_view_type_id;
		page_view_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PageView", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&page_view_type_id__volatile, page_view_type_id);
	}
	return page_view_type_id__volatile;
}


gpointer page_view_ref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	g_atomic_int_inc (&self->ref_count);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	return instance;
#line 6820 "page-view.c"
}


void page_view_unref (gpointer instance) {
	PageView* self;
	self = instance;
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		PAGE_VIEW_GET_CLASS (self)->finalize (self);
#line 26 "/home/bob/bzr/simple-scan/3.10/src/page-view.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 6833 "page-view.c"
	}
}



