#ifndef SCREEM_TAG_TREE_H
#define SCREEM_TAG_TREE_H

#include <glib/ghash.h>

#include <gtk/gtkbin.h>
#include <gtk/gtkliststore.h>

#define SCREEM_TYPE_TAG_TREE  (screem_tag_tree_get_type())
#define SCREEM_TAG_TREE(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_TYPE_TAG_TREE, \
                                                ScreemTagTree ) )
#define SCREEM_TAG_TREE_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_TYPE_TAG_TREE, \
                                                             ScreemTagTreeClass ) )
#define SCREEM_IS_TAG_TREE(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_TYPE_TAG_TREE ) )

typedef struct ScreemTagTreePrivate ScreemTagTreePrivate;

#ifndef _SCREEM_TAG_FILE_FORMAT
#define _SCREEM_TAG_FILE_FORMAT
typedef enum {
	SCREEM_TAG_UNKNOWN_FORMAT,
	SCREEM_TAG_TREE_FORMAT,
	SCREEM_TAG_WEML_FORMAT
} ScreemTagFileFormat;
#endif

typedef struct {
	GtkBin parent;
	
	ScreemTagTreePrivate *private;
} ScreemTagTree;

typedef struct {
	GtkBinClass parent_class;

} ScreemTagTreeClass;

GType screem_tag_tree_get_type( void );
ScreemTagTree *screem_tag_tree_new( void );

gboolean screem_tag_tree_load_trees( void );

GtkListStore *screem_tag_tree_get_file_model( void );

gboolean screem_tag_tree_add_uri( const gchar *uri,
				  ScreemTagFileFormat format );
void screem_tag_tree_remove_uri( const gchar *uri );

GSList *screem_tag_tree_autocomplete( const gchar *mime_type,
		const gchar *prefix, gboolean fortip );

#endif
