/* Image rollovers:
 *
 * Simple image rollover function.  Call it from in window.onload, and avoid
 * filling your html with lots of onmouseover=""" onmouseout=""
 *
 * Usage: screem_rollover( "image id", "mouseover image", "normal image" );
 */

function screem_rollover( name, over, out )
{
	if( document.images ) {
		var image;

		document.images[ name ].srcout = out;
		document.images[ name ].srcover = over;
		document.images[ name ].onmouseover = function() {
			this.src = this.srcover; 
			return false; 
		}
		document.images[ name ].onmouseout = function() { 
			this.src = this.srcout; 
			return false; 
		}
	}
}
