#ifndef STYLE_H
#define STYLE_H

#include <glib.h>

typedef struct {
	gchar *family;
	gchar *style;
	gchar *variant;
	gchar *weight;
	gchar *size;
	gchar *color;
} FontStyle;

typedef struct {
	gchar *color;
	gchar *image;
	gchar *repeat;
	gchar *attachment;
	gchar *position;
} BackStyle;

typedef struct {
	gchar *word_spacing;
	gchar *letter_spacing;
	gchar *decoration;
	gchar *vertical_align;
	gchar *transform;
	gchar *align;
	gchar *indent;
	gchar *height;
} TextStyle;

typedef struct {
	gchar *margin[ 4 ];
	gchar *padding[ 4 ];
	gchar *border_color[ 4 ];
	gchar *border_width[ 4 ];
	gchar *border_style[ 4 ];
	gchar *width;
	gchar *height;
	gchar *float_;
	gchar *clear;
} BoxStyle;

typedef struct {
	gchar *display;
	gchar *white_space;
	gchar *list_style_type;
	gchar *list_style_image;
	gchar *list_style_position;
} ClassStyle;


typedef struct {
	FontStyle  *font;
	BackStyle  *back;
	TextStyle  *text;
	BoxStyle   *box;
	ClassStyle *class;

	gchar *pattern;

	/* store any stuff we don't recognise
	   so we can output it rather than
	   just loose it */
	gchar *unknown;
} Style;

Style*      css_style_new( const gchar *pattern );
FontStyle*  css_font_style_new( void );
BackStyle*  css_back_style_new( void );
TextStyle*  css_text_style_new( void );
BoxStyle*   css_box_style_new( void );
ClassStyle* css_class_style_new( void );

void css_style_destroy( Style *style );
void css_font_style_destroy( FontStyle *style );
void css_back_style_destroy( BackStyle *style );
void css_text_style_destroy( TextStyle *style );
void css_box_style_destroy( BoxStyle *style );
void css_class_style_destroy( ClassStyle *style );

gchar* css_style_output( Style *style );
gchar* css_font_style_output( FontStyle *style );
gchar* css_back_style_output( BackStyle *style );
gchar* css_text_style_output( TextStyle *style );
gchar* css_box_style_output( BoxStyle *style );
gchar* css_class_style_output( ClassStyle *style );

void css_font_style_set( Style *style, 
			 const gchar *param,
			 const gchar *value );
void css_back_style_set( Style *style, 
			 const gchar *param,
			 const gchar *value );
void css_text_style_set( Style *style,
			 const gchar *param,
			 const gchar *value );
void css_box_style_set( Style *style,
			const gchar *param, 
			const gchar *value );
void css_class_style_set( Style *style, 
			  const gchar *param,
			  const gchar *value );

void input_style( const gchar *styleName, const gchar *styleData,
		  Style *style );

void parse_style_data( Style *style, const gchar *data );


#endif
