#include <glib.h>

#include <gtk/gtkctree.h>
#include <gtk/gtknotebook.h>

#include <libgnomeui/gnome-color-picker.h>

#include <bonobo/bonobo-ui-component.h>

#include "css-window.h"

#include "style.h"

/* per wizard struct */
typedef struct {
	ScreemCSSWindow *csswindow;

	BonoboUIComponent *ui;
} CSSWizard;

/* needs updating if the tab positions change */
typedef enum _CSSTabPos {
	CSS_FONT = 0,
	CSS_BACKGROUND = 1,
	CSS_TEXT = 2,
	CSS_BOX = 3,
	CSS_BORDER = 4,
	CSS_SIZEPLACE = 5,
	CSS_CLASSIFICATION = 6
} CSSTabPos;

typedef enum _CSSPos {
	TOP = 0,
	RIGHT = 1,
	BOTTOM = 2,
	LEFT = 3
} CSSPos;

void css_wizard_delete( GtkWidget *widget, GdkEvent *event, gpointer data );
void css_wizard_clicked( GtkWidget *widget, gint button, gpointer data );
void screem_css_dump_stylesheet( ScreemCSSWindow *window );
void screem_css_dump_style( ScreemCSSWindow *window );


void screem_css_style_selected( GtkTreeView *view, gboolean active );
gboolean screem_css_style_clicked( GtkWidget *widget, GdkEventButton *event );


void screem_css_display_style( Style* style, ScreemCSSWindow *window );

void screem_css_remove_style( GtkTreeIter *it, ScreemCSSWindow *window );

gboolean screem_css_page_switch( GtkNotebook *notebook, GtkNotebookPage *page, 
				 guint page_num );


void color_set( GnomeColorPicker *cp, guint r, guint g, guint b, guint a,
		gchar *entry );

void screem_css_new( ScreemCSSWindow *window, const gchar *pathname );
void screem_css_load( ScreemCSSWindow *window );
void screem_css_save( ScreemCSSWindow *window );
void screem_css_save_as( ScreemCSSWindow *window );

/* converts the given path to be relative to the stylesheets path */
gchar* css_relative_path( const gchar *path );

void css_parse( ScreemCSSWindow *window, GString *entireFile );
