#ifndef SCREEM_CSS_WINDOW_H
#define SCREEM_CSS_WINDOW_H

#include <bonobo/bonobo-window.h>
#include <bonobo/bonobo-ui-component.h>

#include <gtk/gtktreemodel.h>

#include <glade/glade.h>

#include "screem-window.h"
#include "screem-editor.h"
#include "screem-preview.h"

#include "gedit-recent.h"

#include "style.h"

#define SCREEM_CSS_TYPE_WINDOW  (screem_css_window_get_type())
#define SCREEM_CSS_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_CAST( ( obj ), SCREEM_CSS_TYPE_WINDOW, \
                                                ScreemCSSWindow ) )
#define SCREEM_CSS_WINDOW_CLASS(klass)  (G_TYPE_CHECK_CLASS_CAST( ( klass ), \
                                                             SCREEM_CSS_TYPE_WINDOW, \
                                                             ScreemCSSWindowClass ) )
#define SCREEM_CSS_IS_WINDOW(obj)  (G_TYPE_CHECK_INSTANCE_TYPE( ( obj ), SCREEM_CSS_TYPE_WINDOW ) )

typedef struct ScreemCSSWindow ScreemCSSWindow;


enum {
	COL_PATTERN = 0,
	COL_STYLE,
	COL_MAX
};

typedef struct {
	BonoboWindowClass parent_spot;

} ScreemCSSWindowClass;

struct ScreemCSSWindow {
	BonoboWindow parent_object;

	BonoboUIContainer *ui_container;
	BonoboUIComponent *ui;

	GladeXML *xml;
	ScreemWindow *window;
        ScreemEditor *editor;
	
	ScreemPreview *preview;

	gint current_page;
	gboolean closing;
	
	gboolean in_pseudo;

	GtkTreeModel *model;
	GeditRecent *recent_sheets;

	gchar *filename;
	
	Style *current;
};

GType  screem_css_window_get_type( void );
ScreemCSSWindow* screem_css_window_new( void );
void     screem_css_window_close( ScreemCSSWindow *window );

Bonobo_UIContainer screem_css_window_get_ui_container(ScreemCSSWindow *window);

void screem_css_window_constructed( ScreemCSSWindow *csswindow,
				    ScreemWindow *window,
				    ScreemEditor *editor );
void screem_css_window_initialise_menus( ScreemCSSWindow *window );

#endif
