#include <config.h>

#include <bonobo/bonobo-ui-util.h>
#include <bonobo/bonobo-object.h>

#include <libgnome/gnome-i18n.h>

#include <libgnomeui/gnome-about.h>
#include <libgnomeui/gnome-entry.h>

#include <gtk/gtkdialog.h>
#include <gtk/gtkentry.h>
#include <gtk/gtktreeselection.h>
#include <gtk/gtktreemodel.h>

#include "css-window.h"
#include "css.h"

#include "css-pattern.h"

static void file_menu_new_sheet_callback( BonoboUIComponent *component,
					  gpointer user_data,
					  const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_new( window, NULL );
}

static void file_menu_open_sheet_callback( BonoboUIComponent *component,
					   gpointer user_data,
					   const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_load( window );
}

static void file_menu_save_sheet_callback( BonoboUIComponent *component,
					   gpointer user_data,
					   const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_save( window );
}

static void file_menu_save_sheet_as_callback( BonoboUIComponent *component,
					      gpointer user_data,
					      const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_save_as( window );
}

static void file_menu_close_window_callback( BonoboUIComponent *component,
					     gpointer user_data,
					     const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );


	/* FIXME: get top node of tree */

	//	remove_style( ?? );

	window->closing = TRUE;
	gtk_widget_hide( GTK_WIDGET( window ) );
}

static void edit_menu_add_style_callback( BonoboUIComponent *component,
					  gpointer user_data,
					  const char *verb )
{
	ScreemCSSWindow *window;
	GtkWidget *widget;
	gint response;
	
	window = SCREEM_CSS_WINDOW( user_data );
	
	widget = screem_css_pattern_dialog();
	
	response = screem_css_run_pattern_dialog( widget );
	
	if( response == GTK_RESPONSE_OK ) {
		/* add the style */
		gchar *pattern;
		Style *style;
		
		pattern = screem_css_pattern_dialog_get( widget );
		style = css_style_new( pattern );
		screem_css_display_style( style, window );
	}
	
	gtk_widget_destroy( widget );
}

static void edit_menu_remove_style_callback( BonoboUIComponent *component,
					     gpointer user_data,
					     const char *verb )
{
	ScreemCSSWindow *window;
	GtkWidget  *tree;
	
	GtkTreeSelection *selection;
	GtkTreeModel *model;
	GtkTreeIter it;
	
	window = SCREEM_CSS_WINDOW( user_data );

	tree = glade_xml_get_widget( window->xml, "styles" );

	selection = gtk_tree_view_get_selection( GTK_TREE_VIEW(tree) );
	
	if( gtk_tree_selection_get_selected( selection, &model, &it ) ) {

		screem_css_remove_style( &it, window );
		gtk_tree_store_remove( GTK_TREE_STORE( window->model ),
				       &it );
	}
}

static void edit_menu_dump_sheet_callback( BonoboUIComponent *component,
					   gpointer user_data,
					   const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_dump_stylesheet( window );
}


static void edit_menu_dump_style_callback( BonoboUIComponent *component,
					   gpointer user_data,
					   const char *verb )
{
	ScreemCSSWindow *window;

	window = SCREEM_CSS_WINDOW( user_data );

	screem_css_dump_style( window );
}

static void
help_menu_about_cassius_callback( BonoboUIComponent *component,
				   gpointer user_data,
				   const char *verb )
{
	GtkWidget *about;

	const gchar *COPYRIGHT = "1999-2003 David A Knight";
	const gchar *AUTHORS[] = {
		"David A Knight",
		"Matt Colyer",
		NULL
	};
	const gchar *DESCRIPTION = _( "\
CaSSIUS (Casscading StyleSheet Intergration Under SCREEM)\n\
CaSSIUS provides a CSS wizard for editing stylesheets in SCREEM.\n\
Screem provides an integrated development environment for creating and maintaining websites\n\
CaSSIUS and SCREEM are licensed under the GNU General Public License version 2 or above" );
        GdkPixbuf *logo = NULL;
	const gchar *DOCUMENTERS[] = {
		"David A Knight",
		"Matt Colyer",
		NULL
	};
	const gchar *TRANSLATERS = NULL;

	logo = gdk_pixbuf_new_from_file( SPLASH_DIR"/splash.png", NULL );

	about = gnome_about_new( PACKAGE, VERSION,
				 COPYRIGHT,
				 DESCRIPTION,
				 AUTHORS,
				 DOCUMENTERS,
				 TRANSLATERS,
				 logo );
	gtk_dialog_run( GTK_DIALOG( about ) );
}



void screem_css_window_initialise_menus( ScreemCSSWindow *window )
{
	BonoboUIVerb verbs[] = {
		/* file menu */
		BONOBO_UI_VERB( "New Sheet", file_menu_new_sheet_callback ),
		BONOBO_UI_VERB( "Open Sheet", file_menu_open_sheet_callback ),
		BONOBO_UI_VERB( "Save Sheet", file_menu_save_sheet_callback ),
		BONOBO_UI_VERB( "Save Sheet As", 
				file_menu_save_sheet_as_callback ),


		BONOBO_UI_VERB( "Close Window", 
				file_menu_close_window_callback ),
		/* edit menu */
		BONOBO_UI_VERB( "Add Style",
				edit_menu_add_style_callback ),
		BONOBO_UI_VERB( "Remove Style",
				edit_menu_remove_style_callback ),
		BONOBO_UI_VERB( "Dump Sheet",
				edit_menu_dump_sheet_callback ),
		BONOBO_UI_VERB( "Dump Style",
				edit_menu_dump_style_callback ),
		
		/* help menu */
		BONOBO_UI_VERB( "About CaSSIUS",
				help_menu_about_cassius_callback ),
		BONOBO_UI_VERB_END
	};

	bonobo_ui_component_freeze( window->ui, NULL );

	bonobo_ui_component_add_verb_list_with_data( window->ui,
						     verbs, window );

	bonobo_ui_component_thaw( window->ui, NULL );
}
