/*  Screem:  css-pattern.c,
 *  Copyright (C) 2003  David A Knight
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 *  For contact information with the author of this source code please see
 *  the AUTHORS file.  If there is no AUTHORS file present then check the
 *  about box under the help menu for a contact address
 */

#include <config.h>

#include <gtk/gtkdialog.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkbox.h>
#include <gtk/gtkcontainer.h>
#include <gtk/gtkentry.h>
#include <gtk/gtkoptionmenu.h>

#include <glade/glade.h>

#include "css-pattern.h"

static void css_add_pattern( GtkWidget *widget );

GtkWidget *screem_css_pattern_dialog()
{
	GtkWidget *widget;
	GtkWidget *pattern;
	GladeXML *xml;
	GladeXML *pxml;
	
	xml = glade_xml_new( GLADE_PATH"/css.glade", "newstyle", NULL );
		
	widget = glade_xml_get_widget( xml, "patterns" );
	pxml = glade_xml_new( GLADE_PATH"/css.glade", "style_pattern", NULL );
	pattern = glade_xml_get_widget( pxml, "style_pattern" );
	gtk_box_pack_start( GTK_BOX( widget ), pattern, FALSE, FALSE, 0 );

	glade_xml_signal_autoconnect( pxml );
	glade_xml_signal_autoconnect( xml );

	widget = glade_xml_get_widget( xml, "newstyle" );
	
	return widget;
}

gint screem_css_run_pattern_dialog( GtkWidget *dialog )
{
	GtkWidget *widget;
	GladeXML *xml;
	gint response;
	
	xml = glade_get_widget_tree( dialog );
	widget = glade_xml_get_widget( xml, "patterns" );
	
	do {
		response = gtk_dialog_run( GTK_DIALOG( dialog ) );
		
		if( response == 0 ) {
			GtkWidget *remove;
			
			css_add_pattern( widget );
			remove = glade_xml_get_widget( xml, "remove" );
			gtk_widget_set_sensitive( remove, TRUE );
		} else if( response == 1 ) {
			GList *children;
			GtkWidget *child;
			gint len;
			
			children = gtk_container_get_children( GTK_CONTAINER( widget ) );
			len = g_list_length( children );
			children = g_list_last( children );
			child = GTK_WIDGET( children->data );
			gtk_container_remove( GTK_CONTAINER( widget ), child );
			if( ( len - 1 ) == 2 ) {
				child = glade_xml_get_widget( xml, "remove" );
				gtk_widget_set_sensitive( child, FALSE );
			}
		}
		
	} while( response >= 0 );
	
	return response;
}

void screem_css_pattern_dialog_fill( GtkWidget *widget, const gchar *pattern )
{
	
}

gchar *screem_css_pattern_dialog_get( GtkWidget *widget )
{
	gchar *ret;
	GList *children;
	GladeXML *xml;
	GString *temp;
	
	xml = glade_get_widget_tree( widget );
	widget = glade_xml_get_widget( xml, "patterns" );
	
	children = gtk_container_get_children( GTK_CONTAINER( widget ) );
	temp = g_string_new( "" );
	
	for( children = children->next; children; children = children->next ) {
		GtkWidget *child;
		gint i;

		child = GTK_WIDGET( children->data );
		
		/* child is a "style_pattern" from a separate GladeXML object */
		xml = glade_get_widget_tree( child );
	
		child = glade_xml_get_widget( xml, "extra_menu" );
		/* if extra menu is visible handle it */
		if( GTK_WIDGET_VISIBLE( child ) ) {
			i = gtk_option_menu_get_history( GTK_OPTION_MENU( child ) );
			switch( i ) {
				case 0:
					g_string_append( temp, ", " );
					break;
				case 1:
					g_string_append( temp, " " );
					break;
				case 2:
					g_string_append( temp, " > " );
					break;
				case 3:
					g_string_append( temp, " + " );
					break;
				default:
					g_assert( FALSE );
					break;
			}
		}
		child = glade_xml_get_widget( xml, "selector_type" );
		i = gtk_option_menu_get_history( GTK_OPTION_MENU( child ) );
		switch( i ) {
			case 0:
				break;
			case 1:
				g_string_append_c( temp, '.' );
				break;
			case 2:
				g_string_append_c( temp, '#' );
				break;
			default:
				g_assert( FALSE );
				break;
		}
		child = glade_xml_get_widget( xml, "selector" );
		g_string_append( temp, 
				 gtk_entry_get_text( GTK_ENTRY( child ) ) );
		child = glade_xml_get_widget( xml, "pseudo_type" );
		i = gtk_option_menu_get_history( GTK_OPTION_MENU( child ) );
		child = glade_xml_get_widget( xml, "pseudo" );
		switch( i ) {
			case 0:
				break;
			case 1:
				g_string_append_c( temp, ':' );
				g_string_append( temp,
						gtk_entry_get_text( GTK_ENTRY( child ) ) );
				break;
			case 2:
				g_string_append_c( temp, '[' );
				g_string_append( temp,
						gtk_entry_get_text( GTK_ENTRY( child ) ) );
				g_string_append_c( temp, ']' );
				break;
			default:
				g_assert( FALSE );
				break;
		}
	}
	
	ret = temp->str;
	if( *ret == '\0' ) {
		ret = NULL;
	}
	g_string_free( temp, ( ret == NULL ) );
	
	return ret;
}

static void css_add_pattern( GtkWidget *widget )
{
	GladeXML *xml;
	
	GtkWidget *pattern;
		
	xml = glade_xml_new( GLADE_PATH"/css.glade", "style_pattern", NULL );
	pattern = glade_xml_get_widget( xml, "style_pattern" );
	gtk_box_pack_start( GTK_BOX( widget ), pattern, FALSE, FALSE, 0 );
	widget = glade_xml_get_widget( xml, "extra_menu" );
	gtk_widget_show( widget );
	glade_xml_signal_autoconnect( xml );
}

void css_pattern_pseudo_type_change( GtkWidget *widget )
{
	GladeXML *xml;
	gint i;
	
	xml = glade_get_widget_tree( widget );
	
	i = gtk_option_menu_get_history( GTK_OPTION_MENU( widget ) );
	
	widget = glade_xml_get_widget( xml, "pseudo_combo" );
	gtk_widget_set_sensitive( widget, ( i != 0 ) );	
}
