#ifndef SUPPORT_H
#define SUPPORT_H

#include <gtk/gtkwidget.h>
#include <gtk/gtkliststore.h>

void change_state( GtkWidget *widget, gpointer data );
void change_visible( GtkWidget *widget, gpointer data );

char * convert_keysym_state_to_string( guint keysym, guint state );

gchar *screem_support_ctags( const gchar *dirname, const gchar *word,
			     gchar **pattern );
gchar *screem_support_escape_regexp( const gchar *pattern );;

GtkTreeIter *screem_support_find_in_list( GtkListStore *store, 
					  guint column, const gchar *str );

gchar *screem_support_charset_convert( const gchar *data );
gchar *screem_support_charset_convert_to( const gchar *data, 
					const gchar *charset );

gchar *screem_get_mime_type( const gchar *filename );
gchar *screem_get_mime_type_override( const gchar *filename,
					const gchar *type ); 

const gchar *g_utf8_skip_space( const gchar *txt );
const gchar *screem_utf8_skip_to_space( const gchar *txt );
	
gchar* screem_escape_underlines( const gchar* text );

gboolean screem_execute_default_app( const gchar *uri );

void g_string_append_utf8_len( GString *str, const gchar *utf8,
				guint len );
GtkPositionType screem_get_tab_position( void );

#endif
