#ifndef SCREEM_PLUGIN_H
#define SCREEM_PLUGIN_H

#include <gmodule.h>

#include <gtk/gtkmenuitem.h>
#include <gtk/gtkwidget.h>

#include "screem-application.h"
#include "screem-window.h"

#ifndef SCREEM_PLUGIN
#define SCREEM_PLUGIN
typedef struct ScreemPlugin ScreemPlugin;
#endif

typedef void(*Popup)( ScreemWindow *window,
		      guint start, guint len, GSList *attrs );


typedef void(*AddUI)( GtkWidget *window, GtkWidget *editor,
		      GtkWidget *preview, GtkWidget *link_view );
/* the fields of this struct are to be filled out in
   the plugin, apart from module */
struct  ScreemPlugin {
	const gchar *name;    /* the plugin name */
	const gchar *author;  /* the plugin author */
	const gchar *version; /* the plugin version */

	GModule *module;      /* the actual plugin */
	const gchar *tag;     /* the tag that the plugin deals with,
			         NULL if no specific tag is handled */
	
	Popup popup;          /* called from the popup editor menu,
				 only used if tag != NULL */
	AddUI add_ui;         /* called when a new ScreemWindow is opened */
	AddUI remove_ui;      /* called when a ScreemWindow is closed,
				 only window is passed at the moment,
				 other params will be NULL */
};

void scan_plugins( ScreemApplication *application, GtkWidget *splash_text );
GModule *screem_plugin_get_sitecopy( ScreemApplication *application );
GtkWidget *screem_plugin_tag_wizard( ScreemApplication *application,
				     ScreemWindow *window,
				     const gchar *tag, const gchar *fulltag,
				     guint start, guint len );

#endif
