#ifndef SCREEM_MDI_H
#define SCREEM_MDI_H

#include <glib-object.h>

#include <gtk/gtknotebook.h>
#include <glib/glist.h>

#include "screem-page.h"
#include "screem-window.h"

#define SCREEM_TYPE_MDI            (screem_mdi_get_type ())
#define SCREEM_MDI(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_MDI, ScreemMDI))
#define SCREEM_MDI_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_MDI, ScreemMDIClass))
#define SCREEM_IS_MDI(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_MDI))

typedef struct ScreemMDIPrivate ScreemMDIPrivate;

typedef struct  {
	GObject parent;

	ScreemMDIPrivate *priv;
} ScreemMDI;

typedef struct {
        GObjectClass parent_class;

	void (*changed)( ScreemMDI *mdi, ScreemPage *current );
	
} ScreemMDIClass;

ScreemMDI *screem_mdi_new( ScreemWindow *window );
GType screem_mdi_get_type( void );

GtkNotebook *screem_mdi_get_notebook( ScreemMDI *mdi );
GList *screem_mdi_get_document_list( ScreemMDI *mdi );
ScreemPage *screem_mdi_get_current( ScreemMDI *mdi );
void screem_mdi_remove_document( ScreemMDI *mdi, ScreemPage *page );
void screem_mdi_remove_all( ScreemMDI *mdi );
gboolean screem_mdi_set_current( ScreemMDI *mdi, ScreemPage *page );
gboolean screem_mdi_add_document( ScreemMDI *mdi, ScreemPage *page );

#endif
