#ifndef SCREEM_LINK_VIEW_IMAGE_H
#define SCREEM_LINK_VIEW_IMAGE_H

#include <glib-object.h>

#include "screem-linkview-util.h"

#define SCREEM_TYPE_LINK_VIEW_IMAGE (screem_link_view_image_get_type())
#define SCREEM_LINK_VIEW_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST( (obj), SCREEM_TYPE_LINK_VIEW_IMAGE, ScreemLinkViewImage ) )
#define SCREEM_IS_LINK_VIEW_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE( (obj), SCREEM_TYPE_LINK_VIEW_IMAGE ) )

typedef struct ScreemLinkViewImage ScreemLinkViewImage;

struct ScreemLinkViewImage{
	GObject parent;

	gchar* name;		/* Realtive Filename from the base node */
	gchar* filename;        /* Full File Name */
	gboolean external; 	/* Is it remote or local? */
	gboolean exists; 	/* Is it dead or not? */
	gboolean excluded;	/* is the page marked for upload?*/
	double filesize; 	/* Filesize in bytes */
	SyncStatus uploadStatus; /* What the upload status is */
	ScreemLinkViewImage* next;      /* pointer to the next image*/
};

typedef struct {
	GObjectClass parent_class;
} ScreemLinkViewImageClass;

GType screem_link_view_image_get_type( void );
ScreemLinkViewImage *screem_link_view_image_new( const gchar *pathname );


#endif
