#ifndef SCREEM_CVS_H
#define SCREEM_CVS_H

#include <glib-object.h>

#include "screem-window.h"
#include "screem-helper.h"

#define SCREEM_TYPE_CVS            (screem_cvs_get_type ())
#define SCREEM_CVS(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), SCREEM_TYPE_CVS, ScreemCVS))
#define SCREEM_CVS_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), SCREEM_TYPE_CVS, ScreemCVSClass))
#define SCREEM_IS_CVS(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SCREEM_TYPE_CVS))


typedef struct ScreemCVSPrivate ScreemCVSPrivate;

typedef struct {
	ScreemHelper parent;

	ScreemCVSPrivate *private;
} ScreemCVS;

typedef struct {
	ScreemHelperClass parent_class;
} ScreemCVSClass;


GType screem_cvs_get_type( void );

ScreemCVS* screem_cvs_new( ScreemWindow *window );

/* pathname can be NULL to use the preset base path */
void screem_cvs_commit( ScreemCVS *cvs, const gchar *pathname,
			const gchar *extra_flags, const gchar *log_text );
void screem_cvs_update( ScreemCVS *cvs, const gchar *pathname,
			const gchar *extra_flags );

void screem_cvs_delete( ScreemCVS *cvs, const gchar *pathname,
			const gchar *extra_flags );
void screem_cvs_add( ScreemCVS *cvs, const gchar *pathname,
		     const gchar *extra_flags, const gchar *log_text );

void screem_cvs_checkout( ScreemCVS *cvs,
			  const gchar *extra_flags, const gchar *module );
void screem_cvs_import( ScreemCVS *cvs,
			const gchar *extra_flags, const gchar *log_text,
			const gchar *module );

#endif
