/* Generated by re2c */
/*
   +----------------------------------------------------------------------+
   | Zend Engine                                                          |
   +----------------------------------------------------------------------+
   | Copyright (c) 1998-2014 Zend Technologies Ltd. (http://www.zend.com) |
   +----------------------------------------------------------------------+
   | This source file is subject to version 2.00 of the Zend license,     |
   | that is bundled with this package in the file LICENSE, and is        |
   | available through the world-wide-web at the following url:           |
   | http://www.zend.com/license/2_00.txt.                                |
   | If you did not receive a copy of the Zend license and are unable to  |
   | obtain it through the world-wide-web, please send a note to          |
   | license@zend.com so we can mail you a copy immediately.              |
   +----------------------------------------------------------------------+
   | Authors: Marcus Boerger <helly@php.net>                              |
   |          Nuno Lopes <nlopess@php.net>                                |
   |          Scott MacVicar <scottmac@php.net>                           |
   | Flex version authors:                                                |
   |          Andi Gutmans <andi@zend.com>                                |
   |          Zeev Suraski <zeev@zend.com>                                |
   +----------------------------------------------------------------------+
*/

/* $Id$ */

#if 0
# define YYDEBUG(s, c) printf("state: %d char: %c\n", s, c)
#else
# define YYDEBUG(s, c)
#endif

#include "zend_language_scanner_defs.h"

#include <errno.h>
#include "zend.h"
#ifdef PHP_WIN32
# include <Winuser.h>
#endif
#include "zend_alloc.h"
#include <zend_language_parser.h>
#include "zend_compile.h"
#include "zend_language_scanner.h"
#include "zend_highlight.h"
#include "zend_constants.h"
#include "zend_variables.h"
#include "zend_operators.h"
#include "zend_API.h"
#include "zend_strtod.h"
#include "zend_exceptions.h"
#include "tsrm_virtual_cwd.h"
#include "tsrm_config_common.h"

#define YYCTYPE   unsigned char
#define YYFILL(n) { if ((YYCURSOR + n) >= (YYLIMIT + ZEND_MMAP_AHEAD)) { return 0; } }
#define YYCURSOR  SCNG(yy_cursor)
#define YYLIMIT   SCNG(yy_limit)
#define YYMARKER  SCNG(yy_marker)

#define YYGETCONDITION()  SCNG(yy_state)
#define YYSETCONDITION(s) SCNG(yy_state) = s

#define STATE(name)  yyc##name

/* emulate flex constructs */
#define BEGIN(state) YYSETCONDITION(STATE(state))
#define YYSTATE      YYGETCONDITION()
#define yytext       ((char*)SCNG(yy_text))
#define yyleng       SCNG(yy_leng)
#define yyless(x)    do { YYCURSOR = (unsigned char*)yytext + x; \
                          yyleng   = (unsigned int)x; } while(0)
#define yymore()     goto yymore_restart

/* perform sanity check. If this message is triggered you should
   increase the ZEND_MMAP_AHEAD value in the zend_streams.h file */
#define YYMAXFILL 16

#if ZEND_MMAP_AHEAD < YYMAXFILL
# error ZEND_MMAP_AHEAD should be greater than or equal to YYMAXFILL
#endif

#ifdef HAVE_STDARG_H
# include <stdarg.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

/* Globals Macros */
#define SCNG	LANG_SCNG
#ifdef ZTS
ZEND_API ts_rsrc_id language_scanner_globals_id;
#else
ZEND_API zend_php_scanner_globals language_scanner_globals;
#endif

#define HANDLE_NEWLINES(s, l)													\
do {																			\
	char *p = (s), *boundary = p+(l);											\
																				\
	while (p<boundary) {														\
		if (*p == '\n' || (*p == '\r' && (*(p+1) != '\n'))) {					\
			CG(zend_lineno)++;													\
		}																		\
		p++;																	\
	}																			\
} while (0)

#define HANDLE_NEWLINE(c) \
{ \
	if (c == '\n' || c == '\r') { \
		CG(zend_lineno)++; \
	} \
}

/* To save initial string length after scanning to first variable, CG(doc_comment_len) can be reused */
#define SET_DOUBLE_QUOTES_SCANNED_LENGTH(len) CG(doc_comment_len) = (len)
#define GET_DOUBLE_QUOTES_SCANNED_LENGTH()    CG(doc_comment_len)

#define IS_LABEL_START(c) (((c) >= 'a' && (c) <= 'z') || ((c) >= 'A' && (c) <= 'Z') || (c) == '_' || (c) >= 0x7F)

#define ZEND_IS_OCT(c)  ((c)>='0' && (c)<='7')
#define ZEND_IS_HEX(c)  (((c)>='0' && (c)<='9') || ((c)>='a' && (c)<='f') || ((c)>='A' && (c)<='F'))

BEGIN_EXTERN_C()

static size_t encoding_filter_script_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, internal_encoding, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_script_to_intermediate(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length, zend_multibyte_encoding_utf8, LANG_SCNG(script_encoding) TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_script(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
LANG_SCNG(script_encoding), zend_multibyte_encoding_utf8 TSRMLS_CC);
}

static size_t encoding_filter_intermediate_to_internal(unsigned char **to, size_t *to_length, const unsigned char *from, size_t from_length TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	assert(internal_encoding && zend_multibyte_check_lexer_compatibility(internal_encoding));
	return zend_multibyte_encoding_converter(to, to_length, from, from_length,
internal_encoding, zend_multibyte_encoding_utf8 TSRMLS_CC);
}


static void _yy_push_state(int new_state TSRMLS_DC)
{
	zend_stack_push(&SCNG(state_stack), (void *) &YYGETCONDITION(), sizeof(int));
	YYSETCONDITION(new_state);
}

#define yy_push_state(state_and_tsrm) _yy_push_state(yyc##state_and_tsrm)

static void yy_pop_state(TSRMLS_D)
{
	int *stack_state;
	zend_stack_top(&SCNG(state_stack), (void **) &stack_state);
	YYSETCONDITION(*stack_state);
	zend_stack_del_top(&SCNG(state_stack));
}

static void yy_scan_buffer(char *str, unsigned int len TSRMLS_DC)
{
	YYCURSOR       = (YYCTYPE*)str;
	YYLIMIT        = YYCURSOR + len;
	if (!SCNG(yy_start)) {
		SCNG(yy_start) = YYCURSOR;
	}
}

void startup_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	CG(doc_comment) = NULL;
	CG(doc_comment_len) = 0;
	zend_stack_init(&SCNG(state_stack));
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));
}

static void heredoc_label_dtor(zend_heredoc_label *heredoc_label) {
    efree(heredoc_label->label);
}

void shutdown_scanner(TSRMLS_D)
{
	CG(parse_error) = 0;
	RESET_DOC_COMMENT();
	zend_stack_destroy(&SCNG(state_stack));
	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
}

ZEND_API void zend_save_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	lex_state->yy_leng   = SCNG(yy_leng);
	lex_state->yy_start  = SCNG(yy_start);
	lex_state->yy_text   = SCNG(yy_text);
	lex_state->yy_cursor = SCNG(yy_cursor);
	lex_state->yy_marker = SCNG(yy_marker);
	lex_state->yy_limit  = SCNG(yy_limit);

	lex_state->state_stack = SCNG(state_stack);
	zend_stack_init(&SCNG(state_stack));

	lex_state->heredoc_label_stack = SCNG(heredoc_label_stack);
	zend_ptr_stack_init(&SCNG(heredoc_label_stack));

	lex_state->in = SCNG(yy_in);
	lex_state->yy_state = YYSTATE;
	lex_state->filename = zend_get_compiled_filename(TSRMLS_C);
	lex_state->lineno = CG(zend_lineno);

	lex_state->script_org = SCNG(script_org);
	lex_state->script_org_size = SCNG(script_org_size);
	lex_state->script_filtered = SCNG(script_filtered);
	lex_state->script_filtered_size = SCNG(script_filtered_size);
	lex_state->input_filter = SCNG(input_filter);
	lex_state->output_filter = SCNG(output_filter);
	lex_state->script_encoding = SCNG(script_encoding);
}

ZEND_API void zend_restore_lexical_state(zend_lex_state *lex_state TSRMLS_DC)
{
	SCNG(yy_leng)   = lex_state->yy_leng;
	SCNG(yy_start)  = lex_state->yy_start;
	SCNG(yy_text)   = lex_state->yy_text;
	SCNG(yy_cursor) = lex_state->yy_cursor;
	SCNG(yy_marker) = lex_state->yy_marker;
	SCNG(yy_limit)  = lex_state->yy_limit;

	zend_stack_destroy(&SCNG(state_stack));
	SCNG(state_stack) = lex_state->state_stack;

	zend_ptr_stack_clean(&SCNG(heredoc_label_stack), (void (*)(void *)) &heredoc_label_dtor, 1);
	zend_ptr_stack_destroy(&SCNG(heredoc_label_stack));
	SCNG(heredoc_label_stack) = lex_state->heredoc_label_stack;

	SCNG(yy_in) = lex_state->in;
	YYSETCONDITION(lex_state->yy_state);
	CG(zend_lineno) = lex_state->lineno;
	zend_restore_compiled_filename(lex_state->filename TSRMLS_CC);

	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	SCNG(script_org) = lex_state->script_org;
	SCNG(script_org_size) = lex_state->script_org_size;
	SCNG(script_filtered) = lex_state->script_filtered;
	SCNG(script_filtered_size) = lex_state->script_filtered_size;
	SCNG(input_filter) = lex_state->input_filter;
	SCNG(output_filter) = lex_state->output_filter;
	SCNG(script_encoding) = lex_state->script_encoding;

	RESET_DOC_COMMENT();
}

ZEND_API void zend_destroy_file_handle(zend_file_handle *file_handle TSRMLS_DC)
{
	zend_llist_del_element(&CG(open_files), file_handle, (int (*)(void *, void *)) zend_compare_file_handles);
	/* zend_file_handle_dtor() operates on the copy, so we have to NULLify the original here */
	file_handle->opened_path = NULL;
	if (file_handle->free_filename) {
		file_handle->filename = NULL;
	}
}

#define BOM_UTF32_BE	"\x00\x00\xfe\xff"
#define	BOM_UTF32_LE	"\xff\xfe\x00\x00"
#define	BOM_UTF16_BE	"\xfe\xff"
#define	BOM_UTF16_LE	"\xff\xfe"
#define	BOM_UTF8		"\xef\xbb\xbf"

static const zend_encoding *zend_multibyte_detect_utf_encoding(const unsigned char *script, size_t script_size TSRMLS_DC)
{
	const unsigned char *p;
	int wchar_size = 2;
	int le = 0;

	/* utf-16 or utf-32? */
	p = script;
	while ((p-script) < script_size) {
		p = memchr(p, 0, script_size-(p-script)-2);
		if (!p) {
			break;
		}
		if (*(p+1) == '\0' && *(p+2) == '\0') {
			wchar_size = 4;
			break;
		}

		/* searching for UTF-32 specific byte orders, so this will do */
		p += 4;
	}

	/* BE or LE? */
	p = script;
	while ((p-script) < script_size) {
		if (*p == '\0' && *(p+wchar_size-1) != '\0') {
			/* BE */
			le = 0;
			break;
		} else if (*p != '\0' && *(p+wchar_size-1) == '\0') {
			/* LE* */
			le = 1;
			break;
		}
		p += wchar_size;
	}

	if (wchar_size == 2) {
		return le ? zend_multibyte_encoding_utf16le : zend_multibyte_encoding_utf16be;
	} else {
		return le ? zend_multibyte_encoding_utf32le : zend_multibyte_encoding_utf32be;
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_detect_unicode(TSRMLS_D)
{
	const zend_encoding *script_encoding = NULL;
	int bom_size;
	unsigned char *pos1, *pos2;

	if (LANG_SCNG(script_org_size) < sizeof(BOM_UTF32_LE)-1) {
		return NULL;
	}

	/* check out BOM */
	if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_BE, sizeof(BOM_UTF32_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32be;
		bom_size = sizeof(BOM_UTF32_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF32_LE, sizeof(BOM_UTF32_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf32le;
		bom_size = sizeof(BOM_UTF32_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_BE, sizeof(BOM_UTF16_BE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16be;
		bom_size = sizeof(BOM_UTF16_BE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF16_LE, sizeof(BOM_UTF16_LE)-1)) {
		script_encoding = zend_multibyte_encoding_utf16le;
		bom_size = sizeof(BOM_UTF16_LE)-1;
	} else if (!memcmp(LANG_SCNG(script_org), BOM_UTF8, sizeof(BOM_UTF8)-1)) {
		script_encoding = zend_multibyte_encoding_utf8;
		bom_size = sizeof(BOM_UTF8)-1;
	}

	if (script_encoding) {
		/* remove BOM */
		LANG_SCNG(script_org) += bom_size;
		LANG_SCNG(script_org_size) -= bom_size;

		return script_encoding;
	}

	/* script contains NULL bytes -> auto-detection */
	if ((pos1 = memchr(LANG_SCNG(script_org), 0, LANG_SCNG(script_org_size)))) {
		/* check if the NULL byte is after the __HALT_COMPILER(); */
		pos2 = LANG_SCNG(script_org);

		while (pos1 - pos2 >= sizeof("__HALT_COMPILER();")-1) {
			pos2 = memchr(pos2, '_', pos1 - pos2);
			if (!pos2) break;
			pos2++;
			if (strncasecmp((char*)pos2, "_HALT_COMPILER", sizeof("_HALT_COMPILER")-1) == 0) {
				pos2 += sizeof("_HALT_COMPILER")-1;
				while (*pos2 == ' '  ||
					   *pos2 == '\t' ||
					   *pos2 == '\r' ||
					   *pos2 == '\n') {
					pos2++;
				}
				if (*pos2 == '(') {
					pos2++;
					while (*pos2 == ' '  ||
						   *pos2 == '\t' ||
						   *pos2 == '\r' ||
						   *pos2 == '\n') {
						pos2++;
					}
					if (*pos2 == ')') {
						pos2++;
						while (*pos2 == ' '  ||
							   *pos2 == '\t' ||
							   *pos2 == '\r' ||
							   *pos2 == '\n') {
							pos2++;
						}
						if (*pos2 == ';') {
							return NULL;
						}
					}
				}
			}
		}
		/* make best effort if BOM is missing */
		return zend_multibyte_detect_utf_encoding(LANG_SCNG(script_org), LANG_SCNG(script_org_size) TSRMLS_CC);
	}

	return NULL;
}

static const zend_encoding* zend_multibyte_find_script_encoding(TSRMLS_D)
{
	const zend_encoding *script_encoding;

	if (CG(detect_unicode)) {
		/* check out bom(byte order mark) and see if containing wchars */
		script_encoding = zend_multibyte_detect_unicode(TSRMLS_C);
		if (script_encoding != NULL) {
			/* bom or wchar detection is prior to 'script_encoding' option */
			return script_encoding;
		}
	}

	/* if no script_encoding specified, just leave alone */
	if (!CG(script_encoding_list) || !CG(script_encoding_list_size)) {
		return NULL;
	}

	/* if multiple encodings specified, detect automagically */
	if (CG(script_encoding_list_size) > 1) {
		return zend_multibyte_encoding_detector(LANG_SCNG(script_org), LANG_SCNG(script_org_size), CG(script_encoding_list), CG(script_encoding_list_size) TSRMLS_CC);
	}

	return CG(script_encoding_list)[0];
}

ZEND_API int zend_multibyte_set_filter(const zend_encoding *onetime_encoding TSRMLS_DC)
{
	const zend_encoding *internal_encoding = zend_multibyte_get_internal_encoding(TSRMLS_C);
	const zend_encoding *script_encoding = onetime_encoding ? onetime_encoding: zend_multibyte_find_script_encoding(TSRMLS_C);

	if (!script_encoding) {
		return FAILURE;
	}

	/* judge input/output filter */
	LANG_SCNG(script_encoding) = script_encoding;
	LANG_SCNG(input_filter) = NULL;
	LANG_SCNG(output_filter) = NULL;

	if (!internal_encoding || LANG_SCNG(script_encoding) == internal_encoding) {
		if (!zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
			/* and if not, work around w/ script_encoding -> utf-8 -> script_encoding conversion */
			LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
			LANG_SCNG(output_filter) = encoding_filter_intermediate_to_script;
		} else {
			LANG_SCNG(input_filter) = NULL;
			LANG_SCNG(output_filter) = NULL;
		}
		return SUCCESS;
	}

	if (zend_multibyte_check_lexer_compatibility(internal_encoding)) {
		LANG_SCNG(input_filter) = encoding_filter_script_to_internal;
		LANG_SCNG(output_filter) = NULL;
	} else if (zend_multibyte_check_lexer_compatibility(LANG_SCNG(script_encoding))) {
		LANG_SCNG(input_filter) = NULL;
		LANG_SCNG(output_filter) = encoding_filter_script_to_internal;
	} else {
		/* both script and internal encodings are incompatible w/ flex */
		LANG_SCNG(input_filter) = encoding_filter_script_to_intermediate;
		LANG_SCNG(output_filter) = encoding_filter_intermediate_to_internal;
	}

	return 0;
}

ZEND_API int open_file_for_scanning(zend_file_handle *file_handle TSRMLS_DC)
{
	const char *file_path = NULL;
	char *buf;
	size_t size, offset = 0;

	/* The shebang line was read, get the current position to obtain the buffer start */
	if (CG(start_lineno) == 2 && file_handle->type == ZEND_HANDLE_FP && file_handle->handle.fp) {
		if ((offset = ftell(file_handle->handle.fp)) == -1) {
			offset = 0;
		}
	}

	if (zend_stream_fixup(file_handle, &buf, &size TSRMLS_CC) == FAILURE) {
		return FAILURE;
	}

	zend_llist_add_element(&CG(open_files), file_handle);
	if (file_handle->handle.stream.handle >= (void*)file_handle && file_handle->handle.stream.handle <= (void*)(file_handle+1)) {
		zend_file_handle *fh = (zend_file_handle*)zend_llist_get_last(&CG(open_files));
		size_t diff = (char*)file_handle->handle.stream.handle - (char*)file_handle;
		fh->handle.stream.handle = (void*)(((char*)fh) + diff);
		file_handle->handle.stream.handle = fh->handle.stream.handle;
	}

	/* Reset the scanner for scanning the new file */
	SCNG(yy_in) = file_handle;
	SCNG(yy_start) = NULL;

	if (size != -1) {
		if (CG(multibyte)) {
			SCNG(script_org) = (unsigned char*)buf;
			SCNG(script_org_size) = size;
			SCNG(script_filtered) = NULL;

			zend_multibyte_set_filter(NULL TSRMLS_CC);

			if (SCNG(input_filter)) {
				if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
					zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
							"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
				}
				buf = (char*)SCNG(script_filtered);
				size = SCNG(script_filtered_size);
			}
		}
		SCNG(yy_start) = (unsigned char *)buf - offset;
		yy_scan_buffer(buf, size TSRMLS_CC);
	} else {
		zend_error_noreturn(E_COMPILE_ERROR, "zend_stream_mmap() failed");
	}

	BEGIN(INITIAL);

	if (file_handle->opened_path) {
		file_path = file_handle->opened_path;
	} else {
		file_path = file_handle->filename;
	}

	zend_set_compiled_filename(file_path TSRMLS_CC);

	if (CG(start_lineno)) {
		CG(zend_lineno) = CG(start_lineno);
		CG(start_lineno) = 0;
	} else {
		CG(zend_lineno) = 1;
	}

	RESET_DOC_COMMENT();
	CG(increment_lineno) = 0;
	return SUCCESS;
}
END_EXTERN_C()


ZEND_API zend_op_array *compile_file(zend_file_handle *file_handle, int type TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval=NULL;
	int compiler_result;
	zend_bool compilation_successful=0;
	znode retval_znode;
	zend_bool original_in_compilation = CG(in_compilation);

	retval_znode.op_type = IS_CONST;
	retval_znode.u.constant.type = IS_LONG;
	retval_znode.u.constant.value.lval = 1;
	Z_UNSET_ISREF(retval_znode.u.constant);
	Z_SET_REFCOUNT(retval_znode.u.constant, 1);

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);

	retval = op_array; /* success oriented */

	if (open_file_for_scanning(file_handle TSRMLS_CC)==FAILURE) {
		if (type==ZEND_REQUIRE) {
			zend_message_dispatcher(ZMSG_FAILED_REQUIRE_FOPEN, file_handle->filename TSRMLS_CC);
			zend_bailout();
		} else {
			zend_message_dispatcher(ZMSG_FAILED_INCLUDE_FOPEN, file_handle->filename TSRMLS_CC);
		}
		compilation_successful=0;
	} else {
		init_op_array(op_array, ZEND_USER_FUNCTION, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(in_compilation) = 1;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		compiler_result = zendparse(TSRMLS_C);
		zend_do_return(&retval_znode, 0 TSRMLS_CC);
		CG(in_compilation) = original_in_compilation;
		if (compiler_result != 0) { /* parser error */
			zend_bailout();
		}
		compilation_successful=1;
	}

	if (retval) {
		CG(active_op_array) = original_active_op_array;
		if (compilation_successful) {
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
		} else {
			efree(op_array);
			retval = NULL;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return retval;
}


zend_op_array *compile_filename(int type, zval *filename TSRMLS_DC)
{
	zend_file_handle file_handle;
	zval tmp;
	zend_op_array *retval;
	char *opened_path = NULL;

	if (filename->type != IS_STRING) {
		tmp = *filename;
		zval_copy_ctor(&tmp);
		convert_to_string(&tmp);
		filename = &tmp;
	}
	file_handle.filename = filename->value.str.val;
	file_handle.free_filename = 0;
	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.opened_path = NULL;
	file_handle.handle.fp = NULL;

	retval = zend_compile_file(&file_handle, type TSRMLS_CC);
	if (retval && file_handle.handle.stream.handle) {
		int dummy = 1;

		if (!file_handle.opened_path) {
			file_handle.opened_path = opened_path = estrndup(filename->value.str.val, filename->value.str.len);
		}

		zend_hash_add(&EG(included_files), file_handle.opened_path, strlen(file_handle.opened_path)+1, (void *)&dummy, sizeof(int), NULL);

		if (opened_path) {
			efree(opened_path);
		}
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);

	if (filename==&tmp) {
		zval_dtor(&tmp);
	}
	return retval;
}

ZEND_API int zend_prepare_string_for_scanning(zval *str, char *filename TSRMLS_DC)
{
	char *buf;
	size_t size;

	/* enforce two trailing NULLs for flex... */
	if (IS_INTERNED(str->value.str.val)) {
		char *tmp = safe_emalloc(1, str->value.str.len, ZEND_MMAP_AHEAD);
		memcpy(tmp, str->value.str.val, str->value.str.len + ZEND_MMAP_AHEAD);
		str->value.str.val = tmp;
	} else {
		str->value.str.val = safe_erealloc(str->value.str.val, 1, str->value.str.len, ZEND_MMAP_AHEAD);
	}

	memset(str->value.str.val + str->value.str.len, 0, ZEND_MMAP_AHEAD);

	SCNG(yy_in) = NULL;
	SCNG(yy_start) = NULL;

	buf = str->value.str.val;
	size = str->value.str.len;

	if (CG(multibyte)) {
		SCNG(script_org) = (unsigned char*)buf;
		SCNG(script_org_size) = size;
		SCNG(script_filtered) = NULL;

		zend_multibyte_set_filter(zend_multibyte_get_internal_encoding(TSRMLS_C) TSRMLS_CC);

		if (SCNG(input_filter)) {
			if ((size_t)-1 == SCNG(input_filter)(&SCNG(script_filtered), &SCNG(script_filtered_size), SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
				zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
						"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
			}
			buf = (char*)SCNG(script_filtered);
			size = SCNG(script_filtered_size);
		}
	}

	yy_scan_buffer(buf, size TSRMLS_CC);

	zend_set_compiled_filename(filename TSRMLS_CC);
	CG(zend_lineno) = 1;
	CG(increment_lineno) = 0;
	RESET_DOC_COMMENT();
	return SUCCESS;
}


ZEND_API size_t zend_get_scanned_file_offset(TSRMLS_D)
{
	size_t offset = SCNG(yy_cursor) - SCNG(yy_start);
	if (SCNG(input_filter)) {
		size_t original_offset = offset, length = 0;
		do {
			unsigned char *p = NULL;
			if ((size_t)-1 == SCNG(input_filter)(&p, &length, SCNG(script_org), offset TSRMLS_CC)) {
				return (size_t)-1;
			}
			efree(p);
			if (length > original_offset) {
				offset--;
			} else if (length < original_offset) {
				offset++;
			}
		} while (original_offset != length);
	}
	return offset;
}


zend_op_array *compile_string(zval *source_string, char *filename TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_op_array *op_array = (zend_op_array *) emalloc(sizeof(zend_op_array));
	zend_op_array *original_active_op_array = CG(active_op_array);
	zend_op_array *retval;
	zval tmp;
	int compiler_result;
	zend_bool original_in_compilation = CG(in_compilation);

	if (source_string->value.str.len==0) {
		efree(op_array);
		return NULL;
	}

	CG(in_compilation) = 1;

	tmp = *source_string;
	zval_copy_ctor(&tmp);
	convert_to_string(&tmp);
	source_string = &tmp;

	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(source_string, filename TSRMLS_CC)==FAILURE) {
		efree(op_array);
		retval = NULL;
	} else {
		zend_bool orig_interactive = CG(interactive);

		CG(interactive) = 0;
		init_op_array(op_array, ZEND_EVAL_CODE, INITIAL_OP_ARRAY_SIZE TSRMLS_CC);
		CG(interactive) = orig_interactive;
		CG(active_op_array) = op_array;
		zend_stack_push(&CG(context_stack), (void *) &CG(context), sizeof(CG(context)));
		zend_init_compiler_context(TSRMLS_C);
		BEGIN(ST_IN_SCRIPTING);
		compiler_result = zendparse(TSRMLS_C);

		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}

		if (compiler_result != 0) {
			CG(active_op_array) = original_active_op_array;
			CG(unclean_shutdown)=1;
			destroy_op_array(op_array TSRMLS_CC);
			efree(op_array);
			retval = NULL;
		} else {
			zend_do_return(NULL, 0 TSRMLS_CC);
			CG(active_op_array) = original_active_op_array;
			pass_two(op_array TSRMLS_CC);
			zend_release_labels(0 TSRMLS_CC);
			retval = op_array;
		}
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(&tmp);
	CG(in_compilation) = original_in_compilation;
	return retval;
}


BEGIN_EXTERN_C()
int highlight_file(char *filename, zend_syntax_highlighter_ini *syntax_highlighter_ini TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zend_file_handle file_handle;

	file_handle.type = ZEND_HANDLE_FILENAME;
	file_handle.filename = filename;
	file_handle.free_filename = 0;
	file_handle.opened_path = NULL;
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (open_file_for_scanning(&file_handle TSRMLS_CC)==FAILURE) {
		zend_message_dispatcher(ZMSG_FAILED_HIGHLIGHT_FOPEN, filename TSRMLS_CC);
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_destroy_file_handle(&file_handle TSRMLS_CC);
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	return SUCCESS;
}

int highlight_string(zval *str, zend_syntax_highlighter_ini *syntax_highlighter_ini, char *str_name TSRMLS_DC)
{
	zend_lex_state original_lex_state;
	zval tmp = *str;

	str = &tmp;
	zval_copy_ctor(str);
	zend_save_lexical_state(&original_lex_state TSRMLS_CC);
	if (zend_prepare_string_for_scanning(str, str_name TSRMLS_CC)==FAILURE) {
		zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
		return FAILURE;
	}
	BEGIN(INITIAL);
	zend_highlight(syntax_highlighter_ini TSRMLS_CC);
	if (SCNG(script_filtered)) {
		efree(SCNG(script_filtered));
		SCNG(script_filtered) = NULL;
	}
	zend_restore_lexical_state(&original_lex_state TSRMLS_CC);
	zval_dtor(str);
	return SUCCESS;
}

ZEND_API void zend_multibyte_yyinput_again(zend_encoding_filter old_input_filter, const zend_encoding *old_encoding TSRMLS_DC)
{
	size_t length;
	unsigned char *new_yy_start;

	/* convert and set */
	if (!SCNG(input_filter)) {
		if (SCNG(script_filtered)) {
			efree(SCNG(script_filtered));
			SCNG(script_filtered) = NULL;
		}
		SCNG(script_filtered_size) = 0;
		length = SCNG(script_org_size);
		new_yy_start = SCNG(script_org);
	} else {
		if ((size_t)-1 == SCNG(input_filter)(&new_yy_start, &length, SCNG(script_org), SCNG(script_org_size) TSRMLS_CC)) {
			zend_error_noreturn(E_COMPILE_ERROR, "Could not convert the script from the detected "
					"encoding \"%s\" to a compatible encoding", zend_multibyte_get_encoding_name(LANG_SCNG(script_encoding)));
		}
		SCNG(script_filtered) = new_yy_start;
		SCNG(script_filtered_size) = length;
	}

	SCNG(yy_cursor) = new_yy_start + (SCNG(yy_cursor) - SCNG(yy_start));
	SCNG(yy_marker) = new_yy_start + (SCNG(yy_marker) - SCNG(yy_start));
	SCNG(yy_text) = new_yy_start + (SCNG(yy_text) - SCNG(yy_start));
	SCNG(yy_limit) = new_yy_start + (SCNG(yy_limit) - SCNG(yy_start));

	SCNG(yy_start) = new_yy_start;
}


# define zend_copy_value(zendlval, yytext, yyleng) \
	if (SCNG(output_filter)) { \
		size_t sz = 0; \
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC); \
		zendlval->value.str.len = sz; \
	} else { \
		zendlval->value.str.val = (char *) estrndup(yytext, yyleng); \
		zendlval->value.str.len = yyleng; \
	}

static void zend_scan_escape_string(zval *zendlval, char *str, int len, char quote_type TSRMLS_DC)
{
	register char *s, *t;
	char *end;

	ZVAL_STRINGL(zendlval, str, len, 1);

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;
			if (s >= end) {
				*t++ = '\\';
				break;
			}

			switch(*s) {
				case 'n':
					*t++ = '\n';
					zendlval->value.str.len--;
					break;
				case 'r':
					*t++ = '\r';
					zendlval->value.str.len--;
					break;
				case 't':
					*t++ = '\t';
					zendlval->value.str.len--;
					break;
				case 'f':
					*t++ = '\f';
					zendlval->value.str.len--;
					break;
				case 'v':
					*t++ = '\v';
					zendlval->value.str.len--;
					break;
				case 'e':
#ifdef PHP_WIN32
					*t++ = VK_ESCAPE;
#else
					*t++ = '\e';
#endif
					zendlval->value.str.len--;
					break;
				case '"':
				case '`':
					if (*s != quote_type) {
						*t++ = '\\';
						*t++ = *s;
						break;
					}
				case '\\':
				case '$':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				case 'x':
				case 'X':
					if (ZEND_IS_HEX(*(s+1))) {
						char hex_buf[3] = { 0, 0, 0 };

						zendlval->value.str.len--; /* for the 'x' */

						hex_buf[0] = *(++s);
						zendlval->value.str.len--;
						if (ZEND_IS_HEX(*(s+1))) {
							hex_buf[1] = *(++s);
							zendlval->value.str.len--;
						}
						*t++ = (char) strtol(hex_buf, NULL, 16);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
				default:
					/* check for an octal */
					if (ZEND_IS_OCT(*s)) {
						char octal_buf[4] = { 0, 0, 0, 0 };

						octal_buf[0] = *s;
						zendlval->value.str.len--;
						if (ZEND_IS_OCT(*(s+1))) {
							octal_buf[1] = *(++s);
							zendlval->value.str.len--;
							if (ZEND_IS_OCT(*(s+1))) {
								octal_buf[2] = *(++s);
								zendlval->value.str.len--;
							}
						}
						*t++ = (char) strtol(octal_buf, NULL, 8);
					} else {
						*t++ = '\\';
						*t++ = *s;
					}
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;
	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
}


int lex_scan(zval *zendlval TSRMLS_DC)
{
restart:
	SCNG(yy_text) = YYCURSOR;

yymore_restart:


{
	YYCTYPE yych;
	unsigned int yyaccept = 0;
	static void *yyctable[10] = {
		&&yyc_ST_IN_SCRIPTING,
		&&yyc_ST_LOOKING_FOR_PROPERTY,
		&&yyc_ST_BACKQUOTE,
		&&yyc_ST_DOUBLE_QUOTES,
		&&yyc_ST_HEREDOC,
		&&yyc_ST_LOOKING_FOR_VARNAME,
		&&yyc_ST_VAR_OFFSET,
		&&yyc_INITIAL,
		&&yyc_ST_END_HEREDOC,
		&&yyc_ST_NOWDOC,
	};
	goto *yyctable[YYGETCONDITION()];
/* *********************************** */
yyc_ST_IN_SCRIPTING:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  36,   4,   0,   0,   4,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 36,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			216, 216, 152, 152, 152, 152, 152, 152, 
			152, 152,   0,   0,   0,   0,   0,   0, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			  0, 144, 144, 144, 144, 144, 144,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,   0,   0,   0,   0,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
			 16,  16,  16,  16,  16,  16,  16,  16, 
		};
		YYDEBUG(1, *YYCURSOR);
		YYFILL(16);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy5,  &&yy5,  &&yy3,  &&yy3,  &&yy5,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,  &&yy3,
				&&yy5,  &&yy8,  &&yy10, &&yy12, &&yy14, &&yy15, &&yy16, &&yy17,
				&&yy19, &&yy20, &&yy21, &&yy22, &&yy20, &&yy23, &&yy24, &&yy25,
				&&yy26, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28, &&yy28,
				&&yy28, &&yy28, &&yy30, &&yy20, &&yy31, &&yy32, &&yy33, &&yy34,
				&&yy20, &&yy35, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy39,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy40, &&yy37, &&yy37, &&yy20, &&yy41, &&yy20, &&yy43, &&yy44,
				&&yy45, &&yy47, &&yy48, &&yy49, &&yy50, &&yy51, &&yy52, &&yy53,
				&&yy37, &&yy54, &&yy37, &&yy37, &&yy55, &&yy37, &&yy56, &&yy37,
				&&yy57, &&yy37, &&yy58, &&yy59, &&yy60, &&yy61, &&yy62, &&yy63,
				&&yy37, &&yy64, &&yy37, &&yy65, &&yy67, &&yy68, &&yy20, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37,
				&&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37, &&yy37
			};
			goto *yytarget[yych];
		}
yy3:
		YYDEBUG(3, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(4, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy5:
		YYDEBUG(5, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(6, *YYCURSOR);
		if (yybm[0+yych] & 4) {
			goto yy5;
		}
		YYDEBUG(7, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy8:
		YYDEBUG(8, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy70;
yy9:
		YYDEBUG(9, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return yytext[0];
}
yy10:
		YYDEBUG(10, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(11, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int bprefix = (yytext[0] != '"') ? 1 : 0;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				yyleng = YYCURSOR - SCNG(yy_text);
				zend_scan_escape_string(zendlval, yytext+bprefix+1, yyleng-bprefix-2, '"' TSRMLS_CC);
				return T_CONSTANT_ENCAPSED_STRING;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	/* Remember how much was scanned to save rescanning */
	SET_DOUBLE_QUOTES_SCANNED_LENGTH(YYCURSOR - SCNG(yy_text) - yyleng);

	YYCURSOR = SCNG(yy_text) + yyleng;

	BEGIN(ST_DOUBLE_QUOTES);
	return '"';
}
yy12:
		YYDEBUG(12, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(13, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				CG(zend_lineno)++;
				break;
			case '%':
				if (!CG(asp_tags)) {
					continue;
				}
				/* fall through */
			case '?':
				if (*YYCURSOR == '>') {
					YYCURSOR--;
					break;
				}
				/* fall through */
			default:
				continue;
		}

		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	return T_COMMENT;
}
yy14:
		YYDEBUG(14, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy9;
			if (yych <= 'Z') goto yy72;
			if (yych <= '^') goto yy9;
			goto yy72;
		} else {
			if (yych <= '`') goto yy9;
			if (yych <= 'z') goto yy72;
			if (yych <= '~') goto yy9;
			goto yy72;
		}
yy15:
		YYDEBUG(15, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy75;
		if (yych <= '>') goto yy77;
		goto yy9;
yy16:
		YYDEBUG(16, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '&') goto yy79;
		if (yych == '=') goto yy81;
		goto yy9;
yy17:
		YYDEBUG(17, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(18, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	register char *s, *t;
	char *end;
	int bprefix = (yytext[0] != '\'') ? 1 : 0;

	while (1) {
		if (YYCURSOR < YYLIMIT) {
			if (*YYCURSOR == '\'') {
				YYCURSOR++;
				yyleng = YYCURSOR - SCNG(yy_text);

				break;
			} else if (*YYCURSOR++ == '\\' && YYCURSOR < YYLIMIT) {
				YYCURSOR++;
			}
		} else {
			yyleng = YYLIMIT - SCNG(yy_text);

			/* Unclosed single quotes; treat similar to double quotes, but without a separate token
			 * for ' (unrecognized by parser), instead of old flex fallback to "Unexpected character..."
			 * rule, which continued in ST_IN_SCRIPTING state after the quote */
			return T_ENCAPSED_AND_WHITESPACE;
		}
	}

	zendlval->value.str.val = estrndup(yytext+bprefix+1, yyleng-bprefix-2);
	zendlval->value.str.len = yyleng-bprefix-2;
	zendlval->type = IS_STRING;

	/* convert escape sequences */
	s = t = zendlval->value.str.val;
	end = s+zendlval->value.str.len;
	while (s<end) {
		if (*s=='\\') {
			s++;

			switch(*s) {
				case '\\':
				case '\'':
					*t++ = *s;
					zendlval->value.str.len--;
					break;
				default:
					*t++ = '\\';
					*t++ = *s;
					break;
			}
		} else {
			*t++ = *s;
		}

		if (*s == '\n' || (*s == '\r' && (*(s+1) != '\n'))) {
			CG(zend_lineno)++;
		}
		s++;
	}
	*t = 0;

	if (SCNG(output_filter)) {
		size_t sz = 0;
		s = zendlval->value.str.val;
		SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)s, (size_t)zendlval->value.str.len TSRMLS_CC);
		zendlval->value.str.len = sz;
		efree(s);
	}
	return T_CONSTANT_ENCAPSED_STRING;
}
yy19:
		YYDEBUG(19, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy84, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy84, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy84, &&yy84, &&yy9,  &&yy84, &&yy9,  &&yy84, &&yy9,
				&&yy9,  &&yy84, &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy84,
				&&yy9,  &&yy9,  &&yy84, &&yy84, &&yy9,  &&yy84, &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,
				&&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9,  &&yy9
			};
			goto *yytarget[yych];
		}
yy20:
		YYDEBUG(20, *YYCURSOR);
		++YYCURSOR;
		goto yy9;
yy21:
		YYDEBUG(21, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy95;
		goto yy9;
yy22:
		YYDEBUG(22, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '+') goto yy97;
		if (yych == '=') goto yy99;
		goto yy9;
yy23:
		YYDEBUG(23, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') {
			if (yych == '-') goto yy101;
			goto yy9;
		} else {
			if (yych <= '=') goto yy103;
			if (yych <= '>') goto yy105;
			goto yy9;
		}
yy24:
		YYDEBUG(24, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy9;
		if (yych <= '9') goto yy107;
		if (yych == '=') goto yy110;
		goto yy9;
yy25:
		YYDEBUG(25, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '.') {
			if (yych == '*') goto yy112;
			goto yy9;
		} else {
			if (yych <= '/') goto yy12;
			if (yych == '=') goto yy114;
			goto yy9;
		}
yy26:
		YYDEBUG(26, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == 'b') goto yy117;
		if (yych == 'x') goto yy118;
		goto yy29;
yy27:
		YYDEBUG(27, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (yyleng < MAX_LENGTH_OF_LONG - 1) { /* Won't overflow */
		zendlval->value.lval = strtol(yytext, NULL, 0);
	} else {
		errno = 0;
		zendlval->value.lval = strtol(yytext, NULL, 0);
		if (errno == ERANGE) { /* Overflow */
			if (yytext[0] == '0') { /* octal overflow */
				zendlval->value.dval = zend_oct_strtod(yytext, NULL);
			} else {
				zendlval->value.dval = zend_strtod(yytext, NULL);
			}
			zendlval->type = IS_DOUBLE;
			return T_DNUMBER;
		}
	}

	zendlval->type = IS_LONG;
	return T_LNUMBER;
}
yy28:
		YYDEBUG(28, *YYCURSOR);
		yyaccept = 1;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy29:
		YYDEBUG(29, *YYCURSOR);
		if (yybm[0+yych] & 8) {
			goto yy28;
		}
		if (yych <= 'D') {
			if (yych == '.') goto yy107;
			goto yy27;
		} else {
			if (yych <= 'E') goto yy116;
			if (yych == 'e') goto yy116;
			goto yy27;
		}
yy30:
		YYDEBUG(30, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == ':') goto yy119;
		goto yy9;
yy31:
		YYDEBUG(31, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') {
			if (yych == '/') goto yy121;
			goto yy9;
		} else {
			if (yych <= '<') goto yy122;
			if (yych <= '=') goto yy124;
			if (yych <= '>') goto yy126;
			goto yy9;
		}
yy32:
		YYDEBUG(32, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy127;
		if (yych <= '>') goto yy129;
		goto yy9;
yy33:
		YYDEBUG(33, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '<') goto yy9;
		if (yych <= '=') goto yy131;
		if (yych <= '>') goto yy133;
		goto yy9;
yy34:
		YYDEBUG(34, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy135;
		goto yy9;
yy35:
		YYDEBUG(35, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy137;
		goto yy38;
yy36:
		YYDEBUG(36, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy37:
		YYDEBUG(37, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy38:
		YYDEBUG(38, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		goto yy36;
yy39:
		YYDEBUG(39, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy138;
		goto yy38;
yy40:
		YYDEBUG(40, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy140;
		goto yy38;
yy41:
		YYDEBUG(41, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(42, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NS_SEPARATOR;
}
yy43:
		YYDEBUG(43, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy141;
		goto yy9;
yy44:
		YYDEBUG(44, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy143;
		goto yy38;
yy45:
		YYDEBUG(45, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(46, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_BACKQUOTE);
	return '`';
}
yy47:
		YYDEBUG(47, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'q') {
			if (yych == 'b') goto yy144;
			goto yy38;
		} else {
			if (yych <= 'r') goto yy145;
			if (yych <= 's') goto yy146;
			goto yy38;
		}
yy48:
		YYDEBUG(48, *YYCURSOR);
		yyaccept = 2;
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy10,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy17,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy148, &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy149, &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38
			};
			goto *yytarget[yych];
		}
yy49:
		YYDEBUG(49, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'k') {
			if (yych == 'a') goto yy150;
			goto yy38;
		} else {
			if (yych <= 'l') goto yy151;
			if (yych == 'o') goto yy152;
			goto yy38;
		}
yy50:
		YYDEBUG(50, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'h') {
			if (yych == 'e') goto yy153;
			goto yy38;
		} else {
			if (yych <= 'i') goto yy154;
			if (yych == 'o') goto yy155;
			goto yy38;
		}
yy51:
		YYDEBUG(51, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy157, &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy158, &&yy159, &&yy160, &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy161, &&yy38,
				&&yy162, &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38
			};
			goto *yytarget[yych];
		}
yy52:
		YYDEBUG(52, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'n') {
			if (yych == 'i') goto yy163;
			goto yy38;
		} else {
			if (yych <= 'o') goto yy164;
			if (yych == 'u') goto yy165;
			goto yy38;
		}
yy53:
		YYDEBUG(53, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy166;
		if (yych == 'o') goto yy167;
		goto yy38;
yy54:
		YYDEBUG(54, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'm') {
			if (yych == 'f') goto yy168;
			if (yych <= 'l') goto yy38;
			goto yy170;
		} else {
			if (yych <= 'n') goto yy171;
			if (yych == 's') goto yy172;
			goto yy38;
		}
yy55:
		YYDEBUG(55, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy173;
		goto yy38;
yy56:
		YYDEBUG(56, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy174;
		if (yych == 'e') goto yy175;
		goto yy38;
yy57:
		YYDEBUG(57, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy176;
		if (yych == 'u') goto yy177;
		goto yy38;
yy58:
		YYDEBUG(58, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy178;
		goto yy38;
yy59:
		YYDEBUG(59, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy179;
		if (yych == 'w') goto yy180;
		goto yy38;
yy60:
		YYDEBUG(60, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy181;
		if (yych == 'r') goto yy182;
		goto yy38;
yy61:
		YYDEBUG(61, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy183;
		if (yych == 's') goto yy184;
		goto yy38;
yy62:
		YYDEBUG(62, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy185;
		goto yy38;
yy63:
		YYDEBUG(63, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy186;
		goto yy38;
yy64:
		YYDEBUG(64, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy187;
		goto yy38;
yy65:
		YYDEBUG(65, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(66, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return '{';
}
yy67:
		YYDEBUG(67, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy188;
		if (yych == '|') goto yy190;
		goto yy9;
yy68:
		YYDEBUG(68, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(69, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	RESET_DOC_COMMENT();
	if (!zend_stack_is_empty(&SCNG(state_stack))) {
		yy_pop_state(TSRMLS_C);
	}
	return '}';
}
yy70:
		YYDEBUG(70, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy192;
yy71:
		YYDEBUG(71, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_EQUAL;
}
yy72:
		YYDEBUG(72, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(73, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74, &&yy74,
				&&yy74, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy74, &&yy74, &&yy74, &&yy74, &&yy72,
				&&yy74, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy74, &&yy74, &&yy74, &&yy74, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72,
				&&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72, &&yy72
			};
			goto *yytarget[yych];
		}
yy74:
		YYDEBUG(74, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy75:
		YYDEBUG(75, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(76, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MOD_EQUAL;
}
yy77:
		YYDEBUG(77, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy194;
		if (yych == '\r') goto yy195;
yy78:
		YYDEBUG(78, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		BEGIN(INITIAL);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		zendlval->value.str.val = yytext; /* no copying - intentional */
		return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
	} else {
		yyless(1);
		return yytext[0];
	}
}
yy79:
		YYDEBUG(79, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(80, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_AND;
}
yy81:
		YYDEBUG(81, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(82, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AND_EQUAL;
}
yy83:
		YYDEBUG(83, *YYCURSOR);
		++YYCURSOR;
		YYFILL(7);
		yych = *YYCURSOR;
yy84:
		YYDEBUG(84, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy83, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy83, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy86, &&yy87, &&yy85, &&yy88, &&yy85, &&yy89, &&yy85,
				&&yy85, &&yy90, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy91,
				&&yy85, &&yy85, &&yy92, &&yy93, &&yy85, &&yy94, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85,
				&&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85, &&yy85
			};
			goto *yytarget[yych];
		}
yy85:
		YYDEBUG(85, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept <= 2) {
			if (yyaccept <= 1) {
				if (yyaccept == 0) {
					goto yy9;
				} else {
					goto yy27;
				}
			} else {
				goto yy36;
			}
		} else {
			if (yyaccept <= 4) {
				if (yyaccept == 3) {
					goto yy109;
				} else {
					goto yy113;
				}
			} else {
				goto yy123;
			}
		}
yy86:
		YYDEBUG(86, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy196;
		goto yy85;
yy87:
		YYDEBUG(87, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy197;
		if (yych == 'o') goto yy198;
		goto yy85;
yy88:
		YYDEBUG(88, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy199;
		goto yy85;
yy89:
		YYDEBUG(89, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy200;
		goto yy85;
yy90:
		YYDEBUG(90, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy201;
		goto yy85;
yy91:
		YYDEBUG(91, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy202;
		goto yy85;
yy92:
		YYDEBUG(92, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy203;
		goto yy85;
yy93:
		YYDEBUG(93, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy204;
		goto yy85;
yy94:
		YYDEBUG(94, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy205;
		goto yy85;
yy95:
		YYDEBUG(95, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(96, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MUL_EQUAL;
}
yy97:
		YYDEBUG(97, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(98, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INC;
}
yy99:
		YYDEBUG(99, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(100, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PLUS_EQUAL;
}
yy101:
		YYDEBUG(101, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(102, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEC;
}
yy103:
		YYDEBUG(103, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(104, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_MINUS_EQUAL;
}
yy105:
		YYDEBUG(105, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(106, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	return T_OBJECT_OPERATOR;
}
yy107:
		YYDEBUG(107, *YYCURSOR);
		yyaccept = 3;
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(108, *YYCURSOR);
		if (yych <= 'D') {
			if (yych <= '/') goto yy109;
			if (yych <= '9') goto yy107;
		} else {
			if (yych <= 'E') goto yy116;
			if (yych == 'e') goto yy116;
		}
yy109:
		YYDEBUG(109, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.dval = zend_strtod(yytext, NULL);
	zendlval->type = IS_DOUBLE;
	return T_DNUMBER;
}
yy110:
		YYDEBUG(110, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(111, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONCAT_EQUAL;
}
yy112:
		YYDEBUG(112, *YYCURSOR);
		yyaccept = 4;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '*') goto yy206;
yy113:
		YYDEBUG(113, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int doc_com;

	if (yyleng > 2) {
		doc_com = 1;
		RESET_DOC_COMMENT();
	} else {
		doc_com = 0;
	}

	while (YYCURSOR < YYLIMIT) {
		if (*YYCURSOR++ == '*' && *YYCURSOR == '/') {
			break;
		}
	}

	if (YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	} else {
		zend_error(E_COMPILE_WARNING, "Unterminated comment starting line %d", CG(zend_lineno));
	}

	yyleng = YYCURSOR - SCNG(yy_text);
	HANDLE_NEWLINES(yytext, yyleng);

	if (doc_com) {
		CG(doc_comment) = estrndup(yytext, yyleng);
		CG(doc_comment_len) = yyleng;
		return T_DOC_COMMENT;
	}

	return T_COMMENT;
}
yy114:
		YYDEBUG(114, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(115, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DIV_EQUAL;
}
yy116:
		YYDEBUG(116, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= ',') {
			if (yych == '+') goto yy207;
			goto yy85;
		} else {
			if (yych <= '-') goto yy207;
			if (yych <= '/') goto yy85;
			if (yych <= '9') goto yy208;
			goto yy85;
		}
yy117:
		YYDEBUG(117, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		goto yy85;
yy118:
		YYDEBUG(118, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy213;
		}
		goto yy85;
yy119:
		YYDEBUG(119, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(120, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PAAMAYIM_NEKUDOTAYIM;
}
yy121:
		YYDEBUG(121, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy216;
		goto yy85;
yy122:
		YYDEBUG(122, *YYCURSOR);
		yyaccept = 5;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= ';') goto yy123;
		if (yych <= '<') goto yy217;
		if (yych <= '=') goto yy219;
yy123:
		YYDEBUG(123, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL;
}
yy124:
		YYDEBUG(124, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(125, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_SMALLER_OR_EQUAL;
}
yy126:
		YYDEBUG(126, *YYCURSOR);
		++YYCURSOR;
		goto yy71;
yy127:
		YYDEBUG(127, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy221;
		YYDEBUG(128, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_EQUAL;
}
yy129:
		YYDEBUG(129, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(130, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_ARROW;
}
yy131:
		YYDEBUG(131, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(132, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_GREATER_OR_EQUAL;
}
yy133:
		YYDEBUG(133, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy223;
		YYDEBUG(134, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR;
}
yy135:
		YYDEBUG(135, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy225;
		if (yych == '\r') goto yy226;
yy136:
		YYDEBUG(136, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(INITIAL);
	return T_CLOSE_TAG;  /* implicit ';' at php-end tag */
}
yy137:
		YYDEBUG(137, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy227;
		goto yy38;
yy138:
		YYDEBUG(138, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(139, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_OR;
}
yy140:
		YYDEBUG(140, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy229;
		goto yy38;
yy141:
		YYDEBUG(141, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(142, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_XOR_EQUAL;
}
yy143:
		YYDEBUG(143, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy231, &&yy232, &&yy38,  &&yy233, &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy234, &&yy235, &&yy236, &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy237, &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy238, &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38
			};
			goto *yytarget[yych];
		}
yy144:
		YYDEBUG(144, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy239;
		goto yy38;
yy145:
		YYDEBUG(145, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy240;
		goto yy38;
yy146:
		YYDEBUG(146, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(147, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_AS;
}
yy148:
		YYDEBUG(148, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy241;
		goto yy85;
yy149:
		YYDEBUG(149, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy242;
		goto yy38;
yy150:
		YYDEBUG(150, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'l') goto yy243;
			goto yy38;
		} else {
			if (yych <= 's') goto yy244;
			if (yych <= 't') goto yy245;
			goto yy38;
		}
yy151:
		YYDEBUG(151, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy246;
		if (yych == 'o') goto yy247;
		goto yy38;
yy152:
		YYDEBUG(152, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy248;
		goto yy38;
yy153:
		YYDEBUG(153, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy249;
		if (yych == 'f') goto yy250;
		goto yy38;
yy154:
		YYDEBUG(154, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy251;
		goto yy38;
yy155:
		YYDEBUG(155, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(156, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DO;
}
yy157:
		YYDEBUG(157, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy253;
		goto yy38;
yy158:
		YYDEBUG(158, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy254;
		goto yy38;
yy159:
		YYDEBUG(159, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy255;
		goto yy38;
yy160:
		YYDEBUG(160, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy256;
		goto yy38;
yy161:
		YYDEBUG(161, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy257;
		goto yy38;
yy162:
		YYDEBUG(162, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy258;
		if (yych == 't') goto yy259;
		goto yy38;
yy163:
		YYDEBUG(163, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy260;
		goto yy38;
yy164:
		YYDEBUG(164, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy261;
		goto yy38;
yy165:
		YYDEBUG(165, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy263;
		goto yy38;
yy166:
		YYDEBUG(166, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy264;
		goto yy38;
yy167:
		YYDEBUG(167, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy265;
		goto yy38;
yy168:
		YYDEBUG(168, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(169, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IF;
}
yy170:
		YYDEBUG(170, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy266;
		goto yy38;
yy171:
		YYDEBUG(171, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') {
			if (yych == 'c') goto yy267;
			goto yy38;
		} else {
			if (yych <= 's') goto yy268;
			if (yych <= 't') goto yy269;
			goto yy38;
		}
yy172:
		YYDEBUG(172, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy270;
		goto yy38;
yy173:
		YYDEBUG(173, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy271;
		goto yy38;
yy174:
		YYDEBUG(174, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy272;
		goto yy38;
yy175:
		YYDEBUG(175, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy273;
		goto yy38;
yy176:
		YYDEBUG(176, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy275;
		if (yych == 'o') goto yy276;
		goto yy38;
yy177:
		YYDEBUG(177, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy277;
		goto yy38;
yy178:
		YYDEBUG(178, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'q') goto yy278;
		if (yych == 't') goto yy279;
		goto yy38;
yy179:
		YYDEBUG(179, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy280;
		goto yy38;
yy180:
		YYDEBUG(180, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy281;
		goto yy38;
yy181:
		YYDEBUG(181, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy282;
		goto yy38;
yy182:
		YYDEBUG(182, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy283;
		if (yych == 'y') goto yy284;
		goto yy38;
yy183:
		YYDEBUG(183, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy286;
		goto yy38;
yy184:
		YYDEBUG(184, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy287;
		goto yy38;
yy185:
		YYDEBUG(185, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy289;
		goto yy38;
yy186:
		YYDEBUG(186, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy291;
		goto yy38;
yy187:
		YYDEBUG(187, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy292;
		goto yy38;
yy188:
		YYDEBUG(188, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(189, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OR_EQUAL;
}
yy190:
		YYDEBUG(190, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(191, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOLEAN_OR;
}
yy192:
		YYDEBUG(192, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(193, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_NOT_IDENTICAL;
}
yy194:
		YYDEBUG(194, *YYCURSOR);
		++YYCURSOR;
		goto yy78;
yy195:
		YYDEBUG(195, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy194;
		goto yy78;
yy196:
		YYDEBUG(196, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy293;
		goto yy85;
yy197:
		YYDEBUG(197, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy294;
		goto yy85;
yy198:
		YYDEBUG(198, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy295;
		goto yy85;
yy199:
		YYDEBUG(199, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy296;
		goto yy85;
yy200:
		YYDEBUG(200, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy297;
		goto yy85;
yy201:
		YYDEBUG(201, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy298;
		goto yy85;
yy202:
		YYDEBUG(202, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'j') goto yy299;
		goto yy85;
yy203:
		YYDEBUG(203, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy300;
		goto yy85;
yy204:
		YYDEBUG(204, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy301;
		goto yy85;
yy205:
		YYDEBUG(205, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy302;
		goto yy85;
yy206:
		YYDEBUG(206, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy85;
			if (yych <= '\n') goto yy303;
			goto yy85;
		} else {
			if (yych <= '\r') goto yy303;
			if (yych == ' ') goto yy303;
			goto yy85;
		}
yy207:
		YYDEBUG(207, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '/') goto yy85;
		if (yych >= ':') goto yy85;
yy208:
		YYDEBUG(208, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(209, *YYCURSOR);
		if (yych <= '/') goto yy109;
		if (yych <= '9') goto yy208;
		goto yy109;
yy210:
		YYDEBUG(210, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(211, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy210;
		}
		YYDEBUG(212, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *bin = yytext + 2; /* Skip "0b" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*bin == '0') {
		++bin;
		--len;
	}

	if (len < SIZEOF_LONG * 8) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(bin, NULL, 2);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_bin_strtod(bin, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy213:
		YYDEBUG(213, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(214, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy213;
		}
		YYDEBUG(215, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *hex = yytext + 2; /* Skip "0x" */
	int len = yyleng - 2;

	/* Skip any leading 0s */
	while (*hex == '0') {
		hex++;
		len--;
	}

	if (len < SIZEOF_LONG * 2 || (len == SIZEOF_LONG * 2 && *hex <= '7')) {
		if (len == 0) {
			zendlval->value.lval = 0;
		} else {
			zendlval->value.lval = strtol(hex, NULL, 16);
		}
		zendlval->type = IS_LONG;
		return T_LNUMBER;
	} else {
		zendlval->value.dval = zend_hex_strtod(hex, NULL);
		zendlval->type = IS_DOUBLE;
		return T_DNUMBER;
	}
}
yy216:
		YYDEBUG(216, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy305;
		goto yy85;
yy217:
		YYDEBUG(217, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(218, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy217, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy217, &&yy85,  &&yy306, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy307,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy308,
				&&yy85,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308
			};
			goto *yytarget[yych];
		}
yy219:
		YYDEBUG(219, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(220, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SL_EQUAL;
}
yy221:
		YYDEBUG(221, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(222, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IS_IDENTICAL;
}
yy223:
		YYDEBUG(223, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(224, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SR_EQUAL;
}
yy225:
		YYDEBUG(225, *YYCURSOR);
		++YYCURSOR;
		goto yy136;
yy226:
		YYDEBUG(226, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy225;
		goto yy136;
yy227:
		YYDEBUG(227, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(228, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_AND;
}
yy229:
		YYDEBUG(229, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(230, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LOGICAL_XOR;
}
yy231:
		YYDEBUG(231, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy310;
		goto yy38;
yy232:
		YYDEBUG(232, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy311;
		goto yy38;
yy233:
		YYDEBUG(233, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy312;
		if (yych == 'U') goto yy313;
		goto yy38;
yy234:
		YYDEBUG(234, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy314;
		goto yy38;
yy235:
		YYDEBUG(235, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy315;
		goto yy38;
yy236:
		YYDEBUG(236, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy316;
		goto yy38;
yy237:
		YYDEBUG(237, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy317;
		goto yy38;
yy238:
		YYDEBUG(238, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy318;
		goto yy38;
yy239:
		YYDEBUG(239, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy319;
		goto yy38;
yy240:
		YYDEBUG(240, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy320;
		goto yy38;
yy241:
		YYDEBUG(241, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '<') goto yy217;
		goto yy85;
yy242:
		YYDEBUG(242, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy321;
		goto yy38;
yy243:
		YYDEBUG(243, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy322;
		goto yy38;
yy244:
		YYDEBUG(244, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy323;
		goto yy38;
yy245:
		YYDEBUG(245, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy325;
		goto yy38;
yy246:
		YYDEBUG(246, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy326;
		goto yy38;
yy247:
		YYDEBUG(247, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy327;
		goto yy38;
yy248:
		YYDEBUG(248, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= 'r') goto yy38;
		if (yych <= 's') goto yy328;
		if (yych <= 't') goto yy329;
		goto yy38;
yy249:
		YYDEBUG(249, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy330;
		goto yy38;
yy250:
		YYDEBUG(250, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy331;
		goto yy38;
yy251:
		YYDEBUG(251, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(252, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy253:
		YYDEBUG(253, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy332;
		goto yy38;
yy254:
		YYDEBUG(254, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy334;
		goto yy38;
yy255:
		YYDEBUG(255, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy336;
		goto yy38;
yy256:
		YYDEBUG(256, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy337, &&yy38,  &&yy338, &&yy38,
				&&yy38,  &&yy339, &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy340, &&yy38,  &&yy38,  &&yy38,  &&yy341,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,
				&&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38,  &&yy38
			};
			goto *yytarget[yych];
		}
yy257:
		YYDEBUG(257, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy342;
		goto yy38;
yy258:
		YYDEBUG(258, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy344;
		goto yy38;
yy259:
		YYDEBUG(259, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy346;
		goto yy38;
yy260:
		YYDEBUG(260, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy347;
		goto yy38;
yy261:
		YYDEBUG(261, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy262, &&yy262, &&yy262, &&yy262, &&yy262, &&yy262,
				&&yy262, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy262, &&yy262, &&yy262, &&yy262, &&yy37,
				&&yy262, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy348, &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy262, &&yy262, &&yy262, &&yy262, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy262:
		YYDEBUG(262, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOR;
}
yy263:
		YYDEBUG(263, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy349;
		goto yy38;
yy264:
		YYDEBUG(264, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy350;
		goto yy38;
yy265:
		YYDEBUG(265, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy351;
		goto yy38;
yy266:
		YYDEBUG(266, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy353;
		goto yy38;
yy267:
		YYDEBUG(267, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy354;
		goto yy38;
yy268:
		YYDEBUG(268, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy355;
		goto yy38;
yy269:
		YYDEBUG(269, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy356;
		goto yy38;
yy270:
		YYDEBUG(270, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy357;
		goto yy38;
yy271:
		YYDEBUG(271, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy358;
		goto yy38;
yy272:
		YYDEBUG(272, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy360;
		goto yy38;
yy273:
		YYDEBUG(273, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(274, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NEW;
}
yy275:
		YYDEBUG(275, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy361;
		if (yych == 'v') goto yy362;
		goto yy38;
yy276:
		YYDEBUG(276, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy363;
		goto yy38;
yy277:
		YYDEBUG(277, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy364;
		goto yy38;
yy278:
		YYDEBUG(278, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy365;
		goto yy38;
yy279:
		YYDEBUG(279, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy366;
		goto yy38;
yy280:
		YYDEBUG(280, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy367;
		goto yy38;
yy281:
		YYDEBUG(281, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy368;
		goto yy38;
yy282:
		YYDEBUG(282, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy369;
		goto yy38;
yy283:
		YYDEBUG(283, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy370;
		goto yy38;
yy284:
		YYDEBUG(284, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(285, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRY;
}
yy286:
		YYDEBUG(286, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy371;
		goto yy38;
yy287:
		YYDEBUG(287, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(288, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_USE;
}
yy289:
		YYDEBUG(289, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(290, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_VAR;
}
yy291:
		YYDEBUG(291, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy372;
		goto yy38;
yy292:
		YYDEBUG(292, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy373;
		goto yy38;
yy293:
		YYDEBUG(293, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy374;
		goto yy85;
yy294:
		YYDEBUG(294, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy375;
		goto yy85;
yy295:
		YYDEBUG(295, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy376;
		goto yy85;
yy296:
		YYDEBUG(296, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy377;
		goto yy85;
yy297:
		YYDEBUG(297, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy378;
		goto yy85;
yy298:
		YYDEBUG(298, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy383;
		goto yy380;
yy299:
		YYDEBUG(299, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy384;
		goto yy85;
yy300:
		YYDEBUG(300, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy385;
		goto yy85;
yy301:
		YYDEBUG(301, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy387;
		goto yy85;
yy302:
		YYDEBUG(302, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy388;
		goto yy85;
yy303:
		YYDEBUG(303, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(304, *YYCURSOR);
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy113;
			if (yych <= '\n') goto yy303;
			goto yy113;
		} else {
			if (yych <= '\r') goto yy303;
			if (yych == ' ') goto yy303;
			goto yy113;
		}
yy305:
		YYDEBUG(305, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy389;
		goto yy85;
yy306:
		YYDEBUG(306, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy85;
		if (yych <= '/') goto yy391;
		if (yych <= '9') goto yy85;
		goto yy391;
yy307:
		YYDEBUG(307, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy85;
		if (yych <= '/') goto yy393;
		if (yych <= '9') goto yy85;
		goto yy393;
yy308:
		YYDEBUG(308, *YYCURSOR);
		++YYCURSOR;
		YYFILL(2);
		yych = *YYCURSOR;
		YYDEBUG(309, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy394, &&yy85,  &&yy85,  &&yy396, &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy308,
				&&yy85,  &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308,
				&&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308, &&yy308
			};
			goto *yytarget[yych];
		}
yy310:
		YYDEBUG(310, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy397;
		goto yy38;
yy311:
		YYDEBUG(311, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'R') goto yy398;
		goto yy38;
yy312:
		YYDEBUG(312, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'L') goto yy399;
		goto yy38;
yy313:
		YYDEBUG(313, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy400;
		goto yy38;
yy314:
		YYDEBUG(314, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy401;
		goto yy38;
yy315:
		YYDEBUG(315, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy402;
		goto yy38;
yy316:
		YYDEBUG(316, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'M') goto yy403;
		goto yy38;
yy317:
		YYDEBUG(317, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy404;
		goto yy38;
yy318:
		YYDEBUG(318, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy405;
		goto yy38;
yy319:
		YYDEBUG(319, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy406;
		goto yy38;
yy320:
		YYDEBUG(320, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy407;
		goto yy38;
yy321:
		YYDEBUG(321, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'k') goto yy409;
		goto yy38;
yy322:
		YYDEBUG(322, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy411;
		goto yy38;
yy323:
		YYDEBUG(323, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(324, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CASE;
}
yy325:
		YYDEBUG(325, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy412;
		goto yy38;
yy326:
		YYDEBUG(326, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy414;
		goto yy38;
yy327:
		YYDEBUG(327, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy416;
		goto yy38;
yy328:
		YYDEBUG(328, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy418;
		goto yy38;
yy329:
		YYDEBUG(329, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy420;
		goto yy38;
yy330:
		YYDEBUG(330, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy421;
		goto yy38;
yy331:
		YYDEBUG(331, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy422;
		goto yy38;
yy332:
		YYDEBUG(332, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(333, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ECHO;
}
yy334:
		YYDEBUG(334, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy335, &&yy335, &&yy335, &&yy335, &&yy335, &&yy335,
				&&yy335, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy335, &&yy335, &&yy335, &&yy335, &&yy37,
				&&yy335, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy423, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy335, &&yy335, &&yy335, &&yy335, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy335:
		YYDEBUG(335, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSE;
}
yy336:
		YYDEBUG(336, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy424;
		goto yy38;
yy337:
		YYDEBUG(337, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy426;
		goto yy38;
yy338:
		YYDEBUG(338, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy427;
		goto yy38;
yy339:
		YYDEBUG(339, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy428;
		goto yy38;
yy340:
		YYDEBUG(340, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy430;
		goto yy38;
yy341:
		YYDEBUG(341, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy431;
		goto yy38;
yy342:
		YYDEBUG(342, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(343, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EVAL;
}
yy344:
		YYDEBUG(344, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(345, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXIT;
}
yy346:
		YYDEBUG(346, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy432;
		goto yy38;
yy347:
		YYDEBUG(347, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy433;
		goto yy38;
yy348:
		YYDEBUG(348, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy435;
		goto yy38;
yy349:
		YYDEBUG(349, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy436;
		goto yy38;
yy350:
		YYDEBUG(350, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy437;
		goto yy38;
yy351:
		YYDEBUG(351, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(352, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GOTO;
}
yy353:
		YYDEBUG(353, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy438;
		goto yy38;
yy354:
		YYDEBUG(354, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy439;
		goto yy38;
yy355:
		YYDEBUG(355, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy440;
		if (yych == 'e') goto yy441;
		goto yy38;
yy356:
		YYDEBUG(356, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy442;
		goto yy38;
yy357:
		YYDEBUG(357, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy443;
		goto yy38;
yy358:
		YYDEBUG(358, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(359, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_LIST;
}
yy360:
		YYDEBUG(360, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy445;
		goto yy38;
yy361:
		YYDEBUG(361, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy446;
		goto yy38;
yy362:
		YYDEBUG(362, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy448;
		goto yy38;
yy363:
		YYDEBUG(363, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy449;
		goto yy38;
yy364:
		YYDEBUG(364, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy450;
		goto yy38;
yy365:
		YYDEBUG(365, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy451;
		goto yy38;
yy366:
		YYDEBUG(366, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy452;
		goto yy38;
yy367:
		YYDEBUG(367, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy453;
		goto yy38;
yy368:
		YYDEBUG(368, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy454;
		goto yy38;
yy369:
		YYDEBUG(369, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'w') goto yy455;
		goto yy38;
yy370:
		YYDEBUG(370, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy457;
		goto yy38;
yy371:
		YYDEBUG(371, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy459;
		goto yy38;
yy372:
		YYDEBUG(372, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy461;
		goto yy38;
yy373:
		YYDEBUG(373, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy463;
		goto yy38;
yy374:
		YYDEBUG(374, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy465;
		goto yy85;
yy375:
		YYDEBUG(375, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy467;
		goto yy85;
yy376:
		YYDEBUG(376, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy472;
		goto yy469;
yy377:
		YYDEBUG(377, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy473;
		goto yy85;
yy378:
		YYDEBUG(378, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy385;
		goto yy85;
yy379:
		YYDEBUG(379, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy380:
		YYDEBUG(380, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy379;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy379;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(381, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(382, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INT_CAST;
}
yy383:
		YYDEBUG(383, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'g') goto yy474;
		goto yy85;
yy384:
		YYDEBUG(384, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy475;
		goto yy85;
yy385:
		YYDEBUG(385, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(386, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy385;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy385;
			if (yych == ')') goto yy476;
			goto yy85;
		}
yy387:
		YYDEBUG(387, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy478;
		goto yy85;
yy388:
		YYDEBUG(388, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy479;
		goto yy85;
yy389:
		YYDEBUG(389, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy481;
		goto yy85;
yy390:
		YYDEBUG(390, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy391:
		YYDEBUG(391, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy482, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy390,
				&&yy85,  &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390,
				&&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390, &&yy390
			};
			goto *yytarget[yych];
		}
yy392:
		YYDEBUG(392, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
yy393:
		YYDEBUG(393, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy482,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy392,
				&&yy85,  &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392,
				&&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392, &&yy392
			};
			goto *yytarget[yych];
		}
yy394:
		YYDEBUG(394, *YYCURSOR);
		++YYCURSOR;
yy395:
		YYDEBUG(395, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *s;
	int bprefix = (yytext[0] != '<') ? 1 : 0;
	zend_heredoc_label *heredoc_label = emalloc(sizeof(zend_heredoc_label));

	CG(zend_lineno)++;
	heredoc_label->length = yyleng-bprefix-3-1-(yytext[yyleng-2]=='\r'?1:0);
	s = yytext+bprefix+3;
	while ((*s == ' ') || (*s == '\t')) {
		s++;
		heredoc_label->length--;
	}

	if (*s == '\'') {
		s++;
		heredoc_label->length -= 2;

		BEGIN(ST_NOWDOC);
	} else {
		if (*s == '"') {
			s++;
			heredoc_label->length -= 2;
		}

		BEGIN(ST_HEREDOC);
	}

	heredoc_label->label = estrndup(s, heredoc_label->length);

	/* Check for ending label on the next line */
	if (heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, s, heredoc_label->length)) {
		YYCTYPE *end = YYCURSOR + heredoc_label->length;

		if (*end == ';') {
			end++;
		}

		if (*end == '\n' || *end == '\r') {
			BEGIN(ST_END_HEREDOC);
		}
	}

	zend_ptr_stack_push(&SCNG(heredoc_label_stack), (void *) heredoc_label);

	return T_START_HEREDOC;
}
yy396:
		YYDEBUG(396, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy394;
		goto yy395;
yy397:
		YYDEBUG(397, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy483;
		goto yy38;
yy398:
		YYDEBUG(398, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy484;
		goto yy38;
yy399:
		YYDEBUG(399, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy485;
		goto yy38;
yy400:
		YYDEBUG(400, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy486;
		goto yy38;
yy401:
		YYDEBUG(401, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy487;
		goto yy38;
yy402:
		YYDEBUG(402, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'H') goto yy488;
		goto yy38;
yy403:
		YYDEBUG(403, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy489;
		goto yy38;
yy404:
		YYDEBUG(404, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy490;
		goto yy38;
yy405:
		YYDEBUG(405, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy491;
		goto yy38;
yy406:
		YYDEBUG(406, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy492;
		goto yy38;
yy407:
		YYDEBUG(407, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(408, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY;
}
yy409:
		YYDEBUG(409, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(410, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BREAK;
}
yy411:
		YYDEBUG(411, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'b') goto yy493;
		goto yy38;
yy412:
		YYDEBUG(412, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(413, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CATCH;
}
yy414:
		YYDEBUG(414, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(415, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLASS;
}
yy416:
		YYDEBUG(416, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(417, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CLONE;
}
yy418:
		YYDEBUG(418, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(419, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONST;
}
yy420:
		YYDEBUG(420, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy494;
		goto yy38;
yy421:
		YYDEBUG(421, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy495;
		goto yy38;
yy422:
		YYDEBUG(422, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy496;
		goto yy38;
yy423:
		YYDEBUG(423, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy497;
		goto yy38;
yy424:
		YYDEBUG(424, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(425, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EMPTY;
}
yy426:
		YYDEBUG(426, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy499;
		goto yy38;
yy427:
		YYDEBUG(427, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy500;
		goto yy38;
yy428:
		YYDEBUG(428, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(429, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDIF;
}
yy430:
		YYDEBUG(430, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy502;
		goto yy38;
yy431:
		YYDEBUG(431, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy503;
		goto yy38;
yy432:
		YYDEBUG(432, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy504;
		goto yy38;
yy433:
		YYDEBUG(433, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy434, &&yy434, &&yy434, &&yy434, &&yy434, &&yy434,
				&&yy434, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy434, &&yy434, &&yy434, &&yy434, &&yy37,
				&&yy434, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy505, &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy434, &&yy434, &&yy434, &&yy434, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy434:
		YYDEBUG(434, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINAL;
}
yy435:
		YYDEBUG(435, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy506;
		goto yy38;
yy436:
		YYDEBUG(436, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy507;
		goto yy38;
yy437:
		YYDEBUG(437, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy508;
		goto yy38;
yy438:
		YYDEBUG(438, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy510;
		goto yy38;
yy439:
		YYDEBUG(439, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy511;
		goto yy38;
yy440:
		YYDEBUG(440, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy512;
		goto yy38;
yy441:
		YYDEBUG(441, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy513;
		goto yy38;
yy442:
		YYDEBUG(442, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy514;
		goto yy38;
yy443:
		YYDEBUG(443, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(444, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ISSET;
}
yy445:
		YYDEBUG(445, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy515;
		goto yy38;
yy446:
		YYDEBUG(446, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(447, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRINT;
}
yy448:
		YYDEBUG(448, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy516;
		goto yy38;
yy449:
		YYDEBUG(449, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy517;
		goto yy38;
yy450:
		YYDEBUG(450, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy518;
		goto yy38;
yy451:
		YYDEBUG(451, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy520;
		goto yy38;
yy452:
		YYDEBUG(452, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy521;
		goto yy38;
yy453:
		YYDEBUG(453, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy523;
		goto yy38;
yy454:
		YYDEBUG(454, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy525;
		goto yy38;
yy455:
		YYDEBUG(455, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(456, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_THROW;
}
yy457:
		YYDEBUG(457, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(458, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_TRAIT;
}
yy459:
		YYDEBUG(459, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(460, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET;
}
yy461:
		YYDEBUG(461, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(462, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_WHILE;
}
yy463:
		YYDEBUG(463, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(464, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_YIELD;
}
yy465:
		YYDEBUG(465, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(466, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy465;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy465;
			if (yych == ')') goto yy527;
			goto yy85;
		}
yy467:
		YYDEBUG(467, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy529;
		goto yy85;
yy468:
		YYDEBUG(468, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy469:
		YYDEBUG(469, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy468;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy468;
			if (yych != ')') goto yy85;
		}
		YYDEBUG(470, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(471, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_BOOL_CAST;
}
yy472:
		YYDEBUG(472, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy531;
		goto yy85;
yy473:
		YYDEBUG(473, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy385;
		goto yy85;
yy474:
		YYDEBUG(474, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy532;
		goto yy85;
yy475:
		YYDEBUG(475, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy533;
		goto yy85;
yy476:
		YYDEBUG(476, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(477, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DOUBLE_CAST;
}
yy478:
		YYDEBUG(478, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'g') goto yy529;
		goto yy85;
yy479:
		YYDEBUG(479, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(480, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy479;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy479;
			if (yych == ')') goto yy535;
			goto yy85;
		}
yy481:
		YYDEBUG(481, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy537;
		goto yy85;
yy482:
		YYDEBUG(482, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy394;
		if (yych == '\r') goto yy396;
		goto yy85;
yy483:
		YYDEBUG(483, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy538;
		goto yy38;
yy484:
		YYDEBUG(484, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy539;
		goto yy38;
yy485:
		YYDEBUG(485, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy541;
		goto yy38;
yy486:
		YYDEBUG(486, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy542;
		goto yy38;
yy487:
		YYDEBUG(487, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy543;
		goto yy38;
yy488:
		YYDEBUG(488, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy544;
		goto yy38;
yy489:
		YYDEBUG(489, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'S') goto yy545;
		goto yy38;
yy490:
		YYDEBUG(490, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'T') goto yy546;
		goto yy38;
yy491:
		YYDEBUG(491, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy547;
		goto yy38;
yy492:
		YYDEBUG(492, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy548;
		goto yy38;
yy493:
		YYDEBUG(493, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy549;
		goto yy38;
yy494:
		YYDEBUG(494, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'u') goto yy550;
		goto yy38;
yy495:
		YYDEBUG(495, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy551;
		goto yy38;
yy496:
		YYDEBUG(496, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy553;
		goto yy38;
yy497:
		YYDEBUG(497, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(498, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ELSEIF;
}
yy499:
		YYDEBUG(499, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy555;
		goto yy38;
yy500:
		YYDEBUG(500, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy501, &&yy501, &&yy501, &&yy501, &&yy501, &&yy501,
				&&yy501, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy501, &&yy501, &&yy501, &&yy501, &&yy37,
				&&yy501, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy556, &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy501, &&yy501, &&yy501, &&yy501, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy501:
		YYDEBUG(501, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOR;
}
yy502:
		YYDEBUG(502, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy557;
		goto yy38;
yy503:
		YYDEBUG(503, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy558;
		goto yy38;
yy504:
		YYDEBUG(504, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy559;
		goto yy38;
yy505:
		YYDEBUG(505, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'y') goto yy561;
		goto yy38;
yy506:
		YYDEBUG(506, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy563;
		goto yy38;
yy507:
		YYDEBUG(507, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy565;
		goto yy38;
yy508:
		YYDEBUG(508, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(509, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_GLOBAL;
}
yy510:
		YYDEBUG(510, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy566;
		goto yy38;
yy511:
		YYDEBUG(511, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy567;
		goto yy38;
yy512:
		YYDEBUG(512, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy569;
		goto yy38;
yy513:
		YYDEBUG(513, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy570;
		goto yy38;
yy514:
		YYDEBUG(514, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy571;
		goto yy38;
yy515:
		YYDEBUG(515, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy572;
		goto yy38;
yy516:
		YYDEBUG(516, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy573;
		goto yy38;
yy517:
		YYDEBUG(517, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy575;
		goto yy38;
yy518:
		YYDEBUG(518, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(519, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PUBLIC;
}
yy520:
		YYDEBUG(520, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy576;
		goto yy38;
yy521:
		YYDEBUG(521, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(522, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_RETURN;
}
yy523:
		YYDEBUG(523, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(524, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STATIC;
}
yy525:
		YYDEBUG(525, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(526, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_SWITCH;
}
yy527:
		YYDEBUG(527, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(528, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ARRAY_CAST;
}
yy529:
		YYDEBUG(529, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(530, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy529;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy529;
			if (yych == ')') goto yy578;
			goto yy85;
		}
yy531:
		YYDEBUG(531, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy468;
		goto yy85;
yy532:
		YYDEBUG(532, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy379;
		goto yy85;
yy533:
		YYDEBUG(533, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(534, *YYCURSOR);
		if (yych <= 0x1F) {
			if (yych == '\t') goto yy533;
			goto yy85;
		} else {
			if (yych <= ' ') goto yy533;
			if (yych == ')') goto yy580;
			goto yy85;
		}
yy535:
		YYDEBUG(535, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(536, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_UNSET_CAST;
}
yy537:
		YYDEBUG(537, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy582;
		goto yy85;
yy538:
		YYDEBUG(538, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy584;
		goto yy38;
yy539:
		YYDEBUG(539, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(540, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);
	const size_t filename_len = strlen(filename);
	char *dirname;

	if (!filename) {
		filename = "";
	}

	dirname = estrndup(filename, filename_len);
	zend_dirname(dirname, filename_len);

	if (strcmp(dirname, ".") == 0) {
		dirname = erealloc(dirname, MAXPATHLEN);
#if HAVE_GETCWD
		VCWD_GETCWD(dirname, MAXPATHLEN);
#elif HAVE_GETWD
		VCWD_GETWD(dirname);
#endif
	}

	zendlval->value.str.len = strlen(dirname);
	zendlval->value.str.val = dirname;
	zendlval->type = IS_STRING;
	return T_DIR;
}
yy541:
		YYDEBUG(541, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy585;
		goto yy38;
yy542:
		YYDEBUG(542, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'I') goto yy587;
		goto yy38;
yy543:
		YYDEBUG(543, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy588;
		goto yy38;
yy544:
		YYDEBUG(544, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'D') goto yy590;
		goto yy38;
yy545:
		YYDEBUG(545, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'P') goto yy591;
		goto yy38;
yy546:
		YYDEBUG(546, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy592;
		goto yy38;
yy547:
		YYDEBUG(547, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy593;
		goto yy38;
yy548:
		YYDEBUG(548, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy594;
		goto yy38;
yy549:
		YYDEBUG(549, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy596;
		goto yy38;
yy550:
		YYDEBUG(550, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy598;
		goto yy38;
yy551:
		YYDEBUG(551, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(552, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DECLARE;
}
yy553:
		YYDEBUG(553, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(554, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_DEFAULT;
}
yy555:
		YYDEBUG(555, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy600;
		goto yy38;
yy556:
		YYDEBUG(556, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'a') goto yy601;
		goto yy38;
yy557:
		YYDEBUG(557, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy602;
		goto yy38;
yy558:
		YYDEBUG(558, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy603;
		goto yy38;
yy559:
		YYDEBUG(559, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(560, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_EXTENDS;
}
yy561:
		YYDEBUG(561, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(562, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FINALLY;
}
yy563:
		YYDEBUG(563, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(564, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FOREACH;
}
yy565:
		YYDEBUG(565, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy605;
		goto yy38;
yy566:
		YYDEBUG(566, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy607;
		goto yy38;
yy567:
		YYDEBUG(567, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy568, &&yy568, &&yy568, &&yy568, &&yy568, &&yy568,
				&&yy568, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy568, &&yy568, &&yy568, &&yy568, &&yy608,
				&&yy568, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy568, &&yy568, &&yy568, &&yy568, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy568:
		YYDEBUG(568, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE;
}
yy569:
		YYDEBUG(569, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy609;
		goto yy38;
yy570:
		YYDEBUG(570, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy610;
		goto yy38;
yy571:
		YYDEBUG(571, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy611;
		goto yy38;
yy572:
		YYDEBUG(572, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy612;
		goto yy38;
yy573:
		YYDEBUG(573, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(574, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PRIVATE;
}
yy575:
		YYDEBUG(575, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy613;
		goto yy38;
yy576:
		YYDEBUG(576, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy577, &&yy577, &&yy577, &&yy577, &&yy577, &&yy577,
				&&yy577, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy577, &&yy577, &&yy577, &&yy577, &&yy614,
				&&yy577, &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy577, &&yy577, &&yy577, &&yy577, &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,
				&&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37,  &&yy37
			};
			goto *yytarget[yych];
		}
yy577:
		YYDEBUG(577, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE;
}
yy578:
		YYDEBUG(578, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(579, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_STRING_CAST;
}
yy580:
		YYDEBUG(580, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(581, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_CAST;
}
yy582:
		YYDEBUG(582, *YYCURSOR);
		++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(583, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy582, &&yy582, &&yy85,  &&yy85,  &&yy582, &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy582, &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy135, &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,
				&&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85,  &&yy85
			};
			goto *yytarget[yych];
		}
yy584:
		YYDEBUG(584, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy615;
		goto yy38;
yy585:
		YYDEBUG(585, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(586, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	char *filename = zend_get_compiled_filename(TSRMLS_C);

	if (!filename) {
		filename = "";
	}
	zendlval->value.str.len = strlen(filename);
	zendlval->value.str.val = estrndup(filename, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FILE;
}
yy587:
		YYDEBUG(587, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'O') goto yy617;
		goto yy38;
yy588:
		YYDEBUG(588, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(589, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = CG(zend_lineno);
	zendlval->type = IS_LONG;
	return T_LINE;
}
yy590:
		YYDEBUG(590, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy618;
		goto yy38;
yy591:
		YYDEBUG(591, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'A') goto yy619;
		goto yy38;
yy592:
		YYDEBUG(592, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy620;
		goto yy38;
yy593:
		YYDEBUG(593, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy622;
		goto yy38;
yy594:
		YYDEBUG(594, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(595, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ABSTRACT;
}
yy596:
		YYDEBUG(596, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(597, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
 return T_CALLABLE;
}
yy598:
		YYDEBUG(598, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(599, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_CONTINUE;
}
yy600:
		YYDEBUG(600, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy623;
		goto yy38;
yy601:
		YYDEBUG(601, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy624;
		goto yy38;
yy602:
		YYDEBUG(602, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy625;
		goto yy38;
yy603:
		YYDEBUG(603, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(604, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDWHILE;
}
yy605:
		YYDEBUG(605, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(606, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_FUNCTION;
}
yy607:
		YYDEBUG(607, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 't') goto yy627;
		goto yy38;
yy608:
		YYDEBUG(608, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy628;
		goto yy38;
yy609:
		YYDEBUG(609, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy629;
		goto yy38;
yy610:
		YYDEBUG(610, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy630;
		goto yy38;
yy611:
		YYDEBUG(611, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy632;
		goto yy38;
yy612:
		YYDEBUG(612, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy634;
		goto yy38;
yy613:
		YYDEBUG(613, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'd') goto yy636;
		goto yy38;
yy614:
		YYDEBUG(614, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'o') goto yy638;
		goto yy38;
yy615:
		YYDEBUG(615, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(616, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT ==
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		/* We create a special __CLASS__ constant that is going to be resolved
		   at run-time */
		zendlval->value.str.len = sizeof("__CLASS__")-1;
		zendlval->value.str.val = estrndup("__CLASS__", zendlval->value.str.len);
		zendlval->type = IS_CONSTANT;
	} else {
		if (CG(active_class_entry)) {
			class_name = CG(active_class_entry)->name;
		}
		
		if (!class_name) {
			class_name = "";
		}
		
		zendlval->value.str.len = strlen(class_name);
		zendlval->value.str.val = estrndup(class_name, zendlval->value.str.len);
		zendlval->type = IS_STRING;
	}
	return T_CLASS_C;
}
yy617:
		YYDEBUG(617, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'N') goto yy639;
		goto yy38;
yy618:
		YYDEBUG(618, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy640;
		goto yy38;
yy619:
		YYDEBUG(619, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'C') goto yy642;
		goto yy38;
yy620:
		YYDEBUG(620, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(621, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *trait_name = NULL;
	
	if (CG(active_class_entry)
		&& (ZEND_ACC_TRAIT == 
			(CG(active_class_entry)->ce_flags & ZEND_ACC_TRAIT))) {
		trait_name = CG(active_class_entry)->name;
	}
	
	if (!trait_name) {
		trait_name = "";
	}
	
	zendlval->value.str.len = strlen(trait_name);
	zendlval->value.str.val = estrndup(trait_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	
	return T_TRAIT_C;
}
yy622:
		YYDEBUG(622, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'm') goto yy643;
		goto yy38;
yy623:
		YYDEBUG(623, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy644;
		goto yy38;
yy624:
		YYDEBUG(624, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy646;
		goto yy38;
yy625:
		YYDEBUG(625, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(626, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDSWITCH;
}
yy627:
		YYDEBUG(627, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 's') goto yy648;
		goto yy38;
yy628:
		YYDEBUG(628, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy650;
		goto yy38;
yy629:
		YYDEBUG(629, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'f') goto yy651;
		goto yy38;
yy630:
		YYDEBUG(630, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(631, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
        return T_INSTEADOF;
}
yy632:
		YYDEBUG(632, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(633, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INTERFACE;
}
yy634:
		YYDEBUG(634, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(635, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_NAMESPACE;
}
yy636:
		YYDEBUG(636, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(637, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_PROTECTED;
}
yy638:
		YYDEBUG(638, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'n') goto yy653;
		goto yy38;
yy639:
		YYDEBUG(639, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy654;
		goto yy38;
yy640:
		YYDEBUG(640, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(641, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *class_name = CG(active_class_entry) ? CG(active_class_entry)->name : NULL;
	const char *func_name = CG(active_op_array)? CG(active_op_array)->function_name : NULL;
	size_t len = 0;

	if (class_name) {
		len += strlen(class_name) + 2;
	}
	if (func_name) {
		len += strlen(func_name);
	}

	zendlval->value.str.len = zend_spprintf(&zendlval->value.str.val, 0, "%s%s%s",
		class_name ? class_name : "",
		class_name && func_name ? "::" : "",
		func_name ? func_name : ""
		);
	zendlval->type = IS_STRING;
	return T_METHOD_C;
}
yy642:
		YYDEBUG(642, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'E') goto yy655;
		goto yy38;
yy643:
		YYDEBUG(643, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy656;
		goto yy38;
yy644:
		YYDEBUG(644, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(645, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDDECLARE;
}
yy646:
		YYDEBUG(646, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(647, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_ENDFOREACH;
}
yy648:
		YYDEBUG(648, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(649, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_IMPLEMENTS;
}
yy650:
		YYDEBUG(650, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy657;
		goto yy38;
yy651:
		YYDEBUG(651, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(652, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INSTANCEOF;
}
yy653:
		YYDEBUG(653, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy658;
		goto yy38;
yy654:
		YYDEBUG(654, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy659;
		goto yy38;
yy655:
		YYDEBUG(655, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy661;
		goto yy38;
yy656:
		YYDEBUG(656, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy662;
		goto yy38;
yy657:
		YYDEBUG(657, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy663;
		goto yy38;
yy658:
		YYDEBUG(658, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'e') goto yy665;
		goto yy38;
yy659:
		YYDEBUG(659, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(660, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	const char *func_name = NULL;

	if (CG(active_op_array)) {
		func_name = CG(active_op_array)->function_name;
	}

	if (!func_name) {
		func_name = "";
	}
	zendlval->value.str.len = strlen(func_name);
	zendlval->value.str.val = estrndup(func_name, zendlval->value.str.len);
	zendlval->type = IS_STRING;
	return T_FUNC_C;
}
yy661:
		YYDEBUG(661, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '_') goto yy667;
		goto yy38;
yy662:
		YYDEBUG(662, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy669;
		goto yy38;
yy663:
		YYDEBUG(663, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(664, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_INCLUDE_ONCE;
}
yy665:
		YYDEBUG(665, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(666, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_REQUIRE_ONCE;
}
yy667:
		YYDEBUG(667, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(668, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(current_namespace)) {
		*zendlval = *CG(current_namespace);
		zval_copy_ctor(zendlval);
	} else {
		ZVAL_EMPTY_STRING(zendlval);
	}
	return T_NS_C;
}
yy669:
		YYDEBUG(669, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy38;
		YYDEBUG(670, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'r') goto yy38;
		YYDEBUG(671, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 16) {
			goto yy37;
		}
		YYDEBUG(672, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_HALT_COMPILER;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_PROPERTY:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,  64,  64,   0,   0,  64,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			 64,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(673, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy675, &&yy677, &&yy677, &&yy675, &&yy675, &&yy677, &&yy675, &&yy675,
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy677, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy680, &&yy675, &&yy675,
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675, &&yy675,
				&&yy675, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy675, &&yy675, &&yy675, &&yy675, &&yy681,
				&&yy675, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy675, &&yy675, &&yy675, &&yy675, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681,
				&&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681, &&yy681
			};
			goto *yytarget[yych];
		}
yy675:
		YYDEBUG(675, *YYCURSOR);
		++YYCURSOR;
yy676:
		YYDEBUG(676, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	goto restart;
}
yy677:
		YYDEBUG(677, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(678, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy677;
		}
		YYDEBUG(679, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_WHITESPACE;
}
yy680:
		YYDEBUG(680, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy684;
		goto yy676;
yy681:
		YYDEBUG(681, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(682, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy681;
		}
		YYDEBUG(683, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy684:
		YYDEBUG(684, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(685, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	return T_OBJECT_OPERATOR;
}
	}
/* *********************************** */
yyc_ST_BACKQUOTE:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(686, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych == '$') goto yy690;
		} else {
			if (yych <= '`') goto yy691;
			if (yych == '{') goto yy693;
		}
		YYDEBUG(688, *YYCURSOR);
		++YYCURSOR;
yy689:
		YYDEBUG(689, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '`':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '`' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy690:
		YYDEBUG(690, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689, &&yy689,
				&&yy689, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy689, &&yy689, &&yy689, &&yy689, &&yy694,
				&&yy689, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy697, &&yy689, &&yy689, &&yy689, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694,
				&&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694, &&yy694
			};
			goto *yytarget[yych];
		}
yy691:
		YYDEBUG(691, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(692, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '`';
}
yy693:
		YYDEBUG(693, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy699;
		goto yy689;
yy694:
		YYDEBUG(694, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(695, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy694;
		}
		if (yych == '-') goto yy701;
		if (yych <= '@') goto yy696;
		if (yych <= '[') goto yy703;
yy696:
		YYDEBUG(696, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy697:
		YYDEBUG(697, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(698, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy699:
		YYDEBUG(699, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(700, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy701:
		YYDEBUG(701, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy705;
yy702:
		YYDEBUG(702, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy696;
yy703:
		YYDEBUG(703, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(704, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy705:
		YYDEBUG(705, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy702;
			if (yych <= 'Z') goto yy706;
			if (yych <= '^') goto yy702;
		} else {
			if (yych <= '`') goto yy702;
			if (yych <= 'z') goto yy706;
			if (yych <= '~') goto yy702;
		}
yy706:
		YYDEBUG(706, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(707, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_DOUBLE_QUOTES:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(708, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '#') {
			if (yych == '"') goto yy712;
		} else {
			if (yych <= '$') goto yy714;
			if (yych == '{') goto yy715;
		}
		YYDEBUG(710, *YYCURSOR);
		++YYCURSOR;
yy711:
		YYDEBUG(711, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (GET_DOUBLE_QUOTES_SCANNED_LENGTH()) {
		YYCURSOR += GET_DOUBLE_QUOTES_SCANNED_LENGTH() - 1;
		SET_DOUBLE_QUOTES_SCANNED_LENGTH(0);

		goto double_quotes_scan_done;
	}

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}
	if (yytext[0] == '\\' && YYCURSOR < YYLIMIT) {
		YYCURSOR++;
	}

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '"':
				break;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT) {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

double_quotes_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng, '"' TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy712:
		YYDEBUG(712, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(713, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	BEGIN(ST_IN_SCRIPTING);
	return '"';
}
yy714:
		YYDEBUG(714, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711, &&yy711,
				&&yy711, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy711, &&yy711, &&yy711, &&yy711, &&yy716,
				&&yy711, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy719, &&yy711, &&yy711, &&yy711, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716,
				&&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716, &&yy716
			};
			goto *yytarget[yych];
		}
yy715:
		YYDEBUG(715, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy721;
		goto yy711;
yy716:
		YYDEBUG(716, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(717, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy716;
		}
		if (yych == '-') goto yy723;
		if (yych <= '@') goto yy718;
		if (yych <= '[') goto yy725;
yy718:
		YYDEBUG(718, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy719:
		YYDEBUG(719, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(720, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy721:
		YYDEBUG(721, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(722, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy723:
		YYDEBUG(723, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy727;
yy724:
		YYDEBUG(724, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy718;
yy725:
		YYDEBUG(725, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(726, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy727:
		YYDEBUG(727, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy724;
			if (yych <= 'Z') goto yy728;
			if (yych <= '^') goto yy724;
		} else {
			if (yych <= '`') goto yy724;
			if (yych <= 'z') goto yy728;
			if (yych <= '~') goto yy724;
		}
yy728:
		YYDEBUG(728, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(729, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_HEREDOC:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(730, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych == '$') goto yy734;
		if (yych == '{') goto yy735;
		YYDEBUG(732, *YYCURSOR);
		++YYCURSOR;
yy733:
		YYDEBUG(733, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto heredoc_scan_done;
					}
				}
				continue;
			case '$':
				if (IS_LABEL_START(*YYCURSOR) || *YYCURSOR == '{') {
					break;
				}
				continue;
			case '{':
				if (*YYCURSOR == '$') {
					break;
				}
				continue;
			case '\\':
				if (YYCURSOR < YYLIMIT && *YYCURSOR != '\n' && *YYCURSOR != '\r') {
					YYCURSOR++;
				}
				/* fall through */
			default:
				continue;
		}

		YYCURSOR--;
		break;
	}

heredoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_scan_escape_string(zendlval, yytext, yyleng - newline, 0 TSRMLS_CC);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy734:
		YYDEBUG(734, *YYCURSOR);
		yych = *++YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733, &&yy733,
				&&yy733, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy733, &&yy733, &&yy733, &&yy733, &&yy736,
				&&yy733, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy739, &&yy733, &&yy733, &&yy733, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736,
				&&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736, &&yy736
			};
			goto *yytarget[yych];
		}
yy735:
		YYDEBUG(735, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '$') goto yy741;
		goto yy733;
yy736:
		YYDEBUG(736, *YYCURSOR);
		YYMARKER = ++YYCURSOR;
		YYFILL(3);
		yych = *YYCURSOR;
		YYDEBUG(737, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy736;
		}
		if (yych == '-') goto yy743;
		if (yych <= '@') goto yy738;
		if (yych <= '[') goto yy745;
yy738:
		YYDEBUG(738, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy739:
		YYDEBUG(739, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(740, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_push_state(ST_LOOKING_FOR_VARNAME TSRMLS_CC);
	return T_DOLLAR_OPEN_CURLY_BRACES;
}
yy741:
		YYDEBUG(741, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(742, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.lval = (long) '{';
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	yyless(1);
	return T_CURLY_OPEN;
}
yy743:
		YYDEBUG(743, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '>') goto yy747;
yy744:
		YYDEBUG(744, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy738;
yy745:
		YYDEBUG(745, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(746, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	yy_push_state(ST_VAR_OFFSET TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy747:
		YYDEBUG(747, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy744;
			if (yych <= 'Z') goto yy748;
			if (yych <= '^') goto yy744;
		} else {
			if (yych <= '`') goto yy744;
			if (yych <= 'z') goto yy748;
			if (yych <= '~') goto yy744;
		}
yy748:
		YYDEBUG(748, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(749, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 3);
	yy_push_state(ST_LOOKING_FOR_PROPERTY TSRMLS_CC);
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
	}
/* *********************************** */
yyc_ST_LOOKING_FOR_VARNAME:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			  0, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128,   0,   0,   0,   0, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
			128, 128, 128, 128, 128, 128, 128, 128, 
		};
		YYDEBUG(750, *YYCURSOR);
		YYFILL(2);
		yych = *YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy752;
			if (yych <= 'Z') goto yy754;
			if (yych >= '_') goto yy754;
		} else {
			if (yych <= '`') goto yy752;
			if (yych <= 'z') goto yy754;
			if (yych >= 0x7F) goto yy754;
		}
yy752:
		YYDEBUG(752, *YYCURSOR);
		++YYCURSOR;
yy753:
		YYDEBUG(753, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(0);
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	goto restart;
}
yy754:
		YYDEBUG(754, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753, &&yy753,
				&&yy753, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy753, &&yy753, &&yy753, &&yy756,
				&&yy753, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy753, &&yy753, &&yy756, &&yy753, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756,
				&&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756, &&yy756
			};
			goto *yytarget[yych];
		}
yy755:
		YYDEBUG(755, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
yy756:
		YYDEBUG(756, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy755;
		}
		if (yych <= '@') goto yy757;
		if (yych <= '[') goto yy758;
		if (yych == '}') goto yy758;
yy757:
		YYDEBUG(757, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy753;
yy758:
		YYDEBUG(758, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(759, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yyless(yyleng - 1);
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	yy_pop_state(TSRMLS_C);
	yy_push_state(ST_IN_SCRIPTING TSRMLS_CC);
	return T_STRING_VARNAME;
}
	}
/* *********************************** */
yyc_ST_VAR_OFFSET:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			240, 240, 176, 176, 176, 176, 176, 176, 
			176, 176,   0,   0,   0,   0,   0,   0, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			  0, 160, 160, 160, 160, 160, 160,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,   0,   0,   0,   0,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
			 32,  32,  32,  32,  32,  32,  32,  32, 
		};
		YYDEBUG(760, *YYCURSOR);
		YYFILL(3);
		yych = *YYCURSOR;
		{
			static void *yytarget[256] = {
				&&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762,
				&&yy762, &&yy764, &&yy764, &&yy762, &&yy762, &&yy764, &&yy762, &&yy762,
				&&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762,
				&&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762, &&yy762,
				&&yy764, &&yy766, &&yy766, &&yy764, &&yy768, &&yy766, &&yy766, &&yy764,
				&&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy769, &&yy771, &&yy771, &&yy771, &&yy771, &&yy771, &&yy771, &&yy771,
				&&yy771, &&yy771, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766, &&yy766,
				&&yy766, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy766, &&yy764, &&yy776, &&yy766, &&yy773,
				&&yy766, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy766, &&yy766, &&yy766, &&yy766, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773,
				&&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773, &&yy773
			};
			goto *yytarget[yych];
		}
yy762:
		YYDEBUG(762, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(763, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	zend_error(E_COMPILE_WARNING,"Unexpected character in input:  '%c' (ASCII=%d) state=%d", yytext[0], yytext[0], YYSTATE);
	goto restart;
}
yy764:
		YYDEBUG(764, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(765, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Invalid rule to return a more explicit parse error with proper line number */
	yyless(0);
	yy_pop_state(TSRMLS_C);
	return T_ENCAPSED_AND_WHITESPACE;
}
yy766:
		YYDEBUG(766, *YYCURSOR);
		++YYCURSOR;
yy767:
		YYDEBUG(767, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	/* Only '[' can be valid, but returning other tokens will allow a more explicit parse error */
	return yytext[0];
}
yy768:
		YYDEBUG(768, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '_') {
			if (yych <= '@') goto yy767;
			if (yych <= 'Z') goto yy778;
			if (yych <= '^') goto yy767;
			goto yy778;
		} else {
			if (yych <= '`') goto yy767;
			if (yych <= 'z') goto yy778;
			if (yych <= '~') goto yy767;
			goto yy778;
		}
yy769:
		YYDEBUG(769, *YYCURSOR);
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= 'a') {
			if (yych <= '/') goto yy770;
			if (yych <= '9') goto yy781;
		} else {
			if (yych <= 'b') goto yy784;
			if (yych == 'x') goto yy786;
		}
yy770:
		YYDEBUG(770, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset could be treated as a long */
	if (yyleng < MAX_LENGTH_OF_LONG - 1 || (yyleng == MAX_LENGTH_OF_LONG - 1 && strcmp(yytext, long_min_digits) < 0)) {
		zendlval->value.lval = strtol(yytext, NULL, 10);
		zendlval->type = IS_LONG;
	} else {
		zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
	}
	return T_NUM_STRING;
}
yy771:
		YYDEBUG(771, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(772, *YYCURSOR);
		if (yybm[0+yych] & 16) {
			goto yy771;
		}
		goto yy770;
yy773:
		YYDEBUG(773, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(774, *YYCURSOR);
		if (yybm[0+yych] & 32) {
			goto yy773;
		}
		YYDEBUG(775, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, yytext, yyleng);
	zendlval->type = IS_STRING;
	return T_STRING;
}
yy776:
		YYDEBUG(776, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(777, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	yy_pop_state(TSRMLS_C);
	return ']';
}
yy778:
		YYDEBUG(778, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(779, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780, &&yy780,
				&&yy780, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy780, &&yy780, &&yy780, &&yy780, &&yy778,
				&&yy780, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy780, &&yy780, &&yy780, &&yy780, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778,
				&&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778, &&yy778
			};
			goto *yytarget[yych];
		}
yy780:
		YYDEBUG(780, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zend_copy_value(zendlval, (yytext+1), (yyleng-1));
	zendlval->type = IS_STRING;
	return T_VARIABLE;
}
yy781:
		YYDEBUG(781, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(782, *YYCURSOR);
		if (yych <= '/') goto yy783;
		if (yych <= '9') goto yy781;
yy783:
		YYDEBUG(783, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{ /* Offset must be treated as a string */
	zendlval->value.str.val = (char *)estrndup(yytext, yyleng);
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	return T_NUM_STRING;
}
yy784:
		YYDEBUG(784, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 64) {
			goto yy787;
		}
yy785:
		YYDEBUG(785, *YYCURSOR);
		YYCURSOR = YYMARKER;
		goto yy770;
yy786:
		YYDEBUG(786, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yybm[0+yych] & 128) {
			goto yy789;
		}
		goto yy785;
yy787:
		YYDEBUG(787, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(788, *YYCURSOR);
		if (yybm[0+yych] & 64) {
			goto yy787;
		}
		goto yy783;
yy789:
		YYDEBUG(789, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(790, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy789;
		}
		goto yy783;
	}
/* *********************************** */
yyc_INITIAL:
	{
		static const unsigned char yybm[] = {
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0, 128, 128,   0,   0, 128,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			128,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
			  0,   0,   0,   0,   0,   0,   0,   0, 
		};
		YYDEBUG(791, *YYCURSOR);
		YYFILL(8);
		yych = *YYCURSOR;
		if (yych == '<') goto yy795;
		YYDEBUG(793, *YYCURSOR);
		++YYCURSOR;
yy794:
		YYDEBUG(794, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

inline_char_handler:

	while (1) {
		YYCTYPE *ptr = memchr(YYCURSOR, '<', YYLIMIT - YYCURSOR);

		YYCURSOR = ptr ? ptr + 1 : YYLIMIT;

		if (YYCURSOR < YYLIMIT) {
			switch (*YYCURSOR) {
				case '?':
					if (CG(short_tags) || !strncasecmp((char*)YYCURSOR + 1, "php", 3) || (*(YYCURSOR + 1) == '=')) { /* Assume [ \t\n\r] follows "php" */
						break;
					}
					continue;
				case '%':
					if (CG(asp_tags)) {
						break;
					}
					continue;
				case 's':
				case 'S':
					/* Probably NOT an opening PHP <script> tag, so don't end the HTML chunk yet
					 * If it is, the PHP <script> tag rule checks for any HTML scanned before it */
					YYCURSOR--;
					yymore();
				default:
					continue;
			}

			YYCURSOR--;
		}

		break;
	}

inline_html:
	yyleng = YYCURSOR - SCNG(yy_text);

	if (SCNG(output_filter)) {
		int readsize;
		size_t sz = 0;
		readsize = SCNG(output_filter)((unsigned char **)&(zendlval->value.str.val), &sz, (unsigned char *)yytext, (size_t)yyleng TSRMLS_CC);
		zendlval->value.str.len = sz;
		if (readsize < yyleng) {
			yyless(readsize);
		}
	} else {
	  zendlval->value.str.val = (char *) estrndup(yytext, yyleng);
	  zendlval->value.str.len = yyleng;
	}
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng);
	return T_INLINE_HTML;
}
yy795:
		YYDEBUG(795, *YYCURSOR);
		yyaccept = 0;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych <= '>') {
			if (yych != '%') goto yy794;
		} else {
			if (yych <= '?') goto yy798;
			if (yych == 's') goto yy800;
			goto yy794;
		}
		YYDEBUG(796, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '=') goto yy802;
		YYDEBUG(797, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy798:
		YYDEBUG(798, *YYCURSOR);
		yyaccept = 1;
		yych = *(YYMARKER = ++YYCURSOR);
		if (yych == '=') goto yy804;
		if (yych == 'p') goto yy806;
yy799:
		YYDEBUG(799, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(short_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG;
	} else {
		goto inline_char_handler;
	}
}
yy800:
		YYDEBUG(800, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'c') goto yy807;
yy801:
		YYDEBUG(801, *YYCURSOR);
		YYCURSOR = YYMARKER;
		if (yyaccept == 0) {
			goto yy794;
		} else {
			goto yy799;
		}
yy802:
		YYDEBUG(802, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(803, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	if (CG(asp_tags)) {
		zendlval->value.str.val = yytext; /* no copying - intentional */
		zendlval->value.str.len = yyleng;
		zendlval->type = IS_STRING;
		BEGIN(ST_IN_SCRIPTING);
		return T_OPEN_TAG_WITH_ECHO;
	} else {
		goto inline_char_handler;
	}
}
yy804:
		YYDEBUG(804, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(805, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG_WITH_ECHO;
}
yy806:
		YYDEBUG(806, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy808;
		goto yy801;
yy807:
		YYDEBUG(807, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'r') goto yy809;
		goto yy801;
yy808:
		YYDEBUG(808, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy810;
		goto yy801;
yy809:
		YYDEBUG(809, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'i') goto yy811;
		goto yy801;
yy810:
		YYDEBUG(810, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych <= '\f') {
			if (yych <= 0x08) goto yy801;
			if (yych <= '\n') goto yy812;
			goto yy801;
		} else {
			if (yych <= '\r') goto yy814;
			if (yych == ' ') goto yy812;
			goto yy801;
		}
yy811:
		YYDEBUG(811, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy815;
		goto yy801;
yy812:
		YYDEBUG(812, *YYCURSOR);
		++YYCURSOR;
yy813:
		YYDEBUG(813, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	HANDLE_NEWLINE(yytext[yyleng-1]);
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
yy814:
		YYDEBUG(814, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\n') goto yy812;
		goto yy813;
yy815:
		YYDEBUG(815, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 't') goto yy801;
		YYDEBUG(816, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'l') goto yy801;
		goto yy818;
yy817:
		YYDEBUG(817, *YYCURSOR);
		++YYCURSOR;
		YYFILL(8);
		yych = *YYCURSOR;
yy818:
		YYDEBUG(818, *YYCURSOR);
		if (yybm[0+yych] & 128) {
			goto yy817;
		}
		if (yych != 'l') goto yy801;
		YYDEBUG(819, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy801;
		YYDEBUG(820, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'n') goto yy801;
		YYDEBUG(821, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy801;
		YYDEBUG(822, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'u') goto yy801;
		YYDEBUG(823, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'a') goto yy801;
		YYDEBUG(824, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'g') goto yy801;
		YYDEBUG(825, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych != 'e') goto yy801;
yy826:
		YYDEBUG(826, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(827, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy826, &&yy826, &&yy801, &&yy801, &&yy826, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy826, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy828, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801
			};
			goto *yytarget[yych];
		}
yy828:
		YYDEBUG(828, *YYCURSOR);
		++YYCURSOR;
		YYFILL(5);
		yych = *YYCURSOR;
		YYDEBUG(829, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy828, &&yy828, &&yy801, &&yy801, &&yy828, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy828, &&yy801, &&yy830, &&yy801, &&yy801, &&yy801, &&yy801, &&yy831,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy832, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801
			};
			goto *yytarget[yych];
		}
yy830:
		YYDEBUG(830, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy833;
		goto yy801;
yy831:
		YYDEBUG(831, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy834;
		goto yy801;
yy832:
		YYDEBUG(832, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy835;
		goto yy801;
yy833:
		YYDEBUG(833, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy836;
		goto yy801;
yy834:
		YYDEBUG(834, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'h') goto yy837;
		goto yy801;
yy835:
		YYDEBUG(835, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy838;
		goto yy801;
yy836:
		YYDEBUG(836, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy840;
		goto yy801;
yy837:
		YYDEBUG(837, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == 'p') goto yy841;
		goto yy801;
yy838:
		YYDEBUG(838, *YYCURSOR);
		++YYCURSOR;
		YYFILL(1);
		yych = *YYCURSOR;
		YYDEBUG(839, *YYCURSOR);
		{
			static void *yytarget[256] = {
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy838, &&yy838, &&yy801, &&yy801, &&yy838, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy838, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy842, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801,
				&&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801, &&yy801
			};
			goto *yytarget[yych];
		}
yy840:
		YYDEBUG(840, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '"') goto yy838;
		goto yy801;
yy841:
		YYDEBUG(841, *YYCURSOR);
		yych = *++YYCURSOR;
		if (yych == '\'') goto yy838;
		goto yy801;
yy842:
		YYDEBUG(842, *YYCURSOR);
		++YYCURSOR;
		YYDEBUG(843, *YYCURSOR);
		yyleng = YYCURSOR - SCNG(yy_text);
		{
	YYCTYPE *bracket = (YYCTYPE*)zend_memrchr(yytext, '<', yyleng - (sizeof("script language=php>") - 1));

	if (bracket != SCNG(yy_text)) {
		/* Handle previously scanned HTML, as possible <script> tags found are assumed to not be PHP's */
		YYCURSOR = bracket;
		goto inline_html;
	}

	HANDLE_NEWLINES(yytext, yyleng);
	zendlval->value.str.val = yytext; /* no copying - intentional */
	zendlval->value.str.len = yyleng;
	zendlval->type = IS_STRING;
	BEGIN(ST_IN_SCRIPTING);
	return T_OPEN_TAG;
}
	}
/* *********************************** */
yyc_ST_END_HEREDOC:
	YYDEBUG(844, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(846, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(847, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	zend_heredoc_label *heredoc_label = zend_ptr_stack_pop(&SCNG(heredoc_label_stack));

	YYCURSOR += heredoc_label->length - 1;
	yyleng = heredoc_label->length;

	heredoc_label_dtor(heredoc_label);
	efree(heredoc_label);

	BEGIN(ST_IN_SCRIPTING);
	return T_END_HEREDOC;
}
/* *********************************** */
yyc_ST_NOWDOC:
	YYDEBUG(848, *YYCURSOR);
	YYFILL(1);
	yych = *YYCURSOR;
	YYDEBUG(850, *YYCURSOR);
	++YYCURSOR;
	YYDEBUG(851, *YYCURSOR);
	yyleng = YYCURSOR - SCNG(yy_text);
	{
	int newline = 0;

	zend_heredoc_label *heredoc_label = zend_ptr_stack_top(&SCNG(heredoc_label_stack));

	if (YYCURSOR > YYLIMIT) {
		return 0;
	}

	YYCURSOR--;

	while (YYCURSOR < YYLIMIT) {
		switch (*YYCURSOR++) {
			case '\r':
				if (*YYCURSOR == '\n') {
					YYCURSOR++;
				}
				/* fall through */
			case '\n':
				/* Check for ending label on the next line */
				if (IS_LABEL_START(*YYCURSOR) && heredoc_label->length < YYLIMIT - YYCURSOR && !memcmp(YYCURSOR, heredoc_label->label, heredoc_label->length)) {
					YYCTYPE *end = YYCURSOR + heredoc_label->length;

					if (*end == ';') {
						end++;
					}

					if (*end == '\n' || *end == '\r') {
						/* newline before label will be subtracted from returned text, but
						 * yyleng/yytext will include it, for zend_highlight/strip, tokenizer, etc. */
						if (YYCURSOR[-2] == '\r' && YYCURSOR[-1] == '\n') {
							newline = 2; /* Windows newline */
						} else {
							newline = 1;
						}

						CG(increment_lineno) = 1; /* For newline before label */
						BEGIN(ST_END_HEREDOC);

						goto nowdoc_scan_done;
					}
				}
				/* fall through */
			default:
				continue;
		}
	}

nowdoc_scan_done:
	yyleng = YYCURSOR - SCNG(yy_text);

	zend_copy_value(zendlval, yytext, yyleng - newline);
	zendlval->type = IS_STRING;
	HANDLE_NEWLINES(yytext, yyleng - newline);
	return T_ENCAPSED_AND_WHITESPACE;
}
}

}
php/php20140822_zend_language_scanner.igcd--flex-syntax.re:1016:12: warning: escape has no effect: '\[' [-Wuseless-escape]
php/php20140822_zend_language_scanner.igcd--flex-syntax.re:2441:2: warning: looks like you use hardcoded numbers instead of autogenerated condition names: better add '/*!types:re2c*/' directive or '-t, --type-header' option and don't rely on fixed condition order. [-Wcondition-order]
