/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the QtGui module of the Qt Toolkit.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial Usage
** Licensees holding valid Qt Commercial licenses may use this file in
** accordance with the Qt Commercial License Agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and Nokia.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 2.1 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU Lesser General Public License version 2.1 requirements
** will be met: http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain
** additional rights. These rights are described in the Nokia Qt LGPL
** Exception version 1.0, included in the file LGPL_EXCEPTION.txt in this
** package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 3.0 as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL included in the
** packaging of this file.  Please review the following information to
** ensure the GNU General Public License version 3.0 requirements will be
** met: http://www.gnu.org/copyleft/gpl.html.
**
** If you are unsure which license is appropriate for your use, please
** contact the sales department at http://www.qtsoftware.com/contact.
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QWINDOWSMOBILESTYLE_P_H
#define QWINDOWSMOBILESTYLE_P_H

//
//  W A R N I N G
//  -------------
//
// This file is not part of the Qt API.  It exists for the convenience
// of qapplication_*.cpp, qwidget*.cpp and qfiledialog.cpp.  This header
// file may change from version to version without notice, or even be removed.
//
// We mean it.
//

#include "qwindowsmobilestyle.h"
#include "qwindowsstyle_p.h"

QT_BEGIN_NAMESPACE

#ifndef QT_NO_STYLE_WINDOWSMOBILE

class QWindowsMobileStylePrivate : public QWindowsStylePrivate
{
    Q_DECLARE_PUBLIC(QWindowsMobileStyle)
public:
    QWindowsMobileStylePrivate();
    bool doubleControls;
    bool smartphone;

    QImage imageRadioButton;
    QImage imageRadioButtonChecked;
    QImage imageRadioButtonHighlighted;
    QImage imageChecked;
    QImage imageCheckedBold;
    QImage imageArrowDown;
    QImage imageArrowUp;
    QImage imageArrowLeft;
    QImage imageArrowRight;
    QImage imageArrowDownBig;
    QImage imageArrowUpBig;
    QImage imageArrowLeftBig;
    QImage imageArrowRightBig;
    QImage imageClose;
    QImage imageMaximize;
    QImage imageNormalize;
    QImage imageMinimize;
};

QT_END_NAMESPACE

#endif // QT_NO_STYLE_WINDOWSMOBILE
#endif //QWINDOWSMOBILESTYLE_P_H
