/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSHTMLOptionsCollection.h"

#include <wtf/GetPtr.h>

#include "HTMLOptionsCollection.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSHTMLOptionsCollection)

/* Hash table */

static const HashTableValue JSHTMLOptionsCollectionTableValues[3] =
{
    { "selectedIndex", DontDelete, (intptr_t)jsHTMLOptionsCollectionSelectedIndex, (intptr_t)setJSHTMLOptionsCollectionSelectedIndex },
    { "length", DontDelete, (intptr_t)jsHTMLOptionsCollectionLength, (intptr_t)setJSHTMLOptionsCollectionLength },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionsCollectionTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 3, JSHTMLOptionsCollectionTableValues, 0 };
#else
    { 4, 3, JSHTMLOptionsCollectionTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSHTMLOptionsCollectionPrototypeTableValues[3] =
{
    { "add", DontDelete|Function, (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionAdd, (intptr_t)2 },
    { "remove", DontDelete|Function, (intptr_t)jsHTMLOptionsCollectionPrototypeFunctionRemove, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSHTMLOptionsCollectionPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 1, JSHTMLOptionsCollectionPrototypeTableValues, 0 };
#else
    { 4, 3, JSHTMLOptionsCollectionPrototypeTableValues, 0 };
#endif

const ClassInfo JSHTMLOptionsCollectionPrototype::s_info = { "HTMLOptionsCollectionPrototype", 0, &JSHTMLOptionsCollectionPrototypeTable, 0 };

JSObject* JSHTMLOptionsCollectionPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLOptionsCollection>(exec, globalObject);
}

bool JSHTMLOptionsCollectionPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSHTMLOptionsCollectionPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSHTMLOptionsCollection::s_info = { "HTMLOptionsCollection", &JSHTMLCollection::s_info, &JSHTMLOptionsCollectionTable, 0 };

JSHTMLOptionsCollection::JSHTMLOptionsCollection(PassRefPtr<Structure> structure, PassRefPtr<HTMLOptionsCollection> impl)
    : JSHTMLCollection(structure, impl)
{
}

JSObject* JSHTMLOptionsCollection::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSHTMLOptionsCollectionPrototype(JSHTMLOptionsCollectionPrototype::createStructure(JSHTMLCollectionPrototype::self(exec, globalObject)));
}

bool JSHTMLOptionsCollection::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLOptionsCollection, Base>(exec, &JSHTMLOptionsCollectionTable, this, propertyName, slot);
}

JSValuePtr jsHTMLOptionsCollectionSelectedIndex(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(static_cast<JSHTMLOptionsCollection*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->selectedIndex());
}

JSValuePtr jsHTMLOptionsCollectionLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSHTMLOptionsCollection*>(asObject(slot.slotBase()))->length(exec);
}

void JSHTMLOptionsCollection::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok) {
        indexSetter(exec, index, value);
        return;
    }
    lookupPut<JSHTMLOptionsCollection, Base>(exec, propertyName, value, &JSHTMLOptionsCollectionTable, this, slot);
}

void JSHTMLOptionsCollection::put(ExecState* exec, unsigned propertyName, JSValuePtr value)
{
    indexSetter(exec, propertyName, value);
    return;
}

void setJSHTMLOptionsCollectionSelectedIndex(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    HTMLOptionsCollection* imp = static_cast<HTMLOptionsCollection*>(static_cast<JSHTMLOptionsCollection*>(thisObject)->impl());
    imp->setSelectedIndex(value->toInt32(exec));
}

void setJSHTMLOptionsCollectionLength(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    static_cast<JSHTMLOptionsCollection*>(thisObject)->setLength(exec, value);
}

JSValuePtr jsHTMLOptionsCollectionPrototypeFunctionAdd(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLOptionsCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(asObject(thisValue));
    return castedThisObj->add(exec, args);
}

JSValuePtr jsHTMLOptionsCollectionPrototypeFunctionRemove(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSHTMLOptionsCollection::s_info))
        return throwError(exec, TypeError);
    JSHTMLOptionsCollection* castedThisObj = static_cast<JSHTMLOptionsCollection*>(asObject(thisValue));
    return castedThisObj->remove(exec, args);
}

HTMLOptionsCollection* toHTMLOptionsCollection(JSC::JSValuePtr value)
{
    return value->isObject(&JSHTMLOptionsCollection::s_info) ? static_cast<JSHTMLOptionsCollection*>(asObject(value))->impl() : 0;
}

}
