/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#include "JSCSSStyleDeclaration.h"

#include <wtf/GetPtr.h>

#include <runtime/PropertyNameArray.h>
#include "AtomicString.h"
#include "CSSRule.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSRule.h"
#include "JSCSSStyleDeclarationCustom.h"
#include "JSCSSValue.h"
#include "KURL.h"

#include <runtime/Error.h>
#include <runtime/JSNumberCell.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSStyleDeclaration)

/* Hash table */

static const HashTableValue JSCSSStyleDeclarationTableValues[5] =
{
    { "cssText", DontDelete, (intptr_t)jsCSSStyleDeclarationCssText, (intptr_t)setJSCSSStyleDeclarationCssText },
    { "length", DontDelete|ReadOnly, (intptr_t)jsCSSStyleDeclarationLength, (intptr_t)0 },
    { "parentRule", DontDelete|ReadOnly, (intptr_t)jsCSSStyleDeclarationParentRule, (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)jsCSSStyleDeclarationConstructor, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 63, JSCSSStyleDeclarationTableValues, 0 };
#else
    { 10, 7, JSCSSStyleDeclarationTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSStyleDeclarationConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSStyleDeclarationConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSStyleDeclarationConstructorTableValues, 0 };
#endif

class JSCSSStyleDeclarationConstructor : public DOMObject {
public:
    JSCSSStyleDeclarationConstructor(ExecState* exec)
        : DOMObject(JSCSSStyleDeclarationConstructor::createStructure(exec->lexicalGlobalObject()->objectPrototype()))
    {
        putDirect(exec->propertyNames().prototype, JSCSSStyleDeclarationPrototype::self(exec), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValuePtr proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, ImplementsHasInstance)); 
    }
};

const ClassInfo JSCSSStyleDeclarationConstructor::s_info = { "CSSStyleDeclarationConstructor", 0, &JSCSSStyleDeclarationConstructorTable, 0 };

bool JSCSSStyleDeclarationConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSStyleDeclarationConstructor, DOMObject>(exec, &JSCSSStyleDeclarationConstructorTable, this, propertyName, slot);
}

/* Hash table for prototype */

static const HashTableValue JSCSSStyleDeclarationPrototypeTableValues[9] =
{
    { "getPropertyValue", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue, (intptr_t)1 },
    { "getPropertyCSSValue", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue, (intptr_t)1 },
    { "removeProperty", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionRemoveProperty, (intptr_t)1 },
    { "getPropertyPriority", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority, (intptr_t)1 },
    { "setProperty", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionSetProperty, (intptr_t)3 },
    { "item", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionItem, (intptr_t)1 },
    { "getPropertyShorthand", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand, (intptr_t)1 },
    { "isPropertyImplicit", DontDelete|Function, (intptr_t)jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static const HashTable JSCSSStyleDeclarationPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 31, JSCSSStyleDeclarationPrototypeTableValues, 0 };
#else
    { 17, 15, JSCSSStyleDeclarationPrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSStyleDeclarationPrototype::s_info = { "CSSStyleDeclarationPrototype", 0, &JSCSSStyleDeclarationPrototypeTable, 0 };

JSObject* JSCSSStyleDeclarationPrototype::self(ExecState* exec)
{
    return getDOMPrototype<JSCSSStyleDeclaration>(exec);
}

bool JSCSSStyleDeclarationPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSCSSStyleDeclarationPrototypeTable, this, propertyName, slot);
}

const ClassInfo JSCSSStyleDeclaration::s_info = { "CSSStyleDeclaration", 0, &JSCSSStyleDeclarationTable, 0 };

JSCSSStyleDeclaration::JSCSSStyleDeclaration(PassRefPtr<Structure> structure, PassRefPtr<CSSStyleDeclaration> impl)
    : DOMObject(structure)
    , m_impl(impl)
{
}

JSCSSStyleDeclaration::~JSCSSStyleDeclaration()
{
    forgetDOMObject(*Heap::heap(this)->globalData(), m_impl.get());

}

JSObject* JSCSSStyleDeclaration::createPrototype(ExecState* exec)
{
    return new (exec) JSCSSStyleDeclarationPrototype(JSCSSStyleDeclarationPrototype::createStructure(exec->lexicalGlobalObject()->objectPrototype()));
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    const HashEntry* entry = JSCSSStyleDeclarationTable.entry(exec, propertyName);
    if (entry) {
        slot.setCustom(this, entry->propertyGetter());
        return true;
    }
    bool ok;
    unsigned index = propertyName.toUInt32(&ok, false);
    if (ok && index < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, index, indexGetter);
        return true;
    }
    if (canGetItemsForName(exec, static_cast<CSSStyleDeclaration*>(impl()), propertyName)) {
        slot.setCustom(this, nameGetter);
        return true;
    }
    return getStaticValueSlot<JSCSSStyleDeclaration, Base>(exec, &JSCSSStyleDeclarationTable, this, propertyName, slot);
}

bool JSCSSStyleDeclaration::getOwnPropertySlot(ExecState* exec, unsigned propertyName, PropertySlot& slot)
{
    if (propertyName < static_cast<CSSStyleDeclaration*>(impl())->length()) {
        slot.setCustomIndex(this, propertyName, indexGetter);
        return true;
    }
    return getOwnPropertySlot(exec, Identifier::from(exec, propertyName), slot);
}

JSValuePtr jsCSSStyleDeclarationCssText(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(static_cast<JSCSSStyleDeclaration*>(asObject(slot.slotBase()))->impl());
    return jsStringOrNull(exec, imp->cssText());
}

JSValuePtr jsCSSStyleDeclarationLength(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(static_cast<JSCSSStyleDeclaration*>(asObject(slot.slotBase()))->impl());
    return jsNumber(exec, imp->length());
}

JSValuePtr jsCSSStyleDeclarationParentRule(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(static_cast<JSCSSStyleDeclaration*>(asObject(slot.slotBase()))->impl());
    return toJS(exec, WTF::getPtr(imp->parentRule()));
}

JSValuePtr jsCSSStyleDeclarationConstructor(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    return static_cast<JSCSSStyleDeclaration*>(asObject(slot.slotBase()))->getConstructor(exec);
}
void JSCSSStyleDeclaration::put(ExecState* exec, const Identifier& propertyName, JSValuePtr value, PutPropertySlot& slot)
{
    if (customPut(exec, propertyName, value, slot))
        return;
    lookupPut<JSCSSStyleDeclaration, Base>(exec, propertyName, value, &JSCSSStyleDeclarationTable, this, slot);
}

void setJSCSSStyleDeclarationCssText(ExecState* exec, JSObject* thisObject, JSValuePtr value)
{
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(static_cast<JSCSSStyleDeclaration*>(thisObject)->impl());
    ExceptionCode ec = 0;
    imp->setCssText(valueToStringWithNullCheck(exec, value), ec);
    setDOMException(exec, ec);
}

void JSCSSStyleDeclaration::getPropertyNames(ExecState* exec, PropertyNameArray& propertyNames)
{
    for (unsigned i = 0; i < static_cast<CSSStyleDeclaration*>(impl())->length(); ++i)
        propertyNames.add(Identifier::from(exec, i));
     Base::getPropertyNames(exec, propertyNames);
}

JSValuePtr JSCSSStyleDeclaration::getConstructor(ExecState* exec)
{
    return getDOMConstructor<JSCSSStyleDeclarationConstructor>(exec);
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionGetPropertyValue(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->getPropertyValue(propertyName));
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionGetPropertyCSSValue(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = toJS(exec, WTF::getPtr(imp->getPropertyCSSValue(propertyName)));
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionRemoveProperty(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->removeProperty(propertyName, ec));
    setDOMException(exec, ec);
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionGetPropertyPriority(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->getPropertyPriority(propertyName));
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionSetProperty(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    const UString& propertyName = args.at(exec, 0)->toString(exec);
    const UString& value = valueToStringWithNullCheck(exec, args.at(exec, 1));
    const UString& priority = args.at(exec, 2)->toString(exec);

    imp->setProperty(propertyName, value, priority, ec);
    setDOMException(exec, ec);
    return jsUndefined();
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionItem(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    unsigned index = args.at(exec, 0)->toInt32(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->item(index));
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionGetPropertyShorthand(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsStringOrNull(exec, imp->getPropertyShorthand(propertyName));
    return result;
}

JSValuePtr jsCSSStyleDeclarationPrototypeFunctionIsPropertyImplicit(ExecState* exec, JSObject*, JSValuePtr thisValue, const ArgList& args)
{
    if (!thisValue->isObject(&JSCSSStyleDeclaration::s_info))
        return throwError(exec, TypeError);
    JSCSSStyleDeclaration* castedThisObj = static_cast<JSCSSStyleDeclaration*>(asObject(thisValue));
    CSSStyleDeclaration* imp = static_cast<CSSStyleDeclaration*>(castedThisObj->impl());
    const UString& propertyName = args.at(exec, 0)->toString(exec);


    JSC::JSValuePtr result = jsBoolean(imp->isPropertyImplicit(propertyName));
    return result;
}


JSValuePtr JSCSSStyleDeclaration::indexGetter(ExecState* exec, const Identifier& propertyName, const PropertySlot& slot)
{
    JSCSSStyleDeclaration* thisObj = static_cast<JSCSSStyleDeclaration*>(asObject(slot.slotBase()));
    return jsStringOrNull(exec, thisObj->impl()->item(slot.index()));
}
JSC::JSValuePtr toJS(JSC::ExecState* exec, CSSStyleDeclaration* object)
{
    return getDOMObjectWrapper<JSCSSStyleDeclaration>(exec, object);
}
CSSStyleDeclaration* toCSSStyleDeclaration(JSC::JSValuePtr value)
{
    return value->isObject(&JSCSSStyleDeclaration::s_info) ? static_cast<JSCSSStyleDeclaration*>(asObject(value))->impl() : 0;
}

}
