/* Test f2xm1 instruction.  */

#include <stdio.h>

struct test {
    long double arg, down, up;
};

const struct test tests[] = {
    { -1.0L, -0.5L, -0.5L },
    { -0.0L, -0.0L, -0.0L },
    { 0.0L, 0.0L, 0.0L },
    /* Randomly generated tests.  */
    { 0x4.1481697ac693aa6p-4L, 0x3.17ec9f8454896518p-4L, 0x3.17ec9f845489651cp-4L },
    { -0xd.84a873b14b9c0e2p-4L, -0x7.1788c46ac260d948p-4L, -0x7.1788c46ac260d94p-4L },
    { 0xa.a3dc18b1eff7e8ap-188L, 0x7.6009241b9e21523p-188L, 0x7.6009241b9e215238p-188L },
    { -0xe.846aeb6f58174d5p-92L, -0xa.1006405817acc33p-92L, -0xa.1006405817acc32p-92L },
    { 0x5.4459f2ac77bb0978p-4L, 0x4.19d3ce7fd5b90ac8p-4L, 0x4.19d3ce7fd5b90adp-4L },
    { -0xb.79bece734a62216p-4L, -0x6.4489a7fc150c0fp-4L, -0x6.4489a7fc150c0ef8p-4L },
    { 0xa.ab48f9ef732f5c4p-4L, 0x9.66acd7d4b7cf015p-4L, 0x9.66acd7d4b7cf016p-4L },
    { -0xb.8204e63359a46e6p-4L, -0x6.48060f0a504e3488p-4L, -0x6.48060f0a504e348p-4L },
    { 0xd.c732865701ae935p-4L, 0xd.103bc1a15cd9f71p-4L, 0xd.103bc1a15cd9f72p-4L },
    { -0x1.6296e8ff499827a2p-4L, -0xe.e8dc973f0bce9d1p-8L, -0xe.e8dc973f0bce9dp-8L },
    { 0x8.3e49377820195c8p-4L, 0x6.ddff7e8caa601a08p-4L, 0x6.ddff7e8caa601a1p-4L },
    { -0x7.ece8699d62a9f76p-4L, -0x4.a6516088a15ab01p-4L, -0x4.a6516088a15ab008p-4L },
    { 0x4.b875c0342c9f86b8p-4L, 0x3.a1709cfaecf11ce8p-4L, 0x3.a1709cfaecf11cecp-4L },
    { -0xe.a37e0fa859e499cp-4L, -0x7.83956f7028853738p-4L, -0x7.83956f702885373p-4L },
    { 0x7.23210d9474f0715p-4L, 0x5.cc1ac556913b5258p-4L, 0x5.cc1ac556913b526p-4L },
    { -0xb.755e74862e61e2bp-4L, -0x6.42b11ec6fd4c00dp-4L, -0x6.42b11ec6fd4c00c8p-4L },
    { 0x3.48cc248e266ab90cp-4L, 0x2.724bd1b7f02d354cp-4L, 0x2.724bd1b7f02d355p-4L },
    { -0xa.9a331b76f8ece94p-4L, -0x5.e47b32e80b1f837p-4L, -0x5.e47b32e80b1f8368p-4L },
    { 0x5.8312ebb25c93d22p-4L, 0x4.50bcc3442a6e832p-4L, 0x4.50bcc3442a6e8328p-4L },
    { -0xa.d41581f0036d233p-4L, -0x5.fdb41cec4e2c108p-4L, -0x5.fdb41cec4e2c1078p-4L },
    { 0x4.84a87d8107c5f408p-4L, 0x3.759419ac694e8798p-4L, 0x3.759419ac694e879cp-4L },
    { -0x1.1a592590e007fap-4L, -0xb.f1b5fdf338edbc1p-8L, -0xb.f1b5fdf338edbcp-8L },
    { 0x2.72f96b27827d2054p-4L, 0x1.ca7a491c0c9ae094p-4L, 0x1.ca7a491c0c9ae096p-4L },
    { -0x8.34634eae18e60c5p-4L, -0x4.c941052638a95e6p-4L, -0x4.c941052638a95e58p-4L },
    { 0x2.f6cff94cffe53048p-180L, 0x2.0df7fb06812da41p-180L, 0x2.0df7fb06812da414p-180L },
    { -0x3.e0779bd58963da5p-120L, -0x2.afed04ed88e2c16cp-120L, -0x2.afed04ed88e2c168p-120L },
    { 0xc.1c72a98f7733051p-4L, 0xb.09ddaf3c3330ff9p-4L, 0xb.09ddaf3c3330ffap-4L },
    { -0x9.6eacf3012c77e7p-4L, -0x5.5df25bc91430e81p-4L, -0x5.5df25bc91430e808p-4L },
    { 0x4.962ce97c4afbc1f8p-4L, 0x3.845e1e9659d35364p-4L, 0x3.845e1e9659d35368p-4L },
    { -0xa.a7735b993f17f55p-4L, -0x5.ea46e99ae5f6dce8p-4L, -0x5.ea46e99ae5f6dcep-4L },
    { 0x5.155f76560f08fccp-4L, 0x3.f1149b22956dff34p-4L, 0x3.f1149b22956dff38p-4L },
    { -0xd.32a453289bd47b3p-4L, -0x6.f7a99ad68a5d961p-4L, -0x6.f7a99ad68a5d9608p-4L },
    { 0xa.9942e7418052b4bp-4L, 0x9.52df2bbafc3218bp-4L, 0x9.52df2bbafc3218cp-4L },
    { -0x5.4f4efad2aff4f76p-4L, -0x3.49afb77e7a12385p-4L, -0x3.49afb77e7a12384cp-4L },
    { 0x3.c9e289d962998608p-4L, 0x2.da96d228ab6c8fd8p-4L, 0x2.da96d228ab6c8fdcp-4L },
    { -0x7.cc295689678770bp-4L, -0x4.962bd983de0367b8p-4L, -0x4.962bd983de0367bp-4L },
    { 0xa.8fc7c1f2a46626cp-4L, 0x9.487a90c858224c9p-4L, 0x9.487a90c858224cap-4L },
    { -0x8.a1d9201d5f09ad6p-4L, -0x4.fdf0ccee86f8d98p-4L, -0x4.fdf0ccee86f8d978p-4L },
    { 0x7.5b8ee6778ad1d64p-4L, 0x6.01a5419abf1cb4f8p-4L, 0x6.01a5419abf1cb5p-4L },
    { -0x9.d20d0f7fc98548p-4L, -0x5.8b571e52bd288448p-4L, -0x5.8b571e52bd28844p-4L },
    { 0x5.f135e81ee2608d4p-4L, 0x4.b293c42ca99fd6e8p-4L, 0x4.b293c42ca99fd6fp-4L },
    { -0x5.d981a42b6b7a36fp-4L, -0x3.94e920725edbe7d4p-4L, -0x3.94e920725edbe7dp-4L },
    { 0xa.edffe301db8be0bp-4L, 0x9.b08144d0a85602p-4L, 0x9.b08144d0a856021p-4L },
    { -0x4.5a026d37f55f1d18p-4L, -0x2.bfc10df32554a28cp-4L, -0x2.bfc10df32554a288p-4L },
    { 0x7.82c193b48128193p-4L, 0x6.2723ac59ee5faf68p-4L, 0x6.2723ac59ee5faf7p-4L },
    { -0xd.2d0fe1cd05a87f4p-4L, -0x6.f57a61e00a5f24bp-4L, -0x6.f57a61e00a5f24a8p-4L },
    { 0x5.e1494f95151c64fp-196L, 0x4.13628f9a498f05d8p-196L, 0x4.13628f9a498f05ep-196L },
    { -0x4.51babb72810e518p-140L, -0x2.fe6ee847d0741a5cp-140L, -0x2.fe6ee847d0741a58p-140L },
    { 0xb.638d8454a685474p-4L, 0xa.34a429815e10dc1p-4L, 0xa.34a429815e10dc2p-4L },
    { -0xb.9ec4e9f266dce49p-4L, -0x6.54194f84395ed2b8p-4L, -0x6.54194f84395ed2bp-4L },
    { 0xe.4b7a4c83290855cp-4L, 0xd.b8a9a282646fa0cp-4L, 0xd.b8a9a282646fa0dp-4L },
    { -0xf.13ec97b6c4f17a7p-4L, -0x7.ac86ac65cc0a8878p-4L, -0x7.ac86ac65cc0a887p-4L },
    { 0x3.8ded178a72c15bcp-4L, 0x2.a9dd11713298de98p-4L, 0x2.a9dd11713298de9cp-4L },
    { -0xd.36a9965916287d1p-4L, -0x6.f93c3981d5369078p-4L, -0x6.f93c3981d536907p-4L },
    { 0x6.b3a10f94dcd70e1p-4L, 0x5.63cd831188f697c8p-4L, 0x5.63cd831188f697dp-4L },
    { -0xc.8517674f15bbcbfp-4L, -0x6.b2be7a8ee34bfc8p-4L, -0x6.b2be7a8ee34bfc78p-4L },
    { 0xb.204e5335e697f73p-4L, 0x9.e8bb034ff53dc6p-4L, 0x9.e8bb034ff53dc61p-4L },
    { -0x8.913a951884085ddp-4L, -0x4.f60101f7884f4f6p-4L, -0x4.f60101f7884f4f58p-4L },
    { 0x4.5861903e9a2c5178p-4L, 0x3.50645bac48af734cp-4L, 0x3.50645bac48af735p-4L },
    { -0x5.24585590086993p-4L, -0x3.31f08d8ca7e0c6e4p-4L, -0x3.31f08d8ca7e0c6ep-4L },
    { 0xf.2ba8f23d35f13f9p-4L, 0xe.dedc34179a9e3acp-4L, 0xe.dedc34179a9e3adp-4L },
    { -0xa.3ecdb386b33fbe5p-4L, -0x5.bc2672b634fa598p-4L, -0x5.bc2672b634fa5978p-4L },
    { 0x9.9b8e544f05c6de4p-8L, 0x6.bf33cd9ab91f6d28p-8L, 0x6.bf33cd9ab91f6d3p-8L },
    { -0x7.abd5585035c4696p-4L, -0x4.862497557f052a6p-4L, -0x4.862497557f052a58p-4L },
    { 0xa.e654e5ca1c1d1fbp-4L, 0x9.a7fa0d5fa5d62cbp-4L, 0x9.a7fa0d5fa5d62ccp-4L },
    { -0x7.8b963b5c9698ae88p-8L, -0x5.2d4a519ba339886p-8L, -0x5.2d4a519ba3398858p-8L },
    { 0xb.ea47beace8589dep-4L, 0xa.cf59bd897bb1319p-4L, 0xa.cf59bd897bb131ap-4L },
    { -0x3.8f66d5a2d60e1fc8p-4L, -0x2.496dee34a71055ap-4L, -0x2.496dee34a710559cp-4L },
    { 0x3.1a53eaa26d0157p-188L, 0x2.269608f745c0b83p-188L, 0x2.269608f745c0b834p-188L },
    { -0x8.6659e1a891ccbd3p-96L, -0x5.d282825fc03c7ca8p-96L, -0x5.d282825fc03c7cap-96L },
    { 0x9.4ae3410622cd598p-4L, 0x7.ee3a22f81622643p-4L, 0x7.ee3a22f816226438p-4L },
    { -0x9.b8fe7ab721fb04cp-4L, -0x5.7ff768a6654000e8p-4L, -0x5.7ff768a6654000ep-4L },
    { 0x4.ee554b54200eeb18p-4L, 0x3.cf77028b579146a8p-4L, 0x3.cf77028b579146acp-4L },
    { -0x1.e1d0727b5f12c23cp-8L, -0x1.4d1e625247cef1dap-8L, -0x1.4d1e625247cef1d8p-8L },
    { 0x8.f3637cea7b9b0b8p-4L, 0x7.942f15c8b77d89c8p-4L, 0x7.942f15c8b77d89dp-4L },
    { -0x2.f3202c602060bd7cp-4L, -0x1.eb59cec0fd5e5b22p-4L, -0x1.eb59cec0fd5e5b2p-4L },
    { 0xc.cdb9d9e3a3a5b61p-4L, 0xb.dcaaf5c009c0684p-4L, 0xb.dcaaf5c009c0685p-4L },
    { -0x5.7ddc79efb147e828p-4L, -0x3.63390bf8b99265d4p-4L, -0x3.63390bf8b99265dp-4L },
    { 0x6.7236b6f8976437ap-4L, 0x5.27852c069a4fd5ep-4L, 0x5.27852c069a4fd5e8p-4L },
    { -0x5.e1ad137b44bc3ad8p-4L, -0x3.994d814216774764p-4L, -0x3.994d81421677476p-4L },
    { 0xb.f5ec1a26fcc9d7ep-4L, 0xa.dce2b2a69a74106p-4L, 0xa.dce2b2a69a74107p-4L },
    { -0xd.dcb826624975b1ep-4L, -0x7.394429db03b0d5e8p-4L, -0x7.394429db03b0d5ep-4L },
    { 0x1.a983e64980e6104p-4L, 0x1.31d2cb35db04030ep-4L, 0x1.31d2cb35db04031p-4L },
    { -0xa.14ebef82079ff92p-4L, -0x5.a9758de717320278p-4L, -0x5.a9758de71732027p-4L },
    { 0x1.e4fcc97f32b404d8p-4L, 0x1.5e5913e4b0dadd5ep-4L, 0x1.5e5913e4b0dadd6p-4L },
    { -0xe.9391126d81ddf25p-4L, -0x7.7db899379b97afep-4L, -0x7.7db899379b97afd8p-4L },
    { 0xb.83be497f42b1776p-8L, 0x8.1b67845064d833ap-8L, 0x8.1b67845064d833bp-8L },
    { -0xb.6c13349b9671c7bp-4L, -0x6.3ec4737bebffb8f8p-4L, -0x6.3ec4737bebffb8fp-4L },
    { 0xd.00d476fab7a907dp-4L, 0xc.1a9e868d759da06p-4L, 0xc.1a9e868d759da07p-4L },
    { -0x3.bf394566ed3e5a44p-4L, -0x2.65b989f46e7a2458p-4L, -0x2.65b989f46e7a2454p-4L },
    { 0x7.4a72aacaec9cd52p-52L, 0x5.0db91de577a1e5c8p-52L, 0x5.0db91de577a1e5dp-52L },
    { -0x4.3354d8429f36037p-24L, -0x2.e95ce5bede67faap-24L, -0x2.e95ce5bede67fa9cp-24L },
    { 0x5.431e650334b97d18p-4L, 0x4.18c10ccaa716c258p-4L, 0x4.18c10ccaa716c26p-4L },
    { -0xf.1eb2c535e06fba3p-4L, -0x7.b068a3edafc6822p-4L, -0x7.b068a3edafc68218p-4L },
    { 0x8.54a857fb1034b62p-4L, 0x6.f433cc318f296fep-4L, 0x6.f433cc318f296fe8p-4L },
    { -0xa.d3c15d582c446d9p-4L, -0x5.fd8fa08a9be23ac8p-4L, -0x5.fd8fa08a9be23acp-4L },
    { 0xc.cb73edcbfcb307fp-4L, 0xb.d9ecb2c64e8df6bp-4L, 0xb.d9ecb2c64e8df6cp-4L },
    { -0x3.fb61f1b2cf35f60cp-4L, -0x2.88fef3c7864d396cp-4L, -0x2.88fef3c7864d3968p-4L },
    { 0x9.d7eb5c50bc8c632p-4L, 0x8.8231f68c5c65f6cp-4L, 0x8.8231f68c5c65f6dp-4L },
    { -0x4.d312891f5f4e786p-4L, -0x3.048b329391356fc8p-4L, -0x3.048b329391356fc4p-4L },
    { 0xe.ae0633b99b178edp-4L, 0xe.389ce9e10301401p-4L, 0xe.389ce9e10301402p-4L },
    { -0x1.39568b7ef55672cp-4L, -0xd.38818f18029f0edp-8L, -0xd.38818f18029f0ecp-8L },
    { 0x4.cf293b1353f539bp-4L, 0x3.b4c86315977b5c7cp-4L, 0x3.b4c86315977b5c8p-4L },
    { -0xd.2b8a9e00126538ap-4L, -0x6.f4e1e5a5bc2731ap-4L, -0x6.f4e1e5a5bc273198p-4L },
    { 0x5.b5eb2a3dcc35826p-8L, 0x3.fd3309c0a1b58598p-8L, 0x3.fd3309c0a1b5859cp-8L },
    { -0xa.db19f19a7ea88bep-4L, -0x6.00be987018657798p-4L, -0x6.00be98701865779p-4L },
    { 0x1.09017c7c80c2c48ap-4L, 0xb.bde7d981fb53b8ep-8L, 0xb.bde7d981fb53b8fp-8L },
    { -0x2.5ae089add9bdff18p-4L, -0x1.8d45d20a5f7c4556p-4L, -0x1.8d45d20a5f7c4554p-4L },
    { 0x6.d211b21df46dcc18p-4L, 0x5.801525b9519ab1cp-4L, 0x5.801525b9519ab1c8p-4L },
    { -0xd.1a64a16c7c8f6d7p-4L, -0x6.ee27813a5adc48a8p-4L, -0x6.ee27813a5adc48ap-4L },
    { 0xc.1ef9ffac1d2c793p-4L, 0xb.0cd41b95ab8f726p-4L, 0xb.0cd41b95ab8f727p-4L },
    { -0x1.67c59b4c06bd7496p-4L, -0xf.1ef71ffc4b3edp-8L, -0xf.1ef71ffc4b3ecffp-8L },
    { 0x8.ba4b4feae22142bp-168L, 0x6.0cb1d8faa6f42ce8p-168L, 0x6.0cb1d8faa6f42cfp-168L },
    { -0x4.d89f7b5a88882dbp-32L, -0x3.5bef2f703124413p-32L, -0x3.5bef2f703124412cp-32L },
    { 0xb.03fa4c349a339d2p-4L, 0x9.c902a02a0215ad1p-4L, 0x9.c902a02a0215ad2p-4L },
    { -0x1.e57ddc8153f3ba8p-8L, -0x1.4fa797d98bce1f74p-8L, -0x1.4fa797d98bce1f72p-8L },
    { 0xc.9c281b57f7d11c8p-4L, 0xb.a11623dd20659ecp-4L, 0xb.a11623dd20659edp-4L },
    { -0x6.8fac6e3f60b61e1p-4L, -0x3.f56b115363b7d2d8p-4L, -0x3.f56b115363b7d2d4p-4L },
    { 0x3.65bed5b32d99326p-4L, 0x2.897c78eee4adc054p-4L, 0x2.897c78eee4adc058p-4L },
    { -0x2.3ef31cc65b2354cp-4L, -0x1.7bc0457bdf14a022p-4L, -0x1.7bc0457bdf14a02p-4L },
    { 0x2.bceec8bc1d31b0ccp-4L, 0x2.03d68f4acad10114p-4L, 0x2.03d68f4acad10118p-4L },
    { -0xd.146217a63673958p-4L, -0x6.ebcaaea4b926a99p-4L, -0x6.ebcaaea4b926a988p-4L },
    { 0x2.17b7fc97b1f46e7cp-4L, 0x1.84af2ad78df6619cp-4L, 0x1.84af2ad78df6619ep-4L },
    { -0x4.49abbcdefc0c959p-4L, -0x2.b65ca46b981930ecp-4L, -0x2.b65ca46b981930e8p-4L },
    { 0x3.efc6f5f489c6c7bcp-4L, 0x2.f9a3671c9c3698fcp-4L, 0x2.f9a3671c9c3699p-4L },
    { -0x8.f7ff40b96f9bd91p-4L, -0x5.26b9d6a96a7c7d4p-4L, -0x5.26b9d6a96a7c7d38p-4L },
    { 0x6.003126d0e9a9acc8p-4L, 0x4.c0070418e60c3eap-4L, 0x4.c0070418e60c3ea8p-4L },
    { -0x5.7be9edcc9dc2a02p-4L, -0x3.6228999b34cd56c8p-4L, -0x3.6228999b34cd56c4p-4L },
    { 0x7.8952a49ff2c2f168p-4L, 0x6.2d71e3ee870f2fp-4L, 0x6.2d71e3ee870f2f08p-4L },
    { -0x3.8a644fc56f9d1fbp-4L, -0x2.4673b0704862205cp-4L, -0x2.4673b07048622058p-4L },
    { 0xf.c1271b0a53a3319p-4L, 0xf.a9563e019f9388ep-4L, 0xf.a9563e019f9388fp-4L },
    { -0x8.a07f742f2a61d18p-4L, -0x4.fd4bef713b1bf35p-4L, -0x4.fd4bef713b1bf348p-4L },
    { 0xf.ce2fc60abd9a47cp-4L, 0xf.bb3bf685a5fb078p-4L, 0xf.bb3bf685a5fb079p-4L },
    { -0x9.e8a3a1c0f885e07p-4L, -0x5.958d6298d2833328p-4L, -0x5.958d6298d283332p-4L },
    { 0xd.11c135742977841p-96L, 0x9.0f19b73e51b46a5p-96L, 0x9.0f19b73e51b46a6p-96L },
    { -0x1.0028929dbde83802p-60L, -0xb.18e376bf8ce7ca1p-64L, -0xb.18e376bf8ce7cap-64L },
    { 0x5.244b484bc9bb7828p-4L, 0x3.fdfcc0ee0ab5b92p-4L, 0x3.fdfcc0ee0ab5b924p-4L },
    { -0x7.02ec4c8b2cc95998p-4L, -0x4.30f4ae1282b41938p-4L, -0x4.30f4ae1282b4193p-4L },
    { 0xa.4d34be63f5bedffp-4L, 0x8.fff7fb1648dba28p-4L, 0x8.fff7fb1648dba29p-4L },
    { -0xf.be786c39b309e8p-4L, -0x7.e929ac0fe4454fbp-4L, -0x7.e929ac0fe4454fa8p-4L },
    { 0x6.16481538d3215558p-4L, 0x4.d3ebea6da53ed4bp-4L, 0x4.d3ebea6da53ed4b8p-4L },
    { -0x8.5ea05eecb9ac14dp-4L, -0x4.ddb34f8925005bf8p-4L, -0x4.ddb34f8925005bfp-4L },
    { 0xd.4be5b4aaf95a52bp-4L, 0xc.7698fe58f5fbc96p-4L, 0xc.7698fe58f5fbc97p-4L },
    { -0x5.505294ddb8af9558p-4L, -0x3.4a3eaba09a1a5584p-4L, -0x3.4a3eaba09a1a558p-4L },
    { 0xf.a2f9540a64c79ap-8L, 0xb.1239629d9548b9ap-8L, 0xb.1239629d9548b9bp-8L },
    { -0x2.b68cfa7df5a80aep-4L, -0x1.c635cc5a0e342052p-4L, -0x1.c635cc5a0e34205p-4L },
    { 0xb.8ac8e4b25441b53p-4L, 0xa.6154102e9f6deb3p-4L, 0xa.6154102e9f6deb4p-4L },
    { -0x2.047a032c2a353b58p-4L, -0x1.56cbb83364a118fcp-4L, -0x1.56cbb83364a118fap-4L },
    { 0x8.eb2ab17c06312d9p-4L, 0x7.8bca95748b755068p-4L, 0x7.8bca95748b75507p-4L },
    { -0xb.932fffb0dfd7537p-4L, -0x6.4f3dd628a0e5cf6p-4L, -0x6.4f3dd628a0e5cf58p-4L },
    { 0x4.e0e6c013f25279bp-4L, 0x3.c3f354fd7de31834p-4L, 0x3.c3f354fd7de31838p-4L },
    { -0xa.7fafcf461e92982p-4L, -0x5.d8d88aa29bb4cebp-4L, -0x5.d8d88aa29bb4cea8p-4L },
    { 0x6.41b8cd66b9392ef8p-4L, 0x4.fb4312effd41adb8p-4L, 0x4.fb4312effd41adcp-4L },
    { -0xf.d372339bf2bef0fp-4L, -0x7.f0801caf476622cp-4L, -0x7.f0801caf476622b8p-4L },
    { 0xf.843d63b0a71eb93p-4L, 0xf.56375011490bccp-4L, 0xf.56375011490bcc1p-4L },
    { -0xe.679784396815117p-4L, -0x7.6d735bc4f5da77p-4L, -0x7.6d735bc4f5da76f8p-4L },
    { 0x2.d7c4bef6577f86p-168L, 0x1.f87361c88ca3f5dcp-168L, 0x1.f87361c88ca3f5dep-168L },
    { -0x3.f871c581e5f5dc24p-128L, -0x2.c08bab62f3684a08p-128L, -0x2.c08bab62f3684a04p-128L },
    { 0x9.f6c4eb5c911111ap-4L, 0x8.a309258b14973d6p-4L, 0x8.a309258b14973d7p-4L },
    { -0xa.08c53e65e98b067p-4L, -0x5.a402f5ec7cf294fp-4L, -0x5.a402f5ec7cf294e8p-4L },
    { 0x4.1a4c613ba5fe16ap-4L, 0x3.1cb7e0a2f57d95e4p-4L, 0x3.1cb7e0a2f57d95e8p-4L },
    { -0xd.36e91d3e54f0432p-4L, -0x6.f95510d133d9ba9p-4L, -0x6.f95510d133d9ba88p-4L },
    { 0xd.1de964de30857a7p-4L, 0xc.3e1d28af4fff2d7p-4L, 0xc.3e1d28af4fff2d8p-4L },
    { -0x8.604a0e63d4f5df1p-4L, -0x4.de809bb2d3dfaec8p-4L, -0x4.de809bb2d3dfaecp-4L },
    { 0xc.6b9d18c70882d52p-4L, 0xb.67389c48f17db3ap-4L, 0xb.67389c48f17db3bp-4L },
    { -0x2.711b4139fbed3dc8p-4L, -0x1.9b290dfa49d31a48p-4L, -0x1.9b290dfa49d31a46p-4L },
    { 0x9.4021cab7a0d78bbp-4L, 0x7.e3162eb6a1bdbe8p-4L, 0x7.e3162eb6a1bdbe88p-4L },
    { -0x8.305eb92b4243ea2p-4L, -0x4.c74d292fe63f0918p-4L, -0x4.c74d292fe63f091p-4L },
    { 0x4.f0330cdb93893948p-4L, 0x3.d111183eddd7d2p-4L, 0x3.d111183eddd7d204p-4L },
    { -0xe.be93c7764505ff9p-8L, -0xa.04ccfff3805ed0dp-8L, -0xa.04ccfff3805ed0cp-8L },
    { 0xd.ea533ffe043e52bp-4L, 0xd.3c980125a65c5dfp-4L, 0xd.3c980125a65c5ep-4L },
    { -0x1.1dd2693fe11489c2p-4L, -0xc.166d57fe9c4abe2p-8L, -0xc.166d57fe9c4abe1p-8L },
    { 0x2.0397d0e9676f1b2p-4L, 0x1.756fb86ebc62a682p-4L, 0x1.756fb86ebc62a684p-4L },
    { -0xa.9002b4ad763bb7cp-4L, -0x5.e0041011e34ae53p-4L, -0x5.e0041011e34ae528p-4L },
    { 0x3.34a5a4894a28659cp-4L, 0x2.623883e4934c92d8p-4L, 0x2.623883e4934c92dcp-4L },
    { -0xd.c27cd78e0864371p-4L, -0x7.2f454c780b622d58p-4L, -0x7.2f454c780b622d5p-4L },
    { 0x9.c7f27c2034ec1cfp-4L, 0x8.714272ce09a4f87p-4L, 0x8.714272ce09a4f88p-4L },
    { -0xa.a9e0aa658eda7dcp-4L, -0x5.eb564d46b128566p-4L, -0x5.eb564d46b1285658p-4L },
    { 0xa.0183ad6b5f24f24p-148L, 0x6.ef81a75cf4925d9p-148L, 0x6.ef81a75cf4925d98p-148L },
    { -0x2.0bdfa7925a4bf4ap-28L, -0x1.6b1f1d70f143adc4p-28L, -0x1.6b1f1d70f143adc2p-28L },
    { 0xa.93e861896961066p-4L, 0x9.4d004c2eac2676fp-4L, 0x9.4d004c2eac2677p-4L },
    { -0xd.4c10bf60bb97196p-4L, -0x7.0196eb9b79274b88p-4L, -0x7.0196eb9b79274b8p-4L },
    { 0x4.ff124c9911f2538p-4L, 0x3.ddd9b3e49fd11e9p-4L, 0x3.ddd9b3e49fd11e94p-4L },
    { -0x8.776b58ba7268d9ep-4L, -0x4.e9a2512b1cd9282p-4L, -0x4.e9a2512b1cd92818p-4L },
    { 0x9.b6f6d16f1d76615p-4L, 0x8.5f4d5e77db1195p-4L, 0x8.5f4d5e77db11951p-4L },
    { -0x9.b667363949a8b6dp-4L, -0x5.7ec9a21714bc48c8p-4L, -0x5.7ec9a21714bc48cp-4L },
    { 0x9.799737c602ebc35p-12L, 0x6.92a3d4df8ac3168p-12L, 0x6.92a3d4df8ac31688p-12L },
    { -0x9.dc0d38d251990e4p-4L, -0x5.8fddc90938b5c8a8p-4L, -0x5.8fddc90938b5c8ap-4L },
    { 0x1.51d68e213ec66d4ep-4L, 0xf.0feacd9b26e94efp-8L, 0xf.0feacd9b26e94fp-8L },
    { -0xd.c78a8c73db2538p-4L, -0x7.313326148c62dbd8p-4L, -0x7.313326148c62dbdp-4L },
    { 0x7.c5f3d0d9d9db89cp-4L, 0x6.67fee55e98a6cf7p-4L, 0x6.67fee55e98a6cf78p-4L },
    { -0x1.6b364994830303c2p-4L, -0xf.42da9bf688d1dbp-8L, -0xf.42da9bf688d1dafp-8L },
    { 0x4.2513fed56a721cp-4L, 0x3.25a6d8fff7773d4cp-4L, 0x3.25a6d8fff7773d5p-4L },
    { -0x3.e183251bd312b9f8p-4L, -0x2.79df44b0dabf9e1p-4L, -0x2.79df44b0dabf9e0cp-4L },
    { 0x5.372c1f6cb3bb4cep-8L, 0x3.a4094f9b223ac4d8p-8L, 0x3.a4094f9b223ac4dcp-8L },
    { -0xc.30d4cc265a07403p-4L, -0x6.908bed536532ac7p-4L, -0x6.908bed536532ac68p-4L },
    { 0xf.7e3aa552d45b234p-4L, 0xf.4e0f6f1aac5a5e6p-4L, 0xf.4e0f6f1aac5a5e7p-4L },
    { -0x3.9a644e95053aaf1cp-4L, -0x2.4ff3cc5ef967d1bcp-4L, -0x2.4ff3cc5ef967d1b8p-4L },
    { 0xe.85839cd58ef2c75p-4L, 0xe.03c1d8a304b280dp-4L, 0xe.03c1d8a304b280ep-4L },
    { -0x7.8809e818c58ede8p-4L, -0x4.744b120d61aa22b8p-4L, -0x4.744b120d61aa22bp-4L },
    { 0xd.d9ee24413681697p-176L, 0x9.99d9ff1a3fe5cecp-176L, 0x9.99d9ff1a3fe5cedp-176L },
    { -0x3.40d11dc412df0dd4p-140L, -0x2.4143c0acd05aa3fcp-140L, -0x2.4143c0acd05aa3f8p-140L },
    { 0x5.0487ddb4070bf26p-4L, 0x3.e28d14d38a11cea8p-4L, 0x3.e28d14d38a11ceacp-4L },
    { -0x5.a0e26438dfac03cp-4L, -0x3.764d74346acb839p-4L, -0x3.764d74346acb838cp-4L },
    { 0x4.cfd480a28c2b6b48p-4L, 0x3.b55a9c63e74d1b2cp-4L, 0x3.b55a9c63e74d1b3p-4L },
    { -0x1.8657dd64795c35ap-4L, -0x1.05d2980556ab36f8p-4L, -0x1.05d2980556ab36f6p-4L },
    { 0x1.262cb60430e5eb9ep-4L, 0xd.11128880978613p-8L, 0xd.111288809786131p-8L },
    { -0x8.0e85fe0bcf8a253p-4L, -0x4.b6ccdbc2803a24p-4L, -0x4.b6ccdbc2803a23f8p-4L },
    { 0x3.cefbd3ecacf92c44p-4L, 0x2.dec16ac730be9dbp-4L, 0x2.dec16ac730be9db4p-4L },
    { -0x5.f20def7196dea63p-4L, -0x3.a216f486f08b5aecp-4L, -0x3.a216f486f08b5ae8p-4L },
    { 0x1.3a394f91198290bcp-4L, 0xd.fb2be9402707d47p-8L, 0xd.fb2be9402707d48p-8L },
    { -0x5.fa0cb4bdfd2d7318p-4L, -0x3.a65ec6a869e7e184p-4L, -0x3.a65ec6a869e7e18p-4L },
    { 0x4.08cc4ee18d971c48p-4L, 0x3.0e3ffd7c5370e6b8p-4L, 0x3.0e3ffd7c5370e6bcp-4L },
    { -0xc.08ff29dce9d081fp-4L, -0x6.8035806826b593e8p-4L, -0x6.8035806826b593ep-4L },
    { 0x8.84e7a8e11ece222p-4L, 0x7.2460415572a2c778p-4L, 0x7.2460415572a2c78p-4L },
    { -0x3.6ac116d0aa98b8bp-4L, -0x2.3397207a04b6d448p-4L, -0x2.3397207a04b6d444p-4L },
    { 0x5.b4cccaf7aee9cd6p-4L, 0x4.7caf8d9a7c39bdf8p-4L, 0x4.7caf8d9a7c39bep-4L },
    { -0xd.08cda37bcd9c8cp-4L, -0x6.e73b932483f4027p-4L, -0x6.e73b932483f40268p-4L },
    { 0xb.d7f74d7d0014f61p-4L, 0xa.ba1cc39b8135ef5p-4L, 0xa.ba1cc39b8135ef6p-4L },
    { -0xa.7263655e0a0ea62p-4L, -0x5.d2fd72c3fb172f98p-4L, -0x5.d2fd72c3fb172f9p-4L },
    { 0x2.47b34fa6f1ad5d68p-4L, 0x1.a93f34ee2980e0cap-4L, 0x1.a93f34ee2980e0ccp-4L },
    { -0x8.fcbb11c22f14e77p-4L, -0x5.28f3257a6e3ab71p-4L, -0x5.28f3257a6e3ab708p-4L },
    { 0xf.9268d3496434d05p-16L, 0xa.cb65631de896653p-16L, 0xa.cb65631de896654p-16L },
    { -0x6.90a7904ae1f6ca48p-172L, -0x4.8cf0e2bc08a21768p-172L, -0x4.8cf0e2bc08a2176p-172L },
    { 0xf.e7cc8c0c8fca8d6p-4L, 0xf.de84d77e096dc2cp-4L, 0xf.de84d77e096dc2dp-4L },
    { -0xb.5766572c78c1636p-4L, -0x6.3603cb668acec5ep-4L, -0x6.3603cb668acec5d8p-4L },
    { 0x7.08271953e92da93p-4L, 0x5.b2b05f792a83ec2p-4L, 0x5.b2b05f792a83ec28p-4L },
    { -0xe.0f6704c35bc87d8p-4L, -0x7.4c742ba7517a322p-4L, -0x7.4c742ba7517a3218p-4L },
    { 0x3.622e5c923b06d66cp-8L, 0x2.5b264a119b7052e8p-8L, 0x2.5b264a119b7052ecp-8L },
    { -0x8.911302b7a344f8ap-4L, -0x4.f5ee153ff9a408ap-4L, -0x4.f5ee153ff9a40898p-4L },
    { 0x5.5234861ad0d016d8p-4L, 0x4.25e7cdeba20def88p-4L, 0x4.25e7cdeba20def9p-4L },
    { -0x8.87063dd41e8a8bbp-4L, -0x4.f11ea0bcf9eb3e7p-4L, -0x4.f11ea0bcf9eb3e68p-4L },
    { 0x4.e1420e7e82cd22dp-4L, 0x3.c44184744892d3ecp-4L, 0x3.c44184744892d3fp-4L },
    { -0xb.db1fc14ef9e7aa3p-4L, -0x6.6d4209f7697a729p-4L, -0x6.6d4209f7697a7288p-4L },
    { 0xc.8346ca25bd9f342p-4L, 0xb.835e70838f32309p-4L, 0xb.835e70838f3230ap-4L },
    { -0x1.51646879b012b5b8p-4L, -0xe.34fbed59aa6c7acp-8L, -0xe.34fbed59aa6c7abp-8L },
    { 0x2.b32d8027c5516654p-4L, 0x1.fc3b2ff7be6c91e6p-4L, 0x1.fc3b2ff7be6c91e8p-4L },
    { -0x6.fd1366df02fe9c5p-4L, -0x4.2df6864ab991689p-4L, -0x4.2df6864ab9916888p-4L },
    { 0x6.c090b4e367d6c7ep-8L, 0x4.b92b6f86425d3ccp-8L, 0x4.b92b6f86425d3cc8p-8L },
    { -0x5.081c001c09df9f3p-4L, -0x3.223d2d4760b053ap-4L, -0x3.223d2d4760b0539cp-4L },
    { 0x7.f9714aab4e09b278p-4L, 0x6.9a31bedda6cc2ab8p-4L, 0x6.9a31bedda6cc2acp-4L },
    { -0x6.4804670d1e062cd8p-4L, -0x3.cfcfa1c45c5a88e8p-4L, -0x3.cfcfa1c45c5a88e4p-4L },
    { 0x9.ef4abcd7f8e696ap-4L, 0x8.9b0f698e7955a9p-4L, 0x8.9b0f698e7955a91p-4L },
    { -0x4.8c4513525f5a0ap-4L, -0x2.dc7be2a249c73a38p-4L, -0x2.dc7be2a249c73a34p-4L },
    { 0x1.7fe67833e1976e6p-168L, 0x1.0a1971aebce11604p-168L, 0x1.0a1971aebce11606p-168L },
    { -0xe.a86b5a2c843f668p-36L, -0xa.28fa9875dd806c6p-36L, -0xa.28fa9875dd806c5p-36L },
    { 0x6.0dd96d442bc44b28p-4L, 0x4.cc518e951f69bd48p-4L, 0x4.cc518e951f69bd5p-4L },
    { -0x3.e88917f9e6c0bb2p-4L, -0x2.7dfc064ecfe2635cp-4L, -0x2.7dfc064ecfe26358p-4L },
    { 0xf.e9c0adcf6e6ebaap-4L, 0xf.e13773c6da26f73p-4L, 0xf.e13773c6da26f74p-4L },
    { -0xe.6049cc9d4ea9c32p-8L, -0x9.c5f8986aafe8b3p-8L, -0x9.c5f8986aafe8b2fp-8L },
    { 0xd.e0ca0ae677c56c7p-4L, 0xd.30868169c79fdeap-4L, 0xd.30868169c79fdebp-4L },
    { -0x3.b604528c1bde4ca8p-4L, -0x2.604b88132e3dceb4p-4L, -0x2.604b88132e3dcebp-4L },
    { 0x9.3e94ea277274ab3p-4L, 0x7.e17b8968152545ep-4L, 0x7.e17b8968152545e8p-4L },
    { -0xf.ec080621a8d9456p-4L, -0x7.f91153ca519955fp-4L, -0x7.f91153ca519955e8p-4L },
    { 0x1.96ef7e6b80e63adep-4L, 0x1.24014f5d43fc1232p-4L, 0x1.24014f5d43fc1234p-4L },
    { -0x2.fd0a9d9f59d83bc8p-4L, -0x1.f164f450f8e2c15p-4L, -0x1.f164f450f8e2c14ep-4L },
    { 0x5.82923d4fd6f683p-4L, 0x4.504b840326d2f688p-4L, 0x4.504b840326d2f69p-4L },
    { -0x2.5fa1d9a3a5a2b664p-4L, -0x1.903f73ce566d8522p-4L, -0x1.903f73ce566d852p-4L },
    { 0xf.b8a161f6eba3189p-4L, 0xf.9da7e29775ea166p-4L, 0xf.9da7e29775ea167p-4L },
    { -0xb.79a14c17c57922dp-4L, -0x6.447d36e53f9fbf98p-4L, -0x6.447d36e53f9fbf9p-4L },
    { 0x9.9b19d045170086ap-4L, 0x8.41f3b9e1fe6130dp-4L, 0x8.41f3b9e1fe6130ep-4L },
    { -0xd.65fbae6f453f5a2p-4L, -0x7.0baa677949607eb8p-4L, -0x7.0baa677949607ebp-4L },
    { 0xc.7a9e15e82248878p-4L, 0xb.790e3f5b2936dc4p-4L, 0xb.790e3f5b2936dc5p-4L },
    { -0x3.f5ec8986cfd785dp-4L, -0x2.85cf707de281dc78p-4L, -0x2.85cf707de281dc74p-4L },
    { 0xa.530c1b060238f06p-4L, 0x9.064c5060f10810bp-4L, 0x9.064c5060f10810cp-4L },
    { -0x3.aa0cc319c013919p-4L, -0x2.59398f9b92fe953p-4L, -0x2.59398f9b92fe952cp-4L },
    { 0x3.c0a4bd100746357p-184L, 0x2.99de0a05056aaf74p-184L, 0x2.99de0a05056aaf78p-184L },
    { -0x6.fd442271482ca6dp-136L, -0x4.d8398bacdf9d28ap-136L, -0x4.d8398bacdf9d2898p-136L },
    { 0x6.67012d8b67014328p-4L, 0x5.1d41e56dafaf995p-4L, 0x5.1d41e56dafaf9958p-4L },
    { -0xa.6b6836f2ff72662p-4L, -0x5.cfe921fda171774p-4L, -0x5.cfe921fda1717738p-4L },
    { 0x9.620bcddbdd20a79p-4L, 0x8.064866d2e843838p-4L, 0x8.064866d2e843839p-4L },
    { -0x4.17376606afdde85p-4L, -0x2.99319a6951355f74p-4L, -0x2.99319a6951355f7p-4L },
    { 0xd.1dc39e358b023ap-4L, 0xc.3deef0997e22f56p-4L, 0xc.3deef0997e22f57p-4L },
    { -0xb.13430c035931444p-4L, -0x6.18f3b1ddbf4bbd98p-4L, -0x6.18f3b1ddbf4bbd9p-4L },
    { 0x3.606617a1673d0184p-4L, 0x2.8531caa9e41d88d8p-4L, 0x2.8531caa9e41d88dcp-4L },
    { -0x8.f017932d188a998p-4L, -0x5.23021a6f15e3204p-4L, -0x5.23021a6f15e32038p-4L },
    { 0x3.cf39982caefbf098p-4L, 0x2.def3e957a9d7b4e8p-4L, 0x2.def3e957a9d7b4ecp-4L },
    { -0x1.8dad3bd8dae62b26p-4L, -0x1.0a93f35dbc547e06p-4L, -0x1.0a93f35dbc547e04p-4L },
    { 0xf.d53ec036950502fp-4L, 0xf.c4f16bfb42b91ebp-4L, 0xf.c4f16bfb42b91ecp-4L },
    { -0xa.9cb0f8ebab4d7f8p-4L, -0x5.e59271c5142a2828p-4L, -0x5.e59271c5142a282p-4L },
    { 0x4.9ff6d398cf5c723p-4L, 0x3.8ca6a81f115945c8p-4L, 0x3.8ca6a81f115945ccp-4L },
    { -0x3.c7ea3c3c2b39e2c8p-4L, -0x2.6ad7b91001b1a278p-4L, -0x2.6ad7b91001b1a274p-4L },
    { 0xf.7206b4c8d50f316p-4L, 0xf.3d872c603dec047p-4L, 0xf.3d872c603dec048p-4L },
    { -0x7.5f74c3dd6c9936dp-4L, -0x4.5fecbd230b7b225p-4L, -0x4.5fecbd230b7b2248p-4L },
    { 0x1.d1a5048e1cfadea8p-4L, 0x1.4fd148e51db81464p-4L, 0x1.4fd148e51db81466p-4L },
    { -0xe.8f9244700df6721p-4L, -0x7.7c3f71d67ca51a2p-4L, -0x7.7c3f71d67ca51a18p-4L },
    { 0x3.99c86ae38d72f47cp-4L, 0x2.b375b38730124248p-4L, 0x2.b375b3873012424cp-4L },
    { -0x5.e2a8926a1f2a69f8p-4L, -0x3.99d49b6de5eb2bfp-4L, -0x3.99d49b6de5eb2becp-4L },
    { 0x2.58e048821c0475f4p-64L, 0x1.a07ede4412af4bbap-64L, 0x1.a07ede4412af4bbcp-64L },
    { -0x1.8989c2560de848e8p-124L, -0x1.10c7a38e60d87138p-124L, -0x1.10c7a38e60d87136p-124L },
    { 0x7.bc19ff559d9831b8p-4L, 0x6.5e7110fac4089518p-4L, 0x6.5e7110fac408952p-4L },
    { -0x6.c87c79c7f39458b8p-4L, -0x4.12e9a15e9bfdadb8p-4L, -0x4.12e9a15e9bfdadbp-4L },
    { 0x2.f5c34056d7c105dp-4L, 0x2.30678a0e37a17cep-4L, 0x2.30678a0e37a17ce4p-4L },
    { -0xd.4a8d8fca0cbe02bp-4L, -0x7.01000b10ed4e999p-4L, -0x7.01000b10ed4e9988p-4L },
    { 0x6.f866735c25236f98p-4L, 0x5.a3e6c10f6f1511fp-4L, 0x5.a3e6c10f6f1511f8p-4L },
    { -0xc.91587f5ff35915fp-4L, -0x6.b7ad5204ea051758p-4L, -0x6.b7ad5204ea05175p-4L },
    { 0x5.8acab0d65d615ap-4L, 0x4.5788c486bedea82p-4L, 0x4.5788c486bedea828p-4L },
    { -0xa.a22cceb5d16a7b9p-4L, -0x5.e7f89a5c228804ap-4L, -0x5.e7f89a5c22880498p-4L },
    { 0x7.9bb3d37308387268p-4L, 0x6.3f21841dccbd4848p-4L, 0x6.3f21841dccbd485p-4L },
    { -0xc.186ea423cfbc56dp-4L, -0x6.868d7eab6a729728p-4L, -0x6.868d7eab6a72972p-4L },
    { 0x2.797cf0eb89b43758p-4L, 0x1.cf80358fed6434cap-4L, 0x1.cf80358fed6434ccp-4L },
    { -0x1.5803a5d39e417564p-4L, -0xe.7a4f6be0f29e7b7p-8L, -0xe.7a4f6be0f29e7b6p-8L },
    { 0xc.a52f12f15058ap-8L, 0x8.eab3287521cf0c3p-8L, 0x8.eab3287521cf0c4p-8L },
    { -0x7.c0b1a87701c336f8p-4L, -0x4.907ee683856ce948p-4L, -0x4.907ee683856ce94p-4L },
    { 0x7.810b603203760db8p-4L, 0x6.257f312ef0f8e4cp-4L, 0x6.257f312ef0f8e4c8p-4L },
    { -0x3.74e32a2c3287777cp-4L, -0x2.39a477aba5f3e36cp-4L, -0x2.39a477aba5f3e368p-4L },
    { 0x7.ce4d4cf62f3cae4p-4L, 0x6.701b2af84891b008p-4L, 0x6.701b2af84891b01p-4L },
    { -0xc.d26229e318f0c64p-4L, -0x6.d1b0028af7ad99e8p-4L, -0x6.d1b0028af7ad99ep-4L },
    { 0x8.457740622adf15fp-4L, 0x6.e51d70eb7475fd68p-4L, 0x6.e51d70eb7475fd7p-4L },
    { -0x7.492c117c47e7f31p-4L, -0x4.54ae45d535c0da2p-4L, -0x4.54ae45d535c0da18p-4L },
    { 0x1.7627671657573188p-68L, 0x1.0357feda17430d52p-68L, 0x1.0357feda17430d54p-68L },
    { -0x1.80b4a26e54c41986p-136L, -0x1.0aa858c341e9388ep-136L, -0x1.0aa858c341e9388cp-136L },
    { 0xf.52d7c0f49c1b5a4p-4L, 0xf.136f9f9fa392aa3p-4L, 0xf.136f9f9fa392aa4p-4L },
    { -0xd.90fb86e4d60004ep-4L, -0x7.1c4914f985d3d1c8p-4L, -0x7.1c4914f985d3d1cp-4L },
    { 0x1.5c0865fc4e06a84ep-4L, 0xf.87bc506c0360beap-8L, 0xf.87bc506c0360bebp-8L },
    { -0xa.2dfc5d1f96be4bcp-4L, -0x5.b4a92468e23a59ep-4L, -0x5.b4a92468e23a59d8p-4L },
    { 0xf.d25ff3331838e0ap-4L, 0xf.c0fe5c5501df211p-4L, 0xf.c0fe5c5501df212p-4L },
    { -0xe.e893761d9d926b2p-4L, -0x7.9cd539ff83893758p-4L, -0x7.9cd539ff8389375p-4L },
    { 0x5.03f2d9b66abed898p-4L, 0x3.e20cb7d716acf19cp-4L, 0x3.e20cb7d716acf1ap-4L },
    { -0xd.e1d2b8730f8408fp-4L, -0x7.3b34b6801908a2d8p-4L, -0x7.3b34b6801908a2dp-4L },
    { 0x3.8052f809aaac9b64p-4L, 0x2.9ee0e2805679d1e8p-4L, 0x2.9ee0e2805679d1ecp-4L },
    { -0xf.ad374726f5b37c2p-4L, -0x7.e31b793e91a5aa08p-4L, -0x7.e31b793e91a5aap-4L },
    { 0x3.48836233e960d588p-4L, 0x2.7211ad27a4176778p-4L, 0x2.7211ad27a417677cp-4L },
    { -0x8.af10e3af7480717p-4L, -0x5.043cabb9514315b8p-4L, -0x5.043cabb9514315bp-4L },
    { 0x2.684f23a780f8d16cp-4L, 0x1.c243ddcaf1137a7ap-4L, 0x1.c243ddcaf1137a7cp-4L },
    { -0x2.956954f33db8ba84p-4L, -0x1.b1bac7e767d6e47p-4L, -0x1.b1bac7e767d6e46ep-4L },
    { 0xe.05c36356f1cc00bp-4L, 0xd.5f6d58c69cd39e4p-4L, 0xd.5f6d58c69cd39e5p-4L },
    { -0x9.851c7f17e3779ebp-4L, -0x5.68430d8fcaf782c8p-4L, -0x5.68430d8fcaf782cp-4L },
    { 0x8.98fecd06210c28ep-8L, 0x6.07827af96e4199d8p-8L, 0x6.07827af96e4199ep-8L },
    { -0xa.944a9ff08e89db6p-4L, -0x5.e1e49752fc61a1f8p-4L, -0x5.e1e49752fc61a1fp-4L },
    { 0xf.069ae41b6f97acbp-4L, 0xe.ad7594fe8b4b59ap-4L, 0xe.ad7594fe8b4b59bp-4L },
    { -0x2.849c2bec428d3088p-4L, -0x1.a74d58f4fabdbfecp-4L, -0x1.a74d58f4fabdbfeap-4L },
    { 0x7.77014ff302ca7f18p-132L, 0x5.2c9b99c7adcd1158p-132L, 0x5.2c9b99c7adcd116p-132L },
    { -0xe.aa11ca5025d7161p-8L, -0x9.f724056ca1ff3ffp-8L, -0x9.f724056ca1ff3fep-8L },
    { 0xe.30a7bdb7d22b3c9p-4L, 0xd.96346f655e1888ep-4L, 0xd.96346f655e1888fp-4L },
    { -0xd.1710819efb6a90bp-4L, -0x6.ecd8990f76e583d8p-4L, -0x6.ecd8990f76e583dp-4L },
    { 0xc.289ab032c02ec2bp-8L, 0x8.91661f345b3b24ap-8L, 0x8.91661f345b3b24bp-8L },
    { -0x9.3c743e33f50fbe3p-8L, -0x6.52977132d3793028p-8L, -0x6.52977132d379302p-8L },
    { 0xc.b983cae10f7203p-4L, 0xb.c45064517003de9p-4L, 0xb.c45064517003deap-4L },
    { -0xb.7422dd3d2b45dc5p-4L, -0x6.422bf2df07d21bc8p-4L, -0x6.422bf2df07d21bcp-4L },
    { 0xa.fbaa8d616ab8d1dp-4L, 0x9.bfbb7af27216907p-4L, 0x9.bfbb7af27216908p-4L },
    { -0xe.926ef7c0fa60c33p-4L, -0x7.7d4da667730b916p-4L, -0x7.7d4da667730b9158p-4L },
    { 0xf.80c7c99d2c6404cp-4L, 0xf.518567961cfcee4p-4L, 0xf.518567961cfcee5p-4L },
    { -0x3.9556369534624858p-8L, -0x2.78c655fc919c92b8p-8L, -0x2.78c655fc919c92b4p-8L },
    { 0xe.80d9a3a08faf173p-4L, 0xd.fdb1f369b283091p-4L, 0xd.fdb1f369b283092p-4L },
    { -0x8.400e8efd60a398p-4L, -0x4.ceeacdda92f4d4f8p-4L, -0x4.ceeacdda92f4d4fp-4L },
    { 0x1.e30b1be4461dcf88p-4L, 0x1.5ce2ab3afe2480fcp-4L, 0x1.5ce2ab3afe2480fep-4L },
    { -0xc.2454aa891f5dba1p-4L, -0x6.8b6e7833d8a9115p-4L, -0x6.8b6e7833d8a91148p-4L },
    { 0x2.c925c1f452e23ebp-4L, 0x2.0d617fc9f8513ef4p-4L, 0x2.0d617fc9f8513ef8p-4L },
    { -0x3.a0caae204aa84214p-4L, -0x2.53bec8ebfa7cc494p-4L, -0x2.53bec8ebfa7cc49p-4L },
    { 0x6.db2d4dd8afa84408p-4L, 0x5.88928d8e125932e8p-4L, 0x5.88928d8e125932fp-4L },
    { -0x8.7fd39596a804d49p-4L, -0x4.edab5a4106ecd58p-4L, -0x4.edab5a4106ecd578p-4L },
    { 0xf.c5af0e065f2eb13p-4L, 0xf.af8ddf3950b244p-4L, 0xf.af8ddf3950b2441p-4L },
    { -0x5.9541e8c20a3e7eep-4L, -0x3.6ffb2642f78d6758p-4L, -0x3.6ffb2642f78d6754p-4L },
    { 0x2.b8baba6727f5d1ep-24L, 0x1.e2efa10b181a1d0cp-24L, 0x1.e2efa10b181a1d0ep-24L },
    { -0x8.db8aa5ad53966d6p-64L, -0x6.23bd7497280c936p-64L, -0x6.23bd7497280c9358p-64L },
    { 0xc.2a19196663e14b4p-4L, 0xb.19dfa4b37a6fc82p-4L, 0xb.19dfa4b37a6fc83p-4L },
    { -0x5.0fb02f7662c3e03p-4L, -0x3.2675eb61e2d86868p-4L, -0x3.2675eb61e2d86864p-4L },
    { 0x6.883e7a1d34914268p-4L, 0x5.3bbf577ebbb3a6e8p-4L, 0x5.3bbf577ebbb3a6fp-4L },
    { -0xb.88a85700deb5549p-4L, -0x6.4ad12b9dbb86aa58p-4L, -0x6.4ad12b9dbb86aa5p-4L },
    { 0xf.2b2a3a311948993p-4L, 0xe.de32bdbd5328a8bp-4L, 0xe.de32bdbd5328a8cp-4L },
    { -0x3.06fe2a10fe55267cp-4L, -0x1.f7730b164f7095cap-4L, -0x1.f7730b164f7095c8p-4L },
    { 0xd.de264368cd7459ap-4L, 0xd.2d302551f4723e2p-4L, 0xd.2d302551f4723e3p-4L },
    { -0x5.567777c9aa2124c8p-4L, -0x3.4da047a5e9ef6524p-4L, -0x3.4da047a5e9ef652p-4L },
    { 0x1.935a9217a5a3024p-4L, 0x1.2158a4e7876f331ep-4L, 0x1.2158a4e7876f332p-4L },
    { -0x7.3ccc7fe1d42ad228p-4L, -0x4.4e6b4b167987ff4p-4L, -0x4.4e6b4b167987ff38p-4L },
    { 0x4.bbff6d1fef17b4c8p-4L, 0x3.a4730f28cbe2fbf4p-4L, 0x3.a4730f28cbe2fbf8p-4L },
    { -0x2.826940b5855fb4cp-4L, -0x1.a5ef6bae7291935p-4L, -0x1.a5ef6bae7291934ep-4L },
    { 0x5.265fe49d84076a68p-4L, 0x3.ffca2018e001a9f4p-4L, 0x3.ffca2018e001a9f8p-4L },
    { -0xc.103986b2d38539dp-4L, -0x6.832e7fadd55aecp-4L, -0x6.832e7fadd55aebf8p-4L },
    { 0x1.70101c108d2f0d0ep-4L, 0x1.073c0b1e50c5d204p-4L, 0x1.073c0b1e50c5d206p-4L },
    { -0x2.66bb0943c921a184p-4L, -0x1.94af43fe62d2cf1ap-4L, -0x1.94af43fe62d2cf18p-4L },
    { 0x7.5a723c24f0c64ebp-4L, 0x6.0095e4fad124e338p-4L, 0x6.0095e4fad124e34p-4L },
    { -0x3.c761bdd9cf2def2cp-4L, -0x2.6a876738e18b6208p-4L, -0x2.6a876738e18b6204p-4L },
    { 0x3.e7acf294cc0ca23cp-8L, 0x2.b89933565f7ae4f4p-8L, 0x2.b89933565f7ae4f8p-8L },
    { -0x7.3c061c9452915b98p-4L, -0x4.4e06c9112a70ca8p-4L, -0x4.4e06c9112a70ca78p-4L },
    { 0x3.0efe779ab69c208p-72L, 0x2.1ebae7521123e438p-72L, 0x2.1ebae7521123e43cp-72L },
    { -0x6.90517ba54103e7cp-172L, -0x4.8cb53818436922b8p-172L, -0x4.8cb53818436922bp-172L },
    { 0xb.dde4e379662aeeap-4L, 0xa.c0facbdff63e577p-4L, 0xa.c0facbdff63e578p-4L },
    { -0xb.0226291c9bc5964p-4L, -0x6.1199984540184bp-4L, -0x6.1199984540184af8p-4L },
    { 0xd.bf9a0da9faa3504p-4L, 0xd.06ad1755cc71cafp-4L, 0xd.06ad1755cc71cbp-4L },
    { -0x5.c1892b0fafe1dc68p-4L, -0x3.87fd1b244474f46p-4L, -0x3.87fd1b244474f45cp-4L },
    { 0x1.44812a3159648466p-4L, 0xe.7384fa316de3657p-8L, 0xe.7384fa316de3658p-8L },
    { -0x3.675c755eb8dbe27cp-4L, -0x2.318fbbc51015422p-4L, -0x2.318fbbc51015421cp-4L },
    { 0x1.e8e8f49835eaacb8p-4L, 0x1.614ce65fa1a17274p-4L, 0x1.614ce65fa1a17276p-4L },
    { -0x9.eac5efdf2c187bdp-4L, -0x5.9683d9aacedb09d8p-4L, -0x5.9683d9aacedb09dp-4L },
    { 0xf.8a9cd502481f327p-4L, 0xf.5edf4b01d85e97fp-4L, 0xf.5edf4b01d85e98p-4L },
    { -0x2.9371a4cdcbd8ac4p-4L, -0x1.b0829193db9b2a82p-4L, -0x1.b0829193db9b2a8p-4L },
    { 0xf.ec9e23f6d0a3bd2p-4L, 0xf.e52cabad2944b2dp-4L, 0xf.e52cabad2944b2ep-4L },
    { -0x4.bfabe9c4786421c8p-4L, -0x2.f99d50346680f5e4p-4L, -0x2.f99d50346680f5ep-4L },
    { 0x6.028525d3aafe4428p-4L, 0x4.c21ee15b144d29a8p-4L, 0x4.c21ee15b144d29bp-4L },
    { -0x4.c2d0568402546a5p-8L, -0x3.47653cfe61fb05p-8L, -0x3.47653cfe61fb04fcp-8L },
    { 0xc.976222dd345048p-4L, 0xb.9b60191b6b95aecp-4L, 0xb.9b60191b6b95aedp-4L },
    { -0xd.6563e961e96fd5dp-4L, -0x7.0b6f86cbdfafbe78p-4L, -0x7.0b6f86cbdfafbe7p-4L },
    { 0x9.e03ff635ae5b0afp-4L, 0x8.8b0bdb10fd8a85fp-4L, 0x8.8b0bdb10fd8a86p-4L },
    { -0xa.42b9f1752ebee14p-4L, -0x5.bde4e29a894df518p-4L, -0x5.bde4e29a894df51p-4L },
    { 0x6.4ef2060125bf954p-4L, 0x5.074b877b025a5c38p-4L, 0x5.074b877b025a5c4p-4L },
    { -0xc.a4d9e356caf3a4ap-4L, -0x6.bf8205df1ee0d508p-4L, -0x6.bf8205df1ee0d5p-4L },
    { 0x7.e842fb7dd3d50cap-196L, 0x5.7b1c7b3b95bed698p-196L, 0x5.7b1c7b3b95bed6ap-196L },
    { -0x1.31f41258f7c01eccp-60L, -0xd.4121c04c9ce13acp-64L, -0xd.4121c04c9ce13abp-64L },
    { 0x2.29f54bce824a24cp-8L, 0x1.811a02ec67bf37aep-8L, 0x1.811a02ec67bf37bp-8L },
    { -0xa.b8f81b679b49916p-4L, -0x5.f1eb5dee53695e5p-4L, -0x5.f1eb5dee53695e48p-4L },
    { 0x2.dfa40c215498cf14p-4L, 0x2.1f01613fffbe7cfcp-4L, 0x2.1f01613fffbe7dp-4L },
    { -0x2.ec02031137509e54p-4L, -0x1.e7019f7577e0055ap-4L, -0x1.e7019f7577e00558p-4L },
    { 0xc.95b28af67c0d0fdp-4L, 0xb.995bfeb5a18fb19p-4L, 0xb.995bfeb5a18fb1ap-4L },
    { -0x3.8b937ee4a5ad9044p-4L, -0x2.4727f0551eb47668p-4L, -0x2.4727f0551eb47664p-4L },
    { 0xc.b61f96c1b9a40fep-8L, 0x8.f6d9fa1cd76287dp-8L, 0x8.f6d9fa1cd76287ep-8L },
    { -0x5.32ac5f2f72c534e8p-4L, -0x3.39e0dcc0490bcf08p-4L, -0x3.39e0dcc0490bcf04p-4L },
    { 0x3.71a836d1385ea83cp-4L, 0x2.930fc44d7c9f0878p-4L, 0x2.930fc44d7c9f087cp-4L },
    { -0x2.98de885b63ec9fap-4L, -0x1.b3df390ab96ff674p-4L, -0x1.b3df390ab96ff672p-4L },
    { 0x2.ec64d50f08792a24p-4L, 0x2.290720411b492388p-4L, 0x2.290720411b49238cp-4L },
    { -0x7.4a3ef749c24694d8p-4L, -0x4.55393aafd5f18ddp-4L, -0x4.55393aafd5f18dc8p-4L },
    { 0x1.c73a886f525db7c4p-4L, 0x1.48033f1818ec4274p-4L, 0x1.48033f1818ec4276p-4L },
    { -0x7.e597e9edb98f8dd8p-4L, -0x4.a2b8122945a3a86p-4L, -0x4.a2b8122945a3a858p-4L },
    { 0x5.b2db0149e01e772p-4L, 0x4.7af5d27da276247p-4L, 0x4.7af5d27da2762478p-4L },
    { -0xa.4e00c5865119715p-4L, -0x5.c2e6944e696561dp-4L, -0x5.c2e6944e696561c8p-4L },
    { 0x3.2d5ce470bbbfc05p-4L, 0x2.5c6c520e75d5dcfp-4L, 0x2.5c6c520e75d5dcf4p-4L },
    { -0x6.fef503b2cde63e88p-4L, -0x4.2eed1c50abe4d0fp-4L, -0x4.2eed1c50abe4d0e8p-4L },
    { 0x9.d7135271cf1adc5p-8L, 0x6.e98f0ad0c8f784bp-8L, 0x6.e98f0ad0c8f784b8p-8L },
    { -0x1.37a6e3f9da2ebc3ap-4L, -0xd.26c4f046ca71bc4p-8L, -0xd.26c4f046ca71bc3p-8L },
    { 0xe.f91909cb851832p-16L, 0xa.611c7fdf8ec95cap-16L, 0xa.611c7fdf8ec95cbp-16L },
    { -0x1.8aec185a037005eap-44L, -0x1.11bd3ef298133bf6p-44L, -0x1.11bd3ef298133bf4p-44L },
    { 0x4.58042455b6631c78p-4L, 0x3.5016317376e61d88p-4L, 0x3.5016317376e61d8cp-4L },
    { -0xf.a5425993c2d22edp-4L, -0x7.e04f162edd1444c8p-4L, -0x7.e04f162edd1444cp-4L },
    { 0xc.cc707747b5d9891p-4L, 0xb.db1d6d0a67ba46dp-4L, 0xb.db1d6d0a67ba46ep-4L },
    { -0x5.6352b9b11a14c48p-4L, -0x3.54b0a77bead101c4p-4L, -0x3.54b0a77bead101cp-4L },
    { 0xb.ddfe2e36f24ba09p-4L, 0xa.c1181c4c96d3b16p-4L, 0xa.c1181c4c96d3b17p-4L },
    { -0xf.ff0d58e82429fafp-4L, -0x7.ffabe56fa53e346p-4L, -0x7.ffabe56fa53e3458p-4L },
    { 0x9.bd53e4167e85b42p-4L, 0x8.6606596f18f0c25p-4L, 0x8.6606596f18f0c26p-4L },
    { -0x5.4c28c9b0b345941p-4L, -0x3.47f39e55e7145a5p-4L, -0x3.47f39e55e7145a4cp-4L },
    { 0x8.fef78aad41a1338p-4L, 0x7.a005c2fb7b575668p-4L, 0x7.a005c2fb7b57567p-4L },
    { -0xf.25b2822b10d9f65p-4L, -0x7.b2ed5c3922a4e83p-4L, -0x7.b2ed5c3922a4e828p-4L },
    { 0x5.cd10c03bcaf10088p-8L, 0x4.0d7eda5d78333cc8p-8L, 0x4.0d7eda5d78333cdp-8L },
    { -0xa.a821812c5f53b52p-4L, -0x5.ea92fddd766193d8p-4L, -0x5.ea92fddd766193dp-4L },
    { 0x5.94e05ec04235ac68p-4L, 0x4.606dcea9678b422p-4L, 0x4.606dcea9678b4228p-4L },
    { -0x5.04ba966a5474e0e8p-4L, -0x3.205aab0b1a291c5cp-4L, -0x3.205aab0b1a291c58p-4L },
    { 0xd.167af1356c9c025p-4L, 0xc.3506efb6e7f748dp-4L, 0xc.3506efb6e7f748ep-4L },
    { -0xf.d0cd204dbb8b533p-4L, -0x7.ef93a0736368116p-4L, -0x7.ef93a07363681158p-4L },
    { 0xa.c0e5742f317f8a3p-4L, 0x9.7e80068401fa255p-4L, 0x9.7e80068401fa256p-4L },
    { -0xe.2242314d427e9c1p-4L, -0x7.538ce8c2b95acc28p-4L, -0x7.538ce8c2b95acc2p-4L },
    { 0x2.37749e13337ef694p-4L, 0x1.9cd5b81ee0f49f52p-4L, 0x1.9cd5b81ee0f49f54p-4L },
    { -0x4.8513915f54085e2p-4L, -0x2.d86313394f7dfa98p-4L, -0x2.d86313394f7dfa94p-4L },
    { 0x7.11d091eb6c5e7f8p-32L, 0x4.e677cd427aff876p-32L, 0x4.e677cd427aff8768p-32L },
    { -0x2.92d0f5e17e14f8ep-176L, -0x1.c8a818bcf03dad22p-176L, -0x1.c8a818bcf03dad2p-176L },
    { 0x9.19d2bf8e626ce94p-4L, 0x7.bb9267aaaf8d16f8p-4L, 0x7.bb9267aaaf8d17p-4L },
    { -0x5.78fee31b1243e6ep-4L, -0x3.6090300d6de230a8p-4L, -0x3.6090300d6de230a4p-4L },
    { 0xe.920450e2df4f23ep-4L, 0xe.14081596bb730e3p-4L, 0xe.14081596bb730e4p-4L },
    { -0x7.8a913f4c29492cdp-4L, -0x4.758ec9da15257a08p-4L, -0x4.758ec9da15257ap-4L },
    { 0xd.f18c68c5e57c1fep-4L, 0xd.45bf8cfdf37d1c1p-4L, 0xd.45bf8cfdf37d1c2p-4L },
    { -0xc.97ed4020a652183p-4L, -0x6.ba5270a397bd198p-4L, -0x6.ba5270a397bd1978p-4L },
    { 0x6.b2da8740f690432p-4L, 0x5.63158e0eca286c4p-4L, 0x5.63158e0eca286c48p-4L },
    { -0x8.d86e55e3f0a94b1p-4L, -0x5.17d9c3b44828322p-4L, -0x5.17d9c3b448283218p-4L },
    { 0x5.0308adabc4a020fp-4L, 0x3.e14306a78e1170ccp-4L, 0x3.e14306a78e1170dp-4L },
    { -0x2.a7d9b961e2c3089p-4L, -0x1.bd23ae2c81af213p-4L, -0x1.bd23ae2c81af212ep-4L },
    { 0xd.227d8e4d09d7251p-4L, 0xc.43b7e073dd24255p-4L, 0xc.43b7e073dd24256p-4L },
    { -0x7.d5608278690935ap-4L, -0x4.9ab96d634d10f6a8p-4L, -0x4.9ab96d634d10f6ap-4L },
    { 0xe.81b27c03c76f499p-4L, 0xd.fecbb5a87bddaadp-4L, 0xd.fecbb5a87bddaaep-4L },
    { -0x2.b154c8162bc04cb4p-4L, -0x1.c2fdf56982dfaa86p-4L, -0x1.c2fdf56982dfaa84p-4L },
    { 0x4.35ecdac82f2a93c8p-4L, 0x3.33a5663cd3ec757cp-4L, 0x3.33a5663cd3ec758p-4L },
    { -0x5.771325ed71c201dp-4L, -0x3.5f833dab5799d678p-4L, -0x3.5f833dab5799d674p-4L },
    { 0xb.d5c2b3ad8490192p-4L, 0xa.b78f2869f7f0d2fp-4L, 0xa.b78f2869f7f0d3p-4L },
    { -0x5.121392f3a25f68p-4L, -0x3.27ca31d087184188p-4L, -0x3.27ca31d087184184p-4L },
    { 0x7.b9734cb7e88bd598p-4L, 0x6.5bdf83f80e502428p-4L, 0x6.5bdf83f80e50243p-4L },
    { -0x1.778ccedfa82f4736p-4L, -0xf.c36523958ccb66dp-8L, -0xf.c36523958ccb66cp-8L },
    { 0x5.9e61f2660d92e2bp-24L, 0x3.e502ce773052c2ep-24L, 0x3.e502ce773052c2e4p-24L },
    { -0xc.ed5cdd95e040dd5p-124L, -0x8.f5e01e66418fdc9p-124L, -0x8.f5e01e66418fdc8p-124L },
    { 0xe.22ec92ad54501adp-4L, 0xd.84a01b636eef0b3p-4L, 0xd.84a01b636eef0b4p-4L },
    { -0x7.ec2bfe55bde275dp-4L, -0x4.a5f4b909907e0218p-4L, -0x4.a5f4b909907e021p-4L },
    { 0xf.d304d6628c01f2ap-4L, 0xf.c1e1328eafdd3bfp-4L, 0xf.c1e1328eafdd3cp-4L },
    { -0x9.352c83f42a1922fp-4L, -0x5.43546e87e016ee88p-4L, -0x5.43546e87e016ee8p-4L },
    { 0x7.4cdb36f2473c8acp-4L, 0x5.f3a5959c53f3ceb8p-4L, 0x5.f3a5959c53f3cecp-4L },
    { -0x1.70792a73178fa0fap-4L, -0xf.79b33e5d77df4c1p-8L, -0xf.79b33e5d77df4cp-8L },
    { 0x5.1ce62b8e10774afp-4L, 0x3.f7962ac86af2f5ecp-4L, 0x3.f7962ac86af2f5fp-4L },
    { -0x7.fa8931ceaf326ac8p-4L, -0x4.ad02e3351c74545p-4L, -0x4.ad02e3351c745448p-4L },
    { 0xb.369caaaa169ce0fp-4L, 0xa.01d090312957af1p-4L, 0xa.01d090312957af2p-4L },
    { -0xa.954d79680ea5909p-4L, -0x5.e25609c7a753185p-4L, -0x5.e25609c7a7531848p-4L },
    { 0xb.432563e5c37e78fp-4L, 0xa.0ff3939e94e53c8p-4L, 0xa.0ff3939e94e53c9p-4L },
    { -0xa.950b0bb7d84c5b3p-4L, -0x5.e238ed18b7fab0bp-4L, -0x5.e238ed18b7fab0a8p-4L },
    { 0x4.3e136fbe7e156658p-4L, 0x3.3a6e53129453d0d4p-4L, 0x3.3a6e53129453d0d8p-4L },
    { -0xb.9930789b19cf8a8p-4L, -0x6.51c2880aa5aa9ff8p-4L, -0x6.51c2880aa5aa9ffp-4L },
    { 0x8.1697784edf6fe07p-8L, 0x5.ab0e426210147018p-8L, 0x5.ab0e42621014702p-8L },
    { -0x2.e9849ddc62c0d374p-4L, -0x1.e57c4324b108422ep-4L, -0x1.e57c4324b108422cp-4L },
    { 0xc.d570e244c0e60bep-4L, 0xb.e5fc70032574c78p-4L, 0xb.e5fc70032574c79p-4L },
    { -0xf.15d04c531718d34p-4L, -0x7.ad351e2ce95c1f88p-4L, -0x7.ad351e2ce95c1f8p-4L },
    { 0x1.e1200b8406eda8fep-4L, 0x1.5b715b4dfb18883p-4L, 0x1.5b715b4dfb188832p-4L },
    { -0x7.995991a529314d5p-4L, -0x4.7cf0755dd5eca728p-4L, -0x4.7cf0755dd5eca72p-4L },
    { 0x9.2cb86254ecdfd09p-192L, 0x6.5c0241febd46c9cp-192L, 0x6.5c0241febd46c9c8p-192L },
    { -0x2.4cc15f58d07c3b1cp-140L, -0x1.981818282e5dbca4p-140L, -0x1.981818282e5dbca2p-140L },
    { 0x3.9173123187f70484p-4L, 0x2.acb691682f6030d4p-4L, 0x2.acb691682f6030d8p-4L },
    { -0x4.e07d3709dbe3fep-4L, -0x3.0c14b7174878c9ecp-4L, -0x3.0c14b7174878c9e8p-4L },
    { 0x5.653d42dac0a5219p-4L, 0x4.368bd2c07053e5ep-4L, 0x4.368bd2c07053e5e8p-4L },
    { -0x9.5f1aff673a041bcp-4L, -0x5.56c3d8c108a0611p-4L, -0x5.56c3d8c108a06108p-4L },
    { 0x8.bcd403a004e1a23p-4L, 0x7.5cb550c524697b8p-4L, 0x7.5cb550c524697b88p-4L },
    { -0x8.1c9d05645c7987cp-4L, -0x4.bdae53d810a91ac8p-4L, -0x4.bdae53d810a91acp-4L },
    { 0xd.13a5ae9285d253dp-4L, 0xc.3190e4f8d4d5582p-4L, 0xc.3190e4f8d4d5583p-4L },
    { -0x9.4cf62e7e77f656p-4L, -0x5.4e5f50857e68f51p-4L, -0x5.4e5f50857e68f508p-4L },
    { 0x2.84d9c1bc69548254p-4L, 0x1.d846c310aa00c054p-4L, 0x1.d846c310aa00c056p-4L },
    { -0x4.21ac0c75a3a7dbe8p-4L, -0x2.9f423cc607a168dcp-4L, -0x2.9f423cc607a168d8p-4L },
    { 0xd.b9bd68e165f831p-4L, 0xc.ff4f076046a69dp-4L, 0xc.ff4f076046a69d1p-4L },
    { -0x8.3fd61ad578cd929p-4L, -0x4.cecf6eabd87b7c9p-4L, -0x4.cecf6eabd87b7c88p-4L },
    { 0xf.30d46d764112444p-4L, 0xe.e5c6f47afffabf2p-4L, 0xe.e5c6f47afffabf3p-4L },
    { -0xb.cd4a73dc359d737p-4L, -0x6.6783a45e4e8dae2p-4L, -0x6.6783a45e4e8dae18p-4L },
    { 0x5.457d60a9148a985p-4L, 0x4.1ad19bfee71e48dp-4L, 0x4.1ad19bfee71e48d8p-4L },
    { -0x5.9e1738c1ccd8a9a8p-4L, -0x3.74c8e8a92c7f7b74p-4L, -0x3.74c8e8a92c7f7b7p-4L },
    { 0x1.497ab915f40b4518p-4L, 0xe.add4c95fb682b23p-8L, 0xe.add4c95fb682b24p-8L },
    { -0x4.8e012f7d7878b01p-4L, -0x2.dd78a1d7e408573cp-4L, -0x2.dd78a1d7e4085738p-4L },
    { 0x5.9d5fb6a6e532323p-4L, 0x4.67ef7a4d5b079348p-4L, 0x4.67ef7a4d5b07935p-4L },
    { -0x7.bc4dc1a54a48fdbp-4L, -0x4.8e51e755a24d00f8p-4L, -0x4.8e51e755a24d00fp-4L },
    { 0x3.fc5a846dfbec9adp-200L, 0x2.c3415566e5a54668p-200L, 0x2.c3415566e5a5466cp-200L },
    { -0x7.6980774d9eb5024p-128L, -0x5.233f7f59341a9e7p-128L, -0x5.233f7f59341a9e68p-128L },
    { 0xc.52f873b5b0d54efp-8L, 0x8.afc12e42adf7bacp-8L, 0x8.afc12e42adf7badp-8L },
    { -0x2.b8137644250c4bbcp-4L, -0x1.c7266a67c6352a0ap-4L, -0x1.c7266a67c6352a08p-4L },
    { 0x8.b13bd917a919d6p-4L, 0x7.50fc3760355aaba8p-4L, 0x7.50fc3760355aabbp-4L },
    { -0xd.a7e60f2da06694ep-4L, -0x7.2517f5997441288p-4L, -0x7.2517f59974412878p-4L },
    { 0x9.6d66afe84b35074p-4L, 0x8.121cbf603f1eb03p-4L, 0x8.121cbf603f1eb04p-4L },
    { -0x8.d45410dc1895ef4p-4L, -0x5.15e9564a5d57b1d8p-4L, -0x5.15e9564a5d57b1dp-4L },
    { 0x8.7112de739485f11p-4L, 0x7.108706705b67e1bp-4L, 0x7.108706705b67e1b8p-4L },
    { -0x5.28bf133fa6f14d3p-4L, -0x3.34615bbf1f08718cp-4L, -0x3.34615bbf1f087188p-4L },
    { 0x5.9ce42450cfaf8ee8p-4L, 0x4.67823dfabf51ea3p-4L, 0x4.67823dfabf51ea38p-4L },
    { -0x6.efb719daf136a1cp-4L, -0x4.271d11505413f6b8p-4L, -0x4.271d11505413f6bp-4L },
    { 0x9.ba0bd38df957e82p-8L, 0x6.d4e5a59f2ab3464p-8L, 0x6.d4e5a59f2ab34648p-8L },
    { -0x7.f37ea4723b67675p-4L, -0x4.a98e0f5848567a48p-4L, -0x4.a98e0f5848567a4p-4L },
    { 0x2.bf5897672b745798p-4L, 0x2.05b8d1dd696925cp-4L, 0x2.05b8d1dd696925c4p-4L },
    { -0x1.2b46b769cd53c99cp-4L, -0xc.a46ee1aa5cf6e29p-8L, -0xc.a46ee1aa5cf6e28p-8L },
    { 0x8.0d256afefef3c89p-4L, 0x6.ad850d0f71e9f0fp-4L, 0x6.ad850d0f71e9f0f8p-4L },
    { -0xa.e23fca6db43882fp-4L, -0x6.03d69b4a9fcb498p-4L, -0x6.03d69b4a9fcb4978p-4L },
    { 0x3.5d7f19c9107b35a4p-4L, 0x2.82ddd03061b78d4p-4L, 0x2.82ddd03061b78d44p-4L },
    { -0x4.0740585229be331p-4L, -0x2.8fe9890e66210b8p-4L, -0x2.8fe9890e66210b7cp-4L },
    { 0xb.2f2372351c33164p-8L, 0x7.deee40d7b054f0a8p-8L, 0x7.deee40d7b054f0bp-8L },
    { -0x1.e98b74b783fe8242p-4L, -0x1.45a6bc169044944ep-4L, -0x1.45a6bc169044944cp-4L },
    { 0x1.ef271536f1acac7cp-116L, 0x1.5736b36e46fd9e2p-116L, 0x1.5736b36e46fd9e22p-116L },
    { -0x2.f2b30898a501e344p-172L, -0x2.0b1e2354091a9a9p-172L, -0x2.0b1e2354091a9a8cp-172L },
    { 0xc.de09271a73942cap-4L, 0xb.f061a10e47f19afp-4L, 0xb.f061a10e47f19bp-4L },
    { -0xd.1fe6e25acc0107ap-4L, -0x6.f0515b52d3bc8b1p-4L, -0x6.f0515b52d3bc8b08p-4L },
    { 0x5.379d21e155802d5p-8L, 0x3.a458c1e822fc87b8p-8L, 0x3.a458c1e822fc87bcp-8L },
    { -0x7.f34a81711f9595fp-4L, -0x4.a974739e5e3c1ecp-4L, -0x4.a974739e5e3c1eb8p-4L },
    { 0x9.8f02fd2b4d10383p-4L, 0x8.3542c1ae328d562p-4L, 0x8.3542c1ae328d563p-4L },
    { -0x3.10d386b4ddaa9bccp-4L, -0x1.fd6c33e550a573ep-4L, -0x1.fd6c33e550a573dep-4L },
    { 0x8.a7f4a483fcced92p-4L, 0x7.479ee5100ad2768p-4L, 0x7.479ee5100ad27688p-4L },
    { -0x8.6ddd524df76f7bdp-4L, -0x4.e50a7bb2dd656468p-4L, -0x4.e50a7bb2dd65646p-4L },
    { 0xc.779757b60637763p-4L, 0xb.757468127d65f88p-4L, 0xb.757468127d65f89p-4L },
    { -0xe.777fe73bf0e9a48p-4L, -0x7.7359b3768a34b5c8p-4L, -0x7.7359b3768a34b5cp-4L },
    { 0x2.31b8036de80e551p-4L, 0x1.9875b4516816bbbep-4L, 0x1.9875b4516816bbcp-4L },
    { -0x9.0b16723fd236994p-4L, -0x5.2faf0a9074dea98p-4L, -0x5.2faf0a9074dea978p-4L },
    { 0x8.9a19522584fca8fp-4L, 0x7.39a98b528df1ef3p-4L, 0x7.39a98b528df1ef38p-4L },
    { -0xf.5402328fd9d6fdfp-4L, -0x7.c38432212a78edbp-4L, -0x7.c38432212a78eda8p-4L },
    { 0x3.39b72eedc5fb39acp-4L, 0x2.664255df780701c4p-4L, 0x2.664255df780701c8p-4L },
    { -0xc.d7d4b25d5ee54a4p-4L, -0x6.d3da67d23282e35p-4L, -0x6.d3da67d23282e348p-4L },
    { 0xf.002b8779c597ceep-4L, 0xe.a4e96c0af56d93ap-4L, 0xe.a4e96c0af56d93bp-4L },
    { -0x7.903eb3c7555e4358p-4L, -0x4.78651e55fe9e325p-4L, -0x4.78651e55fe9e3248p-4L },
    { 0x2.90b7822bc63776fcp-4L, 0x1.e17582d5a09ed40ap-4L, 0x1.e17582d5a09ed40cp-4L },
    { -0xb.887e64736056822p-4L, -0x6.4abf8763ec5ac7ep-4L, -0x6.4abf8763ec5ac7d8p-4L },
    { 0x1.4b3a350eb68541aep-20L, 0xe.596e40ce64dcf5ap-24L, 0xe.596e40ce64dcf5bp-24L },
    { -0x1.aef913a565a8bc1ap-128L, -0x1.2aba49d9af3d613p-128L, -0x1.2aba49d9af3d612ep-128L },
    { 0xc.8b02c285d275bd6p-4L, 0xb.8c97f1c3166348p-4L, 0xb.8c97f1c31663481p-4L },
    { -0x7.2ea947c351044f48p-4L, -0x4.473fa3759df5825p-4L, -0x4.473fa3759df58248p-4L },
    { 0xc.4830d91b64528bdp-4L, 0xb.3d4b68c0a1c1452p-4L, 0xb.3d4b68c0a1c1453p-4L },
    { -0xa.faff5d48675db64p-4L, -0x6.0e8570512dea4ae8p-4L, -0x6.0e8570512dea4aep-4L },
    { 0x1.456f46c72593c416p-4L, 0xe.7e6b02981c8b075p-8L, 0xe.7e6b02981c8b076p-8L },
    { -0x2.cdc53dd42a6cdf4cp-4L, -0x1.d47df5d7bd63c49ep-4L, -0x1.d47df5d7bd63c49cp-4L },
    { 0xd.de830895fc14d25p-4L, 0xd.2da568a29ea15dp-4L, 0xd.2da568a29ea15d1p-4L },
    { -0x1.d696938384c107e8p-4L, -0x1.39897019921dfe5ap-4L, -0x1.39897019921dfe58p-4L },
    { 0x3.5cde202fff810fdp-4L, 0x2.825cba775f96e8d4p-4L, 0x2.825cba775f96e8d8p-4L },
    { -0xb.0173bf64b3af081p-4L, -0x6.114cd4839031f808p-4L, -0x6.114cd4839031f8p-4L },
    { 0x9.ae157e1a5d07d3dp-4L, 0x8.55eee27b4bf2689p-4L, 0x8.55eee27b4bf268ap-4L },
    { -0x4.bded6e2f0ae69668p-4L, -0x2.f8a157b29a4320f8p-4L, -0x2.f8a157b29a4320f4p-4L },
    { 0xb.7b9077a770021aep-4L, 0xa.4ff4d2970ce8214p-4L, 0xa.4ff4d2970ce8215p-4L },
    { -0xe.794bdddad00436cp-4L, -0x7.740408ba771c01d8p-4L, -0x7.740408ba771c01dp-4L },
    { 0x8.bcfd1861de45b01p-4L, 0x7.5cdee4cb7bee481p-4L, 0x7.5cdee4cb7bee4818p-4L },
    { -0xa.ab4ea1951712b09p-4L, -0x5.ebf61acd701b7f68p-4L, -0x5.ebf61acd701b7f6p-4L },
    { 0x6.f81960839d640cdp-4L, 0x5.a39e8005baae39bp-4L, 0x5.a39e8005baae39b8p-4L },
    { -0x7.693a270061cf9de8p-4L, -0x4.64d777196e594488p-4L, -0x4.64d777196e59448p-4L },
    { 0xe.7b0648fc94495aap-4L, 0xd.f6213f610dcf21ep-4L, 0xd.f6213f610dcf21fp-4L },
    { -0xa.916b419fbe9fc1p-4L, -0x5.e0a2312a38c0e318p-4L, -0x5.e0a2312a38c0e31p-4L },
    { 0x1.89bd813bf1f6a1c2p-92L, 0x1.10eb819b2e242b1ep-92L, 0x1.10eb819b2e242b2p-92L },
    { -0x5.9293af393bd5fbfp-184L, -0x3.dcd3e77adc468a94p-184L, -0x3.dcd3e77adc468a9p-184L },
    { 0xd.3ea27eab88fb691p-4L, 0xc.6643216e56bbfb4p-4L, 0xc.6643216e56bbfb5p-4L },
    { -0xe.5d425700b9dfb9p-4L, -0x7.699c2694c5a2105p-4L, -0x7.699c2694c5a21048p-4L },
    { 0x7.ef30d4f5d43c309p-4L, 0x6.902a2db66b7bda78p-4L, 0x6.902a2db66b7bda8p-4L },
    { -0xc.2cc3adaa5f76bd8p-4L, -0x6.8ee23784f80cfdc8p-4L, -0x6.8ee23784f80cfdcp-4L },
    { 0x2.8b29e4e9b1677aap-4L, 0x1.dd28d0729a15749cp-4L, 0x1.dd28d0729a15749ep-4L },
    { -0xb.c9870bb9c74469p-4L, -0x6.65f306cc38bba318p-4L, -0x6.65f306cc38bba31p-4L },
    { 0x3.9b5a02bfcb72b468p-4L, 0x2.b4bb195f6468ceep-4L, 0x2.b4bb195f6468cee4p-4L },
    { -0x3.fcdc007ba74601ap-4L, -0x2.89db741e09207918p-4L, -0x2.89db741e09207914p-4L },
    { 0xf.8ea939c39a2414cp-8L, 0xb.038978e1848fbcep-8L, 0xb.038978e1848fbcfp-8L },
    { -0xd.38eafd3878fe2f4p-12L, -0x9.279f93a09aef86p-12L, -0x9.279f93a09aef85fp-12L },
    { 0x1.c55b237b57929914p-8L, 0x1.3aff3dbaa1f54462p-8L, 0x1.3aff3dbaa1f54464p-8L },
    { -0xe.5512393a7c3aa68p-4L, -0x7.668fce4e8d41ec3p-4L, -0x7.668fce4e8d41ec28p-4L },
    { 0x6.c72dbae38baf489p-4L, 0x5.75f2be10b3da51p-4L, 0x5.75f2be10b3da5108p-4L },
    { -0xa.9efab67bae298c4p-4L, -0x5.e692c461328f2a38p-4L, -0x5.e692c461328f2a3p-4L },
    { 0x6.d6fe2acf94b44bp-4L, 0x5.84abad9d09e7a7dp-4L, 0x5.84abad9d09e7a7d8p-4L },
    { -0x2.1052fcc75fe78e44p-4L, -0x1.5e50254d52c2cb86p-4L, -0x1.5e50254d52c2cb84p-4L },
    { 0xf.5f7e274f7549127p-4L, 0xf.247c06ed64581d2p-4L, 0xf.247c06ed64581d3p-4L },
    { -0xc.e3f378c5ed3afabp-4L, -0x6.d8aa145971328588p-4L, -0x6.d8aa14597132858p-4L },
    { 0x5.ed5d3988224f9748p-4L, 0x4.af2122809de98b08p-4L, 0x4.af2122809de98b1p-4L },
    { -0x3.ceeb00215e0d28fp-4L, -0x2.6ef600bcd292a928p-4L, -0x2.6ef600bcd292a924p-4L },
    { 0x1.81a67feedc219a8cp-160L, 0x1.0b4ffeb467c6a36cp-160L, 0x1.0b4ffeb467c6a36ep-160L },
    { -0x4.1c590bda30ba606p-76L, -0x2.d96e935fdb4f2c6p-76L, -0x2.d96e935fdb4f2c5cp-76L },
    { 0xc.afcea80015980b8p-4L, 0xb.b8a5752c99ff1d2p-4L, 0xb.b8a5752c99ff1d3p-4L },
    { -0xb.d8b227ae135fe8fp-4L, -0x6.6c4030ee2cb63a3p-4L, -0x6.6c4030ee2cb63a28p-4L },
    { 0x8.dc01d8b49232a17p-4L, 0x7.7c58fa948c1ea33p-4L, 0x7.7c58fa948c1ea338p-4L },
    { -0x1.933e5a044e710e98p-4L, -0x1.0e2f0aea0ed3f88ep-4L, -0x1.0e2f0aea0ed3f88cp-4L },
    { 0x1.a467d39df9435c82p-4L, 0x1.2e04d4c090c9af46p-4L, 0x1.2e04d4c090c9af48p-4L },
    { -0xd.177492196d07a44p-4L, -0x6.ecffef80c3115ef8p-4L, -0x6.ecffef80c3115efp-4L },
    { 0xa.8eb53214a5d4d15p-4L, 0x9.474ddcecd909225p-4L, 0x9.474ddcecd909226p-4L },
    { -0x1.8712ead1e57a5c3cp-4L, -0x1.064bf416745202b8p-4L, -0x1.064bf416745202b6p-4L },
    { 0x8.4de1b5d10a110dbp-4L, 0x6.ed77dcb741f173c8p-4L, 0x6.ed77dcb741f173dp-4L },
    { -0x2.5fb6ddfc66521d98p-4L, -0x1.904c98bb8b81f248p-4L, -0x1.904c98bb8b81f246p-4L },
    { 0x9.4d57927720bce2ap-4L, 0x7.f0c5a855860ee5c8p-4L, 0x7.f0c5a855860ee5dp-4L },
    { -0xd.c24a0c2da437c45p-8L, -0x9.5c8c25cb60521fp-8L, -0x9.5c8c25cb60521efp-8L },
    { 0xe.f5d12aeb5942b6bp-8L, 0xa.951ffb20b4a544dp-8L, 0xa.951ffb20b4a544ep-8L },
    { -0x1.6c160eed113f724cp-8L, -0xf.be148f1adb1e1fp-12L, -0xf.be148f1adb1e1efp-12L },
    { 0xe.5e4d4cc7965edb5p-4L, 0xd.d0f05f423ac4ecp-4L, 0xd.d0f05f423ac4ec1p-4L },
    { -0x9.fc2ec0983ea77b3p-4L, -0x5.9e5b37a59c48991p-4L, -0x5.9e5b37a59c489908p-4L },
    { 0xe.add7dabec19d155p-4L, 0xe.38603c1d1ea2234p-4L, 0xe.38603c1d1ea2235p-4L },
    { -0xe.ca8e0a5bcb1909bp-4L, -0x7.91e59560df20b59p-4L, -0x7.91e59560df20b588p-4L },
    { 0xf.3c4d21f42ce9eep-4L, 0xe.f525a7db23c77d2p-4L, 0xe.f525a7db23c77d3p-4L },
    { -0x6.a2b3b3cd69bd69p-4L, -0x3.ff5415c01005cd3p-4L, -0x3.ff5415c01005cd2cp-4L },
    { 0x1.5878b28462452782p-68L, 0xe.ec4f96d55b56cbap-72L, 0xe.ec4f96d55b56cbbp-72L },
    { -0xd.226b6159f1b8274p-176L, -0x9.1aa6ccef2946b71p-176L, -0x9.1aa6ccef2946b7p-176L },
    { 0xd.a2d0231770a0b2fp-4L, 0xc.e29042d0f0148dep-4L, 0xc.e29042d0f0148dfp-4L },
    { -0x5.88f950204ac58c2p-4L, -0x3.6949fabdeff8c62cp-4L, -0x3.6949fabdeff8c628p-4L },
    { 0xd.566e196c5299a76p-4L, 0xc.8398d1f51b7d57bp-4L, 0xc.8398d1f51b7d57cp-4L },
    { -0xd.827bfd05ebedd0fp-4L, -0x7.16b1fb3d30143fdp-4L, -0x7.16b1fb3d30143fc8p-4L },
    { 0xe.690353be92b1ef7p-4L, 0xd.dec96ccbdc54711p-4L, 0xd.dec96ccbdc54712p-4L },
    { -0xc.b40a6525370a3c1p-4L, -0x6.c59691f570ea335p-4L, -0x6.c59691f570ea3348p-4L },
    { 0x4.a16f62e1fb463d7p-4L, 0x3.8de59c3015480afp-4L, 0x3.8de59c3015480af4p-4L },
    { -0xb.6a308232b3be302p-4L, -0x6.3df86ee55414e478p-4L, -0x6.3df86ee55414e47p-4L },
    { 0xa.589c3c563d348fcp-4L, 0x9.0c54f3c1e94b5d5p-4L, 0x9.0c54f3c1e94b5d6p-4L },
    { -0xe.aaf84b1b375592p-4L, -0x7.8654b73051a16d2p-4L, -0x7.8654b73051a16d18p-4L },
    { 0x2.4225b8cb6a3450acp-4L, 0x1.a5000bbb5b20203p-4L, 0x1.a5000bbb5b202032p-4L },
    { -0x5.e1f5a13fb1e038ap-16L, -0x4.13d1b0bbfe40d278p-16L, -0x4.13d1b0bbfe40d27p-16L },
    { 0x6.501f9ed256bec01p-4L, 0x5.085e4ef770a5bbd8p-4L, 0x5.085e4ef770a5bbep-4L },
    { -0xa.0150779e90ebc75p-4L, -0x5.a0a9cac5cfa9e798p-4L, -0x5.a0a9cac5cfa9e79p-4L },
    { 0xd.5de12ee5f0afea5p-4L, 0xc.8cce152f519601bp-4L, 0xc.8cce152f519601cp-4L },
    { -0x8.16fa985eea51244p-4L, -0x4.baee6e9ee24b5858p-4L, -0x4.baee6e9ee24b585p-4L },
    { 0x2.32885a9f2271ac78p-4L, 0x1.991486e0e24975d2p-4L, 0x1.991486e0e24975d4p-4L },
    { -0x9.2c631a27ad6ae34p-4L, -0x5.3f3d59c428297e48p-4L, -0x5.3f3d59c428297e4p-4L },
    { 0xd.5153d9f62ecffddp-4L, 0xc.7d4bf03f0e6d411p-4L, 0xc.7d4bf03f0e6d412p-4L },
    { -0x2.e68bda95c5b3e06cp-4L, -0x1.e3ab538ce3f7ecdap-4L, -0x1.e3ab538ce3f7ecd8p-4L },
    { 0x7.a68b5532b0e7f568p-200L, 0x5.4d8f37527724f7d8p-200L, 0x5.4d8f37527724f7ep-200L },
    { -0x3.cd1483e1b10e99dp-84L, -0x2.a27cdd6c9a12d844p-84L, -0x2.a27cdd6c9a12d84p-84L },
    { 0xc.e8479ca0a43ef6p-8L, 0x9.1ad81877660b242p-8L, 0x9.1ad81877660b243p-8L },
    { -0x9.182ad6a367d08aep-4L, -0x5.35cdecfe5b731ce8p-4L, -0x5.35cdecfe5b731cep-4L },
    { 0x9.3029b8a7e85f35dp-4L, 0x7.d29571a8ad519618p-4L, 0x7.d29571a8ad51962p-4L },
    { -0xa.52ae9411f58887cp-4L, -0x5.c4f9aa019dcb689p-4L, -0x5.c4f9aa019dcb6888p-4L },
    { 0x7.5113a83ec9894cep-4L, 0x5.f7a9702b44563248p-4L, 0x5.f7a9702b4456325p-4L },
    { -0xd.13cf8aa40b87d27p-4L, -0x6.eb9109ecc7f4ddb8p-4L, -0x6.eb9109ecc7f4ddbp-4L },
    { 0xf.2395a1a0df7935bp-4L, 0xe.d411568c149c22fp-4L, 0xe.d411568c149c23p-4L },
    { -0x1.7af3bd8ca1f57c42p-4L, -0xf.e6caba0e492e4c1p-8L, -0xf.e6caba0e492e4cp-8L },
    { 0xd.f33b2053ffa6ae5p-4L, 0xd.47e1d5b0dd7bc76p-4L, 0xd.47e1d5b0dd7bc77p-4L },
    { -0xa.8e75c696dc40c78p-4L, -0x5.df55ef48a4e347e8p-4L, -0x5.df55ef48a4e347ep-4L },
    { 0x9.85d3f0dd48eaf72p-4L, 0x8.2ba30c3f7be89e3p-4L, 0x8.2ba30c3f7be89e4p-4L },
    { -0xd.506b8a6e4aa92acp-4L, -0x7.03491cf2bf49246p-4L, -0x7.03491cf2bf492458p-4L },
    { 0xa.d1883d4b01ef45ap-4L, 0x9.90e6441f511c6d1p-4L, 0x9.90e6441f511c6d2p-4L },
    { -0x3.08af0a00602595fp-4L, -0x1.f87a2c14dd7b7f16p-4L, -0x1.f87a2c14dd7b7f14p-4L },
    { 0xf.cac159b69035579p-4L, 0xf.b684c855d131bb2p-4L, 0xf.b684c855d131bb3p-4L },
    { -0x6.46e719cea85447d8p-4L, -0x3.cf38f95b6009617cp-4L, -0x3.cf38f95b60096178p-4L },
    { 0x5.987b05c45ed8a2ep-4L, 0x4.639c8775c1682ffp-4L, 0x4.639c8775c1682ff8p-4L },
    { -0x6.c4e52aa8d26db038p-4L, -0x4.110e8410a7512478p-4L, -0x4.110e8410a751247p-4L },
    { 0x8.23b5b38feb155f2p-4L, 0x6.c3bac23408a8825p-4L, 0x6.c3bac23408a88258p-4L },
    { -0x8.ad2a11b7f1b5ea6p-4L, -0x5.0354fe71cc130f2p-4L, -0x5.0354fe71cc130f18p-4L },
    { 0xf.af53dc003c2e966p-112L, 0xa.df368663af3dfc2p-112L, 0xa.df368663af3dfc3p-112L },
    { -0x3.f7b5578e89e3d3e8p-128L, -0x2.c0090f63161770cp-128L, -0x2.c0090f63161770bcp-128L },
    { 0x3.73e18f430b288f48p-4L, 0x2.94d9fe08f28f346cp-4L, 0x2.94d9fe08f28f347p-4L },
    { -0xc.f70837877517a74p-4L, -0x6.e03802a500a2e72p-4L, -0x6.e03802a500a2e718p-4L },
    { 0x7.3487f80314c54488p-4L, 0x5.dc8fba31d9f318ep-4L, 0x5.dc8fba31d9f318e8p-4L },
    { -0x5.4eccb9e96eb8967p-4L, -0x3.4967fb3eb0a4d81cp-4L, -0x3.4967fb3eb0a4d818p-4L },
    { 0x9.44460917d619271p-4L, 0x7.e75fbc9c380ed29p-4L, 0x7.e75fbc9c380ed298p-4L },
    { -0xd.5620dcdef8d6adep-4L, -0x7.0581c9d72c7b4df8p-4L, -0x7.0581c9d72c7b4dfp-4L },
    { 0xd.105984ee31d1a19p-4L, 0xc.2d8a202b2771e41p-4L, 0xc.2d8a202b2771e42p-4L },
    { -0xe.cb19e0196a54de2p-4L, -0x7.9218a6517e6df27p-4L, -0x7.9218a6517e6df268p-4L },
    { 0x5.b49471d499a4cf1p-4L, 0x4.7c7d8b0af0f48c28p-4L, 0x4.7c7d8b0af0f48c3p-4L },
    { -0x9.94f5bdecfacab51p-8L, -0x6.8e6561102f3ee5e8p-8L, -0x6.8e6561102f3ee5ep-8L },
    { 0xf.641993c9a620462p-4L, 0xf.2ab3dcfcad4c33ap-4L, 0xf.2ab3dcfcad4c33bp-4L },
    { -0xd.a2dd238869b2787p-4L, -0x7.23294ba101bfcb28p-4L, -0x7.23294ba101bfcb2p-4L },
    { 0xd.4c3f10c6378bac1p-4L, 0xc.77072f3026675d1p-4L, 0xc.77072f3026675d2p-4L },
    { -0xd.a0da38c144c364ap-4L, -0x7.22638fd7197afdbp-4L, -0x7.22638fd7197afda8p-4L },
    { 0x5.9e57359c4cf1067p-4L, 0x4.68ca49a0fa5b5d78p-4L, 0x4.68ca49a0fa5b5d8p-4L },
    { -0xf.5afa51a915c3c2cp-4L, -0x7.c600693d7adedab8p-4L, -0x7.c600693d7adedabp-4L },
    { 0xa.7324ede2d5b774ep-4L, 0x9.29307a00e1a50c1p-4L, 0x9.29307a00e1a50c2p-4L },
    { -0x4.deb94e5dff32647p-4L, -0x3.0b17181ece0d3c68p-4L, -0x3.0b17181ece0d3c64p-4L },
    { 0x6.67af9a1b48f5476p-4L, 0x5.1de173c8b6ffd77p-4L, 0x5.1de173c8b6ffd778p-4L },
    { -0xb.916f204d9b607e2p-4L, -0x6.4e815e5c604ec948p-4L, -0x6.4e815e5c604ec94p-4L },
    { 0x9.a94b7284791aef1p-88L, 0x6.b25b7556a0da05f8p-88L, 0x6.b25b7556a0da06p-88L },
    { -0x7.986b2cd7ddf22268p-132L, -0x5.43c4afc7229c434p-132L, -0x5.43c4afc7229c4338p-132L },
    { 0x1.15035f9ba3aac31ep-4L, 0xc.49523582a5e80c3p-8L, 0xc.49523582a5e80c4p-8L },
    { -0xc.6f90a760827aa89p-4L, -0x6.aa0dc49e51cdac1p-4L, -0x6.aa0dc49e51cdac08p-4L },
    { 0xf.fef4a753b10a076p-4L, 0xf.fe8d6976d07d14bp-4L, 0xf.fe8d6976d07d14cp-4L },
    { -0x6.4c2eb46758106918p-4L, -0x3.d202750df16f62a4p-4L, -0x3.d202750df16f62ap-4L },
    { 0x1.3ef509e0c382df66p-4L, 0xe.328e01d44f681dp-8L, 0xe.328e01d44f681d1p-8L },
    { -0xc.49b63ac9b2b9eaap-4L, -0x6.9ab1ff6082b3beap-4L, -0x6.9ab1ff6082b3be98p-4L },
    { 0x6.d057f880739cc278p-4L, 0x5.7e79c56f2d15b708p-4L, 0x5.7e79c56f2d15b71p-4L },
    { -0xb.1981c21be406601p-4L, -0x6.1ba12bbd58b2c01p-4L, -0x6.1ba12bbd58b2c008p-4L },
    { 0x8.0a6f57c957a28d4p-4L, 0x6.aadb51c6015dbep-4L, 0x6.aadb51c6015dbe08p-4L },
    { -0x5.f3f181c210c8a89p-4L, -0x3.a319fd0750dac56p-4L, -0x3.a319fd0750dac55cp-4L },
    { 0xe.2859c8a2c48c40ap-4L, 0xd.8b91686f98b11bdp-4L, 0xd.8b91686f98b11bep-4L },
    { -0xa.dd44c44ce7a5755p-4L, -0x6.01aed71b7ef78488p-4L, -0x6.01aed71b7ef7848p-4L },
    { 0xb.51ba4b350a61c32p-4L, 0xa.206f7762d17482bp-4L, 0xa.206f7762d17482cp-4L },
    { -0xc.0dfbf7e5e3212ffp-12L, -0x8.58dc6a67dabce9bp-12L, -0x8.58dc6a67dabce9ap-12L },
    { 0x7.6c639e488208ccc8p-4L, 0x6.11b6da6b26aebcd8p-4L, 0x6.11b6da6b26aebcep-4L },
    { -0x3.a1d6c7b434bf3d98p-4L, -0x2.545d932e669d3904p-4L, -0x2.545d932e669d39p-4L },
    { 0x5.c358113ef832c348p-4L, 0x4.899c27db749b1de8p-4L, 0x4.899c27db749b1dfp-4L },
    { -0xb.d7d98c530f97875p-4L, -0x6.6be6509d664dfbbp-4L, -0x6.6be6509d664dfba8p-4L },
    { 0x4.fa42d3ac3bebd7e8p-4L, 0x3.d9b642da220bca6p-4L, 0x3.d9b642da220bca64p-4L },
    { -0xa.5b3f67eed42f35ep-4L, -0x5.c8c4d54ed02eeb08p-4L, -0x5.c8c4d54ed02eebp-4L },
    { 0x8.df34d29839f6cbap-140L, 0x6.2647bfc5682b23d8p-140L, 0x6.2647bfc5682b23ep-140L },
    { -0x4.37cad4bbf2a5aa78p-108L, -0x2.ec747a81313e72acp-108L, -0x2.ec747a81313e72a8p-108L },
    { 0x1.d6566fbbd43703bcp-4L, 0x1.5356ad8698dd1454p-4L, 0x1.5356ad8698dd1456p-4L },
    { -0x5.7c58e6c483f58898p-4L, -0x3.6265408f3b9628d4p-4L, -0x3.6265408f3b9628dp-4L },
    { 0x4.6a4204ea8eeaab98p-4L, 0x3.5f5f5a4b33974f1p-4L, 0x3.5f5f5a4b33974f14p-4L },
    { -0x8.3dccba3b25f76c1p-4L, -0x4.cdd2979cf80fe2a8p-4L, -0x4.cdd2979cf80fe2ap-4L },
    { 0xd.5f0d592ded19983p-4L, 0xc.8e415fdd3807e8fp-4L, 0xc.8e415fdd3807e9p-4L },
    { -0xa.c3b832d5003b707p-8L, -0x7.5a8d2a98b9c25298p-8L, -0x7.5a8d2a98b9c2529p-8L },
    { 0xa.1061f8f22c56a2p-4L, 0x8.be6ebf67d3a8ca6p-4L, 0x8.be6ebf67d3a8ca7p-4L },
    { -0x7.a0e695df486975a8p-4L, -0x4.80b3df37bd2da46p-4L, -0x4.80b3df37bd2da458p-4L },
    { 0x2.0f49c0d924c5ef48p-4L, 0x1.7e4a674b14e39638p-4L, 0x1.7e4a674b14e3963ap-4L },
    { -0x2.98c242e38ab361a4p-4L, -0x1.b3cdb6359889897cp-4L, -0x1.b3cdb6359889897ap-4L },
    { 0xe.a88d8d085eb83b1p-4L, 0xe.3173fc65ba950ccp-4L, 0xe.3173fc65ba950cdp-4L },
    { -0x7.18f85d323644c07p-4L, -0x4.3c36aae8265e794p-4L, -0x4.3c36aae8265e7938p-4L },
    { 0xb.e3d76e1e4bf5645p-8L, 0x8.6028af6e8498d12p-8L, 0x8.6028af6e8498d13p-8L },
    { -0xa.e3f91773dee5cbdp-4L, -0x6.0495789dfe04b06p-4L, -0x6.0495789dfe04b058p-4L },
    { 0x6.64a485a65ba2bb8p-4L, 0x5.1b18ec86f4768a78p-4L, 0x5.1b18ec86f4768a8p-4L },
    { -0xb.ab5d793764e46aap-4L, -0x6.595eea36719ee3p-4L, -0x6.595eea36719ee2f8p-4L },
    { 0x4.180ed04588b6b84p-4L, 0x3.1add121478e2fe34p-4L, 0x3.1add121478e2fe38p-4L },
    { -0x3.1b46b393f7f02654p-4L, -0x2.03c27049f1c5241p-4L, -0x2.03c27049f1c5240cp-4L },
    { 0xb.12b6b696713dd3p-4L, 0x9.d97de4a57a62c6ep-4L, 0x9.d97de4a57a62c6fp-4L },
    { -0x4.65ce2cb3797b29a8p-12L, -0x3.0c0efb555fa20864p-12L, -0x3.0c0efb555fa2086p-12L },
    { 0x2.8d217b257289e3ccp-48L, 0x1.c4b73c33ff87c0a6p-48L, 0x1.c4b73c33ff87c0a8p-48L },
    { -0x6.2775ae1abb4f1b8p-132L, -0x4.44068348b3cc65f8p-132L, -0x4.44068348b3cc65fp-132L },
    { 0x7.9916813ff5ff3cc8p-4L, 0x6.3c9c97e7b3dc5dcp-4L, 0x6.3c9c97e7b3dc5dc8p-4L },
    { -0xe.8cc5489d5bd410dp-4L, -0x7.7b36e89d757a4abp-4L, -0x7.7b36e89d757a4aa8p-4L },
    { 0x4.332914d9e18063ap-4L, 0x3.3158c643f12f4994p-4L, 0x3.3158c643f12f4998p-4L },
    { -0xb.0de0f587f5c107fp-4L, -0x6.16a43bbcf353ca98p-4L, -0x6.16a43bbcf353ca9p-4L },
    { 0x7.8ea9558f03ae0e7p-4L, 0x6.32938e784969b998p-4L, 0x6.32938e784969b9ap-4L },
    { -0xf.dee9088b413455fp-4L, -0x7.f47ff39c1d7b3888p-4L, -0x7.f47ff39c1d7b388p-4L },
    { 0x8.2df8e53739c9b8bp-4L, 0x6.cddbf2a3d58ac5cp-4L, 0x6.cddbf2a3d58ac5c8p-4L },
    { -0xb.237c6168dab68dbp-4L, -0x6.1fe702218f1a48a8p-4L, -0x6.1fe702218f1a48ap-4L },
    { 0xc.ff8006e798ca57dp-4L, 0xc.190015c68329532p-4L, 0xc.190015c68329533p-4L },
    { -0x5.a01080821eed49f8p-4L, -0x3.75db7123ab84cf58p-4L, -0x3.75db7123ab84cf54p-4L },
    { 0x7.837abefd5e55df78p-4L, 0x6.27d5641a6c02fc68p-4L, 0x6.27d5641a6c02fc7p-4L },
    { -0x3.5060ef99941b0558p-4L, -0x2.23c9d923cd4adb98p-4L, -0x2.23c9d923cd4adb94p-4L },
    { 0xe.81ed35e6e8294cep-4L, 0xd.ff1805c791d6424p-4L, 0xd.ff1805c791d6425p-4L },
    { -0x4.bb21255de4a41a5p-4L, -0x2.f70cf4785702e974p-4L, -0x2.f70cf4785702e97p-4L },
    { 0x2.a7771004562ceed4p-4L, 0x1.f31d427f09d18b7cp-4L, 0x1.f31d427f09d18b7ep-4L },
    { -0x1.6959757c92243a3ap-4L, -0xf.2f6ce0c9b166b49p-8L, -0xf.2f6ce0c9b166b48p-8L },
    { 0x6.bbde2a7543c30b38p-4L, 0x5.6b71442a60dd2568p-4L, 0x5.6b71442a60dd257p-4L },
    { -0xb.8edecd5dd38da0cp-4L, -0x6.4d6db28b17aa8588p-4L, -0x6.4d6db28b17aa858p-4L },
    { 0x6.c15f52803f443968p-4L, 0x5.708d7c1ba353e398p-4L, 0x5.708d7c1ba353e3ap-4L },
    { -0x3.918ec1969b0edd88p-4L, -0x2.4ab5c149bf41c4c4p-4L, -0x2.4ab5c149bf41c4cp-4L },
    { 0x7.7b238d3b9d8115e8p-120L, 0x5.2f791dc93f08299p-120L, 0x5.2f791dc93f082998p-120L },
    { -0x1.9f3582a69a86e648p-60L, -0x1.1fcd0c091eb14d28p-60L, -0x1.1fcd0c091eb14d26p-60L },
    { 0x6.81487cec2e861c7p-8L, 0x4.8c82f180777d68f8p-8L, 0x4.8c82f180777d69p-8L },
    { -0x4.87a7a304beeda28p-4L, -0x2.d9db282588789b7cp-4L, -0x2.d9db282588789b78p-4L },
    { 0xd.c7238c1ad3cafc9p-4L, 0xd.1028e60f36ff2b1p-4L, 0xd.1028e60f36ff2b2p-4L },
    { -0xe.ac1774f7032d1ffp-4L, -0x7.86be2433cc1d9da8p-4L, -0x7.86be2433cc1d9dap-4L },
    { 0x8.fc6153c653d77c7p-4L, 0x7.9d6025bd14094ad8p-4L, 0x7.9d6025bd14094aep-4L },
    { -0x1.014e18840001d972p-4L, -0xa.e85ead1a4e78382p-8L, -0xa.e85ead1a4e78381p-8L },
    { 0x5.040eb8c257682f18p-4L, 0x3.e224b9c7d7c0f06cp-4L, 0x3.e224b9c7d7c0f07p-4L },
    { -0xf.7346ad82e18af85p-4L, -0x7.cea4b926fe7c2368p-4L, -0x7.cea4b926fe7c236p-4L },
    { 0x3.c7346df124e8ef98p-4L, 0x2.d8668c024b6308e8p-4L, 0x2.d8668c024b6308ecp-4L },
    { -0xc.f461f50edbbb96fp-4L, -0x6.df2bda27bd06182p-4L, -0x6.df2bda27bd061818p-4L },
    { 0xd.c278b0558bd0b11p-4L, 0xd.0a4916e65159357p-4L, 0xd.0a4916e65159358p-4L },
    { -0x4.b2842fc0d4e29f8p-4L, -0x2.f22eea0353ff92dp-4L, -0x2.f22eea0353ff92ccp-4L },
    { 0xf.a09a22b402060edp-4L, 0xf.7ccfec40ad06d7ep-4L, 0xf.7ccfec40ad06d7fp-4L },
    { -0x8.e32395dc002f9bfp-8L, -0x6.162efd7ddd7ad93p-8L, -0x6.162efd7ddd7ad928p-8L },
    { 0xf.8c0db00bdf53596p-4L, 0xf.60d4a396fb9dadcp-4L, 0xf.60d4a396fb9daddp-4L },
    { -0x5.36e056abcab2faa8p-4L, -0x3.3c3413c718ca2bf4p-4L, -0x3.3c3413c718ca2bfp-4L },
    { 0x7.6c92e56712d5affp-4L, 0x6.11e40e1716fd4fb8p-4L, 0x6.11e40e1716fd4fcp-4L },
    { -0xd.6cb0532deaf2679p-4L, -0x7.0e43f2e8f0654b5p-4L, -0x7.0e43f2e8f0654b48p-4L },
    { 0x1.864d5d5420279f0cp-4L, 0x1.17abd4dea55c6812p-4L, 0x1.17abd4dea55c6814p-4L },
    { -0xa.e4299f2f9dca735p-4L, -0x6.04aa7510ef638d5p-4L, -0x6.04aa7510ef638d48p-4L },
    { 0xe.d132e5394f60034p-128L, 0xa.453ebc4a42e6cb8p-128L, 0xa.453ebc4a42e6cb9p-128L },
    { -0x2.35600cb5057b0fe8p-100L, -0x1.87e3627dc194acb4p-100L, -0x1.87e3627dc194acb2p-100L },
    { 0x9.ea2a7bd17c460dep-4L, 0x8.95993518360a117p-4L, 0x8.95993518360a118p-4L },
    { -0xe.c5d9227ffaac8cfp-4L, -0x7.902d5e9f35d6cfa8p-4L, -0x7.902d5e9f35d6cfap-4L },
    { 0x7.e3d1eea20b324e7p-4L, 0x6.850f961c58bba1cp-4L, 0x6.850f961c58bba1c8p-4L },
    { -0x9.86088a50194e78ap-4L, -0x5.68af5d2483728da8p-4L, -0x5.68af5d2483728dap-4L },
    { 0xf.7fa93e24f531607p-4L, 0xf.5000aaa67e5abb3p-4L, 0xf.5000aaa67e5abb4p-4L },
    { -0x6.3df2b4ad8ed98938p-4L, -0x3.ca7d689c3a04ee1cp-4L, -0x3.ca7d689c3a04ee18p-4L },
    { 0xe.e19314560029718p-4L, 0xe.7c6642b7e0cbddap-4L, 0xe.7c6642b7e0cbddbp-4L },
    { -0xa.e3c3bdecf1dec26p-8L, -0x7.701f272b4e954b3p-8L, -0x7.701f272b4e954b28p-8L },
    { 0x7.13c978b522f9333p-4L, 0x5.bda2c8c3fcf67318p-4L, 0x5.bda2c8c3fcf6732p-4L },
    { -0xd.81aab9ad9044dbbp-4L, -0x7.16613057101cc2e8p-4L, -0x7.16613057101cc2ep-4L },
    { 0x1.1d1ed153b343c44ep-4L, 0xc.a79cde97e744a1p-8L, 0xc.a79cde97e744a11p-8L },
    { -0x7.6fdb8f997549cde8p-8L, -0x5.1a74b0bff8212ac8p-8L, -0x5.1a74b0bff8212acp-8L },
    { 0x9.e81deac115960bcp-4L, 0x8.936a9f1de1dc2c9p-4L, 0x8.936a9f1de1dc2cap-4L },
    { -0xf.6e420d340620fd3p-4L, -0x7.ccdc951843f633f8p-4L, -0x7.ccdc951843f633fp-4L },
    { 0xe.6c4b7e894887c7fp-4L, 0xd.e308edc7c69afe9p-4L, 0xd.e308edc7c69afeap-4L },
    { -0xa.a620eccc4c7480bp-4L, -0x5.e9b3097aa5fb3aep-4L, -0x5.e9b3097aa5fb3ad8p-4L },
    { 0x1.c456c45ad9be2a9p-4L, 0x1.45d98d5ceaac11ecp-4L, 0x1.45d98d5ceaac11eep-4L },
    { -0x3.af9571884b9dea6cp-4L, -0x2.5c7f00327abdcc8cp-4L, -0x2.5c7f00327abdcc88p-4L },
    { 0xb.a0a2f3e13b85a66p-4L, 0xa.7a58fb959132f5p-4L, 0xa.7a58fb959132f51p-4L },
    { -0x1.574d5a4e81cea558p-4L, -0xe.72dbed0cf3f04efp-8L, -0xe.72dbed0cf3f04eep-8L },
    { 0x2.4592a2ef43290dcp-184L, 0x1.931d946725be0bacp-184L, 0x1.931d946725be0baep-184L },
    { -0x2.1340349dc88fe5ap-148L, -0x1.703c28b59101b778p-148L, -0x1.703c28b59101b776p-148L },
    { 0xc.52069130f81cabfp-8L, 0x8.af13d4a97a211afp-8L, 0x8.af13d4a97a211bp-8L },
    { -0x4.20c946d47a37871p-4L, -0x2.9ebecd164da3800cp-4L, -0x2.9ebecd164da38008p-4L },
    { 0xc.ad96dfac7b95172p-4L, 0xb.b5fbb7908197649p-4L, 0xb.b5fbb790819764ap-4L },
    { -0x1.1fc7d37c0ec92196p-4L, -0xc.2b1ec45e46b2f21p-8L, -0xc.2b1ec45e46b2f2p-8L },
    { 0xd.0d8c22a9e6d3c5p-4L, 0xc.2a1e9cdc9f50a83p-4L, 0xc.2a1e9cdc9f50a84p-4L },
    { -0x8.c7054bd7b8a06d5p-4L, -0x5.0f9cb256bb7dc48p-4L, -0x5.0f9cb256bb7dc478p-4L },
    { 0x5.13c1489191b10628p-4L, 0x3.efaed7947e426ea4p-4L, 0x3.efaed7947e426ea8p-4L },
    { -0x9.40268306f3eaf37p-4L, -0x5.486e4611a98deb68p-4L, -0x5.486e4611a98deb6p-4L },
    { 0x4.8b3a84ec2d62ab1p-4L, 0x3.7b1edaf9b2695bacp-4L, 0x3.7b1edaf9b2695bbp-4L },
    { -0x2.971ee88e20aca63cp-4L, -0x1.b2c9edea76d921ap-4L, -0x1.b2c9edea76d9219ep-4L },
    { 0x3.f7343ff72e27615cp-4L, 0x2.ffbf501a1f86d97cp-4L, 0x2.ffbf501a1f86d98p-4L },
    { -0xc.f38290b95d0f886p-4L, -0x6.ded38151017c9f78p-4L, -0x6.ded38151017c9f7p-4L },
    { 0x6.19ec462854667938p-4L, 0x4.d73549a9496846e8p-4L, 0x4.d73549a9496846fp-4L },
    { -0xe.a753d50ad228a17p-4L, -0x7.84fe3ea5ac9675c8p-4L, -0x7.84fe3ea5ac9675cp-4L },
    { 0xb.2326e5c709d8338p-4L, 0x9.ebecfa9a7ed2102p-4L, 0x9.ebecfa9a7ed2103p-4L },
    { -0xe.4cbeeba038e2a66p-4L, -0x7.63754094094d3058p-4L, -0x7.63754094094d305p-4L },
    { 0x9.90137db5d8438f6p-4L, 0x8.36609082c07d8ebp-4L, 0x8.36609082c07d8ecp-4L },
    { -0x8.f6fc2825e1cf803p-4L, -0x5.26400e89ac84512p-4L, -0x5.26400e89ac845118p-4L },
    { 0xb.a6e18f1dc982de2p-4L, 0xa.8183a9b9420a005p-4L, 0xa.8183a9b9420a006p-4L },
    { -0x7.093038cd340d2eap-4L, -0x4.3428c5f7bc4908e8p-4L, -0x4.3428c5f7bc4908ep-4L },
    { 0x1.7d48f31379a2fd94p-16L, 0x1.0849e6ab4023994ep-16L, 0x1.0849e6ab4023995p-16L },
    { -0xe.811989909a6ff03p-172L, -0xa.0db9811ffb53051p-172L, -0xa.0db9811ffb5305p-172L },
    { 0xf.a038fe23264b69fp-4L, 0xf.7c4b6a476a8be7cp-4L, 0xf.7c4b6a476a8be7dp-4L },
    { -0x5.d983ceba22bba45p-4L, -0x3.94ea4ac9f11d384cp-4L, -0x3.94ea4ac9f11d3848p-4L },
    { 0x3.aaf0ce3e734d6f2p-4L, 0x2.c161688c554ee7fcp-4L, 0x2.c161688c554ee8p-4L },
    { -0xf.72f358999238d68p-4L, -0x7.ce872556e868c9d8p-4L, -0x7.ce872556e868c9dp-4L },
    { 0x6.4d100f244be8113p-4L, 0x5.059488ceb9e3a5p-4L, 0x5.059488ceb9e3a508p-4L },
    { -0x8.8a2584d61c785a5p-4L, -0x4.f29d6d10179eb218p-4L, -0x4.f29d6d10179eb21p-4L },
    { 0xd.c98d7189a0303bfp-4L, 0xd.133307457e07c72p-4L, 0xd.133307457e07c73p-4L },
    { -0x1.4471ec132a54d16ap-4L, -0xd.ad37019fa9d9a9p-8L, -0xd.ad37019fa9d9a8fp-8L },
    { 0xb.bac11f4e1e14036p-4L, 0xa.985f73784b37eb5p-4L, 0xa.985f73784b37eb6p-4L },
    { -0x5.f466fe6cbdda3498p-4L, -0x3.a358e8e63a5fba64p-4L, -0x3.a358e8e63a5fba6p-4L },
    { 0xb.650503cc7e3186cp-4L, 0xa.364e81e99eb81f3p-4L, 0xa.364e81e99eb81f4p-4L },
    { -0x1.5d03274c615fac7ep-4L, -0xe.ae956d0835aaf87p-8L, -0xe.ae956d0835aaf86p-8L },
    { 0xf.e3a0ddc922c2768p-4L, 0xf.d8c34a986f967d3p-4L, 0xf.d8c34a986f967d4p-4L },
    { -0xa.669f21ff1f04159p-4L, -0x5.cdcc37c6f732fe1p-4L, -0x5.cdcc37c6f732fe08p-4L },
    { 0x8.ab617e168652f41p-4L, 0x7.4b137892a0c69d88p-4L, 0x7.4b137892a0c69d9p-4L },
    { -0xa.9ceb33ff19c471bp-4L, -0x5.e5abee4fb863c6ep-4L, -0x5.e5abee4fb863c6d8p-4L },
    { 0x7.e712d33d338b3f4p-4L, 0x6.883c6044c3c2bcb8p-4L, 0x6.883c6044c3c2bccp-4L },
    { -0x6.ed724b0ecd1acf48p-4L, -0x4.25f2ea71fb90ba5p-4L, -0x4.25f2ea71fb90ba48p-4L },
    { 0xb.0f353c55a1bc86bp-4L, 0x9.d59127340917f95p-4L, 0x9.d59127340917f96p-4L },
    { -0xa.9ea90fbdcd33289p-4L, -0x5.e66f0ac4d504378p-4L, -0x5.e66f0ac4d5043778p-4L },
    { 0x1.8d57c92ab74b5dbp-36L, 0x1.136ac861af6fd0cep-36L, 0x1.136ac861af6fd0dp-36L },
    { -0x5.db625c7f505b3848p-168L, -0x4.0f4b402286520448p-168L, -0x4.0f4b40228652044p-168L },
    { 0x2.b76e057b32691f28p-4L, 0x1.ff8b9dda8f045aep-4L, 0x1.ff8b9dda8f045ae2p-4L },
    { -0x6.dee852c47ad7ae6p-4L, -0x4.1e798f7b43706028p-4L, -0x4.1e798f7b4370602p-4L },
    { 0x6.bb1bf54be9664e8p-4L, 0x5.6abd10b33410d838p-4L, 0x5.6abd10b33410d84p-4L },
    { -0x6.aee79d84df01a37p-4L, -0x4.05aac336cc0ddf4p-4L, -0x4.05aac336cc0ddf38p-4L },
    { 0xf.db239caa0c58725p-4L, 0xf.cd0f1aa065d9edcp-4L, 0xf.cd0f1aa065d9eddp-4L },
    { -0x6.a15fc994e42a5f98p-4L, -0x3.fea35173a1f28d58p-4L, -0x3.fea35173a1f28d54p-4L },
    { 0xe.d6bf659b8abbf88p-4L, 0xe.6e1d0b3dcc929a2p-4L, 0xe.6e1d0b3dcc929a3p-4L },
    { -0x6.3520edf48c502b48p-4L, -0x3.c5d25806006121bcp-4L, -0x3.c5d25806006121b8p-4L },
    { 0x2.845d2338bd21f05cp-4L, 0x1.d7e66d41d318c988p-4L, 0x1.d7e66d41d318c98ap-4L },
    { -0x1.d3130e0c084f14c8p-4L, -0x1.37497e3ebaa67dcap-4L, -0x1.37497e3ebaa67dc8p-4L },
    { 0x7.e34ef80c4f7e3eep-4L, 0x6.848fd32b674801d8p-4L, 0x6.848fd32b674801ep-4L },
    { -0x5.a8b3cf39973ba25p-4L, -0x3.7a8bd473e711806cp-4L, -0x3.7a8bd473e7118068p-4L },
    { 0xa.b5fcccca163aaedp-4L, 0x9.727686834a4ee16p-4L, 0x9.727686834a4ee17p-4L },
    { -0x9.80fe0cfc3618055p-4L, -0x5.665f01272fca1dfp-4L, -0x5.665f01272fca1de8p-4L },
    { 0x1.deff9f28444c6c38p-4L, 0x1.59d80e0bc88e7a36p-4L, 0x1.59d80e0bc88e7a38p-4L },
    { -0x9.1da1f7cda29486bp-4L, -0x5.385b9fa450441c1p-4L, -0x5.385b9fa450441c08p-4L },
    { 0x9.24964216848ef53p-4L, 0x7.c6a60a15ee989f5p-4L, 0x7.c6a60a15ee989f58p-4L },
    { -0x7.c3b5a7c39208799p-4L, -0x4.91fd41abd0551208p-4L, -0x4.91fd41abd05512p-4L },
    { 0xc.7f839e0758c0fc4p-4L, 0xb.7ee2c8991a66c5bp-4L, 0xb.7ee2c8991a66c5cp-4L },
    { -0xa.04266867c71fecep-4L, -0x5.a1efea5e48c556e8p-4L, -0x5.a1efea5e48c556ep-4L },
    { 0x3.1aa2b36a1fb87f7cp-48L, 0x2.26cca4e6218f7cc8p-48L, 0x2.26cca4e6218f7cccp-48L },
    { -0x1.ba95b94050477ba6p-152L, -0x1.32c6c531dafa9e4p-152L, -0x1.32c6c531dafa9e3ep-152L },
    { 0x6.108af52b9d9b2bp-4L, 0x4.cebef902a16e9c8p-4L, 0x4.cebef902a16e9c88p-4L },
    { -0x3.072eed70b90d2ae8p-4L, -0x1.f790b03dd687e68cp-4L, -0x1.f790b03dd687e68ap-4L },
    { 0xb.ad44f9f8ad944a6p-4L, 0xa.88da98fd452a1b5p-4L, 0xa.88da98fd452a1b6p-4L },
    { -0xb.3fef5d7e57e0805p-4L, -0x6.2c0b5071c8e72768p-4L, -0x6.2c0b5071c8e7276p-4L },
    { 0xe.b53f2b3083d023ep-4L, 0xe.42131e5b55a520bp-4L, 0xe.42131e5b55a520cp-4L },
    { -0xb.f408f69524f06c2p-4L, -0x6.779147008107f7cp-4L, -0x6.779147008107f7b8p-4L },
    { 0x8.03baca4a7357516p-4L, 0x6.a446a2fcb76d806p-4L, 0x6.a446a2fcb76d8068p-4L },
    { -0xa.c1abbb69e26abf7p-4L, -0x5.f5b5017c8517f208p-4L, -0x5.f5b5017c8517f2p-4L },
    { 0x1.d872e7eedaaa637ep-4L, 0x1.54ec695ac1dbc924p-4L, 0x1.54ec695ac1dbc926p-4L },
    { -0x4.495ee30da4659e98p-4L, -0x2.b6306706e0bbaac4p-4L, -0x2.b6306706e0bbaacp-4L },
    { 0xc.150a73ee88aac4bp-4L, 0xb.0131f0d15ff1b5p-4L, 0xb.0131f0d15ff1b51p-4L },
    { -0xa.3e82e32d6766963p-4L, -0x5.bc052d79040a9f88p-4L, -0x5.bc052d79040a9f8p-4L },
    { 0x6.08720c311ad69e78p-4L, 0x4.c773b03aa96a3fc8p-4L, 0x4.c773b03aa96a3fdp-4L },
    { -0x7.3b6b4ffd7b8decp-8L, -0x4.f6d2acdaf77fd21p-8L, -0x4.f6d2acdaf77fd208p-8L },
    { 0x5.80db9fe644d1e708p-4L, 0x4.4ec994b6102856dp-4L, 0x4.4ec994b6102856d8p-4L },
    { -0x1.f640e13ffc2a24cap-4L, -0x1.4dc050898710d058p-4L, -0x1.4dc050898710d056p-4L },
    { 0xb.656227303abf84fp-4L, 0xa.36b8463547f4c73p-4L, 0xa.36b8463547f4c74p-4L },
    { -0x7.b40be4642e982ab8p-4L, -0x4.8a392adbf99bf968p-4L, -0x4.8a392adbf99bf96p-4L },
    { 0x2.8126daf9591a4a78p-4L, 0x1.d56af8b597dab07ep-4L, 0x1.d56af8b597dab08p-4L },
    { -0xf.8481196507714a9p-4L, -0x7.d4bfd1129eebe82p-4L, -0x7.d4bfd1129eebe818p-4L },
    { 0x2.1a154d27c4610f5cp-92L, 0x1.74f88a35a7f80dcep-92L, 0x1.74f88a35a7f80ddp-92L },
    { -0x5.585153da63583088p-12L, -0x3.b40448ded8eb7678p-12L, -0x3.b40448ded8eb7674p-12L },
    { 0x8.4b1f02dac6cd4b9p-4L, 0x6.eaba168a48b0171p-4L, 0x6.eaba168a48b01718p-4L },
    { -0xc.759d3a3d2bb277bp-4L, -0x6.ac7fc087257bf838p-4L, -0x6.ac7fc087257bf83p-4L },
    { 0x9.5efce40ef5c193p-4L, 0x8.0319c4d499a7ca3p-4L, 0x8.0319c4d499a7ca4p-4L },
    { -0x1.3acdec63c75ba85ap-4L, -0xd.47ed2768ca5ede8p-8L, -0xd.47ed2768ca5ede7p-8L },
    { 0x3.a8862397aa33d5bcp-4L, 0x2.bf6ad5c108758048p-4L, 0x2.bf6ad5c10875804cp-4L },
    { -0x8.40b99f3260074bbp-4L, -0x4.cf3dbd131e8a17ap-4L, -0x4.cf3dbd131e8a1798p-4L },
    { 0x1.13ba9d07bc3a2952p-4L, 0xc.3a6591e048e18fep-8L, 0xc.3a6591e048e18ffp-8L },
    { -0x2.71006a8cb34d554cp-4L, -0x1.9b18519a46103f02p-4L, -0x1.9b18519a46103fp-4L },
    { 0x9.1553f4826cd4c82p-4L, 0x7.b6f3ad6001421a68p-4L, 0x7.b6f3ad6001421a7p-4L },
    { -0x5.67cce3baa54af0cp-4L, -0x3.57257d17a151238cp-4L, -0x3.57257d17a1512388p-4L },
    { 0x3.8114a9e190ab791p-4L, 0x2.9f7d24d05db91814p-4L, 0x2.9f7d24d05db91818p-4L },
    { -0x4.9c18fd283d9a589p-4L, -0x2.e57b1e06ca7a4c84p-4L, -0x2.e57b1e06ca7a4c8p-4L },
    { 0xc.05b3f7d8b6f7624p-4L, 0xa.ef465963b3e1fc3p-4L, 0xa.ef465963b3e1fc4p-4L },
    { -0xc.aa597d6d2ed91e3p-4L, -0x6.c1b5f0a62eb977fp-4L, -0x6.c1b5f0a62eb977e8p-4L },
    { 0x5.7aa677b8b3a14efp-4L, 0x4.49543a3a46f57d38p-4L, 0x4.49543a3a46f57d4p-4L },
    { -0x6.8d1b5b54f8172e1p-4L, -0x3.f4143adbee4eb904p-4L, -0x3.f4143adbee4eb9p-4L },
    { 0x4.a8455a7e3a68ed78p-4L, 0x3.93b0e898b77bf4c8p-4L, 0x3.93b0e898b77bf4ccp-4L },
    { -0x8.f684ab518e13e14p-4L, -0x5.2607e33540e678cp-4L, -0x5.2607e33540e678b8p-4L },
    { 0xf.331d018a51a3937p-4L, 0xe.e8d595bf6b18a9ap-4L, 0xe.e8d595bf6b18a9bp-4L },
    { -0x3.eca2bd0c8570369p-4L, -0x2.80620c0582a7ae94p-4L, -0x2.80620c0582a7ae9p-4L },
    { 0xc.a5327c102d01348p-80L, 0x8.c3daa757b84ad52p-80L, 0x8.c3daa757b84ad53p-80L },
    { -0x2.a3c7cec074186df4p-180L, -0x1.d46a5432452e2c9p-180L, -0x1.d46a5432452e2c8ep-180L },
    { 0x2.293460674db2c4p-4L, 0x1.91f96e67e72e8cc2p-4L, 0x1.91f96e67e72e8cc4p-4L },
    { -0xd.ea0bd2fdf3193cep-4L, -0x7.3e53d5de8fa95728p-4L, -0x7.3e53d5de8fa9572p-4L },
    { 0x7.7cc8ad228793eeep-4L, 0x6.2169209a50da8dfp-4L, 0x6.2169209a50da8df8p-4L },
    { -0x3.3eb74cb49c028ad4p-4L, -0x2.192ac814bd5f0c5cp-4L, -0x2.192ac814bd5f0c58p-4L },
    { 0xe.bc5331958998244p-4L, 0xe.4b5bcd8b0908ccfp-4L, 0xe.4b5bcd8b0908cdp-4L },
    { -0x1.2903edbad4d00bdep-4L, -0xc.8c97befaf20c969p-8L, -0xc.8c97befaf20c968p-8L },
    { 0x5.3ee964d9303fef2p-4L, 0x4.1517b8de179c1dap-4L, 0x4.1517b8de179c1da8p-4L },
    { -0x9.0a14cf75dc8c935p-8L, -0x6.30877227885a5f9p-8L, -0x6.30877227885a5f88p-8L },
    { 0x6.e59cd2b304be20bp-8L, 0x4.d353ed698d0eff18p-8L, 0x4.d353ed698d0eff2p-8L },
    { -0xd.25ced593ff0ac61p-4L, -0x6.f2a2932d1abac2d8p-4L, -0x6.f2a2932d1abac2dp-4L },
    { 0x3.1617c019abd659bp-4L, 0x2.49f324ab933e42d8p-4L, 0x2.49f324ab933e42dcp-4L },
    { -0x6.690f39e52d0c90c8p-4L, -0x3.e1358e26e4c35228p-4L, -0x3.e1358e26e4c35224p-4L },
    { 0x9.1050fe64665d025p-4L, 0x7.b1ce2c811fa492bp-4L, 0x7.b1ce2c811fa492b8p-4L },
    { -0x7.f6184dd3447fc3fp-4L, -0x4.aad4f07652aeae78p-4L, -0x4.aad4f07652aeae7p-4L },
    { 0xd.953628a90529c68p-4L, 0xc.d1901b07c97032cp-4L, 0xc.d1901b07c97032dp-4L },
    { -0x7.43be3e30b7e5c7a8p-4L, -0x4.51ef59e61758d838p-4L, -0x4.51ef59e61758d83p-4L },
    { 0x7.a4dabfc6c9e825b8p-4L, 0x6.47f5486a01b237ap-4L, 0x6.47f5486a01b237a8p-4L },
    { -0xb.f01119533e278e8p-4L, -0x6.75ed9a05142d0eap-4L, -0x6.75ed9a05142d0e98p-4L },
    { 0x1.6396f574b56c6172p-4L, 0xf.e0af65687e4b67ep-8L, 0xf.e0af65687e4b67fp-8L },
    { -0xf.b5e4a3223e61c14p-4L, -0x7.e627a04f577a3258p-4L, -0x7.e627a04f577a325p-4L },
    { 0xd.0f395b84573f61dp-192L, 0x9.0d58a8d3ccd5356p-192L, 0x9.0d58a8d3ccd5357p-192L },
    { -0x1.cad34f8832df94b6p-188L, -0x1.3e08970bbbe4953cp-188L, -0x1.3e08970bbbe4953ap-188L },
    { 0xd.a82c5b229e8fe54p-4L, 0xc.e94629ca486873dp-4L, 0xc.e94629ca486873ep-4L },
    { -0xc.337e6ec5ca09cbfp-4L, -0x6.91a27c9fb5331f48p-4L, -0x6.91a27c9fb5331f4p-4L },
    { 0x5.999aa2e2c49c8778p-4L, 0x4.649a9990259a6b08p-4L, 0x4.649a9990259a6b1p-4L },
    { -0x7.b2a783da083648ep-8L, -0x5.47d116a619b453bp-8L, -0x5.47d116a619b453a8p-8L },
    { 0xe.68481349ea07669p-4L, 0xd.ddd72166e76368fp-4L, 0xd.ddd72166e76369p-4L },
    { -0x7.c2d56e73e1215768p-4L, -0x4.918e390065e28458p-4L, -0x4.918e390065e2845p-4L },
    { 0x7.cfb667a4a3914a3p-4L, 0x6.717a3878ea0e60d8p-4L, 0x6.717a3878ea0e60ep-4L },
    { -0x8.d974808af557b0ep-4L, -0x5.1855a0cd14dbe46p-4L, -0x5.1855a0cd14dbe458p-4L },
    { 0xb.439e5356c702ad8p-4L, 0xa.107c2031a79089ep-4L, 0xa.107c2031a79089fp-4L },
    { -0xe.188d98ec6dc463bp-4L, -0x7.4fe68a1b12545d8p-4L, -0x7.4fe68a1b12545d78p-4L },
    { 0xe.d87c88ea04cfc54p-4L, 0xe.7067f2e9706541cp-4L, 0xe.7067f2e9706541dp-4L },
    { -0x7.5df293fec0fa7908p-4L, -0x4.5f2a3838248134f8p-4L, -0x4.5f2a3838248134fp-4L },
    { 0xb.f31341da10838b7p-4L, 0xa.d992b6a99f3586cp-4L, 0xa.d992b6a99f3586dp-4L },
    { -0x4.94201f2127bae1d8p-4L, -0x2.e0f3cbf83592b45cp-4L, -0x2.e0f3cbf83592b458p-4L },
    { 0xf.466813a0cb58997p-4L, 0xf.02b6115e1e0a079p-4L, 0xf.02b6115e1e0a07ap-4L },
    { -0x1.b40206802faf31f8p-4L, -0x1.2356684fa89060dp-4L, -0x1.2356684fa89060cep-4L },
    { 0x5.cfe8b47a3d2bb528p-4L, 0x4.94cd1c5dccf7537p-4L, 0x4.94cd1c5dccf75378p-4L },
    { -0xd.f8e6092df0a67cdp-4L, -0x7.43f462a4ef5a1918p-4L, -0x7.43f462a4ef5a191p-4L },
    { 0xe.c5c2bbb0872eb38p-4L, 0xe.57c07f71f4fb432p-4L, 0xe.57c07f71f4fb433p-4L },
    { -0xe.4ffa3f0dccc1904p-4L, -0x7.64a9d0532f3787bp-4L, -0x7.64a9d0532f3787a8p-4L },
    { 0xd.f51b450c06fa53fp-8L, 0x9.dc151be4407a68ap-8L, 0x9.dc151be4407a68bp-8L },
    { -0x1.eb1cef301d81df08p-52L, -0x1.5469e23dccbca00ep-52L, -0x1.5469e23dccbca00cp-52L },
    { 0x8.5ae9b271c862bd1p-4L, 0x6.fa6d07dce385fccp-4L, 0x6.fa6d07dce385fcc8p-4L },
    { -0xa.8fdf30d83ecd512p-4L, -0x5.dff47c13aa88bb28p-4L, -0x5.dff47c13aa88bb2p-4L },
    { 0x1.e689240cdaba32p-4L, 0x1.5f8358e071a53472p-4L, 0x1.5f8358e071a53474p-4L },
    { -0x7.62f10575934711p-4L, -0x4.61adf89887b9a24p-4L, -0x4.61adf89887b9a238p-4L },
    { 0xf.65a3e9387da5a2fp-4L, 0xf.2cc85c945028fcap-4L, 0xf.2cc85c945028fcbp-4L },
    { -0xb.d4af71c255e18d6p-4L, -0x6.6a9610ee9e87a8cp-4L, -0x6.6a9610ee9e87a8b8p-4L },
    { 0x5.9a9d1446632f3aep-4L, 0x4.657ef16969a055cp-4L, 0x4.657ef16969a055c8p-4L },
    { -0x9.b4e978d15970db2p-4L, -0x5.7e1be34eafa75f3p-4L, -0x5.7e1be34eafa75f28p-4L },
    { 0x8.7aea261756d25f3p-4L, 0x7.1a5e60645036bcb8p-4L, 0x7.1a5e60645036bccp-4L },
    { -0xf.b5a3f9c32315f89p-4L, -0x7.e610eed3517ac508p-4L, -0x7.e610eed3517ac5p-4L },
    { 0xe.7abe135a43a13e6p-4L, 0xd.f5c385f4adc9adbp-4L, 0xd.f5c385f4adc9adcp-4L },
    { -0x7.31920eb4fe1bd628p-4L, -0x4.48b9bee7bd62fefp-4L, -0x4.48b9bee7bd62fee8p-4L },
    { 0x3.2bf2a0a669999b48p-4L, 0x2.5b4c32cabb20c8acp-4L, 0x2.5b4c32cabb20c8bp-4L },
    { -0xa.6bff2a4ca65e178p-4L, -0x5.d02bc0929aebb8c8p-4L, -0x5.d02bc0929aebb8cp-4L },
    { 0x9.8e13ef308c3a17bp-4L, 0x8.3448125bdeacbe9p-4L, 0x8.3448125bdeacbeap-4L },
    { -0x8.4ef4a64c01509a8p-4L, -0x4.d621b783f39f31a8p-4L, -0x4.d621b783f39f31ap-4L },
    { 0x3.765e093b8a1ce118p-4L, 0x2.96da7371ca2fa4f8p-4L, 0x2.96da7371ca2fa4fcp-4L },
    { -0x7.aadaa9cd4105412p-4L, -0x4.85a7f3b0c1e06018p-4L, -0x4.85a7f3b0c1e0601p-4L },
    { 0x1.a2bf59174aca4d52p-4L, 0x1.2cc8f455ff2cea6ap-4L, 0x1.2cc8f455ff2cea6cp-4L },
    { -0x5.8f5a8c1e06358d9p-4L, -0x3.6cc434f58f798508p-4L, -0x3.6cc434f58f798504p-4L },
    { 0x2.8d03b0fea7261144p-156L, 0x1.c4a296285d9fa774p-156L, 0x1.c4a296285d9fa776p-156L },
    { -0xb.4261fc576312e18p-204L, -0x7.cdea5cf7def284b8p-204L, -0x7.cdea5cf7def284bp-204L },
    { 0x4.6d7ef04080b676d8p-4L, 0x3.6217371c0fa676ep-4L, 0x3.6217371c0fa676e4p-4L },
    { -0xb.c0ae25e2a801fc9p-4L, -0x6.62443424ce0cc21p-4L, -0x6.62443424ce0cc208p-4L },
    { 0x9.33aadc610c07076p-4L, 0x7.d6339920da9a3778p-4L, 0x7.d6339920da9a378p-4L },
    { -0xb.62d8d178f4ea271p-4L, -0x6.3add5679a51923bp-4L, -0x6.3add5679a51923a8p-4L },
    { 0xb.de8017b99009994p-4L, 0xa.c1aeb0c257defb4p-4L, 0xa.c1aeb0c257defb5p-4L },
    { -0xc.d14f3f856910093p-4L, -0x6.d142a83bc366c57p-4L, -0x6.d142a83bc366c568p-4L },
    { 0x1.36027b0d8b10a26cp-4L, 0xd.c9e65e03a5bcddcp-8L, 0xd.c9e65e03a5bcdddp-8L },
    { -0xc.5d2d16de94144fcp-4L, -0x6.a29ae09167802018p-4L, -0x6.a29ae0916780201p-4L },
    { 0xd.79e031e02305347p-4L, 0xc.af83870de952b8fp-4L, 0xc.af83870de952b9p-4L },
    { -0xa.c010f18d71bc8c5p-4L, -0x5.f5024e3266fc5898p-4L, -0x5.f5024e3266fc589p-4L },
    { 0x1.9cd7b4a183ae1dcp-4L, 0x1.2864c8400d7852d2p-4L, 0x1.2864c8400d7852d4p-4L },
    { -0x1.720bafd1b399ec82p-4L, -0xf.8a14ed8ba218a08p-8L, -0xf.8a14ed8ba218a07p-8L },
    { 0x4.fac18c7be7e011e8p-4L, 0x3.da233da5c7f9843cp-4L, 0x3.da233da5c7f9844p-4L },
    { -0xe.e7cda687036f7d6p-8L, -0xa.20408f833c406efp-8L, -0xa.20408f833c406eep-8L },
    { 0x9.9c2d0517aeee533p-4L, 0x8.4314f6301d33356p-4L, 0x8.4314f6301d33357p-4L },
    { -0xe.573ec2d151cf156p-4L, -0x7.675f198c15befecp-4L, -0x7.675f198c15befeb8p-4L },
    { 0xe.947a2689d86b12ap-4L, 0xe.173cf492cdc5f07p-4L, 0xe.173cf492cdc5f08p-4L },
    { -0x5.fee8120e5e04be2p-4L, -0x3.a8f7bcd02665b4bcp-4L, -0x3.a8f7bcd02665b4b8p-4L },
    { 0x3.f3364f18a79b3b3cp-4L, 0x2.fc7677f28287f59cp-4L, 0x2.fc7677f28287f5ap-4L },
    { -0xd.acb73d1f464055dp-4L, -0x7.26f0d62a8825fadp-4L, -0x7.26f0d62a8825fac8p-4L },
    { 0x3.72e8ef378d42c014p-136L, 0x2.63fc8bc98f409418p-136L, 0x2.63fc8bc98f40941cp-136L },
    { -0xf.f7a6695a9469f6bp-64L, -0xb.1157d5a78619d6ap-64L, -0xb.1157d5a78619d69p-64L },
    { 0xa.ed0ce5b49afa192p-4L, 0x9.af72dd5f9d309c8p-4L, 0x9.af72dd5f9d309c9p-4L },
    { -0x8.92179a4e3bb69e3p-4L, -0x4.f66ab2d67cb085b8p-4L, -0x4.f66ab2d67cb085bp-4L },
    { 0xb.ed688726df9befap-4L, 0xa.d2fc0f03bbaa3eap-4L, 0xa.d2fc0f03bbaa3ebp-4L },
    { -0x9.3f55bdfddb49b2bp-4L, -0x5.480d56cfe248124p-4L, -0x5.480d56cfe2481238p-4L },
    { 0x7.2ec3f10b51218bfp-4L, 0x5.d71a7e29e3375c08p-4L, 0x5.d71a7e29e3375c1p-4L },
    { -0x7.f78628cdda70a8d8p-8L, -0x5.768d49335e93bc48p-8L, -0x5.768d49335e93bc4p-8L },
    { 0x6.5dbff56825b7dbb8p-4L, 0x5.14cc73903ffab37p-4L, 0x5.14cc73903ffab378p-4L },
    { -0xa.e7a98283fc10855p-4L, -0x6.062dbfc6c13a0cp-4L, -0x6.062dbfc6c13a0bf8p-4L },
    { 0xc.2509016f44e196ap-4L, 0xb.13ee99066e4da51p-4L, 0xb.13ee99066e4da52p-4L },
    { -0x7.861514480ac9199p-4L, -0x4.7350865eeea1ec4p-4L, -0x4.7350865eeea1ec38p-4L },
    { 0xf.17da41cf884346bp-4L, 0xe.c46a3230752f01ep-4L, 0xe.c46a3230752f01fp-4L },
    { -0xc.62d7c253621dcf7p-4L, -0x6.a4e721c955ab92bp-4L, -0x6.a4e721c955ab92a8p-4L },
    { 0x9.845c3e40ed6ad83p-8L, 0x6.aeb3e091a9ca62a8p-8L, 0x6.aeb3e091a9ca62bp-8L },
    { -0xd.68fda9eec5a66c2p-4L, -0x7.0cd5054a8559068p-4L, -0x7.0cd5054a85590678p-4L },
    { 0x8.18f925371b61292p-4L, 0x6.b926981ecb341cc8p-4L, 0x6.b926981ecb341cdp-4L },
    { -0x1.57f7c0849ebb346p-4L, -0xe.79d2f43931febcep-8L, -0xe.79d2f43931febcdp-8L },
    { 0xa.e4ab5281b09d79fp-4L, 0x9.a6211af13affacbp-4L, 0x9.a6211af13affaccp-4L },
    { -0x7.1174b12c13aaf4e8p-4L, -0x4.38619acc6b16c48p-4L, -0x4.38619acc6b16c478p-4L },
    { 0xe.880fef5908d95bdp-4L, 0xe.07123c37decbd2bp-4L, 0xe.07123c37decbd2cp-4L },
    { -0x7.609718a06f5f08ap-4L, -0x4.607ef189a568c048p-4L, -0x4.607ef189a568c04p-4L },
    { 0x6.e2bdbcf507ec4778p-80L, 0x4.c5d6cd2d0554bd38p-80L, 0x4.c5d6cd2d0554bd4p-80L },
    { -0xa.20544abb2f768b5p-172L, -0x7.04dd9fe9c3d0ca4p-172L, -0x7.04dd9fe9c3d0ca38p-172L },
    { 0x6.14aea1523dfe3aa8p-4L, 0x4.d27a84995c90398p-4L, 0x4.d27a84995c903988p-4L },
    { -0xc.97a55c9c85f26f9p-4L, -0x6.ba359004a30e41c8p-4L, -0x6.ba359004a30e41cp-4L },
    { 0x8.680ab975830d106p-4L, 0x7.078281205f71db5p-4L, 0x7.078281205f71db58p-4L },
    { -0x3.7b5dd7324be888fcp-4L, -0x2.3d81bd11bf2f6c4cp-4L, -0x2.3d81bd11bf2f6c48p-4L },
    { 0xd.ff0ee4cab1a5c92p-4L, 0xd.56e662606151cc8p-4L, 0xd.56e662606151cc9p-4L },
    { -0xe.008f2e366ac05f5p-4L, -0x7.46d9fe3c6c7508bp-4L, -0x7.46d9fe3c6c7508a8p-4L },
    { 0xa.b9de710cc3240eap-4L, 0x9.76be49caa91f1f7p-4L, 0x9.76be49caa91f1f8p-4L },
    { -0xd.b8496a7f5a40118p-4L, -0x7.2b5f2502bf92f008p-4L, -0x7.2b5f2502bf92fp-4L },
    { 0xb.c810c87ed94addfp-4L, 0xa.a7ba02e0d048d4bp-4L, 0xa.a7ba02e0d048d4cp-4L },
    { -0x6.0a47a8ab4ac89cd8p-4L, -0x3.af0abdfd7366387cp-4L, -0x3.af0abdfd73663878p-4L },
    { 0xd.694a760f35e0c5cp-4L, 0xc.9aeeb6a65c8040ap-4L, 0xc.9aeeb6a65c8040bp-4L },
    { -0x1.02b5df71e26e7eeep-4L, -0xa.f74a44b0786e5d7p-8L, -0xa.f74a44b0786e5d6p-8L },
    { 0x8.2d4ad8d9b79c26ep-4L, 0x6.cd300350fa1084ep-4L, 0x6.cd300350fa1084e8p-4L },
    { -0x5.d8b77fd6db5f46fp-4L, -0x3.947c5ee25dae93cp-4L, -0x3.947c5ee25dae93bcp-4L },
    { 0x3.b2d5aa2bd4f226c8p-4L, 0x2.c7cc7c21062df578p-4L, 0x2.c7cc7c21062df57cp-4L },
    { -0x1.3d87d39ca205f226p-4L, -0xd.6495ea183c77a34p-8L, -0xd.6495ea183c77a33p-8L },
    { 0x7.58b591427632828p-4L, 0x5.feee1c31635efc6p-4L, 0x5.feee1c31635efc68p-4L },
    { -0xd.51cbb799b3f3a26p-4L, -0x7.03d23697240275b8p-4L, -0x7.03d23697240275bp-4L },
    { 0x9.0e54bb10a5b7912p-4L, 0x7.afc489158099261p-4L, 0x7.afc4891580992618p-4L },
    { -0xa.7e81ca95f58d507p-4L, -0x5.d853b00c0424b748p-4L, -0x5.d853b00c0424b74p-4L },
    { 0xa.38c6b26a97ad959p-144L, 0x7.15cf9ed628b7443p-144L, 0x7.15cf9ed628b74438p-144L },
    { -0xd.8dbb3097e168af8p-16L, -0x9.64dcae1a44ce08fp-16L, -0x9.64dcae1a44ce08ep-16L },
    { 0xf.05da5fd59fc565bp-4L, 0xe.ac75be21fa0a721p-4L, 0xe.ac75be21fa0a722p-4L },
    { -0xd.dd9a1c0c442c4c6p-4L, -0x7.399a1163598e674p-4L, -0x7.399a1163598e6738p-4L },
    { 0x4.61b51c01df55d6d8p-4L, 0x3.5833a282f0757d38p-4L, 0x3.5833a282f0757d3cp-4L },
    { -0xb.dce6fd9bad9f495p-4L, -0x6.6dfecf316daaa2b8p-4L, -0x6.6dfecf316daaa2bp-4L },
    { 0xa.b6f22a1b9f2939fp-4L, 0x9.73850a513137669p-4L, 0x9.73850a51313766ap-4L },
    { -0x3.4bb35afb05788e3p-4L, -0x2.20fa7ab319293c2cp-4L, -0x2.20fa7ab319293c28p-4L },
    { 0xd.0db3afda3c5f8cp-4L, 0xc.2a4edf1f8e608e3p-4L, 0xc.2a4edf1f8e608e4p-4L },
    { -0x2.1ce57b45214ebd74p-4L, -0x1.6646119faf2579e4p-4L, -0x1.6646119faf2579e2p-4L },
    { 0x5.067f9f48fc5b234p-8L, 0x3.81d3c5994dfa29ep-8L, 0x3.81d3c5994dfa29e4p-8L },
    { -0xb.a04244a598be88fp-4L, -0x6.54b9128406b6e57p-4L, -0x6.54b9128406b6e568p-4L },
    { 0xf.d97f1711de15f9cp-4L, 0xf.cacbd7b24bfa344p-4L, 0xf.cacbd7b24bfa345p-4L },
    { -0xf.493b2b477feaaf9p-4L, -0x7.bfaad9fbab559b1p-4L, -0x7.bfaad9fbab559b08p-4L },
    { 0xc.deaf7691740cdefp-8L, 0x9.13f529a0032aecap-8L, 0x9.13f529a0032aecbp-8L },
    { -0xa.59b5d478c821a2ep-4L, -0x5.c816a0d158b46128p-4L, -0x5.c816a0d158b4612p-4L },
    { 0xd.1b186c2e3417901p-4L, 0xc.3aab3f3a165b5b1p-4L, 0xc.3aab3f3a165b5b2p-4L },
    { -0xf.14939428966efa8p-4L, -0x7.acc2e6e3a1c40bfp-4L, -0x7.acc2e6e3a1c40be8p-4L },
    { 0xa.548931dd5b08516p-4L, 0x9.07e9820c45dc918p-4L, 0x9.07e9820c45dc919p-4L },
    { -0x1.86c3057b9088fe1cp-4L, -0x1.06181e6e8d7c4ee6p-4L, -0x1.06181e6e8d7c4ee4p-4L },
    { 0x8.de5082bfa47b272p-8L, 0x6.38b52f74fd4fac9p-8L, 0x6.38b52f74fd4fac98p-8L },
    { -0x6.381df51cf6ba1e58p-4L, -0x3.c7677b23d838f2c4p-4L, -0x3.c7677b23d838f2cp-4L },
    { 0x2.f43f9bb64395d398p-28L, 0x2.0c3105ebb2d3ec1p-28L, 0x2.0c3105ebb2d3ec14p-28L },
    { -0x1.7d1826b58589517p-188L, -0x1.08278b32d446a3dap-188L, -0x1.08278b32d446a3d8p-188L },
    { 0x3.24bd5453a5d96c38p-4L, 0x2.5591a327002dbbfp-4L, 0x2.5591a327002dbbf4p-4L },
    { -0xd.ac66274a591f9a9p-4L, -0x7.26d1c15c81b1be3p-4L, -0x7.26d1c15c81b1be28p-4L },
    { 0x7.4bbb894be77050dp-4L, 0x5.f29408389bbe66ep-4L, 0x5.f29408389bbe66e8p-4L },
    { -0xa.eacc82e14c1610fp-4L, -0x6.0788b0f7dc794f7p-4L, -0x6.0788b0f7dc794f68p-4L },
    { 0x2.a982ac56625aefc4p-4L, 0x1.f4b47ebd7795a254p-4L, 0x1.f4b47ebd7795a256p-4L },
    { -0x8.056940c538fa279p-4L, -0x4.b257711af2be1e78p-4L, -0x4.b257711af2be1e7p-4L },
    { 0x1.66b64b9c9f79a1dep-4L, 0x1.00578a1c0c673a1p-4L, 0x1.00578a1c0c673a12p-4L },
    { -0x3.26b75fa52c7ce30cp-4L, -0x2.0aaf1c1238c99944p-4L, -0x2.0aaf1c1238c9994p-4L },
    { 0x9.da5604fb75e8d87p-4L, 0x8.84c2f5daaacf75ep-4L, 0x8.84c2f5daaacf75fp-4L },
    { -0x8.f39b1339c38973dp-4L, -0x5.24a94b90f03e7ed8p-4L, -0x5.24a94b90f03e7edp-4L },
    { 0x7.677b36d2e1d48358p-4L, 0x6.0d06229c56a97f4p-4L, 0x6.0d06229c56a97f48p-4L },
    { -0xa.996804efaa5460cp-4L, -0x5.e4224415b8782278p-4L, -0x5.e4224415b878227p-4L },
    { 0x6.b6c06e4a29c88afp-4L, 0x5.66b27094b245b1ep-4L, 0x5.66b27094b245b1e8p-4L },
    { -0x5.a5149fe9b18171c8p-4L, -0x3.7894bad1006fb798p-4L, -0x3.7894bad1006fb794p-4L },
    { 0x5.375a31264862647p-4L, 0x4.0e852a933247c008p-4L, 0x4.0e852a933247c01p-4L },
    { -0xc.55651fd1cbee3d4p-4L, -0x6.9f72345b02eab28p-4L, -0x6.9f72345b02eab278p-4L },
    { 0xe.006deb92f93d672p-4L, 0xd.58a49a5d8de28c4p-4L, 0xd.58a49a5d8de28c5p-4L },
    { -0xa.6871090121d471bp-4L, -0x5.ce99fb28aafa5bb8p-4L, -0x5.ce99fb28aafa5bbp-4L },
    { 0xc.8ed445e1ea26da6p-4L, 0xb.9126f62f86bcb47p-4L, 0xb.9126f62f86bcb48p-4L },
    { -0x3.70640030d409ab74p-4L, -0x2.36f53ff3b132cba8p-4L, -0x2.36f53ff3b132cba4p-4L },
    { 0x2.219473696b04364cp-96L, 0x1.7a2acafbc3adc14ep-96L, 0x1.7a2acafbc3adc15p-96L },
    { -0xd.bdc3902e400dcddp-144L, -0x9.865401201b95f7ap-144L, -0x9.865401201b95f79p-144L },
    { 0xb.b53f28201a854efp-4L, 0xa.9207b77bb750cf7p-4L, 0xa.9207b77bb750cf8p-4L },
    { -0x4.28b1a78cc7055bd8p-4L, -0x2.a3536d42907d291p-4L, -0x2.a3536d42907d290cp-4L },
    { 0xd.e2cee7a54e7c7dfp-4L, 0xd.331435f3041bf4fp-4L, 0xd.331435f3041bf5p-4L },
    { -0x9.3f6896a8070ab3ep-4L, -0x5.4816171c316ed77p-4L, -0x5.4816171c316ed768p-4L },
    { 0x1.a1524a334652c37cp-4L, 0x1.2bb95dd5b9658e26p-4L, 0x1.2bb95dd5b9658e28p-4L },
    { -0x1.9b7f6344a4875e14p-4L, -0x1.13861edcadba3e08p-4L, -0x1.13861edcadba3e06p-4L },
    { 0xb.4660bc20f1141f9p-4L, 0xa.1399f4f27c33975p-4L, 0xa.1399f4f27c33976p-4L },
    { -0xd.9888197bcafba2ap-4L, -0x7.1f30db722ee63d78p-4L, -0x7.1f30db722ee63d7p-4L },
    { 0xf.3adad3101e81209p-4L, 0xe.f33515340a557e4p-4L, 0xe.f33515340a557e5p-4L },
    { -0xa.79ea74b25ad8a16p-4L, -0x5.d64e6bad7c9fffc8p-4L, -0x5.d64e6bad7c9fffcp-4L },
    { 0xd.4d87683a39ac568p-4L, 0xc.789c1f6e5dcac31p-4L, 0xc.789c1f6e5dcac32p-4L },
    { -0xd.0f2848388d6bd4fp-4L, -0x6.e9bc44c0f7734168p-4L, -0x6.e9bc44c0f773416p-4L },
    { 0x5.d9fb99a27648b5d8p-4L, 0x4.9dca7407214af058p-4L, 0x4.9dca7407214af06p-4L },
    { -0x1.705dc2d9924977d6p-4L, -0xf.7895af9cd8410b4p-8L, -0xf.7895af9cd8410b3p-8L },
    { 0xe.de1ad3b0df8a929p-4L, 0xe.77d17cd52544381p-4L, 0xe.77d17cd52544382p-4L },
    { -0xe.4bc9f399afa1199p-4L, -0x7.6319db0e3314bc98p-4L, -0x7.6319db0e3314bc9p-4L },
    { 0x9.4bc88b56990e957p-4L, 0x7.ef27dce522664078p-4L, 0x7.ef27dce52266408p-4L },
    { -0xe.2a8337406c02664p-4L, -0x7.56a65648e9cbee38p-4L, -0x7.56a65648e9cbee3p-4L },
};

int check_equal(long double res, long double expected)
{
    if (res != expected) {
        return 0;
    }
    return (__builtin_copysignl(1.0L, res) ==
            __builtin_copysignl(1.0L, expected));
}

int main(void)
{
    int ret = 0;
    int i;
    for (i = 0; i < sizeof(tests) / sizeof(tests[0]); i++) {
        long double ld_res;
        __asm__ volatile ("f2xm1" : "=t" (ld_res) : "0" (tests[i].arg));
        if (!check_equal(ld_res, tests[i].down) &&
            !check_equal(ld_res, tests[i].up)) {
            printf("FAIL: f2xm1 %La, expected %La or %La, got %La\n",
                   tests[i].arg, tests[i].down, tests[i].up, ld_res);
            ret = 1;
        }
    }
    return ret;
}
