from optparse import OptionParser
import os, sys
import re

import testbase



def vararg_callback(option, opt_str, value, parser, func=None):
    assert value is None
    if isinstance(option.default, list):
        if func:
            value = map(func, option.default)
        else:
            value = option.default
    else:
        value = []
    done = 0
    rargs = parser.rargs
    while rargs:
        arg = rargs[0]

        # Stop if we hit an arg like "--foo", "-a", "-fx", "--file=f",
        # etc.  Note that this also stops on "-3" or "-3.0", so if
        # your option takes numeric values, you will need to handle
        # this.
        if ((arg[:2] == "--" and len(arg) > 2) or
            (arg[:1] == "-" and len(arg) > 1 and arg[1] != "-")):
            break
        else:
            if func:
                arg = func(arg)
            value.append(arg)
            del rargs[0]
    setattr(parser.values, option.dest, value)
    
def convert_re(option):
    """ syntax like `--ignore '#.*(HTML|HTTP).*#'` """
    x = option.split("#")
    if len(x) == 1:
        # no regex
        r = re.compile(re.escape(x[0]))
    elif len(x) == 3:
        r = re.compile(x[1])
    else:
        raise ValueError, "Invalid option '%s'" %option
    return r
                  
class commandline_options(OptionParser):
    def __init__(self, ignore_tests=[]):
        OptionParser.__init__(self)
        self.add_option("-s", "--suites", dest="suites",
                help="add TESTCASE", metavar="TESTCASE",
                action="callback", callback=vararg_callback)
        self.add_option("--email", dest="email",
                help="send notification email", metavar="EMAIL", default=list(),
                action="callback", callback=vararg_callback)
        self.add_option("-i", "--ignore", dest="ignore",
                help="ignore TESTCASE", metavar="TESTCASE",
                action="callback", callback=vararg_callback,
                default=ignore_tests, callback_kwargs={"func":convert_re})
        self.add_option("-l", "--ls", dest="list_testcases",
                help="list available testcases",
                action="store_true", default=False)
        self.add_option("-a", "--all", dest="all_testcases",
                help="run all testcases listed in --ls",
                action="store_true", default=False)
        self.add_option("--header", dest="header",
                help="print additional information at the beginning of the report",
                action="store_true", default=False)
        (self.options, self.args) = self.parse_args()
        
def main():
    cfg = testbase.ConfigTest()["test_config"]
    cl = commandline_options(cfg["ignore"])
    if cl.options.list_testcases:
        path = os.path.dirname(os.path.abspath(sys.argv[0]))
        d = testbase.list_testcases((path,))
        for i, k in d.iteritems():
            print i
            for x, y in k.iteritems():
                print " "*4, ".%s" %x
                for v in y:
                    print " "*8,".%s" %v
        return 0
    
    if cl.options.email:
        if not cfg["mail_cmd"] in ("mail",):
            raise ValueError
    
    if cl.options.all_testcases:
        path = os.path.dirname(os.path.abspath(sys.argv[0]))
        d = testbase.list_testcases((path,))
        all = testbase.loadfrom_names(d.keys(), cl.options.ignore)
        testbase.run_test(all, cl.options.email, cl.options.header, cfg["mail_cmd"])
        
    elif cl.options.suites:
        all = testbase.loadfrom_names(cl.options.suites, cl.options.ignore)
        testbase.run_test(all, cl.options.email, cl.options.header, cfg["mail_cmd"])
    return 0
        
        
if __name__ == "__main__":
    sys.exit(main())
