# Written by Henrik Nilsen Omma
# (C) Canonical, Ltd. Licensed under the GPL

import os
import re
import subprocess
import apt_pkg

try:
    from bzrlib.bzrdir import BzrDir
    HAVE_BZR = True    
except:
    HAVE_BZR = False

def find_version_number():
    path = os.path.join(os.path.dirname(__file__), "..")

    # We're using a package
    if path.startswith('/usr'):
        output = subprocess.Popen(["dpkg-query", "-W", "python-launchpad-bugs"], 
                                   stdout=subprocess.PIPE).communicate()[0]
        return output.split()[1]
    if HAVE_BZR:
        try:
            bzr_revno = BzrDir.open(path).open_branch().revno()
            setupscript = open(os.path.join(path, "setup.py")).read()
            version = re.findall("version=\"(.*)\",", setupscript)
            return "%sr%s" % (version[0], bzr_revno)
        except:
            pass
    return "unknown"

def package_exists(package_name):
    try:
        apt_pkg.init()
        sources = apt_pkg.GetPkgSrcRecords()
        sources.Restart()
        if not sources.Lookup(str(package_name)):
            return False
        else:
            return True
    except:
        print "You must put some 'source' URIs in your sources.list"
        return False

def lazy_makedir(directory):
    try:
        os.makedirs(directory)
    except:
        pass

def sanitize_html(text):
    mapping = [['&nbsp;', ' '],
               ['<wbr></wbr>', ''],
               ['&lt;', '<'],
               ['&gt;', '>'],
               ['&amp;', '&']]
    if text:
        for m in mapping:
            text = text.replace(m[0], m[1])
    return text
    
def remove_obsolete_attachments(path, open_bugs):
    open_bug_nrs = set(map(lambda a: str(a.nr), open_bugs))
    if os.path.exists(path):
        bugs = set(filter(lambda a: os.path.isdir(os.path.join(path, a)), 
                          os.listdir(path)))
        for bug in bugs.difference(bugs.intersection(open_bug_nrs)):
            bug_path = os.path.join(path, bug)
            if os.path.isdir(bug_path):
                os.system("rm -r %s" % bug_path)
                
                
BUG = "bug"
BUGLIST = "buglist"
BUGPAGE = "bugpage"
BASEURL = {BUG : "https://bugs.launchpad.net",
        BUGLIST : "",
        BUGPAGE : ""}
def valid_lp_url(url,type):
    """ NEEDS to be implemented
    returns url if it's valid for type
    if url is invalid it returns False"""
    if type == BUG:
        __m = re.search('^(http(s)?\:\/\/)?(bugs\.)?(edge\.)?launchpad\.net\/(.*\/\+bug\/[0-9]+)$', url)
        if __m:
            return "%s/%s" %(BASEURL[type],__m.group(5))

        __m = re.search('^((http(s)?\:\/\/)?(bugs\.)?(edge\.)?launchpad\.net\/bugs\/[0-9]+)$', url)
        if __m:
            return __m.group(1)

        __m = re.search('^\/(.*\/\+bug\/[0-9]+((\/\+[a-z]*)?|(\/attachments\/[0-9]+)))$', url)
        if __m:
            return "%s/%s" %(BASEURL[type],__m.group(1))
    else:
        return url #TODO!
    raise ValueError, "Invalid LP url '%s', please report this problem" %url

def debug(*arg,**args):
    for i in arg:
        if type(i) == type(dict()):
            for k in i:
                print "%s : %s" %(k, i[k])
        else:
            print i
    for k in args:
        print k, args[k]
    
