"""
TODO:
 * move user-class to bugbase (?) as this class is used in html_bug and text_bug

"""

from bugbase import Bug as BugBase
import email
import cStringIO as StringIO
import re

#from html_bug import Bug as BugBase # using html_bug as fallback
import warnings
warnings.warn("text_bug API not stable yet", FutureWarning)
del warnings

class user(str):
    def __new__(cls, lplogin, realname=None):
        obj = super(user, cls).__new__(user, lplogin)
        obj.__lplogin = lplogin
        obj.__realname = realname
        return obj
        
    @property
    def realname(self):
        return self.__realname or "unknown"
        
    def __repr__(self):
        return "<user %s (%s)>" %(self.__lplogin, self.realname)
        
    def __str__(self):
        return self.__lplogin or ""
        
    def __nonzero__(self):
        if self.__lplogin:
            return True
        else:
            return False
        
user_regex = re.compile(r"^([a-zA-Z0-9 ]+) \(([a-zA-Z-]+)\)$")
def _parse_user(usr):
    x = user_regex.search(usr)
    if x:
        return user(x.group(2), x.group(1))
    return usr



class Task(object):
    def __init__(self, task_dict):
        self.__data = task_dict
        self.__data["affects"] = task_dict["task"]
        self.__data["reporter"] = [_parse_user(u) for u in self.__data["reporter"]]
        
        
    def __getattr__(self, name):
        try:
            return self.__data[name][0]
        except KeyError:
            if name in ["affects", "status", "importance", "milestone", "reporter", "assignee"]:
                return None
            else:
                raise AttributeError
            
    def __repr__(self):
        return "<Info of '%s (#1)'>" %(self.affects)
        
    def __str__(self):
        return "[%s: %s/%s]" % (self.affects, self.status, self.importance)
        
        
class BugReport(object):
    def __init__(self, bug_dict):
        self.__data = bug_dict
        self.__data["bugnumber"] = int(bug_dict["bug"][0])
        self.__data["reporter"] = [_parse_user(u) for u in self.__data["reporter"]]
        self.__data["subscribers"] = [_parse_user(u) for u in self.__data["subscribers"]]
        
    def __getattr__(self, name):
        try:
            return self.__data[name]
        except KeyError:
            if name in ["bugnumber", "title", "reporter", "duplicate_of", "duplicates", "subscribers"]:
                return None
            else:
                raise AttributeError
        

class TextPage(object):
    def __init__(self, url, connection):
        self.parsed = False
        self.__url = url + "/+text"
        self.__connection = connection
        self.__data = {}
        
    def __getitem__(self, key):
        if not self.parsed:
            self.parse()
        return self.__data[key]
        
    def parse(self):
        text = self.__connection.get(self.__url).text
        text_file = StringIO.StringIO(text)
        k = None
        v = []
        block = None
        task_count = 0
        tmp_task = []
        cur_data = {}
        for l in text_file:
            if l == "\n":
                if block == "task":
                    tmp_task.append(Task(cur_data))
                elif block == "bug":
                    self.__data["bug"] = BugReport(cur_data)
                else:
                    self.__data[block][k] = v
                block = None
                cur_data = {}
                k = None
                v = []
            else:
                if l.startswith(" "):
                    if block == "bug":
                        try:
                            cur_data[k].append(l.strip(" \n"))
                        except KeyError:
                            cur_data[k] = [l.strip(" \n")]
                    else:
                        v.append(l.strip(" \n"))
                else:
                    x = l.split(":",1)
                    assert len(x) == 2, "wrong line:%s" %l
                    if not block:
                        block = x[0]
                        if block == "task" or block == "bug":
                            cur_data = {}
                        else:
                            self.__data[block] = {}
                    if k and v:
                        if block == "task" or block == "bug":
                            cur_data[k] = v
                        else:
                            self.__data[block][k] = v
                        k = None
                        v = []
                    k = x[0]
                    y = x[1].strip(" \n")
                    if y:
                        v = [y]
        if block:
            if block == "task":
                tmp_task.append(Task(cur_data))
            elif block == "bug":
                self.__data["bug"] = BugReport(cur_data)
            else:
                self.__data[block][k] = v
        self.__data["task"] = tmp_task
        self.parsed = True
                    


class Bug(BugBase):
    def __init__(self, bug=None, url=None, connection=None):
            
        BugBase.__init__(self, bug, url, connection)
        self.__textpage = TextPage(self.url, self.__connection)
        
    def get_url(self):
        return self.url
    
    def get_bugnumber(self):
        assert self.bugnumber == self.__textpage["bug"].bugnumber[0]
        return self.__textpage["bug"].bugnumber[0]
        
    def get_reporter(self):
        return self.__textpage["bug"].reporter[0]
        
    def get_title(self):
        return self.__textpage["bug"].title[0]
        
    def get_subscriptions(self):
        return set(self.__textpage["bug"].subscribers)
        
    def get_duplicate(self):
        try: return self.__textpage["bug"].duplicate_of[0]
        except: return None
        
    def get_duplicates(self):
        return set(self.__textpage["bug"].duplicates or [])
        
    def get_infotable(self):
        return self.__textpage["task"]


        
