import urllib2
import multipartpost_handler
import utils
import cookielib
import bughelper_error as Error

BASEURL = "https://bugs.launchpad.net"

class _result(object):
    def __init__(self, contenttype=None, text=None, url=None):
        assert contenttype or text or url, "at least one argument needed"
        self.contenttype = contenttype
        self.text = text
        self.url = url


class HTTPConnection(object):

    def __init__(self, cookiefile=None, attempts=5, content_types=["text/html","text/plain"]):
        __version = "bughelper/%s (Python-urllib2/%s)" %(utils.find_version_number(),urllib2.__version__)
        self.__cookiefile = cookiefile
        self.__cookie_handler = None
        self.__opener = urllib2.build_opener()
        self.__opener.addheaders = [('User-agent', __version)]
        self.__poster = urllib2.build_opener(multipartpost_handler.MultipartPostHandler)
        self.__poster.addheaders = [('User-agent', __version)]
        self.__attempts = attempts
        self.content_types = content_types
        self.__baseurl = None
        
    def get_auth(self):
        return self.__cookiefile
        
    def set_auth(self, file):
        self.__cookiefile = file
        result = self._set_cookie_handler()  
    
    def _set_cookie_handler(self):
        if self.__cookiefile:
            __cj = cookielib.MozillaCookieJar()
            __cj.load(self.__cookiefile)
            self.__cookie_handler = urllib2.HTTPCookieProcessor(__cj)
            for i in [self.__opener, self.__poster]:
                if not True in [isinstance(h,urllib2.HTTPCookieProcessor) for h in i.handlers]:
                    i.add_handler(self.__cookie_handler)
            self.__baseurl = None
            return False
        else:
            raise IOError, "No cookie file given"
            
    def _get_baseurl(self):
        """ returns the redirected baseurl """
        #unfortunately "https://bugs.launchpad.net" is not redirected
        try:
            a = self.__opener.open(BASEURL + "/+").rstrip("/+")
        except urllib2.HTTPError, e:
            a = e.geturl().rstrip("/+")
        return a
        
    def get(self, url):
        if not self.__baseurl:
            self.__baseurl = self._get_baseurl()
        url = url.replace(BASEURL, self.__baseurl)
        return self._safe_urlopen(url, None, False)
        
    def post(self, url, data):
        if not self.__baseurl:
            self.__baseurl = self._get_baseurl()
        url = url.replace(BASEURL, self.__baseurl)
        return self._safe_urlopen(url, data, True)
        
        
    def _safe_urlopen(self, url, data, post):
        count = 0
        text = None
        contenttype = None
        geturl = None
        sock = None
        if post:
            opener = self.__poster
        else:
            opener = self.__opener
        while count < self.__attempts:
            #print "count: %s, url: %s" %(count,url) #DEBUG
            try:
                if url[:4] != 'http':
                    url_old = url
                    url = 'https://' + url
                    print "wrong url <%s>, try <%s>" %(url_old, url)
                if data:
                    sock = opener.open(url,data)
                else:
                    sock = opener.open(url)
                contenttype = sock.info()["Content-type"]
                if sock.geturl().endswith("+login"):
                    raise Error.LPUrlError("login failed", url)
                for ct in self.content_types:
                    if contenttype.startswith(ct):
                        text = sock.read()
                        geturl = sock.geturl()
                        sock.close()
                        return _result(contenttype=contenttype,text=text, url=geturl)
                sock.close()
                raise IOError, "unsupported contenttype (%s)" %contenttype
            except urllib2.URLError, e:
                try:
                    error = e.code
                except AttributeError, e:
                    error = "unknown error"
                count += 1

        raise Error.LPUrlError(error, url)

