"""TODO:
    * think about adding a filter function to filter by importance and status
        (currently this is done by url-option)
    * urlopt will be useless for a XMLRPC implementation -> we need a per
        implementation filter method
"""

import time
import urlparse
import urllib
import re
import sys

class Filter(object):
    def __init__(self, method):
        self._default()
        self.__method = method
        
    def set_filter(self, minbug=None, filterbug=None, lastcomment=None, tag=None,
            closed_bugs=None, duplicates=None, status=None, importance=None, reporter=None,
            url="", Bug_cls=None, *args, **kwargs):
        """ set standard filter functions on given options """
        
        self.tag = tag
        self.closed_bugs = closed_bugs
        self.duplicates = duplicates
        self.status = status
        self.importance = importance
        self.url = url
        self.__url = urlparse.urlsplit(urllib.unquote(self.url))
        if not Bug_cls:
            import launchpadbugs.connector as Connector
            Bug_cls = Connector.ConnectBug()
        self.__Bug = Bug_cls
        
        if minbug:
            self.minbug = int(minbug)
            self.functions.add(self.func_minbug)
            
        if filterbug:
            self.filterbugs = map(int, filterbug.split(','))
            self.functions.add(self.func_filterbug)
            
        if reporter:
            self.reporters = reporter.split(',')
            self.functions.add(self.func_reporter)

        if lastcomment:
            x = re.split(r" *( |\||&) *", lastcomment)
            assert len(x) in [1,3], "wrong number of lastcomment arguments"
            if len(x) == 3:
                y = x.pop(1)
                if y == " ":
                    y = "|"
                self.lastcomment["operation"] = y
            for i in x:
                if i.startswith("d:"):
                    self.lastcomment["date"] = i.lstrip("d:")
                    try:
                        self.lastcomment["date"] = time.mktime(time.strptime(self.lastcomment["date"], "%Y-%m-%d"))
                    except ValueError:
                        print  >> sys.stderr, "The given date must be in the format 'Year-Month-day'. Ignoring given date!"
                        self.lastcomment["date"] = None
                else:
                    self.lastcomment["user"] = i.lstrip("u:")       
            self.functions.add(self.func_lastcomment)

        
    def _default(self):
        self.__urlopt = None
        self.status = None
        self.importance = None
        self.tag = None
        self.closed_bugs = None
        self.duplicates = None
        self.functions = set()
        self.lastcomment = {"user" : None, "date" : None, "operation": "|"}
        self.minbug = 0
        self.filterbugs = list()
        self.reporters = None
        
    def reset(self):
        self._default()
        
    # Filter functions
        
    def func_filterbug(self, bugs):
        result = set()
        for bug in bugs:
            if int(bug.bugnumber) not in self.filterbugs:
                result.add(bug)
        return result
        
    def func_minbug(self, bugs):
        result = set()
        for bug in bugs:
            if int(bug.bugnumber) > self.minbug:
                result.add(bug)
        return result

    def func_reporter(self, bugs):
        """
        filters bugs by reporter
        * if a bug is instance of BugInfo, it will be replaced by an instance
          of Bug
        """
        result = set()
        for b in bugs:
            if str(type(b)) != "Bug":
                b = self.__Bug(b)
            if b.reporter in self.reporters:
                result.add(b)
        return result

    def func_lastcomment(self, bugs):
        """
        filters bugs by last comments
        * if a bug is instance of BugInfo
            * it will be replaced by an instance of Bug if it's not filtered
            * otherwise it will be removed from the set
        """
        result = set()
        for b in bugs:
            if str(type(b)) != "Bug":
                b = self.__Bug(b)
            if self.lastcomment["user"]:
                if self.lastcomment["user"] == 'reporter':
                    lp_user = b.reporter
                #elif self.lastcomment["user"] == 'maintainer': #currently no maintainer function in Bug()
                    #lp_user = b.maintainer
                else:
                    lp_user = self.lastcomment["user"]
            comments = b.comments
            check_user = None
            check_date = None
            if comments:
                if (self.lastcomment["user"] and comments[-1].user == lp_user):
                    check_user = True
                if self.lastcomment["date"]:
                    t = time.mktime(time.strptime(comments[-1].date, "%Y-%m-%d %H:%M:%S %Z"))
                    if (t - self.lastcomment["date"]) < 0:
                        check_date = True
                if self.lastcomment["operation"] == "|":
                    if check_user or check_date:
                        result.add(b)
                elif self.lastcomment["operation"] == "&":
                    if check_user and check_date:
                        result.add(b)
        return result
        
    def get_url_opt(self, ignore_conflict=False):
        url_option = {}
        if self.tag:
            url_option['field.tag'] = self.tag.replace(',','+')
        if self.closed_bugs:
            url_option['field.status:list'] = ['New','Incomplete',\
                    'Invalid', 'Won\'t Fix', 'Confirmed', 'Triaged',\
                    'In Progress','Fix Committed','Fix Released']
        if self.duplicates:
            url_option['field.omit_dupes'] = ['off']
        if self.status:
            url_option['field.status:list'] = self.status.split(",")
        if self.importance:
            url_option['field.importance:list'] = self.importance.split(",")
            
        if self.__url[3]:
            u = self.__url[3]
            u_opt = urllib.unquote_plus(u).split("&")
            for i in u_opt:
                o = i.split("=")
                if not url_option.has_key(o[0]):
                    url_option[o[0]] = [o[1]]
                else:
                    if not ignore_conflict:
                        raise ValueError, "ValueError: conflict filter options (%s)" %(o[0])
                    else:
                        # this would add the value to the list
                        #if o[1] not in url_option[o[0]]:
                        #    url_option[o[0]].append(o[1])
                        # this overwrites the value
                        pass
                        
        self.__urlopt = urllib.urlencode(url_option,True)
        return self.__urlopt
        
    urlopt = property(get_url_opt, doc='get filter related url appendage')
    
    def get_modiefied_url(self, ignore_conflict=False):
        result = None
        if self.url:
            result = urlparse.urlunsplit((self.__url[0],self.__url[1],self.__url[2], self.get_url_opt(ignore_conflict), self.__url[4]))
        return result 
