import os, os.path, sys

from genhtml import GenHTML
from reader import Reader

#config = {}

htmlHead ="""
<!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN
        "http://www.w3.org/TR/html4/loose.dtd"">
<html>
<head>
  <title>%s</title>
  <meta http-equiv="Content-Type" content="text/html; charset=ISO-8859-1">
  <meta name="GENERATOR" content="wabbit dumphtml">
</head>
<body>
<h4>PyKDE - Python Bindings for KDE</h4>
<hr>
"""

htmlFoot = """
</body>
</html>
"""


def readConfigFile ():
    config = {}
    try:
        homepath = os.getenv ("HOME")
        if not homepath:
            homepath = os.path.join (os.sep, home, os.getlogin ())

        configFile = os.path.join (homepath, ".wabbit", "wabbitrc")

        if os.path.exists (configFile):
            config ["wabbit"] = os.path.dirname (configFile)
            f = open (configFile, "r")
            for line in f:
                if line.find ("="):
                    pair = line.split ("=")
                    if len (pair) >= 2:
                        config [pair [0].strip ()] = pair [1].strip ()
                    else:
                        config [pair [0].strip ()] = ""
        else:
            print "Error: can't locate or read config file wabbitrc"
            return None

        return config
    except:
        print "Error: can't locate or read config file wabbitrc"
        return None


def writeHTMLFiles (config, dest):
    glCopy = "cp %s %s" % (os.path.join (config ["PyKDERef"], "glossary.html"), os.path.join (dest, "glossary.html"))
    os.system (glCopy)

    reader = Reader (os.path.join (config ["PyKDERef"], "classref.txt"), config)
    reader.readfile ()
    genHTML = GenHTML (reader, config, True)

    homefile = os.path.join (dest, "index.html")

    page = htmlHead % ("PyKDE Classref")
    page += genHTML.homePage ()
    page += htmlFoot

    print homefile
    f = open (homefile, "w")
    f.write (page)
    f.close ()

    allfile = os.path.join (dest, "allclasses.html")
    page = htmlHead % ("All PyKDE Classes")
    page += genHTML.allClassesPage ()
    page += htmlFoot

    f = open (allfile, "w")
    f.write (page)
    f.close ()

    print "modules", reader.modules.keys ()
    for mod in reader.modules:
    #    print mod
        moddir = os.path.join (dest, mod)
        if not os.path.exists (moddir):
            os.mkdir (moddir)

        modfile = os.path.join (moddir, "index.html")

        page = htmlHead % ("module " + mod)
        page += genHTML.classesPage (mod)
        page += htmlFoot

        f = open (modfile, "w")
        f.write (page)
        f.close ()

        if mod in reader.globals:
            globfile = os.path.join (moddir, "%s-globals.html" % mod)

            page = htmlHead % ("%s globals" % (mod))
            page += genHTML.globalPage (mod)
            page += htmlFoot

            f = open (globfile, "w")
            f.write (page)
            f.close ()

        for cls in reader.modules [mod]:
    #        print "    %s" % cls
            clsfile = os.path.join (moddir, "%s.html" % cls)

            page = htmlHead % ("class " + cls)
            page += genHTML.classPage (mod, cls)
            page += htmlFoot

            f = open (clsfile, "w")
            f.write (page)
            f.close ()


if __name__ == "__main__":
    config = {}
    config ["PyKDERef"]      = "sip/"
    config ["PyFont"]        = "Sans"
    config ["PyFontSize"]    = 10
    config ["PyFontWeight"]  = 75
    config ["PyFontItalic"]  = True
    config ["CppFont"]       = "Sans"
    config ["CppFontSize"]   = 10
    config ["CppFontWeight"] = 50
    config ["CppFontItalic"] = True
    config ["KDERef"]        = config ["PyKDERef"]
    config ["WebLink"]       = None
#    config = readConfigFile ()

    if len (sys.argv) < 2:
        print "no destination specified"
        sys.exit (1)

    dest = sys.argv [-1]
    config ["PyKDEDocs"]     = os.path.dirname (dest)

    if not dest:
        print "problem with destination or config file"
        sys.exit (1)

    if config:
         writeHTMLFiles (config, dest)


