#
# Autogenerated by Thrift Compiler (0.9.0)
#
# DO NOT EDIT UNLESS YOU ARE SURE THAT YOU KNOW WHAT YOU ARE DOING
#
#  options string: py:new_style
#

from thrift.Thrift import TType, TMessageType, TException, TApplicationException
from ttypes import *
from thrift.Thrift import TProcessor
from thrift.transport import TTransport
from thrift.protocol import TBinaryProtocol, TProtocol
try:
  from thrift.protocol import fastbinary
except:
  fastbinary = None


class Iface(object):
  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    pass

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    pass

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    pass

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    pass

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    pass

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    pass

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    pass

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    pass

  def get(self, tableName, row, column):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
    """
    pass

  def getVer(self, tableName, row, column, numVersions):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
    """
    pass

  def getVerTs(self, tableName, row, column, timestamp, numVersions):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
    """
    pass

  def getRow(self, tableName, row):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
    """
    pass

  def getRowWithColumns(self, tableName, row, columns):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
    """
    pass

  def getRowTs(self, tableName, row, timestamp):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
    """
    pass

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
    """
    pass

  def getRows(self, tableName, rows):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
    """
    pass

  def getRowsWithColumns(self, tableName, rows, columns):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
    """
    pass

  def getRowsTs(self, tableName, rows, timestamp):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
    """
    pass

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
    """
    pass

  def mutateRow(self, tableName, row, mutations):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
    """
    pass

  def mutateRowTs(self, tableName, row, mutations, timestamp):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
    """
    pass

  def mutateRows(self, tableName, rowBatches):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
    """
    pass

  def mutateRowsTs(self, tableName, rowBatches, timestamp):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
    """
    pass

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    pass

  def deleteAll(self, tableName, row, column):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
    """
    pass

  def deleteAllTs(self, tableName, row, column, timestamp):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
    """
    pass

  def deleteAllRow(self, tableName, row):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
    """
    pass

  def deleteAllRowTs(self, tableName, row, timestamp):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
    """
    pass

  def scannerOpenWithScan(self, tableName, scan):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
    """
    pass

  def scannerOpen(self, tableName, startRow, columns):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
    """
    pass

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
    """
    pass

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
    """
    pass

  def scannerOpenTs(self, tableName, startRow, columns, timestamp):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
    """
    pass

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
    """
    pass

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    pass

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    pass


class Client(Iface):
  def __init__(self, iprot, oprot=None):
    self._iprot = self._oprot = iprot
    if oprot is not None:
      self._oprot = oprot
    self._seqid = 0

  def enableTable(self, tableName):
    """
    Brings a table on-line (enables it)

    Parameters:
     - tableName: name of the table
    """
    self.send_enableTable(tableName)
    self.recv_enableTable()

  def send_enableTable(self, tableName):
    self._oprot.writeMessageBegin('enableTable', TMessageType.CALL, self._seqid)
    args = enableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_enableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = enableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def disableTable(self, tableName):
    """
    Disables a table (takes it off-line) If it is being served, the master
    will tell the servers to stop serving it.

    Parameters:
     - tableName: name of the table
    """
    self.send_disableTable(tableName)
    self.recv_disableTable()

  def send_disableTable(self, tableName):
    self._oprot.writeMessageBegin('disableTable', TMessageType.CALL, self._seqid)
    args = disableTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_disableTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = disableTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def isTableEnabled(self, tableName):
    """
    @return true if table is on-line

    Parameters:
     - tableName: name of the table to check
    """
    self.send_isTableEnabled(tableName)
    return self.recv_isTableEnabled()

  def send_isTableEnabled(self, tableName):
    self._oprot.writeMessageBegin('isTableEnabled', TMessageType.CALL, self._seqid)
    args = isTableEnabled_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_isTableEnabled(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = isTableEnabled_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "isTableEnabled failed: unknown result");

  def compact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_compact(tableNameOrRegionName)
    self.recv_compact()

  def send_compact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('compact', TMessageType.CALL, self._seqid)
    args = compact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_compact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = compact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def majorCompact(self, tableNameOrRegionName):
    """
    Parameters:
     - tableNameOrRegionName
    """
    self.send_majorCompact(tableNameOrRegionName)
    self.recv_majorCompact()

  def send_majorCompact(self, tableNameOrRegionName):
    self._oprot.writeMessageBegin('majorCompact', TMessageType.CALL, self._seqid)
    args = majorCompact_args()
    args.tableNameOrRegionName = tableNameOrRegionName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_majorCompact(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = majorCompact_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def getTableNames(self, ):
    """
    List all the userspace tables.

    @return returns a list of names
    """
    self.send_getTableNames()
    return self.recv_getTableNames()

  def send_getTableNames(self, ):
    self._oprot.writeMessageBegin('getTableNames', TMessageType.CALL, self._seqid)
    args = getTableNames_args()
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableNames(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableNames_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableNames failed: unknown result");

  def getColumnDescriptors(self, tableName):
    """
    List all the column families assoicated with a table.

    @return list of column family descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getColumnDescriptors(tableName)
    return self.recv_getColumnDescriptors()

  def send_getColumnDescriptors(self, tableName):
    self._oprot.writeMessageBegin('getColumnDescriptors', TMessageType.CALL, self._seqid)
    args = getColumnDescriptors_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getColumnDescriptors(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getColumnDescriptors_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getColumnDescriptors failed: unknown result");

  def getTableRegions(self, tableName):
    """
    List the regions associated with a table.

    @return list of region descriptors

    Parameters:
     - tableName: table name
    """
    self.send_getTableRegions(tableName)
    return self.recv_getTableRegions()

  def send_getTableRegions(self, tableName):
    self._oprot.writeMessageBegin('getTableRegions', TMessageType.CALL, self._seqid)
    args = getTableRegions_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getTableRegions(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getTableRegions_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getTableRegions failed: unknown result");

  def createTable(self, tableName, columnFamilies):
    """
    Create a table with the specified column families.  The name
    field for each ColumnDescriptor must be set and must end in a
    colon (:). All other fields are optional and will get default
    values if not explicitly specified.

    @throws IllegalArgument if an input parameter is invalid

    @throws AlreadyExists if the table name already exists

    Parameters:
     - tableName: name of table to create
     - columnFamilies: list of column family descriptors
    """
    self.send_createTable(tableName, columnFamilies)
    self.recv_createTable()

  def send_createTable(self, tableName, columnFamilies):
    self._oprot.writeMessageBegin('createTable', TMessageType.CALL, self._seqid)
    args = createTable_args()
    args.tableName = tableName
    args.columnFamilies = columnFamilies
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_createTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = createTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    if result.exist is not None:
      raise result.exist
    return

  def deleteTable(self, tableName):
    """
    Deletes a table

    @throws IOError if table doesn't exist on server or there was some other
    problem

    Parameters:
     - tableName: name of table to delete
    """
    self.send_deleteTable(tableName)
    self.recv_deleteTable()

  def send_deleteTable(self, tableName):
    self._oprot.writeMessageBegin('deleteTable', TMessageType.CALL, self._seqid)
    args = deleteTable_args()
    args.tableName = tableName
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteTable(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteTable_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def get(self, tableName, row, column):
    """
    Get a single TCell for the specified table, row, and column at the
    latest timestamp. Returns an empty list if no such value exists.

    @return value for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
    """
    self.send_get(tableName, row, column)
    return self.recv_get()

  def send_get(self, tableName, row, column):
    self._oprot.writeMessageBegin('get', TMessageType.CALL, self._seqid)
    args = get_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_get(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = get_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "get failed: unknown result");

  def getVer(self, tableName, row, column, numVersions):
    """
    Get the specified number of versions for the specified table,
    row, and column.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - numVersions: number of versions to retrieve
    """
    self.send_getVer(tableName, row, column, numVersions)
    return self.recv_getVer()

  def send_getVer(self, tableName, row, column, numVersions):
    self._oprot.writeMessageBegin('getVer', TMessageType.CALL, self._seqid)
    args = getVer_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.numVersions = numVersions
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVer(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVer_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVer failed: unknown result");

  def getVerTs(self, tableName, row, column, timestamp, numVersions):
    """
    Get the specified number of versions for the specified table,
    row, and column.  Only versions less than or equal to the specified
    timestamp will be returned.

    @return list of cells for specified row/column

    Parameters:
     - tableName: name of table
     - row: row key
     - column: column name
     - timestamp: timestamp
     - numVersions: number of versions to retrieve
    """
    self.send_getVerTs(tableName, row, column, timestamp, numVersions)
    return self.recv_getVerTs()

  def send_getVerTs(self, tableName, row, column, timestamp, numVersions):
    self._oprot.writeMessageBegin('getVerTs', TMessageType.CALL, self._seqid)
    args = getVerTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.numVersions = numVersions
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getVerTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getVerTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getVerTs failed: unknown result");

  def getRow(self, tableName, row):
    """
    Get all the data for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
    """
    self.send_getRow(tableName, row)
    return self.recv_getRow()

  def send_getRow(self, tableName, row):
    self._oprot.writeMessageBegin('getRow', TMessageType.CALL, self._seqid)
    args = getRow_args()
    args.tableName = tableName
    args.row = row
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRow failed: unknown result");

  def getRowWithColumns(self, tableName, row, columns):
    """
    Get the specified columns for the specified table and row at the latest
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
    """
    self.send_getRowWithColumns(tableName, row, columns)
    return self.recv_getRowWithColumns()

  def send_getRowWithColumns(self, tableName, row, columns):
    self._oprot.writeMessageBegin('getRowWithColumns', TMessageType.CALL, self._seqid)
    args = getRowWithColumns_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumns failed: unknown result");

  def getRowTs(self, tableName, row, timestamp):
    """
    Get all the data for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - row: row key
     - timestamp: timestamp
    """
    self.send_getRowTs(tableName, row, timestamp)
    return self.recv_getRowTs()

  def send_getRowTs(self, tableName, row, timestamp):
    self._oprot.writeMessageBegin('getRowTs', TMessageType.CALL, self._seqid)
    args = getRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowTs failed: unknown result");

  def getRowWithColumnsTs(self, tableName, row, columns, timestamp):
    """
    Get the specified columns for the specified table and row at the specified
    timestamp. Returns an empty list if the row does not exist.

    @return TRowResult containing the row and map of columns to TCells

    Parameters:
     - tableName: name of table
     - row: row key
     - columns: List of columns to return, null for all columns
     - timestamp
    """
    self.send_getRowWithColumnsTs(tableName, row, columns, timestamp)
    return self.recv_getRowWithColumnsTs()

  def send_getRowWithColumnsTs(self, tableName, row, columns, timestamp):
    self._oprot.writeMessageBegin('getRowWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowWithColumnsTs_args()
    args.tableName = tableName
    args.row = row
    args.columns = columns
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowWithColumnsTs failed: unknown result");

  def getRows(self, tableName, rows):
    """
    Get all the data for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
    """
    self.send_getRows(tableName, rows)
    return self.recv_getRows()

  def send_getRows(self, tableName, rows):
    self._oprot.writeMessageBegin('getRows', TMessageType.CALL, self._seqid)
    args = getRows_args()
    args.tableName = tableName
    args.rows = rows
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRows failed: unknown result");

  def getRowsWithColumns(self, tableName, rows, columns):
    """
    Get the specified columns for the specified table and rows at the latest
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
    """
    self.send_getRowsWithColumns(tableName, rows, columns)
    return self.recv_getRowsWithColumns()

  def send_getRowsWithColumns(self, tableName, rows, columns):
    self._oprot.writeMessageBegin('getRowsWithColumns', TMessageType.CALL, self._seqid)
    args = getRowsWithColumns_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumns(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumns_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumns failed: unknown result");

  def getRowsTs(self, tableName, rows, timestamp):
    """
    Get all the data for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of the table
     - rows: row keys
     - timestamp: timestamp
    """
    self.send_getRowsTs(tableName, rows, timestamp)
    return self.recv_getRowsTs()

  def send_getRowsTs(self, tableName, rows, timestamp):
    self._oprot.writeMessageBegin('getRowsTs', TMessageType.CALL, self._seqid)
    args = getRowsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsTs failed: unknown result");

  def getRowsWithColumnsTs(self, tableName, rows, columns, timestamp):
    """
    Get the specified columns for the specified table and rows at the specified
    timestamp. Returns an empty list if no rows exist.

    @return TRowResult containing the rows and map of columns to TCells

    Parameters:
     - tableName: name of table
     - rows: row keys
     - columns: List of columns to return, null for all columns
     - timestamp
    """
    self.send_getRowsWithColumnsTs(tableName, rows, columns, timestamp)
    return self.recv_getRowsWithColumnsTs()

  def send_getRowsWithColumnsTs(self, tableName, rows, columns, timestamp):
    self._oprot.writeMessageBegin('getRowsWithColumnsTs', TMessageType.CALL, self._seqid)
    args = getRowsWithColumnsTs_args()
    args.tableName = tableName
    args.rows = rows
    args.columns = columns
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_getRowsWithColumnsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = getRowsWithColumnsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "getRowsWithColumnsTs failed: unknown result");

  def mutateRow(self, tableName, row, mutations):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
    """
    self.send_mutateRow(tableName, row, mutations)
    self.recv_mutateRow()

  def send_mutateRow(self, tableName, row, mutations):
    self._oprot.writeMessageBegin('mutateRow', TMessageType.CALL, self._seqid)
    args = mutateRow_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowTs(self, tableName, row, mutations, timestamp):
    """
    Apply a series of mutations (updates/deletes) to a row in a
    single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - row: row key
     - mutations: list of mutation commands
     - timestamp: timestamp
    """
    self.send_mutateRowTs(tableName, row, mutations, timestamp)
    self.recv_mutateRowTs()

  def send_mutateRowTs(self, tableName, row, mutations, timestamp):
    self._oprot.writeMessageBegin('mutateRowTs', TMessageType.CALL, self._seqid)
    args = mutateRowTs_args()
    args.tableName = tableName
    args.row = row
    args.mutations = mutations
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRows(self, tableName, rowBatches):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  Default current timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
    """
    self.send_mutateRows(tableName, rowBatches)
    self.recv_mutateRows()

  def send_mutateRows(self, tableName, rowBatches):
    self._oprot.writeMessageBegin('mutateRows', TMessageType.CALL, self._seqid)
    args = mutateRows_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRows(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRows_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def mutateRowsTs(self, tableName, rowBatches, timestamp):
    """
    Apply a series of batches (each a series of mutations on a single row)
    in a single transaction.  If an exception is thrown, then the
    transaction is aborted.  The specified timestamp is used, and
    all entries will have an identical timestamp.

    Parameters:
     - tableName: name of table
     - rowBatches: list of row batches
     - timestamp: timestamp
    """
    self.send_mutateRowsTs(tableName, rowBatches, timestamp)
    self.recv_mutateRowsTs()

  def send_mutateRowsTs(self, tableName, rowBatches, timestamp):
    self._oprot.writeMessageBegin('mutateRowsTs', TMessageType.CALL, self._seqid)
    args = mutateRowsTs_args()
    args.tableName = tableName
    args.rowBatches = rowBatches
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_mutateRowsTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = mutateRowsTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return

  def atomicIncrement(self, tableName, row, column, value):
    """
    Atomically increment the column value specified.  Returns the next value post increment.

    Parameters:
     - tableName: name of table
     - row: row to increment
     - column: name of column
     - value: amount to increment by
    """
    self.send_atomicIncrement(tableName, row, column, value)
    return self.recv_atomicIncrement()

  def send_atomicIncrement(self, tableName, row, column, value):
    self._oprot.writeMessageBegin('atomicIncrement', TMessageType.CALL, self._seqid)
    args = atomicIncrement_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.value = value
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_atomicIncrement(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = atomicIncrement_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "atomicIncrement failed: unknown result");

  def deleteAll(self, tableName, row, column):
    """
    Delete all cells that match the passed row and column.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
    """
    self.send_deleteAll(tableName, row, column)
    self.recv_deleteAll()

  def send_deleteAll(self, tableName, row, column):
    self._oprot.writeMessageBegin('deleteAll', TMessageType.CALL, self._seqid)
    args = deleteAll_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAll(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAll_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllTs(self, tableName, row, column, timestamp):
    """
    Delete all cells that match the passed row and column and whose
    timestamp is equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: Row to update
     - column: name of column whose value is to be deleted
     - timestamp: timestamp
    """
    self.send_deleteAllTs(tableName, row, column, timestamp)
    self.recv_deleteAllTs()

  def send_deleteAllTs(self, tableName, row, column, timestamp):
    self._oprot.writeMessageBegin('deleteAllTs', TMessageType.CALL, self._seqid)
    args = deleteAllTs_args()
    args.tableName = tableName
    args.row = row
    args.column = column
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRow(self, tableName, row):
    """
    Completely delete the row's cells.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
    """
    self.send_deleteAllRow(tableName, row)
    self.recv_deleteAllRow()

  def send_deleteAllRow(self, tableName, row):
    self._oprot.writeMessageBegin('deleteAllRow', TMessageType.CALL, self._seqid)
    args = deleteAllRow_args()
    args.tableName = tableName
    args.row = row
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRow(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRow_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def deleteAllRowTs(self, tableName, row, timestamp):
    """
    Completely delete the row's cells marked with a timestamp
    equal-to or older than the passed timestamp.

    Parameters:
     - tableName: name of table
     - row: key of the row to be completely deleted.
     - timestamp: timestamp
    """
    self.send_deleteAllRowTs(tableName, row, timestamp)
    self.recv_deleteAllRowTs()

  def send_deleteAllRowTs(self, tableName, row, timestamp):
    self._oprot.writeMessageBegin('deleteAllRowTs', TMessageType.CALL, self._seqid)
    args = deleteAllRowTs_args()
    args.tableName = tableName
    args.row = row
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_deleteAllRowTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = deleteAllRowTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    return

  def scannerOpenWithScan(self, tableName, scan):
    """
    Get a scanner on the current table, using the Scan instance
    for the scan parameters.

    Parameters:
     - tableName: name of table
     - scan: Scan instance
    """
    self.send_scannerOpenWithScan(tableName, scan)
    return self.recv_scannerOpenWithScan()

  def send_scannerOpenWithScan(self, tableName, scan):
    self._oprot.writeMessageBegin('scannerOpenWithScan', TMessageType.CALL, self._seqid)
    args = scannerOpenWithScan_args()
    args.tableName = tableName
    args.scan = scan
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithScan(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithScan_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithScan failed: unknown result");

  def scannerOpen(self, tableName, startRow, columns):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
    """
    self.send_scannerOpen(tableName, startRow, columns)
    return self.recv_scannerOpen()

  def send_scannerOpen(self, tableName, startRow, columns):
    self._oprot.writeMessageBegin('scannerOpen', TMessageType.CALL, self._seqid)
    args = scannerOpen_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpen(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpen_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpen failed: unknown result");

  def scannerOpenWithStop(self, tableName, startRow, stopRow, columns):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
    """
    self.send_scannerOpenWithStop(tableName, startRow, stopRow, columns)
    return self.recv_scannerOpenWithStop()

  def send_scannerOpenWithStop(self, tableName, startRow, stopRow, columns):
    self._oprot.writeMessageBegin('scannerOpenWithStop', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStop_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStop(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStop_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStop failed: unknown result");

  def scannerOpenWithPrefix(self, tableName, startAndPrefix, columns):
    """
    Open a scanner for a given prefix.  That is all rows will have the specified
    prefix. No other rows will be returned.

    @return scanner id to use with other scanner calls

    Parameters:
     - tableName: name of table
     - startAndPrefix: the prefix (and thus start row) of the keys you want
     - columns: the columns you want returned
    """
    self.send_scannerOpenWithPrefix(tableName, startAndPrefix, columns)
    return self.recv_scannerOpenWithPrefix()

  def send_scannerOpenWithPrefix(self, tableName, startAndPrefix, columns):
    self._oprot.writeMessageBegin('scannerOpenWithPrefix', TMessageType.CALL, self._seqid)
    args = scannerOpenWithPrefix_args()
    args.tableName = tableName
    args.startAndPrefix = startAndPrefix
    args.columns = columns
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithPrefix(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithPrefix_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithPrefix failed: unknown result");

  def scannerOpenTs(self, tableName, startRow, columns, timestamp):
    """
    Get a scanner on the current table starting at the specified row and
    ending at the last row in the table.  Return the specified columns.
    Only values with the specified timestamp are returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
    """
    self.send_scannerOpenTs(tableName, startRow, columns, timestamp)
    return self.recv_scannerOpenTs()

  def send_scannerOpenTs(self, tableName, startRow, columns, timestamp):
    self._oprot.writeMessageBegin('scannerOpenTs', TMessageType.CALL, self._seqid)
    args = scannerOpenTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.columns = columns
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenTs failed: unknown result");

  def scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp):
    """
    Get a scanner on the current table starting and stopping at the
    specified rows.  ending at the last row in the table.  Return the
    specified columns.  Only values with the specified timestamp are
    returned.

    @return scanner id to be used with other scanner procedures

    Parameters:
     - tableName: name of table
     - startRow: Starting row in table to scan.
    Send "" (empty string) to start at the first row.
     - stopRow: row to stop scanning on. This row is *not* included in the
    scanner's results
     - columns: columns to scan. If column name is a column family, all
    columns of the specified column family are returned. It's also possible
    to pass a regex in the column qualifier.
     - timestamp: timestamp
    """
    self.send_scannerOpenWithStopTs(tableName, startRow, stopRow, columns, timestamp)
    return self.recv_scannerOpenWithStopTs()

  def send_scannerOpenWithStopTs(self, tableName, startRow, stopRow, columns, timestamp):
    self._oprot.writeMessageBegin('scannerOpenWithStopTs', TMessageType.CALL, self._seqid)
    args = scannerOpenWithStopTs_args()
    args.tableName = tableName
    args.startRow = startRow
    args.stopRow = stopRow
    args.columns = columns
    args.timestamp = timestamp
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerOpenWithStopTs(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerOpenWithStopTs_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerOpenWithStopTs failed: unknown result");

  def scannerGet(self, id):
    """
    Returns the scanner's current row value and advances to the next
    row in the table.  When there are no more rows in the table, or a key
    greater-than-or-equal-to the scanner's specified stopRow is reached,
    an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerGet(id)
    return self.recv_scannerGet()

  def send_scannerGet(self, id):
    self._oprot.writeMessageBegin('scannerGet', TMessageType.CALL, self._seqid)
    args = scannerGet_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGet(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGet_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGet failed: unknown result");

  def scannerGetList(self, id, nbRows):
    """
    Returns, starting at the scanner's current row value nbRows worth of
    rows and advances to the next row in the table.  When there are no more
    rows in the table, or a key greater-than-or-equal-to the scanner's
    specified stopRow is reached,  an empty list is returned.

    @return a TRowResult containing the current row and a map of the columns to TCells.

    @throws IllegalArgument if ScannerID is invalid

    @throws NotFound when the scanner reaches the end

    Parameters:
     - id: id of a scanner returned by scannerOpen
     - nbRows: number of results to return
    """
    self.send_scannerGetList(id, nbRows)
    return self.recv_scannerGetList()

  def send_scannerGetList(self, id, nbRows):
    self._oprot.writeMessageBegin('scannerGetList', TMessageType.CALL, self._seqid)
    args = scannerGetList_args()
    args.id = id
    args.nbRows = nbRows
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerGetList(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerGetList_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.success is not None:
      return result.success
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    raise TApplicationException(TApplicationException.MISSING_RESULT, "scannerGetList failed: unknown result");

  def scannerClose(self, id):
    """
    Closes the server-state associated with an open scanner.

    @throws IllegalArgument if ScannerID is invalid

    Parameters:
     - id: id of a scanner returned by scannerOpen
    """
    self.send_scannerClose(id)
    self.recv_scannerClose()

  def send_scannerClose(self, id):
    self._oprot.writeMessageBegin('scannerClose', TMessageType.CALL, self._seqid)
    args = scannerClose_args()
    args.id = id
    args.write(self._oprot)
    self._oprot.writeMessageEnd()
    self._oprot.trans.flush()

  def recv_scannerClose(self, ):
    (fname, mtype, rseqid) = self._iprot.readMessageBegin()
    if mtype == TMessageType.EXCEPTION:
      x = TApplicationException()
      x.read(self._iprot)
      self._iprot.readMessageEnd()
      raise x
    result = scannerClose_result()
    result.read(self._iprot)
    self._iprot.readMessageEnd()
    if result.io is not None:
      raise result.io
    if result.ia is not None:
      raise result.ia
    return


class Processor(Iface, TProcessor):
  def __init__(self, handler):
    self._handler = handler
    self._processMap = {}
    self._processMap["enableTable"] = Processor.process_enableTable
    self._processMap["disableTable"] = Processor.process_disableTable
    self._processMap["isTableEnabled"] = Processor.process_isTableEnabled
    self._processMap["compact"] = Processor.process_compact
    self._processMap["majorCompact"] = Processor.process_majorCompact
    self._processMap["getTableNames"] = Processor.process_getTableNames
    self._processMap["getColumnDescriptors"] = Processor.process_getColumnDescriptors
    self._processMap["getTableRegions"] = Processor.process_getTableRegions
    self._processMap["createTable"] = Processor.process_createTable
    self._processMap["deleteTable"] = Processor.process_deleteTable
    self._processMap["get"] = Processor.process_get
    self._processMap["getVer"] = Processor.process_getVer
    self._processMap["getVerTs"] = Processor.process_getVerTs
    self._processMap["getRow"] = Processor.process_getRow
    self._processMap["getRowWithColumns"] = Processor.process_getRowWithColumns
    self._processMap["getRowTs"] = Processor.process_getRowTs
    self._processMap["getRowWithColumnsTs"] = Processor.process_getRowWithColumnsTs
    self._processMap["getRows"] = Processor.process_getRows
    self._processMap["getRowsWithColumns"] = Processor.process_getRowsWithColumns
    self._processMap["getRowsTs"] = Processor.process_getRowsTs
    self._processMap["getRowsWithColumnsTs"] = Processor.process_getRowsWithColumnsTs
    self._processMap["mutateRow"] = Processor.process_mutateRow
    self._processMap["mutateRowTs"] = Processor.process_mutateRowTs
    self._processMap["mutateRows"] = Processor.process_mutateRows
    self._processMap["mutateRowsTs"] = Processor.process_mutateRowsTs
    self._processMap["atomicIncrement"] = Processor.process_atomicIncrement
    self._processMap["deleteAll"] = Processor.process_deleteAll
    self._processMap["deleteAllTs"] = Processor.process_deleteAllTs
    self._processMap["deleteAllRow"] = Processor.process_deleteAllRow
    self._processMap["deleteAllRowTs"] = Processor.process_deleteAllRowTs
    self._processMap["scannerOpenWithScan"] = Processor.process_scannerOpenWithScan
    self._processMap["scannerOpen"] = Processor.process_scannerOpen
    self._processMap["scannerOpenWithStop"] = Processor.process_scannerOpenWithStop
    self._processMap["scannerOpenWithPrefix"] = Processor.process_scannerOpenWithPrefix
    self._processMap["scannerOpenTs"] = Processor.process_scannerOpenTs
    self._processMap["scannerOpenWithStopTs"] = Processor.process_scannerOpenWithStopTs
    self._processMap["scannerGet"] = Processor.process_scannerGet
    self._processMap["scannerGetList"] = Processor.process_scannerGetList
    self._processMap["scannerClose"] = Processor.process_scannerClose

  def process(self, iprot, oprot):
    (name, type, seqid) = iprot.readMessageBegin()
    if name not in self._processMap:
      iprot.skip(TType.STRUCT)
      iprot.readMessageEnd()
      x = TApplicationException(TApplicationException.UNKNOWN_METHOD, 'Unknown function %s' % (name))
      oprot.writeMessageBegin(name, TMessageType.EXCEPTION, seqid)
      x.write(oprot)
      oprot.writeMessageEnd()
      oprot.trans.flush()
      return
    else:
      self._processMap[name](self, seqid, iprot, oprot)
    return True

  def process_enableTable(self, seqid, iprot, oprot):
    args = enableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = enableTable_result()
    try:
      self._handler.enableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("enableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_disableTable(self, seqid, iprot, oprot):
    args = disableTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = disableTable_result()
    try:
      self._handler.disableTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("disableTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_isTableEnabled(self, seqid, iprot, oprot):
    args = isTableEnabled_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = isTableEnabled_result()
    try:
      result.success = self._handler.isTableEnabled(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("isTableEnabled", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_compact(self, seqid, iprot, oprot):
    args = compact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = compact_result()
    try:
      self._handler.compact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("compact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_majorCompact(self, seqid, iprot, oprot):
    args = majorCompact_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = majorCompact_result()
    try:
      self._handler.majorCompact(args.tableNameOrRegionName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("majorCompact", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableNames(self, seqid, iprot, oprot):
    args = getTableNames_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableNames_result()
    try:
      result.success = self._handler.getTableNames()
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableNames", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getColumnDescriptors(self, seqid, iprot, oprot):
    args = getColumnDescriptors_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getColumnDescriptors_result()
    try:
      result.success = self._handler.getColumnDescriptors(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getColumnDescriptors", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getTableRegions(self, seqid, iprot, oprot):
    args = getTableRegions_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getTableRegions_result()
    try:
      result.success = self._handler.getTableRegions(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getTableRegions", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_createTable(self, seqid, iprot, oprot):
    args = createTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = createTable_result()
    try:
      self._handler.createTable(args.tableName, args.columnFamilies)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    except AlreadyExists as exist:
      result.exist = exist
    oprot.writeMessageBegin("createTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteTable(self, seqid, iprot, oprot):
    args = deleteTable_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteTable_result()
    try:
      self._handler.deleteTable(args.tableName)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteTable", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_get(self, seqid, iprot, oprot):
    args = get_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = get_result()
    try:
      result.success = self._handler.get(args.tableName, args.row, args.column)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("get", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVer(self, seqid, iprot, oprot):
    args = getVer_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVer_result()
    try:
      result.success = self._handler.getVer(args.tableName, args.row, args.column, args.numVersions)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVer", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getVerTs(self, seqid, iprot, oprot):
    args = getVerTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getVerTs_result()
    try:
      result.success = self._handler.getVerTs(args.tableName, args.row, args.column, args.timestamp, args.numVersions)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getVerTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRow(self, seqid, iprot, oprot):
    args = getRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRow_result()
    try:
      result.success = self._handler.getRow(args.tableName, args.row)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumns(self, seqid, iprot, oprot):
    args = getRowWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumns_result()
    try:
      result.success = self._handler.getRowWithColumns(args.tableName, args.row, args.columns)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowTs(self, seqid, iprot, oprot):
    args = getRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowTs_result()
    try:
      result.success = self._handler.getRowTs(args.tableName, args.row, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowWithColumnsTs_result()
    try:
      result.success = self._handler.getRowWithColumnsTs(args.tableName, args.row, args.columns, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRows(self, seqid, iprot, oprot):
    args = getRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRows_result()
    try:
      result.success = self._handler.getRows(args.tableName, args.rows)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumns(self, seqid, iprot, oprot):
    args = getRowsWithColumns_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumns_result()
    try:
      result.success = self._handler.getRowsWithColumns(args.tableName, args.rows, args.columns)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumns", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsTs(self, seqid, iprot, oprot):
    args = getRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsTs_result()
    try:
      result.success = self._handler.getRowsTs(args.tableName, args.rows, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_getRowsWithColumnsTs(self, seqid, iprot, oprot):
    args = getRowsWithColumnsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = getRowsWithColumnsTs_result()
    try:
      result.success = self._handler.getRowsWithColumnsTs(args.tableName, args.rows, args.columns, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("getRowsWithColumnsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRow(self, seqid, iprot, oprot):
    args = mutateRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRow_result()
    try:
      self._handler.mutateRow(args.tableName, args.row, args.mutations)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowTs(self, seqid, iprot, oprot):
    args = mutateRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowTs_result()
    try:
      self._handler.mutateRowTs(args.tableName, args.row, args.mutations, args.timestamp)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRows(self, seqid, iprot, oprot):
    args = mutateRows_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRows_result()
    try:
      self._handler.mutateRows(args.tableName, args.rowBatches)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRows", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_mutateRowsTs(self, seqid, iprot, oprot):
    args = mutateRowsTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = mutateRowsTs_result()
    try:
      self._handler.mutateRowsTs(args.tableName, args.rowBatches, args.timestamp)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("mutateRowsTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_atomicIncrement(self, seqid, iprot, oprot):
    args = atomicIncrement_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = atomicIncrement_result()
    try:
      result.success = self._handler.atomicIncrement(args.tableName, args.row, args.column, args.value)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("atomicIncrement", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAll(self, seqid, iprot, oprot):
    args = deleteAll_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAll_result()
    try:
      self._handler.deleteAll(args.tableName, args.row, args.column)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAll", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllTs(self, seqid, iprot, oprot):
    args = deleteAllTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllTs_result()
    try:
      self._handler.deleteAllTs(args.tableName, args.row, args.column, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRow(self, seqid, iprot, oprot):
    args = deleteAllRow_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRow_result()
    try:
      self._handler.deleteAllRow(args.tableName, args.row)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRow", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_deleteAllRowTs(self, seqid, iprot, oprot):
    args = deleteAllRowTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = deleteAllRowTs_result()
    try:
      self._handler.deleteAllRowTs(args.tableName, args.row, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("deleteAllRowTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithScan(self, seqid, iprot, oprot):
    args = scannerOpenWithScan_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithScan_result()
    try:
      result.success = self._handler.scannerOpenWithScan(args.tableName, args.scan)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithScan", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpen(self, seqid, iprot, oprot):
    args = scannerOpen_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpen_result()
    try:
      result.success = self._handler.scannerOpen(args.tableName, args.startRow, args.columns)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpen", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStop(self, seqid, iprot, oprot):
    args = scannerOpenWithStop_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStop_result()
    try:
      result.success = self._handler.scannerOpenWithStop(args.tableName, args.startRow, args.stopRow, args.columns)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStop", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithPrefix(self, seqid, iprot, oprot):
    args = scannerOpenWithPrefix_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithPrefix_result()
    try:
      result.success = self._handler.scannerOpenWithPrefix(args.tableName, args.startAndPrefix, args.columns)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithPrefix", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenTs(self, seqid, iprot, oprot):
    args = scannerOpenTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenTs_result()
    try:
      result.success = self._handler.scannerOpenTs(args.tableName, args.startRow, args.columns, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerOpenWithStopTs(self, seqid, iprot, oprot):
    args = scannerOpenWithStopTs_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerOpenWithStopTs_result()
    try:
      result.success = self._handler.scannerOpenWithStopTs(args.tableName, args.startRow, args.stopRow, args.columns, args.timestamp)
    except IOError as io:
      result.io = io
    oprot.writeMessageBegin("scannerOpenWithStopTs", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGet(self, seqid, iprot, oprot):
    args = scannerGet_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGet_result()
    try:
      result.success = self._handler.scannerGet(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGet", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerGetList(self, seqid, iprot, oprot):
    args = scannerGetList_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerGetList_result()
    try:
      result.success = self._handler.scannerGetList(args.id, args.nbRows)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerGetList", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()

  def process_scannerClose(self, seqid, iprot, oprot):
    args = scannerClose_args()
    args.read(iprot)
    iprot.readMessageEnd()
    result = scannerClose_result()
    try:
      self._handler.scannerClose(args.id)
    except IOError as io:
      result.io = io
    except IllegalArgument as ia:
      result.ia = ia
    oprot.writeMessageBegin("scannerClose", TMessageType.REPLY, seqid)
    result.write(oprot)
    oprot.writeMessageEnd()
    oprot.trans.flush()


# HELPER FUNCTIONS AND STRUCTURES

class enableTable_args(object):
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class enableTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('enableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_args(object):
  """
  Attributes:
   - tableName: name of the table
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class disableTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('disableTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_args(object):
  """
  Attributes:
   - tableName: name of the table to check
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class isTableEnabled_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.BOOL, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.BOOL:
          self.success = iprot.readBool();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('isTableEnabled_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.BOOL, 0)
      oprot.writeBool(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_args(object):
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class compact_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('compact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_args(object):
  """
  Attributes:
   - tableNameOrRegionName
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableNameOrRegionName', None, None, ), # 1
  )

  def __init__(self, tableNameOrRegionName=None,):
    self.tableNameOrRegionName = tableNameOrRegionName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableNameOrRegionName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_args')
    if self.tableNameOrRegionName is not None:
      oprot.writeFieldBegin('tableNameOrRegionName', TType.STRING, 1)
      oprot.writeString(self.tableNameOrRegionName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class majorCompact_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('majorCompact_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_args(object):

  thrift_spec = (
  )

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_args')
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableNames_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRING,None), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype26, _size23) = iprot.readListBegin()
          for _i27 in xrange(_size23):
            _elem28 = iprot.readString();
            self.success.append(_elem28)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableNames_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRING, len(self.success))
      for iter29 in self.success:
        oprot.writeString(iter29)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_args(object):
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getColumnDescriptors_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.MAP, 'success', (TType.STRING,None,TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.MAP:
          self.success = {}
          (_ktype31, _vtype32, _size30 ) = iprot.readMapBegin() 
          for _i34 in xrange(_size30):
            _key35 = iprot.readString();
            _val36 = ColumnDescriptor()
            _val36.read(iprot)
            self.success[_key35] = _val36
          iprot.readMapEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getColumnDescriptors_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.MAP, 0)
      oprot.writeMapBegin(TType.STRING, TType.STRUCT, len(self.success))
      for kiter37,viter38 in self.success.items():
        oprot.writeString(kiter37)
        viter38.write(oprot)
      oprot.writeMapEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_args(object):
  """
  Attributes:
   - tableName: table name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getTableRegions_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRegionInfo, TRegionInfo.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype42, _size39) = iprot.readListBegin()
          for _i43 in xrange(_size39):
            _elem44 = TRegionInfo()
            _elem44.read(iprot)
            self.success.append(_elem44)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getTableRegions_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter45 in self.success:
        iter45.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_args(object):
  """
  Attributes:
   - tableName: name of table to create
   - columnFamilies: list of column family descriptors
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'columnFamilies', (TType.STRUCT,(ColumnDescriptor, ColumnDescriptor.thrift_spec)), None, ), # 2
  )

  def __init__(self, tableName=None, columnFamilies=None,):
    self.tableName = tableName
    self.columnFamilies = columnFamilies

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.columnFamilies = []
          (_etype49, _size46) = iprot.readListBegin()
          for _i50 in xrange(_size46):
            _elem51 = ColumnDescriptor()
            _elem51.read(iprot)
            self.columnFamilies.append(_elem51)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.columnFamilies is not None:
      oprot.writeFieldBegin('columnFamilies', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.columnFamilies))
      for iter52 in self.columnFamilies:
        iter52.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class createTable_result(object):
  """
  Attributes:
   - io
   - ia
   - exist
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
    (3, TType.STRUCT, 'exist', (AlreadyExists, AlreadyExists.thrift_spec), None, ), # 3
  )

  def __init__(self, io=None, ia=None, exist=None,):
    self.io = io
    self.ia = ia
    self.exist = exist

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRUCT:
          self.exist = AlreadyExists()
          self.exist.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('createTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    if self.exist is not None:
      oprot.writeFieldBegin('exist', TType.STRUCT, 3)
      self.exist.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_args(object):
  """
  Attributes:
   - tableName: name of table to delete
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
  )

  def __init__(self, tableName=None,):
    self.tableName = tableName

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteTable_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteTable_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, column=None,):
    self.tableName = tableName
    self.row = row
    self.column = column

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class get_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype56, _size53) = iprot.readListBegin()
          for _i57 in xrange(_size53):
            _elem58 = TCell()
            _elem58.read(iprot)
            self.success.append(_elem58)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('get_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter59 in self.success:
        iter59.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - numVersions: number of versions to retrieve
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I32, 'numVersions', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, numVersions=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.numVersions = numVersions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 4)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVer_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype63, _size60) = iprot.readListBegin()
          for _i64 in xrange(_size60):
            _elem65 = TCell()
            _elem65.read(iprot)
            self.success.append(_elem65)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVer_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter66 in self.success:
        iter66.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - column: column name
   - timestamp: timestamp
   - numVersions: number of versions to retrieve
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
    (5, TType.I32, 'numVersions', None, None, ), # 5
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None, numVersions=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp
    self.numVersions = numVersions

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I32:
          self.numVersions = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    if self.numVersions is not None:
      oprot.writeFieldBegin('numVersions', TType.I32, 5)
      oprot.writeI32(self.numVersions)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getVerTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TCell, TCell.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype70, _size67) = iprot.readListBegin()
          for _i71 in xrange(_size67):
            _elem72 = TCell()
            _elem72.read(iprot)
            self.success.append(_elem72)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getVerTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter73 in self.success:
        iter73.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
  )

  def __init__(self, tableName=None, row=None,):
    self.tableName = tableName
    self.row = row

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRow_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype77, _size74) = iprot.readListBegin()
          for _i78 in xrange(_size74):
            _elem79 = TRowResult()
            _elem79.read(iprot)
            self.success.append(_elem79)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRow_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter80 in self.success:
        iter80.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, columns=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype84, _size81) = iprot.readListBegin()
          for _i85 in xrange(_size81):
            _elem86 = iprot.readString();
            self.columns.append(_elem86)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter87 in self.columns:
        oprot.writeString(iter87)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumns_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype91, _size88) = iprot.readListBegin()
          for _i92 in xrange(_size88):
            _elem93 = TRowResult()
            _elem93.read(iprot)
            self.success.append(_elem93)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter94 in self.success:
        iter94.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_args(object):
  """
  Attributes:
   - tableName: name of the table
   - row: row key
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, timestamp=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype98, _size95) = iprot.readListBegin()
          for _i99 in xrange(_size95):
            _elem100 = TRowResult()
            _elem100.read(iprot)
            self.success.append(_elem100)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter101 in self.success:
        iter101.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - columns: List of columns to return, null for all columns
   - timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, columns=None, timestamp=None,):
    self.tableName = tableName
    self.row = row
    self.columns = columns
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype105, _size102) = iprot.readListBegin()
          for _i106 in xrange(_size102):
            _elem107 = iprot.readString();
            self.columns.append(_elem107)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter108 in self.columns:
        oprot.writeString(iter108)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowWithColumnsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype112, _size109) = iprot.readListBegin()
          for _i113 in xrange(_size109):
            _elem114 = TRowResult()
            _elem114.read(iprot)
            self.success.append(_elem114)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter115 in self.success:
        iter115.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
  )

  def __init__(self, tableName=None, rows=None,):
    self.tableName = tableName
    self.rows = rows

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype119, _size116) = iprot.readListBegin()
          for _i120 in xrange(_size116):
            _elem121 = iprot.readString();
            self.rows.append(_elem121)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter122 in self.rows:
        oprot.writeString(iter122)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRows_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype126, _size123) = iprot.readListBegin()
          for _i127 in xrange(_size123):
            _elem128 = TRowResult()
            _elem128.read(iprot)
            self.success.append(_elem128)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRows_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter129 in self.success:
        iter129.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, rows=None, columns=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype133, _size130) = iprot.readListBegin()
          for _i134 in xrange(_size130):
            _elem135 = iprot.readString();
            self.rows.append(_elem135)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype139, _size136) = iprot.readListBegin()
          for _i140 in xrange(_size136):
            _elem141 = iprot.readString();
            self.columns.append(_elem141)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter142 in self.rows:
        oprot.writeString(iter142)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter143 in self.columns:
        oprot.writeString(iter143)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumns_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype147, _size144) = iprot.readListBegin()
          for _i148 in xrange(_size144):
            _elem149 = TRowResult()
            _elem149.read(iprot)
            self.success.append(_elem149)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumns_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter150 in self.success:
        iter150.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_args(object):
  """
  Attributes:
   - tableName: name of the table
   - rows: row keys
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
  )

  def __init__(self, tableName=None, rows=None, timestamp=None,):
    self.tableName = tableName
    self.rows = rows
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype154, _size151) = iprot.readListBegin()
          for _i155 in xrange(_size151):
            _elem156 = iprot.readString();
            self.rows.append(_elem156)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter157 in self.rows:
        oprot.writeString(iter157)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype161, _size158) = iprot.readListBegin()
          for _i162 in xrange(_size158):
            _elem163 = TRowResult()
            _elem163.read(iprot)
            self.success.append(_elem163)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter164 in self.success:
        iter164.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - rows: row keys
   - columns: List of columns to return, null for all columns
   - timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rows', (TType.STRING,None), None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
  )

  def __init__(self, tableName=None, rows=None, columns=None, timestamp=None,):
    self.tableName = tableName
    self.rows = rows
    self.columns = columns
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rows = []
          (_etype168, _size165) = iprot.readListBegin()
          for _i169 in xrange(_size165):
            _elem170 = iprot.readString();
            self.rows.append(_elem170)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype174, _size171) = iprot.readListBegin()
          for _i175 in xrange(_size171):
            _elem176 = iprot.readString();
            self.columns.append(_elem176)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rows is not None:
      oprot.writeFieldBegin('rows', TType.LIST, 2)
      oprot.writeListBegin(TType.STRING, len(self.rows))
      for iter177 in self.rows:
        oprot.writeString(iter177)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter178 in self.columns:
        oprot.writeString(iter178)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class getRowsWithColumnsTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype182, _size179) = iprot.readListBegin()
          for _i183 in xrange(_size179):
            _elem184 = TRowResult()
            _elem184.read(iprot)
            self.success.append(_elem184)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('getRowsWithColumnsTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter185 in self.success:
        iter185.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
  )

  def __init__(self, tableName=None, row=None, mutations=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype189, _size186) = iprot.readListBegin()
          for _i190 in xrange(_size186):
            _elem191 = Mutation()
            _elem191.read(iprot)
            self.mutations.append(_elem191)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter192 in self.mutations:
        iter192.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRow_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row key
   - mutations: list of mutation commands
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.LIST, 'mutations', (TType.STRUCT,(Mutation, Mutation.thrift_spec)), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, mutations=None, timestamp=None,):
    self.tableName = tableName
    self.row = row
    self.mutations = mutations
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.mutations = []
          (_etype196, _size193) = iprot.readListBegin()
          for _i197 in xrange(_size193):
            _elem198 = Mutation()
            _elem198.read(iprot)
            self.mutations.append(_elem198)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.mutations is not None:
      oprot.writeFieldBegin('mutations', TType.LIST, 3)
      oprot.writeListBegin(TType.STRUCT, len(self.mutations))
      for iter199 in self.mutations:
        iter199.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowTs_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_args(object):
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
  )

  def __init__(self, tableName=None, rowBatches=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype203, _size200) = iprot.readListBegin()
          for _i204 in xrange(_size200):
            _elem205 = BatchMutation()
            _elem205.read(iprot)
            self.rowBatches.append(_elem205)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter206 in self.rowBatches:
        iter206.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRows_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRows_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - rowBatches: list of row batches
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.LIST, 'rowBatches', (TType.STRUCT,(BatchMutation, BatchMutation.thrift_spec)), None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
  )

  def __init__(self, tableName=None, rowBatches=None, timestamp=None,):
    self.tableName = tableName
    self.rowBatches = rowBatches
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.LIST:
          self.rowBatches = []
          (_etype210, _size207) = iprot.readListBegin()
          for _i211 in xrange(_size207):
            _elem212 = BatchMutation()
            _elem212.read(iprot)
            self.rowBatches.append(_elem212)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.rowBatches is not None:
      oprot.writeFieldBegin('rowBatches', TType.LIST, 2)
      oprot.writeListBegin(TType.STRUCT, len(self.rowBatches))
      for iter213 in self.rowBatches:
        iter213.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class mutateRowsTs_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('mutateRowsTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: row to increment
   - column: name of column
   - value: amount to increment by
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'value', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, value=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.value = value

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.value = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.value is not None:
      oprot.writeFieldBegin('value', TType.I64, 4)
      oprot.writeI64(self.value)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class atomicIncrement_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.I64, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I64:
          self.success = iprot.readI64();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('atomicIncrement_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I64, 0)
      oprot.writeI64(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, column=None,):
    self.tableName = tableName
    self.row = row
    self.column = column

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAll_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAll_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: Row to update
   - column: name of column whose value is to be deleted
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.STRING, 'column', None, None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
  )

  def __init__(self, tableName=None, row=None, column=None, timestamp=None,):
    self.tableName = tableName
    self.row = row
    self.column = column
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.column = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.column is not None:
      oprot.writeFieldBegin('column', TType.STRING, 3)
      oprot.writeString(self.column)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllTs_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
  )

  def __init__(self, tableName=None, row=None,):
    self.tableName = tableName
    self.row = row

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRow_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRow_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - row: key of the row to be completely deleted.
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'row', None, None, ), # 2
    (3, TType.I64, 'timestamp', None, None, ), # 3
  )

  def __init__(self, tableName=None, row=None, timestamp=None,):
    self.tableName = tableName
    self.row = row
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.row = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.row is not None:
      oprot.writeFieldBegin('row', TType.STRING, 2)
      oprot.writeString(self.row)
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 3)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class deleteAllRowTs_result(object):
  """
  Attributes:
   - io
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, io=None,):
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('deleteAllRowTs_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_args(object):
  """
  Attributes:
   - tableName: name of table
   - scan: Scan instance
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRUCT, 'scan', (TScan, TScan.thrift_spec), None, ), # 2
  )

  def __init__(self, tableName=None, scan=None,):
    self.tableName = tableName
    self.scan = scan

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.scan = TScan()
          self.scan.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.scan is not None:
      oprot.writeFieldBegin('scan', TType.STRUCT, 2)
      self.scan.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithScan_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithScan_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, startRow=None, columns=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype217, _size214) = iprot.readListBegin()
          for _i218 in xrange(_size214):
            _elem219 = iprot.readString();
            self.columns.append(_elem219)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter220 in self.columns:
        oprot.writeString(iter220)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpen_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpen_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype224, _size221) = iprot.readListBegin()
          for _i225 in xrange(_size221):
            _elem226 = iprot.readString();
            self.columns.append(_elem226)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter227 in self.columns:
        oprot.writeString(iter227)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStop_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStop_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_args(object):
  """
  Attributes:
   - tableName: name of table
   - startAndPrefix: the prefix (and thus start row) of the keys you want
   - columns: the columns you want returned
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startAndPrefix', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
  )

  def __init__(self, tableName=None, startAndPrefix=None, columns=None,):
    self.tableName = tableName
    self.startAndPrefix = startAndPrefix
    self.columns = columns

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startAndPrefix = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype231, _size228) = iprot.readListBegin()
          for _i232 in xrange(_size228):
            _elem233 = iprot.readString();
            self.columns.append(_elem233)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startAndPrefix is not None:
      oprot.writeFieldBegin('startAndPrefix', TType.STRING, 2)
      oprot.writeString(self.startAndPrefix)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter234 in self.columns:
        oprot.writeString(iter234)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithPrefix_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithPrefix_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.LIST, 'columns', (TType.STRING,None), None, ), # 3
    (4, TType.I64, 'timestamp', None, None, ), # 4
  )

  def __init__(self, tableName=None, startRow=None, columns=None, timestamp=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.columns = columns
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.LIST:
          self.columns = []
          (_etype238, _size235) = iprot.readListBegin()
          for _i239 in xrange(_size235):
            _elem240 = iprot.readString();
            self.columns.append(_elem240)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 3)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter241 in self.columns:
        oprot.writeString(iter241)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 4)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_args(object):
  """
  Attributes:
   - tableName: name of table
   - startRow: Starting row in table to scan.
  Send "" (empty string) to start at the first row.
   - stopRow: row to stop scanning on. This row is *not* included in the
  scanner's results
   - columns: columns to scan. If column name is a column family, all
  columns of the specified column family are returned. It's also possible
  to pass a regex in the column qualifier.
   - timestamp: timestamp
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRING, 'tableName', None, None, ), # 1
    (2, TType.STRING, 'startRow', None, None, ), # 2
    (3, TType.STRING, 'stopRow', None, None, ), # 3
    (4, TType.LIST, 'columns', (TType.STRING,None), None, ), # 4
    (5, TType.I64, 'timestamp', None, None, ), # 5
  )

  def __init__(self, tableName=None, startRow=None, stopRow=None, columns=None, timestamp=None,):
    self.tableName = tableName
    self.startRow = startRow
    self.stopRow = stopRow
    self.columns = columns
    self.timestamp = timestamp

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRING:
          self.tableName = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRING:
          self.startRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 3:
        if ftype == TType.STRING:
          self.stopRow = iprot.readString();
        else:
          iprot.skip(ftype)
      elif fid == 4:
        if ftype == TType.LIST:
          self.columns = []
          (_etype245, _size242) = iprot.readListBegin()
          for _i246 in xrange(_size242):
            _elem247 = iprot.readString();
            self.columns.append(_elem247)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 5:
        if ftype == TType.I64:
          self.timestamp = iprot.readI64();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_args')
    if self.tableName is not None:
      oprot.writeFieldBegin('tableName', TType.STRING, 1)
      oprot.writeString(self.tableName)
      oprot.writeFieldEnd()
    if self.startRow is not None:
      oprot.writeFieldBegin('startRow', TType.STRING, 2)
      oprot.writeString(self.startRow)
      oprot.writeFieldEnd()
    if self.stopRow is not None:
      oprot.writeFieldBegin('stopRow', TType.STRING, 3)
      oprot.writeString(self.stopRow)
      oprot.writeFieldEnd()
    if self.columns is not None:
      oprot.writeFieldBegin('columns', TType.LIST, 4)
      oprot.writeListBegin(TType.STRING, len(self.columns))
      for iter248 in self.columns:
        oprot.writeString(iter248)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.timestamp is not None:
      oprot.writeFieldBegin('timestamp', TType.I64, 5)
      oprot.writeI64(self.timestamp)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerOpenWithStopTs_result(object):
  """
  Attributes:
   - success
   - io
  """

  thrift_spec = (
    (0, TType.I32, 'success', None, None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
  )

  def __init__(self, success=None, io=None,):
    self.success = success
    self.io = io

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.I32:
          self.success = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerOpenWithStopTs_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.I32, 0)
      oprot.writeI32(self.success)
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGet_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype252, _size249) = iprot.readListBegin()
          for _i253 in xrange(_size249):
            _elem254 = TRowResult()
            _elem254.read(iprot)
            self.success.append(_elem254)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGet_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter255 in self.success:
        iter255.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
   - nbRows: number of results to return
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
    (2, TType.I32, 'nbRows', None, None, ), # 2
  )

  def __init__(self, id=None, nbRows=None,):
    self.id = id
    self.nbRows = nbRows

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.I32:
          self.nbRows = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    if self.nbRows is not None:
      oprot.writeFieldBegin('nbRows', TType.I32, 2)
      oprot.writeI32(self.nbRows)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerGetList_result(object):
  """
  Attributes:
   - success
   - io
   - ia
  """

  thrift_spec = (
    (0, TType.LIST, 'success', (TType.STRUCT,(TRowResult, TRowResult.thrift_spec)), None, ), # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, success=None, io=None, ia=None,):
    self.success = success
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 0:
        if ftype == TType.LIST:
          self.success = []
          (_etype259, _size256) = iprot.readListBegin()
          for _i260 in xrange(_size256):
            _elem261 = TRowResult()
            _elem261.read(iprot)
            self.success.append(_elem261)
          iprot.readListEnd()
        else:
          iprot.skip(ftype)
      elif fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerGetList_result')
    if self.success is not None:
      oprot.writeFieldBegin('success', TType.LIST, 0)
      oprot.writeListBegin(TType.STRUCT, len(self.success))
      for iter262 in self.success:
        iter262.write(oprot)
      oprot.writeListEnd()
      oprot.writeFieldEnd()
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_args(object):
  """
  Attributes:
   - id: id of a scanner returned by scannerOpen
  """

  thrift_spec = (
    None, # 0
    (1, TType.I32, 'id', None, None, ), # 1
  )

  def __init__(self, id=None,):
    self.id = id

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.I32:
          self.id = iprot.readI32();
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_args')
    if self.id is not None:
      oprot.writeFieldBegin('id', TType.I32, 1)
      oprot.writeI32(self.id)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)

class scannerClose_result(object):
  """
  Attributes:
   - io
   - ia
  """

  thrift_spec = (
    None, # 0
    (1, TType.STRUCT, 'io', (IOError, IOError.thrift_spec), None, ), # 1
    (2, TType.STRUCT, 'ia', (IllegalArgument, IllegalArgument.thrift_spec), None, ), # 2
  )

  def __init__(self, io=None, ia=None,):
    self.io = io
    self.ia = ia

  def read(self, iprot):
    if iprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and isinstance(iprot.trans, TTransport.CReadableTransport) and self.thrift_spec is not None and fastbinary is not None:
      fastbinary.decode_binary(self, iprot.trans, (self.__class__, self.thrift_spec))
      return
    iprot.readStructBegin()
    while True:
      (fname, ftype, fid) = iprot.readFieldBegin()
      if ftype == TType.STOP:
        break
      if fid == 1:
        if ftype == TType.STRUCT:
          self.io = IOError()
          self.io.read(iprot)
        else:
          iprot.skip(ftype)
      elif fid == 2:
        if ftype == TType.STRUCT:
          self.ia = IllegalArgument()
          self.ia.read(iprot)
        else:
          iprot.skip(ftype)
      else:
        iprot.skip(ftype)
      iprot.readFieldEnd()
    iprot.readStructEnd()

  def write(self, oprot):
    if oprot.__class__ == TBinaryProtocol.TBinaryProtocolAccelerated and self.thrift_spec is not None and fastbinary is not None:
      oprot.trans.write(fastbinary.encode_binary(self, (self.__class__, self.thrift_spec)))
      return
    oprot.writeStructBegin('scannerClose_result')
    if self.io is not None:
      oprot.writeFieldBegin('io', TType.STRUCT, 1)
      self.io.write(oprot)
      oprot.writeFieldEnd()
    if self.ia is not None:
      oprot.writeFieldBegin('ia', TType.STRUCT, 2)
      self.ia.write(oprot)
      oprot.writeFieldEnd()
    oprot.writeFieldStop()
    oprot.writeStructEnd()

  def validate(self):
    return


  def __repr__(self):
    L = ['%s=%r' % (key, value)
      for key, value in self.__dict__.iteritems()]
    return '%s(%s)' % (self.__class__.__name__, ', '.join(L))

  def __eq__(self, other):
    return isinstance(other, self.__class__) and self.__dict__ == other.__dict__

  def __ne__(self, other):
    return not (self == other)
