/*
    This code (with some modifications) is from GNU Parted
    Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.
*/

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdlib.h>
#include <string.h>

#include <reiserfs/reiserfs.h>

#if ENABLE_NLS
#  include <libintl.h>
#  define _(String) dgettext (PACKAGE, String)
#else
#  define _(String) (String)
#endif

int libreiserfs_get_max_interface_version(void) {
    return LIBREISERFS_MAX_INTERFACE_VERSION;
}

int libreiserfs_get_min_interface_version(void) {
    return LIBREISERFS_MIN_INTERFACE_VERSION;
}

const char *libreiserfs_get_version(void) {
    return VERSION;
}

static void _init(void) __attribute__ ((constructor));

static void _init(void) {
#ifdef ENABLE_NLS
    bindtextdomain(PACKAGE, LOCALEDIR);
#endif
}

void *libreiserfs_malloc(size_t size) {
    void *mem;

    if (!(mem = (void *)malloc(size))) {
	libreiserfs_exception_throw(EXCEPTION_FATAL, EXCEPTION_CANCEL,
	    _("Out of memory."));
	return NULL;
    }

    return mem;
}

void *libreiserfs_calloc(size_t size, char c) {
    void *mem;

    if (!(mem = libreiserfs_malloc(size)))
	return NULL;
    memset(mem, c, size);

    return mem;
}

int libreiserfs_realloc(void** old, size_t size) {
    void *mem;

    if (!(mem = (void *)realloc(*old, size))) {
	libreiserfs_exception_throw(EXCEPTION_FATAL, EXCEPTION_CANCEL,
	    _("Out of memory."));
	return 0;
    }
    *old = mem;
    return 1;
}

void libreiserfs_free(void* ptr) {
    free(ptr);
}
