/*
    This code (with some modifications) is from GNU Parted
    Copyright (C) 1999, 2000, 2001 Free Software Foundation, Inc.
*/

#ifndef REISERFS_H
#define REISERFS_H

#ifdef __cplusplus
extern "C" {
#endif

#if !defined(__GNUC__) && (defined(__sparc__) || defined(__sparc_v9__))
#	include <sys/int_types.h>
#else /* GNU C or not sparc */
#	include <stdint.h>
#endif

#include "block.h"
#include "bitmap.h"
#include "journal.h"
#include "key.h"
#include "endian.h"
#include "filesystem.h"
#include "tree.h"
#include "tools.h"
#include "exception.h"
#include "geom.h"
#include "object.h"
#include "gauge.h"
#include "path.h"
#include "dir.h"
#include "file.h"
#include "core.h"

extern int libreiserfs_get_max_interface_version(void);
extern int libreiserfs_get_min_interface_version(void);
extern const char *libreiserfs_get_version(void);

extern void* libreiserfs_malloc(size_t size);
extern void *libreiserfs_calloc(size_t size, char c);
extern int libreiserfs_realloc(void** ptr, size_t size);
extern void libreiserfs_free(void* ptr);

#ifdef __cplusplus
}
#endif

#endif

