/*
    geom.h -- filesystem geometry functions
    Copyright (C) 2001, 2002 Yury Umanets <torque@ukrpost.net>, see COPYING for 
    licensing and copyright details.
*/

#ifndef GEOM_H
#define GEOM_H

#include <dal/dal.h>

#include "gauge.h"

struct reiserfs_geom {
    dal_t *dal;
    blk_t start, end;
};

typedef struct reiserfs_geom reiserfs_geom_t;

extern reiserfs_geom_t *reiserfs_geom_create(dal_t *dal, blk_t start, blk_t end);
extern int reiserfs_geom_init(reiserfs_geom_t *geom, dal_t *dal, blk_t start, blk_t end);

extern void reiserfs_geom_free(reiserfs_geom_t *geom);    

extern int reiserfs_geom_fill(reiserfs_geom_t *geom, char c, reiserfs_gauge_t *gauge);

extern blk_t reiserfs_geom_relocate(reiserfs_fs_t *dst_fs, reiserfs_geom_t *dst_geom, 
    reiserfs_fs_t *src_fs, reiserfs_geom_t *src_geom, reiserfs_gauge_t *gauge);

extern int reiserfs_geom_test_inside(reiserfs_geom_t *geom, blk_t blk);
extern int reiserfs_geom_test_overlap(reiserfs_geom_t *geom1, reiserfs_geom_t *geom2);

extern blk_t reiserfs_geom_len(reiserfs_geom_t *geom);

#endif

