#!/bin/sh

PACKAGE=pppoeconf
DIR=../..

set -e

bash --dump-po-strings $DIR/$PACKAGE > pppoeconf.pot
cp pppoeconf.pot templates.pot

if [ "$1" == "clean" ] ; then
   echo Removing garbage...
   rm -rf usr *.old.* *~ *.mo
   exit 0
fi


if test "$1" && test -e $1 ; then 
   list=$1
else
   list="$( ls *.po | grep -v old )"
fi

for lang in $list ; do
   x=${lang%.po}
   cp -f $x.po $x.old.po
   echo -n "Updating and compiling $x.po"
   msgmerge $x.old.po pppoeconf.pot > $x.po~ && mv $x.po~ $x.po
   msgfmt --statistics $x.po
   mkdir -p usr/share/locale/$x/LC_MESSAGES
   msgfmt -o usr/share/locale/$x/LC_MESSAGES/$PACKAGE.mo $x.po
   
done
