include /usr/share/cdbs/1/class/cmake.mk

# Include default KDE 4 cmake configuration variables
include /usr/share/pkg-kde-tools/makefiles/1/variables.mk
# Pass standard KDE 4 flags to cmake via appropriate CDBS variable
DEB_CMAKE_EXTRA_FLAGS += $(DEB_CMAKE_KDE4_FLAGS) $(DEB_CMAKE_CUSTOM_FLAGS)

DEB_COMPRESS_EXCLUDE = .dcl .docbook -license .tag .sty .el

clean::
	rm -rf po/*.pot
	# clean up edited .desktop etc files
	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  for file in `cat LIST`; do \
	     sed -i '/X-Ubuntu-Gettext-Domain=/d' $${file}; \
	  done; \
	  rm -f LIST; \
	fi

#Kubuntu specific, Launchpad translations support, create .pot translation templates
common-install-prehook-impl::
	mkdir -p po
	extract-messages.sh
	-for file in po/*pot; do \
		sed "s/charset=CHARSET/charset=UTF-8/" -i $$file; \
	done

	# generate .po files for .desktop etc files
	if [ -z $${KUBUNTU_DESKTOP_POT} ]; then \
		KUBUNTU_DESKTOP_POT=$(DEB_SOURCE_PACKAGE); \
	fi; \
	echo KUBUNTU_DESKTOP_POT: $${KUBUNTU_DESKTOP_POT}; \
	if [ -f /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl ]; then \
	  sh /usr/lib/kubuntu-desktop-i18n/findfiles LIST; \
	  cat LIST; \
	  perl /usr/lib/kubuntu-desktop-i18n/createdesktopcontext.pl --file-list=LIST --base-dir=. > desktop.$${KUBUNTU_DESKTOP_POT}.tmp; \
	  msguniq --to-code=UTF-8 --no-wrap -o desktop.$${KUBUNTU_DESKTOP_POT} desktop.$${KUBUNTU_DESKTOP_POT}.tmp 2>/dev/null; \
	  python /usr/lib/kubuntu-desktop-i18n/msgsplit desktop.$${KUBUNTU_DESKTOP_POT}; \
	  mv desktop.$${KUBUNTU_DESKTOP_POT} po/desktop_$${KUBUNTU_DESKTOP_POT}.pot; \
	  rm -f desktop.$${KUBUNTU_DESKTOP_POT} desktop.$${KUBUNTU_DESKTOP_POT}.tmp; \
	  # add translation domain to files \
	  for file in `cat LIST`; do \
	    echo X-Ubuntu-Gettext-Domain=desktop_$${KUBUNTU_DESKTOP_POT} >> $${file}; \
	  done; \
	  rm -f LIST; \
	fi
