/*
 * This file was generated automatically by ExtUtils::ParseXS version 2.18_02 from the
 * contents of Pilot.xs. Do not edit this file, edit Pilot.xs instead.
 *
 *	ANY CHANGES MADE HERE WILL BE LOST! 
 *
 */

#line 1 "Pilot.xs"
/*
 * Pilot.xs - Interface pilot-link library with Perl.
 *
 * Copyright (C) 1997, 1998, Kenneth Albanowski
 *
 * This library is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library
 * General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this library; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA. *
 */

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"
#include "patchlevel.h"

/* FIXME Hack to get around a perl macro problem with calling the type 'int
   dirty;' in pi-mail.h and pi-todo.h. This originally showed up with perl
   5.6 and gcc-3.x, and was fixed in gcc, but now appears in perl 5.8 with
   gcc-3.x. It smells like another internal macro being exposed into
   userland. */
#undef dirty

#include "pi-macros.h"
#include "pi-buffer.h"
#include "pi-file.h"
#include "pi-datebook.h"
#include "pi-memo.h"
#include "pi-expense.h"
#include "pi-address.h"
#include "pi-todo.h"
#include "pi-mail.h"
#include "pi-socket.h"
#include "pi-dlp.h"
#include "pi-syspkt.h"
#include "pi-error.h"
#include "pi-version.h"

#include "const-c.inc"


typedef unsigned char * CPTR;

static unsigned char mybuf[0xffff];
static pi_buffer_t pibuf = {NULL, 0, 0};

static AV * tmtoav (struct tm * t) {
	AV * ret = newAV();
	
	av_push(ret, newSViv(t->tm_sec));
	av_push(ret, newSViv(t->tm_min));
	av_push(ret, newSViv(t->tm_hour));
	av_push(ret, newSViv(t->tm_mday));
	av_push(ret, newSViv(t->tm_mon));
	av_push(ret, newSViv(t->tm_year));
	av_push(ret, newSViv(t->tm_wday));
	av_push(ret, newSViv(t->tm_yday));
	av_push(ret, newSViv(t->tm_isdst));
	
	return ret;
}

struct tm * avtotm (AV * av, struct tm * t) {
	SV ** s;
	t->tm_sec 	= (s = av_fetch(av, 0, 0)) ? SvIV(*s) : 0;
	t->tm_min 	= (s = av_fetch(av, 1, 0)) ? SvIV(*s) : 0;
	t->tm_hour 	= (s = av_fetch(av, 2, 0)) ? SvIV(*s) : 0;
	t->tm_mday 	= (s = av_fetch(av, 3, 0)) ? SvIV(*s) : 0;
	t->tm_mon 	= (s = av_fetch(av, 4, 0)) ? SvIV(*s) : 0;
	t->tm_year 	= (s = av_fetch(av, 5, 0)) ? SvIV(*s) : 0;
	t->tm_wday	= (s = av_fetch(av, 6, 0)) ? SvIV(*s) : 0;
	t->tm_yday	= (s = av_fetch(av, 7, 0)) ? SvIV(*s) : 0;
	t->tm_isdst 	= (s = av_fetch(av, 8, 0)) ? SvIV(*s) : 0;

	return t;
}

#ifndef newRV_noinc   
static SV * rv;
#define newRV_noinc(s) ((rv=newRV(s)), SvREFCNT_dec(s), rv)
#endif

#if (PATCHLEVEL < 3) || ((PATCHLEVEL == 3) && (SUBVERSION < 16))
#define sv_derived_from(x, y) sv_isobject((x))
#endif

extern char * printlong _((unsigned long val));
extern unsigned long makelong _((char * c));
SV * newSVChar4 _((unsigned long arg));
unsigned long SvChar4 _((SV *arg));

typedef struct {
	int errnop;
	struct pi_file * pf;
	SV * Class;
} PDA__Pilot__File;

typedef struct DLP {
	int errnop;
	int socket;
} PDA__Pilot__DLP;

typedef struct DLPDB {
	SV *	connection;
	int	socket;
	int	handle;
	int errnop;
	SV * dbname;
	int dbmode;
	int dbcard;
	SV * Class;
} PDA__Pilot__DLP__DB;

/* typedef PDA__Pilot__DLP__DB PDA__Pilot__DLP__ResourceDB;
   typedef PDA__Pilot__DLP__DB PDA__Pilot__DLP__RecordDB;
*/
typedef struct DBInfo DBInfo;
typedef struct PilotUser UserInfo;
typedef unsigned long Char4;
typedef int Result;

SV *
newSVChar4(arg)
	unsigned long arg;
{
	char * c = printlong(arg);
	if((isalpha(c[0]) || (c[0] == ' ') || (c[0] == '_')) &&
	   (isalpha(c[1]) || (c[1] == ' ') || (c[0] == '_')) &&
	   (isalpha(c[2]) || (c[2] == ' ') || (c[0] == '_')) &&
	   (isalpha(c[3]) || (c[3] == ' ') || (c[0] == '_'))) {
		return newSVpv(c,4);
	} else {
		return newSViv(arg);
	}
}

unsigned long
SvChar4(arg)
	SV * arg;
{
	if (SvIOKp(arg)) {
		return SvIV(arg);
	} else {
		STRLEN len;
		char * c = SvPV(arg, len);
		if (len != 4)
			croak("Char4 argument a string that isn't four bytes long");
		return makelong(c);
	}
}

#define pack_dbinfo(arg, var, failure) {	\
		if (failure < 0)  {		\
			arg = &sv_undef;	\
			self->errnop = failure;	\
		} else {			\
			HV * i = newHV();	\
			hv_store(i, "more",                 4, newSViv(var.more), 0);						\
	    		hv_store(i, "flagReadOnly",        12, newSViv((var.flags & dlpDBFlagReadOnly) !=0), 0);		\
		    	hv_store(i, "flagResource",        12, newSViv((var.flags & dlpDBFlagResource) !=0), 0);		\
		    	hv_store(i, "flagBackup",          10, newSViv((var.flags & dlpDBFlagBackup) !=0), 0);			\
	    		hv_store(i, "flagOpen",             8, newSViv((var.flags & dlpDBFlagOpen) !=0), 0);			\
		    	hv_store(i, "flagAppInfoDirty",    16, newSViv((var.flags & dlpDBFlagAppInfoDirty) !=0), 0);		\
		    	hv_store(i, "flagNewer",            9, newSViv((var.flags & dlpDBFlagNewer) !=0), 0);			\
	    		hv_store(i, "flagReset",            9, newSViv((var.flags & dlpDBFlagReset) !=0), 0);			\
		        hv_store(i, "flagCopyPrevention",  18, newSViv((var.flags & dlpDBFlagCopyPrevention) !=0), 0);		\
        		hv_store(i, "flagStream",          10, newSViv((var.flags & dlpDBFlagStream) !=0), 0);			\
	    		hv_store(i, "flagExcludeFromSync", 19, newSViv((var.miscFlags & dlpDBMiscFlagExcludeFromSync)!=0), 0);	\
		    	hv_store(i, "type",                 4, newSVChar4(var.type), 0);	\
		    	hv_store(i, "creator",              7, newSVChar4(var.creator), 0);	\
	    		hv_store(i, "version",              7, newSViv(var.version), 0);	\
		    	hv_store(i, "modnum",               6, newSViv(var.modnum), 0);		\
		    	hv_store(i, "index",                5, newSViv(var.index), 0);		\
	    		hv_store(i, "createDate",          10, newSViv(var.createDate), 0);	\
		    	hv_store(i, "modifyDate",          10, newSViv(var.modifyDate), 0);	\
		    	hv_store(i, "backupDate",          10, newSViv(var.backupDate), 0);	\
	    		hv_store(i, "name",                 4, newSVpv(var.name, 0), 0);	\
			arg = newRV_noinc((SV*)i);\
		}\
	}

#define unpack_dbinfo(arg, var)\
	if (SvROK(arg) && (SvTYPE(SvRV(arg))==SVt_PVHV)) {\
		HV * i = (HV*)SvRV(arg);\
		SV ** s;\
		var.more = (s = hv_fetch(i, "more", 4, 0)) ? SvIV(*s) : 0;\
		var.flags =\
			(((s = hv_fetch(i, "flagReadOnly",       12, 0)) && SvTRUE(*s)) ? dlpDBFlagReadOnly : 0) |	\
			(((s = hv_fetch(i, "flagResource",       12, 0)) && SvTRUE(*s)) ? dlpDBFlagResource : 0) |	\
			(((s = hv_fetch(i, "flagBackup",         10, 0)) && SvTRUE(*s)) ? dlpDBFlagBackup : 0) |	\
			(((s = hv_fetch(i, "flagOpen",            8, 0)) && SvTRUE(*s)) ? dlpDBFlagOpen : 0) |		\
			(((s = hv_fetch(i, "flagAppInfoDirty",   16, 0)) && SvTRUE(*s)) ? dlpDBFlagAppInfoDirty : 0)|	\
			(((s = hv_fetch(i, "flagNewer",           9, 0)) && SvTRUE(*s)) ? dlpDBFlagNewer : 0) |		\
			(((s = hv_fetch(i, "flagReset",           9, 0)) && SvTRUE(*s)) ? dlpDBFlagReset : 0) |		\
			(((s = hv_fetch(i, "flagCopyPrevention", 18, 0)) && SvTRUE(*s)) ? dlpDBFlagCopyPrevention : 0) |\
			(((s = hv_fetch(i, "flagStream",         10, 0)) && SvTRUE(*s)) ? dlpDBFlagStream : 0) |	\
	    	0;\
		var.miscFlags =\
			(((s = hv_fetch(i, "flagExcludeFromSync", 19, 0)) && SvTRUE(*s)) ? dlpDBMiscFlagExcludeFromSync : 0);\
		var.type 	= (s = hv_fetch(i, "type",        4, 0)) ? SvChar4(*s) : 0;\
		var.creator 	= (s = hv_fetch(i, "creator",     7, 0)) ? SvChar4(*s) : 0;\
		var.version 	= (s = hv_fetch(i, "version",     7, 0)) ? SvIV(*s) : 0;\
		var.modnum 	= (s = hv_fetch(i, "modnum",      6, 0)) ? SvIV(*s) : 0;\
		var.index 	= (s = hv_fetch(i, "index",       5, 0)) ? SvIV(*s) : 0;\
		var.createDate 	= (s = hv_fetch(i, "createDate", 10, 0)) ? SvIV(*s) : 0;\
		var.modifyDate 	= (s = hv_fetch(i, "modifyDate", 10, 0)) ? SvIV(*s) : 0;\
		var.backupDate 	= (s = hv_fetch(i, "backupDate", 10, 0)) ? SvIV(*s) : 0;\
		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,na) : 0)		\
			strncpy(var.name, SvPV(*s, na), sizeof(var.name));	\
		} else	{\
			croak("argument is not a hash reference");		\
		}

#define pack_userinfo(arg, var, failure) {	\
	if (failure < 0)  {			\
		arg = &sv_undef;		\
		self->errnop = failure;		\
	} else {				\
		HV * i = newHV();		\
		hv_store(i, "userID",              6, newSViv(var.userID), 0);				\
	    	hv_store(i, "viewerID",            8, newSViv(var.viewerID), 0);			\
	    	hv_store(i, "lastSyncPC",         10, newSViv(var.lastSyncPC), 0);			\
	    	hv_store(i, "successfulSyncDate", 18, newSViv(var.successfulSyncDate), 0);		\
	    	hv_store(i, "lastSyncDate",       12, newSViv(var.lastSyncDate), 0);			\
	    	hv_store(i, "name",                4, newSVpv(var.username,0), 0);			\
	    	hv_store(i, "password",            8, newSVpvn(var.password,var.passwordLength), 0);	\
		arg = newRV_noinc((SV*)i);	\
	}\
}

#define unpack_userinfo(arg, var)\
	if (SvROK(arg) && (SvTYPE(SvRV(arg))==SVt_PVHV)) {\
		HV * i = (HV*)SvRV(arg);\
		SV ** s;\
		var.userID 		= (s = hv_fetch(i, "userID",              6, 0)) ? SvIV(*s) : 0;\
		var.viewerID 		= (s = hv_fetch(i, "viewerID",            8, 0)) ? SvIV(*s) : 0;\
		var.lastSyncPC 		= (s = hv_fetch(i, "lastSyncPC",         10, 0)) ? SvIV(*s) : 0;\
		var.lastSyncDate 	= (s = hv_fetch(i, "lastSyncDate",       12, 0)) ? SvIV(*s) : 0;\
		var.successfulSyncDate 	= (s = hv_fetch(i, "successfulSyncDate", 18, 0)) ? SvIV(*s) : 0;\
		if ((s = hv_fetch(i, "name", 4, 0)) ? SvPV(*s,na) : 0)\
			strncpy(var.username, SvPV(*s, na), sizeof(var.username));\
		} else	{\
			croak("argument is not a hash reference");\
		}

#define PackAI {\
	HV * h;\
	if (SvRV(data) && (SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
		int count;	\
		PUSHMARK(sp);	\
	        XPUSHs(data);	\
		PUTBACK;	\
		count = perl_call_method("Pack", G_SCALAR);\
		SPAGAIN;	\
		if (count != 1)	\
			croak("Unable to pack app block");\
		data = POPs;	\
		PUTBACK;	\
	} else {		\
		croak("Unable to pack app block");\
	}			\
}

#define ReturnReadAI(buf,size)\
	if (result >=0) {\
		if (self->Class) {\
			int count;\
	    		PUSHMARK(sp);\
	    		XPUSHs(self->Class);\
	    		XPUSHs(newSVpvn((char *) buf, size));	\
		    	PUTBACK;\
		    	count = perl_call_method("appblock", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to create appblock");\
	    	} else {\
	    		croak("Class not defined");\
	    	}\
	} else {\
		self->errnop = result;\
		PUSHs(&sv_undef);\
	}

#define PackSI\
	    {\
	    	HV * h;\
	    	if (SvRV(data) &&\
	    		(SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
	    		int count;\
	        	PUSHMARK(sp);\
	          	XPUSHs(data);\
		    	PUTBACK;\
		    	count = perl_call_method("Pack", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to pack sort block");\
		    	data = POPs;\
		    	PUTBACK;\
	        }\
	        else {\
		    		croak("Unable to pack sort block");\
	        }\
	    }

#define ReturnReadSI(buf,size)\
	    if (result >=0) {\
	    	if (self->Class) {\
	    		int count;\
	    		PUSHMARK(sp);\
	    		XPUSHs(self->Class);\
	    		XPUSHs(newSVpvn((char *) buf, size));	\
		    	PUTBACK;\
		    	count = perl_call_method("sortblock", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to create sortblock");\
	    	}\
	    	else {\
	    		croak("Class not defined");\
	    	}\
		} else {\
	    	self->errnop = result;\
	    	PUSHs(&sv_undef);\
	    }

#define PackRecord {\
	HV * h;\
	if (SvRV(data) &&\
		(SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
	    	int count;\
	    	SV ** s;\
	    	if (!(s = hv_fetch(h, "id", 2, 0)) || !SvOK(*s))\
	    		croak("record must contain id");\
		id = SvIV(*s);\
    		attr = 0;\
		if (!(s = hv_fetch(h, "secret", 6, 0)) || !SvOK(*s))\
			croak("record must contain secret");\
		attr |= SvTRUE(*s) ? dlpRecAttrSecret : 0;\
		if (!(s = hv_fetch(h, "deleted", 7, 0)) || !SvOK(*s))\
			croak("record must contain deleted");\
		attr |= SvTRUE(*s) ? dlpRecAttrDeleted : 0;\
		if (!(s = hv_fetch(h, "modified", 8, 0)) || !SvOK(*s))\
	    		croak("record must contain modified");\
		attr |= SvTRUE(*s) ? dlpRecAttrDirty : 0;\
	    	if (!(s = hv_fetch(h, "busy", 4, 0)) || !SvOK(*s))\
	    		croak("record must contain busy");\
		attr |= SvTRUE(*s) ? dlpRecAttrBusy : 0;\
		if (!(s = hv_fetch(h, "archived", 8, 0)) || !SvOK(*s))\
			croak("record must contain archived");\
		attr |= SvTRUE(*s) ? dlpRecAttrArchived : 0;\
		if (!(s = hv_fetch(h, "category", 8, 0)) || !SvOK(*s))\
			croak("record must contain category");\
		category = SvIV(*s);\
	        PUSHMARK(sp);\
	        XPUSHs(data);\
		PUTBACK;\
		count = perl_call_method("Pack", G_SCALAR);\
		SPAGAIN;\
		if (count != 1)\
			croak("Unable to pack record");\
		data = POPs;\
		PUTBACK;\
	} else {\
		croak("Unable to pack record");\
	}\
}

#define PackRaw {\
	HV * h;\
	if (SvRV(data) &&\
		(SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
	    	int count;\
	        PUSHMARK(sp);\
	        XPUSHs(data);\
		PUTBACK;\
		count = perl_call_method("Raw", G_SCALAR);\
		SPAGAIN;\
		if (count != 1)	{\
			SV ** s = hv_fetch(h, "raw", 3, 0);\
		    	if (s)\
		    		data = *s;\
		} else {\
			data = POPs;\
			PUTBACK;\
		}\
	}\
}

#define ReturnReadRecord(buf,size)\
	    if (result >=0) {\
	    	if (self->Class) {\
	    		int count;\
	    		SV * ret;\
	    		PUSHMARK(sp);\
	    		XPUSHs(self->Class);\
	    		XPUSHs(newSVpvn((char *) buf, size));	\
		    	XPUSHs(sv_2mortal(newSViv(id)));\
		    	XPUSHs(sv_2mortal(newSViv(attr)));\
		    	XPUSHs(sv_2mortal(newSViv(category)));\
		    	XPUSHs(sv_2mortal(newSViv(index)));\
		    	PUTBACK;\
		    	count = perl_call_method("record", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to create record");\
		    	ret = POPs;\
		    	PUTBACK;\
		    	PUSHs(ret);\
	    	}\
	    	else {\
	    		croak("Class not defined");\
	    	}\
		} else {\
	    	self->errnop = result;\
	    	PUSHs(&sv_undef);\
	    }

#define PackResource\
	    {\
	    	HV * h;\
	    	if (SvRV(data) &&\
	    		(SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
	    		int count;\
	    		SV ** s;\
	    		if (!(s = hv_fetch(h, "id", 2, 0)) || !SvOK(*s))\
	    			croak("record must contain id");\
    			id = SvIV(*s);\
	    		if (!(s = hv_fetch(h, "type", 4, 0)) || !SvOK(*s))\
	    			croak("record must contain type");\
    			type = SvChar4(*s);\
	        	PUSHMARK(sp);\
	          	XPUSHs(data);\
		    	PUTBACK;\
		    	count = perl_call_method("Pack", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to pack resource");\
		    	data = POPs;\
		    	PUTBACK;\
	        }\
	        else {\
		    		croak("Unable to pack resource");\
	        }\
	    }

#define ReturnReadResource(buf,size)\
	    if (result >=0) {\
	    	if (self->Class) {\
	    		int count;\
	    		PUSHMARK(sp);\
	    		XPUSHs(self->Class);\
	    		XPUSHs(newSVpvn((char *) buf, size));	\
		    	XPUSHs(sv_2mortal(newSVChar4(type)));\
		    	XPUSHs(sv_2mortal(newSViv(id)));\
		    	XPUSHs(sv_2mortal(newSViv(index)));\
		    	PUTBACK;\
		    	count = perl_call_method("resource", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to create resource");\
	    	}\
	    	else {\
	    		croak("Class not defined");\
	    	}\
		} else {\
	    	self->errnop = result;\
	    	PUSHs(&sv_undef);\
	    }

#define PackPref\
	    {\
	    	HV * h;\
	    	if (SvRV(data) &&\
	    		(SvTYPE(h=(HV*)SvRV(data))==SVt_PVHV)) {\
	    		int count;\
	    		SV ** s;\
	    		if (!(s = hv_fetch(h, "id", 2, 0)) || !SvOK(*s))\
	    			croak("record must contain id");\
    			id = SvIV(*s);\
	    		if (!(s = hv_fetch(h, "creator", 7, 0)) || !SvOK(*s))\
	    			croak("record must contain type");\
    			creator = SvChar4(*s);\
	    		if (!(s = hv_fetch(h, "version", 7, 0)) || !SvOK(*s))\
	    			croak("record must contain type");\
    			version = SvIV(*s);\
	    		if (!(s = hv_fetch(h, "backup", 6, 0)) || !SvOK(*s))\
	    			croak("record must contain type");\
    			backup = SvIV(*s);\
   	        	PUSHMARK(sp);\
	          	XPUSHs(data);\
		    	PUTBACK;\
		    	count = perl_call_method("Pack", G_SCALAR);\
		    	SPAGAIN;\
		    	if (count != 1)\
		    		croak("Unable to pack resource");\
		    	data = POPs;\
		    	PUTBACK;\
	        }\
	        else {\
		    		croak("Unable to pack resource");\
	        }\
	    }

#define ReturnReadPref(buf,size)\
	    if (result >=0) {\
			HV * h = perl_get_hv("PDA::Pilot::PrefClasses", 0);\
			SV ** s;\
    		int count;\
			if (!h)\
				croak("PrefClasses doesn't exist");\
			s = hv_fetch(h, printlong(creator), 4, 0);\
			if (!s)\
				s = hv_fetch(h, "", 0, 0);\
			if (!s)\
				croak("Default PrefClass not defined");\
    		PUSHMARK(sp);\
    		XPUSHs(newSVsv(*s));\
    		XPUSHs(newSVpvn((char *) buf, size));		\
	    	XPUSHs(sv_2mortal(newSVChar4(creator)));\
	    	XPUSHs(sv_2mortal(newSViv(id)));\
	    	XPUSHs(sv_2mortal(newSViv(version)));\
	    	XPUSHs(sv_2mortal(newSViv(backup)));\
	    	PUTBACK;\
	    	count = perl_call_method("pref", G_SCALAR);\
	    	SPAGAIN;\
	    	if (count != 1)\
	    		croak("Unable to create resource");\
		} else {\
	    	self->errnop = result;\
	    	PUSHs(&sv_undef);\
	    }

void doUnpackCategory(HV * self, struct CategoryAppInfo * c)
{
	AV * e = newAV();
	int i;
	
    hv_store(self, "categoryRenamed", 15, newRV_noinc((SV*)e), 0);

    for (i=0;i<16;i++) {
    	av_push(e, newSViv(c->renamed[i]));
    }

    e = newAV();
    hv_store(self, "categoryName", 12, newRV_noinc((SV*)e), 0);
    
    for (i=0;i<16;i++) {
    	av_push(e, newSVpv(c->name[i], 0));
    }

    e = newAV();
    hv_store(self, "categoryID", 10, newRV_noinc((SV*)e), 0);
    
    for (i=0;i<16;i++) {
    	av_push(e, newSViv(c->ID[i]));
    }

    hv_store(self, "categoryLastUniqueID", 20, newSViv(c->lastUniqueID), 0);
}


void doPackCategory(HV * self, struct CategoryAppInfo * c)
{
	SV ** s;
	AV * av;
	int i;
	
    if ((s = hv_fetch(self, "categoryName", 12, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<16;i++)
    		strncpy(c->name[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
	else
		for (i=0;i<16;i++)
			strcpy(c->name[i], "");

	for (i=0;i<16;i++)
		c->name[i][15] = '\0';

    if ((s = hv_fetch(self, "categoryID", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<16;i++)
    		c->ID[i] = (s=av_fetch(av, i, 0)) ? SvIV(*s) : 0;
	else
		for (i=0;i<16;i++)
			c->ID[i] = 0;

    if ((s = hv_fetch(self, "categoryRenamed", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<16;i++)
    		c->renamed[i] = (s=av_fetch(av, i, 0)) ? SvIV(*s) : 0;
	else
		for (i=0;i<16;i++)
			c->renamed[i] = 0;
}

int SvList(SV * arg, char **list)
{
	int i;
	char * str = SvPV(arg, na);
	for (i=0;list[i];i++)
		if (strcasecmp(list[i], str)==0)
			return i;
	if (SvPOKp(arg)) {
		croak("Invalid value");
	}
	return SvIV(arg);
}

SV * newSVlist(int value, char **list)
{
	int i;
	for (i=0;list[i];i++)
		;
	if (value < i)
		return newSVpv(list[value], 0);
	else
		return newSViv(value);
}

#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#line 640 "Pilot.c"

/* INCLUDE:  Including 'const-xs.inc' from 'Pilot.xs' */


XS(XS_PDA__Pilot_constant); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_constant)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::constant", "sv");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
#line 4 "const-xs.inc"
#ifdef dXSTARG
	dXSTARG; /* Faster if we have it.  */
#else
	dTARGET;
#endif
	STRLEN		len;
        int		type;
	IV		iv;
	/* NV		nv;	Uncomment this if you need to return NVs */
	/* const char	*pv;	Uncomment this if you need to return PVs */
#line 670 "Pilot.c"
	SV *	sv = ST(0);
	const char *	s = SvPV(sv, len);
#line 18 "const-xs.inc"
        /* Change this to constant(aTHX_ s, len, &iv, &nv);
           if you need to return both NVs and IVs */
	type = constant(aTHX_ s, len, &iv);
      /* Return 1 or 2 items. First is error message, or undef if no error.
           Second, if present, is found value */
        switch (type) {
        case PERL_constant_NOTFOUND:
          sv =
	    sv_2mortal(newSVpvf("%s is not a valid PDA::Pilot macro", s));
          PUSHs(sv);
          break;
        case PERL_constant_NOTDEF:
          sv = sv_2mortal(newSVpvf(
	    "Your vendor has not defined PDA::Pilot macro %s, used",
				   s));
          PUSHs(sv);
          break;
        case PERL_constant_ISIV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHi(iv);
          break;
	/* Uncomment this if you need to return NOs
        case PERL_constant_ISNO:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_no);
          break; */
	/* Uncomment this if you need to return NVs
        case PERL_constant_ISNV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHn(nv);
          break; */
	/* Uncomment this if you need to return PVs
        case PERL_constant_ISPV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, strlen(pv));
          break; */
	/* Uncomment this if you need to return PVNs
        case PERL_constant_ISPVN:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHp(pv, iv);
          break; */
	/* Uncomment this if you need to return SVs
        case PERL_constant_ISSV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(sv);
          break; */
	/* Uncomment this if you need to return UNDEFs
        case PERL_constant_ISUNDEF:
          break; */
	/* Uncomment this if you need to return UVs
        case PERL_constant_ISUV:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHu((UV)iv);
          break; */
	/* Uncomment this if you need to return YESs
        case PERL_constant_ISYES:
          EXTEND(SP, 1);
          PUSHs(&PL_sv_undef);
          PUSHs(&PL_sv_yes);
          break; */
        default:
          sv = sv_2mortal(newSVpvf(
	    "Unexpected return type %d while processing PDA::Pilot macro %s, used",
               type, s));
          PUSHs(sv);
        }
#line 747 "Pilot.c"
	PUTBACK;
	return;
    }
}


/* INCLUDE: Returning to 'Pilot.xs' from 'const-xs.inc' */


XS(XS_PDA__Pilot__Appointment_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Appointment_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Appointment::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 637 "Pilot.xs"
    {
    STRLEN len;
    int i;
    AV * e;
    HV * ret, *h;
    struct Appointment a;
    char *str;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    if (!SvPOK(record)) {
        croak("Not a string!?");
    }
    str = SvPV(record,len);
    if (len > 0)  { /* len == 0 when the record has the deleted flag set */
	pi_buffer_clear(&pibuf);
	if (!pi_buffer_append(&pibuf, str, len)) {
	    croak("Unable to reallocate buffer");
	}
	if (unpack_Appointment(&a, &pibuf, datebook_v1) < 0) {
	    croak("unpack_Appointment failed");
	}

	hv_store(ret, "event", 5, newSViv(a.event), 0);
	hv_store(ret, "begin", 5, newRV_noinc((SV*)tmtoav(&a.begin)), 0);

	if (!a.event) {
	    hv_store(ret, "end", 3, newRV_noinc((SV*)tmtoav(&a.end)), 0);
	}

	if (a.alarm) {
	    HV * alarm = newHV();
	    hv_store(ret, "alarm", 5, newRV_noinc((SV*)alarm), 0);

	    hv_store(alarm, "advance", 7, newSViv(a.advance), 0);
	    hv_store(alarm, "units", 5, newSVpv((
						 (a.advanceUnits == 0) ? "minutes" :        /* Minutes */
						 (a.advanceUnits == 1) ? "hours" :     /* Hours */
						 (a.advanceUnits == 2) ? "days" :  /* Days */
						 0), 0), 0);
	    if (a.advanceUnits > 2) {
		warn("Invalid advance unit %d encountered", a.advanceUnits);
	    }
	}
	if (a.repeatType) {
	    HV * repeat = newHV();
	    hv_store(ret, "repeat", 6, newRV_noinc((SV*)repeat), 0);

	    hv_store(repeat, "type", 4, newSVpv(DatebookRepeatTypeNames[a.repeatType],0), 0);
	    hv_store(repeat, "frequency", 9, newSViv(a.repeatFrequency), 0);
	    if (a.repeatType == repeatMonthlyByDay)
		hv_store(repeat, "day", 3, newSViv(a.repeatDay), 0);
	    else if (a.repeatType == repeatWeekly) {
		e = newAV();
		hv_store(repeat, "days", 4, newRV_noinc((SV*)e), 0);
		for (i=0;i<7;i++)
		    av_push(e,newSViv(a.repeatDays[i]));
	    }
	    hv_store(repeat, "weekstart", 9, newSViv(a.repeatWeekstart), 0);
	    if (!a.repeatForever)
		hv_store(repeat, "end", 3, newRV_noinc((SV*)tmtoav(&a.repeatEnd)),0);
	}

	if (a.exceptions) {
	    e = newAV();
	    hv_store(ret, "exceptions", 10, newRV_noinc((SV*)e), 0);
	    for (i=0;i<a.exceptions;i++) {
		av_push(e,newRV_noinc((SV*)tmtoav(&a.exception[i])));
	    }
	}

	if (a.description)
	    hv_store(ret, "description", 11, newSVpv((char*)a.description,0), 0);

	if (a.note)
	    hv_store(ret, "note", 4, newSVpv((char*)a.note,0), 0);

	free_Appointment(&a);
    }
    }
#line 864 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Appointment_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Appointment_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Appointment::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 736 "Pilot.xs"
    {
    SV ** s;
    HV * h;
    long advance;
    struct Appointment a;

    if (!SvOK(record) || !SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    else {

    a.event = (s = hv_fetch(h, "event", 5, 0)) ? SvIV(*s) : 0;
    if ((s= hv_fetch(h, "begin", 5, 0))  && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV))
    	avtotm((AV*)SvRV(*s), &a.begin);
    else {
      memset(&a.begin, '\0', sizeof(struct tm));
      croak("appointments must contain a begin date");
    }
    if ((s= hv_fetch(h, "end", 3, 0))  && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV))
    	avtotm((AV*)SvRV(*s), &a.end);
    else
    	memset(&a.end, '\0', sizeof(struct tm));

	if ((s = hv_fetch(h, "alarm", 5, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVHV)) {
		HV * h2 = (HV*)SvRV(*s);
		I32 u;
	    a.advance = (s = hv_fetch(h2, "advance", 7, 0)) ? SvIV(*s) : 0;
	    s = hv_fetch(h2, "units", 5, 0);
	    if SvIOK(*s) {
		u = SvIV(*s);
		switch (u) {
		case 60:
		    u = 0;
		    break;
		case 60*60:
		    u = 1;
		    break;
		case 60*60*24:
		    u = 2;
		    break;
		default:
		    croak("Invalid advance unit %d encountered", u);
		}
	    } else {
	    	if (strEQ(SvPV(*s, na), "minutes"))
		    u = 0;
	    	else if (strEQ(SvPV(*s, na), "hours"))
		    u = 1;
	    	else if (strEQ(SvPV(*s, na), "days"))
		    u = 2;
	    	else
		    croak("Invalid advance unit %d encountered", u);
	    }
	    a.advanceUnits = u;
	    if (a.advance > 254)
	    	warn("Alarm advance value %d out of range", a.advance);
	    a.alarm = 1;
    } else {
    	a.alarm = 0;
    	a.advance = 0;
    	a.advanceUnits = 0;
    }    	


	if ((s = hv_fetch(h, "repeat", 6, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVHV)) {
		HV * h2 = (HV*)SvRV(*s);
		int i;
	    a.repeatType = (s = hv_fetch(h2, "type", 4, 0)) ? SvList(*s, DatebookRepeatTypeNames) : 0;
	    a.repeatFrequency = (s = hv_fetch(h2, "frequency", 9, 0)) ? SvIV(*s) : 0;
	    a.repeatDay = 0;
	    for(i=0;i<7;i++)
	    	a.repeatDays[i] = 0;
	    if (a.repeatType == repeatMonthlyByDay ) {
	    	a.repeatDay = (s = hv_fetch(h2, "day", 3, 0)) ? SvIV(*s) : 0;
	    } else if (a.repeatType == repeatWeekly) {
			if ((s = hv_fetch(h2, "days", 4, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV)) {
				int i;
				AV * a2 = (AV*)SvRV(*s);
			    for (i=0;i<7;i++)
			    	if ((s = av_fetch(a2, i, 0)))
			    		a.repeatDays[i] = SvIV(*s);
			}
	    }
	    a.repeatWeekstart = (s = hv_fetch(h2, "weekstart", 9, 0)) ? SvIV(*s) : 0;
	    if ((s = hv_fetch(h2, "end", 3, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV))  {
	    	avtotm((AV*)SvRV(*s), &a.repeatEnd);
	    	a.repeatForever = 0;
	    } else {
	    	a.repeatForever = 1;
	    }
    } else {
    	a.repeatType = 0;
    	a.repeatForever = 0;
    	a.repeatFrequency = 0;
    	a.repeatDay = 0;
    	a.repeatWeekstart = 0;
    	memset(&a.repeatEnd,'\0', sizeof(struct tm));
    }    	

	a.exceptions = 0;
	a.exception = 0;
	if ((s = hv_fetch(h, "exceptions", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV)) {
		int i;
		AV * a2 = (AV*)SvRV(*s);
		if (av_len(a2)>-1) {
		    a.exceptions = av_len(a2)+1;
		    a.exception = malloc(sizeof(struct tm)*a.exceptions);
		    for (i=0;i<a.exceptions;i++)
		    	if ((s = av_fetch(a2, i, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV))
		    		avtotm((AV*)SvRV(*s), a.exception+i);
		}
    }    	

    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,na) : 0;
    if (!a.description)
        croak("appointments must contain a description");
    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,na) : 0;

    if (pack_Appointment(&a, &pibuf, datebook_v1) < 0) {
	croak("pack_Appointment failed");
    }

    if (a.exception)
		free(a.exception);

    RETVAL = newSVpvn((char *) pibuf.data, pibuf.used);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1021 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Appointment_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Appointment_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Appointment::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 878 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct AppointmentAppInfo a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_AppointmentAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {

		doUnpackCategory(ret, &a.category);

	    hv_store(ret, "startOfWeek", 11, newSViv(a.startOfWeek), 0);
	}

    }
#line 1074 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Appointment_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Appointment_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Appointment::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 915 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct AppointmentAppInfo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    doPackCategory(h, &a.category);

    if ((s = hv_fetch(h, "startOfWeek", 11, 0)))
	    a.startOfWeek = SvIV(*s);
	else
		a.startOfWeek = 0;

    len = pack_AppointmentAppInfo(&a, (unsigned char *) mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1123 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__ToDo_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__ToDo_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::ToDo::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 950 "Pilot.xs"
    {
    STRLEN len;
    int i;
    AV * e;
    HV * ret;
    struct ToDo a;
    char *str;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    str = SvPV(record,len);
    if (len > 0) { /* len == 0 if deleted flag is set */
	pi_buffer_clear(&pibuf);
	if (!pi_buffer_append(&pibuf, str, len)) {
	    croak("Unable to reallocate buffer");
	}
	if (unpack_ToDo(&a, &pibuf, todo_v1) < 0) {
	    croak("unpack_ToDo failed");
	}

	if (!a.indefinite)
	    hv_store(ret, "due", 3, newRV_noinc((SV*)tmtoav(&a.due)), 0);  
	hv_store(ret, "priority", 8, newSViv(a.priority), 0);
	hv_store(ret, "complete", 8, newSViv(a.complete), 0);
	if (a.description)
	    hv_store(ret, "description", 11, newSVpv((char*)a.description,0), 0);
	if (a.note)
	    hv_store(ret, "note", 4, newSVpv((char*)a.note,0), 0);

	free_ToDo(&a);
    }
    }
#line 1190 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__ToDo_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__ToDo_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::ToDo::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1001 "Pilot.xs"
    {
    SV ** s;
    HV * h;
    struct ToDo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
 	else {

    a.priority = (s = hv_fetch(h, "priority", 8, 0)) ? SvIV(*s) : 0;
    a.complete = (s = hv_fetch(h, "complete", 8, 0)) ? SvIV(*s) : 0;
    if ((s = hv_fetch(h, "due", 3, 0))  && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV)) {
    	avtotm((AV*)SvRV(*s), &a.due);
    	a.indefinite = 0;
    }
    else {
    	memset(&a.due,'\0', sizeof(struct tm));
    	a.indefinite = 1;
    }

    a.description = (s = hv_fetch(h, "description", 11, 0)) ? SvPV(*s,na) : 0;
    a.note = (s = hv_fetch(h, "note", 4, 0)) ? SvPV(*s,na) : 0;

    if (pack_ToDo(&a, &pibuf, todo_v1) < 0) {
	croak("pack_ToDo failed");
    }

    RETVAL = newSVpvn((char *) pibuf.data, pibuf.used);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1250 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__ToDo_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__ToDo_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::ToDo::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1046 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct ToDoAppInfo a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_ToDoAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {

	    doUnpackCategory(ret, &a.category);

	    hv_store(ret, "dirty", 5, newSViv(a.dirty), 0);

	    hv_store(ret, "sortByPriority", 14, newSViv(a.sortByPriority), 0);
	}
    }
#line 1304 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__ToDo_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__ToDo_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::ToDo::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1084 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct ToDoAppInfo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    doUnpackCategory(h, &a.category);


	doPackCategory(h, &a.category);

    a.dirty = (s = hv_fetch(h, "dirty", 5, 0)) ? SvIV(*s) : 0;
    a.sortByPriority = (s = hv_fetch(h, "sortByPriority", 14, 0)) ? SvIV(*s) : 0;

    len = pack_ToDoAppInfo(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1354 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Address_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Address_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Address::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1120 "Pilot.xs"
    {
    STRLEN len;
    int i;
    AV * e;
    HV * ret;
    struct Address a;
    char *str;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    str = SvPV(record,len);
    if (len > 0) { /* len == 0 when deleted flag is set */
	pi_buffer_clear(&pibuf);
	if (!pi_buffer_append(&pibuf, str, len)) {
	    croak("Unable to reallocate buffer");
	}
	if (unpack_Address(&a, &pibuf, address_v1) < 0) {
	    croak("unpack_Address failed");
	}

	e = newAV();
	hv_store(ret, "phoneLabel", 10, newRV_noinc((SV*)e), 0);

	for (i=0;i<5;i++) {
	    av_push(e, newSViv(a.phoneLabel[i]));
	}

	e = newAV();
	hv_store(ret, "entry", 5, newRV_noinc((SV*)e), 0);

	for (i=0;i<19;i++) {
	    av_push(e, a.entry[i] ? newSVpv(a.entry[i],0) : &sv_undef);
	}

	hv_store(ret, "showPhone", 9, newSViv(a.showPhone), 0);

	free_Address(&a);
    }
    }
#line 1428 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Address_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Address_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Address::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1178 "Pilot.xs"
    {
    SV ** s;
    HV * h;
    AV * av;
    int i;
    struct Address a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    else {

    if ((s = hv_fetch(h, "phoneLabel", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<5;i++)
    		a.phoneLabel[i] = ((s=av_fetch(av, i, 0)) && SvOK(*s)) ? SvIV(*s) : 0;
	else
		for (i=0;i<5;i++)
			a.phoneLabel[i] = 0;

    if ((s = hv_fetch(h, "entry", 5, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<19;i++)
    		a.entry[i] = ((s=av_fetch(av, i, 0)) && SvOK(*s)) ? SvPV(*s,na) : 0;
	else
		for (i=0;i<19;i++)
			a.entry[i] = 0;

	if ((s = hv_fetch(h, "showPhone", 9, 0)))
	  a.showPhone = SvIV(*s);
	else
	  a.showPhone = 0;

    if (pack_Address(&a, &pibuf, address_v1) < 0) {
	croak("pack_Address failed");
    }

    RETVAL = newSVpvn((char *) pibuf.data, pibuf.used);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1495 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Address_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Address_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Address::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1230 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct AddressAppInfo a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_AddressAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {

	    doUnpackCategory(ret, &a.category);

	    e = newAV();
	    hv_store(ret, "labelRenamed", 12, newRV_noinc((SV*)e), 0);

	    for (i=0;i<22;i++) {
	    	av_push(e, newSViv(a.labelRenamed[i]));
	    }

	    hv_store(ret, "country", 7, newSViv(a.country), 0);
	    hv_store(ret, "sortByCompany", 13, newSViv(a.sortByCompany), 0);

	    e = newAV();
	    hv_store(ret, "label", 5, newRV_noinc((SV*)e), 0);

	    for (i=0;i<22;i++) {
	    	av_push(e, newSVpv(a.labels[i],0));
	    }

	    e = newAV();
	    hv_store(ret, "phoneLabel", 10, newRV_noinc((SV*)e), 0);

	    for (i=0;i<8;i++) {
	    	av_push(e, newSVpv(a.phoneLabels[i],0));
	    }

	}
    }
#line 1570 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Address_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Address_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Address::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1289 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct AddressAppInfo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    doPackCategory(h, &a.category);

    if ((s = hv_fetch(h, "labelRenamed", 12, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<22;i++) a.labelRenamed[i] = (s=av_fetch(av, i, 0)) ? SvIV(*s) : 0;
	else
		for (i=0;i<22;i++) a.labelRenamed[i] = 0;

    a.country = (s = hv_fetch(h, "country", 7, 0)) ? SvIV(*s) : 0;
    a.sortByCompany = (s = hv_fetch(h, "sortByCompany", 13, 0)) ? SvIV(*s) : 0;

    if ((s = hv_fetch(h, "label", 5, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<22;i++) strncpy(a.labels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
	else
		for (i=0;i<22;i++) a.labels[i][0] = 0;
	for (i=0;i<22;i++) a.labels[i][15] = 0;

    if ((s = hv_fetch(h, "phoneLabel", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV))
    	for (i=0;i<8;i++) strncpy(a.phoneLabels[i], (s=av_fetch(av, i, 0)) ? SvPV(*s,na) : "", 16);
	else
		for (i=0;i<8;i++) a.phoneLabels[i][0] = 0;
	for (i=0;i<8;i++) a.phoneLabels[i][15] = 0;

    len = pack_AddressAppInfo(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1634 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Memo_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Memo_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Memo::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1339 "Pilot.xs"
    {
    STRLEN len;
    int i;
    AV * e;
    HV * ret;
    struct Memo a;
    char *str;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    str = SvPV(record,len);
    if (len > 0) { /* len == 0 if deleted flag is set */
	pi_buffer_clear(&pibuf);
	if (!pi_buffer_append(&pibuf, str, len)) {
	    croak("Unable to reallocate buffer");
	}
	if (unpack_Memo(&a, &pibuf, memo_v1) < 0) {
	    croak("unpack_Memo failed");
	}


	hv_store(ret, "text", 4, newSVpv(a.text,0), 0);

	free_Memo(&a);
    }
    }
#line 1695 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Memo_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Memo_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Memo::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1384 "Pilot.xs"
    {
    SV ** s;
    HV * h;
    struct Memo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    else {

    if ((s = hv_fetch(h, "text", 4, 0)))
	    a.text = SvPV(*s,na);
	else
		a.text = 0;

    if (pack_Memo(&a, &pibuf, memo_v1) < 0) {
	croak("pack_Memo failed");
    }

    RETVAL = newSVpvn((char *) pibuf.data, pibuf.used);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1746 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Memo_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Memo_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Memo::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1419 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct MemoAppInfo a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_MemoAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {

	    doUnpackCategory(ret, &a.category);

	    hv_store(ret, "sortByAlpha", 11, newSViv(a.sortByAlpha), 0);
	}
    }
#line 1798 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Memo_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Memo_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Memo::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1455 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct MemoAppInfo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    doPackCategory(h, &a.category);


    if ((s = hv_fetch(h, "sortByAlpha", 11, 0)))
	    a.sortByAlpha = SvIV(*s);
	else
		a.sortByAlpha = 0;

    len = pack_MemoAppInfo(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 1848 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1491 "Pilot.xs"
    {
    STRLEN len;
    int i;
    HV * ret;
    struct Expense e;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (len > 0) { /* len == 0 if deleted flag is set */
	if (unpack_Expense(&e, (CPTR)SvPV(record, na), len)>0) {

	    hv_store(ret, "date", 4, newRV_noinc((SV*)tmtoav(&e.date)), 0);
	    hv_store(ret, "type", 4, newSVlist(e.type,ExpenseTypeNames),0);
	    hv_store(ret, "payment", 7, newSVlist(e.payment,ExpensePaymentNames),0);
	    hv_store(ret, "currency", 8, newSViv(e.currency),0);
	    if (e.amount)
		hv_store(ret, "amount", 6, newSVpv(e.amount,0), 0);
	    if (e.vendor)
		hv_store(ret, "vendor", 6, newSVpv(e.vendor,0), 0);
	    if (e.city)
		hv_store(ret, "city", 4, newSVpv(e.city,0), 0);
	    if (e.note)
		hv_store(ret, "note", 4, newSVpv(e.note,0), 0);
	    if (e.attendees)
	    	hv_store(ret, "attendees", 9, newSVpv(e.attendees,0), 0);

	    free_Expense(&e);
	}
    }
    }
#line 1914 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1541 "Pilot.xs"
    {
    STRLEN len;
    SV ** s;
    HV * h;
    struct Expense e;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    else {

    if ((s = hv_fetch(h, "type", 4, 0)))
    	e.type = SvList(*s,ExpenseTypeNames);
    else
    	croak("must have type");
    if ((s = hv_fetch(h, "payment", 7, 0)))
    	e.payment = SvList(*s,ExpensePaymentNames);
    else
    	croak("must have payment");
    if ((s = hv_fetch(h, "currency", 8, 0)))
    	e.currency = SvIV(*s);
    else
    	croak("must have currency");

    if ((s = hv_fetch(h, "date", 4, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV))
    	avtotm((AV*)SvRV(*s), &e.date);
    else
    	croak("expense record must contain date");
    if ((s = hv_fetch(h, "amount", 6, 0))) e.amount = SvPV(*s,na);
	else e.amount = 0;
    if ((s = hv_fetch(h, "vendor", 6, 0))) e.vendor = SvPV(*s,na);
	else e.vendor = 0;
    if ((s = hv_fetch(h, "city", 4, 0))) e.city = SvPV(*s,na);
	else e.city = 0;
    if ((s = hv_fetch(h, "attendess", 9, 0))) e.attendees = SvPV(*s,na);
	else e.attendees = 0;
    if ((s = hv_fetch(h, "note", 4, 0))) e.note = SvPV(*s,na);
	else e.note = 0;

    len = pack_Expense(&e, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);


    }
    }
#line 1989 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1600 "Pilot.xs"
    {
    STRLEN len;
    HV * ret;
    AV * a;
    int i;
    struct ExpenseAppInfo e;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_ExpenseAppInfo(&e, (CPTR)SvPV(record, na), len)>0) {

		hv_store(ret, "sortOrder", 9, newSVlist(e.sortOrder,ExpenseSortNames),0);
		a = newAV();
		hv_store(ret, "currencies", 10, newRV_noinc((SV*)a), 0);
		for (i=0;i<4;i++) {
			HV * h = newHV();
			hv_store(h, "name", 4, newSVpv(e.currencies[i].name, 0), 0);
			hv_store(h, "symbol", 6, newSVpv(e.currencies[i].symbol, 0), 0);
			hv_store(h, "rate", 4, newSVpv(e.currencies[i].rate, 0), 0);
			av_store(a, i, (SV*)newRV_noinc((SV*)h));
		}

	    doUnpackCategory(ret, &e.category);
	}
    }
#line 2050 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1645 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct ExpenseAppInfo e;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    doPackCategory(h, &e.category);

	e.sortOrder = (s = hv_fetch(h, "sortOrder", 9, 0)) ? SvList(*s, ExpenseSortNames) : 0;
	if ((s=hv_fetch(h, "currencies", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV)) {
		for(i=0;i<4;i++) {
			HV * hv;
			if ((s=av_fetch(av, i, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(hv=(HV*)SvRV(*s))==SVt_PVHV)) {
				if (s = hv_fetch(hv, "name", 4, 0)) {
					strncpy(e.currencies[i].name, SvPV(*s, na), 16);
					e.currencies[i].name[15] = 0;
				}
				if (s = hv_fetch(hv, "symbol", 6, 0)) {
					strncpy(e.currencies[i].symbol, SvPV(*s, na), 4);
					e.currencies[i].symbol[3] = 0;
				}
				if (s = hv_fetch(hv, "rate", 4, 0)) {
					strncpy(e.currencies[i].rate, SvPV(*s, na), 8);
					e.currencies[i].rate[7] = 0;
				}
			}
		}
	} else
		for(i=0;i<4;i++) {
			e.currencies[i].symbol[0] = 0;
			e.currencies[i].name[0] = 0;
			e.currencies[i].rate[0] = 0;
		}

    len = pack_ExpenseAppInfo(&e, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2120 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_UnpackPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_UnpackPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::UnpackPref", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1699 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct ExpensePref a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_ExpensePref(&a, (CPTR)SvPV(record, na), len)>0) {

	    hv_store(ret, "unitOfDistance", 14, newSVlist(a.unitOfDistance, ExpenseDistanceNames), 0);
	    hv_store(ret, "currentCategory", 15, newSViv(a.currentCategory), 0);
	    hv_store(ret, "defaultCurrency", 15, newSViv(a.defaultCurrency), 0);
	    hv_store(ret, "attendeeFont", 8, newSViv(a.attendeeFont), 0);
	    hv_store(ret, "showAllCategories", 17, newSViv(a.showAllCategories), 0);
	    hv_store(ret, "showCurrency", 12, newSViv(a.showCurrency), 0);
	    hv_store(ret, "saveBackup", 10, newSViv(a.saveBackup), 0);
	    hv_store(ret, "allowQuickFill", 14, newSViv(a.allowQuickFill), 0);
	    e = newAV();
	    for (i=0;i<5;i++)
			av_store(e, i, newSViv(a.currencies[i]));
		hv_store(ret, "currencies", 10, (SV*)newRV_noinc((SV*)e), 0);
	    hv_store(ret, "noteFont", 8, newSViv(a.noteFont), 0);
	}
    }
#line 2182 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Expense_PackPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Expense_PackPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Expense::PackPref", "record, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	int	id = (int)SvIV(ST(1));
	SV *	RETVAL;
#line 1746 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct ExpensePref a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

	a.unitOfDistance = (s = hv_fetch(h, "unitOfDistance", 14, 0)) ? SvList(*s, ExpenseDistanceNames) : 0;
	a.currentCategory = (s=hv_fetch(h,"currentCategory",15,0)) ? SvIV(*s) : 0;
	a.defaultCurrency = (s=hv_fetch(h,"defaultCurrency",15,0)) ? SvIV(*s) : 0;
	a.attendeeFont = (s=hv_fetch(h,"attendeeFont",8,0)) ? SvIV(*s) : 0;
	a.showAllCategories = (s=hv_fetch(h,"showAllCategories",17,0)) ? SvIV(*s) : 0;
	a.showCurrency = (s=hv_fetch(h,"showCurrency",12,0)) ? SvIV(*s) : 0;
	a.saveBackup = (s=hv_fetch(h,"saveBackup",10,0)) ? SvIV(*s) : 0;
	a.allowQuickFill = (s=hv_fetch(h,"allowQuickFill",14,0)) ? SvIV(*s) : 0;

	if ((s=hv_fetch(h, "currencies", 10, 0)) && SvOK(*s) && SvRV(*s) && (SvTYPE(av=(AV*)SvRV(*s))==SVt_PVAV)) {
		for(i=0;i<5;i++)
			a.currencies[i] = (s=av_fetch(av, i, 0)) ? SvIV(*s) : 0;
	} else
		for(i=0;i<5;i++)
			a.currencies[i] = 0;
	a.noteFont = (s=hv_fetch(h,"noteFont",8,0)) ? SvIV(*s) : 0;

    len = pack_ExpensePref(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2242 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_Unpack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_Unpack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::Unpack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1791 "Pilot.xs"
    {
    STRLEN len;
    int i;
    AV * e;
    HV * ret;
    struct Mail a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (len > 0) { /* len == 0 if deleted flag is set */
	if (unpack_Mail(&a, (CPTR)SvPV(record, na), len)>0) {

	    if (a.subject) hv_store(ret, "subject", 7, newSVpv(a.subject,0), 0);
	    if (a.from) hv_store(ret, "from", 4, newSVpv(a.from,0), 0);
	    if (a.to) hv_store(ret, "to", 2, newSVpv(a.to,0), 0);
	    if (a.cc) hv_store(ret, "cc", 2, newSVpv(a.cc,0), 0);
	    if (a.bcc) hv_store(ret, "bcc", 3, newSVpv(a.bcc,0), 0);
	    if (a.replyTo) hv_store(ret, "replyTo", 7, newSVpv(a.replyTo,0), 0);
	    if (a.sentTo) hv_store(ret, "sentTo", 6, newSVpv(a.sentTo,0), 0);
	    if (a.body) hv_store(ret, "body", 4, newSVpv(a.body,0), 0);

	    hv_store(ret, "read", 4, newSViv(a.read), 0);
	    hv_store(ret, "signature", 9, newSViv(a.signature), 0);
	    hv_store(ret, "confirmRead", 11, newSViv(a.confirmRead), 0);
	    hv_store(ret, "confirmDelivery", 15, newSViv(a.confirmDelivery), 0);
	    hv_store(ret, "priority", 8, newSViv(a.priority), 0);
	    hv_store(ret, "addressing", 10, newSViv(a.addressing), 0);

	    if (a.dated)
		hv_store(ret, "date", 4, newRV_noinc((SV*)tmtoav(&a.date)), 0);

	    free_Mail(&a);
	}
    }
    }
#line 2313 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_Pack); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_Pack)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::Pack", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1846 "Pilot.xs"
    {
    STRLEN len;
    SV ** s;
    HV * h;
    struct Mail a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else if ((s=hv_fetch(h, "deleted", 7, 0)) && SvOK(*s) && SvTRUE(*s) &&
    		(s=hv_fetch(h, "archived", 8, 0)) && SvOK(*s) && !SvTRUE(*s)) {
    	RETVAL = newSVpv("",0);
	    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    else {

    a.subject = (s = hv_fetch(h, "subject", 7, 0)) ? SvPV(*s,na) : 0;
    a.from = (s = hv_fetch(h, "from", 4, 0)) ? SvPV(*s,na) : 0;
    a.to = (s = hv_fetch(h, "to", 2, 0)) ? SvPV(*s,na) : 0;
    a.cc = (s = hv_fetch(h, "cc", 2, 0)) ? SvPV(*s,na) : 0;
    a.bcc = (s = hv_fetch(h, "bcc", 3, 0)) ? SvPV(*s,na) : 0;
    a.replyTo = (s = hv_fetch(h, "replyTo", 7, 0)) ? SvPV(*s,na) : 0;
    a.sentTo = (s = hv_fetch(h, "sentTo", 6, 0)) ? SvPV(*s,na) : 0;
    a.body = (s = hv_fetch(h, "body", 4, 0)) ? SvPV(*s,na) : 0;

    a.read = (s = hv_fetch(h, "read", 4, 0)) ? SvIV(*s) : 0;
    a.signature = (s = hv_fetch(h, "signature", 9, 0)) ? SvIV(*s) : 0;
    a.confirmRead = (s = hv_fetch(h, "confirmRead", 11, 0)) ? SvIV(*s) : 0;
    a.confirmDelivery = (s = hv_fetch(h, "confirmDelivery", 15, 0)) ? SvIV(*s) : 0;
    a.priority = (s = hv_fetch(h, "priority", 8, 0)) ? SvIV(*s) : 0;
    a.addressing = (s = hv_fetch(h, "addressing", 10, 0)) ? SvIV(*s) : 0;

    a.dated = (s = hv_fetch(h, "date", 4, 0)) ? 1 : 0;
    if (s && SvOK(*s) && SvRV(*s) && (SvTYPE(SvRV(*s))==SVt_PVAV)) avtotm((AV*)SvRV(*s), &a.date);

    len = pack_Mail(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2377 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_UnpackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_UnpackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::UnpackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1894 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct MailAppInfo a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_MailAppInfo(&a, (CPTR)SvPV(record, na), len)>0) {

	    doUnpackCategory(ret, &a.category);

	    hv_store(ret, "sortOrder", 9, newSVlist(a.sortOrder, MailSortTypeNames), 0);

	    hv_store(ret, "dirty", 5, newSViv(a.dirty), 0);
	    hv_store(ret, "unsentMessage", 13, newSViv(a.unsentMessage), 0);
	}
    }
#line 2432 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_PackAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_PackAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::PackAppBlock", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1933 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct MailAppInfo a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {


    doPackCategory(h, &a.category);

    if ((s = hv_fetch(h, "sortOrder", 9, 0)))
	    a.sortOrder = SvList(*s, MailSortTypeNames);
	else
		a.sortOrder = 0;

	a.dirty = (s=hv_fetch(h,"dirty",5,0)) ? SvIV(*s) : 0;
	a.unsentMessage = (s=hv_fetch(h,"unsentMessage",13,0)) ? SvIV(*s) : 0;

    len = pack_MailAppInfo(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2485 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_UnpackSyncPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_UnpackSyncPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::UnpackSyncPref", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 1970 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct MailSyncPref a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_MailSyncPref(&a, (CPTR)SvPV(record, na), len)>0) {

	    hv_store(ret, "syncType", 8, newSVlist(a.syncType, MailSyncTypeNames), 0);
	    hv_store(ret, "getHigh", 7, newSViv(a.getHigh), 0);
	    hv_store(ret, "getContaining", 13, newSViv(a.getContaining), 0);
	    hv_store(ret, "truncate", 8, newSViv(a.truncate), 0);

	    if (a.filterTo)  
		    hv_store(ret, "filterTo", 8, newSVpv(a.filterTo, 0), 0);
	    if (a.filterFrom)  
		    hv_store(ret, "filterFrom", 10, newSVpv(a.filterFrom, 0), 0);
	    if (a.filterSubject)  
	 	   hv_store(ret, "filterSubject", 13, newSVpv(a.filterSubject, 0), 0);
	}
    }
#line 2545 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_PackSyncPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_PackSyncPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::PackSyncPref", "record, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	int	id = (int)SvIV(ST(1));
	SV *	RETVAL;
#line 2015 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct MailSyncPref a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

    if ((s = hv_fetch(h, "syncType", 8, 0)))
	    a.syncType = SvList(*s, MailSyncTypeNames);
	else
		a.syncType = 0;

	a.getHigh = (s=hv_fetch(h,"getHigh",7,0)) ? SvIV(*s) : 0;
	a.getContaining = (s=hv_fetch(h,"getContaining",13,0)) ? SvIV(*s) : 0;
	a.truncate = (s=hv_fetch(h,"truncate",8,0)) ? SvIV(*s) : 0;

	a.filterTo = (s=hv_fetch(h,"filterTo",8,0)) ? SvPV(*s,na) : 0;
	a.filterFrom = (s=hv_fetch(h,"filterFrom",10,0)) ? SvPV(*s,na) : 0;
	a.filterSubject = (s=hv_fetch(h,"filterSubject",13,0)) ? SvPV(*s,na) : 0;

    len = pack_MailSyncPref(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2601 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_UnpackSignaturePref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_UnpackSignaturePref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::UnpackSignaturePref", "record");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	SV *	RETVAL;
#line 2054 "Pilot.xs"
    {
    STRLEN len;
    AV * e;
    HV * ret;
    int i;
    struct MailSignaturePref a;

    if (SvOK(record) && SvRV(record) && (SvTYPE(SvRV(record)) == SVt_PVHV)) {
    	SV ** raw;
    	ret = (HV*)SvRV(record);
    	raw = hv_fetch(ret, "raw", 3, 0);
    	if (!raw || !SvOK(*raw))
    		croak("Unable to unpack");
    	RETVAL = newSVsv(record);
    	record = *raw;
    } else {
    	ret = newHV();
    	hv_store(ret, "raw", 3, newSVsv(record),0);
    	RETVAL = newRV_noinc((SV*)ret);
    }

    SvPV(record,len);
    if (unpack_MailSignaturePref(&a, (CPTR)SvPV(record, na), len)>0) {

	    if (a.signature)  
		    hv_store(ret, "signature", 9, newSVpv(a.signature, 0), 0);
	}
    }
#line 2652 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__Mail_PackSignaturePref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__Mail_PackSignaturePref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::Mail::PackSignaturePref", "record, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	SV *	record = ST(0);
	int	id = (int)SvIV(ST(1));
	SV *	RETVAL;
#line 2090 "Pilot.xs"
    {
    int i;
    int len;
    SV ** s;
    HV * h;
    AV * av;
    struct MailSignaturePref a;

    if (!SvRV(record) || (SvTYPE(h=(HV*)SvRV(record))!=SVt_PVHV))
    	RETVAL = record;
    else {

	a.signature = (s=hv_fetch(h,"signature",9,0)) ? SvPV(*s,na) : 0;

    len = pack_MailSignaturePref(&a, mybuf, 0xffff);

    RETVAL = newSVpvn((char *) mybuf, len);

    hv_store(h, "raw", 3, SvREFCNT_inc(RETVAL), 0);
    }
    }
#line 2697 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::close", "socket");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	socket = (int)SvIV(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2120 "Pilot.xs"
	RETVAL = pi_close(socket);
#line 2722 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_write); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_write)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::write", "socket, msg");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	socket = (int)SvIV(ST(0));
	SV *	msg = ST(1);
	int	RETVAL;
	dXSTARG;
#line 2129 "Pilot.xs"
	{
	    STRLEN len;
	    SvPV(msg, len);
		RETVAL = pi_write(socket,SvPV(msg,na),len);
	}
#line 2751 "Pilot.c"
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_read); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_read)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::read", "socket, len");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	socket = (int)SvIV(ST(0));
	int	len = (int)SvIV(ST(1));
	SV *	RETVAL;
#line 2142 "Pilot.xs"
	{
	    int result;

	    result = pi_read(socket, &pibuf, len);
	    if (result >=0) 
	    	RETVAL = newSVpvn((char *) pibuf.data, result);
	    else
	    	RETVAL = &sv_undef;
	}
#line 2782 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_socket); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_socket)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::socket", "domain, type, protocol");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	domain = (int)SvIV(ST(0));
	int	type = (int)SvIV(ST(1));
	int	protocol = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;
#line 2160 "Pilot.xs"
	RETVAL = pi_socket(domain, type, protocol);
#line 2809 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_listen); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_listen)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::listen", "socket, backlog");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	socket = (int)SvIV(ST(0));
	int	backlog = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2169 "Pilot.xs"
	RETVAL = pi_listen(socket, backlog);
#line 2834 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_errorText); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_errorText)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::errorText", "error");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	error = (int)SvIV(ST(0));
	char *	RETVAL;
	dXSTARG;
#line 2177 "Pilot.xs"
	RETVAL = dlp_strerror(error);
#line 2858 "Pilot.c"
	sv_setpv(TARG, RETVAL); XSprePUSH; PUSHTARG;
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_bind); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_bind)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::bind", "socket, port");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	int	socket = (int)SvIV(ST(0));
	char *	port = (char *)SvPV_nolen(ST(1));
	int	RETVAL;
	dXSTARG;
#line 2186 "Pilot.xs"
	RETVAL = pi_bind(socket, port);
#line 2883 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_openPort); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_openPort)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::openPort", "port");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	char *	port = (char *)SvPV_nolen(ST(0));
	int	RETVAL;
	dXSTARG;
#line 2194 "Pilot.xs"
	{
		int socket = pi_socket(PI_AF_PILOT, PI_SOCK_STREAM, PI_PF_DLP);
		pi_bind(socket, port);
		pi_listen(socket, 1);
		RETVAL = socket;
	}
#line 2912 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot_accept); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot_accept)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::accept", "socket");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	int	socket = (int)SvIV(ST(0));
#line 2207 "Pilot.xs"
	{
		struct pi_sockaddr a;
		size_t len = sizeof(struct pi_sockaddr);
		int result;
		result = pi_accept(socket, (struct sockaddr*)&a, &len);
		EXTEND(SP, 1);
		if (result < 0) {
			PUSHs(sv_newmortal());
		} else {
			PDA__Pilot__DLP * x = malloc(sizeof(PDA__Pilot__DLP));
			SV * sv = newSViv((IV)(void*)x);
			x->errnop = 0;
			x->socket = result;
			SV * rv = newRV_noinc(sv);
			sv_bless(rv, gv_stashpv("PDA::Pilot::DLPPtr",0));
			PUSHs(sv_2mortal(rv));
		}
		/* In list context, return error code as a second value */
		if (GIMME_V == G_ARRAY) {
		        EXTEND(SP, 1);
			if (result < 0) {
				PUSHs(sv_2mortal(newSViv(result)));
			} else {
				PUSHs(sv_newmortal());
			}
		}

	}
#line 2963 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::DESTROY", "db");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	db;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    db = INT2PTR(PDA__Pilot__DLP__DB *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"PDA::Pilot::DLP::DBPtr::DESTROY",
			"db");
#line 2242 "Pilot.xs"
	if (db->Class)
		SvREFCNT_dec(db->Class);
	if (db->handle)
		dlp_CloseDB(db->socket, db->handle);
	if (db->dbname)
		SvREFCNT_dec(db->dbname);
	SvREFCNT_dec(db->connection);
	free(db);
#line 3001 "Pilot.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_PDA__Pilot__DLP__DBPtr_errno); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_errno)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::errno", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2255 "Pilot.xs"
		RETVAL = self->errnop;
		self->errnop = 0;
#line 3032 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_palmos_errno); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_palmos_errno)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::palmos_errno", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2264 "Pilot.xs"
		RETVAL = pi_palmos_error(self->socket);
#line 3063 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_class); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_class)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::class", "self, name=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	name;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    name = 0;
	else {
	    name = ST(1);
	}
#line 2275 "Pilot.xs"
	{
		SV ** s = 0;
		HV * h;
		if (name) {
			STRLEN len;
			h = perl_get_hv("PDA::Pilot::DBClasses", 0);
			if (!h)
				croak("DBClasses doesn't exist");
			if (SvOK(name)) {
				(void)SvPV(name,len);
				s = hv_fetch(h, SvPV(name,na), len, 0);
			}
			if (!s)
				s = hv_fetch(h, "", 0, 0);
			if (!s)
				croak("Default DBClass not defined");
			SvREFCNT_inc(*s);
			if (self->Class)
				SvREFCNT_dec(self->Class);
			self->Class = *s;
		}
		RETVAL = newSVsv(self->Class);
	}
#line 3122 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::close", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2305 "Pilot.xs"
	RETVAL = dlp_CloseDB(self->socket, self->handle);
	self->handle=0;
#line 3154 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_setSortBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setSortBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setSortBlock", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2315 "Pilot.xs"
	{
		STRLEN len;
		void * c;
		PackSI;
		c = SvPV(data, len);
		RETVAL = dlp_WriteSortBlock(self->socket, self->handle, c, len);
	}
#line 3196 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_getAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getAppBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2329 "Pilot.xs"
	{
		int result = dlp_ReadAppBlock(self->socket, self->handle, 0, -1, &pibuf);
		ReturnReadAI(pibuf.data, result);
	}
#line 3236 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getSortBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getSortBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getSortBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2338 "Pilot.xs"
	{
		int result = dlp_ReadSortBlock(self->socket,self->handle, 0, -1, &pibuf);
		ReturnReadSI(pibuf.data, result);
	}
#line 3271 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_setAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setAppBlock", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2348 "Pilot.xs"
	{
		STRLEN len;
		void * c;
		PackAI;
		c = SvPV(data, len);
		RETVAL = dlp_WriteAppBlock(self->socket, self->handle, c, len);
	}
#line 3308 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_purge); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_purge)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::purge", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2362 "Pilot.xs"
	RETVAL = dlp_CleanUpDatabase(self->socket, self->handle);
#line 3343 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_resetFlags); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_resetFlags)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::resetFlags", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2370 "Pilot.xs"
	RETVAL = dlp_ResetSyncFlags(self->socket, self->handle);
#line 3378 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_deleteCategory); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_deleteCategory)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::deleteCategory", "self, category");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	int	category = (int)SvIV(ST(1));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2379 "Pilot.xs"
	RETVAL = dlp_DeleteCategory(self->socket, self->handle, category);
#line 3414 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_newRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_newRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::newRecord", "self, id=0, attr=0, cat=0");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	id;
	SV *	attr;
	SV *	cat;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    id = 0;
	else {
	    id = ST(1);
	}

	if (items < 3)
	    attr = 0;
	else {
	    attr = ST(2);
	}

	if (items < 4)
	    cat = 0;
	else {
	    cat = ST(3);
	}
#line 2390 "Pilot.xs"
	{
    	if (self->Class) {									
    		int count;										
    		PUSHMARK(sp);									
    		XPUSHs(self->Class);
    		if (id)
	    		XPUSHs(id);
	    	if (attr)
	    		XPUSHs(attr);
	    	if (cat)
	    		XPUSHs(cat);
	    	PUTBACK;										
	    	count = perl_call_method("record", G_SCALAR);
	    	SPAGAIN;										
	    	if (count != 1)									
	    		croak("Unable to create record");			
    	}													
    	else {												
    		croak("Class not defined");						
    	}													
    }
#line 3491 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_newResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_newResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::newResource", "self, type=0, id=0");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	type;
	SV *	id;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    type = 0;
	else {
	    type = ST(1);
	}

	if (items < 3)
	    id = 0;
	else {
	    id = ST(2);
	}
#line 2418 "Pilot.xs"
	{
    	if (self->Class) {									
    		int count;										
    		PUSHMARK(sp);									
    		XPUSHs(self->Class);							
    		if (type)	
    			XPUSHs(type);
    		if (id)
    			XPUSHs(id);
	    	PUTBACK;										
	    	count = perl_call_method("resource", G_SCALAR);
	    	SPAGAIN;										
	    	if (count != 1)									
	    		croak("Unable to create record");			
    	}													
    	else {												
    		croak("Class not defined");						
    	}													
    }
#line 3554 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_newAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_newAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::newAppBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2442 "Pilot.xs"
	{
    	if (self->Class) {									
    		int count;										
    		PUSHMARK(sp);									
    		XPUSHs(self->Class);							
	    	PUTBACK;										
	    	count = perl_call_method("appblock", G_SCALAR);
	    	SPAGAIN;										
	    	if (count != 1)									
	    		croak("Unable to create record");			
    	}													
    	else {												
    		croak("Class not defined");						
    	}													
    }
#line 3599 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_newSortBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_newSortBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::newSortBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2462 "Pilot.xs"
	{
    	if (self->Class) {									
    		int count;										
    		PUSHMARK(sp);									
    		XPUSHs(self->Class);							
	    	PUTBACK;										
	    	count = perl_call_method("sortblock", G_SCALAR);
	    	SPAGAIN;										
	    	if (count != 1)									
	    		croak("Unable to create record");			
    	}													
    	else {												
    		croak("Class not defined");						
    	}													
    }
#line 3644 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_newPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_newPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::newPref", "self, id=0, version=0, backup=0, creator=0");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	id;
	SV *	version;
	SV *	backup;
	SV *	creator;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    id = 0;
	else {
	    id = ST(1);
	}

	if (items < 3)
	    version = 0;
	else {
	    version = ST(2);
	}

	if (items < 4)
	    backup = 0;
	else {
	    backup = ST(3);
	}

	if (items < 5)
	    creator = 0;
	else {
	    creator = ST(4);
	}
#line 2486 "Pilot.xs"
	{
		if (!creator) {
			int count;
			PUSHMARK(sp);
			XPUSHs(self->Class);
			PUTBACK;
			count = perl_call_method("creator", G_SCALAR);
			SPAGAIN;
			if (count != 1)
				croak("Unable to get creator");
			creator = POPs;
			PUTBACK;
		}
    	if (self->Class) {									
    		int count;										
    		PUSHMARK(sp);									
    		XPUSHs(self->Class);
    		if (creator)
    			XPUSHs(creator);
    		if (id)
    			XPUSHs(id);
    		if (version)
    			XPUSHs(version);
    		if (backup)
    			XPUSHs(backup);
	    	PUTBACK;										
	    	count = perl_call_method("pref", G_SCALAR);
	    	SPAGAIN;										
	    	if (count != 1)									
	    		croak("Unable to create record");			
    	}													
    	else {												
    		croak("Class not defined");						
    	}													
    }
#line 3737 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getRecord", "self, index");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	index = (int)SvIV(ST(1));

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2527 "Pilot.xs"
	{
		int attr, category;
		unsigned long id;
		int result;

		result = dlp_ReadRecordByIndex(self->socket, self->handle, index, &pibuf, &id, &attr, &category);
		ReturnReadRecord(pibuf.data, pibuf.used);
	}
#line 3776 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_moveCategory); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_moveCategory)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::moveCategory", "self, fromcat, tocat");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	int	fromcat = (int)SvIV(ST(1));
	int	tocat = (int)SvIV(ST(2));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2542 "Pilot.xs"
	RETVAL = dlp_MoveCategory(self->socket, self->handle, fromcat, tocat);
#line 3808 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_deleteRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_deleteRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::deleteRecord", "self, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	unsigned long	id = (unsigned long)SvUV(ST(1));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2552 "Pilot.xs"
	RETVAL = dlp_DeleteRecord(self->socket, self->handle, 0, id);
#line 3844 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_deleteRecords); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_deleteRecords)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::deleteRecords", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2561 "Pilot.xs"
	RETVAL = dlp_DeleteRecord(self->socket, self->handle, 1, 0);
#line 3879 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_resetNext); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_resetNext)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::resetNext", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2569 "Pilot.xs"
	RETVAL = dlp_ResetDBIndex(self->socket, self->handle);
#line 3914 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_getRecords); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getRecords)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getRecords", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2577 "Pilot.xs"
	{
		int result = dlp_ReadOpenDBInfo(self->socket, self->handle, &RETVAL);
		if (result < 0) {
			RETVAL = newSVsv(&sv_undef);
			self->errnop = result;
		}
	}
#line 3956 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_getRecordIDs); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getRecordIDs)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getRecordIDs", "self, sort=0");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	sort;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    sort = 0;
	else {
	    sort = (int)SvIV(ST(1));
	}
#line 2592 "Pilot.xs"
	{
		recordid_t * id = (recordid_t*)mybuf;
		int result;
		int start;
		int count;
		int i;
		AV * list = newAV();

		start = 0;
		for(;;) {
			result = dlp_ReadRecordIDList(self->socket, self->handle, sort, start,
				0xFFFF/sizeof(recordid_t), id, &count);
			if (result < 0) {
				self->errnop = result;
				break;
			} else {
				for(i=0;i<count;i++) {
					EXTEND(sp,1);
					PUSHs(sv_2mortal(newSViv(id[i])));
				}
				if (count == (0xFFFF/sizeof(recordid_t)))
					start = count;
				else
					break;
			}
		}
	}
#line 4020 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getRecordByID); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getRecordByID)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getRecordByID", "self, id");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	unsigned long	id = (unsigned long)SvUV(ST(1));

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2625 "Pilot.xs"
	{
	    int result, attr, category, index;

	    result = dlp_ReadRecordById(self->socket, self->handle, id, &pibuf, &index, &attr, &category);
	    ReturnReadRecord(pibuf.data, pibuf.used);
	}
#line 4057 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getNextModRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getNextModRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getNextModRecord", "self, category=-1");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	category;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    category = -1;
	else {
	    category = (int)SvIV(ST(1));
	}
#line 2637 "Pilot.xs"
	{
	    int result, attr, index;
	    unsigned long id;

	    if (category == -1)
	    	result = dlp_ReadNextModifiedRec(self->socket, self->handle, &pibuf, &id, &index, &attr, &category);
	    else
	    	result = dlp_ReadNextModifiedRecInCategory(self->socket, self->handle, category, &pibuf, &id, &index, &attr);
	    ReturnReadRecord(pibuf.data, pibuf.used);
	}
#line 4104 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getNextRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getNextRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getNextRecord", "self, category");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	category = (int)SvIV(ST(1));

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2653 "Pilot.xs"
	{
	   int result, attr, index;
	    unsigned long id;

	    result = dlp_ReadNextRecInCategory(self->socket, self->handle, category, &pibuf, &id, &index, &attr);
	    ReturnReadRecord(pibuf.data, pibuf.used);
	}
#line 4142 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_setRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setRecord", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	unsigned long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2666 "Pilot.xs"
	{
		STRLEN len;
		unsigned long id;
		int attr, category;
		int result;
		void * c;
		PackRecord;
		c = SvPV(data, len);
		result = dlp_WriteRecord(self->socket, self->handle, attr, id, category, c, len, &RETVAL);
		if (result<0) {
			RETVAL = 0;
			self->errnop = result;
		}
	}
#line 4187 "Pilot.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_setRecordRaw); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setRecordRaw)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setRecordRaw", "self, data, id, attr, category");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	unsigned long	id = (unsigned long)SvUV(ST(2));
	int	attr = (int)SvIV(ST(3));
	int	category = (int)SvIV(ST(4));
	SV *	data = ST(1);
	unsigned long	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2691 "Pilot.xs"
	{
		STRLEN len;
		int result;
		void * c;
		PackRaw;
		c = SvPV(data, len);
		result = dlp_WriteRecord(self->socket, self->handle, attr, id, category, c, len, &RETVAL);
		if (result<0) {
			RETVAL = 0;
			self->errnop = result;
		}
	}
#line 4233 "Pilot.c"
	XSprePUSH; PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_setResourceByID); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setResourceByID)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setResourceByID", "self, type, id");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	Char4	type;
	int	id = (int)SvIV(ST(2));

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			type = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    type = makelong(c);
		}
	};
#line 2712 "Pilot.xs"
	{
	   int result, index;

	    result = dlp_ReadResourceByType(self->socket, self->handle, type, id, &pibuf, &index);
	    ReturnReadResource(pibuf.data, pibuf.used);
	}
#line 4281 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_getResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getResource", "self, index");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	index = (int)SvIV(ST(1));

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2724 "Pilot.xs"
	{
	    int result, id;
	    Char4 type;

	    result = dlp_ReadResourceByIndex(self->socket, self->handle, index, &pibuf, &type, &id);
	    ReturnReadResource(pibuf.data, pibuf.used);
	}
#line 4319 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_setResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setResource", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2737 "Pilot.xs"
	{
		STRLEN len;
		int result;
		Char4 type;
		int id;
		void * c;
		PackResource;
		c = SvPV(data, len);
		result = dlp_WriteResource(self->socket, self->handle, type, id, c, len);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else
			RETVAL = newSViv(result);
	}
#line 4364 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_deleteResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_deleteResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::deleteResource", "self, type, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Char4	type;
	int	id = (int)SvIV(ST(2));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			type = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    type = makelong(c);
		}
	};
#line 2761 "Pilot.xs"
	RETVAL = dlp_DeleteResource(self->socket, self->handle, 0, type, id);
#line 4407 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_deleteResources); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_deleteResources)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::deleteResources", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP__DB *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2769 "Pilot.xs"
	RETVAL = dlp_DeleteResource(self->socket, self->handle, 1, 0, 0);
#line 4442 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLP__DBPtr_getPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_getPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::getPref", "self, id=0, backup=1");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	int	id;
	int	backup;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 2)
	    id = 0;
	else {
	    id = (int)SvIV(ST(1));
	}

	if (items < 3)
	    backup = 1;
	else {
	    backup = (int)SvIV(ST(2));
	}
#line 2779 "Pilot.xs"
	{
		Char4 creator;
	    int version, result;
		size_t len;
	    SV * c, n, v;
	    int r;
		if (self->Class) {
			int count;
			PUSHMARK(sp);
			XPUSHs(self->Class);
			PUTBACK;
			count = perl_call_method("creator", G_SCALAR);
			SPAGAIN;
			if (count != 1)
				croak("Unable to get creator");
			creator = SvChar4(POPs);
			PUTBACK;
        }
        if (pi_version(self->socket)< 0x101)
		    r = dlp_CloseDB(self->socket, self->handle);
	    result = dlp_ReadAppPreference(self->socket, creator, id, backup, 0xFFFF, mybuf, &len, &version);
	    if (pi_version(self->socket)< 0x101)
		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,na), &self->handle);
	    ReturnReadPref(mybuf, len);
	}
#line 4516 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_setPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setPref", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");
#line 2810 "Pilot.xs"
	{
		Char4	creator;
		int id;
		int	version;
		int	backup;
	    STRLEN len;
	    int result;
	    void * buf;
	    int r;
	    PackPref;
	    buf = SvPV(data, len);
    	if (pi_version(self->socket)< 0x101)
	    	r = dlp_CloseDB(self->socket, self->handle);
	    result = dlp_WriteAppPreference(self->socket, creator, id, backup, version, buf, len);
    	if (pi_version(self->socket)< 0x101)
		    r = dlp_OpenDB(self->socket, self->dbcard, self->dbmode, SvPV(self->dbname,na), &self->handle);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			RETVAL = newSViv(result);
		}
	}
#line 4571 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLP__DBPtr_setPrefRaw); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLP__DBPtr_setPrefRaw)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 4 || items > 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLP::DBPtr::setPrefRaw", "self, data, number, version, backup=1");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP__DB *	self;
	SV *	data = ST(1);
	int	number = (int)SvIV(ST(2));
	int	version = (int)SvIV(ST(3));
	int	backup;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLP::DBPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP__DB *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLP::DBPtr");

	if (items < 5)
	    backup = 1;
	else {
	    backup = (int)SvIV(ST(4));
	}
#line 2842 "Pilot.xs"
	{
	    STRLEN len;
		Char4 creator;
	    int version, result;
	    void * buf;
	    PackRaw;
	    buf = SvPV(data, len);
		if (self->Class) {
			int count;
			PUSHMARK(sp);
			XPUSHs(self->Class);
			PUTBACK;
			count = perl_call_method("creator", G_SCALAR);
			SPAGAIN;
			if (count != 1)
				croak("Unable to get creator");
			creator = SvChar4(POPs);
			PUTBACK;
        }
	    result = dlp_WriteAppPreference(self->socket, creator, number, backup, version, buf, len);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			RETVAL = newSViv(result);
		}
	}
#line 4639 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::DESTROY", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(PDA__Pilot__DLP *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"PDA::Pilot::DLPPtr::DESTROY",
			"self");
#line 2877 "Pilot.xs"
	if (self->socket)
		pi_close(self->socket);
	free(self);
#line 4672 "Pilot.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_PDA__Pilot__DLPPtr_errno); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_errno)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::errno", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2885 "Pilot.xs"
		RETVAL = self->errnop;
		self->errnop = 0;
#line 4703 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_palmos_errno); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_palmos_errno)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::palmos_errno", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2894 "Pilot.xs"
		RETVAL = pi_palmos_error(self->socket);
#line 4734 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getTime); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getTime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getTime", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2902 "Pilot.xs"
	{
		time_t t;
		int result = dlp_GetSysDateTime(self->socket, &t);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else
			RETVAL = newSViv(t);
	}
#line 4772 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_setTime); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_setTime)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::setTime", "self, time");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	long	time = (long)SvIV(ST(1));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2919 "Pilot.xs"
	RETVAL = dlp_SetSysDateTime(self->socket, time);
#line 4804 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getSysInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getSysInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getSysInfo", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2927 "Pilot.xs"
	{
		struct SysInfo si;
		int result = dlp_ReadSysInfo(self->socket, &si);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			HV * i = newHV();
			hv_store(i, "romVersion", 10, newSViv(si.romVersion), 0);\
	    	hv_store(i, "locale", 6, newSViv(si.locale), 0);\
	    	hv_store(i, "product", 4, newSVpvn(si.prodID, si.prodIDLength), 0);\
			RETVAL = newRV((SV*)i);
		}
	}
#line 4852 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getCardInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getCardInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getCardInfo", "self, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	cardno;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 2)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(1));
	}
#line 2949 "Pilot.xs"
	{
		struct CardInfo c;
		int result = dlp_ReadStorageInfo(self->socket, cardno, &c);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			HV * i = newHV();
			hv_store(i, "card", 6, newSViv(c.card), 0);\
	    	hv_store(i, "version", 7, newSViv(c.version), 0);\
	    	hv_store(i, "created", 8, newSViv(c.creation), 0);\
	    	hv_store(i, "romSize", 7, newSViv(c.romSize), 0);\
	    	hv_store(i, "ramSize", 7, newSViv(c.ramSize), 0);\
	    	hv_store(i, "ramFree", 7, newSViv(c.ramFree), 0);\
	    	hv_store(i, "name", 4, newSVpv(c.name,0), 0);\
	    	hv_store(i, "manufacturer", 12, newSVpv(c.manufacturer,0), 0);\
			RETVAL = newRV((SV*)i);
		}
	}
#line 4908 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_setUserInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_setUserInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::setUserInfo", "self, info");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	UserInfo	info;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	unpack_userinfo(ST(1), info);
#line 2976 "Pilot.xs"
	RETVAL = dlp_WriteUserInfo(self->socket, &info);
#line 4943 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getBattery); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getBattery)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getBattery", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 2984 "Pilot.xs"
	{
		int warn, critical, ticks, kind, AC;
		unsigned long voltage;
		int result;
		struct RPC_params p;

		PackRPC(&p,0xA0B6, RPC_IntReply,
			RPC_Byte(0), RPC_ShortPtr(&warn), RPC_ShortPtr(&critical),
			RPC_ShortPtr(&ticks), RPC_BytePtr(&kind), RPC_BytePtr(&AC), RPC_End);

		result = dlp_RPC(self->socket, &p, &voltage);

		if (result==0) {
			EXTEND(sp,5);
			PUSHs(sv_2mortal(newSVnv((float)voltage/100)));
			PUSHs(sv_2mortal(newSVnv((float)warn/100)));
			PUSHs(sv_2mortal(newSVnv((float)critical/100)));
			PUSHs(sv_2mortal(newSViv(kind)));
			PUSHs(sv_2mortal(newSViv(AC)));
		}
	}
#line 4994 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_getUserInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getUserInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getUserInfo", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3010 "Pilot.xs"
	{
		UserInfo info;
		int result;
		result = dlp_ReadUserInfo(self->socket, &info);
		pack_userinfo(RETVAL, info, result);
	}
#line 5029 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_newPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_newPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::newPref", "self, creator, id=0, version=0, backup=0");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	Char4	creator;
	SV *	id;
	SV *	version;
	SV *	backup;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			creator = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    creator = makelong(c);
		}
	};

	if (items < 3)
	    id = 0;
	else {
	    id = ST(2);
	}

	if (items < 4)
	    version = 0;
	else {
	    version = ST(3);
	}

	if (items < 5)
	    backup = 0;
	else {
	    backup = ST(4);
	}
#line 3027 "Pilot.xs"
	{
		HV * h = perl_get_hv("PDA::Pilot::PrefClasses", 0);
		SV ** s;										
   		int count;											
		if (!h)												
			croak("PrefClasses doesn't exist");				
		s = hv_fetch(h, printlong(creator), 4, 0);			
		if (!s)												
			s = hv_fetch(h, "", 0, 0);						
		if (!s)												
			croak("Default PrefClass not defined");			
   		PUSHMARK(sp);										
   		XPUSHs(newSVsv(*s));								
   		XPUSHs(&sv_undef);									
    	XPUSHs(sv_2mortal(newSVChar4(creator)));			
    	if (id)
	    	XPUSHs(id);					
	    if (version)
	    	XPUSHs(version);				
	    if (backup)
	    	XPUSHs(backup);
    	PUTBACK;											
    	count = perl_call_method("pref", G_SCALAR);			
    	SPAGAIN;											
    	if (count != 1)										
    		croak("Unable to create resource");				
    }
#line 5119 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_delete); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_delete)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::delete", "self, name, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	char *	name = (char *)SvPV_nolen(ST(1));
	int	cardno;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 3)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(2));
	}
#line 3061 "Pilot.xs"
	{
		UserInfo info;
		int result;
		RETVAL = dlp_DeleteDB(self->socket, cardno, name);
	}
#line 5161 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_open); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_open)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::open", "self, name, mode=0, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	char *	name = (char *)SvPV_nolen(ST(1));
	SV *	mode;
	int	cardno;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 3)
	    mode = 0;
	else {
	    mode = ST(2);
	}

	if (items < 4)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(3));
	}
#line 3076 "Pilot.xs"
	{
		int handle;
		int nummode;
		int result;
		if (!mode)
			nummode = dlpOpenRead|dlpOpenWrite|dlpOpenSecret;
		else {
			char *c;
			STRLEN len;
			nummode = SvIV(mode);
			if (SvPOKp(mode)) {
				c = SvPV(mode, len);
				while (*c) {
					switch (*c) {
					case 'r':
						nummode |= dlpOpenRead;
						break;
					case 'w':
						nummode |= dlpOpenWrite;
						break;
					case 'x':
						nummode |= dlpOpenExclusive;
						break;
					case 's':
						nummode |= dlpOpenSecret;
						break;
					}
					c++;
				}
			}
		}
		result = dlp_OpenDB(self->socket, cardno, nummode, name, &handle);
		if (result<0) {
			self->errnop = result;
			RETVAL = &sv_undef;
		} else {
			int type;
			PDA__Pilot__DLP__DB * x = malloc(sizeof(PDA__Pilot__DLP__DB));
			SV * sv = newSViv((IV)(void*)x);
			SvREFCNT_inc(ST(0));
			x->connection = ST(0);
			x->socket = self->socket;
			x->handle = handle;
			x->errnop = 0;
			x->dbname = newSVpv(name,0);
			x->dbmode = nummode;
			x->dbcard = cardno;
			RETVAL = newRV(sv);
			SvREFCNT_dec(sv);
			sv_bless(RETVAL, gv_stashpv("PDA::Pilot::DLP::DBPtr",0));
			{
				HV * h = perl_get_hv("PDA::Pilot::DBClasses", 0);
				SV ** s;
				if (!h)
					croak("DBClasses doesn't exist");
				s = hv_fetch(h, name, strlen(name), 0);
				if (!s)
					s = hv_fetch(h, "", 0, 0);
				if (!s)
					croak("Default DBClass not defined");
				x->Class = *s; 
				SvREFCNT_inc(*s);
			}
		}
	}
#line 5275 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_create); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_create)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 6 || items > 7)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::create", "self, name, creator, type, flags, version, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	char *	name = (char *)SvPV_nolen(ST(1));
	Char4	creator;
	Char4	type;
	int	flags = (int)SvIV(ST(4));
	int	version = (int)SvIV(ST(5));
	int	cardno;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(2)) || SvNOKp(ST(2)))
			creator = SvIV(ST(2));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(2), len);
		    creator = makelong(c);
		}
	};

	{
		if (SvIOKp(ST(3)) || SvNOKp(ST(3)))
			type = SvIV(ST(3));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(3), len);
		    type = makelong(c);
		}
	};

	if (items < 7)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(6));
	}
#line 3154 "Pilot.xs"
	{
		int handle;
		int result = dlp_CreateDB(self->socket, creator, type, cardno, flags, version, name, &handle);
		if (result<0) {
			self->errnop = result;
			RETVAL = &sv_undef;
		} else {
			PDA__Pilot__DLP__DB * x = malloc(sizeof(PDA__Pilot__DLP__DB));
			SV * sv = newSViv((IV)(void*)x);
			SvREFCNT_inc(ST(0));
			x->connection = ST(0);
			x->socket = self->socket;
			x->handle = handle;
			x->errnop = 0;
			x->dbname = newSVpv(name,0);
			x->dbmode = dlpOpenRead|dlpOpenWrite|dlpOpenSecret;
			x->dbcard = cardno;
			RETVAL = newRV(sv);
			SvREFCNT_dec(sv);
			sv_bless(RETVAL, gv_stashpv("PDA::Pilot::DLP::DBPtr",0));
			{
				HV * h = perl_get_hv("PDA::Pilot::DBClasses", 0);
				SV ** s;
				if (!h)
					croak("DBClasses doesn't exist");
				s = hv_fetch(h, name, strlen(name), 0);
				if (!s)
					s = hv_fetch(h, "", 0, 0);
				if (!s)
					croak("Default DBClass not defined");
				x->Class = *s; 
				SvREFCNT_inc(*s);
			}
		}
	}
#line 5372 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getPref", "self, creator, id=0, backup=1");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	Char4	creator;
	int	id;
	int	backup;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			creator = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    creator = makelong(c);
		}
	};

	if (items < 3)
	    id = 0;
	else {
	    id = (int)SvIV(ST(2));
	}

	if (items < 4)
	    backup = 1;
	else {
	    backup = (int)SvIV(ST(3));
	}
#line 3201 "Pilot.xs"
	{
	    int version, result;
		size_t len;
	    SV * c, n, v;
	    result = dlp_ReadAppPreference(self->socket, creator, id, backup, 0xFFFF, mybuf, &len, &version);
	    ReturnReadPref(mybuf, len);
	}
#line 5435 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_setPref); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_setPref)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::setPref", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	SV *	data = ST(1);
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3214 "Pilot.xs"
	{
		Char4	creator;
		int id;
		int	version;
		int	backup;
	    STRLEN len;
	    int result;
	    void * buf;
	    PackPref;
	    buf = SvPV(data, len);
	    result = dlp_WriteAppPreference(self->socket, creator, id, backup, version, buf, len);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			RETVAL = newSViv(result);
		}
	}
#line 5485 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_setPrefRaw); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_setPrefRaw)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 5 || items > 6)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::setPrefRaw", "self, data, creator, number, version, backup=1");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	SV *	data = ST(1);
	Char4	creator;
	int	number = (int)SvIV(ST(3));
	int	version = (int)SvIV(ST(4));
	int	backup;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(2)) || SvNOKp(ST(2)))
			creator = SvIV(ST(2));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(2), len);
		    creator = makelong(c);
		}
	};

	if (items < 6)
	    backup = 1;
	else {
	    backup = (int)SvIV(ST(5));
	}
#line 3242 "Pilot.xs"
	{
	    STRLEN len;
	    int version, result;
	    void * buf;
	    PackRaw;
	    buf = SvPV(data, len);
	    result = dlp_WriteAppPreference(self->socket, creator, number, backup, version, buf, len);
		if (result < 0) {
			self->errnop = result;
			RETVAL = newSVsv(&sv_undef);
		} else {
			RETVAL = newSViv(result);
		}
	}
#line 5551 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::close", "self, status=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	status;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 2)
	    status = 0;
	else {
	    status = (int)SvIV(ST(1));
	}
#line 3263 "Pilot.xs"
	RETVAL = dlp_EndOfSync(self->socket, status) || pi_close(self->socket);
	if (!RETVAL)
		self->socket = 0;
#line 5590 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_abort); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_abort)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::abort", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3273 "Pilot.xs"
	RETVAL = dlp_AbortSync(self->socket) || pi_close(self->socket);
	if (!RETVAL)
		self->socket = 0;
#line 5627 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_reset); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_reset)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::reset", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3283 "Pilot.xs"
	RETVAL = dlp_ResetSystem(self->socket);
#line 5662 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getStatus); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getStatus)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getStatus", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3291 "Pilot.xs"
	RETVAL = dlp_OpenConduit(self->socket);
#line 5697 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_log); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_log)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::log", "self, message");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	char *	message = (char *)SvPV_nolen(ST(1));
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3300 "Pilot.xs"
	RETVAL = dlp_AddSyncLogEntry(self->socket,message);
#line 5733 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_dirty); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_dirty)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::dirty", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	Result	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3309 "Pilot.xs"
	RETVAL = dlp_ResetLastSyncPC(self->socket);
#line 5768 "Pilot.c"
	ST(0) = sv_newmortal();
	if (RETVAL < 0) {
		sv_setsv(ST(0), &sv_no);
		self->errnop = RETVAL;
	} else
		sv_setsv(ST(0), &sv_yes);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getDBInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getDBInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 2 || items > 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getDBInfo", "self, start, RAM=1, ROM=0, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	start = (int)SvIV(ST(1));
	int	RAM;
	int	ROM;
	int	cardno;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 3)
	    RAM = 1;
	else {
	    RAM = (int)SvIV(ST(2));
	}

	if (items < 4)
	    ROM = 0;
	else {
	    ROM = (int)SvIV(ST(3));
	}

	if (items < 5)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(4));
	}
#line 3321 "Pilot.xs"
	{
		struct DBInfo info;

		int where = (RAM ? dlpDBListRAM : 0) | (ROM ? dlpDBListROM : 0);
		int result = dlp_ReadDBList(self->socket, cardno, where, start, &pibuf);
		pack_dbinfo(RETVAL,(*(struct DBInfo *)(pibuf.data)), result);
	}
#line 5831 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_findDBInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_findDBInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 5 || items > 6)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::findDBInfo", "self, start, name, creator, type, cardno=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	start = (int)SvIV(ST(1));
	SV *	name = ST(2);
	SV *	creator = ST(3);
	SV *	type = ST(4);
	int	cardno;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	if (items < 6)
	    cardno = 0;
	else {
	    cardno = (int)SvIV(ST(5));
	}
#line 3340 "Pilot.xs"
	{
		struct DBInfo info;
		Char4 c,t;
		int result;
		if (SvOK(creator))
			c = SvChar4(creator);
		else
			c = 0;
		if (SvOK(type))
			t = SvChar4(type);
		else
			t = 0;
		result = dlp_FindDBInfo(self->socket, cardno, start, 
			SvOK(name) ? SvPV(name,na) : 0,
			t, c, &info);
		pack_dbinfo(RETVAL, info, result);
	}
#line 5889 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getFeature); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getFeature)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getFeature", "self, creator, number");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	Char4	creator;
	int	number = (int)SvIV(ST(2));
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			creator = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    creator = makelong(c);
		}
	};
#line 3366 "Pilot.xs"
	{
		unsigned long f;
		int result;
		if ((result = dlp_ReadFeature(self->socket, creator, number, &f))<0) {
			RETVAL = newSVsv(&sv_undef);
			self->errnop = result;
		} else {
			RETVAL = newSViv(f);
		}
	}
#line 5941 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_getROMToken); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_getROMToken)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::getROMToken", "self, token");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	Char4	token;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			token = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    token = makelong(c);
		}
	};
#line 3385 "Pilot.xs"
	{
		char buffer[50];
		long long_token;
		size_t size;
		int result;

		result = dlp_GetROMToken(self->socket, token, buffer, &size);

		if (result==0) {
			EXTEND(sp,1);
			PUSHs(sv_2mortal(newSVpvn(buffer, size)));
		}
	}
#line 5996 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_callApplication); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_callApplication)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 4 || items > 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::callApplication", "self, creator, type, action, data=&sv_undef");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__DLP *	self;
	Char4	creator;
	Char4	type;
	int	action = (int)SvIV(ST(3));
	SV *	data;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");

	{
		if (SvIOKp(ST(1)) || SvNOKp(ST(1)))
			creator = SvIV(ST(1));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(1), len);
		    creator = makelong(c);
		}
	};

	{
		if (SvIOKp(ST(2)) || SvNOKp(ST(2)))
			type = SvIV(ST(2));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(2), len);
		    type = makelong(c);
		}
	};

	if (items < 5)
	    data = &sv_undef;
	else {
	    data = ST(4);
	}
#line 3407 "Pilot.xs"
	{
		unsigned long retcode;
		STRLEN len;
		int result;
		(void)SvPV(data,len);
		result = dlp_CallApplication(self->socket, creator, 
				    type, action, len, SvPV(data,na),
		                    &retcode, &pibuf);
		EXTEND(sp, 2);
		if (result >= 0) {
		        PUSHs(sv_2mortal(newSVpvn((char *) pibuf.data, pibuf.used)));
			if (GIMME != G_SCALAR) {
				PUSHs(sv_2mortal(newSViv(retcode)));
			}
		} else
			PUSHs(&sv_undef);
	}
#line 6073 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__DLPPtr_tickle); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_tickle)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::tickle", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3429 "Pilot.xs"
	{
		RETVAL = pi_tickle(self->socket);
	}
#line 6106 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__DLPPtr_watchdog); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__DLPPtr_watchdog)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::DLPPtr::watchdog", "self, interval");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__DLP *	self;
	int	interval = (int)SvIV(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::DLPPtr");
#line 3440 "Pilot.xs"
	{
		RETVAL = pi_watchdog(self->socket, interval);
	}
#line 6140 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__File_open); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__File_open)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::File::open", "name");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	char *	name = (char *)SvPV_nolen(ST(0));
	PDA__Pilot__File *	RETVAL;
#line 3452 "Pilot.xs"
	{
		RETVAL = calloc(sizeof(PDA__Pilot__File),1);
		RETVAL->errnop = 0;
		RETVAL->pf = pi_file_open(name);
		{
			HV * h = perl_get_hv("PDA::Pilot::DBClasses", 0);
			SV ** s;
			if (!h)
				croak("DBClasses doesn't exist");
			s = hv_fetch(h, name, strlen(name), 0);
			if (!s)
				s = hv_fetch(h, "", 0, 0);
			if (!s)
				croak("Default DBClass not defined");
			RETVAL->Class = *s; 
			SvREFCNT_inc(*s);
		}
	}
#line 6180 "Pilot.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "PDA::Pilot::FilePtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__File_create); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__File_create)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::File::create", "name, info");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	char *	name = (char *)SvPV_nolen(ST(0));
	DBInfo	info;
	PDA__Pilot__File *	RETVAL;

	unpack_dbinfo(ST(1), info);
#line 3478 "Pilot.xs"
	RETVAL = calloc(sizeof(PDA__Pilot__File),1);
	RETVAL->errnop = 0;
	RETVAL->pf = pi_file_create(name, &info);
	{
		HV * h = perl_get_hv("PDA::Pilot::DBClasses", 0);
		SV ** s;
		if (!h)
			croak("DBClasses doesn't exist");
		s = hv_fetch(h, name, strlen(name), 0);
		if (!s)
			s = hv_fetch(h, "", 0, 0);
		if (!s)
			croak("Default DBClass not defined");
		RETVAL->Class = *s; 
		SvREFCNT_inc(*s);
	}
#line 6222 "Pilot.c"
	ST(0) = sv_newmortal();
	sv_setref_pv(ST(0), "PDA::Pilot::FilePtr", (void*)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_errno); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_errno)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::errno", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3503 "Pilot.xs"
		RETVAL = self->errnop;
		self->errnop = 0;
#line 6255 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_DESTROY); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_DESTROY)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::DESTROY", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;

	if (SvROK(ST(0))) {
	    IV tmp = SvIV((SV*)SvRV(ST(0)));
	    self = INT2PTR(PDA__Pilot__File *,tmp);
	}
	else
	    Perl_croak(aTHX_ "%s: %s is not a reference",
			"PDA::Pilot::FilePtr::DESTROY",
			"self");
#line 3512 "Pilot.xs"
	if (self->pf)
		pi_file_close(self->pf);
	if (self->Class)
		SvREFCNT_dec(self->Class);
	free(self);
#line 6290 "Pilot.c"
    }
    XSRETURN_EMPTY;
}


XS(XS_PDA__Pilot__FilePtr_class); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_class)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items < 1 || items > 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::class", "self, name=0");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	name;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");

	if (items < 2)
	    name = 0;
	else {
	    name = ST(1);
	}
#line 3523 "Pilot.xs"
	{
		SV ** s = 0;
		HV * h;
		if (name) {
			STRLEN len;
			h = perl_get_hv("PDA::Pilot::DBClasses", 0);
			if (!h)
				croak("DBClasses doesn't exist");
			if (SvOK(name)) {
				(void)SvPV(name, len);
				s = hv_fetch(h, SvPV(name, na), len, 0);
			}
			if (!s)
				s = hv_fetch(h, "", 0, 0);
			if (!s)
				croak("Default DBClass not defined");
			SvREFCNT_inc(*s);
			if (self->Class)
				SvREFCNT_dec(self->Class);
			self->Class = *s;
		}
		RETVAL = newSVsv(self->Class);
	}
#line 6348 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_close); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_close)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::close", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3553 "Pilot.xs"
	if (self->pf) {
		RETVAL = pi_file_close(self->pf);
		self->pf = 0;
	} else
		RETVAL = 0;
#line 6384 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_getAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getAppBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__File *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3565 "Pilot.xs"
	{
		int result = 0;
	    size_t len;
	    void * buf;
		pi_file_get_app_info(self->pf, &buf, &len);
		ReturnReadAI(buf, (int)len);
	}
#line 6422 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__FilePtr_getSortBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getSortBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getSortBlock", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__File *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3577 "Pilot.xs"
	{
		int result = 0;
	    size_t len;
	    void * buf;
		pi_file_get_sort_info(self->pf, &buf, &len);
		ReturnReadSI(buf, (int)len);
	}
#line 6460 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__FilePtr_getRecords); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getRecords)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getRecords", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3590 "Pilot.xs"
	{
		int len, result = 0;
		pi_file_get_entries(self->pf, &len);
		RETVAL = newSViv((int)len);
	}
#line 6494 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_getResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getResource", "self, index");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	int	index = (int)SvIV(ST(1));
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3603 "Pilot.xs"
	{
	    int result, id;
		size_t len;
	    Char4 type;
	    void * buf;
		result = pi_file_read_resource(self->pf, index, &buf, &len, &type, &id);
		ReturnReadResource(buf,(int)len);
	}
#line 6533 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_getRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getRecord", "self, index");
    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	PDA__Pilot__File *	self;
	int	index = (int)SvIV(ST(1));
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3619 "Pilot.xs"
	{
	    int result, attr, category;
		size_t len;
	    unsigned long id;
	    void * buf;
		result = pi_file_read_record(self->pf, index, &buf, &len, &attr, &category, &id);
		ReturnReadRecord(buf,(int)len);
	}
#line 6574 "Pilot.c"
	PUTBACK;
	return;
    }
}


XS(XS_PDA__Pilot__FilePtr_getRecordByID); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getRecordByID)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getRecordByID", "self, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	unsigned long	id = (unsigned long)SvUV(ST(1));
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3634 "Pilot.xs"
	{
	    int result;
		size_t len;
	    int attr, category, index;
	    void * buf;
		result = pi_file_read_record_by_id(self->pf, id, &buf, &len, &index, &attr, &category);
		ReturnReadRecord(buf, (int)len);
	}
#line 6612 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_checkID); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_checkID)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::checkID", "self, uid");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	unsigned long	uid = (unsigned long)SvUV(ST(1));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3650 "Pilot.xs"
	RETVAL = pi_file_id_used(self->pf, uid);
#line 6645 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_getDBInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_getDBInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 1)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::getDBInfo", "self");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	RETVAL;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3658 "Pilot.xs"
	{
		DBInfo result;
		pi_file_get_info(self->pf, &result);
		pack_dbinfo(RETVAL, result, 0);
	}
#line 6679 "Pilot.c"
	ST(0) = RETVAL;
	sv_2mortal(ST(0));
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_setDBInfo); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_setDBInfo)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::setDBInfo", "self, info");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	DBInfo	info;
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");

	unpack_dbinfo(ST(1), info);
#line 3671 "Pilot.xs"
	RETVAL = pi_file_set_info(self->pf, &info);
#line 6714 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_setAppBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_setAppBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::setAppBlock", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	data = ST(1);
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3680 "Pilot.xs"
	{
	    STRLEN len;
	    char * c;
	    PackAI;
	    c = SvPV(data, len);
		RETVAL = pi_file_set_app_info(self->pf, c, len);
    }
#line 6752 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_setSortBlock); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_setSortBlock)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::setSortBlock", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	data = ST(1);
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3695 "Pilot.xs"
	{
	    STRLEN len;
	    char * c;
	    PackSI;
	    c = SvPV(data, len);
		RETVAL = pi_file_set_sort_info(self->pf, c, len);
    }
#line 6790 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_addResource); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_addResource)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 4)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::addResource", "self, data, type, id");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	data = ST(1);
	Char4	type;
	int	id = (int)SvIV(ST(3));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");

	{
		if (SvIOKp(ST(2)) || SvNOKp(ST(2)))
			type = SvIV(ST(2));
		else {
		    STRLEN len;
		    char * c = SvPV(ST(2), len);
		    type = makelong(c);
		}
	};
#line 3712 "Pilot.xs"
	{
	    STRLEN len;
	    int result;
	    void * buf;
	    PackResource;
	    buf = SvPV(data, len);
		RETVAL = pi_file_append_resource(self->pf, buf, len, type, id);
	}
#line 6841 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_addRecord); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_addRecord)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 2)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::addRecord", "self, data");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	data = ST(1);
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3728 "Pilot.xs"
	{
	    STRLEN len;
	    unsigned long id;
	    int attr, category;
	    int result;
	    void * buf;
	    PackRecord;
	    buf = SvPV(data, len);
		RETVAL = pi_file_append_record(self->pf, buf, len, attr, category, id);
	}
#line 6882 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_addRecordRaw); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_addRecordRaw)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 5)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::addRecordRaw", "self, data, uid, attr, category");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	SV *	data = ST(1);
	unsigned long	uid = (unsigned long)SvUV(ST(2));
	int	attr = (int)SvIV(ST(3));
	int	category = (int)SvIV(ST(4));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");
#line 3749 "Pilot.xs"
	{
	    STRLEN len;
	    int result;
	    void * buf;
	    PackRaw;
	    buf = SvPV(data, len);
		RETVAL = pi_file_append_record(self->pf, buf, len, attr, category, uid);
	}
#line 6924 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_install); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_install)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::install", "self, socket, cardno");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	PDA__Pilot__DLP *	socket;
	int	cardno = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");

	if (sv_derived_from(ST(1), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		socket = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("socket is not of type PDA::Pilot::DLPPtr");
#line 3767 "Pilot.xs"
	RETVAL = pi_file_install(self->pf, socket->socket, cardno, NULL);
#line 6964 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS(XS_PDA__Pilot__FilePtr_retrieve); /* prototype to pass -Wmissing-prototypes */
XS(XS_PDA__Pilot__FilePtr_retrieve)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    if (items != 3)
       Perl_croak(aTHX_ "Usage: %s(%s)", "PDA::Pilot::FilePtr::retrieve", "self, socket, cardno");
    PERL_UNUSED_VAR(cv); /* -W */
    {
	PDA__Pilot__File *	self;
	PDA__Pilot__DLP *	socket;
	int	cardno = (int)SvIV(ST(2));
	int	RETVAL;
	dXSTARG;

	if (sv_derived_from(ST(0), "PDA::Pilot::FilePtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(0)));
		self = (PDA__Pilot__File *) tmp;
	}
	else
		croak("self is not of type PDA::Pilot::FilePtr");

	if (sv_derived_from(ST(1), "PDA::Pilot::DLPPtr")) {
		IV tmp = SvIV((SV*)SvRV(ST(1)));
		socket = (PDA__Pilot__DLP *) tmp;
	}
	else
		croak("socket is not of type PDA::Pilot::DLPPtr");
#line 3777 "Pilot.xs"
	RETVAL = pi_file_retrieve(self->pf, socket->socket, cardno, NULL);
#line 7004 "Pilot.c"
	XSprePUSH; PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C"
#endif
XS(boot_PDA__Pilot); /* prototype to pass -Wmissing-prototypes */
XS(boot_PDA__Pilot)
{
#ifdef dVAR
    dVAR; dXSARGS;
#else
    dXSARGS;
#endif
    char* file = __FILE__;

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
    XS_VERSION_BOOTCHECK ;

        newXS("PDA::Pilot::constant", XS_PDA__Pilot_constant, file);
        newXS("PDA::Pilot::Appointment::Unpack", XS_PDA__Pilot__Appointment_Unpack, file);
        newXS("PDA::Pilot::Appointment::Pack", XS_PDA__Pilot__Appointment_Pack, file);
        newXS("PDA::Pilot::Appointment::UnpackAppBlock", XS_PDA__Pilot__Appointment_UnpackAppBlock, file);
        newXS("PDA::Pilot::Appointment::PackAppBlock", XS_PDA__Pilot__Appointment_PackAppBlock, file);
        newXS("PDA::Pilot::ToDo::Unpack", XS_PDA__Pilot__ToDo_Unpack, file);
        newXS("PDA::Pilot::ToDo::Pack", XS_PDA__Pilot__ToDo_Pack, file);
        newXS("PDA::Pilot::ToDo::UnpackAppBlock", XS_PDA__Pilot__ToDo_UnpackAppBlock, file);
        newXS("PDA::Pilot::ToDo::PackAppBlock", XS_PDA__Pilot__ToDo_PackAppBlock, file);
        newXS("PDA::Pilot::Address::Unpack", XS_PDA__Pilot__Address_Unpack, file);
        newXS("PDA::Pilot::Address::Pack", XS_PDA__Pilot__Address_Pack, file);
        newXS("PDA::Pilot::Address::UnpackAppBlock", XS_PDA__Pilot__Address_UnpackAppBlock, file);
        newXS("PDA::Pilot::Address::PackAppBlock", XS_PDA__Pilot__Address_PackAppBlock, file);
        newXS("PDA::Pilot::Memo::Unpack", XS_PDA__Pilot__Memo_Unpack, file);
        newXS("PDA::Pilot::Memo::Pack", XS_PDA__Pilot__Memo_Pack, file);
        newXS("PDA::Pilot::Memo::UnpackAppBlock", XS_PDA__Pilot__Memo_UnpackAppBlock, file);
        newXS("PDA::Pilot::Memo::PackAppBlock", XS_PDA__Pilot__Memo_PackAppBlock, file);
        newXS("PDA::Pilot::Expense::Unpack", XS_PDA__Pilot__Expense_Unpack, file);
        newXS("PDA::Pilot::Expense::Pack", XS_PDA__Pilot__Expense_Pack, file);
        newXS("PDA::Pilot::Expense::UnpackAppBlock", XS_PDA__Pilot__Expense_UnpackAppBlock, file);
        newXS("PDA::Pilot::Expense::PackAppBlock", XS_PDA__Pilot__Expense_PackAppBlock, file);
        newXS("PDA::Pilot::Expense::UnpackPref", XS_PDA__Pilot__Expense_UnpackPref, file);
        newXS("PDA::Pilot::Expense::PackPref", XS_PDA__Pilot__Expense_PackPref, file);
        newXS("PDA::Pilot::Mail::Unpack", XS_PDA__Pilot__Mail_Unpack, file);
        newXS("PDA::Pilot::Mail::Pack", XS_PDA__Pilot__Mail_Pack, file);
        newXS("PDA::Pilot::Mail::UnpackAppBlock", XS_PDA__Pilot__Mail_UnpackAppBlock, file);
        newXS("PDA::Pilot::Mail::PackAppBlock", XS_PDA__Pilot__Mail_PackAppBlock, file);
        newXS("PDA::Pilot::Mail::UnpackSyncPref", XS_PDA__Pilot__Mail_UnpackSyncPref, file);
        newXS("PDA::Pilot::Mail::PackSyncPref", XS_PDA__Pilot__Mail_PackSyncPref, file);
        newXS("PDA::Pilot::Mail::UnpackSignaturePref", XS_PDA__Pilot__Mail_UnpackSignaturePref, file);
        newXS("PDA::Pilot::Mail::PackSignaturePref", XS_PDA__Pilot__Mail_PackSignaturePref, file);
        newXS("PDA::Pilot::close", XS_PDA__Pilot_close, file);
        newXS("PDA::Pilot::write", XS_PDA__Pilot_write, file);
        newXS("PDA::Pilot::read", XS_PDA__Pilot_read, file);
        newXS("PDA::Pilot::socket", XS_PDA__Pilot_socket, file);
        newXS("PDA::Pilot::listen", XS_PDA__Pilot_listen, file);
        newXS("PDA::Pilot::errorText", XS_PDA__Pilot_errorText, file);
        newXS("PDA::Pilot::bind", XS_PDA__Pilot_bind, file);
        newXS("PDA::Pilot::openPort", XS_PDA__Pilot_openPort, file);
        newXS("PDA::Pilot::accept", XS_PDA__Pilot_accept, file);
        newXS("PDA::Pilot::DLP::DBPtr::DESTROY", XS_PDA__Pilot__DLP__DBPtr_DESTROY, file);
        newXS("PDA::Pilot::DLP::DBPtr::errno", XS_PDA__Pilot__DLP__DBPtr_errno, file);
        newXS("PDA::Pilot::DLP::DBPtr::palmos_errno", XS_PDA__Pilot__DLP__DBPtr_palmos_errno, file);
        newXS("PDA::Pilot::DLP::DBPtr::class", XS_PDA__Pilot__DLP__DBPtr_class, file);
        newXS("PDA::Pilot::DLP::DBPtr::close", XS_PDA__Pilot__DLP__DBPtr_close, file);
        newXS("PDA::Pilot::DLP::DBPtr::setSortBlock", XS_PDA__Pilot__DLP__DBPtr_setSortBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::getAppBlock", XS_PDA__Pilot__DLP__DBPtr_getAppBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::getSortBlock", XS_PDA__Pilot__DLP__DBPtr_getSortBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::setAppBlock", XS_PDA__Pilot__DLP__DBPtr_setAppBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::purge", XS_PDA__Pilot__DLP__DBPtr_purge, file);
        newXS("PDA::Pilot::DLP::DBPtr::resetFlags", XS_PDA__Pilot__DLP__DBPtr_resetFlags, file);
        newXS("PDA::Pilot::DLP::DBPtr::deleteCategory", XS_PDA__Pilot__DLP__DBPtr_deleteCategory, file);
        newXS("PDA::Pilot::DLP::DBPtr::newRecord", XS_PDA__Pilot__DLP__DBPtr_newRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::newResource", XS_PDA__Pilot__DLP__DBPtr_newResource, file);
        newXS("PDA::Pilot::DLP::DBPtr::newAppBlock", XS_PDA__Pilot__DLP__DBPtr_newAppBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::newSortBlock", XS_PDA__Pilot__DLP__DBPtr_newSortBlock, file);
        newXS("PDA::Pilot::DLP::DBPtr::newPref", XS_PDA__Pilot__DLP__DBPtr_newPref, file);
        newXS("PDA::Pilot::DLP::DBPtr::getRecord", XS_PDA__Pilot__DLP__DBPtr_getRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::moveCategory", XS_PDA__Pilot__DLP__DBPtr_moveCategory, file);
        newXS("PDA::Pilot::DLP::DBPtr::deleteRecord", XS_PDA__Pilot__DLP__DBPtr_deleteRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::deleteRecords", XS_PDA__Pilot__DLP__DBPtr_deleteRecords, file);
        newXS("PDA::Pilot::DLP::DBPtr::resetNext", XS_PDA__Pilot__DLP__DBPtr_resetNext, file);
        newXS("PDA::Pilot::DLP::DBPtr::getRecords", XS_PDA__Pilot__DLP__DBPtr_getRecords, file);
        newXS("PDA::Pilot::DLP::DBPtr::getRecordIDs", XS_PDA__Pilot__DLP__DBPtr_getRecordIDs, file);
        newXS("PDA::Pilot::DLP::DBPtr::getRecordByID", XS_PDA__Pilot__DLP__DBPtr_getRecordByID, file);
        newXS("PDA::Pilot::DLP::DBPtr::getNextModRecord", XS_PDA__Pilot__DLP__DBPtr_getNextModRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::getNextRecord", XS_PDA__Pilot__DLP__DBPtr_getNextRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::setRecord", XS_PDA__Pilot__DLP__DBPtr_setRecord, file);
        newXS("PDA::Pilot::DLP::DBPtr::setRecordRaw", XS_PDA__Pilot__DLP__DBPtr_setRecordRaw, file);
        newXS("PDA::Pilot::DLP::DBPtr::setResourceByID", XS_PDA__Pilot__DLP__DBPtr_setResourceByID, file);
        newXS("PDA::Pilot::DLP::DBPtr::getResource", XS_PDA__Pilot__DLP__DBPtr_getResource, file);
        newXS("PDA::Pilot::DLP::DBPtr::setResource", XS_PDA__Pilot__DLP__DBPtr_setResource, file);
        newXS("PDA::Pilot::DLP::DBPtr::deleteResource", XS_PDA__Pilot__DLP__DBPtr_deleteResource, file);
        newXS("PDA::Pilot::DLP::DBPtr::deleteResources", XS_PDA__Pilot__DLP__DBPtr_deleteResources, file);
        newXS("PDA::Pilot::DLP::DBPtr::getPref", XS_PDA__Pilot__DLP__DBPtr_getPref, file);
        newXS("PDA::Pilot::DLP::DBPtr::setPref", XS_PDA__Pilot__DLP__DBPtr_setPref, file);
        newXS("PDA::Pilot::DLP::DBPtr::setPrefRaw", XS_PDA__Pilot__DLP__DBPtr_setPrefRaw, file);
        newXS("PDA::Pilot::DLPPtr::DESTROY", XS_PDA__Pilot__DLPPtr_DESTROY, file);
        newXS("PDA::Pilot::DLPPtr::errno", XS_PDA__Pilot__DLPPtr_errno, file);
        newXS("PDA::Pilot::DLPPtr::palmos_errno", XS_PDA__Pilot__DLPPtr_palmos_errno, file);
        newXS("PDA::Pilot::DLPPtr::getTime", XS_PDA__Pilot__DLPPtr_getTime, file);
        newXS("PDA::Pilot::DLPPtr::setTime", XS_PDA__Pilot__DLPPtr_setTime, file);
        newXS("PDA::Pilot::DLPPtr::getSysInfo", XS_PDA__Pilot__DLPPtr_getSysInfo, file);
        newXS("PDA::Pilot::DLPPtr::getCardInfo", XS_PDA__Pilot__DLPPtr_getCardInfo, file);
        newXS("PDA::Pilot::DLPPtr::setUserInfo", XS_PDA__Pilot__DLPPtr_setUserInfo, file);
        newXS("PDA::Pilot::DLPPtr::getBattery", XS_PDA__Pilot__DLPPtr_getBattery, file);
        newXS("PDA::Pilot::DLPPtr::getUserInfo", XS_PDA__Pilot__DLPPtr_getUserInfo, file);
        newXS("PDA::Pilot::DLPPtr::newPref", XS_PDA__Pilot__DLPPtr_newPref, file);
        newXS("PDA::Pilot::DLPPtr::delete", XS_PDA__Pilot__DLPPtr_delete, file);
        newXS("PDA::Pilot::DLPPtr::open", XS_PDA__Pilot__DLPPtr_open, file);
        newXS("PDA::Pilot::DLPPtr::create", XS_PDA__Pilot__DLPPtr_create, file);
        newXS("PDA::Pilot::DLPPtr::getPref", XS_PDA__Pilot__DLPPtr_getPref, file);
        newXS("PDA::Pilot::DLPPtr::setPref", XS_PDA__Pilot__DLPPtr_setPref, file);
        newXS("PDA::Pilot::DLPPtr::setPrefRaw", XS_PDA__Pilot__DLPPtr_setPrefRaw, file);
        newXS("PDA::Pilot::DLPPtr::close", XS_PDA__Pilot__DLPPtr_close, file);
        newXS("PDA::Pilot::DLPPtr::abort", XS_PDA__Pilot__DLPPtr_abort, file);
        newXS("PDA::Pilot::DLPPtr::reset", XS_PDA__Pilot__DLPPtr_reset, file);
        newXS("PDA::Pilot::DLPPtr::getStatus", XS_PDA__Pilot__DLPPtr_getStatus, file);
        newXS("PDA::Pilot::DLPPtr::log", XS_PDA__Pilot__DLPPtr_log, file);
        newXS("PDA::Pilot::DLPPtr::dirty", XS_PDA__Pilot__DLPPtr_dirty, file);
        newXS("PDA::Pilot::DLPPtr::getDBInfo", XS_PDA__Pilot__DLPPtr_getDBInfo, file);
        newXS("PDA::Pilot::DLPPtr::findDBInfo", XS_PDA__Pilot__DLPPtr_findDBInfo, file);
        newXS("PDA::Pilot::DLPPtr::getFeature", XS_PDA__Pilot__DLPPtr_getFeature, file);
        newXS("PDA::Pilot::DLPPtr::getROMToken", XS_PDA__Pilot__DLPPtr_getROMToken, file);
        newXS("PDA::Pilot::DLPPtr::callApplication", XS_PDA__Pilot__DLPPtr_callApplication, file);
        newXS("PDA::Pilot::DLPPtr::tickle", XS_PDA__Pilot__DLPPtr_tickle, file);
        newXS("PDA::Pilot::DLPPtr::watchdog", XS_PDA__Pilot__DLPPtr_watchdog, file);
        newXS("PDA::Pilot::File::open", XS_PDA__Pilot__File_open, file);
        newXS("PDA::Pilot::File::create", XS_PDA__Pilot__File_create, file);
        newXS("PDA::Pilot::FilePtr::errno", XS_PDA__Pilot__FilePtr_errno, file);
        newXS("PDA::Pilot::FilePtr::DESTROY", XS_PDA__Pilot__FilePtr_DESTROY, file);
        newXS("PDA::Pilot::FilePtr::class", XS_PDA__Pilot__FilePtr_class, file);
        newXS("PDA::Pilot::FilePtr::close", XS_PDA__Pilot__FilePtr_close, file);
        newXS("PDA::Pilot::FilePtr::getAppBlock", XS_PDA__Pilot__FilePtr_getAppBlock, file);
        newXS("PDA::Pilot::FilePtr::getSortBlock", XS_PDA__Pilot__FilePtr_getSortBlock, file);
        newXS("PDA::Pilot::FilePtr::getRecords", XS_PDA__Pilot__FilePtr_getRecords, file);
        newXS("PDA::Pilot::FilePtr::getResource", XS_PDA__Pilot__FilePtr_getResource, file);
        newXS("PDA::Pilot::FilePtr::getRecord", XS_PDA__Pilot__FilePtr_getRecord, file);
        newXS("PDA::Pilot::FilePtr::getRecordByID", XS_PDA__Pilot__FilePtr_getRecordByID, file);
        newXS("PDA::Pilot::FilePtr::checkID", XS_PDA__Pilot__FilePtr_checkID, file);
        newXS("PDA::Pilot::FilePtr::getDBInfo", XS_PDA__Pilot__FilePtr_getDBInfo, file);
        newXS("PDA::Pilot::FilePtr::setDBInfo", XS_PDA__Pilot__FilePtr_setDBInfo, file);
        newXS("PDA::Pilot::FilePtr::setAppBlock", XS_PDA__Pilot__FilePtr_setAppBlock, file);
        newXS("PDA::Pilot::FilePtr::setSortBlock", XS_PDA__Pilot__FilePtr_setSortBlock, file);
        newXS("PDA::Pilot::FilePtr::addResource", XS_PDA__Pilot__FilePtr_addResource, file);
        newXS("PDA::Pilot::FilePtr::addRecord", XS_PDA__Pilot__FilePtr_addRecord, file);
        newXS("PDA::Pilot::FilePtr::addRecordRaw", XS_PDA__Pilot__FilePtr_addRecordRaw, file);
        newXS("PDA::Pilot::FilePtr::install", XS_PDA__Pilot__FilePtr_install, file);
        newXS("PDA::Pilot::FilePtr::retrieve", XS_PDA__Pilot__FilePtr_retrieve, file);
    if (PL_unitcheckav)
         call_list(PL_scopestack_ix, PL_unitcheckav);
    XSRETURN_YES;
}

