#ifndef INCLUDE_MODULE_DISPLAY_H
#define INCLUDE_MODULE_DISPLAY_H
/* ----------------------------------------------------------------------------
 * module_display.h
 * prototypes and definitions for the module display.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#include <pbbtaglist.h>

#define  DEFAULT_FB_DEVICE	"/dev/fb0"

#ifndef KEY_KBDILLUMTOGGLE
#define KEY_KBDILLUMTOGGLE 228
#endif

#ifndef KEY_KBDILLUMDOWN
#define KEY_KBDILLUMDOWN   229
#endif

#ifndef KEY_KBDILLUMUP
#define KEY_KBDILLUMUP     230
#endif

#ifndef FBIOBLANK
#define FBIOBLANK	   0x4611 /* 0 or vesa-level+1 */
#endif

/* operation codes (OP) for display_setlevel() */
#define OP_DIM_LIGHT	1
#define OP_DIM_RECOVER	2
#define OP_DIM_OFF	3

#define LCD_BRIGHTNESS_OFF 0  /* lower ranges for light sources */
#define LCD_BRIGHTNESS_MIN 1
#define KBD_BRIGHTNESS_OFF 0
#define KBD_BRIGHTNESS_MIN 1

/* definitions for status */
#define STATUS_NORMAL 0
#define STATUS_DIMMED 1
#define STATUS_OFF    2

struct display_flags {
	unsigned int lmu_enable:1;
	unsigned int lcd_autoadjust:1;
	unsigned int kbd_autoadjust:1;
	unsigned int kbd_autoadjust_bak:1; /* copy of kbd_autoadjust */
	unsigned int ctrl_fb:1;	   /* 1, if framebuffer should be blanked too */
	unsigned int dimfullydark:1;
	unsigned int status:2;
	unsigned int coveropen:1;  /* track signal from TAG_COVERSTATUS */
	unsigned int :0;
};

struct display_light {
	int current;     /* current brightness value */
	int target;      /* brightness to set to */
	int max;         /* maximum brightness value */
	int backup;
	int offset;      /* users influence on automatic adjustment */
	int fadingspeed;
	int fadingcount;
	int threshold;   /* ambient threshold for automatic adjustment */
};

/* public prototypes */
int display_init (struct tagitem *taglist);
int display_exit ();

/* private prototypes */
void display_keyboard (struct tagitem *taglist);
void display_query (struct tagitem *taglist);
void display_configure (struct tagitem *taglist);
void display_timer (struct tagitem *taglist);
void display_ambienttimer (struct tagitem *taglist);
int display_handle_tags (int mode, struct tagitem *taglist);
int display_set_brightness(struct display_light *illu, int level);
void display_change_brightness(int op);
void display_framebuffer (int on);

#endif    /* INCLUDE_MODULE_DISPLAY_H */
