#ifndef INCLUDE_PBBTAGLIST_H
#define INCLUDE_PBBTAGLIST_H
/* ----------------------------------------------------------------------------
 * pbbtaglist.h
 * prototypes and definitions for pbbtaglist.c.
 *
 * Copyright 2002 Matthias Grimm
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version
 * 2 of the License, or (at your option) any later version.
 * ----------------------------------------------------------------------------*/

#define TAG_END			0
#define TAG_SKIP		1

#define FLG_STRING		0x8000
#define FLG_PRIVATE		0x4000
#define FLG_ERROR		0x2000
#define FLG_NOPEEP		0x1000  /* for pbbuttonsd internal use only */

#define MASK_ERROR		~FLG_ERROR

/* Flags for TAG_SYSINFO */
#define SYSINFO_CONFIGWRITABLE	0x01
#define SYSINFO_HAVELMU		0x02
#define SYSINFO_SLEEPSUPPORTED	0x04
#define SYSINFO_PMUDSUPPORT	0x08

typedef unsigned long tag_t;

struct tagitem {
	tag_t tag;
	tag_t data;
};

/* prototypes */
tag_t tagfind (struct tagitem *taglist, tag_t tag, tag_t val);
struct tagitem* find_tagitem (struct tagitem *taglist, long tag);
void tagskip (struct tagitem *taglist, tag_t tag);
int tagerror (struct tagitem *tag, int error);
void taglist_init (struct tagitem *taglist);
void taglist_add (struct tagitem *taglist, tag_t tag, tag_t val);
int taglist_count (struct tagitem *taglist);

#endif    /* INCLUDE_PBBTAGLIST_H */
