/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svxacorr.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:50:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MySVXACORR_HXX
#define _MySVXACORR_HXX

#ifndef _RTTI_HXX //autogen
#include <tools/rtti.hxx>
#endif
#ifndef _SVARRAY_HXX //autogen
#include <svtools/svarray.hxx>
#endif
#ifndef _LANG_HXX //autogen
#include <tools/lang.hxx>
#endif
#ifndef _TIME_HXX //autogen
#include <tools/time.hxx>
#endif
#ifndef _DATE_HXX //autogen
#include <tools/date.hxx>
#endif
#ifndef _STRING_HXX //autogen
#include <tools/string.hxx>
#endif
#ifndef _SVXSWAFOPT_HXX
#include <bf_svx/swafopt.hxx>
#endif
class CharClass;
class SfxPoolItem; 
class SvStringsISortDtor;
class SvStorage;
class SvStorageRef;
namespace binfilter {

class SvxAutoCorrect;
class SfxObjectShell;
class SvxAutoCorrLanguageTable_Impl;
class SvxAutoCorrLastFileAskTable_Impl;

// Flags fuer die AutoKorrekt-Flags
const long CptlSttSntnc		= 0x00000001;	// Gross-Buchstaben am SatzAnfang
const long CptlSttWrd		= 0x00000002;	// keine 2 Gr.-Buchst. am WordAnfang
const long ChgFractionSymbol= 0x00000004;	// 1/2, 1/4, .. ersetzen
const long ChgOrdinalNumber = 0x00000008;	// Ordinal-Number 1st, 2nd,..
const long ChgToEnEmDash    = 0x00000010;	// - -> Endash/Emdash
const long ChgWeightUnderl  = 0x00000020;	// * -> Fett, _ -> unterstreichen
const long SetINetAttr      = 0x00000040;	// INetAttribut setzen
const long Autocorrect 		= 0x00000080;	// Autokorrektur aufrufen
const long ChgQuotes		= 0x00000100;	// doppelte Quotes ersetzen
const long SaveWordCplSttLst= 0x00000200;	// GrB. am SatzAnf. auto. aufnehmen
const long SaveWordWrdSttLst= 0x00000400;	// 2 GrB. am WortAnf. auto. aufnehmen
const long IngnoreDoubleSpace= 0x00000800;	// 2 Spaces ignorieren
const long ChgSglQuotes		= 0x00001000;	// einfache Quotes ersetzen

const long ChgWordLstLoad	= 0x20000000;	// Ersetzungsliste geladen
const long CplSttLstLoad	= 0x40000000;	// Exceptionlist fuer CplStart geladen
const long WrdSttLstLoad	= 0x80000000;	// Exceptionlist fuer WordStart geladen

// nur eine Mappingklasse
//STRIP001 class SvxAutoCorrDoc
//STRIP001 {
//STRIP001 public:
//STRIP001 	SvxAutoCorrDoc() {}
//STRIP001 	virtual ~SvxAutoCorrDoc();
//STRIP001 
//STRIP001 	virtual BOOL Delete( xub_StrLen nStt, xub_StrLen nEnd ) = 0;
//STRIP001 	virtual BOOL Insert( xub_StrLen nPos, const String& rTxt ) = 0;
//STRIP001 	virtual BOOL Replace( xub_StrLen nPos, const String& rTxt ) = 0;
//STRIP001 
//STRIP001 	virtual BOOL SetAttr( xub_StrLen nStt, xub_StrLen nEnd, USHORT nSlotId,
//STRIP001 							SfxPoolItem& ) = 0;
//STRIP001 
//STRIP001 	virtual BOOL SetINetAttr( xub_StrLen nStt, xub_StrLen nEnd, const String& rURL ) = 0;
//STRIP001 
//STRIP001 	// returne den Text eines vorherigen Absatzes.
//STRIP001 	// Dieser darf nicht leer sein!
//STRIP001 	// Gibt es diesen nicht oder gibt es davor nur Leere, dann returne 0
//STRIP001 	// Das Flag gibt an:
//STRIP001 	//		TRUE: den, vor der normalen Einfuegeposition (TRUE)
//STRIP001 	// 		FALSE: den, in den das korrigierte Wort eingfuegt wurde.
//STRIP001 	//				(Muss nicht der gleiche Absatz sein!!!!)
//STRIP001 	virtual const String* GetPrevPara( BOOL bAtNormalPos ) = 0;
//STRIP001 
//STRIP001 	virtual BOOL ChgAutoCorrWord( xub_StrLen& rSttPos, xub_StrLen nEndPos,
//STRIP001 								  SvxAutoCorrect& rACorrect,
//STRIP001 								  const String** ppPara ) = 0;
//STRIP001 	// wird nach dem austauschen der Zeichen von den Funktionen
//STRIP001 	//	- FnCptlSttWrd
//STRIP001 	// 	- FnCptlSttSntnc
//STRIP001 	// gerufen. Dann koennen die Worte ggfs. in die Ausnahmelisten
//STRIP001 	// aufgenommen werden.
//STRIP001 	virtual void SaveCpltSttWord( ULONG nFlag, xub_StrLen nPos,
//STRIP001 									const String& rExceptWord,
//STRIP001 									sal_Unicode cChar );
//STRIP001 
//STRIP001 	// welche Sprache gilt an der Position?
//STRIP001 	virtual LanguageType GetLanguage( xub_StrLen nPos, BOOL bPrevPara = FALSE ) const;
//STRIP001 };

//STRIP001 class SvxAutocorrWord
//STRIP001 {
//STRIP001 	String sShort, sLong;
//STRIP001 	BOOL bIsTxtOnly;				// ist reiner ASCII - Text
//STRIP001 public:
//STRIP001 	SvxAutocorrWord( const String& rS, const String& rL, BOOL bFlag = TRUE )
//STRIP001 		: sShort( rS ), sLong( rL ), bIsTxtOnly( bFlag )
//STRIP001 	{}
//STRIP001 
//STRIP001 	const String& GetShort() const					{ return sShort; }
//STRIP001 	const String& GetLong() const					{ return sLong; }
//STRIP001 	BOOL IsTextOnly() const							{ return bIsTxtOnly; }
//STRIP001 };

//STRIP001 typedef SvxAutocorrWord* SvxAutocorrWordPtr;
//STRIP001 SV_DECL_PTRARR_SORT_DEL( SvxAutocorrWordList, SvxAutocorrWordPtr, 10, 10 )

class SvxAutoCorrectLanguageLists
{
//STRIP001 	String sShareAutoCorrFile, sUserAutoCorrFile;
//STRIP001 	// falls die AutoCorr Datei neuer ist
//STRIP001 	Date aModifiedDate;
//STRIP001 	Time aModifiedTime, aLastCheckTime;
//STRIP001 
//STRIP001 	LanguageType 			eLanguage; //LANGUAGE_DONTKNOW fuer alle Sprachen verwenden
//STRIP001 	SvStringsISortDtor* 	pCplStt_ExcptLst;
//STRIP001 	SvStringsISortDtor* 	pWrdStt_ExcptLst;
//STRIP001 	SvxAutocorrWordList* 	pAutocorr_List;
//STRIP001 	SvxAutoCorrect&			rAutoCorrect;
//STRIP001 
//STRIP001 	long nFlags;
//STRIP001 
//STRIP001 	BOOL IsFileChanged_Imp();
//STRIP001 	void LoadExceptList_Imp( SvStringsISortDtor*& rpLst,
//STRIP001 								const sal_Char* pStrmName,
//STRIP001 								SvStorageRef &rStg);
//STRIP001 	void LoadXMLExceptList_Imp( SvStringsISortDtor*& rpLst,
//STRIP001 								const sal_Char* pStrmName,
//STRIP001 								SvStorageRef &rStg);
//STRIP001 	void SaveExceptList_Imp( const SvStringsISortDtor& rLst,
//STRIP001 								const sal_Char* pStrmName,
//STRIP001 								SvStorageRef &rStg,
//STRIP001 								BOOL bConvert = FALSE);
//STRIP001 
//STRIP001 	BOOL MakeBlocklist_Imp( SvStorage& rStg );
//STRIP001 	void RemoveStream_Imp( const String& rName );
//STRIP001 	void MakeUserStorage_Impl();
//STRIP001 
public:
	SvxAutoCorrectLanguageLists( SvxAutoCorrect& rParent,
			const String& rShareAutoCorrectFile,
			const String& rUserAutoCorrectFile,
			LanguageType eLang);
	~SvxAutoCorrectLanguageLists();
//STRIP001 
//STRIP001 	// Lade, Setze, Gebe - die Ersetzungsliste
//STRIP001 	SvxAutocorrWordList* LoadAutocorrWordList();
//STRIP001 	void SetAutocorrWordList( SvxAutocorrWordList* pList );
//STRIP001 	const SvxAutocorrWordList* GetAutocorrWordList();
//STRIP001 
//STRIP001 	// Lade, Setze, Gebe - die Ausnahmeliste fuer Grossbuchstabe am
//STRIP001 	// Satzanfang
//STRIP001 	SvStringsISortDtor* LoadCplSttExceptList();
//STRIP001 	void SaveCplSttExceptList();
//STRIP001 	void SetCplSttExceptList( SvStringsISortDtor* pList );
//STRIP001 	const SvStringsISortDtor* GetCplSttExceptList();
//STRIP001 	BOOL AddToCplSttExceptList(const String& rNew);
//STRIP001 
//STRIP001 	// Lade, Setze, Gebe die Ausnahmeliste fuer 2 Grossbuchstaben am
//STRIP001 	// Wortanfang
//STRIP001 	SvStringsISortDtor* LoadWrdSttExceptList();
//STRIP001 	void SaveWrdSttExceptList();
//STRIP001 	void SetWrdSttExceptList( SvStringsISortDtor* pList );
//STRIP001 	const SvStringsISortDtor* GetWrdSttExceptList();
//STRIP001 	BOOL AddToWrdSttExceptList(const String& rNew);
//STRIP001 
//STRIP001 	// Speichern von Wortersetzungen:
//STRIP001 	//		Diese speichern direkt im Storage. Die Wortliste wird
//STRIP001 	//		entsprechend aktualisiert!
//STRIP001 	//	- purer Text
//STRIP001 	BOOL PutText( const String& rShort, const String& rLong );
//STRIP001 	//	- Text mit Attributierung (kann nur der SWG - SWG-Format!)
//STRIP001 	BOOL PutText( const String& rShort, SfxObjectShell& );
//STRIP001 	//	- loesche einen Eintrag
//STRIP001 	BOOL DeleteText( const String& rShort );
};

class SvxAutoCorrect
{
//STRIP001 	friend class SvxAutoCorrectLanguageLists;

	String sShareAutoCorrFile, sUserAutoCorrFile;

	SvxSwAutoFmtFlags aSwFlags;		// StarWriter AutoFormat-Flags

	// alle Sprachen in einer Tabelle
	SvxAutoCorrLanguageTable_Impl* pLangTable;
	SvxAutoCorrLastFileAskTable_Impl* pLastFileTable;
	CharClass* pCharClass;

	LanguageType eCharClassLang;

	long nFlags;
	sal_Unicode cStartDQuote, cEndDQuote, cStartSQuote, cEndSQuote,
				c1Div2, c1Div4, c3Div4,
				cEmDash, cEnDash;

	// private methods
//STRIP001 	SvxAutoCorrectLanguageLists& _GetLanguageList( LanguageType eLang );

//STRIP001 	void _GetCharClass( LanguageType eLang );

protected:
	//	- Text mit Attributierung (kann nur der SWG - SWG-Format!)
	//		rShort ist der Stream-Name - gecryptet!
//STRIP001 	virtual BOOL PutText( SvStorage&, const String& rShort, SfxObjectShell& ,
//STRIP001 							String& );

	// geforderte Sprache in die Tabelle eintragen gfs. nur wenn das file existiert
//STRIP001 	BOOL 	CreateLanguageFile(LanguageType eLang, BOOL bNewFile = TRUE);
	//	- return den Ersetzungstext (nur fuer SWG-Format, alle anderen
	//		koennen aus der Wortliste herausgeholt werden!)
	//		rShort ist der Stream-Name - gecryptet!
public:
	//The method below is changed from private to public by BerryJia for Bug95846 Time:2002-8-13 15:50
//STRIP001 	sal_Unicode GetQuote( sal_Unicode cInsChar, BOOL bSttQuote,
//STRIP001 							LanguageType eLang ) const;
//STRIP001 	virtual BOOL GetLongText( SvStorageRef&, const String& rShort, String& rLong );

//STRIP001 	TYPEINFO();

	SvxAutoCorrect( const String& rShareAutocorrFile,
					const String& rUserAutocorrFile );
	SvxAutoCorrect( const SvxAutoCorrect& );
	virtual ~SvxAutoCorrect();

	// fuehre eine AutoKorrektur aus.
	// returnt was ausgefuehrt wurde; entsprechend den obigen Flags
//STRIP001 	ULONG AutoCorrect( SvxAutoCorrDoc& rDoc, const String& rTxt,
//STRIP001 						xub_StrLen nPos, sal_Unicode cInsChar, BOOL bInsert );

	// return fuer die Autotext Expandierung das vorherige Wort, was dem
	// AutoCorrect - Algorythmus entspricht.
//STRIP001 	BOOL GetPrevAutoCorrWord( SvxAutoCorrDoc& rDoc, const String& rTxt,
//STRIP001 								xub_StrLen nPos, String& rWord ) const;

	// suche das oder die Worte in der ErsetzungsTabelle.
	// rText - ueberpruefe in diesem Text die Worte der Liste
	// rStt - die gefundene Startposition
	// nEnd - zu ueberpruefende Position - ab dieser Pos nach vorne
	// rLang - Input: in welcher Sprache wird gesucht
	//			Output: in welcher "Sprach-Liste" wurde es gefunden
//STRIP001 	const SvxAutocorrWord* SearchWordsInList( const String& rTxt,
//STRIP001 									xub_StrLen& rStt, xub_StrLen nEndPos,
//STRIP001 									SvxAutoCorrDoc& rDoc,
//STRIP001 									LanguageType& rLang );

	// erfrage / setze die Zeichen fuer die Quote-Ersetzung
	sal_Unicode GetStartSingleQuote() const 		{ return cStartSQuote; }
	sal_Unicode GetEndSingleQuote() const			{ return cEndSQuote; }
	sal_Unicode GetStartDoubleQuote() const 		{ return cStartDQuote; }
	sal_Unicode GetEndDoubleQuote() const			{ return cEndDQuote; }

	void SetStartSingleQuote( const sal_Unicode cStart ) 	{ cStartSQuote = cStart; }
	void SetEndSingleQuote( const sal_Unicode cEnd ) 		{ cEndSQuote = cEnd; }
	void SetStartDoubleQuote( const sal_Unicode cStart ) 	{ cStartDQuote = cStart; }
	void SetEndDoubleQuote( const sal_Unicode cEnd ) 		{ cEndDQuote = cEnd; }

//STRIP001 	String GetQuote( SvxAutoCorrDoc& rDoc, xub_StrLen nInsPos,
//STRIP001 					sal_Unicode cInsChar, BOOL bSttQuote );
//STRIP001 	void InsertQuote( SvxAutoCorrDoc& rDoc, xub_StrLen nInsPos,
//STRIP001 					sal_Unicode cInsChar, BOOL bSttQuote, BOOL bIns );

	// erfrage / setze den Namen der AutoKorrektur-Datei
	// defaultet auf "autocorr.dat"
//STRIP001 	String GetAutoCorrFileName( LanguageType eLang = LANGUAGE_SYSTEM,
//STRIP001 								BOOL bNewFile = FALSE,
//STRIP001 								BOOL bTstUserExist = FALSE ) const;
//STRIP001 	void SetUserAutoCorrFileName( const String& rNew );
//STRIP001 	void SetShareAutoCorrFileName( const String& rNew );

	// erfrage / setze die aktuellen Einstellungen der AutoKorrektur
	long GetFlags() const						{ return nFlags; }
	inline SvxSwAutoFmtFlags&	GetSwFlags()	{ return aSwFlags;}
	BOOL IsAutoCorrFlag( long nFlag ) const
								{ return nFlags & nFlag ? TRUE : FALSE; }
	void SetAutoCorrFlag( long nFlag, BOOL bOn = TRUE );

	// Lade, Setze, Gebe - die Ersetzungsliste
//STRIP001 	SvxAutocorrWordList* LoadAutocorrWordList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{ return _GetLanguageList( eLang ).LoadAutocorrWordList(); }
//STRIP001 	const SvxAutocorrWordList* GetAutocorrWordList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{ return _GetLanguageList( eLang ).GetAutocorrWordList(); }

	// Speichern von Wortersetzungen:
	//		Diese speichern direkt im Storage. Die Wortliste wird
	//		entsprechend aktualisiert!
	//	- purer Text
//STRIP001 	BOOL PutText( const String& rShort, const String& rLong, LanguageType eLang = LANGUAGE_SYSTEM );
	//	- Text mit Attributierung (kann nur der SWG - SWG-Format!)
//STRIP001 	BOOL PutText( const String& rShort, SfxObjectShell& rShell,
//STRIP001 				 LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{ return _GetLanguageList( eLang ).PutText(rShort, rShell ); }

	//	- loesche einen Eintrag
//STRIP001 	BOOL DeleteText( const String& rShort, LanguageType eLang = LANGUAGE_SYSTEM);

	// Lade, Setze, Gebe - die Ausnahmeliste fuer Grossbuchstabe am
	// Satzanfang
//STRIP001 	void SaveCplSttExceptList( LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	SvStringsISortDtor* LoadCplSttExceptList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM)
//STRIP001 		{	return _GetLanguageList( eLang ).LoadCplSttExceptList(); }
//STRIP001 	const SvStringsISortDtor* GetCplSttExceptList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{	return _GetLanguageList( eLang ).GetCplSttExceptList(); }

	// fuegt ein einzelnes Wort hinzu. Die Liste wird sofort
	// in die Datei geschrieben!
//STRIP001 	BOOL AddCplSttException( const String& rNew,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );

	// Lade, Setze, Gebe die Ausnahmeliste fuer 2 Grossbuchstaben am
	// Wortanfang
//STRIP001 	void SaveWrdSttExceptList( LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	SvStringsISortDtor* LoadWrdSttExceptList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{	return _GetLanguageList( eLang ).LoadWrdSttExceptList(); }
//STRIP001 	const SvStringsISortDtor* GetWrdSttExceptList(
//STRIP001 									LanguageType eLang = LANGUAGE_SYSTEM )
//STRIP001 		{	return _GetLanguageList( eLang ).LoadWrdSttExceptList(); }
	// fuegt ein einzelnes Wort hinzu. Die Liste wird sofort
	// in die Datei geschrieben!
//STRIP001 	BOOL AddWrtSttException( const String& rNew, LanguageType eLang = LANGUAGE_SYSTEM);

	//ueber die Sprachen nach dem Eintrag suchen
//STRIP001 	BOOL FindInWrdSttExceptList( LanguageType eLang, const String& sWord );
//STRIP001 	BOOL FindInCplSttExceptList( LanguageType eLang, const String& sWord,
//STRIP001 									BOOL bAbbreviation = FALSE);

	// die einzelnen Methoden fuer die Autokorrektur
//STRIP001 	BOOL FnCptlSttWrd( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	BOOL FnChgFractionSymbol( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos );
//STRIP001 	BOOL FnChgOrdinalNumber( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	BOOL FnChgToEnEmDash( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	BOOL FnSetINetAttr( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	BOOL FnChgWeightUnderl( SvxAutoCorrDoc&, const String&,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang = LANGUAGE_SYSTEM );
//STRIP001 	BOOL FnCptlSttSntnc( SvxAutoCorrDoc&, const String&, BOOL bNormalPos,
//STRIP001 								xub_StrLen nSttPos, xub_StrLen nEndPos,
//STRIP001 								LanguageType eLang  = LANGUAGE_SYSTEM);
	static long 	GetDefaultFlags();

//STRIP001 	CharClass& GetCharClass( LanguageType eLang )
//STRIP001 	{
//STRIP001 		if( !pCharClass || eLang != eCharClassLang )
//STRIP001 			_GetCharClass( eLang );
//STRIP001 		return *pCharClass;
//STRIP001 	}
};

}//end of namespace binfilter
#endif
