/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_swstbctl.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 07:06:34 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #include "hintids.hxx"

#ifndef _STATUS_HXX //autogen
#include <vcl/status.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFXVIEWFRM_HXX
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif

#include <utlui.hrc>
// auto strip #include "errhdl.hxx"

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif
#ifndef _VISCRS_HXX
#include <viscrs.hxx>
#endif
#include "wrtsh.hxx"
#include "cmdid.h"
#include "swstbctl.hxx"
namespace binfilter {

#define C2S(cChar) UniString::CreateFromAscii(cChar)

// STATIC DATA -----------------------------------------------------------

/*N*/ SFX_IMPL_STATUSBAR_CONTROL(SwHyperlinkControl, SfxBoolItem);

// class SwHyperlinkControl ------------------------------------------------

/*N*/ SwHyperlinkControl::SwHyperlinkControl( USHORT nId,
/*N*/ 									StatusBar& rStb, SfxBindings& rBind ) :
/*N*/ 
/*N*/ 	SfxStatusBarControl( nId, rStb, rBind ),
/*N*/ 	bState( TRUE )
/*N*/ {
/*N*/ }

// -----------------------------------------------------------------------

/*N*/ void SwHyperlinkControl::StateChanged( USHORT nSID, SfxItemState eState,
/*N*/ 									 const SfxPoolItem* pState )
/*N*/ {
/*N*/ 	if ( SFX_ITEM_AVAILABLE != eState )
/*?*/ 		GetStatusBar().SetItemText( GetId(), aEmptyStr );
/*N*/ 	else
/*N*/ 	{
/*N*/ 		DBG_ASSERT( pState->ISA( SfxBoolItem ), "invalid item type" );
/*N*/ 		SfxBoolItem* pItem = (SfxBoolItem*)pState;
/*N*/ 		bState = pItem->GetValue();
/*N*/ 		DrawItemText_Impl();
/*N*/ 	}
/*N*/ }

// -----------------------------------------------------------------------

//STRIP001 void SwHyperlinkControl::Paint( const UserDrawEvent& rUsrEvt )
//STRIP001 {
//STRIP001 	DrawItemText_Impl();
//STRIP001 }

// -----------------------------------------------------------------------


/*M*/ void SwHyperlinkControl::DrawItemText_Impl()
/*M*/ {
/*M*/     USHORT nResId = bState ? STR_HYPERCTRL_HYP : STR_HYPERCTRL_SEL;
/*M*/     GetStatusBar().SetItemText( GetId(), SW_RESSTR(nResId) );
/*M*/ }

// -----------------------------------------------------------------------


//STRIP001 void SwHyperlinkControl::Click()
//STRIP001 {
//STRIP001 	SfxBoolItem aState( GetId(), !bState );
//STRIP001 	SfxViewFrame::Current()->GetDispatcher()->Execute( GetId(), SFX_CALLMODE_RECORD, &aState, 0L );
//STRIP001 }



}
