/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_view2.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:49:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHOPTIONS_HPP_
// auto strip #include <com/sun/star/util/SearchOptions.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_SEARCHFLAGS_HPP_
// auto strip #include <com/sun/star/util/SearchFlags.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_I18N_TRANSLITERATIONMODULES_HPP_
// auto strip #include <com/sun/star/i18n/TransliterationModules.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_LOCALE_HPP_
// auto strip #include <com/sun/star/lang/Locale.hpp>
// auto strip #endif

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _UIPARAM_HXX
#include <uiparam.hxx>
#endif

// auto strip #ifndef _SVTOOLS_PASSWORDHELPER_HXX
// auto strip #include <svtools/PasswordHelper.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_PASSWD_HXX
// auto strip #include <bf_sfx2/passwd.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_HELP_HXX 
// auto strip #include <bf_sfx2/sfxhelp.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LANGITEM_HXX //autogen
// auto strip #include <bf_svx/langitem.hxx>
// auto strip #endif
// auto strip #ifndef _APP_HXX //autogen
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif
// auto strip #ifndef _WRKWIN_HXX //autogen
// auto strip #include <vcl/wrkwin.hxx>
// auto strip #endif
// auto strip #ifndef _SFXAPP_HXX //autogen
// auto strip #include <bf_sfx2/app.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_BINDINGS_HXX //autogen
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif
// auto strip #ifndef _LINKDLG_HXX //autogen
// auto strip #include <so3/linkdlg.hxx>
// auto strip #endif
#ifndef _TXTCMP_HXX //autogen
#include <svtools/txtcmp.hxx>
#endif
// auto strip #ifndef _SVX_ZOOM_HXX //autogen
// auto strip #include <bf_svx/zoom.hxx>
// auto strip #endif
// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_TSPTITEM_HXX //autogen
// auto strip #include <bf_svx/tstpitem.hxx>
// auto strip #endif
#ifndef _SFXEVENT_HXX //autogen
#include <bf_sfx2/event.hxx>
#endif
// auto strip #ifndef _SFXDOCFILE_HXX //autogen
// auto strip #include <bf_sfx2/docfile.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_DOCFILT_HACK_HXX //autogen
// auto strip #include <bf_sfx2/docfilt.hxx>
// auto strip #endif
// auto strip #ifndef _SFX_FCONTNR_HXX //autogen
// auto strip #include <bf_sfx2/fcontnr.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SIZEITEM_HXX //autogen
// auto strip #include <bf_svx/sizeitem.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif
// auto strip #ifndef _SFX_TOPFRM_HXX
// auto strip #include <bf_sfx2/topfrm.hxx>
// auto strip #endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
// auto strip #ifndef _SFXPTITEM_HXX //autogen
// auto strip #include <svtools/ptitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVXLINKMGR_HXX
// auto strip #include <bf_svx/linkmgr.hxx>
// auto strip #endif
// auto strip #ifndef __RSC //autogen
// auto strip #include <tools/errinf.hxx>
// auto strip #endif
// auto strip #ifndef _URLOBJ_HXX //autogen
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif
#ifndef _SVDVIEW_HXX //autogen
#include <bf_svx/svdview.hxx>
#endif
// auto strip #ifndef _UNOTOOLS_TEXTSEARCH_HXX
// auto strip #include <unotools/testsearch.hxx>
// auto strip #endif

// auto strip #ifndef _SWTYPES_HXX
// auto strip #include <swtypes.hxx>
// auto strip #endif
// auto strip #ifndef _SWWAIT_HXX
// auto strip #include <swwait.hxx>
// auto strip #endif
// auto strip #ifndef _REDLNDLG_HXX
// auto strip #include <redlndlg.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif
// auto strip #ifndef _UIVWIMP_HXX
// auto strip #include <uivwimp.hxx>
// auto strip #endif
#ifndef _DOCSH_HXX
#include <docsh.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _BASESH_HXX
// auto strip #include <basesh.hxx>
// auto strip #endif
#ifndef _SWMODULE_HXX
#include <swmodule.hxx>
#endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
// auto strip #ifndef _SHELLIO_HXX
// auto strip #include <shellio.hxx>
// auto strip #endif
// auto strip #ifndef _FMTINFMT_HXX
// auto strip #include <fmtinfmt.hxx>
// auto strip #endif
// auto strip #ifndef _REDLENUM_HXX
// auto strip #include <redlenum.hxx>
// auto strip #endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>
#endif
// auto strip #ifndef _DRAWBASE_HXX
// auto strip #include <drawbase.hxx>
// auto strip #endif
// auto strip #ifndef _FRMMGR_HXX
// auto strip #include <frmmgr.hxx>
// auto strip #endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
// auto strip #ifndef _LINENUM_HXX
// auto strip #include <linenum.hxx>
// auto strip #endif
#ifndef _SECTION_HXX
#include <section.hxx>
#endif
#ifndef _USRPREF_HXX
#include <usrpref.hxx>
#endif
// auto strip #ifndef _BOOKMRK_HXX
// auto strip #include <bookmrk.hxx>
// auto strip #endif
// auto strip #ifndef _NAVIPI_HXX
// auto strip #include <navipi.hxx>
// auto strip #endif
#ifndef _TOX_HXX
#include <tox.hxx>
#endif
// auto strip #ifndef _WORKCTRL_HXX
// auto strip #include <workctrl.hxx>
// auto strip #endif
// auto strip #ifndef _SCROLL_HXX
// auto strip #include <scroll.hxx>
// auto strip #endif
#ifndef _EDTWIN_HXX
#include <edtwin.hxx>
#endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif
// auto strip #ifndef _TEXTSH_HXX
// auto strip #include <textsh.hxx>
// auto strip #endif
// auto strip #ifndef _TABSH_HXX
// auto strip #include <tabsh.hxx>
// auto strip #endif
#ifndef _LISTSH_HXX
#include <listsh.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _SWSWERROR_H
#include <swerror.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
#ifndef _SHELLS_HRC
#include <shells.hrc>
#endif
#ifndef _WEB_HRC
#include <web.hrc>
#endif
#ifndef _VIEW_HRC
#include <view.hrc>
#endif
#ifndef _APP_HRC
#include <app.hrc>
#endif
// auto strip #ifndef _FMTCLDS_HXX //autogen
// auto strip #include <fmtclds.hxx>
// auto strip #endif
#include <helpid.h>
#ifndef _SVTOOLS_TEMPLDLG_HXX 
#include <svtools/templdlg.hxx>
#endif
// auto strip #ifndef _DBCONFIG_HXX
// auto strip #include <dbconfig.hxx>
// auto strip #endif
// auto strip #ifndef _DBMGR_HXX
// auto strip #include <dbmgr.hxx>
// auto strip #endif
// auto strip #ifndef _MAILMRGE_HXX
// auto strip #include "mailmrge.hxx"
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
// auto strip #include <com/sun/star/lang/XMultiServiceFactory.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
// auto strip #include <com/sun/star/container/XNameAccess.hpp>
// auto strip #endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
#include "so3/staticbaseurl.hxx"
namespace binfilter {
//Damit die Seitenanzeige in der Statusleiste nicht unnoetig erfolgt.
static String sLstPg;
static USHORT nPageCnt = 0;
const char __FAR_DATA sStatusDelim[] = " : ";

using namespace ::rtl;
using namespace ::com::sun::star;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::scanner;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
#define C2U(char) ::rtl::OUString::createFromAscii(char)

/*---------------------------------------------------------------------------
	Beschreibung:	String fuer die Seitenanzeige in der Statusbar basteln.
 ----------------------------------------------------------------------------*/

/*N*/ String SwView::GetPageStr( USHORT nPg, USHORT nLogPg,
/*N*/ 							const String& rDisplay )
/*N*/ {
/*N*/ 	String aStr( aPageStr );
/*N*/ 	if( rDisplay.Len() )
/*N*/ 		aStr += rDisplay;
/*N*/ 	else
/*N*/ 		aStr += String::CreateFromInt32(nLogPg);
/*N*/ 
/*N*/ 	if( nLogPg && nLogPg != nPg )
/*N*/ 	{
/*N*/ 		aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM("   "));
/*N*/ 		aStr += String::CreateFromInt32(nPg);
/*N*/ 	}
/*N*/ 	aStr.AppendAscii( RTL_CONSTASCII_STRINGPARAM(" / "));
/*N*/ 	aStr += String::CreateFromInt32( GetWrtShell().GetPageCnt() );
/*N*/ 
/*N*/ 	return aStr;
/*N*/ }

//STRIP001 void __EXPORT SwView::Execute(SfxRequest &rReq)
//STRIP001 {
//STRIP001 	USHORT nSlot = rReq.GetSlot();
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 	const SfxPoolItem* pItem;
//STRIP001     BOOL bIgnore = FALSE;
//STRIP001 	switch( nSlot )
//STRIP001 	{
//STRIP001 		case SID_CREATE_SW_DRAWVIEW:
//STRIP001 			pWrtShell->GetDoc()->MakeDrawModel();
//STRIP001 			break;
//STRIP001 
//STRIP001 		case FN_LINE_NUMBERING_DLG:
//STRIP001 		{
//STRIP001 			SwLineNumberingDlg *pDlg = new SwLineNumberingDlg(this);
//STRIP001 			pDlg->Execute();
//STRIP001 			delete pDlg;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case FN_EDIT_LINK_DLG:
//STRIP001 			EditLinkDlg();
//STRIP001 			break;
//STRIP001 		case FN_REFRESH_VIEW:
//STRIP001 			GetEditWin().Invalidate();
//STRIP001 			break;
//STRIP001 		case FN_PAGEUP:
//STRIP001 		case FN_PAGEUP_SEL:
//STRIP001 		{
//STRIP001 			Rectangle aVis( GetVisArea() );
//STRIP001 			PageUpCrsr(FN_PAGEUP_SEL == nSlot);
//STRIP001 			rReq.SetReturnValue(SfxBoolItem(nSlot,
//STRIP001 												aVis != GetVisArea()));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_PAGEDOWN_SEL:
//STRIP001 		case FN_PAGEDOWN:
//STRIP001 		{
//STRIP001 			Rectangle aVis( GetVisArea() );
//STRIP001 			PageDownCrsr(FN_PAGEDOWN_SEL == nSlot);
//STRIP001 			rReq.SetReturnValue(SfxBoolItem(nSlot,
//STRIP001 												aVis != GetVisArea()));
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_REDLINE_ON:
//STRIP001 		{
//STRIP001 			if( pArgs &&
//STRIP001 				SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem ))
//STRIP001 			{
//STRIP001 				USHORT nOn = ((const SfxBoolItem*)pItem)->GetValue() ? REDLINE_ON : 0;
//STRIP001 				USHORT nMode = pWrtShell->GetRedlineMode();
//STRIP001 				pWrtShell->SetRedlineMode( (nMode & ~REDLINE_ON) | nOn);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001         case FN_REDLINE_PROTECT :
//STRIP001         {
//STRIP001             BOOL bMode = (( pWrtShell->GetRedlineMode() & REDLINE_ON ) != 0);
//STRIP001             if( pArgs && SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem ) && ((SfxBoolItem*)pItem)->GetValue() == bMode )
//STRIP001                 break;
//STRIP001             Sequence <sal_Int8> aPasswd =
//STRIP001                         pWrtShell->GetDoc()->GetRedlinePasswd();
//STRIP001             SfxPasswordDialog aPasswdDlg(&GetViewFrame()->GetWindow());
//STRIP001             if(!aPasswd.getLength())
//STRIP001                 aPasswdDlg.ShowExtras(SHOWEXTRAS_CONFIRM);
//STRIP001             if (aPasswdDlg.Execute())
//STRIP001             {
//STRIP001                 USHORT nOn = REDLINE_ON;;
//STRIP001                 String sNewPasswd( aPasswdDlg.GetPassword() );
//STRIP001                 Sequence <sal_Int8> aNewPasswd =
//STRIP001                         pWrtShell->GetDoc()->GetRedlinePasswd();
//STRIP001                 SvPasswordHelper::GetHashPassword( aNewPasswd, sNewPasswd );
//STRIP001                 if(!aPasswd.getLength())
//STRIP001                 {
//STRIP001                     pWrtShell->GetDoc()->SetRedlinePasswd(aNewPasswd);
//STRIP001                 }
//STRIP001                 else if(SvPasswordHelper::CompareHashPassword(aPasswd, sNewPasswd))
//STRIP001                 {
//STRIP001                     pWrtShell->GetDoc()->SetRedlinePasswd(Sequence <sal_Int8> ());
//STRIP001                     nOn = 0;
//STRIP001                 }
//STRIP001 				USHORT nMode = pWrtShell->GetRedlineMode();
//STRIP001 				pWrtShell->SetRedlineMode( (nMode & ~REDLINE_ON) | nOn);
//STRIP001                 rReq.AppendItem( SfxBoolItem( FN_REDLINE_PROTECT, ((nMode&REDLINE_ON)==0) ) );
//STRIP001             }
//STRIP001             else
//STRIP001                 bIgnore = TRUE;
//STRIP001         }
//STRIP001         break;
//STRIP001 		case FN_REDLINE_SHOW:
//STRIP001 
//STRIP001 			if( pArgs &&
//STRIP001 				SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem))
//STRIP001 			{
//STRIP001 				USHORT nMode = ( ~(REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE)
//STRIP001 						& pWrtShell->GetRedlineMode() ) | REDLINE_SHOW_INSERT;
//STRIP001 				if( ((const SfxBoolItem*)pItem)->GetValue() )
//STRIP001 					nMode |= REDLINE_SHOW_DELETE;
//STRIP001 
//STRIP001 				pWrtShell->SetRedlineMode( nMode );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case FN_REDLINE_ACCEPT:
//STRIP001 			GetViewFrame()->ToggleChildWindow(FN_REDLINE_ACCEPT);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_DOCUMENT_COMPARE:
//STRIP001 		case SID_DOCUMENT_MERGE:
//STRIP001 			{
//STRIP001 				String sFileName, sFilterName;
//STRIP001 				INT16 nVersion = 0;
//STRIP001 
//STRIP001 				if( pArgs )
//STRIP001 				{
//STRIP001 					if( SFX_ITEM_SET == pArgs->GetItemState( SID_FILE_NAME, FALSE, &pItem ))
//STRIP001 						sFileName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 					if( SFX_ITEM_SET == pArgs->GetItemState( SID_FILTER_NAME, FALSE, &pItem ))
//STRIP001 						sFilterName = ((const SfxStringItem*)pItem)->GetValue();
//STRIP001 
//STRIP001 					if( SFX_ITEM_SET == pArgs->GetItemState( SID_VERSION, FALSE, &pItem ))
//STRIP001 						nVersion = ((const SfxInt16Item *)pItem)->GetValue();
//STRIP001 				}
//STRIP001 
//STRIP001 				long nFound = InsertDoc( nSlot, sFileName, sFilterName, nVersion );
//STRIP001 				rReq.SetReturnValue( SfxInt32Item( nSlot, nFound ));
//STRIP001 
//STRIP001 				if (nFound > 0)	// Redline-Browser anzeigen
//STRIP001 				{
//STRIP001 					SfxViewFrame* pVFrame = GetViewFrame();
//STRIP001 					pVFrame->ShowChildWindow(FN_REDLINE_ACCEPT);
//STRIP001 
//STRIP001 					// RedlineDlg neu initialisieren
//STRIP001 					USHORT nId = SwRedlineAcceptChild::GetChildWindowId();
//STRIP001 					SwRedlineAcceptChild *pRed = (SwRedlineAcceptChild*)
//STRIP001 											pVFrame->GetChildWindow(nId);
//STRIP001 					if (pRed)
//STRIP001 						pRed->ReInitDlg(GetDocShell());
//STRIP001 				}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_SYNC_LABELS:
//STRIP001 			GetViewFrame()->ShowChildWindow(FN_SYNC_LABELS, TRUE);
//STRIP001 			break;
//STRIP001 		case FN_ESCAPE:
//STRIP001 		{
//STRIP001 			if ( pWrtShell->HasDrawView() && pWrtShell->GetDrawView()->IsDragObj() )
//STRIP001 			{
//STRIP001 				pWrtShell->BreakDrag();
//STRIP001 				pWrtShell->EnterSelFrmMode();
//STRIP001 			}
//STRIP001 			else if ( pWrtShell->IsDrawCreate() )
//STRIP001 			{
//STRIP001 				GetDrawFuncPtr()->BreakCreate();
//STRIP001 				AttrChangedNotify(pWrtShell); // ggf Shellwechsel...
//STRIP001 			}
//STRIP001 			else if ( pWrtShell->HasSelection() || IsDrawMode() )
//STRIP001 			{
//STRIP001                 SdrView *pSdrView = pWrtShell->HasDrawView() ? pWrtShell->GetDrawView() : 0;
//STRIP001                 if(pSdrView && pSdrView->HasMarkedObj() &&
//STRIP001                     pSdrView->GetHdlList().GetFocusHdl())
//STRIP001                 {
//STRIP001                     ((SdrHdlList&)pSdrView->GetHdlList()).ResetFocusHdl();
//STRIP001                 }
//STRIP001                 else
//STRIP001                 {
//STRIP001                     if(pSdrView)
//STRIP001                     {
//STRIP001                         LeaveDrawCreate();
//STRIP001                         Point aPt(LONG_MIN, LONG_MIN);
//STRIP001                         //go out of the frame
//STRIP001                         pWrtShell->SelectObj(aPt, SW_LEAVE_FRAME);
//STRIP001                         SfxBindings& rBind = GetViewFrame()->GetBindings();
//STRIP001                         rBind.Invalidate( SID_ATTR_SIZE );
//STRIP001                     }
//STRIP001                     pWrtShell->EnterStdMode();
//STRIP001                     AttrChangedNotify(pWrtShell); // ggf Shellwechsel...
//STRIP001                 }
//STRIP001 			}
//STRIP001 			else if ( GetEditWin().GetApplyTemplate() )
//STRIP001 			{
//STRIP001 				GetEditWin().SetApplyTemplate(SwApplyTemplate());
//STRIP001 			}
//STRIP001 			else if( ((SfxObjectShell*)GetDocShell())->GetInPlaceObject() &&
//STRIP001 						((SfxObjectShell*)GetDocShell())->GetInPlaceObject()->GetIPClient() )
//STRIP001 			{
//STRIP001 				ErrCode nErr = GetDocShell()->DoInPlaceActivate( FALSE );
//STRIP001 				if ( nErr )
//STRIP001 					ErrorHandler::HandleError( nErr );
//STRIP001 			}
//STRIP001 			else if ( GetEditWin().IsChainMode() )
//STRIP001 			{
//STRIP001 				GetEditWin().SetChainMode( FALSE );
//STRIP001 			}
//STRIP001             else if( pWrtShell->GetFlyFrmFmt() )
//STRIP001             {
//STRIP001                 const SwFrmFmt* pFmt = pWrtShell->GetFlyFrmFmt();
//STRIP001                 if(pWrtShell->GotoFly( pFmt->GetName(), FLYCNTTYPE_FRM ))
//STRIP001                 {
//STRIP001                     pWrtShell->HideCrsr();
//STRIP001                     pWrtShell->EnterSelFrmMode();
//STRIP001                 }
//STRIP001             }
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SfxBoolItem aItem( SID_WIN_FULLSCREEN, FALSE );
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute( SID_WIN_FULLSCREEN, SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001                 bIgnore = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001         break;
//STRIP001 		case SID_ATTR_BORDER_INNER:
//STRIP001 		case SID_ATTR_BORDER_OUTER:
//STRIP001 		case SID_ATTR_BORDER_SHADOW:
//STRIP001 			if(pArgs)
//STRIP001 				pWrtShell->SetAttr(*pArgs);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_ATTR_PAGE:
//STRIP001 		case SID_ATTR_PAGE_SIZE:
//STRIP001 		case SID_ATTR_PAGE_MAXSIZE:
//STRIP001 		case SID_ATTR_PAGE_PAPERBIN:
//STRIP001 		case SID_ATTR_PAGE_EXT1:
//STRIP001 		case FN_PARAM_FTN_INFO:
//STRIP001 		{
//STRIP001 			if(pArgs)
//STRIP001 			{
//STRIP001 				const USHORT nCurIdx = pWrtShell->GetCurPageDesc();
//STRIP001 				SwPageDesc aPageDesc( pWrtShell->GetPageDesc( nCurIdx ) );
//STRIP001 				::ItemSetToPageDesc( *pArgs, aPageDesc );
//STRIP001 				// Den Descriptor der Core veraendern.
//STRIP001 				pWrtShell->ChgPageDesc( nCurIdx, aPageDesc );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_NAVIGATION_PI_GOTO_PAGE:
//STRIP001 		{
//STRIP001 			SfxViewFrame* pVFrame = GetViewFrame();
//STRIP001 			SfxChildWindow* pCh = pVFrame->GetChildWindow( SID_NAVIGATOR );
//STRIP001 			if(!pCh)
//STRIP001 			{
//STRIP001 				pVFrame->ToggleChildWindow( SID_NAVIGATOR );
//STRIP001 				pCh = pVFrame->GetChildWindow( SID_NAVIGATOR );
//STRIP001 
//STRIP001 			}
//STRIP001 				((SwNavigationPI*) pCh->GetContextWindow(SW_MOD()))->GotoPage();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case  FN_EDIT_CURRENT_TOX:
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 								FN_INSERT_MULTI_TOX, SFX_CALLMODE_ASYNCHRON);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_UPDATE_CUR_TOX:
//STRIP001 		{
//STRIP001 			const SwTOXBase* pBase = pWrtShell->GetCurTOX();
//STRIP001 			if(pBase)
//STRIP001 			{
//STRIP001 				pWrtShell->StartAction();
//STRIP001 				if(TOX_INDEX == pBase->GetType())
//STRIP001 					pWrtShell->ApplyAutoMark();
//STRIP001 				pWrtShell->UpdateTableOf( *pBase );
//STRIP001 				pWrtShell->EndAction();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_UPDATE_TOX:
//STRIP001 		{
//STRIP001 			pWrtShell->StartAction();
//STRIP001 			pWrtShell->EnterStdMode();
//STRIP001 			FASTBOOL bOldCrsrInReadOnly = pWrtShell->IsReadOnlyAvailable();
//STRIP001 			pWrtShell->SetReadOnlyAvailable( TRUE );
//STRIP001 
//STRIP001 			for( USHORT i = 0; i < 2; ++i )
//STRIP001 			{
//STRIP001 				USHORT nCount = pWrtShell->GetTOXCount();
//STRIP001 				if( 1 == nCount )
//STRIP001 					++i;
//STRIP001 
//STRIP001 				while( pWrtShell->GotoPrevTOXBase() )
//STRIP001 					;   // aufs erste Verzeichnis springen
//STRIP001 
//STRIP001 				// falls wir nicht mehr in einem stehen, dann zum naechsten
//STRIP001 				// springen.
//STRIP001 				const SwTOXBase* pBase = pWrtShell->GetCurTOX();
//STRIP001 				if( !pBase )
//STRIP001 				{
//STRIP001 					pWrtShell->GotoNextTOXBase();
//STRIP001 					pBase = pWrtShell->GetCurTOX();
//STRIP001 				}
//STRIP001 
//STRIP001 				BOOL bAutoMarkApplied = FALSE;
//STRIP001 				while( pBase )
//STRIP001 				{
//STRIP001 					if(TOX_INDEX == pBase->GetType() && !bAutoMarkApplied)
//STRIP001 					{
//STRIP001 						pWrtShell->ApplyAutoMark();
//STRIP001 						bAutoMarkApplied = TRUE;
//STRIP001 					}
//STRIP001 					// JP 15.07.96: das pBase wird nur fuer die Schnittstelle
//STRIP001 					//              benoetigt. Muss mal umgetstellt werden!!!
//STRIP001 					pWrtShell->UpdateTableOf( *pBase );
//STRIP001 
//STRIP001 					if( pWrtShell->GotoNextTOXBase() )
//STRIP001 						pBase = pWrtShell->GetCurTOX();
//STRIP001 					else
//STRIP001 						pBase = 0;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			pWrtShell->SetReadOnlyAvailable( bOldCrsrInReadOnly );
//STRIP001 			pWrtShell->EndAction();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_BRUSH:
//STRIP001 		{
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(RES_BACKGROUND, FALSE, &pItem))
//STRIP001 			{
//STRIP001 				const USHORT nCurIdx = pWrtShell->GetCurPageDesc();
//STRIP001 				SwPageDesc aDesc( pWrtShell->GetPageDesc( nCurIdx ));
//STRIP001 				SwFrmFmt& rMaster = aDesc.GetMaster();
//STRIP001 				rMaster.SetAttr(*pItem);
//STRIP001 				pWrtShell->ChgPageDesc( nCurIdx, aDesc);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_CLEARHISTORY:
//STRIP001 		{
//STRIP001 			pWrtShell->DelAllUndoObj();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_UNDO:
//STRIP001 		{
//STRIP001 			pShell->ExecuteSlot(rReq);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_INSERT_CTRL:
//STRIP001 		case FN_INSERT_OBJ_CTRL:
//STRIP001 		{
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem))
//STRIP001 			{
//STRIP001 				USHORT nValue = ((SfxUInt16Item*)pItem)->GetValue();
//STRIP001 				switch ( nSlot )
//STRIP001 				{
//STRIP001 					case FN_INSERT_CTRL:
//STRIP001 					{
//STRIP001 						BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 						if(bWeb)
//STRIP001 							SwView::nWebInsertCtrlState = nValue;
//STRIP001 						else
//STRIP001 							SwView::nInsertCtrlState = nValue;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 					case FN_INSERT_OBJ_CTRL:    SwView::nInsertObjectCtrlState = nValue  ;break;
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 			GetViewFrame()->GetBindings().Invalidate( nSlot );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 #if defined WIN || defined WNT || defined UNX
//STRIP001         case SID_TWAIN_SELECT:
//STRIP001         case SID_TWAIN_TRANSFER:
//STRIP001             GetViewImpl()->ExecuteScan( rReq );
//STRIP001 		break;
//STRIP001 #endif
//STRIP001 
//STRIP001 		case SID_ATTR_DEFTABSTOP:
//STRIP001 		{
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(SID_ATTR_DEFTABSTOP, FALSE, &pItem))
//STRIP001 			{
//STRIP001 				SvxTabStopItem aDefTabs( 0, 0 );
//STRIP001 				USHORT nTab = ((const SfxUInt16Item*)pItem)->GetValue();
//STRIP001 				MakeDefTabs( nTab, aDefTabs );
//STRIP001 				pWrtShell->SetDefault( aDefTabs );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_LANGUAGE:
//STRIP001 		if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(SID_ATTR_LANGUAGE, FALSE, &pItem))
//STRIP001 		{
//STRIP001 			SvxLanguageItem aLang(((SvxLanguageItem*)pItem)->GetLanguage(), RES_CHRATR_LANGUAGE);
//STRIP001 			pWrtShell->SetDefault( aLang );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case  SID_ATTR_CHAR_CTL_LANGUAGE:
//STRIP001 		if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(RES_CHRATR_CTL_LANGUAGE, FALSE, &pItem))
//STRIP001 		{
//STRIP001 			pWrtShell->SetDefault( *pItem );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case  SID_ATTR_CHAR_CJK_LANGUAGE:
//STRIP001 		if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(RES_CHRATR_CJK_LANGUAGE, FALSE, &pItem))
//STRIP001 		{
//STRIP001 			pWrtShell->SetDefault( *pItem );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_INSERT_HEADER:
//STRIP001 			pWrtShell->SetHeadInBrowse(!pWrtShell->IsHeadInBrowse());
//STRIP001 			break;
//STRIP001 		case FN_INSERT_FOOTER:
//STRIP001 			pWrtShell->SetFootInBrowse(!pWrtShell->IsFootInBrowse());
//STRIP001 			break;
//STRIP001 		case FN_SCROLL_NEXT_PREV:
//STRIP001 			if(pArgs && pArgs->GetItemState(FN_SCROLL_NEXT_PREV, FALSE, &pItem))
//STRIP001 			{
//STRIP001 				// hier sollen nur die Handler der PageUp/DownButtons gerufen werden
//STRIP001 				BOOL bNext = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001 				MoveNavigation(bNext);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		case SID_JUMPTOMARK:
//STRIP001 			if( pArgs && SFX_ITEM_SET == pArgs->GetItemState(SID_JUMPTOMARK, FALSE, &pItem))
//STRIP001 				JumpToSwMark( (( const SfxStringItem*)pItem)->GetValue() );
//STRIP001 			break;
//STRIP001 		case SID_GALLERY :
//STRIP001             GetViewFrame()->ChildWindowExecute(rReq);//ToggleChildWindow(SID_GALLERY);
//STRIP001 		break;
//STRIP001         case SID_VIEW_DATA_SOURCE_BROWSER:
//STRIP001 		{
//STRIP001             SfxViewFrame* pVFrame = GetViewFrame();
//STRIP001             pVFrame->ChildWindowExecute(rReq);
//STRIP001             if(pVFrame->HasChildWindow(SID_BROWSER))
//STRIP001             {
//STRIP001                 const SwDBData& rData = GetWrtShell().GetDBDesc();
//STRIP001                 SW_MOD()->ShowDBObj(*this, rData, FALSE);
//STRIP001             }
//STRIP001         }
//STRIP001 		break;
//STRIP001         case FN_INSERT_FIELD_DATA_ONLY :
//STRIP001 		{
//STRIP001 			BOOL bShow = FALSE;
//STRIP001 			if( pArgs &&
//STRIP001 				SFX_ITEM_SET == pArgs->GetItemState(nSlot, FALSE, &pItem ))
//STRIP001 				bShow = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001             //GetViewFrame()->ShowChildWindow(nSlot, bShow && bInMailMerge);
//STRIP001             if((bShow && bInMailMerge) != GetViewFrame()->HasChildWindow(nSlot))
//STRIP001                 GetViewFrame()->ToggleChildWindow(nSlot);
//STRIP001             //if fields have been succesfully inserted call the "real" 
//STRIP001             //mail merge dialog
//STRIP001             SwWrtShell &rSh = GetWrtShell();
//STRIP001             if(bInMailMerge && rSh.IsAnyDatabaseFieldInDoc())
//STRIP001             {
//STRIP001                 SwNewDBMgr* pNewDBMgr = rSh.GetNewDBMgr();
//STRIP001                 if (pNewDBMgr)
//STRIP001                 {
//STRIP001                     SwDBData aData;
//STRIP001                     aData = rSh.GetDBData();
//STRIP001                     rSh.EnterStdMode(); // Wechsel in Textshell erzwingen; ist fuer
//STRIP001                                         // das Mischen von DB-Feldern notwendig.
//STRIP001                     AttrChangedNotify( &rSh );
//STRIP001                     pNewDBMgr->SetMergeType( DBMGR_MERGE );
//STRIP001 
//STRIP001                     Sequence<PropertyValue> aProperties(3);
//STRIP001                     PropertyValue* pValues = aProperties.getArray();
//STRIP001                     pValues[0].Name = C2U("DataSourceName");
//STRIP001                     pValues[1].Name = C2U("Command");
//STRIP001                     pValues[2].Name = C2U("CommandType");
//STRIP001                     pValues[0].Value <<= aData.sDataSource;
//STRIP001                     pValues[1].Value <<= aData.sCommand;
//STRIP001                     pValues[2].Value <<= aData.nCommandType;
//STRIP001                     pNewDBMgr->ExecuteFormLetter(rSh, aProperties, TRUE);
//STRIP001                 }
//STRIP001             }        
//STRIP001             bInMailMerge &= bShow;
//STRIP001             GetViewFrame()->GetBindings().Invalidate(FN_INSERT_FIELD);
//STRIP001 		}
//STRIP001         break;
//STRIP001         case FN_QRY_MERGE:
//STRIP001         {
//STRIP001             BOOL bUseCurrentDocument = TRUE;
//STRIP001             BOOL bQuery = !pArgs||SFX_ITEM_SET != pArgs->GetItemState(nSlot);
//STRIP001             if(bQuery)
//STRIP001             {
//STRIP001                 SfxViewFrame* pFrame = GetViewFrame();
//STRIP001                 SfxHelp::OpenHelpAgent( pFrame->GetFrame(), HID_MAIL_MERGE_SELECT ); 
//STRIP001                 SwMailMergeCreateFromDlg* pDlg = new SwMailMergeCreateFromDlg(
//STRIP001                         &pFrame->GetWindow());
//STRIP001                 if(RET_OK == pDlg->Execute())
//STRIP001                     bUseCurrentDocument = pDlg->IsThisDocument();
//STRIP001                 else
//STRIP001                     break;
//STRIP001             }
//STRIP001             GenerateFormLetter(bUseCurrentDocument);
//STRIP001         }
//STRIP001         break;
//STRIP001         default:
//STRIP001 			ASSERT(!this, falscher Dispatcher);
//STRIP001 			return;
//STRIP001 	}
//STRIP001     if(!bIgnore)
//STRIP001         rReq.Done();
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	SeitenNr-Feld invalidieren
 --------------------------------------------------------------------*/

/*N*/ void SwView::UpdatePageNums(USHORT nPhyNum, USHORT nVirtNum, const String& rPgStr)
/*N*/ {
/*N*/ 	String sTemp(GetPageStr( nPhyNum, nVirtNum, rPgStr ));
/*N*/ 	if ( sLstPg != sTemp )
/*N*/ 	{
/*N*/ 		sLstPg = sTemp;
/*N*/ 		const SfxStringItem aTmp( FN_STAT_PAGE,
/*N*/ 								 sLstPg);
/*N*/ 		SfxBindings &rBnd = GetViewFrame()->GetBindings();
/*N*/ 		rBnd.SetState( aTmp );
/*N*/ 		rBnd.Update( FN_STAT_PAGE );
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Status der Stauszeile
 --------------------------------------------------------------------*/


/*N*/ void SwView::StateStatusLine(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	SwWrtShell& rShell = GetWrtShell();
/*N*/ 
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 	ASSERT( nWhich, "leeres Set");
/*N*/ 
/*N*/ 	while( nWhich )
/*N*/ 	{
/*N*/ 		switch( nWhich )
/*N*/ 		{
/*N*/ 			case FN_STAT_PAGE:
/*
//JP 07.01.00: is a nice feature - show the selektion of DrawObjects
			if( rShell.IsObjSelected()
//???				|| rShell.IsFrmSelected()
				)
			{
				String sDisplay( rShell.GetDrawView()->GetMarkList().
									GetMarkDescription() );
				rSet.Put( SfxStringItem( FN_STAT_PAGE, sDisplay ));
			}
			else
*/			{
				// Anzahl der Seiten, log. SeitenNr. SeitenNr ermitteln
/*N*/ 				USHORT nPage, nLogPage;
/*N*/ 				String sDisplay;
/*N*/ 				rShell.GetPageNumber( -1, rShell.IsCrsrVisible(), nPage, nLogPage, sDisplay );
/*N*/ 				rSet.Put( SfxStringItem( FN_STAT_PAGE,
/*N*/ 							GetPageStr( nPage, nLogPage, sDisplay) ));
/*N*/ 
/*N*/ 				USHORT nCnt = GetWrtShell().GetPageCnt();
/*N*/ 				if (nPageCnt != nCnt)	// Basic benachrichtigen
/*N*/ 				{
/*N*/ 					nPageCnt = nCnt;
/*N*/ 					SFX_APP()->NotifyEvent(SfxEventHint(SW_EVENT_PAGE_COUNT, GetViewFrame()->GetObjectShell()), FALSE);
/*N*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case FN_STAT_TEMPLATE:
/*N*/ 			{
/*N*/ 				rSet.Put(SfxStringItem( FN_STAT_TEMPLATE,
/*N*/ 										rShell.GetCurPageStyle(FALSE)));
/*N*/ 
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_ATTR_ZOOM:
/*N*/ 			{
/*N*/ 				if ( GetDocShell()->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
/*N*/ 				{
/*N*/ 					const SwViewOption* pVOpt = rShell.GetViewOptions();
/*N*/ 					SvxZoomType eZoom = (SvxZoomType) pVOpt->GetZoomType();
/*N*/ 					SvxZoomItem aZoom(eZoom,
/*N*/ 										pVOpt->GetZoom());
/*N*/ 					if(pWrtShell->IsBrowseMode())
/*N*/ 					{
/*N*/ 						aZoom.SetValueSet(
/*N*/ 								SVX_ZOOM_ENABLE_50|
/*N*/ 								SVX_ZOOM_ENABLE_75|
/*N*/ 								SVX_ZOOM_ENABLE_100|
/*N*/ 								SVX_ZOOM_ENABLE_150|
/*N*/ 								SVX_ZOOM_ENABLE_200);
/*N*/ 					}
/*N*/ 					rSet.Put( aZoom );
/*N*/ 				}
/*N*/ 				else
/*?*/ 					rSet.DisableItem( SID_ATTR_ZOOM );
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_ATTR_POSITION:
/*N*/ 			case SID_ATTR_SIZE:
/*N*/ 			{
/*N*/ 				if( !rShell.IsFrmSelected() && !rShell.IsObjSelected() )
/*N*/ 					SwBaseShell::_SetFrmMode( FLY_DRAG_END );
/*N*/ 				else
/*N*/ 				{
/*?*/ 					USHORT nFrameMode = SwBaseShell::GetFrmMode();
/*?*/ 					if ( nFrameMode == FLY_DRAG_START || nFrameMode == FLY_DRAG )
/*?*/ 					{
/*?*/ 						DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( nWhich == SID_ATTR_POSITION )
//STRIP001 /*?*/ 							rSet.Put( SfxPointItem( SID_ATTR_POSITION,
//STRIP001 /*?*/ 													rShell.GetAnchorObjDiff()));
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							rSet.Put( SvxSizeItem( SID_ATTR_SIZE,
//STRIP001 /*?*/ 												   rShell.GetObjSize()));
/*?*/ 					}
/*?*/ 				}
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case SID_TABLE_CELL:
/*N*/ 
/*N*/ 			if( rShell.IsFrmSelected() || rShell.IsObjSelected() )
/*N*/ 			{
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 rSet.Put( SvxSizeItem( SID_TABLE_CELL, rShell.GetObjSize()));
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				String sStr;
/*N*/ 				if( rShell.IsCrsrInTbl() )
/*N*/ 					sStr = rShell.GetBoxNms();
/*N*/ 				else
/*N*/ 				{
/*N*/ 					const SwSection* pCurrSect = rShell.GetCurrSection();
/*N*/ 					if( pCurrSect )
/*N*/ 					{
/*N*/ 						switch( pCurrSect->GetType() )
/*N*/ 						{
/*N*/ 						case TOX_HEADER_SECTION:
/*N*/ 						case TOX_CONTENT_SECTION:
/*N*/ 							{
/*N*/ 								const SwTOXBase* pTOX = pWrtShell->GetCurTOX();
/*N*/ 								if( pTOX )
/*N*/ 									sStr = pTOX->GetTOXName();
/*N*/ 								else
/*N*/ 								{
/*?*/ 									ASSERT( !this,
/*?*/ 										"was ist das fuer ein Verzeichnis?" );
/*?*/ 									sStr = pCurrSect->GetName();
/*N*/ 								}
/*N*/ 							}
/*N*/ 							break;
/*N*/ 						default:
/*?*/ 							sStr = pCurrSect->GetName();
/*N*/ 							break;
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 				const SwNumRule* pNumRule = rShell.GetCurNumRule();
/*N*/ 				if (pNumRule)	// Cursor in Numerierung
/*N*/ 				{
/*N*/ 					BYTE nNumLevel = rShell.GetNumLevel();
/*N*/ 					if( NO_NUM > nNumLevel && MAXLEVEL >
/*N*/ 						( nNumLevel = GetRealLevel( nNumLevel )) )
/*N*/ 					{
/*N*/ 						if( sStr.Len() )
/*N*/ 							sStr.AppendAscii(sStatusDelim);
/*N*/ 						sStr += SW_RESSTR(STR_NUM_LEVEL);
/*N*/ 						sStr += String::CreateFromInt32( nNumLevel + 1 );
/*N*/ 						if(!pNumRule->IsAutoRule())
/*N*/ 						{
/*N*/ 							SfxItemSet aSet(GetPool(),
/*N*/ 									RES_PARATR_NUMRULE, RES_PARATR_NUMRULE);
/*N*/ 							rShell.GetAttr(aSet);
/*N*/ 							const SfxPoolItem* pItem;
/*N*/ 							if(SFX_ITEM_AVAILABLE <=
/*N*/ 							   aSet.GetItemState(RES_PARATR_NUMRULE, TRUE 
/*N*/ 												 /*, &pItem */ ))
/*N*/ 							{
/*N*/ 								const String& rNumStyle = 
/*N*/ 									((const SfxStringItem &)
/*N*/ 									 aSet.Get(RES_PARATR_NUMRULE)).GetValue();
								/* #i5116# GetItemState does not necessarily
                                   change pItem */
/*N*/ 								// ((const SfxStringItem*)pItem)->GetValue();
/*N*/ 								if(rNumStyle.Len())
/*N*/ 								{
/*N*/ 									sStr.AppendAscii(sStatusDelim);
/*N*/ 									sStr += rNumStyle;
/*N*/ 								}
/*N*/ 							}
/*N*/ 						}
/*N*/ 					}
/*N*/ 				}
/*N*/ 
/*N*/ 				if( rShell.HasReadonlySel() )
/*N*/ 				{
/*N*/ 					if( sStr.Len() )
/*N*/ 						sStr.InsertAscii( sStatusDelim, 0 );
/*N*/ 					sStr.Insert( SW_RESSTR( STR_READONLY_SEL ), 0 );
/*N*/ 				}
/*N*/ 				if( sStr.Len() )
/*N*/ 					rSet.Put( SfxStringItem( SID_TABLE_CELL, sStr ));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 			case FN_STAT_SELMODE:
/*N*/ 			{
/*N*/ 				if(rShell.IsStdMode())
/*N*/ 					rSet.Put(SfxUInt16Item(FN_STAT_SELMODE, 0));
/*N*/ 				else if(rShell.IsAddMode())
/*N*/ 					rSet.Put(SfxUInt16Item(FN_STAT_SELMODE, 2));
/*N*/ 				else
/*N*/ 					rSet.Put(SfxUInt16Item(FN_STAT_SELMODE, 1));
/*N*/ 				break;
/*N*/ 			}
/*N*/ 			case SID_ATTR_INSERT:
/*N*/ 				if( rShell.IsRedlineOn() )
/*N*/ 					rSet.DisableItem( nWhich );
/*N*/ 				else
/*N*/ 				{
/*N*/ 					rSet.Put(SfxBoolItem(SID_ATTR_INSERT,rShell.IsInsMode()));
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			case FN_STAT_HYPERLINKS:
/*N*/ 			{
/*N*/ 				rSet.Put(SfxBoolItem(FN_STAT_HYPERLINKS,
/*N*/ 							pWrtShell->GetViewOptions()->IsExecHyperlinks()));
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Execute fuer die Stauszeile
 --------------------------------------------------------------------*/


/*N*/ void SwView::ExecuteStatusLine(SfxRequest &rReq)
/*N*/ {
DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	SwWrtShell &rSh = GetWrtShell();
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001     const SfxPoolItem* pItem=NULL;
//STRIP001 	BOOL bUp = FALSE;
//STRIP001 	USHORT nWhich = rReq.GetSlot();
//STRIP001 	switch( nWhich )
//STRIP001 	{
//STRIP001 		case FN_STAT_PAGE:
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute( SID_NAVIGATOR,
//STRIP001 									  SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_STAT_BOOKMARK:
//STRIP001 		if ( pArgs )
//STRIP001 		{
//STRIP001 			if (SFX_ITEM_SET == pArgs->GetItemState( nWhich, TRUE, &pItem))
//STRIP001 			{
//STRIP001 				USHORT nDest;
//STRIP001 				nDest = ((const SfxUInt16Item *)pItem)->GetValue();
//STRIP001 				rSh.EnterStdMode();
//STRIP001 				rSh.GotoBookmark( nDest );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_STAT_TEMPLATE:
//STRIP001 		{
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(FN_FORMAT_PAGE_DLG,
//STRIP001 										SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case SID_ATTR_ZOOM:
//STRIP001 		{
//STRIP001 			if ( GetDocShell()->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
//STRIP001 			{
//STRIP001 				const SfxItemSet *pSet = 0;
//STRIP001 				SvxZoomDialog *pDlg = 0;
//STRIP001 				if ( pArgs )
//STRIP001 					pSet = pArgs;
//STRIP001 				else if ( GetDocShell()->GetCreateMode() != SFX_CREATE_MODE_EMBEDDED )
//STRIP001 				{
//STRIP001 					SfxItemSet aCoreSet(pShell->GetPool(), SID_ATTR_ZOOM, SID_ATTR_ZOOM);
//STRIP001 					SvxZoomItem aZoom( (SvxZoomType)rSh.GetViewOptions()->GetZoomType(),
//STRIP001 												rSh.GetViewOptions()->GetZoom()	);
//STRIP001 
//STRIP001 					if(rSh.IsBrowseMode())
//STRIP001 					{
//STRIP001 						aZoom.SetValueSet(
//STRIP001 								SVX_ZOOM_ENABLE_50|
//STRIP001 								SVX_ZOOM_ENABLE_75|
//STRIP001 								SVX_ZOOM_ENABLE_100|
//STRIP001 								SVX_ZOOM_ENABLE_150|
//STRIP001 								SVX_ZOOM_ENABLE_200);
//STRIP001 					}
//STRIP001 					aCoreSet.Put( aZoom );
//STRIP001 
//STRIP001 					pDlg = new SvxZoomDialog( &GetViewFrame()->GetWindow(), aCoreSet );
//STRIP001 					pDlg->SetLimits( MINZOOM, MAXZOOM );
//STRIP001 
//STRIP001 					if( pDlg->Execute() != RET_CANCEL )
//STRIP001 						pSet = pDlg->GetOutputItemSet();
//STRIP001 				}
//STRIP001 
//STRIP001 				if ( pSet && SFX_ITEM_SET == pSet->GetItemState(SID_ATTR_ZOOM, TRUE, &pItem))
//STRIP001 				{
//STRIP001 					enum SvxZoomType eType = ((const SvxZoomItem *)pItem)->GetType();
//STRIP001 					SetZoom( eType, ((const SvxZoomItem *)pItem)->GetValue() );
//STRIP001 				}
//STRIP001 				bUp = TRUE;
//STRIP001 				if ( pItem )
//STRIP001 					rReq.AppendItem( *pItem );
//STRIP001 				rReq.Done();
//STRIP001 				delete pDlg;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_ATTR_SIZE:
//STRIP001 		{
//STRIP001 			ULONG nId = FN_INSERT_FIELD;
//STRIP001 			if( rSh.IsCrsrInTbl() )
//STRIP001 				nId = FN_FORMAT_TABLE_DLG;
//STRIP001 			else if( rSh.GetCurTOX() )
//STRIP001 				nId = FN_INSERT_MULTI_TOX;
//STRIP001 			else if( rSh.GetCurrSection() )
//STRIP001 				nId = FN_EDIT_REGION;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const SwNumRule* pNumRule = rSh.GetCurNumRule();
//STRIP001 				if( pNumRule )	// Cursor in Numerierung
//STRIP001 				{
//STRIP001 					if( pNumRule->IsAutoRule() )
//STRIP001 						nId = FN_NUMBER_BULLETS;
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// Dialog vom Gestalter starten ;-)
//STRIP001 						nId = 0;
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else if( rSh.IsFrmSelected() )
//STRIP001 					nId = FN_FORMAT_FRAME_DLG;
//STRIP001 				else if( rSh.IsObjSelected() )
//STRIP001 					nId = SID_ATTR_TRANSFORM;
//STRIP001 			}
//STRIP001 			if( nId )
//STRIP001 				GetViewFrame()->GetDispatcher()->Execute( nId, SFX_CALLMODE_SYNCHRON |
//STRIP001 											   SFX_CALLMODE_RECORD );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_STAT_SELMODE:
//STRIP001 		{
//STRIP001 			if ( pArgs )
//STRIP001 			{
//STRIP001 				if (SFX_ITEM_SET == pArgs->GetItemState( nWhich, TRUE, &pItem))
//STRIP001 				{
//STRIP001 					switch ( ((const SfxUInt16Item *)pItem)->GetValue() )
//STRIP001 					{
//STRIP001 						case 0: rSh.EnterStdMode(); break;
//STRIP001 						case 1: rSh.EnterExtMode(); break;
//STRIP001 						case 2: rSh.EnterAddMode(); break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 
//STRIP001 				if( !rSh.IsAddMode() && !rSh.IsExtMode() )
//STRIP001 					rSh.ToggleExtMode();
//STRIP001 				else if ( rSh.IsExtMode() )
//STRIP001 				{
//STRIP001 					rSh.ToggleExtMode();
//STRIP001 					rSh.ToggleAddMode();
//STRIP001 				}
//STRIP001 				else if ( rSh.IsAddMode() )
//STRIP001 					rSh.ToggleAddMode();
//STRIP001 			}
//STRIP001 			bUp = TRUE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		case FN_SET_ADD_MODE:
//STRIP001 			rSh.ToggleAddMode();
//STRIP001 			nWhich = FN_STAT_SELMODE;
//STRIP001 			bUp = TRUE;
//STRIP001 		break;
//STRIP001 		case FN_SET_EXT_MODE:
//STRIP001 			rSh.ToggleExtMode();
//STRIP001 			nWhich = FN_STAT_SELMODE;
//STRIP001 			bUp = TRUE;
//STRIP001 		break;
//STRIP001 		case SID_ATTR_INSERT:
//STRIP001 			rSh.ToggleInsMode();
//STRIP001 			bUp = TRUE;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_STAT_HYPERLINKS:
//STRIP001 		{
//STRIP001 			SwViewOption aOpt( *rSh.GetViewOptions() );
//STRIP001 			BOOL bIs = aOpt.IsExecHyperlinks();
//STRIP001 			BOOL bSet;
//STRIP001 			if(pArgs && SFX_ITEM_SET == pArgs->GetItemState(nWhich, FALSE, &pItem))
//STRIP001 				bSet = ((const SfxBoolItem*)pItem)->GetValue();
//STRIP001 			else
//STRIP001 				bSet = !bIs;
//STRIP001 			if(bIs != bSet)
//STRIP001 			{
//STRIP001 				aOpt.SetExecHyperlinks(bSet);
//STRIP001 				SW_MOD()->ApplyUsrPref(aOpt, this);
//STRIP001 				bUp = TRUE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	if ( bUp )
//STRIP001 	{
//STRIP001 		SfxBindings &rBnd = GetViewFrame()->GetBindings();
//STRIP001 		rBnd.Invalidate(nWhich);
//STRIP001 		rBnd.Update(nWhich);
//STRIP001 	}
/*N*/ }




//STRIP001 void SwView::InsFrmMode(USHORT nCols)
//STRIP001 {
//STRIP001 	if ( pWrtShell->HasWholeTabSelection() )
//STRIP001 	{
//STRIP001 		SwFlyFrmAttrMgr aMgr( TRUE, pWrtShell, FRMMGR_TYPE_TEXT );
//STRIP001 
//STRIP001 		const SwFrmFmt &rPageFmt =
//STRIP001 				pWrtShell->GetPageDesc(pWrtShell->GetCurPageDesc()).GetMaster();
//STRIP001 		SwTwips lWidth = rPageFmt.GetFrmSize().GetWidth();
//STRIP001 		const SvxLRSpaceItem &rLR = rPageFmt.GetLRSpace();
//STRIP001 		lWidth -= rLR.GetLeft() + rLR.GetRight();
//STRIP001 		aMgr.SetSize(Size(lWidth, aMgr.GetSize().Height()));
//STRIP001 		if(nCols > 1)
//STRIP001 		{
//STRIP001 			SwFmtCol aCol;
//STRIP001 			aCol.Init( nCols, aCol.GetGutterWidth(), aCol.GetWishWidth() );
//STRIP001 			aMgr.SetCol( aCol );
//STRIP001 		}
//STRIP001 		aMgr.InsertFlyFrm();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GetEditWin().InsFrm(nCols);
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Links bearbeiten
 --------------------------------------------------------------------*/

//STRIP001 void SwView::EditLinkDlg()
//STRIP001 {
//STRIP001 	BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 	::so3::SvBaseLinksDialog aSvBaseLinksDialog( &GetViewFrame()->GetWindow(),
//STRIP001 									&GetWrtShell().GetLinkManager(), bWeb );
//STRIP001 	aSvBaseLinksDialog.Execute();
/*
	SwLinkDlg* pDlg = new SwLinkDlg(GetFrameWindow());
	pDlg->SetShell(&GetWrtShell());
	pDlg->Execute();

	DELETEZ(pDlg);
*/
//STRIP001 }

//STRIP001 BOOL SwView::JumpToSwMark( const String& rMark )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( rMark.Len() )
//STRIP001 	{
//STRIP001 		// wir wollen den Bookmark aber am oberen Rand haben
//STRIP001 		BOOL bSaveCC = IsCrsrAtCenter();
//STRIP001 		BOOL bSaveCT = IsCrsrAtTop();
//STRIP001 		SetCrsrAtTop( TRUE );
//STRIP001 
//STRIP001 		//JP 27.04.98: Bug 49786
//STRIP001 		// Damit in FrameSet auch gescrollt werden kann, muss die
//STRIP001 		// entsprechende Shell auch das Focus-Flag gesetzt haben!
//STRIP001 		BOOL bHasShFocus = pWrtShell->HasShFcs();
//STRIP001 		if( !bHasShFocus )
//STRIP001 			pWrtShell->ShGetFcs( FALSE );
//STRIP001 
//STRIP001 		const SwFmtINetFmt* pINet;
//STRIP001 		String sCmp, sMark( INetURLObject::decode( rMark, INET_HEX_ESCAPE,
//STRIP001 						   				INetURLObject::DECODE_WITH_CHARSET,
//STRIP001 										RTL_TEXTENCODING_UTF8 ));
//STRIP001 
//STRIP001 		xub_StrLen nLastPos, nPos = sMark.Search( cMarkSeperator );
//STRIP001 		if( STRING_NOTFOUND != nPos )
//STRIP001 			while( STRING_NOTFOUND != ( nLastPos =
//STRIP001 				sMark.Search( cMarkSeperator, nPos + 1 )) )
//STRIP001 				nPos = nLastPos;
//STRIP001 
//STRIP001 		if( STRING_NOTFOUND != nPos &&
//STRIP001 			( sCmp = sMark.Copy( nPos + 1 ) ).EraseAllChars().Len() )
//STRIP001 		{
//STRIP001 			String sName( sMark.Copy( 0, nPos ) );
//STRIP001 			sCmp.ToLowerAscii();
//STRIP001 			FlyCntType eFlyType = FLYCNTTYPE_ALL;
//STRIP001 
//STRIP001 			if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToRegion ) )
//STRIP001 			{
//STRIP001 				pWrtShell->EnterStdMode();
//STRIP001 				bRet = pWrtShell->GotoRegion( sName );
//STRIP001 			}
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToOutline ) )
//STRIP001 			{
//STRIP001 				pWrtShell->EnterStdMode();
//STRIP001 				bRet = pWrtShell->GotoOutline( sName );
//STRIP001 			}
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToFrame ) )
//STRIP001 				eFlyType = FLYCNTTYPE_FRM;
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToGraphic ) )
//STRIP001 				eFlyType = FLYCNTTYPE_GRF;
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToOLE ) )
//STRIP001 				eFlyType = FLYCNTTYPE_OLE;
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToTable ) )
//STRIP001 			{
//STRIP001 				pWrtShell->EnterStdMode();
//STRIP001 				bRet = pWrtShell->GotoTable( sName );
//STRIP001 			}
//STRIP001 			else if( COMPARE_EQUAL == sCmp.CompareToAscii( pMarkToText ) )
//STRIP001 			{
//STRIP001 				// Normale Textsuche
//STRIP001 				pWrtShell->EnterStdMode();
//STRIP001 
//STRIP001 				SearchOptions aSearchOpt(
//STRIP001 									SearchAlgorithms_ABSOLUTE, 0,
//STRIP001 									sName, ::rtl::OUString(),
//STRIP001 									CreateLocale( LANGUAGE_SYSTEM ),
//STRIP001 									0,0,0,
//STRIP001 									TransliterationModules_IGNORE_CASE );
//STRIP001 
//STRIP001 				if( pWrtShell->SearchPattern( aSearchOpt, DOCPOS_START, DOCPOS_END ))
//STRIP001 				{
//STRIP001 					pWrtShell->EnterStdMode();		// Selektion wieder aufheben
//STRIP001 					bRet = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( USHRT_MAX != ( nPos = pWrtShell->FindBookmark( sMark ) ))
//STRIP001 				pWrtShell->GotoBookmark( nPos, FALSE, TRUE ), bRet = TRUE;
//STRIP001 			else if( 0 != ( pINet = pWrtShell->FindINetAttr( sMark ) ))
//STRIP001 				bRet = pWrtShell->GotoINetAttr( *pINet->GetTxtINetFmt() );
//STRIP001 
//STRIP001 			// fuer alle Arten von Flys
//STRIP001 			if( FLYCNTTYPE_ALL != eFlyType && pWrtShell->GotoFly( sName, eFlyType ))
//STRIP001 			{
//STRIP001 				bRet = TRUE;
//STRIP001 				if( FLYCNTTYPE_FRM == eFlyType )
//STRIP001 				{
//STRIP001 					// TextFrames: Cursor in den Frame setzen
//STRIP001 					pWrtShell->UnSelectFrm();
//STRIP001 					pWrtShell->LeaveSelFrmMode();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pWrtShell->HideCrsr();
//STRIP001 					pWrtShell->EnterSelFrmMode();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else if( USHRT_MAX != ( nPos = pWrtShell->FindBookmark( sMark ) ))
//STRIP001 			pWrtShell->GotoBookmark( nPos, FALSE, TRUE ), bRet = TRUE;
//STRIP001 		else if( 0 != ( pINet = pWrtShell->FindINetAttr( sMark ) ))
//STRIP001 			bRet = pWrtShell->GotoINetAttr( *pINet->GetTxtINetFmt() );
//STRIP001 
//STRIP001 		// ViewStatus wieder zurueck setzen
//STRIP001 		SetCrsrAtTop( bSaveCT, bSaveCC );
//STRIP001 
//STRIP001 		if( !bHasShFocus )
//STRIP001 			pWrtShell->ShLooseFcs();
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Links bearbeiten
 --------------------------------------------------------------------*/

//STRIP001 long SwView::InsertDoc( USHORT nSlotId, const String& rFileName,
//STRIP001 						const String& rFilterName, INT16 nVersion )
//STRIP001 {
//STRIP001 	BOOL bInsert = FALSE, bCompare = FALSE, bMerge = FALSE;
//STRIP001 	long nFound = 0;
//STRIP001 
//STRIP001 	switch( nSlotId )
//STRIP001 	{
//STRIP001 		case SID_DOCUMENT_MERGE:		bMerge = TRUE;		break;
//STRIP001 		case SID_DOCUMENT_COMPARE:		bCompare = TRUE;	break;
//STRIP001 		case SID_INSERTDOC:				bInsert = TRUE;		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			ASSERT( !this, "Unbekannte SlotId!" );
//STRIP001 			bInsert = TRUE;
//STRIP001 			nSlotId = SID_INSERTDOC;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxMedium* pMed = 0;
//STRIP001 	SwDocShell* pDocSh = GetDocShell();
//STRIP001 	if( rFileName.Len() )
//STRIP001 	{
//STRIP001 		SfxObjectFactory& rFact = pDocSh->GetFactory();
//STRIP001         const SfxFilter* pFilter = rFact.GetFilterContainer()->GetFilter( rFilterName );
//STRIP001 		if ( !pFilter )
//STRIP001 		{
//STRIP001 			pMed = new SfxMedium(rFileName, STREAM_READ, TRUE, 0, 0 );
//STRIP001 			SfxFilterMatcher aMatcher( rFact.GetFilterContainer() );
//STRIP001 			ErrCode nErr = aMatcher.GuessFilter( *pMed, &pFilter, FALSE );
//STRIP001 			if ( nErr )
//STRIP001 				DELETEZ(pMed);
//STRIP001 			else
//STRIP001 				pMed->SetFilter( pFilter );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pMed = new SfxMedium(rFileName, STREAM_READ, TRUE, pFilter, 0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pMed = SFX_APP()->InsertDocumentDialog(0, pDocSh->GetFactory(), HID_INSERT_FILE );
//STRIP001 	}
//STRIP001 	if( !pMed )
//STRIP001 		return -1;
//STRIP001 
//STRIP001 	if( bInsert )
//STRIP001 	{
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder =
//STRIP001                 GetViewFrame()->GetBindings().GetRecorder();
//STRIP001 		if ( xRecorder.is() )
//STRIP001         {
//STRIP001             SfxRequest aRequest(GetViewFrame(), SID_INSERTDOC);
//STRIP001             aRequest.AppendItem(SfxStringItem(SID_INSERTDOC, pMed->GetOrigURL()));
//STRIP001             if(pMed->GetFilter())
//STRIP001             aRequest.AppendItem(SfxStringItem(FN_PARAM_1, pMed->GetFilter()->GetName()));
//STRIP001             aRequest.Done();
//STRIP001         }
//STRIP001 
//STRIP001         SfxObjectShellRef aRef( pDocSh );
//STRIP001 
//STRIP001         SfxObjectShell::HandleFilter( pMed, pDocSh );
//STRIP001         pDocSh->RegisterTransfer( *pMed );
//STRIP001 		pMed->DownLoad();	// ggfs. den DownLoad anstossen
//STRIP001 		if( aRef.Is() && 1 < aRef->GetRefCount() )	// noch gueltige Ref?
//STRIP001 		{
//STRIP001 			SwReader* pRdr;
//STRIP001 			Reader *pRead = pDocSh->StartConvertFrom( *pMed, &pRdr, pWrtShell );
//STRIP001 			if( pRead ||
//STRIP001 				(pMed->GetFilter()->GetFilterFlags() & SFX_FILTER_STARONEFILTER) != 0 )
//STRIP001 			{
//STRIP001 				String sTmpBaseURL( so3::StaticBaseUrl::GetBaseURL() );
//STRIP001 				so3::StaticBaseUrl::SetBaseURL( pMed->GetName() );
//STRIP001 
//STRIP001 				ULONG nErrno;
//STRIP001 				{	//Scope for SwWait-Object, to be able to execute slots
//STRIP001 					//outside this scope.
//STRIP001 					SwWait aWait( *GetDocShell(), TRUE );
//STRIP001 					pWrtShell->StartAllAction();
//STRIP001 					if ( pWrtShell->HasSelection() )
//STRIP001 						pWrtShell->DelRight();		// Selektionen loeschen
//STRIP001 					if( pRead )
//STRIP001 					{
//STRIP001 						nErrno = pRdr->Read( *pRead );	// und Dokument einfuegen
//STRIP001 						delete pRdr;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						nErrno = pDocSh->ImportFrom( *pMed ) ? 0
//STRIP001 												: ERR_SWG_READ_ERROR;
//STRIP001 					}
//STRIP001 
//STRIP001 					so3::StaticBaseUrl::SetBaseURL( sTmpBaseURL );
//STRIP001 				}
//STRIP001 
//STRIP001 				// ggfs. alle Verzeichnisse updaten:
//STRIP001 				if( pWrtShell->IsUpdateTOX() )
//STRIP001 				{
//STRIP001 					SfxRequest aReq( FN_UPDATE_TOX, SFX_CALLMODE_SLOT, GetPool() );
//STRIP001 					Execute( aReq );
//STRIP001 					pWrtShell->SetUpdateTOX( FALSE );		// wieder zurueck setzen
//STRIP001 				}
//STRIP001 
//STRIP001 				pWrtShell->EndAllAction();
//STRIP001 				if( nErrno )
//STRIP001 				{
//STRIP001 					ErrorHandler::HandleError( nErrno );
//STRIP001 					nFound = IsError( nErrno ) ? -1 : 0;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					nFound = 0;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SfxObjectShellRef xDocSh;
//STRIP001 
//STRIP001 extern int lcl_FindDocShell( SfxObjectShellRef& xDocSh,
//STRIP001 							const String& rFileName, const String& rPasswd,
//STRIP001 							String& rFilter, INT16 nVersion,
//STRIP001 							SwDocShell* pDestSh );
//STRIP001 
//STRIP001 		String sFltNm;
//STRIP001 		int nRet = lcl_FindDocShell( xDocSh, pMed->GetName(), aEmptyStr,
//STRIP001 									sFltNm, nVersion, pDocSh );
//STRIP001 		if( nRet )
//STRIP001 		{
//STRIP001 			SwWait aWait( *GetDocShell(), TRUE );
//STRIP001 			pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 			pWrtShell->EnterStdMode();			// Selektionen loeschen
//STRIP001 
//STRIP001 			if( bCompare )
//STRIP001 				nFound = pWrtShell->CompareDoc( *((SwDocShell*)&xDocSh)->GetDoc() );
//STRIP001 			else
//STRIP001 				nFound = pWrtShell->MergeDoc( *((SwDocShell*)&xDocSh)->GetDoc() );
//STRIP001 
//STRIP001 			pWrtShell->EndAllAction();
//STRIP001 
//STRIP001 			if (!bCompare && !nFound)
//STRIP001 			{
//STRIP001 				Window* pWindow = &GetEditWin();
//STRIP001 				InfoBox(pWindow, SW_RES(MSG_NO_MERGE_ENTRY)).Execute();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( 2 == nRet && xDocSh.Is() )
//STRIP001 			xDocSh->DoClose();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pMed;
//STRIP001 	return nFound;
//STRIP001 }
//STRIP001 /* -----------------05.02.2003 12:06-----------------
//STRIP001  * 
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwView::EnableMailMerge(BOOL bEnable )
//STRIP001 {
//STRIP001     bInMailMerge = bEnable;
//STRIP001     SfxBindings& rBind = GetViewFrame()->GetBindings();
//STRIP001     rBind.Invalidate(FN_INSERT_FIELD_DATA_ONLY);
//STRIP001     rBind.Update(FN_INSERT_FIELD_DATA_ONLY);
//STRIP001 }        
//STRIP001 /*
//STRIP001 */
//STRIP001 namespace
//STRIP001 {
//STRIP001 	sal_Bool lcl_NeedAdditionalDataSource( const Reference< XNameAccess >& _rDatasourceContext )
//STRIP001 	{
//STRIP001 		Sequence < OUString > aNames = _rDatasourceContext->getElementNames();
//STRIP001 
//STRIP001 		return	(	!aNames.getLength()
//STRIP001 				||	(	( 1 == aNames.getLength() )
//STRIP001 					&&	aNames.getConstArray()[0] == SW_MOD()->GetDBConfig()->GetBibliographySource().sDataSource
//STRIP001 					)
//STRIP001 				);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------27.11.2002 12:12-----------------
//STRIP001  * 
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwView::GenerateFormLetter(BOOL bUseCurrentDocument)
//STRIP001 {
//STRIP001     if(bUseCurrentDocument)
//STRIP001     {
//STRIP001         if(!GetWrtShell().IsAnyDatabaseFieldInDoc())
//STRIP001         {
//STRIP001             //check availability of data sources (except biblio source)
//STRIP001             Reference< XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory() );
//STRIP001             Reference<XNameAccess>  xDBContext;
//STRIP001             if( xMgr.is() )
//STRIP001             {
//STRIP001                 Reference<XInterface> xInstance = xMgr->createInstance( 
//STRIP001                     OUString::createFromAscii( "com.sun.star.sdb.DatabaseContext" ));
//STRIP001                 xDBContext = Reference<XNameAccess>(xInstance, UNO_QUERY) ;
//STRIP001             }
//STRIP001             if(!xDBContext.is())
//STRIP001                 return ;
//STRIP001             BOOL bCallAddressPilot = FALSE;
//STRIP001 			if ( lcl_NeedAdditionalDataSource( xDBContext ) )
//STRIP001             {
//STRIP001                 // no data sources are available - create a new one
//STRIP001                 WarningBox aWarning(
//STRIP001                             &GetViewFrame()->GetWindow(), 
//STRIP001                             SW_RES(MSG_DATA_SOURCES_UNAVAILABLE));
//STRIP001                 // no cancel allowed
//STRIP001                 if ( RET_OK != aWarning.Execute() )
//STRIP001 					return;
//STRIP001                 bCallAddressPilot = TRUE;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 //take an existing data source or create a new one?
//STRIP001                     SwMailMergeFieldConnectionsDlg* pConnectionsDlg = new SwMailMergeFieldConnectionsDlg(
//STRIP001                                                                     &GetViewFrame()->GetWindow());
//STRIP001                     if(RET_OK == pConnectionsDlg->Execute())
//STRIP001                         bCallAddressPilot = !pConnectionsDlg->IsUseExistingConnections();
//STRIP001                     else
//STRIP001                         return;
//STRIP001                 
//STRIP001             }            
//STRIP001             if(bCallAddressPilot)
//STRIP001             {
//STRIP001                 GetViewFrame()->GetDispatcher()->Execute( 
//STRIP001                                 SID_ADDRESS_DATA_SOURCE, SFX_CALLMODE_SYNCHRON);
//STRIP001 				if ( lcl_NeedAdditionalDataSource( xDBContext ) )
//STRIP001 					// no additional data source has been created
//STRIP001 					// -> assume that the user has cancelled the pilot
//STRIP001 					return;
//STRIP001             }
//STRIP001             
//STRIP001             //call insert fields with database field page available, only
//STRIP001             SfxViewFrame* pVFrame = GetViewFrame();
//STRIP001             //at first hide the default field dialog if currently visible
//STRIP001             pVFrame->SetChildWindow(FN_INSERT_FIELD, FALSE);
//STRIP001             //enable the status of the db field dialog - it is disabled in the status method 
//STRIP001             //to prevent creation of the dialog without mail merge active
//STRIP001             EnableMailMerge();
//STRIP001             //then show the "Data base only" field dialog
//STRIP001             SfxBoolItem aOn(FN_INSERT_FIELD_DATA_ONLY, TRUE);
//STRIP001             pVFrame->GetDispatcher()->Execute(FN_INSERT_FIELD_DATA_ONLY, 
//STRIP001                                                 SFX_CALLMODE_SYNCHRON, &aOn, 0);
//STRIP001             return;
//STRIP001         }        
//STRIP001         else
//STRIP001         {
//STRIP001             // check whether the 
//STRIP001             String sSource;
//STRIP001             if(!GetWrtShell().IsFieldDataSourceAvailable(sSource))
//STRIP001             {        
//STRIP001                 WarningBox aWarning( &GetViewFrame()->GetWindow(), 
//STRIP001                             SW_RES(MSG_MERGE_SOURCE_UNAVAILABLE));
//STRIP001                 String sTmp(aWarning.GetMessText());
//STRIP001                 sTmp.SearchAndReplaceAscii("%1", sSource);
//STRIP001                 aWarning.SetMessText(sTmp);
//STRIP001                 aWarning.Execute();
//STRIP001                 return ;
//STRIP001             }
//STRIP001         }        
//STRIP001         SwNewDBMgr* pNewDBMgr = GetWrtShell().GetNewDBMgr();
//STRIP001         
//STRIP001         SwDBData aData;
//STRIP001         SwWrtShell &rSh = GetWrtShell();
//STRIP001         aData = rSh.GetDBData();
//STRIP001         rSh.EnterStdMode(); // Wechsel in Textshell erzwingen; ist fuer
//STRIP001                             // das Mischen von DB-Feldern notwendig.
//STRIP001         AttrChangedNotify( &rSh );
//STRIP001         pNewDBMgr->SetMergeType( DBMGR_MERGE );
//STRIP001 
//STRIP001         if (pNewDBMgr)
//STRIP001         {
//STRIP001             Sequence<PropertyValue> aProperties(3);
//STRIP001             PropertyValue* pValues = aProperties.getArray();
//STRIP001             pValues[0].Name = C2U("DataSourceName");
//STRIP001             pValues[1].Name = C2U("Command");
//STRIP001             pValues[2].Name = C2U("CommandType");
//STRIP001             pValues[0].Value <<= aData.sDataSource;
//STRIP001             pValues[1].Value <<= aData.sCommand;
//STRIP001             pValues[2].Value <<= aData.nCommandType;
//STRIP001             pNewDBMgr->ExecuteFormLetter(GetWrtShell(), aProperties, TRUE);
//STRIP001         }
//STRIP001     }        
//STRIP001     else
//STRIP001     {
//STRIP001         //call documents and template dialog
//STRIP001         SfxApplication* pSfxApp = SFX_APP();
//STRIP001         Window* pTopWin = pSfxApp->GetTopWindow();
//STRIP001         SvtDocumentTemplateDialog* pDocTemplDlg = new SvtDocumentTemplateDialog( pTopWin );
//STRIP001         pDocTemplDlg->SelectTemplateFolder();
//STRIP001 
//STRIP001         int nRet = pDocTemplDlg->Execute();
//STRIP001         sal_Bool bNewWin = sal_False;
//STRIP001         if ( nRet == RET_OK )
//STRIP001         {
//STRIP001             if ( pTopWin != pSfxApp->GetTopWindow() )
//STRIP001             {
//STRIP001                 // the dialogue opens a document -> a new TopWindow appears
//STRIP001                 pTopWin = pSfxApp->GetTopWindow();
//STRIP001                 bNewWin = sal_True;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         delete pDocTemplDlg;
//STRIP001         if ( bNewWin )
//STRIP001             // after the destruction of the dialogue its parent comes to top,
//STRIP001             // but we want that the new document is on top
//STRIP001             pTopWin->ToTop();
//STRIP001 
//STRIP001 //        return;
//STRIP001     }
//STRIP001 }            


}
