/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_glossary.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:17:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "so3/staticbaseurl.hxx"
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #define _SVSTDARR_STRINGSDTOR
//STRIP001 #define _SVSTDARR_STRINGS
//STRIP001 
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UIPARAM_HXX
//STRIP001 #include <uiparam.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _MENU_HXX //autogen
//STRIP001 #include <vcl/menu.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _HELP_HXX //autogen
//STRIP001 #include <vcl/help.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVSTDARR_HXX
//STRIP001 #include <svtools/svstdarr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXSTRITEM_HXX //autogen
//STRIP001 #include <svtools/stritem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef INCLUDED_SVTOOLS_PATHOPTIONS_HXX
//STRIP001 #include <svtools/pathoptions.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXREQUEST_HXX //autogen
//STRIP001 #include <bf_sfx2/request.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_FCONTNR_HXX
//STRIP001 #include <bf_sfx2/fcontnr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_MULTIPAT_HXX //autogen
//STRIP001 #include <bf_svx/multipat.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFF_APP_HXX //autogen
//STRIP001 #include <bf_offmgr/app.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFAACCFG_HXX //autogen
//STRIP001 #include <bf_offmgr/ofaaccfg.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _DOC_HXX //autogen wg. SwDoc
//STRIP001 #include <doc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOCRSR_HXX //autogen wg. SwUnoCrsr
//STRIP001 #include <unocrsr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_HXX
//STRIP001 #include <unotools.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOOBJ_HXX
//STRIP001 #include <unoobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
//STRIP001 #include <comphelper/processfactory.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UCBHELPER_CONTENT_HXX
//STRIP001 #include <ucbhelper/content.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UI_DIALOGS_XFILEPICKER_HPP_
//STRIP001 #include <com/sun/star/ui/dialogs/XFilePicker.hpp>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UI_DIALOGS_XFILTERMANAGER_HPP_
//STRIP001 #include <com/sun/star/ui/dialogs/XFilterManager.hpp>
//STRIP001 #endif
//STRIP001 #ifndef  _COM_SUN_STAR_UI_DIALOGS_TEMPLATEDESCRIPTION_HPP_
//STRIP001 #include <com/sun/star/ui/dialogs/TemplateDescription.hpp>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef SVTOOLS_URIHELPER_HXX
//STRIP001 #include <svtools/urihelper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_CHARCLASS_HXX
//STRIP001 #include <unotools/charclass.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SWWAIT_HXX
//STRIP001 #include <swwait.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWTYPES_HXX
//STRIP001 #include <swtypes.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include <wrtsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _VIEW_HXX
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _BASESH_HXX
//STRIP001 #include <basesh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSSARY_HXX
//STRIP001 #include <glossary.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSHDL_HXX
//STRIP001 #include <gloshdl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSBIB_HXX
//STRIP001 #include <glosbib.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _INITUI_HXX
//STRIP001 #include <initui.hxx>					// fuer ::GetGlossaries()
//STRIP001 #endif
//STRIP001 #ifndef _GLOSDOC_HXX
//STRIP001 #include <glosdoc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MACASSGN_HXX
//STRIP001 #include <macassgn.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWEVENT_HXX
//STRIP001 #include <swevent.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SHELLIO_HXX
//STRIP001 #include <shellio.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _CMDID_H
//STRIP001 #include <cmdid.h>
//STRIP001 #endif
//STRIP001 #ifndef _HELPID_H
//STRIP001 #include <helpid.h>
//STRIP001 #endif
//STRIP001 #ifndef _SWERROR_H
//STRIP001 #include <swerror.h>
//STRIP001 #endif
//STRIP001 #ifndef _GLOBALS_HRC
//STRIP001 #include <globals.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _MISC_HRC
//STRIP001 #include <misc.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSSARY_HRC
//STRIP001 #include <glossary.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _SWMODULE_HXX
//STRIP001 #include <swmodule.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _URLOBJ_HXX
//STRIP001 #include <tools/urlobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FILEDLGHELPER_HXX
//STRIP001 #include <bf_sfx2/filedlghelper.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 // #107253#
//STRIP001 #ifndef _SWLINGUCONFIG_HXX
//STRIP001 #include <swlinguconfig.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #define LONG_LENGTH 60
//STRIP001 #define SHORT_LENGTH 30
//STRIP001 
//STRIP001 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP001 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP001 #endif
//STRIP001 
//STRIP001 using namespace ::com::sun::star;
//STRIP001 using namespace ::com::sun::star::lang;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::text;
//STRIP001 using namespace ::com::sun::star::ucb;
//STRIP001 using namespace ::com::sun::star::ui::dialogs;
//STRIP001 using namespace ::comphelper;
//STRIP001 using namespace ::ucb;
//STRIP001 using namespace ::rtl;
//STRIP001 using namespace ::sfx2;
//STRIP001 
//STRIP001 /* -----------------------------08.02.00 10:28--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 struct GroupUserData
//STRIP001 {
//STRIP001 	String 		sGroupName;
//STRIP001 	sal_uInt16 	nPathIdx;
//STRIP001 	BOOL 		bReadonly;
//STRIP001 
//STRIP001 	GroupUserData()
//STRIP001 		: nPathIdx(0),
//STRIP001 		  bReadonly(FALSE)	{}
//STRIP001 };
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Dialog fuer neuen Bausteinnamen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 class SwNewGlosNameDlg : public ModalDialog
//STRIP001 {
//STRIP001 	FixedText		aNNFT;
//STRIP001 	Edit			aNewName;
//STRIP001 	FixedText		aNSFT;
//STRIP001 	NoSpaceEdit		aNewShort;
//STRIP001 	OKButton		aOk;
//STRIP001 	CancelButton	aCancel;
//STRIP001     FixedLine       aFL;
//STRIP001 	FixedText		aONFT;
//STRIP001 	Edit			aOldName;
//STRIP001 	FixedText 		aOSFT;
//STRIP001 	Edit			aOldShort;
//STRIP001 
//STRIP001 protected:
//STRIP001 	DECL_LINK( Modify, Edit * );
//STRIP001 	DECL_LINK( Rename, Button * );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwNewGlosNameDlg( Window* pParent,
//STRIP001 					  const String& rOldName,
//STRIP001 					  const String& rOldShort );
//STRIP001 
//STRIP001 	String GetNewName()  const { return aNewName.GetText(); }
//STRIP001 	String GetNewShort() const { return aNewShort.GetText(); }
//STRIP001 };
//STRIP001 
//STRIP001 SwNewGlosNameDlg::SwNewGlosNameDlg(Window* pParent,
//STRIP001 							const String& rOldName,
//STRIP001 							const String& rOldShort ) :
//STRIP001 	ModalDialog( pParent, SW_RES( DLG_RENAME_GLOS ) ),
//STRIP001 	aOk		(this, SW_RES( BT_OKNEW)),
//STRIP001 	aCancel	(this, SW_RES( BT_CANCEL)),
//STRIP001 	aONFT	(this, SW_RES( FT_ON	)),
//STRIP001 	aOSFT	(this, SW_RES( FT_OS	)),
//STRIP001 	aNNFT	(this, SW_RES( FT_NN	)),
//STRIP001 	aNSFT	(this, SW_RES( FT_NS	)),
//STRIP001 	aOldName(this, SW_RES( ED_ON	)),
//STRIP001 	aOldShort(this,SW_RES( ED_OS	)),
//STRIP001 	aNewName(this, SW_RES( ED_NN	)),
//STRIP001 	aNewShort(this,SW_RES( ED_NS	)),
//STRIP001     aFL    (this, SW_RES( FL_NN    ))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	aOldName.SetText( rOldName );
//STRIP001 	aOldShort.SetText( rOldShort );
//STRIP001 	aNewShort.SetMaxTextLen(SHORT_LENGTH);
//STRIP001 	aNewName.SetMaxTextLen(LONG_LENGTH);
//STRIP001 	aNewName.SetModifyHdl(LINK(this, SwNewGlosNameDlg, Modify ));
//STRIP001 	aNewShort.SetModifyHdl(LINK(this, SwNewGlosNameDlg, Modify ));
//STRIP001 	aOk.SetClickHdl(LINK(this, SwNewGlosNameDlg, Rename ));
//STRIP001 	aNewName.GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	aktuell eingestellte Gruppe erfragen / setzen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 String SwGlossaryDlg::GetCurrGroup()
//STRIP001 {
//STRIP001 	if( pCurrGlosGroup && pCurrGlosGroup->Len() )
//STRIP001 		return *pCurrGlosGroup;
//STRIP001 	return SwGlossaries::GetDefName();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryDlg::SetActGroup(const String &rGrp)
//STRIP001 {
//STRIP001 	if( !pCurrGlosGroup )
//STRIP001 		pCurrGlosGroup = new String;
//STRIP001 	*pCurrGlosGroup = rGrp;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SwGlossaryDlg::SwGlossaryDlg(SfxViewFrame* pViewFrame,
//STRIP001 							SwGlossaryHdl * pGlosHdl, SwWrtShell *pWrtShell) :
//STRIP001 
//STRIP001 	SvxStandardDialog(&pViewFrame->GetWindow(), SW_RES(DLG_GLOSSARY)),
//STRIP001 	aExampleWIN   (this, SW_RES(WIN_EXAMPLE	)),
//STRIP001     aExampleDummyWIN(this, SW_RES(WIN_EXAMPLE_DUMMY )),
//STRIP001 	aShowExampleCB(this, SW_RES(CB_SHOW_EXAMPLE	)),
//STRIP001 	aInsertTipCB  (this, SW_RES(CB_INSERT_TIP)),
//STRIP001 	aNameLbl	  (this, SW_RES(FT_NAME)),
//STRIP001 	aNameED       (this, SW_RES(ED_NAME)),
//STRIP001 	aShortNameLbl (this, SW_RES(FT_SHORTNAME)),
//STRIP001 	aShortNameEdit(this, SW_RES(ED_SHORTNAME)),
//STRIP001 	aCategoryBox  (this, SW_RES(LB_BIB)),
//STRIP001 	aFileRelCB    (this, SW_RES(CB_FILE_REL)),
//STRIP001 	aNetRelCB     (this, SW_RES(CB_NET_REL)),
//STRIP001     aRelativeFL   (this, SW_RES(FL_RELATIVE)),
//STRIP001 	aInsertBtn	  (this, SW_RES(PB_INSERT)),
//STRIP001 	aEditBtn	  (this, SW_RES(PB_EDIT)),
//STRIP001 	aBibBtn		  (this, SW_RES(PB_BIB)),
//STRIP001 	aPathBtn	  (this, SW_RES(PB_PATH)),
//STRIP001 	aCloseBtn	  (this, SW_RES(PB_CLOSE)),
//STRIP001 	aHelpBtn      (this, SW_RES(PB_HELP)),
//STRIP001 	sReadonlyPath (SW_RES(ST_READONLY_PATH)),
//STRIP001 	pMenu		  (new PopupMenu(SW_RES(MNU_EDIT))),
//STRIP001 	pGlossaryHdl  (pGlosHdl),
//STRIP001 	pSh			  (pWrtShell),
//STRIP001 	pExampleFrame(0),
//STRIP001 	bSelection( pWrtShell->IsSelection() ),
//STRIP001 	bReadOnly( sal_False ),
//STRIP001 	bIsOld( sal_False ),
//STRIP001 	bIsDocReadOnly(sal_False),
//STRIP001 	bResume(sal_False)
//STRIP001 {
//STRIP001 	// #107253# Hold one local SwLinguConfig here. This creates one incarnation
//STRIP001 	// of a SvtLinguConfig which is then used as long as this local incarnation
//STRIP001 	// exists. Other dialogs may be equipped with the same startup-mechanism
//STRIP001 	// when required.
//STRIP001 	SwLinguConfig aLocalLinguConfig;
//STRIP001 
//STRIP001     // Static-Pointer initialisieren
//STRIP001 	if( !pCurrGlosGroup )
//STRIP001 		pCurrGlosGroup = new String;//(SwGlossaries::GetDefName());
//STRIP001 
//STRIP001 	pMenu->SetActivateHdl(LINK(this,SwGlossaryDlg,EnableHdl));
//STRIP001 	pMenu->SetSelectHdl(LINK(this,SwGlossaryDlg,MenuHdl));
//STRIP001 	aEditBtn.SetPopupMenu(pMenu);
//STRIP001 	aEditBtn.SetSelectHdl(LINK(this,SwGlossaryDlg,EditHdl));
//STRIP001 	aPathBtn.SetClickHdl(LINK(this, SwGlossaryDlg, PathHdl));
//STRIP001 
//STRIP001 	aNameED.SetModifyHdl(LINK(this,SwGlossaryDlg,NameModify));
//STRIP001 	aShortNameEdit.SetModifyHdl(LINK(this,SwGlossaryDlg,NameModify));
//STRIP001 
//STRIP001 	aCategoryBox.SetDoubleClickHdl(LINK(this,SwGlossaryDlg, NameDoubleClick));
//STRIP001 	aCategoryBox.SetSelectHdl(LINK(this,SwGlossaryDlg,GrpSelect));
//STRIP001 	aBibBtn.SetClickHdl(LINK(this,SwGlossaryDlg,BibHdl));
//STRIP001 	aShowExampleCB.SetClickHdl(LINK(this, SwGlossaryDlg, ShowPreviewHdl));
//STRIP001 
//STRIP001 	aShortNameEdit.SetMaxTextLen(SHORT_LENGTH);
//STRIP001 	aNameED.SetMaxTextLen(LONG_LENGTH);
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	const OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 
//STRIP001 	aShowExampleCB.Check( pCfg->IsAutoTextPreview());
//STRIP001 	ShowPreviewHdl(&aShowExampleCB);
//STRIP001 
//STRIP001 	bIsDocReadOnly = pSh->GetView().GetDocShell()->IsReadOnly() ||
//STRIP001 					  pSh->HasReadonlySel();
//STRIP001 	if( bIsDocReadOnly )
//STRIP001 		aInsertBtn.Enable(sal_False);
//STRIP001 	aNameED.GrabFocus();
//STRIP001 	aCategoryBox.SetHelpId(HID_MD_GLOS_CATEGORY);
//STRIP001 	aCategoryBox.SetWindowBits(WB_HASBUTTONS|WB_HASBUTTONSATROOT|WB_HSCROLL|WB_VSCROLL|WB_CLIPCHILDREN|WB_SORT);
//STRIP001 	aCategoryBox.GetModel()->SetSortMode(SortAscending);
//STRIP001 	aCategoryBox.SetHighlightRange();	// ueber volle Breite selektieren
//STRIP001 	aCategoryBox.SetNodeDefaultImages( );
//STRIP001 
//STRIP001 	Init();
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwGlossaryDlg::~SwGlossaryDlg()
//STRIP001 {
//STRIP001 	OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 	pCfg->SetAutoTextPreview(aShowExampleCB.IsChecked()) ;
//STRIP001 
//STRIP001 	aCategoryBox.Clear();
//STRIP001 	aEditBtn.SetPopupMenu(0);
//STRIP001 	delete pMenu;
//STRIP001 	delete pExampleFrame;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Auswahl neue Gruppe
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, GrpSelect, SvTreeListBox *, pBox )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = pBox->FirstSelected();
//STRIP001 	if(!pEntry)
//STRIP001 		return 0;
//STRIP001 	SvLBoxEntry* pParent = pBox->GetParent(pEntry) ? pBox->GetParent(pEntry) : pEntry;
//STRIP001 	GroupUserData* pGroupData = (GroupUserData*)pParent->GetUserData();
//STRIP001 	(*pCurrGlosGroup) = pGroupData->sGroupName;
//STRIP001 	(*pCurrGlosGroup) += GLOS_DELIM;
//STRIP001 	(*pCurrGlosGroup) += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 	pGlossaryHdl->SetCurGroup(*pCurrGlosGroup);
//STRIP001 	const sal_uInt16 nCount = pGlossaryHdl->GetGlossaryCnt();
//STRIP001 	// Aktuellen Textbaustein setzen
//STRIP001 	bReadOnly = pGlossaryHdl->IsReadOnly();
//STRIP001 	EnableShortName( !bReadOnly );
//STRIP001 	aEditBtn.Enable(!bReadOnly);
//STRIP001 	bIsOld = pGlossaryHdl->IsOld();
//STRIP001 	if( pParent != pEntry)
//STRIP001 	{
//STRIP001 		String aName(pBox->GetEntryText(pEntry));
//STRIP001 		aNameED.SetText(aName);
//STRIP001 		aShortNameEdit.SetText(*(String*)pEntry->GetUserData());
//STRIP001 		pEntry = pBox->GetParent(pEntry);
//STRIP001 		aInsertBtn.Enable( !bIsDocReadOnly);
//STRIP001 		ShowAutoText(*pCurrGlosGroup, aShortNameEdit.GetText());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		ShowAutoText(aEmptyStr, aEmptyStr);
//STRIP001 	//Controls aktualisieren
//STRIP001 	NameModify(&aShortNameEdit);
//STRIP001     if( SfxRequest::HasMacroRecorder( pSh->GetView().GetViewFrame() ) )
//STRIP001 	{
//STRIP001         SfxRequest aReq( pSh->GetView().GetViewFrame(), FN_SET_ACT_GLOSSARY );
//STRIP001 		String sTemp(*pCurrGlosGroup);
//STRIP001 		// der nullte Pfad wird nicht aufgezeichnet!
//STRIP001         if('0' == sTemp.GetToken(1, GLOS_DELIM).GetChar(0))
//STRIP001 			sTemp = sTemp.GetToken(0, GLOS_DELIM);
//STRIP001 		aReq.AppendItem(SfxStringItem(FN_SET_ACT_GLOSSARY, sTemp));
//STRIP001 		aReq.Done();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryDlg::Apply()
//STRIP001 {
//STRIP001 	const String aGlosName(aShortNameEdit.GetText());
//STRIP001 	if(aGlosName.Len())	pGlossaryHdl->InsertGlossary(aGlosName);
//STRIP001     if( SfxRequest::HasMacroRecorder( pSh->GetView().GetViewFrame() ) )
//STRIP001 	{
//STRIP001         SfxRequest aReq( pSh->GetView().GetViewFrame(), FN_INSERT_GLOSSARY );
//STRIP001 		String sTemp(*pCurrGlosGroup);
//STRIP001 		// der nullte Pfad wird nicht aufgezeichnet!
//STRIP001         if('0' == sTemp.GetToken(1, GLOS_DELIM).GetChar(0))
//STRIP001 			sTemp = sTemp.GetToken(0, GLOS_DELIM);
//STRIP001 		aReq.AppendItem(SfxStringItem(FN_INSERT_GLOSSARY, sTemp));
//STRIP001 		aReq.AppendItem(SfxStringItem(FN_PARAM_1, aGlosName));
//STRIP001 		aReq.Done();
//STRIP001 	}
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 /* inline */ void SwGlossaryDlg::EnableShortName(sal_Bool bOn)
//STRIP001 {
//STRIP001 	aShortNameLbl.Enable(bOn);
//STRIP001 	aShortNameEdit.Enable(bOn);
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------26.11.98 16:15-------------------
//STRIP001  * existiert der Titel in der ausgewaehlten Gruppe?
//STRIP001  * --------------------------------------------------*/
//STRIP001 SvLBoxEntry* SwGlossaryDlg::DoesBlockExist(const String& rBlock,
//STRIP001 				const String& rShort)
//STRIP001 {
//STRIP001 	//evtl. vorhandenen Eintrag in der TreeListBox suchen
//STRIP001 	SvLBoxEntry* pEntry = aCategoryBox.FirstSelected();
//STRIP001     if(pEntry)
//STRIP001     {
//STRIP001         if(aCategoryBox.GetParent(pEntry))
//STRIP001             pEntry = aCategoryBox.GetParent(pEntry);
//STRIP001         sal_uInt32 nChildCount = aCategoryBox.GetChildCount( pEntry );
//STRIP001         for(sal_uInt32 i = 0; i < nChildCount; i++)
//STRIP001         {
//STRIP001             SvLBoxEntry* pChild = aCategoryBox.GetEntry( pEntry, i );
//STRIP001             if(rBlock == aCategoryBox.GetEntryText(pChild) &&
//STRIP001                 (!rShort.Len() || rShort == *(String*)pChild->GetUserData()))
//STRIP001             {
//STRIP001                 return pChild;
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, NameModify, Edit *, pEdit )
//STRIP001 {
//STRIP001 	String aName(aNameED.GetText());
//STRIP001 	sal_Bool bNameED = pEdit == &aNameED;
//STRIP001 	if( !aName.Len() )
//STRIP001 	{
//STRIP001 		if(bNameED)
//STRIP001 			aShortNameEdit.SetText(aName);
//STRIP001 		aInsertBtn.Enable(sal_False);
//STRIP001 		return 0;
//STRIP001 	}
//STRIP001 	String sShortSearch;
//STRIP001 	if(!bNameED)
//STRIP001 		sShortSearch = pEdit->GetText();
//STRIP001 	sal_Bool bNotFound = !DoesBlockExist(aName, sShortSearch);
//STRIP001 	if(bNameED)
//STRIP001 	{
//STRIP001 			// ist der Text durch einen Klick in die Listbox in das
//STRIP001 			// Edit gekommem?
//STRIP001 		if(bNotFound)
//STRIP001 		{
//STRIP001 			sal_uInt16 nSz = aName.Len();
//STRIP001 			sal_uInt16 nStart = 1;
//STRIP001 			while( aName.GetChar( nStart-1 ) == ' ' && nStart < nSz )
//STRIP001 				nStart++;
//STRIP001 			String aBuf( aName.GetChar( nStart-1 ));
//STRIP001 			for( nStart ; nStart < nSz; ++nStart )
//STRIP001 			{
//STRIP001 				if( aName.GetChar( nStart-1 ) == ' ' && aName.GetChar( nStart ) != ' ')
//STRIP001 					aBuf += aName.GetChar( nStart );
//STRIP001 			}
//STRIP001 			aShortNameEdit.SetText(aBuf);
//STRIP001 			EnableShortName();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aShortNameEdit.SetText(pGlossaryHdl->GetGlossaryShortName(aName));
//STRIP001 			EnableShortName(!bReadOnly);
//STRIP001 		}
//STRIP001 		aInsertBtn.Enable(!bNotFound && !bIsDocReadOnly);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//ShortNameEdit
//STRIP001 		if(!bNotFound)
//STRIP001 		{
//STRIP001 			sal_Bool bEnable = !bNotFound;
//STRIP001 			bEnable &= !bIsDocReadOnly;
//STRIP001 			aInsertBtn.Enable(bEnable);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwGlossaryDlg, NameDoubleClick, SvTreeListBox*, pBox )
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = pBox->FirstSelected();
//STRIP001 	if(pBox->GetParent(pEntry) && !bIsDocReadOnly)
//STRIP001 		EndDialog( RET_OK );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwGlossaryDlg, NameDoubleClick, SvTreeListBox*, EMPTYARG )
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, EnableHdl, Menu *, pMn )
//STRIP001 {
//STRIP001 	const String aEditText(aNameED.GetText());
//STRIP001 	const sal_Bool bHasEntry = aEditText.Len() && aShortNameEdit.GetText().Len();
//STRIP001 	const sal_Bool bExists = 0 != DoesBlockExist(aEditText, aShortNameEdit.GetText());
//STRIP001 	pMn->EnableItem(FN_GL_DEFINE, bSelection && bHasEntry && !bExists);
//STRIP001 	pMn->EnableItem(FN_GL_DEFINE_TEXT, bSelection && bHasEntry && !bExists);
//STRIP001 	pMn->EnableItem(FN_GL_COPY_TO_CLIPBOARD, bExists);
//STRIP001 	pMn->EnableItem(FN_GL_REPLACE, bSelection && bExists && !bIsOld );
//STRIP001 	pMn->EnableItem(FN_GL_REPLACE_TEXT, bSelection && bExists && !bIsOld );
//STRIP001 	pMn->EnableItem(FN_GL_EDIT, bExists );
//STRIP001     pMn->EnableItem(FN_GL_RENAME, bExists  );
//STRIP001     pMn->EnableItem(FN_GL_DELETE, bExists  );
//STRIP001 	pMn->EnableItem(FN_GL_MACRO, bExists && !bIsOld  &&
//STRIP001 									!pGlossaryHdl->IsReadOnly() );
//STRIP001 
//STRIP001 	SvLBoxEntry* pEntry = aCategoryBox.FirstSelected();
//STRIP001 	sal_Bool bEnable = sal_False;
//STRIP001 	if ( pEntry )
//STRIP001 		bEnable = !aCategoryBox.GetParent( pEntry ) && !bIsOld && !pGlossaryHdl->IsReadOnly();
//STRIP001 	pMn->EnableItem( FN_GL_IMPORT, bEnable );
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, MenuHdl, Menu *, pMn )
//STRIP001 {
//STRIP001 	sal_Bool bNoAttr = sal_False;
//STRIP001 
//STRIP001 	switch(pMn->GetCurItemId())
//STRIP001 	{
//STRIP001 		case FN_GL_REPLACE:
//STRIP001 		case FN_GL_REPLACE_TEXT:
//STRIP001 			pGlossaryHdl->NewGlossary(	aNameED.GetText(),
//STRIP001 										aShortNameEdit.GetText(),
//STRIP001 										sal_False,
//STRIP001 										pMn->GetCurItemId() == FN_GL_REPLACE_TEXT);
//STRIP001 		break;
//STRIP001 		case FN_GL_DEFINE_TEXT:
//STRIP001 			bNoAttr = sal_True;
//STRIP001 			// Kein break!!!
//STRIP001 		case FN_GL_DEFINE:
//STRIP001 		{
//STRIP001 			const String aStr(aNameED.GetText());
//STRIP001 			const String aShortName(aShortNameEdit.GetText());
//STRIP001 			if(pGlossaryHdl->HasShortName(aShortName))
//STRIP001 			{
//STRIP001 				InfoBox(this, SW_RES(MSG_DOUBLE_SHORTNAME)).Execute();
//STRIP001 				aShortNameEdit.SetSelection(Selection(0, SELECTION_MAX));
//STRIP001 				aShortNameEdit.GrabFocus();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			if(pGlossaryHdl->NewGlossary(aStr, aShortName, sal_False, bNoAttr ))
//STRIP001 			{
//STRIP001 				SvLBoxEntry* pEntry = aCategoryBox.FirstSelected();
//STRIP001 				if(aCategoryBox.GetParent(pEntry))
//STRIP001 					pEntry = aCategoryBox.GetParent(pEntry);
//STRIP001 
//STRIP001 				SvLBoxEntry* pChild = aCategoryBox.InsertEntry(aStr, pEntry);
//STRIP001 				pChild->SetUserData(new String(aShortName));
//STRIP001 				aNameED.SetText(aStr);
//STRIP001 				aShortNameEdit.SetText(aShortName);
//STRIP001 				NameModify(&aNameED);		// fuer Schalten der Buttons
//STRIP001 
//STRIP001                 if( SfxRequest::HasMacroRecorder( pSh->GetView().GetViewFrame() ) )
//STRIP001 				{
//STRIP001                     SfxRequest aReq(pSh->GetView().GetViewFrame(), FN_NEW_GLOSSARY);
//STRIP001 					String sTemp(*pCurrGlosGroup);
//STRIP001 					// der nullte Pfad wird nicht aufgezeichnet!
//STRIP001                     if('0' == sTemp.GetToken(1, GLOS_DELIM).GetChar(0))
//STRIP001 						sTemp = sTemp.GetToken(0, GLOS_DELIM);
//STRIP001 					aReq.AppendItem(SfxStringItem(FN_NEW_GLOSSARY, sTemp));
//STRIP001 					aReq.AppendItem(SfxStringItem(FN_PARAM_1, aShortName));
//STRIP001 					aReq.AppendItem(SfxStringItem(FN_PARAM_2, aStr));
//STRIP001 					aReq.Done();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_GL_COPY_TO_CLIPBOARD :
//STRIP001 		{
//STRIP001 			pGlossaryHdl->CopyToClipboard(*pSh, aShortNameEdit.GetText());
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_GL_EDIT:
//STRIP001 		break;
//STRIP001 		case FN_GL_RENAME:
//STRIP001 		{
//STRIP001 			aShortNameEdit.SetText(pGlossaryHdl->GetGlossaryShortName(aNameED.GetText()));
//STRIP001 			SwNewGlosNameDlg* pNewNameDlg = new SwNewGlosNameDlg(this, aNameED.GetText(),
//STRIP001 											aShortNameEdit.GetText() );
//STRIP001 			if( RET_OK == pNewNameDlg->Execute() &&
//STRIP001 				pGlossaryHdl->Rename( aShortNameEdit.GetText(),
//STRIP001 										pNewNameDlg->GetNewShort(),
//STRIP001 										pNewNameDlg->GetNewName()))
//STRIP001 			{
//STRIP001 				SvLBoxEntry* pEntry = aCategoryBox.FirstSelected();
//STRIP001 				SvLBoxEntry* pNewEntry = aCategoryBox.InsertEntry(
//STRIP001 						pNewNameDlg->GetNewName(), aCategoryBox.GetParent(pEntry));
//STRIP001 				pNewEntry->SetUserData(new String(pNewNameDlg->GetNewShort()));
//STRIP001 				delete (String*)pEntry->GetUserData();
//STRIP001 				aCategoryBox.GetModel()->Remove(pEntry);
//STRIP001 				aCategoryBox.Select(pNewEntry);
//STRIP001 				aCategoryBox.MakeVisible(pNewEntry);
//STRIP001 			}
//STRIP001 			GrpSelect( &aCategoryBox );
//STRIP001 			delete pNewNameDlg;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_GL_DELETE:
//STRIP001 		{
//STRIP001 			QueryBox aQuery(this, SW_RES(MSG_QUERY_DELETE));
//STRIP001 			if(RET_YES == aQuery.Execute())
//STRIP001 			{
//STRIP001 				const String aShortName(aShortNameEdit.GetText());
//STRIP001 				const String aTitle(aNameED.GetText());
//STRIP001 				if(aTitle.Len() && pGlossaryHdl->DelGlossary(aShortName))
//STRIP001 				{
//STRIP001 					SvLBoxEntry* pChild = DoesBlockExist(aTitle, aShortName);
//STRIP001 					DBG_ASSERT(pChild, "Eintrag nicht gefunden!")
//STRIP001 					SvLBoxEntry* pParent = aCategoryBox.GetParent(pChild);
//STRIP001 					aCategoryBox.Select(pParent);
//STRIP001 
//STRIP001 					aCategoryBox.GetModel()->Remove(pChild);
//STRIP001 					aNameED.SetText( aEmptyStr );
//STRIP001 					NameModify(&aNameED);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case FN_GL_MACRO:
//STRIP001 		{
//STRIP001 			SfxItemSet aSet( pSh->GetAttrPool(), RES_FRMMACRO, RES_FRMMACRO );
//STRIP001 
//STRIP001 			SvxMacro aStart(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 			SvxMacro aEnd(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 			pGlossaryHdl->GetMacros(aShortNameEdit.GetText(), aStart, aEnd );
//STRIP001 
//STRIP001 			SvxMacroItem aItem;
//STRIP001 			if( aStart.GetMacName().Len() )
//STRIP001 				aItem.SetMacro( SW_EVENT_START_INS_GLOSSARY, aStart );
//STRIP001 			if( aEnd.GetMacName().Len() )
//STRIP001 				aItem.SetMacro( SW_EVENT_END_INS_GLOSSARY, aEnd );
//STRIP001 
//STRIP001 			aSet.Put( aItem );
//STRIP001 
//STRIP001 			const SfxPoolItem* pItem;
//STRIP001 			SwMacroAssignDlg aMacDlg( this, aSet, MACASSGN_TEXTBAUST );
//STRIP001 			if( RET_OK == aMacDlg.Execute() &&
//STRIP001 				SFX_ITEM_SET == aMacDlg.GetOutputItemSet()->GetItemState(
//STRIP001 					RES_FRMMACRO, sal_False, &pItem ))
//STRIP001 			{
//STRIP001 				const SvxMacroTableDtor& rTbl = ((SvxMacroItem*)pItem)->GetMacroTable();
//STRIP001 
//STRIP001 				pGlossaryHdl->SetMacros( aShortNameEdit.GetText(),
//STRIP001 											rTbl.Get( SW_EVENT_START_INS_GLOSSARY ),
//STRIP001 											rTbl.Get( SW_EVENT_END_INS_GLOSSARY ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case FN_GL_IMPORT:
//STRIP001 		{
//STRIP001 			// call the FileOpenDialog do find WinWord - Files with templates
//STRIP001             FileDialogHelper aDlgHelper( TemplateDescription::FILEOPEN_SIMPLE, 0 );
//STRIP001             Reference < XFilePicker > xFP = aDlgHelper.GetFilePicker();
//STRIP001 
//STRIP001 			SvtPathOptions aPathOpt;
//STRIP001             xFP->setDisplayDirectory(aPathOpt.GetWorkPath() );
//STRIP001 			String sWW8( C2S(FILTER_WW8) );
//STRIP001 
//STRIP001 			sal_uInt16 i = 0;
//STRIP001 
//STRIP001 			const SfxFactoryFilterContainer* pFltCnt =
//STRIP001 					SwDocShell::Factory().GetFilterContainer();
//STRIP001 			if( pFltCnt )
//STRIP001 			{
//STRIP001                 Reference<XFilterManager> xFltMgr(xFP, UNO_QUERY);
//STRIP001 
//STRIP001                 const SfxFilter* pFilter;
//STRIP001 				sal_uInt16 nCount = pFltCnt->GetFilterCount();
//STRIP001 				for( i = 0; i < nCount; ++i )
//STRIP001 					if( ( pFilter = pFltCnt->GetFilter( i ))
//STRIP001 						/*->IsAllowedAsTemplate()
//STRIP001 						&& pFilter*/->GetUserData() == sWW8 )
//STRIP001 					{
//STRIP001                         xFltMgr->appendFilter( pFilter->GetUIName(),
//STRIP001                                     ((WildCard&)pFilter->GetWildcard()).GetWildCard() );
//STRIP001                         xFltMgr->setCurrentFilter( pFilter->GetUIName() ) ;
//STRIP001                     }
//STRIP001 			}
//STRIP001 
//STRIP001             if( i && aDlgHelper.Execute() == ERRCODE_NONE )
//STRIP001 			{
//STRIP001                 if( pGlossaryHdl->ImportGlossaries( xFP->getFiles().getConstArray()[0] ))
//STRIP001 					Init();
//STRIP001 				else
//STRIP001 				{
//STRIP001 					InfoBox(this, SW_RES( MSG_NO_GLOSSARIES )).Execute();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	   	break;
//STRIP001 
//STRIP001 		default:
//STRIP001 			return 0;
//STRIP001 	}
//STRIP001 	return 1;
//STRIP001 }
//STRIP001 /*--------------------------------------------------------------------
//STRIP001 	 Beschreibung:	Dialog Verwaltung Bereiche
//STRIP001  --------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, BibHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	SwGlossaries* pGloss = ::GetGlossaries();
//STRIP001 	if( pGloss->IsGlosPathErr() )
//STRIP001 		pGloss->ShowError();
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//check if at least one glossary path is write enabled
//STRIP001 		SvtPathOptions aPathOpt;
//STRIP001 		String sGlosPath( aPathOpt.GetAutoTextPath() );
//STRIP001 		USHORT nPaths = sGlosPath.GetTokenCount(';');
//STRIP001 		BOOL bIsWritable = FALSE;
//STRIP001 		for(USHORT nPath = 0; nPath < nPaths; nPath++)
//STRIP001 		{
//STRIP001 			String sPath = so3::StaticBaseUrl::SmartRelToAbs(sGlosPath.GetToken(nPath, ';'));
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Content aTestContent( sPath,
//STRIP001 							uno::Reference< XCommandEnvironment >());
//STRIP001 				Any aAny = aTestContent.getPropertyValue( C2U("IsReadOnly") );
//STRIP001 				if(aAny.hasValue())
//STRIP001 				{
//STRIP001 					bIsWritable = !*(sal_Bool*)aAny.getValue();
//STRIP001 				}
//STRIP001 			}
//STRIP001             catch(Exception&)
//STRIP001 			{}
//STRIP001 			if(bIsWritable)
//STRIP001 				break;
//STRIP001 		}
//STRIP001 		if(bIsWritable)
//STRIP001 		{
//STRIP001 
//STRIP001 			SwGlossaryGroupDlg *pDlg = new SwGlossaryGroupDlg( this, pGloss->GetPathArray(), pGlossaryHdl );
//STRIP001 			if ( RET_OK == pDlg->Execute() )
//STRIP001 			{
//STRIP001 				Init();
//STRIP001 				//if new groups were created - select one of them
//STRIP001 				String sNewGroup = pDlg->GetCreatedGroupName();
//STRIP001 				SvLBoxEntry* pEntry = aCategoryBox.First();
//STRIP001 				while(sNewGroup.Len() && pEntry)
//STRIP001 				{
//STRIP001 					if(!aCategoryBox.GetParent(pEntry))
//STRIP001 					{
//STRIP001 						GroupUserData* pGroupData = (GroupUserData*)pEntry->GetUserData();
//STRIP001 						String sGroup = pGroupData->sGroupName;
//STRIP001 						sGroup += GLOS_DELIM;
//STRIP001 						sGroup += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 						if(sGroup == sNewGroup)
//STRIP001 						{
//STRIP001 							aCategoryBox.Select(pEntry);
//STRIP001 							aCategoryBox.MakeVisible(pEntry);
//STRIP001 							GrpSelect(&aCategoryBox);
//STRIP001 							break;
//STRIP001 						}
//STRIP001 					}
//STRIP001 					pEntry = aCategoryBox.Next(pEntry);
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 			delete pDlg;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			QueryBox aBox(this, WB_YES_NO, sReadonlyPath);
//STRIP001 			if(RET_YES == aBox.Execute())
//STRIP001 				PathHdl(&aPathBtn);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Initialisierung; aus Ctor und nach Bearbeiten Bereiche
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryDlg::Init()
//STRIP001 {
//STRIP001 	aCategoryBox.SetUpdateMode( sal_False );
//STRIP001 	aCategoryBox.Clear();
//STRIP001 	// Textbausteinbereiche anzeigen
//STRIP001 	const sal_uInt16 nCnt = pGlossaryHdl->GetGroupCnt();
//STRIP001 	SvLBoxEntry* pSelEntry = 0;
//STRIP001 	const String sSelStr(pCurrGlosGroup->GetToken(0, GLOS_DELIM));
//STRIP001 	const sal_uInt16 nSelPath = pCurrGlosGroup->GetToken(1, GLOS_DELIM).ToInt32();
//STRIP001 	for(sal_uInt16 nId = 0; nId < nCnt; ++nId )
//STRIP001 	{
//STRIP001 		String sTitle;
//STRIP001 		String sGroupName(pGlossaryHdl->GetGroupName(nId, &sTitle));
//STRIP001         if(!sGroupName.Len())
//STRIP001             continue;
//STRIP001 		if(!sTitle.Len())
//STRIP001 			sTitle = sGroupName.GetToken( 0, GLOS_DELIM );
//STRIP001 		SvLBoxEntry* pEntry = aCategoryBox.InsertEntry( sTitle );
//STRIP001 		sal_uInt16 nPath = sGroupName.GetToken( 1, GLOS_DELIM ).ToInt32();
//STRIP001 
//STRIP001 		GroupUserData* pData = new GroupUserData;
//STRIP001 		pData->sGroupName = sGroupName.GetToken(0, GLOS_DELIM);
//STRIP001 		pData->nPathIdx = nPath;
//STRIP001 		pData->bReadonly = pGlossaryHdl->IsReadOnly(&sGroupName);
//STRIP001 
//STRIP001 		pEntry->SetUserData(pData);
//STRIP001 		if(sSelStr == pData->sGroupName && nSelPath == nPath)
//STRIP001 			pSelEntry = pEntry;
//STRIP001 
//STRIP001 		//Eintraege fuer die Gruppen auffuellen
//STRIP001 		{
//STRIP001 			pGlossaryHdl->SetCurGroup(sGroupName, sal_False, sal_True);
//STRIP001 			const sal_uInt16 nCount = pGlossaryHdl->GetGlossaryCnt();
//STRIP001 			for(sal_uInt16 i = 0; i < nCount; ++i)
//STRIP001 			{
//STRIP001 				String sTitle(pGlossaryHdl->GetGlossaryName(i));
//STRIP001 				SvLBoxEntry* pChild = aCategoryBox.InsertEntry(
//STRIP001 									sTitle, pEntry);
//STRIP001 				pChild->SetUserData(new String(pGlossaryHdl->GetGlossaryShortName(i)));
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 		// Aktuelle Gruppe setzen und Textbausteine anzeigen
//STRIP001 	if(!pSelEntry)
//STRIP001 	{
//STRIP001 		//find a non-readonly group
//STRIP001 		SvLBoxEntry* pSearch = aCategoryBox.First();
//STRIP001 		while(pSearch)
//STRIP001 		{
//STRIP001 			if(!aCategoryBox.GetParent(pSearch))
//STRIP001 			{
//STRIP001 				GroupUserData* pData = (GroupUserData*)pSearch->GetUserData();
//STRIP001 				if(!pData->bReadonly)
//STRIP001 				{
//STRIP001 					pSelEntry = pSearch;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			pSearch = aCategoryBox.Next(pSearch);
//STRIP001 		}
//STRIP001 		if(!pSelEntry)
//STRIP001 			pSelEntry = aCategoryBox.GetEntry(0);
//STRIP001 	}
//STRIP001 	if(pSelEntry)
//STRIP001 	{
//STRIP001 		aCategoryBox.Expand(pSelEntry);
//STRIP001 		aCategoryBox.Select(pSelEntry);
//STRIP001 		aCategoryBox.MakeVisible(pSelEntry);
//STRIP001 		GrpSelect(&aCategoryBox);
//STRIP001 	}
//STRIP001 	//JP 16.11.99: the SvxTreeListBox has a Bug. The Box dont recalc the
//STRIP001 	//		outputsize, when all entries are insertet. The result is, that
//STRIP001 	//		the Focus/Highlight rectangle is to large and paintet over the
//STRIP001 	//		HScrollbar. -> Fix: call the resize
//STRIP001 	aCategoryBox.Resize();
//STRIP001 
//STRIP001 	aCategoryBox.GetModel()->Resort();
//STRIP001 	aCategoryBox.SetUpdateMode( sal_True );
//STRIP001 	aCategoryBox.Update();
//STRIP001 
//STRIP001 	const OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 	aFileRelCB.Check( pCfg->IsSaveRelFile() );
//STRIP001 	aFileRelCB.SetClickHdl(LINK(this, SwGlossaryDlg, CheckBoxHdl));
//STRIP001 	aNetRelCB.Check( pCfg->IsSaveRelNet() );
//STRIP001 	aNetRelCB.SetClickHdl(LINK(this, SwGlossaryDlg, CheckBoxHdl));
//STRIP001 	aInsertTipCB.Check( pCfg->IsAutoTextTip() );
//STRIP001 	aInsertTipCB.SetClickHdl(LINK(this, SwGlossaryDlg, CheckBoxHdl));
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 IMPL_LINK_INLINE_START( SwGlossaryDlg, EditHdl, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 //EndDialog darf nicht im MenuHdl aufgerufen werden
//STRIP001 	if(aEditBtn.GetCurItemId() == FN_GL_EDIT )
//STRIP001 	{
//STRIP001 		SwTextBlocks *pGroup = ::GetGlossaries()->GetGroupDoc (  GetCurrGrpName () );
//STRIP001 		BOOL bRet = pGlossaryHdl->ConvertToNew ( *pGroup );
//STRIP001 		delete pGroup;
//STRIP001 		if ( bRet )
//STRIP001 			EndDialog(RET_EDIT);
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwGlossaryDlg, EditHdl, Button *, EMPTYARG )
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	KeyInput fuer ShortName - Edits ohne Spaces
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwNewGlosNameDlg, Modify, Edit *, pBox )
//STRIP001 {
//STRIP001 	String aName(aNewName.GetText());
//STRIP001 	SwGlossaryDlg* pDlg = (SwGlossaryDlg*)GetParent();
//STRIP001 
//STRIP001 	if( pBox == &aNewName )
//STRIP001 	{
//STRIP001 		if( aName.Len() )
//STRIP001 			aNewShort.SetText( pDlg->pGlossaryHdl->GetValidShortCut( aName ));
//STRIP001 		else
//STRIP001 			aNewShort.SetText(aName);
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_Bool bEnable = aName.Len() && aNewShort.GetText().Len() &&
//STRIP001 		(!pDlg->DoesBlockExist(aName, aNewShort.GetText())
//STRIP001 			|| aName == aOldName.GetText());
//STRIP001 	aOk.Enable(bEnable);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwNewGlosNameDlg, Rename, Button *, EMPTYARG )
//STRIP001 {
//STRIP001 	SwGlossaryDlg* pDlg = (SwGlossaryDlg*)GetParent();
//STRIP001 	String sNew = aNewShort.GetText();
//STRIP001 	GetAppCharClass().toUpper(sNew);
//STRIP001 	if( pDlg->pGlossaryHdl->HasShortName(aNewShort.GetText())
//STRIP001 		&& sNew != aOldShort.GetText() )
//STRIP001 	{
//STRIP001 		InfoBox(this, SW_RES(MSG_DOUBLE_SHORTNAME)).Execute();
//STRIP001 		aNewShort.GrabFocus();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		EndDialog(sal_True);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 IMPL_LINK( SwGlossaryDlg, CheckBoxHdl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 	sal_Bool bCheck = pBox->IsChecked();
//STRIP001 	if( pBox == &aInsertTipCB )
//STRIP001 		pCfg->SetAutoTextTip(bCheck);
//STRIP001 	else if(pBox == &aFileRelCB)
//STRIP001 		pCfg->SetSaveRelFile(bCheck);
//STRIP001 	else
//STRIP001 		pCfg->SetSaveRelNet(bCheck);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------26.11.98 15:18-------------------
//STRIP001  * TreeListBox fuer Gruppen und Bausteine
//STRIP001  * --------------------------------------------------*/
//STRIP001 SwGlTreeListBox::SwGlTreeListBox(Window* pParent, const ResId& rResId) :
//STRIP001 	SvTreeListBox(pParent, rResId),
//STRIP001 	sReadonly	  (SW_RES(ST_READONLY)),
//STRIP001 	pDragEntry(0)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	SetDragDropMode( SV_DRAGDROP_CTRL_MOVE|SV_DRAGDROP_CTRL_COPY );
//STRIP001 }
//STRIP001 /* -----------------30.11.98 10:49-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 void SwGlTreeListBox::Clear()
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = First();
//STRIP001 	while(pEntry)
//STRIP001 	{
//STRIP001 		if(GetParent(pEntry))
//STRIP001 			delete (String*)pEntry->GetUserData();
//STRIP001 		else
//STRIP001 			delete (GroupUserData*)pEntry->GetUserData();
//STRIP001 		pEntry = Next(pEntry);
//STRIP001 	}
//STRIP001 	SvTreeListBox::Clear();
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------10.06.97 14.52-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 void SwGlTreeListBox::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 	Point aPos( ScreenToOutputPixel( rHEvt.GetMousePosPixel() ));
//STRIP001 	SvLBoxEntry* pEntry = GetEntry( aPos );
//STRIP001 	// Hilfe gibt es nur fuer die Gruppennamen
//STRIP001 	if(pEntry)
//STRIP001 	{
//STRIP001 		SvLBoxTab* pTab;
//STRIP001 		SvLBoxItem* pItem = GetItem( pEntry, aPos.X(), &pTab );
//STRIP001 		if(pItem)
//STRIP001 		{
//STRIP001 			aPos = SvTreeListBox::GetEntryPos( pEntry );
//STRIP001 		 	Size aSize(pItem->GetSize( this, pEntry ));
//STRIP001 			aPos.X() = GetTabPos( pEntry, pTab );
//STRIP001 
//STRIP001 			if((aPos.X() + aSize.Width()) > GetSizePixel().Width())
//STRIP001 				aSize.Width() = GetSizePixel().Width() - aPos.X();
//STRIP001 			aPos = OutputToScreenPixel(aPos);
//STRIP001 		 	Rectangle aItemRect( aPos, aSize );
//STRIP001 			String sMsg;
//STRIP001 			if(!GetParent(pEntry))
//STRIP001 			{
//STRIP001 				GroupUserData* pData = (GroupUserData*)pEntry->GetUserData();
//STRIP001 				const SvStrings* pPathArr = ::GetGlossaries()->GetPathArray();
//STRIP001 				if(pPathArr->Count())
//STRIP001 				{
//STRIP001 					sMsg = (*(*pPathArr)[pData->nPathIdx]);
//STRIP001 					sMsg += INET_PATH_TOKEN;
//STRIP001 					sMsg += pData->sGroupName;
//STRIP001 					sMsg += SwGlossaries::GetExtension();
//STRIP001 					INetURLObject aTmp(sMsg);
//STRIP001 					sMsg = aTmp.GetPath();
//STRIP001 
//STRIP001 					if(pData->bReadonly)
//STRIP001 					{
//STRIP001 						sMsg += ' ';
//STRIP001 						sMsg += '(';
//STRIP001 						sMsg += sReadonly;
//STRIP001 						sMsg += ')';
//STRIP001 					}
//STRIP001 
//STRIP001 
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 				sMsg = *(String*)pEntry->GetUserData();
//STRIP001 			Help::ShowQuickHelp( this, aItemRect, sMsg,
//STRIP001 						QUICKHELP_LEFT|QUICKHELP_VCENTER );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------26.11.98 14:42-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 DragDropMode SwGlTreeListBox::NotifyStartDrag(
//STRIP001 					TransferDataContainer& rContainer,
//STRIP001 					SvLBoxEntry* pEntry )
//STRIP001 {
//STRIP001 	DragDropMode  eRet;
//STRIP001 	pDragEntry = pEntry;
//STRIP001 	String sEntry;
//STRIP001 	if(!GetParent(pEntry))
//STRIP001 		eRet = SV_DRAGDROP_NONE;
//STRIP001 	else
//STRIP001 	{
//STRIP001 		SwGlossaryDlg* pDlg = (SwGlossaryDlg*)Window::GetParent();
//STRIP001 		SvLBoxEntry* pParent = GetParent(pEntry);
//STRIP001 
//STRIP001 		GroupUserData* pGroupData = (GroupUserData*)pParent->GetUserData();
//STRIP001 		String sEntry(pGroupData->sGroupName);
//STRIP001 		sEntry += GLOS_DELIM;
//STRIP001 		sEntry += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 		sal_Int8 nDragOptions = DND_ACTION_COPY;
//STRIP001 		eRet = SV_DRAGDROP_CTRL_COPY;
//STRIP001 		if(!pDlg->pGlossaryHdl->IsReadOnly(&sEntry))
//STRIP001 		{
//STRIP001 			eRet |= SV_DRAGDROP_CTRL_MOVE;
//STRIP001 			nDragOptions |= DND_ACTION_MOVE;
//STRIP001 		}
//STRIP001 		SetDragOptions( nDragOptions );
//STRIP001 	}
//STRIP001 	return eRet;
//STRIP001 }
//STRIP001 /* -----------------27.11.98 09:35-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 sal_Bool    SwGlTreeListBox::NotifyAcceptDrop( SvLBoxEntry* pEntry)
//STRIP001 {
//STRIP001 	// TODO: Readonly - Ueberpruefung fehlt noch!
//STRIP001 	SvLBoxEntry* pSrcParent = GetParent(pEntry) ? GetParent(pEntry) : pEntry;
//STRIP001 	SvLBoxEntry* pDestParent =
//STRIP001 		GetParent(pDragEntry ) ? GetParent(pDragEntry ) : pDragEntry ;
//STRIP001 	return pDestParent != pSrcParent;
//STRIP001 
//STRIP001 }
//STRIP001 /* -----------------26.11.98 14:42-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 sal_Bool  SwGlTreeListBox::NotifyMoving(   SvLBoxEntry*  pTarget,
//STRIP001 									SvLBoxEntry*  pEntry,
//STRIP001 									SvLBoxEntry*& rpNewParent,
//STRIP001 									sal_uInt32&        rNewChildPos
//STRIP001 								)
//STRIP001 {
//STRIP001 	pDragEntry = 0;
//STRIP001 	if(!pTarget) //An den Anfang verschieben
//STRIP001 	{
//STRIP001 		pTarget = GetEntry(0);
//STRIP001 	}
//STRIP001 	// 1. wird in verschiedene Gruppen verschoben?
//STRIP001 	// 2. darf in beiden Gruppen geschrieben werden?
//STRIP001 	SvLBoxEntry* pSrcParent = GetParent(pEntry);
//STRIP001 	SvLBoxEntry* pDestParent =
//STRIP001 		GetParent(pTarget) ? GetParent(pTarget) : pTarget;
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if(pDestParent != pSrcParent)
//STRIP001 	{
//STRIP001 		SwGlossaryDlg* pDlg = (SwGlossaryDlg*)Window::GetParent();
//STRIP001 		SwWait aWait( *pDlg->pSh->GetView().GetDocShell(), sal_True );
//STRIP001 
//STRIP001 		GroupUserData* pGroupData = (GroupUserData*)pSrcParent->GetUserData();
//STRIP001 		String sSourceGroup(pGroupData->sGroupName);
//STRIP001 		sSourceGroup += GLOS_DELIM;
//STRIP001 		sSourceGroup += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 		pDlg->pGlossaryHdl->SetCurGroup(sSourceGroup);
//STRIP001 		String sTitle(GetEntryText(pEntry));
//STRIP001 		String sShortName(*(String*)pEntry->GetUserData());
//STRIP001 
//STRIP001 		GroupUserData* pDestData = (GroupUserData*)pDestParent->GetUserData();
//STRIP001 		String sDestName = pDestData->sGroupName;
//STRIP001 		sDestName += GLOS_DELIM;
//STRIP001 		sDestName += String::CreateFromInt32(pDestData->nPathIdx);
//STRIP001 		bRet = pDlg->pGlossaryHdl->CopyOrMove( sSourceGroup,  sShortName,
//STRIP001 						sDestName, sTitle, sal_True );
//STRIP001 		if(bRet)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pChild = InsertEntry(sTitle, pDestParent);
//STRIP001 			pChild->SetUserData(new String(sShortName));
//STRIP001 			GetModel()->Remove(pEntry);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False; //sonst wird der Eintrag automatisch vorgenommen
//STRIP001 }
//STRIP001 /* -----------------26.11.98 14:42-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 sal_Bool  SwGlTreeListBox::NotifyCopying(   SvLBoxEntry*  pTarget,
//STRIP001 									SvLBoxEntry*  pEntry,
//STRIP001 									SvLBoxEntry*& rpNewParent,
//STRIP001 									sal_uInt32&        rNewChildPos
//STRIP001 								)
//STRIP001 {
//STRIP001 	pDragEntry = 0;
//STRIP001 	// 1. wird in verschiedene Gruppen verschoben?
//STRIP001 	// 2. darf in beiden Gruppen geschrieben werden?
//STRIP001 	if(!pTarget) //An den Anfang verschieben
//STRIP001 	{
//STRIP001 		pTarget = GetEntry(0);
//STRIP001 	}
//STRIP001 	SvLBoxEntry* pSrcParent = GetParent(pEntry);
//STRIP001 	SvLBoxEntry* pDestParent =
//STRIP001 		GetParent(pTarget) ? GetParent(pTarget) : pTarget;
//STRIP001 	sal_Bool bRet = sal_False;
//STRIP001 	if(pDestParent != pSrcParent)
//STRIP001 	{
//STRIP001 		SwGlossaryDlg* pDlg = (SwGlossaryDlg*)Window::GetParent();
//STRIP001 		SwWait aWait( *pDlg->pSh->GetView().GetDocShell(), sal_True );
//STRIP001 
//STRIP001 		GroupUserData* pGroupData = (GroupUserData*)pSrcParent->GetUserData();
//STRIP001 		String sSourceGroup(pGroupData->sGroupName);
//STRIP001 		sSourceGroup += GLOS_DELIM;
//STRIP001 		sSourceGroup += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 
//STRIP001 		pDlg->pGlossaryHdl->SetCurGroup(sSourceGroup);
//STRIP001 		String sTitle(GetEntryText(pEntry));
//STRIP001 		String sShortName(*(String*)pEntry->GetUserData());
//STRIP001 
//STRIP001 		GroupUserData* pDestData = (GroupUserData*)pDestParent->GetUserData();
//STRIP001 		String sDestName = pDestData->sGroupName;
//STRIP001 		sDestName += GLOS_DELIM;
//STRIP001 		sDestName += String::CreateFromInt32(pDestData->nPathIdx);
//STRIP001 
//STRIP001 		bRet = pDlg->pGlossaryHdl->CopyOrMove( sSourceGroup,  sShortName,
//STRIP001 						sDestName, sTitle, sal_False );
//STRIP001 		if(bRet)
//STRIP001 		{
//STRIP001 			SvLBoxEntry* pChild = InsertEntry(sTitle, pDestParent);
//STRIP001 			pChild->SetUserData(new String(sShortName));
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False; //sonst wird der Eintrag automatisch vorgenommen
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*-----------------10.06.97 15.18-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 String SwGlossaryDlg::GetCurrGrpName() const
//STRIP001 {
//STRIP001 	SvLBoxEntry* pEntry = aCategoryBox.FirstSelected();
//STRIP001 	String sRet;
//STRIP001 	if(pEntry)
//STRIP001 	{
//STRIP001 		pEntry =
//STRIP001 			aCategoryBox.GetParent(pEntry) ? aCategoryBox.GetParent(pEntry) : pEntry;
//STRIP001 		GroupUserData* pGroupData = (GroupUserData*)pEntry->GetUserData();
//STRIP001 		sRet = pGroupData->sGroupName;
//STRIP001 		sRet += GLOS_DELIM;
//STRIP001 		sRet += String::CreateFromInt32(pGroupData->nPathIdx);
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------11.06.97 08.17-------------------
//STRIP001 
//STRIP001 --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwGlossaryDlg, PathHdl, Button *, pBtn )
//STRIP001 {
//STRIP001 	SvxMultiPathDialog* pDlg = new SvxMultiPathDialog(pBtn);
//STRIP001 	SvtPathOptions aPathOpt;
//STRIP001 	String sGlosPath( aPathOpt.GetAutoTextPath() );
//STRIP001 	pDlg->SetPath(sGlosPath);
//STRIP001 	if(RET_OK == pDlg->Execute())
//STRIP001 	{
//STRIP001 		String sTmp(pDlg->GetPath());
//STRIP001 		if(sTmp != sGlosPath)
//STRIP001 		{
//STRIP001 			aPathOpt.SetAutoTextPath( sTmp );
//STRIP001 			::GetGlossaries()->UpdateGlosPath( sal_True );
//STRIP001 			Init();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	delete pDlg;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 /* -----------------28.07.99 13:48-------------------
//STRIP001 
//STRIP001  --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwGlossaryDlg, ShowPreviewHdl, CheckBox *, pBox )
//STRIP001 {
//STRIP001 	sal_Bool bCreated = sal_False;
//STRIP001 	if(pBox->IsChecked())
//STRIP001 	{
//STRIP001 		//create example
//STRIP001 		if(!pExampleFrame)
//STRIP001 		{
//STRIP001 			Link aLink(LINK(this, SwGlossaryDlg, PreviewLoadedHdl));
//STRIP001 			pExampleFrame = new SwOneExampleFrame( aExampleWIN,
//STRIP001 							EX_SHOW_ONLINE_LAYOUT, &aLink );
//STRIP001 			bCreated = sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     BOOL bShow = pBox->IsChecked() && !bCreated;
//STRIP001     aExampleWIN.Show( bShow );
//STRIP001     aExampleDummyWIN.Show(!bShow);
//STRIP001 	if( pCurrGlosGroup )
//STRIP001 		ShowAutoText(*pCurrGlosGroup, aShortNameEdit.GetText());
//STRIP001 
//STRIP001 	return 0;
//STRIP001 };
//STRIP001 /* -----------------18.11.99 17:09-------------------
//STRIP001 
//STRIP001  --------------------------------------------------*/
//STRIP001 IMPL_LINK( SwGlossaryDlg, PreviewLoadedHdl,  void *, EMPTYARG )
//STRIP001 {
//STRIP001     BOOL bShow = aShowExampleCB.IsChecked();
//STRIP001     aExampleWIN.Show( bShow );
//STRIP001     aExampleDummyWIN.Show(!bShow);
//STRIP001     ResumeShowAutoText();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------28.07.99 16:28-------------------
//STRIP001 
//STRIP001  --------------------------------------------------*/
//STRIP001 void SwGlossaryDlg::ShowAutoText(const String& rGroup, const String& rShortName)
//STRIP001 {
//STRIP001 	if(aExampleWIN.IsVisible())
//STRIP001 	{
//STRIP001 		SetResumeData(rGroup, rShortName);
//STRIP001 		//try to make an Undo()
//STRIP001 		pExampleFrame->ClearDocument( TRUE );
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------21.12.00 11:33--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void	SwGlossaryDlg::ResumeShowAutoText()
//STRIP001 {
//STRIP001 	String sGroup, sShortName;
//STRIP001 	if(GetResumeData(sGroup, sShortName) && aExampleWIN.IsVisible())
//STRIP001 	{
//STRIP001 		if(!_xAutoText.is())
//STRIP001 		{
//STRIP001 			uno::Reference< lang::XMultiServiceFactory >
//STRIP001 									xMgr = ::legacy_binfilters::getLegacyProcessServiceFactory();
//STRIP001 			//now the AutoText ListBoxes have to be filled
//STRIP001 
//STRIP001             uno::Reference< uno::XInterface >  xAText = xMgr->createInstance( C2U("com.sun.star.text.AutoTextContainer") );
//STRIP001 			_xAutoText = uno::Reference< container::XNameAccess >(xAText, uno::UNO_QUERY);
//STRIP001 		}
//STRIP001 
//STRIP001 		uno::Reference< XTextCursor > & xCrsr = pExampleFrame->GetTextCursor();
//STRIP001 		if(xCrsr.is())
//STRIP001 		{
//STRIP001 			if(sShortName.Len())
//STRIP001 			{
//STRIP001 				uno::Any aGroup = _xAutoText->getByName(sGroup);
//STRIP001                 uno::Reference< XAutoTextGroup >  xGroup;
//STRIP001 				OUString uShortName(sShortName);
//STRIP001                 if((aGroup >>= xGroup) && xGroup->hasByName(uShortName))
//STRIP001 				{
//STRIP001 					uno::Any aEntry(xGroup->getByName(uShortName));
//STRIP001                     uno::Reference< XAutoTextEntry >  xEntry;
//STRIP001                     aEntry >>= xEntry;
//STRIP001 					uno::Reference< XTextRange >  xRange(xCrsr, uno::UNO_QUERY);
//STRIP001 					xEntry->applyTo(xRange);
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ResetResumeData();
//STRIP001 }


}
