/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_splwrp.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:11:36 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _UIPARAM_HXX
#include <uiparam.hxx>		// fuer ITEMID_SPELLCHECK (muss _vor_ sfxdlg.hxx!)
#endif
#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif
#ifndef _VIEW_HXX
#include <view.hxx>
#endif
#ifndef _WRTSH_HXX
#include <wrtsh.hxx>
#endif
#ifndef _SWUNDO_HXX
#include <swundo.hxx>         // fuer Undo-Ids
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif


#ifndef _MSGBOX_HXX //autogen
#include <vcl/msgbox.hxx>
#endif
#ifndef _MySVXACORR_HXX //autogen
#include <bf_svx/svxacorr.hxx>
#endif
#ifndef _OFF_APP_HXX //autogen
#include <bf_offmgr/app.hxx>
#endif
#ifndef _SVX_LANGITEM_HXX //autogen
#include <bf_svx/langitem.hxx>
#endif
#ifndef _WRKWIN_HXX //autogen
#include <vcl/wrkwin.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif


#ifndef _UNO_LINGU_HXX
#include <bf_svx/unolingu.hxx>
#endif
#ifndef _SFX_SFXUNO_HXX
#include <bf_sfx2/sfxuno.hxx>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLALTERNATIVES_HPP_
#include <com/sun/star/linguistic2/XSpellAlternatives.hpp>
#endif
#ifndef _COM_SUN_STAR_LINGUISTIC2_XSPELLCHECKER1_HPP_
#include <com/sun/star/linguistic2/XSpellChecker1.hpp>
#endif

#ifndef _SPLWRP_HXX
#include <splwrp.hxx>
#endif
#ifndef _SDRSPELL_HXX
#include <sdrspell.hxx>
#endif
#ifndef _SHELLIO_HXX
#include <shellio.hxx>      // fuer SwTextBlocks
#endif
#ifndef _MDIEXP_HXX
#include <mdiexp.hxx>		// Progress
#endif
#ifndef _TEMPAUTO_HXX
#include <tempauto.hxx>     // temporaere Autokorrektur
#endif
#ifndef _EDTWIN_HXX
#include <edtwin.hxx>
#endif
#ifndef _CRSSKIP_HXX
#include <crsskip.hxx>
#endif


#ifndef _OLMENU_HRC
#include <olmenu.hrc>
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::linguistic2;

#define PSH (&pView->GetWrtShell())

/*--------------------------------------------------------------------
	 Beschreibung: Ggf. Rahmen/Objektshell abschalten
 --------------------------------------------------------------------*/

static void lcl_ActivateTextShell( SwWrtShell* pWrtSh )
{
	if( pWrtSh->IsSelFrmMode() || pWrtSh->IsObjSelected() )
		pWrtSh->EnterStdMode();
}

/*--------------------------------------------------------------------
	 Beschreibung: Ctor
 --------------------------------------------------------------------*/
SwSpellWrapper::SwSpellWrapper( SwView* pVw, Reference< XSpellChecker1 >  &xSpl,
								sal_Bool bStart, sal_Bool bIsAllRight,
								sal_Bool bOther, sal_Bool bSelect ) :
	SvxSpellWrapper( &pVw->GetEditWin(), xSpl, bStart,
					 bIsAllRight, bOther ), //#34752# EditWin als Parent
	pView( pVw ),
	nPageCount( 0 ),
	nPageStart( 0 ),
	pBlocks( 0 ),
	bInSelection(bSelect),
	bInfoBox( sal_False ),
	bLastRet( sal_True )
{
	bDrawObj = sal_False;
	EnableAutoCorrect();
}

// -----------------------------------------------------------------------

void SwSpellWrapper::SpellStart( SvxSpellArea eSpell )
{
	SetDrawObj( SVX_SPELL_OTHER == eSpell );
	pView->SpellStart( eSpell, IsStartDone(), IsEndDone() );
}

// -----------------------------------------------------------------------

sal_Bool SwSpellWrapper::SpellContinue()
{
	sal_Bool bProgress = !bDrawObj && !bInSelection;
    uno::Any  aRet = bProgress ?
		pView->GetWrtShell().SpellContinue( &nPageCount, &nPageStart ) :
		pView->GetWrtShell().SpellContinue( &nPageCount, NULL );
    Reference< XInterface >  xSpellAlt;
    aRet >>= xSpellAlt;
	SetLast( xSpellAlt );
	bLastRet = !xSpellAlt.is();
	return GetLast().is();
}

// -----------------------------------------------------------------------

void SwSpellWrapper::SpellEnd()
{
	pView->SpellEnd();
	SvxSpellWrapper::SpellEnd();
}

sal_Bool SwSpellWrapper::SpellMore()
{
	bInfoBox = sal_True;
	return sal_False;
}

// -----------------------------------------------------------------------

void SwSpellWrapper::ScrollArea()
{
	if ( IsDialog() && GetWin() )
		PSH->SetCareWin( GetWin() );

	pView->Scroll( PSH->GetCharRect().SVRect() );
}

// -----------------------------------------------------------------------

void SwSpellWrapper::ChangeWord( const String& rNewWord, const sal_uInt16 nLang )
{
	lcl_ActivateTextShell( PSH );
	// Das aktuelle Wort austauschen
	PSH->StartAllAction();
	PSH->StartUndo( UNDO_OVERWRITE );
	PSH->Delete();
    SetLanguage( nLang );

	String aTmp( rNewWord );

	// nur aufnehmen, wenn es NICHT schon in der Autokorrektur vorhanden ist
	Reference< XSpellAlternatives >  xAlt( GetLast(), UNO_QUERY );

	String 			aOrigWord;
	LanguageType	nOrigLang = LANGUAGE_NONE;
	if (xAlt.is())
	{
	 	aOrigWord = String(xAlt->getWord());
		nOrigLang = SvxLocaleToLanguage( xAlt->getLocale() );

		// if orginal word has a trailing . (likely the end of a sentence)
		// and the replacement text hasn't, then add it to the replacement
		if (aTmp.Len() && aOrigWord.Len() &&
			'.' == aOrigWord.GetChar( aOrigWord.Len() - 1) && /* !IsAlphaNumeric ??*/
			'.' != aTmp.GetChar( aTmp.Len() - 1))
		{
			aTmp += '.';
		}
	}
	SvxAutoCorrect* pACorr = OFF_APP()->GetAutoCorrect();
	SvxAutocorrWord aAWord( aOrigWord, aEmptyStr );
	if( aOrigWord.Len() > 0  &&
		!pACorr->GetAutocorrWordList( nOrigLang )->Seek_Entry( &aAWord ))
	{
		SwCorrection* pCorr = new SwCorrection( aAWord.GetShort() );
		pCorr->Correct() = rNewWord;
		if( !pTempAuto )
			pTempAuto = new SwTempAuto;
		pTempAuto->Insert( pCorr );
	}

	PSH->Insert( aTmp );
	PSH->EndUndo( UNDO_OVERWRITE );
	PSH->EndAllAction();
}

// -----------------------------------------------------------------------

String SwSpellWrapper::GetThesWord()
{
	if ( IsDialog() )
		return GetNewEditWord();
	return PSH->GetCurWord();
}

// -----------------------------------------------------------------------

void SwSpellWrapper::ChangeThesWord( const String& rNewWord )
{
	if ( IsDialog() )
		SetNewEditWord( rNewWord );
	else
	{
		lcl_ActivateTextShell( PSH );
		PSH->StartAllAction();
		PSH->StartUndo(UNDO_DELETE);
		if( !PSH->IsInWrd() && !PSH->IsEndWrd()	&& !PSH->IsSttWrd() )
			PSH->PrvWrd();
		if( PSH->IsEndWrd() )
			PSH->Left(CRSR_SKIP_CELLS, FALSE, 1, FALSE );
		PSH->SelWrd();
		PSH->Insert( rNewWord );
		PSH->EndUndo(UNDO_DELETE);
		PSH->EndAllAction();
	}
}

// -----------------------------------------------------------------------

void SwSpellWrapper::ReplaceAll( const String &rNewText, sal_Int16 nLanguage )
{
	Reference< XSpellAlternatives >  xAlt( GetLast(), UNO_QUERY );
	if (!xAlt.is())
		return;

	lcl_ActivateTextShell( PSH );
	PSH->StartAllAction();
	PSH->StartUndo(UNDO_OVERWRITE);
	PSH->Delete();

	String 		 aRplcText( rNewText );
	LanguageType nRplcLang = nLanguage;
	LanguageType nActLang  = SvxLocaleToLanguage( xAlt->getLocale() );

	String aTmp( aRplcText );	// no pre-/poststripped available to attach...
	String aOrig( xAlt->getWord());

	// if orginal word has a trailing . (likely the end of a sentence)
	// and the replacement text hasn't, then add it to the replacement
	if (aTmp.Len() && aOrig.Len() &&
		'.' == aOrig.GetChar( aOrig.Len() - 1) && /* !IsAlphaNumeric ??*/
		'.' != aTmp.GetChar( aTmp.Len() - 1))
	{
		aTmp += '.';
	}

	PSH->Insert( aTmp );

	// evtl. auch Sprache anpassen
	if( nRplcLang != nActLang )
	{	// Sprache bei Aenderung setzen
		SvxLanguageItem aLang( nRplcLang );
		PSH->SetAttr( aLang );
	}

	PSH->EndUndo(UNDO_OVERWRITE);
	PSH->EndAllAction();
}

// -----------------------------------------------------------------------

void SwSpellWrapper::SetLanguage( const sal_uInt16 nLang )
{
	lcl_ActivateTextShell( PSH );
	PSH->StartAllAction();

	SfxItemSet aSet(pView->GetPool(), RES_CHRATR_LANGUAGE, RES_CHRATR_LANGUAGE);
	aSet.Put( SvxLanguageItem( (LanguageType)nLang ) );
	PSH->SetAttr(aSet);

	PSH->EndAllAction();
}

// -----------------------------------------------------------------------

sal_Bool SwSpellWrapper::HasOtherCnt()
{
	return bInSelection ? sal_False : PSH->HasOtherCnt();
}

// -----------------------------------------------------------------------

SwSpellWrapper::~SwSpellWrapper()
{
	if( pBlocks )
		delete pBlocks;

	PSH->SetCareWin( NULL );
	if ( IsDrawObj() && bLastRet && pView->GetWrtShell().HasDrawView() )
	{
		Cursor *pSave = pView->GetWindow()->GetCursor();
		{
			Reference< XSpellChecker1 >  xSpell( GetSpellChecker() );
			SdrSpeller aSdrSpell( pView, xSpell );
			aSdrSpell.StartSpelling();
		}
		pView->GetWindow()->SetCursor( pSave );
	}
	if( nPageCount )
		::EndProgress( pView->GetDocShell() );
	if( bInfoBox )
		InfoBox(&pView->GetEditWin(), String(SW_RES(STR_SPELL_OK)) ).Execute();
}
// -----------------------------------------------------------------------

void SwSpellWrapper::AutoCorrect( const String& rAktStr, const String& rNewStr )
{
	Reference< XSpellAlternatives >  xAlt( GetLast(), UNO_QUERY);
	if (!xAlt.is())
		return;

	SvxAutoCorrect* pACorr = OFF_APP()->GetAutoCorrect();
	pACorr->PutText( rAktStr, rNewStr,
			SvxLocaleToLanguage( xAlt->getLocale() ) );
	if( pTempAuto )
		pTempAuto->Delete( rAktStr );
}

}
