/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_swwait.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 03:55:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

// auto strip #ifndef _SFXVIEWFRM_HXX //autogen wg. SfxViewFrame
// auto strip #include <bf_sfx2/viewfrm.hxx>
// auto strip #endif
#ifndef _SFXDISPATCH_HXX //autogen wg. SfxDispatcher
#include <bf_sfx2/dispatch.hxx>
#endif
#ifndef _WINDOW_HXX //autogen
#include <vcl/window.hxx>
#endif
#ifndef _SWDOCSH_HXX //autogen wg. SwDocShell
#include <docsh.hxx>
#endif
#ifndef _SWWAIT_HXX
#include <swwait.hxx>
#endif
namespace binfilter {


/*N*/ void SwDocShell::EnterWait( BOOL bLockDispatcher )
/*N*/ {
/*N*/ 	SfxViewFrame *pFrame = SfxViewFrame::GetFirst( this, 0, FALSE );
/*N*/ 	while ( pFrame )
/*N*/ 	{
/*N*/ 		pFrame->GetWindow().EnterWait();
/*N*/ 		if ( bLockDispatcher )
/*N*/ 			pFrame->GetDispatcher()->Lock( TRUE );
/*N*/ 		pFrame = SfxViewFrame::GetNext( *pFrame, this, 0, FALSE );
/*N*/ 	}
/*N*/ }

/*N*/ void SwDocShell::LeaveWait( BOOL bLockDispatcher )
/*N*/ {
/*N*/ 	SfxViewFrame *pFrame = SfxViewFrame::GetFirst( this, 0, FALSE );
/*N*/ 	while ( pFrame )
/*N*/ 	{
/*N*/ 		pFrame->GetWindow().LeaveWait();
/*N*/ 		if ( bLockDispatcher )
/*N*/ 			pFrame->GetDispatcher()->Lock( FALSE );
/*N*/ 		pFrame = SfxViewFrame::GetNext( *pFrame, this, 0, FALSE );
/*N*/ 	}
/*N*/ }

/*N*/ SwWait::SwWait( SwDocShell &rDocShell, BOOL bLockDispatcher ) :
/*N*/ 	rDoc ( rDocShell ),
/*N*/ 	bLock( bLockDispatcher )
/*N*/ {
/*N*/ 	rDoc.EnterWait( bLock );
/*N*/ }

/*N*/ SwWait::~SwWait()
/*N*/ {
/*N*/ 	rDoc.LeaveWait( bLock );
/*N*/ }


}
