/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: docsort.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 09:26:27 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SORT_HXX
#define _SORT_HXX

#ifndef _SVARRAY_HXX
#include <svtools/svarray.hxx>
#endif
// auto strip #ifndef _NDINDEX_HXX
// auto strip #include <ndindex.hxx>
// auto strip #endif
namespace com { namespace sun { namespace star { namespace lang {
	struct Locale;
}}}};
class CollatorWrapper;
class LocaleDataWrapper;
namespace binfilter {


class SwDoc;
class SwTableBox;
class SwUndoSort;
class FlatFndBox;
struct SwSortOptions;
struct SwSortElement;
class _FndBox;
class _FndLine;



//STRIP008 namespace com { namespace sun { namespace star { namespace lang {
//STRIP008 	struct Locale;
//STRIP008 }}}};

/*--------------------------------------------------------------------
	Beschreibung: Liste aller sortierten Elemente
 --------------------------------------------------------------------*/
typedef const _FndBox* 		_FndBoxPtr;
typedef SwSortElement* 		SwSortElementPtr;
typedef const SwTableBox* 	SwMovedBoxPtr;

SV_DECL_PTRARR_SORT(SwSortElements, SwSortElementPtr, 0, 1 )//STRIP008 ;
SV_DECL_PTRARR(SwMovedBoxes, 		SwMovedBoxPtr, 10, 10 )//STRIP008 ;

/*--------------------------------------------------------------------
	Beschreibung: Funktionen zum Moven von Boxen
 --------------------------------------------------------------------*/

//STRIP001 void MoveCol(SwDoc* pDoc, const FlatFndBox& rBox,
//STRIP001 			 USHORT nS, USHORT nT, SwMovedBoxes& rMovedList, SwUndoSort* pUD=0);
//STRIP001 void MoveRow(SwDoc* pDoc, const FlatFndBox& rBox,
//STRIP001 			 USHORT nS, USHORT nT, SwMovedBoxes& rMovedList, SwUndoSort* pUD=0);
//STRIP001 void MoveCell(SwDoc* pDoc, const SwTableBox* pSource,
//STRIP001 			  const SwTableBox* pTar, BOOL bMovedBefore, SwUndoSort* pUD=0);

/*-------------------------------------------------------------------
	Beschreibung: Elemente zum Sortieren von Text und Tabellen-Inhalt
 --------------------------------------------------------------------*/

//STRIP001 struct SwSortElement
//STRIP001 {
//STRIP001 	static SwSortOptions*		pOptions;
//STRIP001 	static SwDoc*				pDoc;
//STRIP001 	static const FlatFndBox*	pBox;
//STRIP001 	static CollatorWrapper*		pSortCollator;
//STRIP001 	static ::com::sun::star::lang::Locale* pLocale;
//STRIP001 	static String*				pLastAlgorithm;
//STRIP001 	static LocaleDataWrapper* 	pLclData;

//STRIP001 	static void Init( SwDoc*, const SwSortOptions& rOpt, FlatFndBox* = 0 );
//STRIP001 	static void Finit();

//STRIP001 	virtual ~SwSortElement();

//STRIP001 	virtual	String GetKey(USHORT nKey ) const = 0;
//STRIP001 	virtual	double GetValue(USHORT nKey ) const;

//STRIP001 	BOOL operator==(const SwSortElement& );
//STRIP001 	BOOL operator<(const SwSortElement& );

//STRIP001 	double StrToDouble(const String& rStr) const;
//STRIP001 };

/*--------------------------------------------------------------------
	Beschreibung: Sortieren Text
 --------------------------------------------------------------------*/

//STRIP001 struct SwSortTxtElement : public SwSortElement
//STRIP001 {
//STRIP001 	// fuer Text
//STRIP001 	ULONG 			nOrg;
//STRIP001 	SwNodeIndex		aPos;
//STRIP001 
//STRIP001 	SwSortTxtElement( const SwNodeIndex& rPos );
//STRIP001 	virtual ~SwSortTxtElement();
//STRIP001 
//STRIP001 	virtual String GetKey( USHORT nKey ) const;
//STRIP001 };

/*--------------------------------------------------------------------
	Beschreibung: Sortieren Tabelle
 --------------------------------------------------------------------*/

//STRIP001 struct SwSortBoxElement : public SwSortElement
//STRIP001 {
//STRIP001 	USHORT 						nRow;
//STRIP001 
//STRIP001 	SwSortBoxElement( USHORT nRC );
//STRIP001 	virtual ~SwSortBoxElement();
//STRIP001 
//STRIP001 	virtual String GetKey( USHORT nKey ) const;
//STRIP001 	virtual	double GetValue( USHORT nKey ) const;
//STRIP001 };


/*--------------------------------------------------------------------
	Beschreibung: SymFndBoxes stellt ein zweidimensionales
				  Array von FndBoxes dar
 --------------------------------------------------------------------*/

//STRIP001 class FlatFndBox
//STRIP001 {
//STRIP001 public:
//STRIP001 	FlatFndBox(SwDoc* pDocPtr, const _FndBox& rBox);
//STRIP001 	~FlatFndBox();
//STRIP001 
//STRIP001 	BOOL 				IsSymmetric() const { return bSym; 	}
//STRIP001 	USHORT				GetRows()	  const { return nRows;	}
//STRIP001 	USHORT				GetCols()	  const { return nCols;	}
//STRIP001 
//STRIP001 	const _FndBox* 		GetBox(USHORT nCol, USHORT nRow) const;
//STRIP001 
//STRIP001 	inline BOOL			HasItemSets() const;
//STRIP001 	const SfxItemSet* 	GetItemSet(USHORT nCol, USHORT nRow) const;
//STRIP001 
//STRIP001 private:
//STRIP001 
//STRIP001 	BOOL 				CheckLineSymmetry(const _FndBox& rBox);
//STRIP001 	BOOL 				CheckBoxSymmetry(const _FndLine& rLn);
//STRIP001 	USHORT 				GetColCount(const _FndBox& rBox);
//STRIP001 	USHORT 				GetRowCount(const _FndBox& rBox);
//STRIP001 	void 		   		FillFlat(const _FndBox&, BOOL bLastBox=FALSE);
//STRIP001 
//STRIP001 	SwDoc*				pDoc;
//STRIP001 	const _FndBox&		rBoxRef;
//STRIP001 	_FndBoxPtr* 		pArr;
//STRIP001 	SfxItemSet** 		ppItemSets;
//STRIP001 
//STRIP001 	USHORT 	 			nRows;
//STRIP001 	USHORT   	   		nCols;
//STRIP001 
//STRIP001 	USHORT 				nRow;
//STRIP001 	USHORT 				nCol;
//STRIP001 
//STRIP001 	BOOL				bSym;
//STRIP001 };
//STRIP001 
//STRIP001 
//STRIP001 inline BOOL FlatFndBox::HasItemSets() const	{ return 0 != ppItemSets; }

} //namespace binfilter
#endif // _NDSORT_HXX
