/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: fileobj.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:11:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FILEOBJ_HXX
#define _FILEOBJ_HXX

// auto strip #ifndef _STRING_HXX //autogen
// auto strip #include <tools/string.hxx>
// auto strip #endif
#ifndef _LINKSRC_HXX //autogen
#include <so3/linksrc.hxx>
#endif
#ifndef _SFXDOCFILE_HXX //autogen
#include <bf_sfx2/docfile.hxx>
#endif
class Graphic;
namespace binfilter {

struct Impl_DownLoadData;


class SvFileObject : public ::so3::SvLinkSource
{
	String sFileNm;
	String sFilter;
	String sReferer;
	SfxMediumRef xMed;
	Impl_DownLoadData* pDownLoadData;

	BYTE nType;

	BOOL bProgress : 1;
	BOOL bLoadAgain : 1;
	BOOL bSynchron : 1;
	BOOL bLoadError : 1;
	BOOL bWaitForData : 1;
	BOOL bInNewData : 1;
	BOOL bDataReady : 1;
	BOOL bMedUseCache : 1;
	BOOL bNativFormat : 1;
	BOOL bClearMedium : 1;
	BOOL bStateChangeCalled : 1;
	BOOL bInCallDownLoad : 1;

	BOOL GetGraphic_Impl( Graphic&, SvStream* pStream = 0 );
	BOOL LoadFile_Impl();
	void SendStateChg_Impl( USHORT nState );

	DECL_STATIC_LINK( SvFileObject, DelMedium_Impl, SfxMediumRef* );
	DECL_STATIC_LINK( SvFileObject, LoadGrfReady_Impl, void* );
	DECL_STATIC_LINK( SvFileObject, LoadGrfNewData_Impl, void* );
protected:
	virtual ~SvFileObject();

public:
	SvFileObject();

	virtual BOOL GetData( ::com::sun::star::uno::Any & rData /*out param*/,
							const String & rMimeType,
							BOOL bSynchron = FALSE );

	virtual BOOL Connect( ::so3::SvBaseLink* );
//STRIP001 	virtual String Edit( Window*, ::so3::SvBaseLink* );

	// erfrage ob das man direkt auf die Daten zugreifen kann oder ob das
	// erst angestossen werden muss
//STRIP001 	virtual BOOL IsPending() const;
//STRIP001 	virtual BOOL IsDataComplete() const;

	void CancelTransfers();
//STRIP001 	void SetTransferPriority( USHORT nPrio );
};


}//end of namespace binfilter
#endif

