/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_labdlg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:52:53 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#ifndef _SHL_HXX
#include <tools/shl.hxx>
#endif
#ifndef _SFXAPP_HXX
#include <bf_sfx2/app.hxx>
#endif
#ifndef _SFXMODULE_HXX
#include <bf_sfx2/module.hxx>
#endif
#pragma hdrstop

#define _SVX_LABDLG_CXX

#include "svdattrx.hxx"
#include "dialogs.hrc"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
#include "transfrm.hxx"

#include "labdlg.hrc"
#include "labdlg.hxx"
namespace binfilter {

// define ----------------------------------------------------------------

//STRIP001 #define AZ_OPTIMAL		0
//STRIP001 #define AZ_VON_OBEN		1
//STRIP001 #define AZ_VON_LINKS	2
//STRIP001 #define AZ_HORIZONTAL	3
//STRIP001 #define AZ_VERTIKAL		4

//STRIP001 #define AT_OBEN			0
//STRIP001 #define AT_MITTE		1
//STRIP001 #define AT_UNTEN		2

//STRIP001 #define WK_OPTIMAL		0
//STRIP001 #define WK_30			1
//STRIP001 #define WK_45			2
//STRIP001 #define WK_60			3
//STRIP001 #define WK_90			4

// static ----------------------------------------------------------------

//STRIP001 static USHORT pCaptionRanges[] =
//STRIP001 {
//STRIP001 	SDRATTR_CAPTIONTYPE,
//STRIP001 	SDRATTR_CAPTIONFIXEDANGLE,
//STRIP001 	SDRATTR_CAPTIONANGLE,
//STRIP001 	SDRATTR_CAPTIONGAP,
//STRIP001 	SDRATTR_CAPTIONESCDIR,
//STRIP001 	SDRATTR_CAPTIONESCISREL,
//STRIP001 	SDRATTR_CAPTIONESCREL,
//STRIP001 	SDRATTR_CAPTIONESCABS,
//STRIP001 	SDRATTR_CAPTIONLINELEN,
//STRIP001 	SDRATTR_CAPTIONFITLINELEN,
//STRIP001 	0
//STRIP001 };

// -----------------------------------------------------------------------

//STRIP001 SvxCaptionTabPage::SvxCaptionTabPage(Window* pParent, const SfxItemSet& rInAttrs)
//STRIP001  :	SfxTabPage( pParent, SVX_RES( RID_SVXPAGE_CAPTION ), rInAttrs ),
//STRIP001 
//STRIP001 	aCT_CAPTTYPE(		this, ResId( CT_CAPTTYPE ) ),
//STRIP001 	aFT_ABSTAND(		this, ResId( FT_ABSTAND ) ),
//STRIP001 	aMF_ABSTAND(		this, ResId( MF_ABSTAND ) ),
//STRIP001 	aFT_WINKEL(			this, ResId( FT_WINKEL ) ),
//STRIP001 	aLB_WINKEL(			this, ResId( LB_WINKEL ) ),
//STRIP001 	aFT_ANSATZ(			this, ResId( FT_ANSATZ ) ),
//STRIP001 	aLB_ANSATZ(			this, ResId( LB_ANSATZ ) ),
//STRIP001 	aFT_UM(				this, ResId( FT_UM ) ),
//STRIP001 	aMF_ANSATZ(			this, ResId( MF_ANSATZ ) ),
//STRIP001 	aFT_ANSATZ_REL(		this, ResId( FT_ANSATZ_REL ) ),
//STRIP001 	aLB_ANSATZ_REL(		this, ResId( LB_ANSATZ_REL ) ),
//STRIP001 	aFT_LAENGE(			this, ResId( FT_LAENGE ) ),
//STRIP001 	aMF_LAENGE(			this, ResId( MF_LAENGE ) ),
//STRIP001 	aCB_LAENGE(			this, ResId( CB_LAENGE ) ),
//STRIP001 
//STRIP001 	aStrHorzList( ResId(STR_HORZ_LIST) ),
//STRIP001 	aStrVertList( ResId(STR_VERT_LIST) ),
//STRIP001 
//STRIP001 	rOutAttrs		( rInAttrs )
//STRIP001 {
//STRIP001 	//------------NYI-------------------------------------------
//STRIP001 	aFT_WINKEL.Hide();
//STRIP001 	aLB_WINKEL.Hide();
//STRIP001 
//STRIP001 	//------------Positionen korrigieren-------------------------
//STRIP001 	aFT_ANSATZ_REL.SetPosPixel( aFT_UM.GetPosPixel() );
//STRIP001 	aLB_ANSATZ_REL.SetPosPixel(
//STRIP001 		Point(
//STRIP001 			aFT_ANSATZ_REL.GetPosPixel().X()+aFT_ANSATZ_REL.GetSizePixel().Width()+6,
//STRIP001 			aLB_ANSATZ.GetPosPixel().Y() )
//STRIP001 		);
//STRIP001 
//STRIP001 	aMF_ANSATZ.SetPosPixel(
//STRIP001 		Point(
//STRIP001 			aFT_UM.GetPosPixel().X()+aFT_UM.GetSizePixel().Width()+6,
//STRIP001 			aLB_ANSATZ.GetPosPixel().Y() )
//STRIP001 		);
//STRIP001 
//STRIP001 	sal_uInt16 nBitmap;
//STRIP001 	for( nBitmap = 0; nBitmap < CAPTYPE_BITMAPS_COUNT; nBitmap++ )
//STRIP001 	{
//STRIP001 		mpBmpCapTypes[nBitmap]  = new Image(Bitmap(ResId(BMP_CAPTTYPE_1   + nBitmap)), COL_LIGHTMAGENTA );
//STRIP001 		mpBmpCapTypesH[nBitmap] = new Image(Bitmap(ResId(BMP_CAPTTYPE_1_H + nBitmap)), COL_LIGHTMAGENTA );
//STRIP001 	}
//STRIP001 
//STRIP001 	//------------ValueSet installieren--------------------------
//STRIP001 	aCT_CAPTTYPE.SetStyle( aCT_CAPTTYPE.GetStyle() | WB_ITEMBORDER | WB_DOUBLEBORDER | WB_NAMEFIELD );
//STRIP001 	aCT_CAPTTYPE.SetColCount(5);//XXX
//STRIP001 	aCT_CAPTTYPE.SetLineCount(1);
//STRIP001 	aCT_CAPTTYPE.SetSelectHdl(LINK( this, SvxCaptionTabPage, SelectCaptTypeHdl_Impl));
//STRIP001 
//STRIP001 	Image aImage;
//STRIP001 	aCT_CAPTTYPE.InsertItem(BMP_CAPTTYPE_1, aImage,	String(ResId(STR_CAPTTYPE_1)));
//STRIP001 	aCT_CAPTTYPE.InsertItem(BMP_CAPTTYPE_2,	aImage,	String(ResId(STR_CAPTTYPE_2)));
//STRIP001 	aCT_CAPTTYPE.InsertItem(BMP_CAPTTYPE_3,	aImage,	String(ResId(STR_CAPTTYPE_3)));
//STRIP001 
//STRIP001 	FillValueSet();
//STRIP001 
//STRIP001 	aLB_ANSATZ.SetSelectHdl(LINK(this,SvxCaptionTabPage,AnsatzSelectHdl_Impl));
//STRIP001 	aLB_ANSATZ_REL.SetSelectHdl(LINK(this,SvxCaptionTabPage,AnsatzRelSelectHdl_Impl));
//STRIP001 	aCB_LAENGE.SetClickHdl(LINK(this,SvxCaptionTabPage,LineOptHdl_Impl));
//STRIP001 
//STRIP001 	FreeResource();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxCaptionTabPage::~SvxCaptionTabPage()
//STRIP001 {
//STRIP001 	sal_uInt16 nBitmap;
//STRIP001 	for( nBitmap = 0; nBitmap < CAPTYPE_BITMAPS_COUNT; nBitmap++ )
//STRIP001 	{
//STRIP001 		delete mpBmpCapTypes[nBitmap];
//STRIP001 		delete mpBmpCapTypesH[nBitmap];
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::Construct()
//STRIP001 {
//STRIP001 	// Setzen des Rechtecks und der Workingarea
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 BOOL SvxCaptionTabPage::FillItemSet( SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	SfxItemPool* 	pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 
//STRIP001 	SfxMapUnit		eUnit;
//STRIP001 
//STRIP001 	nCaptionType = aCT_CAPTTYPE.GetSelectItemId()-1;
//STRIP001 
//STRIP001 	rOutAttrs.Put( SdrCaptionTypeItem( (SdrCaptionType) nCaptionType ) );
//STRIP001 
//STRIP001 	if( aMF_ABSTAND.IsValueModified() )
//STRIP001 	{
//STRIP001 		eUnit = pPool->GetMetric( GetWhich( SDRATTR_CAPTIONGAP ) );
//STRIP001 		rOutAttrs.Put( SdrCaptionGapItem( GetCoreValue(aMF_ABSTAND, eUnit ) ) );
//STRIP001 	}
//STRIP001 
//STRIP001 	// Sonderbehandlung!!! XXX
//STRIP001 	if( nCaptionType==SDRCAPT_TYPE1 )
//STRIP001 	{
//STRIP001 		switch( nEscDir )
//STRIP001 		{
//STRIP001 			case SDRCAPT_ESCHORIZONTAL:		nEscDir=SDRCAPT_ESCVERTICAL;break;
//STRIP001 			case SDRCAPT_ESCVERTICAL:		nEscDir=SDRCAPT_ESCHORIZONTAL;break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rOutAttrs.Put( SdrCaptionEscDirItem( (SdrCaptionEscDir)nEscDir ) );
//STRIP001 
//STRIP001 	bEscRel = aLB_ANSATZ_REL.IsVisible();
//STRIP001 	rOutAttrs.Put( SdrCaptionEscIsRelItem( bEscRel ) );
//STRIP001 
//STRIP001 	if( bEscRel )
//STRIP001 	{
//STRIP001 		long	nVal = 0;
//STRIP001 
//STRIP001 		switch( aLB_ANSATZ_REL.GetSelectEntryPos() )
//STRIP001 		{
//STRIP001 			case AT_OBEN:	nVal=0;break;
//STRIP001 			case AT_MITTE:	nVal=5000;break;
//STRIP001 			case AT_UNTEN:	nVal=10000;break;
//STRIP001 		}
//STRIP001 		rOutAttrs.Put( SdrCaptionEscRelItem( nVal ) );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if( aMF_ANSATZ.IsValueModified() )
//STRIP001 		{
//STRIP001 			eUnit = pPool->GetMetric( GetWhich( SDRATTR_CAPTIONESCABS ) );
//STRIP001 			rOutAttrs.Put( SdrCaptionEscAbsItem( GetCoreValue(aMF_ANSATZ, eUnit ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	bFitLineLen = aCB_LAENGE.IsChecked();
//STRIP001 	rOutAttrs.Put( SdrCaptionFitLineLenItem( bFitLineLen ) );
//STRIP001 
//STRIP001 	if( ! bFitLineLen )
//STRIP001 	{
//STRIP001 		if( aMF_LAENGE.IsValueModified() )
//STRIP001 		{
//STRIP001 			eUnit = pPool->GetMetric( GetWhich( SDRATTR_CAPTIONLINELEN ) );
//STRIP001 			rOutAttrs.Put( SdrCaptionLineLenItem( GetCoreValue(aMF_LAENGE, eUnit ) ) );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 //NYI-------------die Winkel muessen noch hier rein!!! XXX----------------------
//STRIP001 
//STRIP001 	return( TRUE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::Reset( const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 
//STRIP001 	//------------Metrik einstellen-----------------------------
//STRIP001 
//STRIP001 	FieldUnit eFUnit = GetModuleFieldUnit( &rOutAttrs );
//STRIP001 
//STRIP001 	switch ( eFUnit )
//STRIP001 	{
//STRIP001 		case FUNIT_CM:
//STRIP001 		case FUNIT_M:
//STRIP001 		case FUNIT_KM:
//STRIP001 			eFUnit = FUNIT_MM;
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	SetFieldUnit( aMF_ABSTAND, eFUnit );
//STRIP001 	SetFieldUnit( aMF_ANSATZ, eFUnit );
//STRIP001 	SetFieldUnit( aMF_LAENGE, eFUnit );
//STRIP001 
//STRIP001 	SfxItemPool* 	pPool = rOutAttrs.GetPool();
//STRIP001 	DBG_ASSERT( pPool, "Wo ist der Pool" );
//STRIP001 
//STRIP001 	USHORT			nWhich;
//STRIP001 	SfxMapUnit		eUnit;
//STRIP001 
//STRIP001 	//------- Winkel ----------
//STRIP001 	nWhich = GetWhich( SDRATTR_CAPTIONANGLE );
//STRIP001 	nFixedAngle = ( ( const SdrCaptionAngleItem& ) rOutAttrs.Get( nWhich ) ).GetValue();
//STRIP001 
//STRIP001 	//------- absolute Ansatzentfernung ----------
//STRIP001 	nWhich = GetWhich( SDRATTR_CAPTIONESCABS );
//STRIP001 	eUnit = pPool->GetMetric( nWhich );
//STRIP001 	nEscAbs = ( ( const SdrCaptionEscAbsItem& ) rOutAttrs.Get( nWhich ) ).GetValue();
//STRIP001 	SetMetricValue( aMF_ANSATZ, nEscAbs, eUnit );
//STRIP001 	nEscAbs = aMF_ANSATZ.GetValue();
//STRIP001 
//STRIP001 	//------- relative Ansatzentfernung ----------
//STRIP001 	nWhich = GetWhich( SDRATTR_CAPTIONESCREL );
//STRIP001 	nEscRel = (long)( ( const SdrCaptionEscRelItem& ) rOutAttrs.Get( nWhich ) ).GetValue();
//STRIP001 
//STRIP001 	//------- Linienlaenge ----------
//STRIP001 	nWhich = GetWhich( SDRATTR_CAPTIONLINELEN );
//STRIP001 	eUnit = pPool->GetMetric( nWhich );
//STRIP001 	nLineLen = ( ( const SdrCaptionLineLenItem& ) rOutAttrs.Get( nWhich ) ).GetValue();
//STRIP001 	SetMetricValue( aMF_LAENGE, nLineLen, eUnit );
//STRIP001 	nLineLen = aMF_LAENGE.GetValue();
//STRIP001 
//STRIP001 	//------- Abstand zur Box ----------
//STRIP001 	nWhich = GetWhich( SDRATTR_CAPTIONGAP );
//STRIP001 	eUnit = pPool->GetMetric( nWhich );
//STRIP001 	nGap = ( ( const SdrCaptionGapItem& ) rOutAttrs.Get( nWhich ) ).GetValue();
//STRIP001 	SetMetricValue( aMF_ABSTAND, nGap, eUnit );
//STRIP001 	nGap = aMF_ABSTAND.GetValue();
//STRIP001 
//STRIP001 	nCaptionType = (short)( ( const SdrCaptionTypeItem& ) rOutAttrs.Get( GetWhich( SDRATTR_CAPTIONTYPE ) ) ).GetValue();
//STRIP001 	bFixedAngle = ( ( const SfxBoolItem& ) rOutAttrs.Get( GetWhich( SDRATTR_CAPTIONFIXEDANGLE ) ) ).GetValue();
//STRIP001 	bFitLineLen = ( ( const SfxBoolItem& ) rOutAttrs.Get( GetWhich( SDRATTR_CAPTIONFITLINELEN ) ) ).GetValue();
//STRIP001 	nEscDir = (short)( ( const SdrCaptionEscDirItem& ) rOutAttrs.Get( GetWhich( SDRATTR_CAPTIONESCDIR ) ) ).GetValue();
//STRIP001 	bEscRel = ( ( const SfxBoolItem& ) rOutAttrs.Get( GetWhich( SDRATTR_CAPTIONESCISREL ) ) ).GetValue();
//STRIP001 
//STRIP001 	// Sonderbehandlung!!! XXX
//STRIP001 	if( nCaptionType==SDRCAPT_TYPE1 )
//STRIP001 	{
//STRIP001 		switch( nEscDir )
//STRIP001 		{
//STRIP001 			case SDRCAPT_ESCHORIZONTAL:		nEscDir=SDRCAPT_ESCVERTICAL;break;
//STRIP001 			case SDRCAPT_ESCVERTICAL:		nEscDir=SDRCAPT_ESCHORIZONTAL;break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	nAnsatzRelPos=AT_MITTE;
//STRIP001 	nAnsatzTypePos=AZ_OPTIMAL;
//STRIP001 	nWinkelTypePos=WK_OPTIMAL;
//STRIP001 
//STRIP001 	aMF_ABSTAND.SetValue( nGap );
//STRIP001 
//STRIP001 	if( nEscDir == SDRCAPT_ESCHORIZONTAL )
//STRIP001 	{
//STRIP001 		if( bEscRel )
//STRIP001 		{
//STRIP001 			if( nEscRel < 3333 )
//STRIP001 				nAnsatzRelPos = AT_OBEN;
//STRIP001 			if( nEscRel > 6666 )
//STRIP001 				nAnsatzRelPos = AT_UNTEN;
//STRIP001 			nAnsatzTypePos = AZ_HORIZONTAL;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nAnsatzTypePos = AZ_VON_OBEN;
//STRIP001 			aMF_ANSATZ.SetValue( nEscAbs );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( nEscDir == SDRCAPT_ESCVERTICAL )
//STRIP001 	{
//STRIP001 		if( bEscRel )
//STRIP001 		{
//STRIP001 			if( nEscRel < 3333 )
//STRIP001 				nAnsatzRelPos = AT_OBEN;
//STRIP001 			if( nEscRel > 6666 )
//STRIP001 				nAnsatzRelPos = AT_UNTEN;
//STRIP001 			nAnsatzTypePos = AZ_VERTIKAL;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			nAnsatzTypePos = AZ_VON_LINKS;
//STRIP001 			aMF_ANSATZ.SetValue( nEscAbs );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if( nEscDir == SDRCAPT_ESCBESTFIT )
//STRIP001 	{
//STRIP001 		nAnsatzTypePos = AZ_OPTIMAL;
//STRIP001 	}
//STRIP001 
//STRIP001 	if( bFixedAngle )
//STRIP001 	{
//STRIP001 		if( nFixedAngle <= 3000 )
//STRIP001 			nWinkelTypePos=WK_30;
//STRIP001 		else if( nFixedAngle <= 4500 )
//STRIP001 			nWinkelTypePos=WK_45;
//STRIP001 		else if( nFixedAngle <= 6000 )
//STRIP001 			nWinkelTypePos=WK_60;
//STRIP001 		else
//STRIP001 			nWinkelTypePos=WK_90;
//STRIP001 	}
//STRIP001 
//STRIP001 	aCB_LAENGE.Check( bFitLineLen );
//STRIP001 	aMF_LAENGE.SetValue( nLineLen );
//STRIP001 
//STRIP001 	aLB_ANSATZ.SelectEntryPos( nAnsatzTypePos );
//STRIP001 	aLB_WINKEL.SelectEntryPos( nWinkelTypePos );
//STRIP001 
//STRIP001 	SetupAnsatz_Impl( nAnsatzTypePos );
//STRIP001 	aCT_CAPTTYPE.SelectItem( nCaptionType+1 );// Enum beginnt bei 0!
//STRIP001 	SetupType_Impl( nCaptionType+1 );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SfxTabPage* SvxCaptionTabPage::Create( Window* pWindow,
//STRIP001 				const SfxItemSet& rOutAttrs )
//STRIP001 {
//STRIP001 	return( new SvxCaptionTabPage( pWindow, rOutAttrs ) );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 USHORT*	SvxCaptionTabPage::GetRanges()
//STRIP001 {
//STRIP001 	return( pCaptionRanges );
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::SetupAnsatz_Impl( USHORT nType )
//STRIP001 {
//STRIP001 	xub_StrLen	nCnt=0, nIdx=0;
//STRIP001 
//STRIP001 	switch( nType )
//STRIP001 	{
//STRIP001 		case AZ_OPTIMAL:
//STRIP001 //		aMF_ANSATZ.Hide(); //XXX auch bei OPTIMAL werden Abswerte genommen
//STRIP001 //		aFT_UM.Hide();
//STRIP001 		aMF_ANSATZ.Show();
//STRIP001 		aFT_UM.Show();
//STRIP001 		aFT_ANSATZ_REL.Hide();
//STRIP001 		aLB_ANSATZ_REL.Hide();
//STRIP001 		nEscDir = SDRCAPT_ESCBESTFIT;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case AZ_VON_OBEN:
//STRIP001 		aMF_ANSATZ.Show();
//STRIP001 		aFT_UM.Show();
//STRIP001 		aFT_ANSATZ_REL.Hide();
//STRIP001 		aLB_ANSATZ_REL.Hide();
//STRIP001 		nEscDir = SDRCAPT_ESCHORIZONTAL;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case AZ_VON_LINKS:
//STRIP001 		aMF_ANSATZ.Show();
//STRIP001 		aFT_UM.Show();
//STRIP001 		aFT_ANSATZ_REL.Hide();
//STRIP001 		aLB_ANSATZ_REL.Hide();
//STRIP001 		nEscDir = SDRCAPT_ESCVERTICAL;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case AZ_HORIZONTAL:
//STRIP001 		aLB_ANSATZ_REL.Clear();
//STRIP001 		nCnt = aStrHorzList.GetTokenCount();
//STRIP001 		for( nIdx=0 ; nIdx<nCnt ; nIdx++ )
//STRIP001 			aLB_ANSATZ_REL.InsertEntry( aStrHorzList.GetToken(nIdx) );
//STRIP001 		aLB_ANSATZ_REL.SelectEntryPos( nAnsatzRelPos );
//STRIP001 
//STRIP001 		aMF_ANSATZ.Hide();
//STRIP001 		aFT_UM.Hide();
//STRIP001 		aFT_ANSATZ_REL.Show();
//STRIP001 		aLB_ANSATZ_REL.Show();
//STRIP001 		nEscDir = SDRCAPT_ESCHORIZONTAL;
//STRIP001 		break;
//STRIP001 
//STRIP001 		case AZ_VERTIKAL:
//STRIP001 		aLB_ANSATZ_REL.Clear();
//STRIP001 		nCnt = aStrVertList.GetTokenCount();
//STRIP001 		for( nIdx=0 ; nIdx<nCnt ; nIdx++ )
//STRIP001 			aLB_ANSATZ_REL.InsertEntry( aStrVertList.GetToken(nIdx) );
//STRIP001 		aLB_ANSATZ_REL.SelectEntryPos( nAnsatzRelPos );
//STRIP001 
//STRIP001 		aMF_ANSATZ.Hide();
//STRIP001 		aFT_UM.Hide();
//STRIP001 		aFT_ANSATZ_REL.Show();
//STRIP001 		aLB_ANSATZ_REL.Show();
//STRIP001 		nEscDir = SDRCAPT_ESCVERTICAL;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxCaptionTabPage, AnsatzSelectHdl_Impl, ListBox *, pListBox )
//STRIP001 {
//STRIP001 	if( pListBox == &aLB_ANSATZ )
//STRIP001 	{
//STRIP001 		SetupAnsatz_Impl( aLB_ANSATZ.GetSelectEntryPos() );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxCaptionTabPage, AnsatzSelectHdl_Impl, ListBox *, pListBox )

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxCaptionTabPage, AnsatzRelSelectHdl_Impl, ListBox *, pListBox )
//STRIP001 {
//STRIP001 	if( pListBox == &aLB_ANSATZ_REL )
//STRIP001 	{
//STRIP001 		nAnsatzRelPos = aLB_ANSATZ_REL.GetSelectEntryPos();
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxCaptionTabPage, AnsatzRelSelectHdl_Impl, ListBox *, pListBox )

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK( SvxCaptionTabPage, LineOptHdl_Impl, Button *, pButton )
//STRIP001 {
//STRIP001 	if( pButton == &aCB_LAENGE )
//STRIP001 	{
//STRIP001 		if( aCB_LAENGE.IsChecked() || ! aCB_LAENGE.IsEnabled() )
//STRIP001 		{
//STRIP001             aFT_LAENGE.Disable();
//STRIP001 			aMF_LAENGE.Disable();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001             aFT_LAENGE.Enable();
//STRIP001 			aMF_LAENGE.Enable();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------

//STRIP001 IMPL_LINK_INLINE_START( SvxCaptionTabPage, SelectCaptTypeHdl_Impl, void *, EMPTYARG )
//STRIP001 {
//STRIP001 	SetupType_Impl( aCT_CAPTTYPE.GetSelectItemId() );
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SvxCaptionTabPage, SelectCaptTypeHdl_Impl, void *, EMPTYARG )

//------------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::SetupType_Impl( USHORT nType )
//STRIP001 {
//STRIP001 	switch( nType-1 )
//STRIP001 	{
//STRIP001 		case SDRCAPT_TYPE1:
//STRIP001         aFT_WINKEL.Disable();
//STRIP001 		aLB_WINKEL.Disable();
//STRIP001         aFT_LAENGE.Disable();
//STRIP001 		aCB_LAENGE.Disable();
//STRIP001 		LineOptHdl_Impl( &aCB_LAENGE );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SDRCAPT_TYPE2:
//STRIP001         aFT_WINKEL.Enable();
//STRIP001 		aLB_WINKEL.Enable();
//STRIP001         aFT_LAENGE.Disable();
//STRIP001 		aCB_LAENGE.Disable();
//STRIP001 		LineOptHdl_Impl( &aCB_LAENGE );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SDRCAPT_TYPE3:
//STRIP001         aFT_WINKEL.Enable();
//STRIP001 		aLB_WINKEL.Enable();
//STRIP001         aFT_LAENGE.Enable();
//STRIP001 		aCB_LAENGE.Enable();
//STRIP001 		LineOptHdl_Impl( &aCB_LAENGE );
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SDRCAPT_TYPE4:
//STRIP001         aFT_WINKEL.Enable();
//STRIP001 		aLB_WINKEL.Enable();
//STRIP001         aFT_LAENGE.Enable();
//STRIP001 		aCB_LAENGE.Enable();
//STRIP001 		LineOptHdl_Impl( &aCB_LAENGE );
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     SfxTabPage::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             FillValueSet();
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxCaptionTabPage::FillValueSet()
//STRIP001 {
//STRIP001 	bool bHighContrast = (bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0);
//STRIP001 
//STRIP001 	Image** ppBitmaps = bHighContrast ? mpBmpCapTypesH : mpBmpCapTypes;
//STRIP001 	aCT_CAPTTYPE.SetItemImage(BMP_CAPTTYPE_1, *(ppBitmaps[0]) );
//STRIP001 	aCT_CAPTTYPE.SetItemImage(BMP_CAPTTYPE_2, *(ppBitmaps[1]) );
//STRIP001 	aCT_CAPTTYPE.SetItemImage(BMP_CAPTTYPE_3, *(ppBitmaps[2]) );
//STRIP001 }

//========================================================================


//STRIP001 SvxCaptionTabDialog::SvxCaptionTabDialog(Window* pParent, const SdrView* pSdrView, USHORT nAnchorTypes)
//STRIP001  :	SfxTabDialog( pParent, SVX_RES( RID_SVXDLG_CAPTION ) ),
//STRIP001 	nAnchorCtrls(nAnchorTypes),
//STRIP001 	pView		( pSdrView )
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 
//STRIP001 	AddTabPage( RID_SVXPAGE_POSITION_SIZE, SvxPositionSizeTabPage::Create,
//STRIP001 							SvxPositionSizeTabPage::GetRanges );
//STRIP001 	AddTabPage( RID_SVXPAGE_CAPTION, SvxCaptionTabPage::Create,
//STRIP001 							SvxCaptionTabPage::GetRanges );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 SvxCaptionTabDialog::~SvxCaptionTabDialog()
//STRIP001 {
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxCaptionTabDialog::PageCreated( USHORT nId, SfxTabPage &rPage )
//STRIP001 {
//STRIP001 	switch( nId )
//STRIP001 	{
//STRIP001 		case RID_SVXPAGE_POSITION_SIZE:
//STRIP001 			( (SvxPositionSizeTabPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxPositionSizeTabPage&) rPage ).Construct();
//STRIP001 			if( nAnchorCtrls & SVX_OBJ_NORESIZE )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).DisableResize();
//STRIP001 
//STRIP001 			if( nAnchorCtrls & SVX_OBJ_NOPROTECT )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).DisableProtect();
//STRIP001 
//STRIP001 			if(nAnchorCtrls & 0x00ff )
//STRIP001 				( (SvxPositionSizeTabPage&) rPage ).ShowAnchorCtrls(nAnchorCtrls);
//STRIP001 		break;
//STRIP001 
//STRIP001 		case RID_SVXPAGE_CAPTION:
//STRIP001 			( (SvxCaptionTabPage&) rPage ).SetView( pView );
//STRIP001 			( (SvxCaptionTabPage&) rPage ).Construct();
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }


}
