/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_viewhdl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:07:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

#include <view.hxx>

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDLISTENER_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardListener.hpp>
#endif
#ifndef _COM_SUN_STAR_DATATRANSFER_CLIPBOARD_XCLIPBOARDNOTIFIER_HPP_
#include <com/sun/star/datatransfer/clipboard/XClipboardNotifier.hpp>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _TRANSFER_HXX
#include <svtools/transfer.hxx>
#endif
#ifndef _SFX_BINDINGS_HXX
#include <bf_sfx2/bindings.hxx>
#endif
#ifndef _SFXSIDS_HRC
#include <bf_sfx2/sfxsids.hrc>
#endif
namespace binfilter {

using namespace ::com::sun::star;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::datatransfer::clipboard;

// --------------------------- Clipboard EventListener ------------------

class SmClipboardChangeListener : public ::cppu::WeakImplHelper1<
	::com::sun::star::datatransfer::clipboard::XClipboardListener >
{
	SmViewShell*	pView;

	// XEventListener
	virtual void SAL_CALL disposing(
			const lang::EventObject& rEventObject ) throw ( ::com::sun::star::uno::RuntimeException)
;//							throw( UNO_NMSPC::RuntimeException );

	// XClipboardListener
	virtual void SAL_CALL changedContents(
			const datatransfer::clipboard::ClipboardEvent& rEventObject ) throw ( ::com::sun::star::uno::RuntimeException)
;//										throw( UNO_NMSPC::RuntimeException );

public:
	SmClipboardChangeListener( SmViewShell& rView ) : pView( &rView ) {}
	virtual	~SmClipboardChangeListener();

	void ViewDestroyed() { pView = 0; }

	void AddRemoveListener( BOOL bAdd );
};



// ------------------------- SmClipboardChangeListener ---------------------

/*N*/ SmClipboardChangeListener::~SmClipboardChangeListener()
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL SmClipboardChangeListener::disposing(
/*N*/ 									const lang::EventObject& rEventObject ) throw ( ::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL SmClipboardChangeListener::changedContents(
/*N*/ 							const ClipboardEvent& rEventObject ) throw ( ::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	if( pView )
/*N*/ 	{
/*N*/ 		{
/*N*/ 		const ::vos::OGuard aGuard( Application::GetSolarMutex() );
/*N*/ 
/*N*/ 		TransferableDataHelper aDataHelper( rEventObject.Contents );
/*N*/ 		pView->bPasteState = aDataHelper.GetTransferable().is() &&
/*N*/ 			( aDataHelper.HasFormat( FORMAT_STRING ) ||
/*N*/ 			aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBEDDED_OBJ ) ||
/*N*/ 			(aDataHelper.HasFormat( SOT_FORMATSTR_ID_OBJECTDESCRIPTOR )
/*N*/ 				&& aDataHelper.HasFormat( SOT_FORMATSTR_ID_EMBED_SOURCE )));
/*N*/ 		}
/*N*/ 
/*N*/ 		SfxBindings& rBind = pView->GetViewFrame()->GetBindings();
/*N*/ 		rBind.Invalidate( SID_PASTE );
/*N*/ 	}
/*N*/ }

/*N*/ void SmClipboardChangeListener::AddRemoveListener( BOOL bAdd )
/*N*/ {
/*N*/ 	try
/*N*/ 	{
/*N*/ 		do {
/*N*/ 			Window* pW;
/*N*/ 			Reference< XClipboard > xClipboard;
/*N*/ 			if( pView && 0 != ( pW = pView->GetEditWindow()) )
/*N*/ 				xClipboard = pW->GetClipboard();
/*N*/ 			if( !xClipboard.is() )
/*N*/ 				break;
/*N*/ 
/*N*/ 			Reference< XClipboardNotifier > xClpbrdNtfr( xClipboard, UNO_QUERY );
/*N*/ 			if( xClpbrdNtfr.is() )
/*N*/ 			{
/*N*/ 				Reference< XClipboardListener >	xClipEvtLstnr( this );
/*N*/ 				if( bAdd )
/*N*/ 					xClpbrdNtfr->addClipboardListener( xClipEvtLstnr );
/*N*/ 				else
/*?*/ 					xClpbrdNtfr->removeClipboardListener( xClipEvtLstnr );
/*N*/ 			}
/*N*/ 		}  while ( FALSE );
/*N*/ 	}
/*N*/ 	catch( const ::com::sun::star::uno::Exception& )
/*N*/ 	{
/*N*/ 	}
/*N*/ }

// ------------------------- SmViewShell ---------------------

/*N*/ void SmViewShell::AddRemoveClipboardListener( BOOL bAdd )
/*N*/ {
/*N*/ 	if( bAdd && !xClipEvtLstnr.is() )
/*N*/ 	{
/*N*/ 		xClipEvtLstnr = pClipEvtLstnr = new SmClipboardChangeListener( *this );
/*N*/ 		pClipEvtLstnr->AddRemoveListener( TRUE );
/*N*/ 	}
/*N*/ 	else if( !bAdd && xClipEvtLstnr.is() )
/*N*/ 	{
/*N*/ 		pClipEvtLstnr->AddRemoveListener( FALSE );
/*N*/ 		pClipEvtLstnr->ViewDestroyed();
/*N*/ 	}
/*N*/ }



}
