/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_viewfrm.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:55:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <stdio.h>

// auto strip #include "viewfrm.hxx"

#ifndef _IPENV_HXX //autogen
#include <so3/ipenv.hxx>
#endif
// auto strip #ifndef _SPLITWIN_HXX //autogen
// auto strip #include <vcl/splitwin.hxx>
// auto strip #endif
// auto strip #ifndef _SFXINTITEM_HXX //autogen
// auto strip #include <svtools/intitem.hxx>
// auto strip #endif
#ifndef _SFXSTRITEM_HXX //autogen
#include <svtools/stritem.hxx>
#endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
// auto strip #ifndef _SFXSLSTITM_HXX //autogen
// auto strip #include <svtools/slstitm.hxx>
// auto strip #endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _UNDO_HXX //autogen
#include <svtools/undo.hxx>
#endif
// auto strip #ifndef _MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif
// auto strip #ifndef _SFXECODE_HXX
// auto strip #include <svtools/sfxecode.hxx>
// auto strip #endif
// auto strip #ifndef _EHDL_HXX
// auto strip #include <svtools/ehdl.hxx>
// auto strip #endif
// auto strip #ifndef _XCEPTION_HXX_
// auto strip #include <vos/xception.hxx>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAMESSUPPLIER_HPP_
// auto strip #include <com/sun/star/frame/XFramesSupplier.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
// auto strip #include <com/sun/star/frame/XFrame.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_AWT_XWINDOW_HPP_
// auto strip #include <com/sun/star/awt/XWindow.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
// auto strip #include <com/sun/star/frame/XController.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
// auto strip #include <com/sun/star/frame/XModel.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
// auto strip #include <com/sun/star/util/XURLTransformer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FRAME_XDISPATCHRECORDERSUPPLIER_HPP_
// auto strip #include <com/sun/star/frame/XDispatchRecorderSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DOCUMENT_MACROEXECMODE_HPP_
// auto strip #include <com/sun/star/document/MacroExecMode.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_DOCUMENT_UPDATEDOCMODE_HPP_
// auto strip #include <com/sun/star/document/UpdateDocMode.hpp>
// auto strip #endif

// auto strip #ifndef _RTL_USTRBUF_HXX_
// auto strip #include <rtl/ustrbuf.hxx>
// auto strip #endif

// auto strip #include <unotools/localfilehelper.hxx>
// auto strip #include <comphelper/processfactory.hxx>

#include <com/sun/star/uno/Reference.h>
#include <com/sun/star/ucb/XContent.hpp>

// auto strip #include <basic/basmgr.hxx>
// auto strip #include <basic/sbmod.hxx>
// auto strip #include <basic/sbmeth.hxx>
// auto strip #include <svtools/sbx.hxx>


using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::ucb;
using namespace ::com::sun::star::frame;

#pragma hdrstop

// auto strip #include "openflag.hxx"
#include "objshimp.hxx"
// auto strip #include "viewsh.hxx"
// auto strip #include "objsh.hxx"
// auto strip #include "bindings.hxx"
#include "dispatch.hxx"
#include "loadenv.hxx"
#include "arrdecl.hxx"
// auto strip #include "sfxtypes.hxx"
#include "newhdl.hxx"
#include "request.hxx"
// auto strip #include "docfac.hxx"
// auto strip #include "ipfrm.hxx"
// auto strip #include "sfxresid.hxx"
// auto strip #include "cfgmgr.hxx"
// auto strip #include "appbas.hxx"
// auto strip #include "objitem.hxx"
#include "viewfac.hxx"
// auto strip #include "stbmgr.hxx"
#include "event.hxx"
// auto strip #include "fltfnc.hxx"
// auto strip #include "fsetvwsh.hxx"
#include "fsetobsh.hxx"
#include "docfile.hxx"
#include "interno.hxx"
// auto strip #include "module.hxx"
// auto strip #include "msgpool.hxx"
#include "topfrm.hxx"
// auto strip #include "urlframe.hxx"
#include "fsetvwsh.hxx"
// auto strip #include "viewimp.hxx"
#include "sfxbasecontroller.hxx"
#include "sfx.hrc"
#include "view.hrc"
// auto strip #include "intfrm.hxx"
#include "frmdescr.hxx"
// auto strip #include "appdata.hxx"
// auto strip #include "sfxuno.hxx"
// auto strip #include "progress.hxx"
#include "workwin.hxx"
// auto strip #include "helper.hxx"

#ifndef _SVTOOLS_IMGDEF_HXX
#include <svtools/imgdef.hxx>
#endif

#include "tbxconf.hxx"
// auto strip #include "mnumgr.hxx"
// auto strip #include "virtmenu.hxx"
// auto strip #include "macro.hxx"
#include "tbxcust.hxx"

//STRIP002 #ifndef _LEGACYBINFILTERMGR_HXX
//STRIP002 #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
//STRIP002 #endif

//-------------------------------------------------------------------------
/*N*/ DBG_NAME(SfxViewFrame)

#define SfxViewFrame
namespace binfilter {
#include "sfxslots.hxx"

//-------------------------------------------------------------------------

/*N*/ SFX_IMPL_INTERFACE(SfxViewFrame,SfxShell,SfxResId(0))
/*N*/ {
/*N*/     SFX_CHILDWINDOW_REGISTRATION( SID_BROWSER );
/*N*/     SFX_CHILDWINDOW_REGISTRATION( SID_RECORDING_FLOATWINDOW );
/*N*/ }

/*N*/ TYPEINIT2(SfxViewFrame,SfxShell,SfxListener);
//STRIP001 TYPEINIT1(SfxViewFrameItem, SfxPoolItem);

//=========================================================================

struct SfxViewFrame_Impl
{
    SvBorder            aBorder;
    Size                aMargin;
    Size                aSize;
    String              aViewData;
    String              aFrameTitle;
    TypeId              aLastType;
	String				aActualURL;
	String				aActualPresentationURL;
    SfxFrame*           pFrame;
    SfxCancelManager*   pCancelMgr;
    svtools::AsynchronLink* pReloader;
	SfxInPlaceFrame*	pIPFrame;
	Window*				pWindow;
    SfxViewFrame*       pActiveChild;
    SfxViewFrame*       pParentViewFrame;
    SfxObjectShell*     pImportShell;
    Window*             pFocusWin;
    SfxMacro*           pMacro;
    SfxMenuBarManager*  pMenuBar;
    sal_uInt16          nDocViewNo;
    sal_uInt16          nCurViewId;
    sal_Bool            bResizeInToOut:1;
    sal_Bool            bDontOverwriteResizeInToOut:1;
    sal_Bool            bObjLocked:1;
    sal_Bool            bRestoreView:1;
    sal_Bool            bSetViewFrameLocked:1;
    sal_Bool            bReloading:1;
    sal_Bool            bIsDowning:1;
    sal_Bool            bInCtor:1;
    sal_Bool            bModal:1;
    sal_Bool            bEnabled:1;

                        SfxViewFrame_Impl()
                        : pReloader(0 )
                        , pMacro( 0 )
                        {}

                        ~SfxViewFrame_Impl()
                        {
                            delete pReloader;
                            delete pCancelMgr;
                        }
};

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetDowning_Impl()
/*N*/ {
/*N*/     pImp->bIsDowning = sal_True;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsDowning_Impl() const
/*N*/ {
/*N*/     return pImp->bIsDowning;
/*N*/ }


//-------------------------------------------------------------------------
//STRIP001 void SfxViewFrame::SetSetViewFrameAllowed_Impl( sal_Bool bSet )
//STRIP001 {
//STRIP001     pImp->bSetViewFrameLocked = !bSet;
//STRIP001 };

//-------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsSetViewFrameAllowed_Impl() const
/*N*/ {
/*N*/     return !pImp->bSetViewFrameLocked;
/*N*/ }

//-------------------------------------------------------------------------
//STRIP001 void SfxViewFrame::SetImportingObjectShell_Impl( SfxObjectShell* pSh )
//STRIP001 {
//STRIP001     pImp->pImportShell = pSh;
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 SfxObjectShell* SfxViewFrame::GetImportingObjectShell_Impl() const
//STRIP001 {
//STRIP001     return pImp->pImportShell;
//STRIP001 }


class SfxViewNotificatedFrameList_Impl :
    public SfxListener, public SfxViewFrameArr_Impl
{
public:

    void InsertViewFrame( SfxViewFrame* pFrame )
    {
        StartListening( *pFrame );
        C40_INSERT( SfxViewFrame, pFrame, Count() );
    }
//STRIP001     void Notify( SfxBroadcaster& rBC, const SfxHint& rHint );
};

//-------------------------------------------------------------------------
//STRIP001 void SfxViewNotificatedFrameList_Impl::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001     if ( rHint.IsA(TYPE(SfxSimpleHint)) )
//STRIP001     {
//STRIP001         switch( ( (SfxSimpleHint&) rHint ).GetId() )
//STRIP001         {
//STRIP001             case SFX_HINT_DYING:
//STRIP001                 SfxViewFrame* pFrame = (SfxViewFrame*) &rBC;
//STRIP001                 if( pFrame )
//STRIP001                 {
//STRIP001                     sal_uInt16 nPos = C40_GETPOS( SfxViewFrame, pFrame );
//STRIP001                     if( nPos != USHRT_MAX )
//STRIP001 						Remove( nPos );
//STRIP001                 }
//STRIP001                 break;
//STRIP001         }
//STRIP001     }
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 long ReloadDecouple_Impl( void* pObj, void* pArg )
//STRIP001 {
//STRIP001     ((SfxViewFrame*) pObj)->ExecReload_Impl( *(SfxRequest*)pArg );
//STRIP001     return 0;
//STRIP001 }

/*N*/ void SfxViewFrame::ExecReload_Impl( SfxRequest& rReq, sal_Bool bAsync )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	if( bAsync )
//STRIP001 	{
//STRIP001 		if( !pImp->pReloader )
//STRIP001             pImp->pReloader = new svtools::AsynchronLink(
//STRIP001 				Link( this, ReloadDecouple_Impl ) );
//STRIP001 		pImp->pReloader->Call( new SfxRequest( rReq ) );
//STRIP001 	}
//STRIP001 	else ExecReload_Impl( rReq );
/*N*/ }

/*N*/ void SfxViewFrame::ExecReload_Impl( SfxRequest& rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SfxFrame *pParent = GetFrame()->GetParentFrame();
//STRIP001 	if ( rReq.GetSlot() == SID_RELOAD )
//STRIP001 	{
//STRIP001         // Bei CTRL-Reload den aktiven Frame reloaden
//STRIP001         SfxViewFrame* pActFrame = this;
//STRIP001         while ( pActFrame )
//STRIP001             pActFrame = pActFrame->GetActiveChildFrame_Impl();
//STRIP001 
//STRIP001         if ( pActFrame )
//STRIP001         {
//STRIP001             sal_uInt16 nModifier = rReq.GetModifier();
//STRIP001             if ( nModifier & KEY_MOD1 )
//STRIP001             {
//STRIP001                 pActFrame->ExecReload_Impl( rReq );
//STRIP001                 return;
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001 		// Wenn nur ein Reload der Graphiken eines oder mehrerer ChildFrames
//STRIP001 		// gemacht werden soll
//STRIP001 		SfxFrame *pFrame = GetFrame();
//STRIP001 		if ( pParent == pFrame && pFrame->GetChildFrameCount() )
//STRIP001 		{
//STRIP001 			sal_Bool bReloadAvailable = sal_False;
//STRIP001 			SfxFrameIterator aIter( *pFrame, sal_False );
//STRIP001 			SfxFrame *pChild = aIter.FirstFrame();
//STRIP001 			while ( pChild )
//STRIP001 			{
//STRIP001 				SfxFrame *pNext = aIter.NextFrame( *pChild );
//STRIP001 				SfxObjectShell *pShell = pChild->GetCurrentDocument();
//STRIP001 				if( pShell && pShell->Get_Impl()->bReloadAvailable )
//STRIP001 				{
//STRIP001 					bReloadAvailable = sal_True;
//STRIP001 					pChild->GetCurrentViewFrame()->ExecuteSlot( rReq );
//STRIP001 				}
//STRIP001 				pChild = pNext;
//STRIP001 			}
//STRIP001 
//STRIP001 			// Der TopLevel-Frame selbst het keine Graphiken!
//STRIP001 			if ( bReloadAvailable )
//STRIP001 				return;
//STRIP001 		}
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // Bei CTRL-Edit den TopFrame bearbeiten
//STRIP001         sal_uInt16 nModifier = rReq.GetModifier();
//STRIP001 
//STRIP001         if ( ( nModifier & KEY_MOD1 ) && pParent )
//STRIP001         {
//STRIP001             SfxViewFrame *pTop = GetTopViewFrame();
//STRIP001             pTop->ExecReload_Impl( rReq );
//STRIP001             return;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     SfxObjectShell* pSh = GetObjectShell();
//STRIP001 	sal_Bool bWasReadonly = pSh->IsReadOnly();
//STRIP001 
//STRIP001     switch ( rReq.GetSlot() )
//STRIP001     {
//STRIP001         case SID_EDITDOC:
//STRIP001         {
//STRIP001 			if ( GetFrame()->HasComponent() )
//STRIP001 				break;
//STRIP001 
//STRIP001             // Wg. Doppeltbelegung in Toolboxen (mit/ohne Ctrl) ist es auch
//STRIP001             // m"oglich, da\s der Slot zwar enabled ist, aber Ctrl-Click
//STRIP001             // trotzdem nicht geht!
//STRIP001             if( !pSh || !pSh->HasName() || !(pSh->Get_Impl()->nLoadedFlags & SFX_LOADED_MAINDOCUMENT ))
//STRIP001                 break;
//STRIP001 
//STRIP001             SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pItem, SfxBoolItem, SID_VIEWONLY, sal_False );
//STRIP001         	if ( pItem && pItem->GetValue() )
//STRIP001 			{
//STRIP001                 SfxMedium* pMed = pSh->GetMedium();
//STRIP001 				SfxApplication* pApp = SFX_APP();
//STRIP001 				SfxAllItemSet aSet( pApp->GetPool() );
//STRIP001 				aSet.Put( SfxStringItem( SID_FILE_NAME, pMed->GetURLObject().GetMainURL(INetURLObject::NO_DECODE) ) );
//STRIP001 				aSet.Put( SfxBoolItem( SID_TEMPLATE, sal_True ) );
//STRIP001 				aSet.Put( SfxStringItem( SID_TARGETNAME, String::CreateFromAscii("_blank") ) );
//STRIP001                 SFX_ITEMSET_ARG( pMed->GetItemSet(), pReferer, SfxStringItem, SID_REFERER, sal_False );
//STRIP001 				if ( pReferer )
//STRIP001 					aSet.Put( *pReferer );
//STRIP001 		        SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pVersionItem, SfxInt16Item, SID_VERSION, sal_False );
//STRIP001 				if ( pVersionItem )
//STRIP001 					aSet.Put( *pVersionItem );
//STRIP001 
//STRIP001 				if( pMed->GetFilter() )
//STRIP001 				{
//STRIP001                     aSet.Put( SfxStringItem( SID_FILTER_NAME, pMed->GetFilter()->GetFilterName() ) );
//STRIP001 			        SFX_ITEMSET_ARG( pMed->GetItemSet(), pOptions, SfxStringItem, SID_FILE_FILTEROPTIONS, sal_False );
//STRIP001 					if ( pOptions )
//STRIP001 						aSet.Put( *pOptions );
//STRIP001 				}
//STRIP001 
//STRIP001                 GetDispatcher()->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001                 return;
//STRIP001 			}
//STRIP001 
//STRIP001             sal_uInt16 nOpenMode;
//STRIP001             sal_Bool bNeedsReload = sal_False;
//STRIP001             if ( !pSh->IsReadOnly() )
//STRIP001             {
//STRIP001                 // Speichern und Readonly Reloaden
//STRIP001                 if( pSh->IsModified() )
//STRIP001                 {
//STRIP001                     if ( !pSh->PrepareClose() )
//STRIP001                     {
//STRIP001                         rReq.SetReturnValue( SfxBoolItem( rReq.GetSlot(), sal_False ) );
//STRIP001                         return;
//STRIP001                     }
//STRIP001                     else bNeedsReload = sal_True;
//STRIP001                 }
//STRIP001                 nOpenMode = SFX_STREAM_READONLY;
//STRIP001             }
//STRIP001             else
//STRIP001                 nOpenMode = SFX_STREAM_READWRITE;
//STRIP001 
//STRIP001 			// Parameter auswerten
//STRIP001             // sal_Bool bReload = sal_True;
//STRIP001 			if ( rReq.IsAPI() )
//STRIP001 			{
//STRIP001 				// per API steuern ob r/w oder r/o
//STRIP001             	SFX_REQUEST_ARG(rReq, pEditItem, SfxBoolItem, SID_EDITDOC, sal_False);
//STRIP001 				if ( pEditItem )
//STRIP001 					nOpenMode = pEditItem->GetValue() ? SFX_STREAM_READWRITE : SFX_STREAM_READONLY;
//STRIP001 			}
//STRIP001 
//STRIP001 			// doing
//STRIP001             if( pSh  )
//STRIP001             {
//STRIP001                 SfxMedium* pMed = pSh->GetMedium();
//STRIP001                 String aTemp;
//STRIP001                 utl::LocalFileHelper::ConvertPhysicalNameToURL( pMed->GetPhysicalName(), aTemp );
//STRIP001                 INetURLObject aPhysObj( aTemp );
//STRIP001 		        SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(),
//STRIP001 								 pVersionItem, SfxInt16Item, SID_VERSION, sal_False );
//STRIP001 
//STRIP001 				INetURLObject aMedObj( pMed->GetName() );
//STRIP001 				if ( ( !bNeedsReload &&
//STRIP001                     ( aMedObj.GetProtocol() == INET_PROT_FILE
//STRIP001                             && aMedObj.getFSysPath(INetURLObject::FSYS_DETECT) == aPhysObj.getFSysPath(INetURLObject::FSYS_DETECT)
//STRIP001 							&& !SfxContentHelper::IsYounger( aPhysObj.GetMainURL( INetURLObject::NO_DECODE ),
//STRIP001 															 aMedObj.GetMainURL( INetURLObject::NO_DECODE ) )
//STRIP001 					  || pMed->IsRemote()
//STRIP001 					)
//STRIP001 				   ) || pVersionItem )
//STRIP001                 {
//STRIP001 					sal_Bool bOK = sal_False;
//STRIP001 					if ( !pVersionItem )
//STRIP001 					{
//STRIP001                     	// Umschalten ohne Reload ist moeglich
//STRIP001                     	pSh->DoHandsOff();
//STRIP001                     	pMed->Close();
//STRIP001                         pMed->GetItemSet()->Put( SfxBoolItem( SID_DOC_READONLY, !( nOpenMode & STREAM_WRITE ) ) );
//STRIP001                         pMed->SetOpenMode( nOpenMode, pMed->IsDirect() );
//STRIP001                     	pMed->ReOpen();
//STRIP001 						if ( !pMed->GetErrorCode() )
//STRIP001 							bOK = sal_True;
//STRIP001 					}
//STRIP001 
//STRIP001                     if( !bOK )
//STRIP001                     {
//STRIP001                         ErrCode nErr = pMed->GetErrorCode();
//STRIP001 						if ( pVersionItem )
//STRIP001 							nErr = ERRCODE_IO_ACCESSDENIED;
//STRIP001 						else
//STRIP001 						{
//STRIP001                         	pMed->ResetError();
//STRIP001                         	pMed->SetOpenMode( SFX_STREAM_READONLY, pMed->IsDirect() );
//STRIP001                         	pMed->ReOpen();
//STRIP001                         	pSh->DoSaveCompleted( pMed );
//STRIP001 						}
//STRIP001 
//STRIP001                         // r/o-Doc kann nicht in Editmode geschaltet werden?
//STRIP001                         rReq.Done( sal_False );
//STRIP001 
//STRIP001 			            SFX_REQUEST_ARG( rReq, pFSetItem, SfxBoolItem, SID_EDIT_FRAMESET, sal_False);
//STRIP001                         if ( nOpenMode == SFX_STREAM_READWRITE && !rReq.IsAPI() )
//STRIP001                         {
//STRIP001                             // dem ::com::sun::star::sdbcx::User anbieten, als Vorlage zu oeffnen
//STRIP001                             QueryBox aBox( &GetWindow(), SfxResId(MSG_QUERY_OPENASTEMPLATE) );
//STRIP001                             if ( !pFSetItem && RET_YES == aBox.Execute() )
//STRIP001                             {
//STRIP001 								SfxApplication* pApp = SFX_APP();
//STRIP001 								SfxAllItemSet aSet( pApp->GetPool() );
//STRIP001 								aSet.Put( SfxStringItem( SID_FILE_NAME, pMed->GetName() ) );
//STRIP001                                 SFX_ITEMSET_ARG( pMed->GetItemSet(), pReferer, SfxStringItem, SID_REFERER, sal_False );
//STRIP001 								if ( pReferer )
//STRIP001 									aSet.Put( *pReferer );
//STRIP001 								aSet.Put( SfxBoolItem( SID_TEMPLATE, sal_True ) );
//STRIP001 								if ( pVersionItem )
//STRIP001 									aSet.Put( *pVersionItem );
//STRIP001 
//STRIP001 								if( pMed->GetFilter() )
//STRIP001 								{
//STRIP001                                     aSet.Put( SfxStringItem( SID_FILTER_NAME, pMed->GetFilter()->GetFilterName() ) );
//STRIP001 			            			SFX_ITEMSET_ARG( pMed->GetItemSet(), pOptions,
//STRIP001 													 SfxStringItem, SID_FILE_FILTEROPTIONS, sal_False );
//STRIP001 									if ( pOptions )
//STRIP001 										aSet.Put( *pOptions );
//STRIP001 								}
//STRIP001 
//STRIP001                                 GetDispatcher()->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001                                 return;
//STRIP001                             }
//STRIP001                             else
//STRIP001 								nErr = 0;
//STRIP001                         }
//STRIP001 
//STRIP001                         ErrorHandler::HandleError( nErr );
//STRIP001                         rReq.SetReturnValue(
//STRIP001                             SfxBoolItem( rReq.GetSlot(), sal_False ) );
//STRIP001                         return;
//STRIP001                     }
//STRIP001                     else
//STRIP001                     {
//STRIP001                         pSh->DoSaveCompleted( pMed );
//STRIP001                         pSh->Broadcast( SfxSimpleHint(SFX_HINT_MODECHANGED) );
//STRIP001                         rReq.SetReturnValue( SfxBoolItem( rReq.GetSlot(), sal_True ) );
//STRIP001                         rReq.Done( sal_True );
//STRIP001                         if( nOpenMode == SFX_STREAM_READONLY )
//STRIP001                             pMed->Close();
//STRIP001 
//STRIP001 						// ReloadForEdit bei Framesets schaltet auch FramesetEditmode
//STRIP001 						sal_Bool bIsReadonly = GetObjectShell()->IsReadOnly();
//STRIP001 			            if ( bIsReadonly != bWasReadonly && !GetFrame()->GetParentFrame() )
//STRIP001 						{
//STRIP001 							SfxBoolItem aItem( SID_EDIT_FRAMESET, !bIsReadonly );
//STRIP001 			                GetDispatcher()->Execute( SID_EDIT_FRAMESET,
//STRIP001 									SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 						}
//STRIP001                         return;
//STRIP001                     }
//STRIP001                 }
//STRIP001 
//STRIP001 				/*
//STRIP001                 if ( !bReload )
//STRIP001                 {
//STRIP001                     // Es soll nicht reloaded werden
//STRIP001                     SfxErrorContext aEc( ERRCODE_SFX_NODOCRELOAD );
//STRIP001                     ErrorHandler::HandleError( ERRCODE_SFX_NODOCRELOAD );
//STRIP001                     rReq.SetReturnValue(
//STRIP001                         SfxBoolItem( rReq.GetSlot(), sal_False ) );
//STRIP001                     return;
//STRIP001                 }
//STRIP001 				*/
//STRIP001                 // Ansonsten ( lokal und arbeiten auf Kopie ) muss gereloaded
//STRIP001                 // werden.
//STRIP001             }
//STRIP001             SfxItemSet* pSet = pSh->GetMedium()->GetItemSet();
//STRIP001             pSet->Put( SfxBoolItem(
//STRIP001                 SID_DOC_READONLY, nOpenMode != SFX_STREAM_READWRITE ) );
//STRIP001             rReq.AppendItem( SfxBoolItem( SID_FORCERELOAD, sal_True) );
//STRIP001             rReq.AppendItem( SfxBoolItem( SID_SILENT, sal_True ));
//STRIP001         }
//STRIP001 
//STRIP001         case SID_RELOAD:
//STRIP001         {
//STRIP001             // Wg. Doppeltbelegung in Toolboxen (mit/ohne Ctrl) ist es auch
//STRIP001             // m"oglich, da\s der Slot zwar enabled ist, aber Ctrl-Click
//STRIP001             // trotzdem nicht geht!
//STRIP001             if ( !pSh || !pSh->CanReload_Impl() )
//STRIP001                 break;
//STRIP001             sal_uInt32 nErr = 0;
//STRIP001             SfxApplication* pApp = SFX_APP();
//STRIP001             SFX_REQUEST_ARG(rReq, pForceReloadItem, SfxBoolItem,
//STRIP001                             SID_FORCERELOAD, sal_False);
//STRIP001             if(  pForceReloadItem && !pForceReloadItem->GetValue() &&
//STRIP001                 !pSh->GetMedium()->IsExpired() )
//STRIP001                 return;
//STRIP001             if( pImp->bReloading || pSh->IsInModalMode() )
//STRIP001                 return;
//STRIP001 
//STRIP001             // AutoLoad ist ggf. verboten
//STRIP001             SFX_REQUEST_ARG(rReq, pAutoLoadItem, SfxBoolItem, SID_AUTOLOAD, sal_False);
//STRIP001             if ( pAutoLoadItem && pAutoLoadItem->GetValue() &&
//STRIP001                  GetFrame()->IsAutoLoadLocked_Impl() )
//STRIP001                 return;
//STRIP001 
//STRIP001             SfxObjectShellLock xOldObj( pSh );
//STRIP001             pImp->bReloading = sal_True;
//STRIP001             SFX_REQUEST_ARG(rReq, pURLItem, SfxStringItem,
//STRIP001                             SID_FILE_NAME, sal_False);
//STRIP001             // editierbar "offnen?
//STRIP001             sal_Bool bForEdit = !pSh->IsReadOnly();
//STRIP001             if ( rReq.GetSlot() == SID_EDITDOC )
//STRIP001                 bForEdit = !bForEdit;
//STRIP001 
//STRIP001             // ggf. beim User nachfragen
//STRIP001             sal_Bool bDo = GetViewShell()->PrepareClose();
//STRIP001             SFX_REQUEST_ARG(rReq, pSilentItem, SfxBoolItem, SID_SILENT, sal_False);
//STRIP001             if ( bDo && GetFrame()->DocIsModified_Impl() &&
//STRIP001 				 !rReq.IsAPI() && ( !pSilentItem || !pSilentItem->GetValue() ) )
//STRIP001             {
//STRIP001                 QueryBox aBox( &GetWindow(), ResId(MSG_QUERY_LASTVERSION) );
//STRIP001                 bDo = ( RET_YES == aBox.Execute() );
//STRIP001             }
//STRIP001 
//STRIP001             if ( bDo )
//STRIP001             {
//STRIP001                 SfxMedium *pMedium = xOldObj->GetMedium();
//STRIP001 
//STRIP001 				// Frameset abziehen, bevor FramesetView evtl. verschwindet
//STRIP001                 SFX_REQUEST_ARG(rReq, pNoCacheItem, SfxBoolItem, SID_NOCACHE, sal_False);
//STRIP001 				String aURL = pURLItem ? pURLItem->GetValue() :
//STRIP001 								pMedium->GetName();
//STRIP001 
//STRIP001 	            sal_uInt16 nModifier = rReq.GetModifier();
//STRIP001                 sal_Bool bHandsOff = pMedium->GetURLObject().GetProtocol() == INET_PROT_FILE;
//STRIP001 
//STRIP001                 // bestehende SfxMDIFrames f"ur dieses Doc leeren
//STRIP001                 // eigenes Format oder R/O jetzt editierbar "offnen?
//STRIP001                 SfxViewNotificatedFrameList_Impl aFrames;
//STRIP001                 SfxViewFrame *pView = GetFirst(xOldObj);
//STRIP001                 SfxObjectShellLock xNewObj;
//STRIP001                 sal_Bool bRestoreView = ( pURLItem == NULL );
//STRIP001                 TypeId aOldType = xOldObj->Type();
//STRIP001 
//STRIP001 				while(pView)
//STRIP001 				{
//STRIP001 					if( bHandsOff )
//STRIP001 						pView->GetDispatcher()->LockUI_Impl(sal_True);
//STRIP001 					aFrames.InsertViewFrame( pView );
//STRIP001 					pView->GetBindings().ENTERREGISTRATIONS();
//STRIP001 
//STRIP001 					// RestoreView nur wenn keine neue Datei geladen
//STRIP001 					// (Client-Pull-Reloading)
//STRIP001 					if( bHandsOff )
//STRIP001                     {
//STRIP001                         pView->pImp->pMenuBar = pView->GetViewShell()->GetMenuBar_Impl();
//STRIP001                         pView->GetViewShell()->ReleaseMenuBar_Impl();
//STRIP001 						pView->ReleaseObjectShell_Impl( bRestoreView );
//STRIP001                     }
//STRIP001 
//STRIP001 					pView = bHandsOff ? (SfxTopViewFrame*) GetFirst(
//STRIP001 						xOldObj, TYPE(SfxTopViewFrame) ) :
//STRIP001 						(SfxTopViewFrame*)GetNext( *pView, xOldObj,
//STRIP001 											   TYPE( SfxTopViewFrame ) );
//STRIP001 				}
//STRIP001 
//STRIP001                 DELETEZ( xOldObj->Get_Impl()->pReloadTimer );
//STRIP001 
//STRIP001                 // Medium mit angepa\stem Open-Mode
//STRIP001                 StreamMode nMode = bForEdit ? SFX_STREAM_READWRITE
//STRIP001                     : SFX_STREAM_READONLY;
//STRIP001 
//STRIP001                 SfxMedium *pNewMedium;
//STRIP001                 SfxItemSet* pNewSet = 0;
//STRIP001 				if( !pURLItem )
//STRIP001 				{
//STRIP001 					pNewSet = new SfxAllItemSet( *pMedium->GetItemSet() );
//STRIP001 					pNewSet->ClearItem( SID_VIEW_ID );
//STRIP001 					pNewSet->ClearItem( SID_USER_DATA );
//STRIP001 				}
//STRIP001 
//STRIP001                 const SfxObjectFactory* pFactory = 0;
//STRIP001 
//STRIP001 				// Wenn OrigURL mitkam nicht Filter verwenden, denn dann
//STRIP001 				// kann es sich um die sba Geschichten handeln.
//STRIP001                 SFX_ITEMSET_ARG( pNewSet, pOrigURL, SfxStringItem, SID_ORIGURL, sal_False);
//STRIP001                 sal_Bool bUseFilter = !pOrigURL && !pURLItem;
//STRIP001 
//STRIP001 				// Falls eine salvagede Datei vorliegt, nicht nochmals die
//STRIP001 				// OrigURL mitschicken, denn die Tempdate ist nach Reload
//STRIP001 				// ungueltig
//STRIP001                 SFX_ITEMSET_ARG( pNewSet, pSalvageItem, SfxStringItem, SID_DOC_SALVAGE, sal_False);
//STRIP001 
//STRIP001 				if( pSalvageItem && pOrigURL )
//STRIP001 				{
//STRIP001 					if( !pURLItem ) aURL = pOrigURL->GetValue();
//STRIP001 					pNewSet->ClearItem( SID_ORIGURL );
//STRIP001 					pNewSet->ClearItem( SID_DOC_SALVAGE );
//STRIP001 				}
//STRIP001 
//STRIP001                 pNewMedium = new SfxMedium(
//STRIP001                     aURL, nMode, pMedium->IsDirect(), bUseFilter ? pMedium->GetFilter() : 0, pNewSet );
//STRIP001 
//STRIP001                 pNewSet = pNewMedium->GetItemSet();
//STRIP001 				if ( pURLItem )
//STRIP001 				{
//STRIP001 					pNewSet->Put( SfxStringItem( SID_REFERER, pMedium->GetName() ) );
//STRIP001 				}
//STRIP001                 else
//STRIP001                     pNewSet->Put( SfxStringItem( SID_REFERER, String() ) );
//STRIP001 
//STRIP001                 SFX_REQUEST_ARG( rReq, pBindingItem, SfxRefItem, SID_BINDING, sal_False);
//STRIP001 				if( pBindingItem )
//STRIP001                     DBG_ERROR( "Not implemented!" );
//STRIP001 
//STRIP001                 xOldObj->CancelTransfers();
//STRIP001                 pNewMedium->SetUsesCache(
//STRIP001                     xOldObj->Get_Impl()->bReloadAvailable ||
//STRIP001                     pNoCacheItem && !pNoCacheItem->GetValue() );
//STRIP001 
//STRIP001                 // eigentliches Reload
//STRIP001                 pNewSet->Put( SfxFrameItem ( SID_DOCFRAME, GetFrame() ) );
//STRIP001                 pNewSet->Put( SfxBoolItem( SID_SILENT, sal_True ) );
//STRIP001 
//STRIP001 		        SFX_ITEMSET_ARG(pNewSet, pInteractionItem, SfxUnoAnyItem, SID_INTERACTIONHANDLER, FALSE);
//STRIP001 		        SFX_ITEMSET_ARG(pNewSet, pMacroExecItem  , SfxUInt16Item, SID_MACROEXECMODE     , FALSE);
//STRIP001 		        SFX_ITEMSET_ARG(pNewSet, pDocTemplateItem, SfxUInt16Item, SID_UPDATEDOCMODE     , FALSE);
//STRIP001 
//STRIP001 		        if (!pInteractionItem)
//STRIP001 		        {
//STRIP001 		            Reference < ::com::sun::star::task::XInteractionHandler > xHdl( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(::rtl::OUString::createFromAscii("com.sun.star.comp.uui.UUIInteractionHandler")), UNO_QUERY );
//STRIP001 		            if (xHdl.is())
//STRIP001 		                pNewSet->Put( SfxUnoAnyItem(SID_INTERACTIONHANDLER,::com::sun::star::uno::makeAny(xHdl)) );
//STRIP001 		        }
//STRIP001 
//STRIP001 		        if (!pMacroExecItem)
//STRIP001 		            pNewSet->Put( SfxUInt16Item(SID_MACROEXECMODE,::com::sun::star::document::MacroExecMode::USE_CONFIG) );
//STRIP001 		        if (!pDocTemplateItem)
//STRIP001 		            pNewSet->Put( SfxUInt16Item(SID_UPDATEDOCMODE,::com::sun::star::document::UpdateDocMode::ACCORDING_TO_CONFIG) );
//STRIP001 
//STRIP001                 LoadEnvironment_ImplRef xLoader =
//STRIP001 					new LoadEnvironment_Impl(
//STRIP001 						pNewMedium, GetFrame(),
//STRIP001 						LEI_DETECTFILTER | LEI_LOAD | LEI_CREATEVIEW, sal_False, sal_False );
//STRIP001 				xOldObj->SetModified( sal_False );
//STRIP001                 // Altes Dok nicht cachen! Gilt nicht, wenn anderes
//STRIP001 				// Doc geladen wird.
//STRIP001 
//STRIP001                 const SfxFilter *pSaveFilter = pNewMedium->GetFilter();
//STRIP001                 SfxItemSet* pSaveItemSet = pNewSet->Clone();
//STRIP001                 if( !pURLItem || pURLItem->GetValue() ==
//STRIP001 					xOldObj->GetMedium()->GetName() )
//STRIP001 					xOldObj->Get_Impl()->bForbidCaching = sal_True;
//STRIP001 
//STRIP001                 // Files schliessen, damit wir Reloaden koennen.
//STRIP001 				if( bHandsOff )
//STRIP001 					xOldObj->DoHandsOff();
//STRIP001 
//STRIP001                 xLoader->Start();
//STRIP001                 while( xLoader->GetState() != LoadEnvironment_Impl::DONE )
//STRIP001                     Application::Yield();
//STRIP001 
//STRIP001                 // hat reload nicht geklappt?
//STRIP001                 xNewObj = xLoader->GetObjectShell();
//STRIP001                 if( !xNewObj.Is() )
//STRIP001                 {
//STRIP001                     pNewMedium =  xLoader->GetMedium();
//STRIP001                     if( pNewMedium )
//STRIP001                         pNewMedium->Close();
//STRIP001 
//STRIP001                     // wieder auf das alte Medium zurueck
//STRIP001                     const SfxFilter* pOldFilter = xOldObj->GetMedium()->GetFilter();
//STRIP001 					if( bHandsOff )
//STRIP001 						xOldObj->DoSaveCompleted( xOldObj->GetMedium() );
//STRIP001 
//STRIP001                     // r/o-Doc kann nicht in Editmode geschaltet werden?
//STRIP001                     if ( bForEdit && SID_EDITDOC == rReq.GetSlot() )
//STRIP001                     {
//STRIP001                         // dem ::com::sun::star::sdbcx::User anbieten, als Vorlage zu oeffnen
//STRIP001                         QueryBox aBox( &GetWindow(), SfxResId(MSG_QUERY_OPENASTEMPLATE) );
//STRIP001                         if ( RET_YES == aBox.Execute() )
//STRIP001                         {
//STRIP001 							SfxAllItemSet aSet( pApp->GetPool() );
//STRIP001                             aSet.Put( SfxStringItem( SID_FILE_NAME, pMedium->GetName() ) );
//STRIP001                             SFX_ITEMSET_ARG( pSaveItemSet, pOptions, SfxStringItem, SID_FILE_FILTEROPTIONS, sal_False);
//STRIP001 							if ( pOptions )
//STRIP001 								aSet.Put( *pOptions );
//STRIP001                             SFX_ITEMSET_ARG( pSaveItemSet, pReferer, SfxStringItem, SID_REFERER, sal_False);
//STRIP001 							if ( pReferer )
//STRIP001 								aSet.Put( *pReferer );
//STRIP001 							aSet.Put( SfxBoolItem( SID_TEMPLATE, sal_True ) );
//STRIP001                             if( pSaveFilter )
//STRIP001                                 aSet.Put( SfxStringItem( SID_FILTER_NAME, pSaveFilter->GetFilterName() ) );
//STRIP001 
//STRIP001                             //MI: im selben Frame => er macht gar nix !?!
//STRIP001                             //SfxFrameItem aFrameItem( SID_DOCFRAME, GetFrame() );
//STRIP001                             GetDispatcher()->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001                         }
//STRIP001                     }
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// an error handling should be done here
//STRIP001 						if ( !pSilentItem || !pSilentItem->GetValue() )
//STRIP001 							ErrorHandler::HandleError( xLoader->GetError() );
//STRIP001 					}
//STRIP001                 }
//STRIP001 				else
//STRIP001                 {
//STRIP001 					xNewObj->GetMedium()->GetItemSet()->ClearItem( SID_RELOAD );
//STRIP001                 }
//STRIP001 
//STRIP001                 DELETEZ( pSaveItemSet );
//STRIP001 
//STRIP001                 SfxViewFrame* pThis = (SfxViewFrame*)this;
//STRIP001                 sal_Bool bDeleted = aFrames.C40_GETPOS( SfxViewFrame, pThis ) == USHRT_MAX;
//STRIP001 
//STRIP001                 if( !bDeleted )
//STRIP001                 {
//STRIP001 /*                    if( GetFrame()->GetLoadEnvironment_Impl() == &xLoader )
//STRIP001                         GetFrame()->SetLoadEnvironment_Impl( 0 );*/
//STRIP001 
//STRIP001                     GetBindings().Invalidate( SID_RELOAD );
//STRIP001                     pImp->bReloading = sal_False;
//STRIP001                 }
//STRIP001 
//STRIP001                 // neues Doc in die bestehenden SfxMDIFrames einsetzen; wenn
//STRIP001                 // das Reload geklappt hat, mu\s in diesem Frame kein Dokument
//STRIP001                 // eingesetzt werden, weil das schon vom LoadEnvironment
//STRIP001                 // gemacht wurde
//STRIP001 				if ( xNewObj.Is() && xNewObj->Type() != aOldType )
//STRIP001                 	// RestoreView nur, wenn gleicher Dokumenttyp
//STRIP001 					bRestoreView = sal_False;
//STRIP001 
//STRIP001                 DELETEZ( pImp->pMenuBar );
//STRIP001 
//STRIP001                 const sal_uInt16 nCount = aFrames.Count();
//STRIP001                 for(sal_uInt16 i = 0; i < nCount; ++i)
//STRIP001                 {
//STRIP001                     SfxViewFrame *pView = aFrames.GetObject( i );
//STRIP001 					if( !bHandsOff && this != pView   )
//STRIP001                     {
//STRIP001                         pView->pImp->pMenuBar = pView->GetViewShell()->GetMenuBar_Impl();
//STRIP001                         pView->GetViewShell()->ReleaseMenuBar_Impl();
//STRIP001 						pView->ReleaseObjectShell_Impl( bRestoreView );
//STRIP001                     }
//STRIP001 
//STRIP001                     pView->SetRestoreView_Impl( bRestoreView );
//STRIP001                     if( pView != this || !xNewObj.Is() )
//STRIP001                     {
//STRIP001                         SfxFrame *pFrame = pView->GetFrame();
//STRIP001                         pFrame->InsertDocument(xNewObj.Is() ? xNewObj : xOldObj );
//STRIP001                     }
//STRIP001 
//STRIP001                     DELETEZ( pView->pImp->pMenuBar );
//STRIP001 					pView->GetBindings().LEAVEREGISTRATIONS();
//STRIP001                     pView->GetDispatcher()->LockUI_Impl( sal_False );
//STRIP001                 }
//STRIP001 
//STRIP001                 // als erledigt recorden
//STRIP001                 rReq.Done( sal_True );
//STRIP001                 rReq.SetReturnValue(SfxBoolItem(rReq.GetSlot(), sal_True));
//STRIP001                 if( !bDeleted )
//STRIP001                 {
//STRIP001 					Notify( *GetObjectShell(), SfxSimpleHint(
//STRIP001                         SFX_HINT_TITLECHANGED ));
//STRIP001 
//STRIP001 					// ReloadForEdit bei Framesets schaltet auch FramesetEditmode
//STRIP001 					sal_Bool bIsReadonly = GetObjectShell()->IsReadOnly();
//STRIP001 					if ( bIsReadonly != bWasReadonly &&
//STRIP001 						 rReq.GetSlot() == SID_EDITDOC  && !GetFrame()->GetParentFrame() )
//STRIP001 					{
//STRIP001 						SfxBoolItem aItem( SID_EDIT_FRAMESET, !bIsReadonly );
//STRIP001 						GetDispatcher()->Execute( SID_EDIT_FRAMESET,
//STRIP001 												  SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 					}
//STRIP001 				}
//STRIP001                 return;
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 // als nicht erledigt recorden
//STRIP001                 rReq.Done();
//STRIP001                 rReq.SetReturnValue(SfxBoolItem(rReq.GetSlot(), sal_False));
//STRIP001                 pImp->bReloading = sal_False;
//STRIP001                 return;
//STRIP001             }
//STRIP001         }
//STRIP001     }
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateReload_Impl( SfxItemSet& rSet )
/*N*/ {
/*N*/     SfxObjectShell* pSh = GetObjectShell();
/*N*/ 	if ( !pSh )
/*N*/ 		// Ich bin gerade am Reloaden und Yielde so vor mich hin ...
/*N*/ 		return;
/*N*/ 
/*N*/     SfxFrame *pParent = GetFrame()->GetParentFrame();
/*N*/     SfxWhichIter aIter( rSet );
/*N*/     for ( sal_uInt16 nWhich = aIter.FirstWhich(); nWhich; nWhich = aIter.NextWhich() )
/*N*/     {
/*N*/ 		if ( GetFrame()->HasComponent() )
/*N*/ 		{
/*N*/ 			// Wenn die Komponente es nicht selbst dispatched, dann
/*N*/ 			// macht es auch keinen Sinn!
/*?*/ 			rSet.DisableItem( nWhich );
/*?*/ 			continue;
/*N*/ 		}
/*N*/ 
/*N*/         switch ( nWhich )
/*N*/         {
/*N*/             case SID_EDITDOC:
/*N*/             {
/*N*/ 		        if ( !pSh || !pSh->HasName() || !( pSh->Get_Impl()->nLoadedFlags &  SFX_LOADED_MAINDOCUMENT ) )
/*N*/ 		            rSet.DisableItem( SID_EDITDOC );
/*N*/ 		        else
/*N*/ 				{
/*N*/ 					SFX_ITEMSET_ARG( pSh->GetMedium()->GetItemSet(), pItem, SfxBoolItem, SID_EDITDOC, sal_False );
/*N*/ 					if ( pItem && !pItem->GetValue() )
/*N*/ 						rSet.DisableItem( SID_EDITDOC );
/*N*/ 					else
/*N*/ 						rSet.Put( SfxBoolItem( nWhich, !pSh->IsReadOnly() ) );
/*N*/ 				}
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SID_RELOAD:
/*N*/             {
/*?*/ 				DBG_BF_ASSERT(0, "STRIP"); //STRIP001 SfxFrame* pFrame = GetTopFrame();
//STRIP001 /*?*/ 				SfxViewFrame *pView = pFrame->GetCurrentViewFrame();
//STRIP001 /*?*/ 				if ( pView && pView->GetViewShell() &&
//STRIP001 /*?*/ 					pView->GetViewShell()->IsImplementedAsFrameset_Impl() &&
//STRIP001 /*?*/ 					pView->GetViewShell()->GetInterface()->GetSlot( nWhich ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// Hack f"ur Explorer: Reload wird an der ViewShell ausgef"uhrt
//STRIP001 /*?*/ 					pView->GetViewShell()->GetSlotState( nWhich, 0, &rSet );
//STRIP001 /*?*/ 					break;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				// Wenn irgendein ChildFrame reloadable ist, wird der Slot
//STRIP001 /*?*/ 				// enabled, damit man CTRL-Reload machen kann
//STRIP001 /*?*/ 				sal_Bool bReloadAvailable = sal_False;
//STRIP001 /*?*/ 				SfxFrameIterator aIter( *pFrame, sal_True );
//STRIP001 /*?*/ 				for( SfxFrame* pNextFrame = aIter.FirstFrame();
//STRIP001 /*?*/ 						pFrame;
//STRIP001 /*?*/ 						pNextFrame = pNextFrame ?
//STRIP001 /*?*/ 							aIter.NextFrame( *pNextFrame ) : 0 )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					SfxObjectShell *pShell = pFrame->GetCurrentDocument();
//STRIP001 /*?*/ 					if( pShell && pShell->Get_Impl()->bReloadAvailable )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						bReloadAvailable = sal_True;
//STRIP001 /*?*/ 						break;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					pFrame = pNextFrame;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 if ( !pSh || !pSh->CanReload_Impl() )
//STRIP001 /*?*/                     rSet.DisableItem(nWhich);
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                     rSet.Put( SfxBoolItem( nWhich, bReloadAvailable));
//STRIP001 /*?*/ 
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }


//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::ExecHistory_Impl( SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     // gibt es an der obersten Shell einen Undo-Manager?
//STRIP001     SfxShell *pSh = GetDispatcher()->GetShell(0);
//STRIP001     SfxUndoManager *pUndoMgr = pSh->GetUndoManager();
//STRIP001     sal_Bool bOK = sal_False;
//STRIP001     if ( pUndoMgr )
//STRIP001     {
//STRIP001         switch ( rReq.GetSlot() )
//STRIP001         {
//STRIP001             case SID_CLEARHISTORY:
//STRIP001                 pUndoMgr->Clear();
//STRIP001                 bOK = sal_True;
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_UNDO:
//STRIP001                 pUndoMgr->Undo(0);
//STRIP001                 GetBindings().InvalidateAll(sal_False);
//STRIP001                 bOK = sal_True;
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_REDO:
//STRIP001                 pUndoMgr->Redo(0);
//STRIP001                 GetBindings().InvalidateAll(sal_False);
//STRIP001                 bOK = sal_True;
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_REPEAT:
//STRIP001                 if ( pSh->GetRepeatTarget() )
//STRIP001                     pUndoMgr->Repeat( *pSh->GetRepeatTarget(), 0);
//STRIP001                 bOK = sal_True;
//STRIP001                 break;
//STRIP001         }
//STRIP001     }
//STRIP001     else if ( GetViewShell() )
//STRIP001     {
//STRIP001         // der SW hat eigenes Undo an der ::com::sun::star::sdbcx::View
//STRIP001         const SfxPoolItem *pRet = GetViewShell()->ExecuteSlot( rReq );
//STRIP001         if ( pRet )
//STRIP001             bOK = ((SfxBoolItem*)pRet)->GetValue();
//STRIP001     }
//STRIP001 
//STRIP001     rReq.SetReturnValue( SfxBoolItem( rReq.GetSlot(), bOK ) );
//STRIP001     rReq.Done();
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateHistory_Impl( SfxItemSet &rSet )
/*N*/ {
/*N*/     // Undo-Manager suchen
/*N*/     SfxShell *pSh = GetDispatcher()->GetShell(0);
/*N*/ 	if ( !pSh )
/*N*/ 		// Ich bin gerade am Reloaden und Yielde so vor mich hin ...
/*N*/ 		return;
/*N*/ 
/*N*/     SfxUndoManager *pUndoMgr = pSh->GetUndoManager();
/*N*/     if ( !pUndoMgr )
/*N*/     {
/*N*/         // der SW hat eigenes Undo an der ::com::sun::star::sdbcx::View
/*N*/         SfxWhichIter aIter( rSet );
/*N*/         SfxViewShell *pViewSh = GetViewShell();
/*N*/         if( !pViewSh ) return;
/*N*/         for ( sal_uInt16 nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/             pViewSh->GetSlotState( nSID, 0, &rSet );
/*N*/         return;
/*N*/     }
/*N*/ 
/*N*/     if ( pUndoMgr->GetUndoActionCount() == 0 &&
/*N*/          pUndoMgr->GetRedoActionCount() == 0 &&
/*N*/          pUndoMgr->GetRepeatActionCount() == 0 )
/*N*/         rSet.DisableItem( SID_CLEARHISTORY );
/*N*/ 
/*N*/     if ( pUndoMgr && pUndoMgr->GetUndoActionCount() )
/*N*/ 	{
/*N*/         String aTmp( SfxResId( STR_UNDO ) );
/*N*/ 		aTmp += pUndoMgr->GetUndoActionComment(0);
/*N*/ 		rSet.Put( SfxStringItem( SID_UNDO, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_UNDO );
/*N*/ 
/*N*/     if ( pUndoMgr && pUndoMgr->GetRedoActionCount() )
/*N*/ 	{
/*?*/         String aTmp( SfxResId(STR_REDO) );
/*?*/ 		aTmp += pUndoMgr->GetRedoActionComment(0);
/*?*/ 		rSet.Put( SfxStringItem( SID_REDO, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_REDO );
/*N*/     SfxRepeatTarget *pTarget = pSh->GetRepeatTarget();
/*N*/     if ( pUndoMgr && pTarget && pUndoMgr->GetRepeatActionCount() &&
/*N*/          pUndoMgr->CanRepeat(*pTarget, 0) )
/*N*/ 	{
/*N*/         String aTmp( SfxResId(STR_REPEAT) );
/*N*/ 		aTmp += pUndoMgr->GetRepeatActionComment(*pTarget, 0);
/*N*/ 		rSet.Put( SfxStringItem( SID_REPEAT, aTmp ) );
/*N*/ 	}
/*N*/     else
/*N*/         rSet.DisableItem( SID_REPEAT );
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::SetObjectShell_Impl
//STRIP001 (
//STRIP001     SfxObjectShell& rObjSh, // eine initialisierte SfxObjectShell,
//STRIP001     FASTBOOL        bDefaultView    // sal_True: nicht restaurieren
//STRIP001 )

/*  [Beschreibung]

    Diese Methode setzt eine <SfxObjectShell> in den SfxViewFrame ein.

    Zuvor mu\s die vorherige SfxObjectShell, insofern schein eine gesetzt
    wurde, mit der Methode ReleaseObjectShell() entfernt worden sein. Somit
    kann durch Aufruf von ReleaseObjectShell() und SetObjectShell() die
    SfxObjectShell ausgetauscht werden.


    [Querverweise]

    <SfxViewFrame::ReleaseObjectShell()>
*/

//STRIP001 {
//STRIP001     DBG_CHKTHIS(SfxViewFrame, 0);
//STRIP001     DBG_ASSERT( !xObjSh.Is(), "old feature used: only one Object per View!" );
//STRIP001 
//STRIP001     GetFrame()->ReleasingComponent_Impl( sal_False );
//STRIP001 
//STRIP001     // Doc einsetzen
//STRIP001     xObjSh = &rObjSh;
//STRIP001 	if ( xObjSh.Is() && xObjSh->IsPreview() )
//STRIP001 		SetQuietMode_Impl( sal_True );
//STRIP001 
//STRIP001     if ( rObjSh.IsA( TYPE( SfxFrameSetObjectShell ) ) )
//STRIP001         GetFrame()->SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
//STRIP001     else
//STRIP001         GetFrame()->SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
//STRIP001 
//STRIP001     // Modulshell einf"ugen
//STRIP001     SfxModule* pModule = xObjSh->GetModule();
//STRIP001     if( pModule )
//STRIP001         pDispatcher->InsertShell_Impl( *pModule, 1 );
//STRIP001 
//STRIP001     pDispatcher->Push( rObjSh );
//STRIP001     pDispatcher->Flush();
//STRIP001     StartListening( rObjSh );
//STRIP001 
//STRIP001     rObjSh.ViewAssigned();
//STRIP001     pDispatcher->SetReadOnly_Impl( rObjSh.IsReadOnly() );
//STRIP001 
//STRIP001 	const SfxMedium *pMedium = GetObjectShell()->GetMedium();
//STRIP001 	SFX_ITEMSET_ARG(
//STRIP001 		pMedium->GetItemSet(), pHiddenItem, SfxBoolItem, SID_HIDDEN, sal_False );
//STRIP001 	if ( !pHiddenItem || !pHiddenItem->GetValue() )
//STRIP001 	{
//STRIP001         LockObjectShell_Impl(sal_True);
//STRIP001 		GetDocNumber_Impl();
//STRIP001 	}
//STRIP001 
//STRIP001     // ::com::sun::star::sdbcx::View erzeugen
//STRIP001     if ( bDefaultView )
//STRIP001         SetRestoreView_Impl( sal_False );
//STRIP001 
//STRIP001 // So darf man es nicht machen, da LaodWindows hierueber laeuft. Kann meiner Meinung nach
//STRIP001 // auch nur beim Reload mit Dokumenttypwechsel passieren.
//STRIP001 /*    if ( xObjSh->Type() != pImp->aLastType )
//STRIP001         SetRestoreView_Impl( sal_False ); */
//STRIP001 
//STRIP001     SwitchToViewShell_Impl( !IsRestoreView_Impl() ? (sal_uInt16) 0 : GetCurViewId() );
//STRIP001 
//STRIP001     // was so in Activate passiert w"are
//STRIP001     SfxObjectShell *pDocSh = GetObjectShell();
//STRIP001 #if SUPD<635
//STRIP001     if ( SfxViewFrame::Current() == this )
//STRIP001     {
//STRIP001         // ggf. Config-Manager aktivieren
//STRIP001         SfxConfigManager *pCfgMgr = rObjSh.GetConfigManager();
//STRIP001         if ( pCfgMgr )
//STRIP001             pCfgMgr->Activate( SFX_CFGMANAGER() );
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	if ( !rObjSh.IsLoading() )
//STRIP001         rObjSh.PostActivateEvent_Impl();
//STRIP001 
//STRIP001     Notify( rObjSh, SfxSimpleHint(SFX_HINT_TITLECHANGED) );
//STRIP001     Notify( rObjSh, SfxSimpleHint(SFX_HINT_DOCCHANGED) );
//STRIP001 
//STRIP001 	// Zur Sicherheit, aber eigentlich sollte jetzt nichts mehr passieren
//STRIP001 	// ( kein erzwungenes Update )
//STRIP001 	if ( SfxViewFrame::Current() == this )
//STRIP001 		GetDispatcher()->Update_Impl();
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::ReleaseObjectShell_Impl( sal_Bool bStoreView )

/*  [Beschreibung]

    Diese Methode entleert den SfxViewFrame, d.h. nimmt die <SfxObjectShell>
    vom Dispatcher und beendet seine <SfxListener>-Beziehung zu dieser
    SfxObjectShell (wodurch sie sich ggf. selbst zerst"ort).

    Somit kann durch Aufruf von ReleaseObjectShell() und SetObjectShell()
    die SfxObjectShell ausgetauscht werden.

    Zwischen RealeaseObjectShell() und SetObjectShell() darf die Kontrolle
    nicht an das ::com::sun::star::chaos::System abgegeben werden.


    [Querverweise]

    <SfxViewFrame::SetObjectShell(SfxObjectShell&)>
*/
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     DBG_ASSERT( xObjSh.Is(), "no SfxObjectShell to release!" );
/*N*/ 
/*N*/ 	GetFrame()->ReleasingComponent_Impl( sal_True );
/*N*/ 	SfxViewShell *pDyingViewSh = GetViewShell();
/*N*/     pImp->aLastType = xObjSh->Type();
/*N*/ 
/*N*/     HACK(MI weiss nicht wie !pSh sein kann - nach PlugIns isses aber so)
/*N*/     if ( pDyingViewSh )
/*N*/     {
/*N*/         // Gibt es noch andere Views auf mein Doc?
/*N*/         SfxViewFrame *pView = GetFirst(xObjSh);
/*N*/         while( pView )
/*N*/         {
/*N*/             if ( pView != this )
/*N*/                 break;
/*N*/             pView = GetNext( *pView, xObjSh );
/*N*/         }
/*N*/ 
/*N*/         if ( !pView )
/*N*/         {
/*N*/             // Ich bin die letzte ::com::sun::star::sdbcx::View
/*N*/             SfxObjectFactory *pFactory = &xObjSh->GetFactory();
/*N*/             if ( pFactory && pFactory->GetFlags() & SFXOBJECTSHELL_HASOPENDOC )
/*N*/ 			{
/*N*/                 // Event nur bei echten Dokumenten
/*N*/ 				xObjSh->Get_Impl()->bInCloseEvent = sal_True;
/*N*/                 SFX_APP()->NotifyEvent( SfxEventHint(SFX_EVENT_CLOSEDOC, xObjSh) );
/*N*/ 				xObjSh->Get_Impl()->bInCloseEvent = sal_False;
/*N*/ 			}
/*N*/         }
/*N*/ 
/*N*/         SetRestoreView_Impl( bStoreView );
/*N*/         if ( bStoreView )
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pDyingViewSh->WriteUserData( GetViewData_Impl(), sal_True );
/*N*/ 
/*N*/ 	    // Falls es SubFrames gibt, m"ussen diese deleted werden, solange noch
/*N*/ 	    // die FramesetViewShell da ist, sonst gibt es Probleme.
/*N*/ 		// Um Flackern bei den Objectbars zu vermeiden, werden die SubFrames
/*N*/ 		// zerst"ort, solange die FrameSetView noch da ist.
/*N*/ 	    if ( pDyingViewSh->IsA( TYPE(SfxFrameSetViewShell) ) )
/*N*/ 	    {
/*?*/ 	        DBG_BF_ASSERT(0, "STRIP"); //STRIP001 Window *pWindow = pDyingViewSh->GetWindow();
//STRIP001 /*?*/ 	        if ( pWindow )
//STRIP001 /*?*/ 	            pWindow->Hide();
//STRIP001 /*?*/ 	        GetFrame()->CloseChildFrames();
/*N*/ 	    }
/*N*/ 
/*N*/         // Jetzt alle SubShells wechhauen
/*N*/ 		pDyingViewSh->PushSubShells_Impl( sal_False );
/*N*/         sal_uInt16 nLevel = pDispatcher->GetShellLevel( *pDyingViewSh );
/*N*/         if ( nLevel && nLevel != USHRT_MAX )
/*N*/         {
/*N*/             // Es gibt immer nocht SubShells
/*N*/             SfxShell *pSubShell = pDispatcher->GetShell( nLevel-1 );
/*N*/             if ( pSubShell == pDyingViewSh->GetSubShell() )
/*N*/                 //"Echte" Subshells nicht deleten
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL );
/*N*/             else
/*N*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL | SFX_SHELL_POP_DELETE );
/*N*/         }
/*N*/         pDispatcher->Pop( *pDyingViewSh );
/*N*/     }
/*N*/ #ifdef DBG_UTIL
/*N*/     else
/*N*/         DBG_ERROR("Keine Shell");
/*N*/ #endif
/*N*/ 
/*N*/     GetDispatcher()->Flush();
/*N*/ 
/*N*/ 	if ( GetWindow().HasChildPathFocus( sal_True ) )
/*N*/ 	{
/*N*/ 		DBG_ASSERT( !GetActiveChildFrame_Impl(), "Wrong active child frame!" );
/*N*/ 		GetWindow().GrabFocus();
/*N*/ 	}
/*N*/ 
/*N*/ 	pDyingViewSh->DisconnectClients_Impl( NULL );
/*N*/     SetViewShell_Impl(0);
/*N*/     delete pDyingViewSh;
/*N*/ 
/*N*/     pDispatcher->Pop( *xObjSh );
/*N*/     SfxModule* pModule = xObjSh->GetModule();
/*N*/     if( pModule )
/*N*/         pDispatcher->RemoveShell_Impl( *pModule );
/*N*/ 
/*N*/     pDispatcher->Flush();
/*N*/     EndListening( *xObjSh );
/*N*/     SFX_NOTIFY( *xObjSh, xObjSh->Type(),
/*N*/             SfxSimpleHint(SFX_HINT_TITLECHANGED),
/*N*/             TYPE(SfxSimpleHint) );
/*N*/ 
/*N*/     SFX_NOTIFY( *xObjSh, xObjSh->Type(),
/*N*/             SfxSimpleHint(SFX_HINT_DOCCHANGED),
/*N*/             TYPE(SfxSimpleHint) );
/*N*/ 
/*N*/     // Damit ::com::sun::star::script::JavaScript Objekte das ::com::sun::star::script::JavaScript ueber
/*N*/     // Frame->ViewFrame->DocShell->Medium bei CloseEvents besorgen koennen
/*N*/     SfxViewFrame* pFrame = SfxViewFrame::GetFirst( xObjSh, TYPE(SfxInPlaceFrame ) );
/*N*/     if ( 1 == xObjSh->GetOwnerLockCount() && pImp->bObjLocked && !pFrame )
/*N*/         xObjSh->DoClose();
/*N*/     SfxObjectShellRef xDyingObjSh = xObjSh;
/*N*/     xObjSh.Clear();
/*N*/     if( ( GetFrameType() & SFXFRAME_HASTITLE ) && pImp->nDocViewNo )
/*N*/         xDyingObjSh->GetNoSet_Impl().ReleaseIndex(pImp->nDocViewNo-1);
/*N*/     if ( pImp->bObjLocked )
/*N*/     {
/*N*/         xDyingObjSh->OwnerLock( sal_False );
/*N*/         pImp->bObjLocked = sal_False;
/*N*/     }
/*N*/ 
/*N*/ 	GetDispatcher()->SetDisableFlags( 0 );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ String SfxViewFrame::UpdateTitle()

/*  [Beschreibung]

    Mit dieser Methode kann der SfxMDIFrame gezwungen werden, sich sofort
    den neuen Titel vom der <SfxObjectShell> zu besorgen.

    [Anmerkung]

    Dies ist z.B. dann notwendig, wenn man der SfxObjectShell als SfxListener
    zuh"ort und dort auf den <SfxSimpleHint> SFX_HINT_TITLECHANGED reagieren
    m"ochte, um dann die Titel seiner Views abzufragen. Diese Views (SfxMDIFrames)
    jedoch sind ebenfalls SfxListener und da die Reihenfolge der Benachrichtigung
    nicht feststeht, mu\s deren Titel-Update vorab erzwungen werden.


    [Beispiel]

    void SwDocShell::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
    {
        if ( rHint.IsA(TYPE(SfxSimpleHint)) )
        {
            switch( ( (SfxSimpleHint&) rHint ).GetId() )
            {
                case SFX_HINT_TITLECHANGED:
                    for ( SfxMDIFrame *pMDI = (SfxMDIFrame*)
                                SfxViewFrame::GetFirst(this, TYPE(SfxMDIFrame));
                          pMDI;
                          pMDI = (SfxMDIFrame*)
                                SfxViewFrame::GetNext(this, TYPE(SfxMDIFrame));
                    {
                        pMDI->UpdateTitle();
                        ... pMDI->GetName() ...
                    }
                    break;
                ...
            }
        }
    }
*/

/*N*/ {
/*N*/     SfxObjectShell *pObjSh = GetObjectShell();
/*N*/ 	if ( !pObjSh )
/*N*/         return String();
/*N*/ 
/*N*/     if  ( pObjSh->GetInPlaceObject() && pObjSh->GetInPlaceObject()->GetProtocol().IsEmbed() )
/*N*/         // kein UpdateTitle mit Embedded-ObjectShell
/*N*/         return String();
/*N*/ 
/*N*/     const SfxMedium *pMedium = pObjSh->GetMedium();
/*N*/ 	String aURL;
/*N*/ 	SfxFrame *pFrm = GetFrame();
/*N*/     if ( pObjSh->HasName() )
/*N*/ 	{
/*N*/ 		INetURLObject aTmp( pMedium->GetName() );
/*N*/         aURL = aTmp.getName( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_WITH_CHARSET );
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( aURL != pImp->aActualURL )
/*N*/         // URL hat sich ge"andert
/*N*/ 		pImp->aActualURL = aURL;
/*N*/ 
/*N*/     // gibt es noch eine weitere View?
/*N*/     sal_uInt16 nViews=0;
/*N*/     for ( SfxViewFrame *pView= GetFirst(pObjSh);
/*N*/           pView && nViews<2;
/*N*/           pView = GetNext(*pView,pObjSh) )
/*N*/         if ( ( pView->GetFrameType() & SFXFRAME_HASTITLE ) &&
/*N*/              !IsDowning_Impl())
/*N*/             nViews++;
/*N*/ 
/*N*/     // Titel des Fensters
/*N*/     String aTitle;
/*N*/     if ( nViews == 2 || pImp->nDocViewNo > 1 )
/*N*/         // dann die Nummer dranh"angen
/*?*/         aTitle = pObjSh->UpdateTitle( NULL, pImp->nDocViewNo );
/*N*/     else
/*N*/         aTitle = pObjSh->UpdateTitle();
/*N*/ 
/*N*/     // Name des SbxObjects
/*N*/     String aSbxName = pObjSh->SfxShell::GetName();
/*N*/     if ( IsVisible() )
/*N*/     {
/*N*/         aSbxName += ':';
/*N*/         aSbxName += String::CreateFromInt32(pImp->nDocViewNo);
/*N*/     }
/*N*/ 
/*N*/     SetName( aSbxName );
/*N*/     pImp->aFrameTitle = aTitle;
/*N*/     GetBindings().Invalidate( SID_FRAMETITLE );
/*N*/     GetBindings().Invalidate( SID_CURRENT_URL );
/*N*/     return aTitle;
/*N*/ }


//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::Close()
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/     DBG_ASSERT( GetFrame()->IsClosing_Impl() || !GetFrame()->GetFrameInterface().is(), "ViewFrame closed too early!" );
/*N*/ 
/*N*/ 	// Wenn bis jetzt noch nicht gespeichert wurde, sollen eingebettete Objekte
/*N*/ 	// auch nicht mehr automatisch gespeichert werden!
/*N*/ 	if ( GetViewShell() )
/*N*/ 		GetViewShell()->DiscardClients_Impl();
/*N*/ 	Broadcast( SfxSimpleHint(SFX_HINT_DYING) );
/*N*/ 
/*N*/     return sal_True;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::DoActivate( sal_Bool bUI, SfxViewFrame* pOldFrame )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/ 
/*N*/ #ifdef WIN
/*N*/     pSfxApp->TestFreeResources_Impl();
/*N*/ #endif
/*N*/ 
/*N*/     pDispatcher->DoActivate_Impl( bUI );
/*N*/ 
/*N*/     // Wenn ich einen parent habe und dieser ist kein parent des alten
/*N*/     // ViewFrames, erh"alt er ein ParentActivate
/*N*/     if ( bUI )
/*N*/     {
/*
		SfxMedium* pMed = GetObjectShell() ? GetObjectShell()->GetMedium() : NULL;
		if( pMed )
		{
            SFX_ITEMSET_ARG(
                pMed->GetItemSet(), pInterceptorItem, SfxSlotInterceptorItem,
                SID_INTERCEPTOR, sal_False );
			if( pInterceptorItem )
			{
				SfxSlotInterceptor* pInter = pInterceptorItem->GetValue();
				if( !pInter->GetBindings() )
					pInter->SetBindings( &GetBindings() );
				pInter->Activate( sal_True );
			}
		}
 */
/*N*/         SfxViewFrame *pFrame = GetParentViewFrame();
/*N*/         while ( pFrame )
/*N*/         {
/*?*/             DBG_BF_ASSERT(0, "STRIP"); //STRIP001 if ( !pOldFrame || !pOldFrame->GetFrame()->IsParent( pFrame->GetFrame() ) )
//STRIP001 /*?*/                 pFrame->pDispatcher->DoParentActivate_Impl();
//STRIP001 /*?*/             pFrame = pFrame->GetParentViewFrame();
/*N*/         }
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::DoDeactivate(sal_Bool bUI, SfxViewFrame* pNewFrame )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     pDispatcher->DoDeactivate_Impl( bUI );
/*N*/ 
/*N*/     // Wenn ich einen parent habe und dieser ist kein parent des neuen
/*N*/     // ViewFrames, erh"alt er ein ParentDeactivate
/*N*/     if ( bUI )
/*N*/     {
/*N*/ //        if ( GetFrame()->GetWorkWindow_Impl() )
/*N*/ //            GetFrame()->GetWorkWindow_Impl()->SaveStatus_Impl();
/*
		SfxMedium* pMed = GetObjectShell() ? GetObjectShell()->GetMedium() : NULL;
		if( pMed )
		{
            SFX_ITEMSET_ARG(
                pMed->GetItemSet(), pInterceptorItem, SfxSlotInterceptorItem,
                SID_INTERCEPTOR, sal_False );
			if( pInterceptorItem )
				pInterceptorItem->GetValue()->Activate( sal_False );
		}
*/
/*N*/         SfxViewFrame *pFrame = GetParentViewFrame();
/*N*/         while ( pFrame )
/*N*/         {
/*N*/             if ( !pNewFrame || !pNewFrame->GetFrame()->IsParent( pFrame->GetFrame() ) )
/*N*/                 pFrame->pDispatcher->DoParentDeactivate_Impl();
/*N*/             pFrame = pFrame->GetParentViewFrame();
/*N*/         }
/*N*/     }
/*N*/ #ifdef WIN
/*N*/     pSfxApp->TestFreeResources_Impl();
/*N*/ #endif
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::InvalidateBorderImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh
/*N*/ )
/*N*/ 
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if( pSh && !nAdjustPosPixelLock )
//STRIP001     {
//STRIP001         //! Hack
//STRIP001         if ( ISA(SfxInPlaceFrame) )
//STRIP001             ((SfxInPlaceFrame*)this)->InvalidateBorderImpl( pSh );
//STRIP001         else if ( ISA(SfxTopViewFrame) )
//STRIP001             ((SfxTopViewFrame*)this)->InvalidateBorderImpl( pSh );
//STRIP001         else
//STRIP001             ((SfxInternalFrame*)this)->InvalidateBorderImpl( pSh );
//STRIP001     }
/*N*/ }

//------------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::SetBorderPixelImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh,
/*N*/     const SvBorder&     rBorder
/*N*/ )
/*N*/ 
/*N*/ {
/*N*/     pImp->aBorder = rBorder;
/*N*/     return sal_True;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ const SvBorder& SfxViewFrame::GetBorderPixelImpl
/*N*/ (
/*N*/     const SfxViewShell* pSh
/*N*/ )   const
/*N*/ 
/*N*/ {
/*N*/     return pImp->aBorder;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
/*N*/ {
/*N*/     {DBG_CHKTHIS(SfxViewFrame, 0);}
/*N*/     if ( !xObjSh.Is() )
/*N*/         return;
/*N*/ 
/*N*/     if ( rHint.IsA(TYPE(SfxSimpleHint)) )
/*N*/     {
/*N*/         switch( ( (SfxSimpleHint&) rHint ).GetId() )
/*N*/         {
/*N*/             case SFX_HINT_MODECHANGED:
/*N*/             {
/*N*/                 // r/o Umschaltung?
/*N*/                 SfxDispatcher *pDispat = GetDispatcher();
/*N*/                 sal_Bool bWasReadOnly = pDispat->GetReadOnly_Impl();
/*N*/                 sal_Bool bIsReadOnly = xObjSh->IsReadOnly();
/*N*/                 if ( !bWasReadOnly != !bIsReadOnly )
/*N*/             	{
/*?*/ 					// Dann auch TITLE_CHANGED
/*?*/ 					UpdateTitle();
/*?*/ 	                GetBindings().Invalidate( SID_FILE_NAME );
/*?*/ 	                GetBindings().Invalidate( SID_DOCINFO_TITLE );
/*?*/ 
/*?*/                     pDispat->GetBindings()->InvalidateAll(sal_True);
/*?*/                     pDispat->SetReadOnly_Impl( bIsReadOnly );
/*?*/ 
/*?*/ 					// Dispatcher-Update nur erzwingen, wenn es nicht sowieso
/*?*/ 					// demn"achst kommt, anderenfalls ist Zappelei oder gar
/*?*/ 					// GPF m"oglich, da Writer z.B. gerne mal im Resize irgendwelche
/*?*/ 					// Aktionen t"atigt, die ein SetReadOnlyUI am Dispatcher zur
/*?*/ 					// Folge haben!
/*?*/ 					if ( pDispat->IsUpdated_Impl() )
/*?*/                     	pDispat->Update_Impl(sal_True);
/*N*/                 }
/*N*/ 
/*N*/                 Enable( !xObjSh->IsInModalMode() );
/*N*/ 				break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_HINT_TITLECHANGED:
/*N*/             {
/*N*/ 				UpdateTitle();
/*N*/                 GetBindings().Invalidate( SID_FILE_NAME );
/*N*/                 GetBindings().Invalidate( SID_DOCINFO_TITLE );
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_HINT_DYING:
/*N*/             case SFX_HINT_DEINITIALIZING:
/*N*/                 // when the Object is being deleted, destroy the view too
/*?*/                 if ( xObjSh.Is() )
/*?*/                     ReleaseObjectShell_Impl();
/*?*/                 else
/*?*/                     GetFrame()->DoClose();
/*N*/                 break;
/*N*/ 
/*N*/         }
/*N*/     }
/*N*/     else if ( rHint.IsA(TYPE(SfxEventHint)) )
/*N*/     {
/*N*/         // Wenn das Document asynchron geladen wurde, wurde der Dispatcher
/*N*/         // auf ReadOnly gesetzt, was zur"ckgenommen werden mu\s, wenn
/*N*/         // das Document selbst nicht ReadOnly ist und das Laden fertig ist.
/*N*/         switch ( ((SfxEventHint&)rHint).GetEventId() )
/*N*/         {
/*N*/             case SFX_EVENT_MODIFYCHANGED:
/*N*/             {
/*N*/                 SfxBindings& rBind = GetBindings();
/*N*/                 rBind.Invalidate( SID_DOC_MODIFIED );
/*N*/                 rBind.Invalidate( SID_SAVEDOC );
/*N*/                 rBind.Invalidate( SID_RELOAD );
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_OPENDOC:
/*N*/             case SFX_EVENT_CREATEDOC:
/*N*/             {
/*N*/                 if ( !xObjSh->IsReadOnly() )
/*N*/                 {
/*N*/                     // Im Gegensatz zu oben (TITLE_CHANGED) mu\s das UI nicht
/*N*/                     // upgedated werden, da es nicht gehidet war!
/*N*/                     GetDispatcher()->GetBindings()->InvalidateAll(sal_True);
/*N*/                 }
/*N*/ 
/*N*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_LOADFINISHED:
/*N*/             {
/*N*/                 // Ein fertig geladenes Dokument kann das Event nicht selbst ausl"osen,
/*N*/                 // weil es nicht wei\s, ob schon eine ::com::sun::star::sdbcx::View erzeugt wurde
/*?*/                 xObjSh->PostActivateEvent_Impl();
/*?*/                 break;
/*N*/             }
/*N*/ 
/*N*/             case SFX_EVENT_TOGGLEFULLSCREENMODE:
/*N*/             {
/*?*/                 if ( GetFrame()->OwnsBindings_Impl() )
/*?*/                     GetBindings().GetDispatcher_Impl()->Update_Impl( sal_True );
/*?*/                 break;
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ #if 0	// (dv)
/*N*/ 	else if ( &rBC == (SfxBroadcaster*) (CntAnchor*) pImp->xAnchor )
/*N*/ 	{
/*N*/ 		CntAnchorHint* pCHint = PTR_CAST(CntAnchorHint, &rHint);
/*N*/ 		if ( pCHint )
/*N*/ 		{
/*N*/ 			CntAction eAction = pCHint->GetAction();
/*N*/ 			switch( eAction )
/*N*/ 			{
/*N*/ 				case CNT_ACTION_EXCHANGED :
/*N*/ 				{
/*N*/ 					SfxMedium* pMedium = GetObjectShell()->GetMedium();
/*N*/ 					pMedium->RefreshName_Impl();
/*N*/ 					Reference< XController >  xController =
/*N*/ 						GetFrame()->GetFrameInterface()->getController();
/*N*/ 					Reference< XModel >  xModel = xController->getModel();
/*N*/ 					if ( xModel.is() )
/*N*/ 						xModel->attachResource( S2U( pMedium->GetName() ), xModel->getArgs() );
/*N*/ 					UpdateTitle();
/*N*/                     pBindings->Invalidate( SID_CURRENT_URL, sal_True, sal_False );
/*N*/                     pBindings->Update( SID_CURRENT_URL );
/*N*/ 					break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ #endif	// (dv)
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::Construct_Impl( SfxObjectShell *pObjSh )
/*N*/ {
/*N*/     pImp->pFrame->DocumentInserted( pObjSh );
/*N*/     pImp->pMenuBar = NULL;
/*N*/     pImp->bInCtor = sal_True;
/*N*/     pImp->pParentViewFrame = 0;
/*N*/     pImp->bResizeInToOut = sal_True;
/*N*/     pImp->bDontOverwriteResizeInToOut = sal_False;
/*N*/     pImp->pImportShell = 0;
/*N*/     pImp->bObjLocked = sal_False;
/*N*/     pImp->pFocusWin = 0;
/*N*/     pImp->pActiveChild = NULL;
/*N*/     pImp->bRestoreView = sal_False;
/*N*/     pImp->nCurViewId = 0;
/*N*/     pImp->bSetViewFrameLocked = sal_False;
/*N*/     pImp->bReloading = sal_False;
/*N*/     pImp->bIsDowning = sal_False;
/*N*/     pImp->bModal = sal_False;
/*N*/     pImp->bEnabled = sal_True;
/*N*/     pImp->nDocViewNo = 0;
/*N*/     pImp->aMargin = Size( -1, -1 );
/*N*/     pImp->pCancelMgr = 0;
/*N*/ 	pImp->pWindow = 0;
/*N*/ 	pImp->pIPFrame = 0;
/*N*/ 
/*N*/ 	SetPool( &SFX_APP()->GetPool() );
/*N*/     pDispatcher = new SfxDispatcher(this);
/*N*/     if ( !GetBindings().GetDispatcher() )
/*N*/         GetBindings().SetDispatcher( pDispatcher );
/*N*/ 
/*N*/     xObjSh = pObjSh;
/*N*/ 	if ( xObjSh.Is() && xObjSh->IsPreview() )
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 SetQuietMode_Impl( sal_True );
/*N*/ 
/*N*/     if ( pObjSh && pObjSh->IsA( TYPE( SfxFrameSetObjectShell ) ) )
/*?*/         GetFrame()->SetFrameType_Impl( GetFrameType() | SFXFRAME_FRAMESET );
/*N*/     else
/*N*/         GetFrame()->SetFrameType_Impl( GetFrameType() & ~SFXFRAME_FRAMESET );
/*N*/ 
/*N*/     if ( pObjSh )
/*N*/     {
/*N*/         pDispatcher->Push( *SFX_APP() );
/*N*/         SfxModule* pModule = xObjSh->GetModule();
/*N*/         if( pModule )
/*N*/             pDispatcher->Push( *pModule );
/*N*/         pDispatcher->Push( *this );
/*N*/         pDispatcher->Push( *pObjSh );
/*N*/         pDispatcher->Flush();
/*N*/         StartListening( *pObjSh );
/*N*/         pObjSh->ViewAssigned();
/*N*/         Notify( *pObjSh, SfxSimpleHint(SFX_HINT_TITLECHANGED) );
/*N*/         Notify( *pObjSh, SfxSimpleHint(SFX_HINT_DOCCHANGED) );
/*N*/         pDispatcher->SetReadOnly_Impl( pObjSh->IsReadOnly() );
/*N*/     }
/*N*/     else
/*N*/     {
/*?*/         pDispatcher->Push( *SFX_APP() );
/*?*/         pDispatcher->Push( *this );
/*?*/         pDispatcher->Flush();
/*N*/     }
/*N*/ 
/*N*/     SfxViewFrame *pThis = this; // wegen der kranken Array-Syntax
/*N*/     SfxViewFrameArr_Impl &rViewArr = SFX_APP()->GetViewFrames_Impl();
/*N*/     rViewArr.C40_INSERT(SfxViewFrame, pThis, rViewArr.Count() );
/*N*/ 
/*N*/     pImp->bInCtor = sal_False;
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 SfxViewFrame::SfxViewFrame( SfxObjectShell &rObjShell, SfxBindings &rBindings,
//STRIP001 							SfxFrame* pParent, sal_uInt32 nType )
//STRIP001 :
//STRIP001     pImp( new SfxViewFrame_Impl ),
//STRIP001     pDispatcher(0),
//STRIP001     pBindings(&rBindings),
//STRIP001     nAdjustPosPixelLock( 0 )
//STRIP001 {
//STRIP001     DBG_CTOR(SfxViewFrame, 0);
//STRIP001 
//STRIP001     SetFrame_Impl( pParent );
//STRIP001     pImp->pFrame->SetCurrentViewFrame_Impl( this );
//STRIP001     GetFrame()->SetFrameType_Impl( GetFrameType() | nType );
//STRIP001     Construct_Impl( &rObjShell );
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 SfxViewFrame::SfxViewFrame(const SfxViewFrame &rCopy, SfxBindings &rBindings,
//STRIP001     SfxFrame *pFrame )
//STRIP001 :
//STRIP001     pImp( new SfxViewFrame_Impl ),
//STRIP001     pDispatcher(0),
//STRIP001     pBindings(&rBindings),
//STRIP001     nAdjustPosPixelLock( 0 )
//STRIP001 {
//STRIP001     DBG_CTOR(SfxViewFrame, 0);
//STRIP001 
//STRIP001     SetFrame_Impl( pFrame );
//STRIP001     pImp->pFrame->SetCurrentViewFrame_Impl( this );
//STRIP001     GetFrame()->SetFrameType_Impl( rCopy.GetFrameType() );
//STRIP001     Construct_Impl( rCopy.GetObjectShell() );
//STRIP001 }

/*N*/ SfxViewFrame::SfxViewFrame( SfxBindings& rBindings, SfxFrame *pFrame,
/*N*/         SfxObjectShell *pDoc, sal_uInt32 nType )
/*N*/     : pImp( new SfxViewFrame_Impl )
/*N*/     , pDispatcher(0)
/*N*/     , pBindings(&rBindings)
/*N*/     , nAdjustPosPixelLock( 0 )
/*N*/ {
/*N*/     DBG_CTOR(SfxViewFrame, 0);
/*N*/ 
/*N*/     SetFrame_Impl( pFrame );
/*N*/     pImp->pFrame->SetCurrentViewFrame_Impl( this );
/*N*/     GetFrame()->SetFrameType_Impl( GetFrameType() | nType );
/*N*/     Construct_Impl( pDoc);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxViewFrame::~SfxViewFrame()
/*N*/ {
/*N*/     DBG_DTOR(SfxViewFrame, 0);
/*N*/ 
/*N*/     if ( GetFrame() && GetFrame()->GetCurrentViewFrame() == this )
/*N*/         GetFrame()->SetCurrentViewFrame_Impl( NULL );
/*N*/ 
/*N*/     SfxObjectShell* pSh = pImp->pImportShell;
/*N*/     if( pSh )
/*?*/         pSh->AbortImport();
/*N*/ 
/*N*/     // von Frame-Liste abmelden
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/     const SfxViewFrame *pThis = this;
/*N*/     rFrames.Remove( rFrames.GetPos(pThis) );
/*N*/ 
/*N*/     // Member l"oschen
/*N*/     KillDispatcher_Impl();
/*N*/ 
/*N*/     SfxNewHdl::Get()->TryAllocBuffer();
/*N*/     delete pImp;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void SfxViewFrame::KillDispatcher_Impl()

// Dispatcher abr"aumen und l"oschen

/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/     SfxModule* pModule = xObjSh.Is() ? xObjSh->GetModule() : 0;
/*N*/     if ( xObjSh.Is() )
/*N*/         ReleaseObjectShell_Impl();
/*N*/     if ( pDispatcher )
/*N*/     {
/*N*/         if( pModule )
/*?*/ 			pDispatcher->Pop( *pModule, SFX_SHELL_POP_UNTIL );
/*N*/         else
/*N*/ 			pDispatcher->Pop( *this );
/*N*/         DELETEZ(pDispatcher);
/*N*/     }
/*N*/ }

//------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::Current()
/*N*/ {
/*N*/     return SFX_APP() ? SFX_APP()->GetViewFrame() : NULL;
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 sal_uInt16 SfxViewFrame::Count(TypeId aType)

/*  [Beschreibung]

    Liefert die Anzahl der sichtbaren <SfxViewFrame>-Instanzen vom Typ
    'aType' bzw. aller sichtbaren, falls 'aType==0' (default).
*/

//STRIP001 {
//STRIP001     SfxApplication *pSfxApp = SFX_APP();
//STRIP001     SfxViewFrameArr_Impl& rFrames = pSfxApp->GetViewFrames_Impl();
//STRIP001     const sal_uInt16 nCount = rFrames.Count();
//STRIP001     sal_uInt16 nFound = 0;
//STRIP001     for ( sal_uInt16 i = 0; i < nCount; ++i )
//STRIP001     {
//STRIP001         SfxViewFrame *pFrame = rFrames[i];
//STRIP001         if ( ( !aType || pFrame->IsA(aType) ) &&
//STRIP001              pFrame->IsVisible() )
//STRIP001             ++nFound;
//STRIP001     }
//STRIP001     return nFound;
//STRIP001 }

//--------------------------------------------------------------------
// returns the first window of spec. type viewing the specified doc.
/*N*/ SfxViewFrame* SfxViewFrame::GetFirst
/*N*/ (
/*N*/     const SfxObjectShell*   pDoc,
/*N*/     TypeId                  aType,
/*N*/     sal_Bool                    bOnlyIfVisible
/*N*/ )
/*N*/ {
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/ 
/*N*/     // search for a SfxDocument of the specified type
/*N*/     for ( sal_uInt16 nPos = 0; nPos < rFrames.Count(); ++nPos )
/*N*/     {
/*N*/         SfxViewFrame *pFrame = rFrames.GetObject(nPos);
/*N*/         if ( ( !pDoc || pDoc == pFrame->GetObjectShell() ) &&
/*N*/              ( !aType || pFrame->IsA(aType) ) &&
/*N*/              ( !bOnlyIfVisible || pFrame->IsVisible()) )
/*N*/             return pFrame;
/*N*/     }
/*N*/ 
/*N*/     return 0;
/*N*/ }
//--------------------------------------------------------------------

// returns thenext window of spec. type viewing the specified doc.
/*N*/ SfxViewFrame* SfxViewFrame::GetNext
/*N*/ (
/*N*/     const SfxViewFrame&     rPrev,
/*N*/     const SfxObjectShell*   pDoc,
/*N*/     TypeId                  aType,
/*N*/     sal_Bool                    bOnlyIfVisible
/*N*/ )
/*N*/ {
/*N*/     SfxApplication *pSfxApp = SFX_APP();
/*N*/     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
/*N*/ 
/*N*/     // refind the specified predecessor
/*N*/ 	sal_uInt16 nPos;
/*N*/     for ( nPos = 0; nPos < rFrames.Count(); ++nPos )
/*N*/         if ( rFrames.GetObject(nPos) == &rPrev )
/*N*/             break;
/*N*/ 
/*N*/     // search for a Frame of the specified type
/*N*/     for ( ++nPos; nPos < rFrames.Count(); ++nPos )
/*N*/     {
/*N*/         SfxViewFrame *pFrame = rFrames.GetObject(nPos);
/*N*/         if ( ( !pDoc || pDoc == pFrame->GetObjectShell() ) &&
/*N*/              ( !aType || pFrame->IsA(aType) ) &&
/*N*/              ( !bOnlyIfVisible || pFrame->IsVisible()) )
/*N*/             return pFrame;
/*N*/     }
/*N*/     return 0;
/*N*/ }

//STRIP001 void SfxViewFrame::CloseHiddenFrames_Impl()
//STRIP001 {
//STRIP001     SfxApplication *pSfxApp = SFX_APP();
//STRIP001     SfxViewFrameArr_Impl &rFrames = pSfxApp->GetViewFrames_Impl();
//STRIP001     for ( sal_uInt16 nPos=0; nPos<rFrames.Count(); )
//STRIP001     {
//STRIP001         SfxViewFrame *pFrame = rFrames.GetObject(nPos);
//STRIP001         if ( !pFrame->IsVisible() )
//STRIP001 			pFrame->DoClose();
//STRIP001 		else
//STRIP001 			nPos++;
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ SfxProgress* SfxViewFrame::GetProgress() const
/*N*/ {
/*N*/     SfxObjectShell *pObjSh = GetObjectShell();
/*N*/     return pObjSh ? pObjSh->GetProgress() : 0;
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::ShowStatusText( const String& rText)
//STRIP001 {
//STRIP001     SfxWorkWindow* pWorkWin = GetFrame()->GetWorkWindow_Impl();
//STRIP001     SfxStatusBarManager *pMgr = pWorkWin->GetStatusBarManager_Impl();
//STRIP001 	if ( pMgr )
//STRIP001 	{
//STRIP001 		pMgr->GetStatusBar()->HideItems();
//STRIP001 		pMgr->GetStatusBar()->SetText( rText );
//STRIP001 	}
//STRIP001 }

//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::HideStatusText()
//STRIP001 {
//STRIP001     SfxWorkWindow* pWorkWin = GetFrame()->GetWorkWindow_Impl();
//STRIP001     SfxStatusBarManager *pMgr = pWorkWin->GetStatusBarManager_Impl();
//STRIP001 	if ( pMgr )
//STRIP001 		pMgr->GetStatusBar()->ShowItems();
//STRIP001 }


//--------------------------------------------------------------------
#ifdef ENABLE_INIMANAGER//MUSTINI
SfxIniManager* SfxViewFrame::GetIniManager() const
{
/*  SfxIniManager *pIniMgr = GetObjectShell()
            ? GetObjectShell()->GetFactory().GetIniManager()
            : 0;
    if ( !pIniMgr )*/ //!
        return SFX_APP()->GetAppIniManager();
//  return pIniMgr;
}
#endif

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::DoAdjustPosSizePixel //! teilen in Inner.../Outer...
/*N*/ (
/*N*/     SfxViewShell*   pSh,
/*N*/     const Point&    rPos,
/*N*/     const Size&     rSize
/*N*/ )
/*N*/ {
/*N*/     DBG_CHKTHIS(SfxViewFrame, 0);
/*N*/ 
/*N*/ 	// Components benutzen diese Methode nicht!
/*N*/     if( pSh && pSh->GetWindow() && !nAdjustPosPixelLock )
/*N*/     {
/*N*/         nAdjustPosPixelLock++;
/*N*/         if ( pImp->bResizeInToOut )
/*?*/             {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pSh->InnerResizePixel( rPos, rSize );
/*N*/         else
/*N*/             pSh->OuterResizePixel( rPos, rSize );
/*N*/         nAdjustPosPixelLock--;
/*N*/     }
/*N*/ }

//========================================================================

/*N*/ int SfxViewFrameItem::operator==( const SfxPoolItem &rItem ) const
/*N*/ {
/*?*/      return PTR_CAST(SfxViewFrameItem, &rItem)->pFrame== pFrame;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ String SfxViewFrameItem::GetValueText() const
/*N*/ {
/*N*/     return String();
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 SfxPoolItem* SfxViewFrameItem::Clone( SfxItemPool *) const
//STRIP001 {
//STRIP001     return new SfxViewFrameItem( pFrame);
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetViewShell_Impl( SfxViewShell *pVSh )

/*  [Beschreibung]

    Interne Methode zum setzen der jeweils aktuellen <SfxViewShell>-Instanz,
    die in diesem SfxViewFrame aktiv ist.
*/

/*N*/ {
/*N*/     SfxShell::SetViewShell_Impl( pVSh );
/*N*/     if ( pVSh && !IsA(TYPE(SfxInPlaceFrame)) && !pVSh->UseObjectSize() )
/*N*/         pImp->bResizeInToOut = sal_False;
/*N*/ }

#if SUPD<604
//--------------------------------------------------------------------
//STRIP001 SfxViewShell* SfxViewFrame::GetViewShell() const

/*  [Beschreibung]

    Liefert, sofern existent, die zur Zeit in diesem SfxViewFrame aktive
    <SfxViewShell>. Dieser kann sich bei speziellen Multi-::com::sun::star::sdbcx::View-Frames
    von Zeit zu Zeit "ndern. Der R"uckgabewert ist nur im aktuellen
    Stack-Frame g"ultig.
*/

//STRIP001 {
//STRIP001     return SfxShell::GetViewShell();
//STRIP001 }
#endif

//--------------------------------------------------------------------
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des Containers bei internem InPlace
*/

//STRIP001 void SfxViewFrame::SetParentViewFrame_Impl(SfxViewFrame *pFrame)
//STRIP001 {
//STRIP001     pImp->pParentViewFrame = pFrame;
//STRIP001 }

//--------------------------------------------------------------------
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des Containers bei internem InPlace
*/

/*N*/ SfxViewFrame* SfxViewFrame::GetParentViewFrame_Impl() const
/*N*/ {
/*N*/     return pImp->pParentViewFrame;
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::ForceOuterResize_Impl(sal_Bool bOn)
//STRIP001 {
//STRIP001 	if ( !pImp->bDontOverwriteResizeInToOut )
//STRIP001     	pImp->bResizeInToOut = !bOn;
//STRIP001 }

/*?*/ void SfxViewFrame::ForceInnerResize_Impl(sal_Bool bOn)
/*?*/ {
/*?*/ 	pImp->bDontOverwriteResizeInToOut = bOn;
/*?*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsResizeInToOut_Impl() const
/*N*/ {
/*N*/     return pImp->bResizeInToOut;
/*N*/ }
//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::DoAdjustPosSize( SfxViewShell *pSh,
//STRIP001                                 const Point rPos, const Size &rSize )
//STRIP001 {
//STRIP001     DBG_CHKTHIS(SfxViewFrame, 0);
//STRIP001     if( pSh && !nAdjustPosPixelLock && pSh->UseObjectSize())
//STRIP001     {
//STRIP001         Window *pWindow = pSh->GetWindow();
//STRIP001         Point aPos = pWindow->LogicToPixel(rPos);
//STRIP001         Size aSize = pWindow->LogicToPixel(rSize);
//STRIP001         DoAdjustPosSizePixel(pSh, aPos, aSize);
//STRIP001     }
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::GetDocNumber_Impl()
/*N*/ {
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/     GetObjectShell()->SetNamedVisibility_Impl();
/*N*/     pImp->nDocViewNo = GetObjectShell()->GetNoSet_Impl().GetFreeIndex()+1;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::Enable( sal_Bool bEnable )
/*N*/ {
/*N*/     if ( bEnable != pImp->bEnabled )
/*N*/     {
/*N*/         pImp->bEnabled = bEnable;
/*N*/ 
/*N*/         // e.g. InPlace-Frames have a parent...
/*N*/         SfxViewFrame *pParent = GetParentViewFrame_Impl();
/*N*/         if ( pParent )
/*N*/         {
/*?*/             pParent->Enable( bEnable );
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             Window *pWindow = &GetFrame()->GetTopFrame()->GetWindow();
/*N*/             while ( !pWindow->IsSystemWindow() )
/*N*/                 pWindow = pWindow->GetParent();
/*N*/             pWindow->EnableInput( bEnable, TRUE );
/*N*/         }
/*N*/ 
/*N*/         // cursor and focus
/*N*/         SfxViewShell* pViewSh = GetViewShell();
/*N*/         if ( bEnable )
/*N*/         {
/*N*/             // show cursor
/*N*/             if ( pViewSh )
/*N*/                 pViewSh->ShowCursor();
/*N*/         }
/*N*/         else
/*N*/         {
/*N*/             // hide cursor
/*N*/             if ( pViewSh )
/*N*/                 pViewSh->ShowCursor(sal_False);
/*N*/         }
/*
        if ( !bEnable )
            GetBindings().ENTERREGISTRATIONS();
        GetDispatcher()->Lock( !bEnable );
        if ( bEnable )
            GetBindings().LEAVEREGISTRATIONS();
*/
/*N*/     }
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::Show()

/*  [Beschreibung]

    Diese Methode macht das Frame-Window sichtbar und ermittelt vorher
    den Fenstername. Au\serdem wird das Dokument festgehalten. Man darf
    i.d.R. nie das Window direkt showen!
*/

/*N*/ {
/*N*/     // zuerst locken damit in UpdateTitle() gilt: IsVisible() == sal_True (:#)
/*N*/     if ( xObjSh.Is() )
/*N*/     {
/*N*/         if ( !pImp->bObjLocked )
/*N*/             LockObjectShell_Impl( sal_True );
/*N*/ 
/*N*/         // Doc-Shell Titel-Nummer anpassen, get unique view-no
/*N*/         if ( 0 == pImp->nDocViewNo && !(GetFrameType() & SFXFRAME_PLUGIN ) )
/*N*/         {
/*N*/             GetDocNumber_Impl();
/*N*/             UpdateTitle();
/*N*/         }
/*N*/     }
/*N*/     else
/*?*/         UpdateTitle();
/*N*/ 
/*N*/     // Frame-Window anzeigen, aber nur wenn der ViewFrame kein eigenes Window
/*N*/ 	// hat oder wenn er keine Component enth"alt
/*N*/ 	if ( &GetWindow() == &GetFrame()->GetWindow() || !GetFrame()->HasComponent() )
/*N*/     	GetWindow().Show();
/*N*/ 
/*N*/     if ( GetFrame()->GetFrameInterface()->isActive() && SfxViewFrame::Current() != this && !GetActiveChildFrame_Impl() )
/*?*/         MakeActive_Impl( FALSE );
/*N*/ }

//--------------------------------------------------------------------
/*N*/ sal_Bool SfxViewFrame::IsVisible() const
/*N*/ {
/*N*/     Window *pWin = pImp->bInCtor ? 0 : &GetWindow();
/*N*/     return GetFrame()->HasComponent() || pImp->bObjLocked || ( pWin && pWin->IsVisible() );
/*N*/ }

//--------------------------------------------------------------------
//STRIP001 void SfxViewFrame::Hide()
//STRIP001 {
//STRIP001     GetWindow().Hide();
//STRIP001     if ( pImp->bObjLocked )
//STRIP001         LockObjectShell_Impl( sal_False );
//STRIP001 }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::LockObjectShell_Impl( sal_Bool bLock )
/*N*/ {
/*N*/     DBG_ASSERT( pImp->bObjLocked != bLock, "Falscher Locked-Status!" );
/*N*/ 
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/     GetObjectShell()->OwnerLock(bLock);
/*N*/     pImp->bObjLocked = bLock;
/*N*/ }

//--------------------------------------------------------------------
/*N*/ void SfxViewFrame::MakeActive_Impl( BOOL bGrabFocus )
/*N*/ {
/*N*/ 	if ( GetViewShell() && !GetFrame()->IsClosing_Impl() )
/*N*/ 	{
/*N*/         if ( IsVisible() )
/*N*/         {
/*N*/             if ( GetViewShell() )
/*N*/             {
/*N*/                 BOOL bPreview = FALSE;
/*N*/                 SfxApplication *pSfxApp = SFX_APP();
/*N*/                 if ( GetObjectShell()->IsPreview() )
/*N*/                 {
/*N*/                     bPreview = TRUE;
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*N*/                     SfxViewFrame* pParent = GetParentViewFrame();
/*N*/                     if ( pParent )
/*?*/                         {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 pParent->SetActiveChildFrame_Impl( this );
/*N*/                 }
/*N*/ 
/*N*/                 SfxViewFrame* pCurrent = SfxViewFrame::Current();
/*N*/                 if ( GetFrame()->GetFrameInterface()->isActive() || !bPreview && ( !pCurrent || bGrabFocus ) )
/*N*/                 {
/*N*/                     pSfxApp->SetViewFrame( this );
/*N*/                     GetBindings().SetActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
/*N*/                     if ( bGrabFocus )
/*N*/                     {
/*N*/                         SvInPlaceClient *pCli = GetViewShell()->GetIPClient();
/*N*/                         if ( ( !pCli || !pCli->GetProtocol().IsUIActive() ) &&
/*N*/                             ( !pCurrent || pCurrent->GetParentViewFrame_Impl() != this ) )
/*N*/                                 GetFrame()->GrabFocusOnComponent_Impl();
/*N*/                     }
/*N*/                 }
/*N*/                 else
/*N*/                 {
/*?*/                     GetBindings().SetDispatcher( GetDispatcher() );
/*?*/                     GetBindings().SetActiveFrame( ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > () );
/*?*/                     GetDispatcher()->Update_Impl( TRUE );
/*N*/                 }
/*N*/             }
/*N*/         }
/*N*/ 	}
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 SfxViewShell* SfxViewFrame::CreateView_Impl( sal_uInt16 nViewId )

/*  [Beschreibung]

    Erzeugt eine SfxViewShell f"ur diesen SfxViewFrame. Wird auch aus
    <SfxObjectShell::LoadWindows_Impl()>
    gerufen.
*/

//STRIP001 {
//STRIP001     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
//STRIP001 
//STRIP001     LockAdjustPosSizePixel();
//STRIP001 
//STRIP001     // passende ::com::sun::star::sdbcx::View-Factory suchen
//STRIP001     SfxObjectFactory &rDocFact = GetObjectShell()->GetFactory();
//STRIP001     sal_uInt16 nNewNo = nViewId ? USHRT_MAX : 0;
//STRIP001     for ( sal_uInt16 nNo = 0;
//STRIP001           nNo < rDocFact.GetViewFactoryCount();
//STRIP001           ++nNo )
//STRIP001     {
//STRIP001         sal_uInt16 nFoundId = rDocFact.GetViewFactory(nNo).GetOrdinal();
//STRIP001         if ( nNewNo == USHRT_MAX )
//STRIP001         {
//STRIP001             if ( nViewId == nFoundId )
//STRIP001                 nNewNo = nNo;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     // per Factory erzeugen
//STRIP001 	GetBindings().ENTERREGISTRATIONS();
//STRIP001     SfxViewFactory &rViewFactory = rDocFact.GetViewFactory( nNewNo );
//STRIP001     SfxViewShell *pViewShell = rViewFactory.CreateInstance(this, 0);
//STRIP001     SetViewShell_Impl(pViewShell);
//STRIP001     UnlockAdjustPosSizePixel();
//STRIP001 
//STRIP001 	if ( GetWindow().IsReallyVisible() )
//STRIP001     	DoAdjustPosSizePixel(pViewShell, Point(), GetWindow().GetOutputSizePixel());
//STRIP001 
//STRIP001     // erste jetzt anzeigen (ausser wenn MTs BASIC-IDE mal wieder keins hat)
//STRIP001     Window *pViewWin = pViewShell->GetWindow();
//STRIP001     if ( pViewWin && pViewShell->IsShowView_Impl() )
//STRIP001         pViewWin->Show();
//STRIP001 
//STRIP001     // Dispatcher
//STRIP001     GetDispatcher()->Push( *pViewShell );
//STRIP001     if ( pViewShell->GetSubShell() )
//STRIP001         GetDispatcher()->Push( *pViewShell->GetSubShell() );
//STRIP001 	pViewShell->PushSubShells_Impl();
//STRIP001 
//STRIP001 #if defined SFX_HINT_VIEWCREATED
//STRIP001 	GetObjectShell()->Broadcast( SfxSimpleHint( SFX_HINT_VIEWCREATED ) );
//STRIP001 #endif
//STRIP001 
//STRIP001 	GetBindings().LEAVEREGISTRATIONS();
//STRIP001     return pViewShell;
//STRIP001 }

//-------------------------------------------------------------------------
//STRIP001 SfxViewFrame* SfxViewFrame::SearchViewFrame( SfxViewFrame *pViewFrame,
//STRIP001     const String& rName )
//STRIP001 {
//STRIP001     if ( !pViewFrame )
//STRIP001         pViewFrame = SfxViewFrame::Current();
//STRIP001     if ( !pViewFrame )
//STRIP001         return NULL;
//STRIP001     SfxFrame *pFrame = pViewFrame->GetFrame()->SearchFrame( rName );
//STRIP001     if ( !pFrame )
//STRIP001         return NULL;
//STRIP001 
//STRIP001     // Der Frame ist selbst ein ViewFrame oder enth"alt einen
//STRIP001 /*
//STRIP001     pViewFrame = PTR_CAST( SfxViewFrame, pFrame );
//STRIP001     if ( !pViewFrame && pFrame->GetChildFrameCount() )
//STRIP001         pViewFrame = PTR_CAST( SfxViewFrame, pFrame->GetChildFrame(0) );
//STRIP001 */
//STRIP001     return pFrame->GetCurrentViewFrame();
//STRIP001 }

//-------------------------------------------------------------------------

//STRIP001 void SfxViewFrame::SetQuietMode_Impl( sal_Bool bOn )
//STRIP001 {
//STRIP001     GetDispatcher()->SetQuietMode_Impl( bOn );
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SfxObjectShell* SfxViewFrame::GetObjectShell()
/*N*/ {
/*N*/     return xObjSh;
/*N*/ }

//STRIP001 void SfxViewFrame::SetMargin_Impl( const Size& rMargin )
//STRIP001 {
//STRIP001     pImp->aMargin = rMargin;
//STRIP001 }

/*N*/ const Size& SfxViewFrame::GetMargin_Impl() const
/*N*/ {
/*N*/     return pImp->aMargin;
/*N*/ }

//STRIP001 void SfxViewFrame::SetActiveChildFrame_Impl( SfxViewFrame *pViewFrame )
//STRIP001 {
//STRIP001 	if ( pViewFrame != pImp->pActiveChild )
//STRIP001 	{
//STRIP001 	    if ( !pViewFrame )
//STRIP001 	    {
//STRIP001 	//!     if ( GetChildFrame(0) && GetViewShell() && GetViewShell()->IsA( TYPE(SfxFrameSetViewShell) ) )
//STRIP001 	//!         GetDispatcher()->LockUI_Impl();
//STRIP001 	    }
//STRIP001 	    else if ( !pImp->pActiveChild )
//STRIP001 	    {
//STRIP001 	        GetDispatcher()->LockUI_Impl( sal_False );
//STRIP001 	    }
//STRIP001 
//STRIP001 	    pImp->pActiveChild = pViewFrame;
//STRIP001 
//STRIP001 		Reference< XFramesSupplier > xFrame( GetFrame()->GetFrameInterface(), UNO_QUERY );
//STRIP001 		Reference< XFrame >  xActive;
//STRIP001 		if ( pViewFrame )
//STRIP001 			xActive = pViewFrame->GetFrame()->GetFrameInterface();
//STRIP001 
//STRIP001 		if ( xFrame.is() )	// PB: #74432# xFrame cann be NULL
//STRIP001 			xFrame->setActiveFrame( xActive );
//STRIP001 
//STRIP001 		if ( pViewFrame )
//STRIP001 		{
//STRIP001 			// Das n"achsth"ohere Frameset suchen, falls ich nicht selbst schon
//STRIP001 			// eines enthalte( der InternalFrame k"onnte auch zu einem FloatingFrame
//STRIP001 			// geh"oren ) und dort den Frame aktivieren, der letztlich pViewFrame
//STRIP001 			// enth"alt.
//STRIP001 			SfxFrame *pFrame = GetFrame();
//STRIP001 			do
//STRIP001 			{
//STRIP001 				SfxURLFrame *pURLFrame = PTR_CAST( SfxURLFrame, pFrame );
//STRIP001 				if ( pURLFrame && pURLFrame->GetFrameSet() )
//STRIP001 				{
//STRIP001 					pURLFrame->GetFrameSet()->SetActiveFrame( pURLFrame );
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				pFrame = pFrame->GetParentFrame();
//STRIP001 			}
//STRIP001 			while ( pFrame );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*N*/ SfxViewFrame* SfxViewFrame::GetActiveChildFrame_Impl() const
/*N*/ {
/*N*/     SfxViewFrame *pViewFrame = pImp->pActiveChild;
/*
    if ( !pViewFrame )
    {
        // Wenn es keinen aktiven ChildFrame gibt, irgendeinen nehmen
        for ( sal_uInt16 n=0; n<GetChildFrameCount(); n++ )
        {
            pViewFrame =
                PTR_CAST( SfxViewFrame, GetChildFrame(n)->GetChildFrame(0) );
            if ( pViewFrame )
                break;
        }
    }

    pImp->pActiveChild = pViewFrame;
*/
/*N*/     return pViewFrame;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ sal_Bool SfxViewFrame::SwitchToViewShell_Impl
/*N*/ (
    sal_uInt16  nViewId,        /*  > 0
                                Registrierungs-Id der ::com::sun::star::sdbcx::View, auf die umge-
                                schaltet werden soll, bzw. die erstmalig
                                erzeugt werden soll.

                                == 0
                                Es soll die Default-::com::sun::star::sdbcx::View verwendet werden. */

    sal_Bool    bIsIndex        /*  sal_True
                                'nViewId' ist keine Registrations-Id sondern
                                ein ::com::sun::star::sdbcx::Index in die f"ur die in diesem
                                <SfxViewFrame> dargestellte <SfxObjectShell>.
                                */
/*N*/ )

/*  [Beschreibung]

    Interne Methode zum Umschalten auf eine andere <SfxViewShell>-Subklasse,
    die in diesem SfxMDIFrame erzeugt werden soll. Existiert noch
    keine SfxViewShell in diesem SfxMDIFrame, so wird erstmalig eine
    erzeugt.


    [R"uckgabewert]

    sal_Bool                        sal_True
                                die angeforderte SfxViewShell wurde erzeugt
                                und eine ggf. bestehende gel"oscht

                                sal_False
                                die angeforderte SfxViewShell konnte nicht
                                erzeugt werden, die bestehende SfxViewShell
                                existiert daher weiterhin
*/

/*N*/ {
/*N*/     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
/*N*/ 
/*N*/     SfxObjectFactory &rDocFact = GetObjectShell()->GetFactory();
/*N*/ 
/*N*/     // die Indizes der neuen und alten ::com::sun::star::sdbcx::View-Shell finden
/*N*/     sal_uInt16 nOldNo = USHRT_MAX, nNewNo = USHRT_MAX;
/*N*/     bIsIndex |= 0 == nViewId;
/*N*/     for ( sal_uInt16 nNo = 0; nNo < rDocFact.GetViewFactoryCount(); ++nNo )
/*N*/     {
/*N*/         sal_uInt16 nFoundId = rDocFact.GetViewFactory(nNo).GetOrdinal();
/*N*/         if ( nNewNo == USHRT_MAX )
/*N*/         {
/*N*/             if ( bIsIndex && nViewId == nNo )
/*N*/             {
/*N*/                 nNewNo = nNo;
/*N*/                 nViewId = nFoundId; // fuer nViewId == 0
/*N*/             }
/*N*/             else if ( !bIsIndex && nViewId == nFoundId )
/*N*/                nNewNo = nNo;
/*N*/         }
/*N*/         if ( pImp->nCurViewId == nFoundId )
/*N*/             nOldNo = nNo;
/*N*/     }
/*N*/ 
/*N*/     if ( nNewNo == USHRT_MAX )
/*N*/ 	{
/*N*/ 		// Bei unbekannter Id die Dafault-Id nehmen
/*?*/         sal_uInt16 nFoundId = rDocFact.GetViewFactory(0).GetOrdinal();
/*?*/ 		nNewNo = 0;
/*?*/ 		nViewId = nFoundId;
/*?*/         if ( pImp->nCurViewId == nFoundId )
/*?*/             nOldNo = 0;
/*N*/ 	}
/*N*/ 
/*N*/     SfxViewShell *pSh = GetViewShell();
/*N*/ 
/*N*/     DBG_ASSERT( !pSh || nOldNo != USHRT_MAX, "old shell id not found" );
/*N*/ 
/*N*/     // existiert schon eine ViewShell?
/*N*/ 	sal_Bool bHasFocus = sal_False;
/*N*/     SfxViewShell *pOldSh = pSh;
/*N*/     if ( pOldSh )
/*N*/     {
/*?*/ 		if ( !bHasFocus )
/*?*/ 			bHasFocus = pOldSh->GetWindow() && pOldSh->GetWindow()->HasChildPathFocus( sal_True );
/*?*/ 
/*?*/         // dann diese schlie\sen
/*?*/         if ( !pOldSh->PrepareClose() )
/*?*/             return sal_False;
/*?*/ 
/*?*/         // Jetzt alle SubShells wechhauen
/*?*/ 		pOldSh->PushSubShells_Impl( sal_False );
/*?*/         sal_uInt16 nLevel = pDispatcher->GetShellLevel( *pOldSh );
/*?*/         if ( nLevel )
/*?*/         {
/*?*/             // Es gibt SubShells
/*?*/             SfxShell *pSubShell = pDispatcher->GetShell( nLevel-1 );
/*?*/             if ( pSubShell == pOldSh->GetSubShell() )
/*?*/                 //"Echte" Subshells nicht deleten
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL );
/*?*/             else
/*?*/                 pDispatcher->Pop( *pSubShell, SFX_SHELL_POP_UNTIL | SFX_SHELL_POP_DELETE );
/*?*/         }
/*?*/         pDispatcher->Pop( *pOldSh );
/*?*/         GetBindings().Invalidate( nOldNo + SID_VIEWSHELL0 );
/*N*/     }
/*N*/ 
/*N*/     // Id der neuen ViewShell eintragen
/*N*/     pImp->nCurViewId = nViewId;
/*N*/     GetBindings().Invalidate( nNewNo + SID_VIEWSHELL0 );
/*N*/ 
/*N*/     // neue ViewShell erzeugen
/*N*/     SfxViewFactory &rViewFactory = rDocFact.GetViewFactory( nNewNo );
/*N*/     LockAdjustPosSizePixel();
/*N*/ 
/*N*/ 	GetBindings().ENTERREGISTRATIONS();
/*N*/     pSh = rViewFactory.CreateInstance(this, pOldSh);
/*N*/     Window *pEditWin = pSh->GetWindow();
/*N*/     DBG_ASSERT( !pEditWin || !pEditWin->IsReallyVisible(), "don`t show your ViewShell`s Window by yourself!" );
/*N*/ 
/*N*/     // neue ViewShell in Frame einsetzen
/*N*/ 	GetDispatcher()->SetDisableFlags( 0 );
/*N*/     SetViewShell_Impl(pSh);
/*N*/ 
/*N*/     Reference < ::com::sun::star::awt::XWindow > xWindow(
/*N*/         GetFrame()->GetWindow().GetComponentInterface(), UNO_QUERY );
/*N*/     Reference < XFrame > xFrame( GetFrame()->GetFrameInterface() );
/*N*/     if ( !pSh->GetController().is() )
/*?*/         pSh->SetController( new SfxBaseController( pSh ) );
/*N*/     Reference < XController > xController( pSh->GetController() );
/*N*/     xFrame->setComponent( xWindow, xController );
/*N*/     xController->attachFrame( xFrame );
/*N*/     Reference < XModel > xModel( GetObjectShell()->GetModel() );
/*N*/     if ( xModel.is() )
/*N*/     {
/*N*/         xController->attachModel( xModel );
/*N*/         xModel->connectController( xController );
/*N*/         xModel->setCurrentController( xController );
/*N*/     }
/*N*/ 
/*N*/     GetDispatcher()->Push( *pSh );
/*N*/     if ( pSh->GetSubShell() )
/*?*/         GetDispatcher()->Push( *pSh->GetSubShell() );
/*N*/ 	pSh->PushSubShells_Impl();
/*N*/     GetDispatcher()->Flush();
/*N*/ 
/*N*/     // ggf. UserData restaurieren
/*N*/     if ( pImp->bRestoreView && pImp->aViewData.Len() )
/*N*/     {
/*?*/         DBG_BF_ASSERT(0, "STRIP"); //STRIP001 pSh->ReadUserData( pImp->aViewData, sal_True );
//STRIP001 /*?*/         pImp->bRestoreView = sal_False;
/*N*/     }
/*N*/ 
/*N*/ 	// Tools anordnen, bevor die Gr"os\se gesetzt wird
/*N*/ 	if ( SfxViewFrame::Current() == this )
/*?*/ 		GetDispatcher()->Update_Impl( sal_True );
/*N*/ 
/*N*/     // ggf. Resize ausl"osen
/*N*/     UnlockAdjustPosSizePixel();
/*N*/ 
/*N*/ 	Window* pFrameWin = &GetWindow();
/*N*/     if ( pFrameWin != &GetFrame()->GetWindow() )
/*N*/ 		pFrameWin->Show();
/*N*/ 
/*N*/     if ( GetWindow().IsReallyVisible() )
/*N*/         DoAdjustPosSizePixel( pSh, Point(), GetWindow().GetOutputSizePixel() );
/*N*/ 
/*N*/     if ( pEditWin && pSh->IsShowView_Impl() )
/*N*/     {
/*N*/         pEditWin->Show();
/*N*/ 		if ( bHasFocus )
/*?*/ 			GetFrame()->GrabFocusOnComponent_Impl();
/*N*/     }
/*N*/ 
/*N*/ 	GetBindings().LEAVEREGISTRATIONS();
/*N*/     delete pOldSh;
/*N*/     return sal_True;
/*N*/ }
//--------------------------------------------------------------------

//STRIP001 void SfxViewFrame::SetViewData_Impl( sal_uInt16 nViewId, const String &rViewData )
//STRIP001 {
//STRIP001     pImp->bRestoreView = sal_True;
//STRIP001     pImp->nCurViewId = nViewId;
//STRIP001     pImp->aViewData = rViewData;
//STRIP001 }

//-------------------------------------------------------------------------
//STRIP001 String& SfxViewFrame::GetViewData_Impl()
//STRIP001 {
//STRIP001     return pImp->aViewData;
//STRIP001 }

//-------------------------------------------------------------------------
//STRIP001 sal_Bool SfxViewFrame::IsRestoreView_Impl() const
//STRIP001 {
//STRIP001     return pImp->bRestoreView;
//STRIP001 }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetRestoreView_Impl( sal_Bool bOn )
/*N*/ {
/*N*/     pImp->bRestoreView = bOn;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ sal_uInt16 SfxViewFrame::GetCurViewId() const
/*N*/ {
/*N*/     return pImp->nCurViewId;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::ExecView_Impl
/*N*/ (
/*N*/     SfxRequest& rReq        // der auszuf"uhrende <SfxRequest>
/*N*/ )

/*  [Beschreibung]

    Interne Methode zum Ausf"uhren der f"ur die <SfxShell> Subklasse
    SfxViewFrame in der <SVIDL> beschriebenen Slots.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     DBG_CHKTHIS(SfxViewFrame, 0);
//STRIP001 
//STRIP001     // Wenn gerade die Shells ausgetauscht werden...
//STRIP001     if ( !GetObjectShell() || !GetViewShell() )
//STRIP001         return;
//STRIP001 
//STRIP001     switch ( rReq.GetSlot() )
//STRIP001     {
//STRIP001 #ifdef BASIC_HACKS
//STRIP001         case SID_HELP_STRING:
//STRIP001         {
//STRIP001             SFX_REQUEST_ARG( rReq, pItem, SfxUInt16Item, SID_CONFIGITEMID, sal_False );
//STRIP001             if ( pItem )
//STRIP001             {
//STRIP001                 sal_uInt16 nId = pItem->GetValue();
//STRIP001                 SfxModule *pMod = GetObjectShell()->GetModule();
//STRIP001                 SfxSlotPool* pPool = pMod ? pMod->GetSlotPool() : NULL;
//STRIP001                 if ( !pPool )
//STRIP001                     pPool = &SFX_APP()->GetSlotPool();
//STRIP001                 rReq.SetReturnValue( SfxStringItem( SID_HELP_STRING, pPool->GetSlotHelpText_Impl( nId ) ) );
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_METHODNAME:
//STRIP001         {
//STRIP001             SFX_REQUEST_ARG( rReq, pItem, SfxUInt16Item, SID_CONFIGITEMID, sal_False );
//STRIP001             if ( pItem )
//STRIP001             {
//STRIP001                 sal_uInt16 nId = pItem->GetValue();
//STRIP001                 SfxModule *pMod = GetObjectShell()->GetModule();
//STRIP001                 SfxSlotPool* pPool = pMod ? pMod->GetSlotPool() : NULL;
//STRIP001                 if ( !pPool )
//STRIP001                     pPool = &SFX_APP()->GetSlotPool();
//STRIP001                 rReq.SetReturnValue( SfxStringItem( SID_METHODNAME, pPool->GetSlotName_Impl( nId ) ) );
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_CONFIGITEMID:
//STRIP001         {
//STRIP001             SFX_REQUEST_ARG( rReq, pItem, SfxUInt16Item, SID_CONFIGITEMID, sal_False );
//STRIP001             if ( pItem )
//STRIP001             {
//STRIP001                 sal_uInt16 nId = pItem->GetValue();
//STRIP001                 SfxModule *pMod = GetObjectShell()->GetModule();
//STRIP001 /*
//STRIP001                 SfxSlotPool* pPool = pMod ? pMod->GetSlotPool() : NULL;
//STRIP001                 if ( !pPool )
//STRIP001                     pPool = &SFX_APP()->GetSlotPool();
//STRIP001                 const SfxSlot *pSlot = pPool->GetSlot( nId );
//STRIP001                 sal_Bool bRet = pSlot ? pSlot->IsMode( SFX_SLOT_TOOLBOXCONFIG ) : sal_False;
//STRIP001  */
//STRIP001                 SFX_IMAGEMANAGER()->StartCustomize();
//STRIP001                 Image aImage = SFX_IMAGEMANAGER()->GetImageFromModule_Impl( nId, pMod );
//STRIP001                 sal_Bool bRet = aImage.GetSizePixel().Width() != 0;
//STRIP001                 rReq.SetReturnValue( SfxBoolItem( SID_CONFIGITEMID, bRet ) );
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 #endif
//STRIP001 
//STRIP001         case SID_FILLFRAME:
//STRIP001         {
//STRIP001             // Bei Mail etc. k"onnen die Frames nicht angesprochen werden
//STRIP001             SfxFrame *pParent = GetFrame()->GetParentFrame();
//STRIP001             if ( pParent && pParent->GetCurrentViewFrame()->
//STRIP001                     GetViewShell()->IsImplementedAsFrameset_Impl() )
//STRIP001                 break;
//STRIP001 
//STRIP001             SfxViewFrame *pRet = NULL;
//STRIP001             SFX_REQUEST_ARG(
//STRIP001                 rReq, pItem, SfxStringItem, SID_FILLFRAME, sal_False );
//STRIP001             if ( pItem )
//STRIP001             {
//STRIP001                 String aName( pItem->GetValue() );
//STRIP001                 sal_uInt16 nFrame = (sal_uInt16) aName.ToInt32();
//STRIP001 				if ( nFrame == 0 )
//STRIP001 					nFrame = USHRT_MAX;
//STRIP001 
//STRIP001                 SfxFrameIterator aIter( *GetFrame(), sal_False );
//STRIP001                 SfxFrame *pFrame = aIter.FirstFrame();
//STRIP001                 sal_uInt16 nActFrame = 1;
//STRIP001                 while ( pFrame )
//STRIP001                 {
//STRIP001                     SfxViewFrame *pView = pFrame->GetCurrentViewFrame();
//STRIP001                     if ( nActFrame == nFrame || pView &&
//STRIP001 						 aName.CompareIgnoreCaseToAscii( pView->SfxShell::GetName() ) == COMPARE_EQUAL )
//STRIP001                     {
//STRIP001                         pRet = pView;
//STRIP001                         break;
//STRIP001                     }
//STRIP001 
//STRIP001                     pFrame = aIter.NextFrame( *pFrame );
//STRIP001                     nActFrame++;
//STRIP001                 }
//STRIP001             }
//STRIP001 
//STRIP001             rReq.SetReturnValue( SfxObjectItem( SID_DOCFRAME, pRet ) );
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_VIEWSHELL:
//STRIP001         {
//STRIP001             const SfxPoolItem *pItem = 0;
//STRIP001             if ( rReq.GetArgs() &&
//STRIP001                  SFX_ITEM_SET == rReq.GetArgs()->GetItemState( SID_VIEWSHELL, sal_False, &pItem ) )
//STRIP001                 rReq.SetReturnValue( SfxBoolItem(0, SwitchToViewShell_Impl(
//STRIP001                     (sal_uInt16)((const SfxUInt16Item*) pItem)->GetValue()) ));
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_VIEWSHELL0:
//STRIP001         case SID_VIEWSHELL1:
//STRIP001         case SID_VIEWSHELL2:
//STRIP001         case SID_VIEWSHELL3:
//STRIP001         case SID_VIEWSHELL4:
//STRIP001         {
//STRIP001             rReq.SetReturnValue( SfxBoolItem(0,
//STRIP001                 SwitchToViewShell_Impl( rReq.GetSlot() - SID_VIEWSHELL0, sal_True ) ) );
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         case SID_NEWWINDOW:
//STRIP001         {
//STRIP001             // Hack. demnaechst virtuelle Funktion
//STRIP001             if ( !GetViewShell()->NewWindowAllowed() && !GetObjectShell()->HasName() )
//STRIP001                 return;
//STRIP001 
//STRIP001 			// ViewData bei FrameSets rekursiv holen
//STRIP001 			GetFrame()->GetViewData_Impl();
//STRIP001 			SfxMedium *pMed = GetObjectShell()->GetMedium();
//STRIP001 			String aUserData;
//STRIP001 			GetViewShell()->WriteUserData( aUserData, sal_True );
//STRIP001 			if ( !GetViewShell()->NewWindowAllowed() )
//STRIP001 			{
//STRIP001                 SFX_REQUEST_ARG( rReq, pFrameItem, SfxUsrAnyItem, SID_FILLFRAME, sal_False );
//STRIP001                 SfxFrame *pFrame = NULL;
//STRIP001                 Reference < XFrame > xFrame;
//STRIP001                 if ( pFrameItem )
//STRIP001                 {
//STRIP001                     pFrameItem->GetValue() >>= xFrame;
//STRIP001                     pFrame = SfxTopFrame::Create( xFrame );
//STRIP001                 }
//STRIP001                 else
//STRIP001                     pFrame = SfxTopFrame::Create();
//STRIP001 
//STRIP001                 SfxAllItemSet aSet( SFX_APP()->GetPool() );
//STRIP001                 SFX_REQUEST_ARG( rReq, pHiddenItem, SfxBoolItem, SID_HIDDEN, sal_False );
//STRIP001                 if ( pHiddenItem )
//STRIP001                     aSet.Put( *pHiddenItem );
//STRIP001 
//STRIP001 				SFX_ITEMSET_ARG( pMed->GetItemSet(), pRefererItem, SfxStringItem, SID_REFERER, sal_False );
//STRIP001 				SfxStringItem aReferer( SID_REFERER, DEFINE_CONST_UNICODE( "private:user" ) );
//STRIP001 				if ( !pRefererItem )
//STRIP001 					pRefererItem = &aReferer;
//STRIP001 
//STRIP001 				aSet.Put( SfxStringItem( SID_FILE_NAME, pMed->GetName() ) );
//STRIP001 				aSet.Put( SfxStringItem( SID_USER_DATA, aUserData ) );
//STRIP001 				aSet.Put( SfxUInt16Item( SID_VIEW_ID, GetCurViewId() ) );
//STRIP001 				aSet.Put( *pRefererItem );
//STRIP001 				if( pMed->GetFilter() )
//STRIP001                     aSet.Put( SfxStringItem( SID_FILTER_NAME, pMed->GetFilter()->GetFilterName()) );
//STRIP001 				aSet.Put( SfxFrameItem ( SID_DOCFRAME, pFrame ) );
//STRIP001                 if ( xFrame.is() )
//STRIP001                     GetDispatcher()->Execute( SID_OPENDOC, SFX_CALLMODE_SYNCHRON, aSet );
//STRIP001                 else
//STRIP001                     GetDispatcher()->Execute( SID_OPENDOC, SFX_CALLMODE_ASYNCHRON, aSet );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				pMed->GetItemSet()->Put( SfxStringItem( SID_USER_DATA, aUserData ) );
//STRIP001 
//STRIP001                 SFX_REQUEST_ARG( rReq, pFrameItem, SfxUsrAnyItem, SID_FILLFRAME, sal_False );
//STRIP001                 if ( pFrameItem )
//STRIP001                 {
//STRIP001                 	Reference < XFrame > xFrame;
//STRIP001                     pFrameItem->GetValue() >>= xFrame;
//STRIP001                     SfxFrame* pFrame = SfxTopFrame::Create( xFrame );
//STRIP001 					pMed->GetItemSet()->ClearItem( SID_HIDDEN );
//STRIP001 					pFrame->InsertDocument( GetObjectShell() );
//STRIP001                 }
//STRIP001                 else
//STRIP001 				{
//STRIP001                 	BOOL bHidden = FALSE;
//STRIP001                 	SFX_REQUEST_ARG( rReq, pHiddenItem, SfxBoolItem, SID_HIDDEN, sal_False );
//STRIP001                 	if ( pHiddenItem )
//STRIP001                     	bHidden = pHiddenItem->GetValue();
//STRIP001 					SfxAllItemSet aSet( GetPool() );
//STRIP001 					aSet.Put( SfxBoolItem( SID_OPEN_NEW_VIEW, TRUE ) );
//STRIP001                 	SfxFrame* pFrame = SfxTopFrame::Create( GetObjectShell(), GetCurViewId(), bHidden, &aSet );
//STRIP001                 	if ( bHidden )
//STRIP001                     	pFrame->GetCurrentViewFrame()->LockObjectShell_Impl( TRUE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			rReq.Done();
//STRIP001             break;
//STRIP001         }
//STRIP001     }
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::StateView_Impl
/*N*/ (
    SfxItemSet&     rSet            /*  leeres <SfxItemSet> mit <Which-Ranges>,
                                        welche die Ids der zu erfragenden
                                        Slots beschreiben. */
/*N*/ )

/*  [Beschreibung]

    Diese interne Methode liefert in 'rSet' die Status der f"ur die
    <SfxShell> Subklasse SfxViewFrame in der <SVIDL> beschriebenen <Slots>.

    In 'rSet' sind dabei genau die vom SFx als ung"ultig erkannten
    Slot-Ids als Which-ranges enthalten. Falls der an dieser Shell gesetzte
    <SfxItemPool> f"ur einzelne Slot-Ids ein Mapping hat, werden die
    entsprechenden Which-Ids verwendet, so da\s Items ggf. direkt mit
    einer mit Which-Ids arbeitenden Core-::com::sun::star::script::Engine ausgetauscht werden
    k"onnen.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     DBG_CHKTHIS(SfxViewFrame, 0);
//STRIP001 
//STRIP001     SfxObjectShell *pDocSh = GetObjectShell();
//STRIP001 
//STRIP001     if ( !pDocSh )
//STRIP001 		// Ich bin gerade am Reloaden und Yielde so vor mich hin ...
//STRIP001         return;
//STRIP001 
//STRIP001     const sal_uInt16 *pRanges = rSet.GetRanges();
//STRIP001     DBG_ASSERT(pRanges, "Set ohne Bereich");
//STRIP001     while ( *pRanges )
//STRIP001     {
//STRIP001         for ( sal_uInt16 nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich )
//STRIP001         {
//STRIP001             switch(nWhich)
//STRIP001             {
//STRIP001                 case SID_VIEWSHELL:
//STRIP001                 {
//STRIP001                     rSet.Put( SfxUInt16Item( nWhich, pImp->nCurViewId ) );
//STRIP001                     break;
//STRIP001                 }
//STRIP001 
//STRIP001                 case SID_VIEWSHELL0:
//STRIP001                 case SID_VIEWSHELL1:
//STRIP001                 case SID_VIEWSHELL2:
//STRIP001                 case SID_VIEWSHELL3:
//STRIP001                 case SID_VIEWSHELL4:
//STRIP001                 {
//STRIP001                     sal_uInt16 nViewNo = nWhich - SID_VIEWSHELL0;
//STRIP001                     if ( GetObjectShell()->GetFactory().GetViewFactoryCount() >
//STRIP001                          nViewNo && !IsA( TYPE(SfxInPlaceFrame) ) )
//STRIP001                     {
//STRIP001                         SfxViewFactory &rViewFactory =
//STRIP001                             GetObjectShell()->GetFactory().GetViewFactory(nViewNo);
//STRIP001                         rSet.Put( SfxBoolItem(
//STRIP001                             nWhich, pImp->nCurViewId == rViewFactory.GetOrdinal() ) );
//STRIP001                     }
//STRIP001                     else
//STRIP001                         rSet.DisableItem( nWhich );
//STRIP001                     break;
//STRIP001                 }
//STRIP001                 case SID_FRAMETITLE:
//STRIP001                 {
//STRIP001                     if( GetFrameType() & SFXFRAME_HASTITLE )
//STRIP001                         rSet.Put( SfxStringItem(
//STRIP001                             SID_FRAMETITLE, pImp->aFrameTitle) );
//STRIP001                     else
//STRIP001                         rSet.DisableItem( nWhich );
//STRIP001                     break;
//STRIP001                 }
//STRIP001 
//STRIP001 		        case SID_NEWWINDOW:
//STRIP001 		        {
//STRIP001                     if ( !GetViewShell()->NewWindowAllowed() && !pDocSh->HasName() )
//STRIP001 							rSet.DisableItem( nWhich );
//STRIP001 					break;
//STRIP001 				}
//STRIP001             }
//STRIP001         }
//STRIP001     }
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::GetState_Impl( SfxItemSet &rSet )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     if ( GetViewShell() && GetViewShell()->GetVerbs() && !ISA( SfxInPlaceFrame ) )
//STRIP001         rSet.Put(SfxStringListItem(SID_OBJECT));
//STRIP001     else
//STRIP001         rSet.DisableItem( SID_OBJECT );
/*N*/ }

//-------------------------------------------------------------------------
//STRIP001 void SfxViewFrame::ToTop()
//STRIP001 {
//STRIP001     GetFrame()->Appear();
//STRIP001 }

//-------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::GetParentViewFrame() const
/*
    Beschreibung:
    Der ParentViewFrame ist der ViewFrame des ParentFrames
*/
/*N*/ {
/*N*/     SfxFrame *pFrame = GetFrame()->GetParentFrame();
/*N*/     return pFrame ? pFrame->GetCurrentViewFrame() : NULL;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxFrame* SfxViewFrame::GetFrame() const
/*
    Beschreibung:
    GetFrame liefert den Frame, in dem sich der ViewFrame befindet
*/
/*N*/ {
/*N*/     return pImp->pFrame;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ void SfxViewFrame::SetFrame_Impl( SfxFrame *pFrame )
/*N*/ {
/*N*/     pImp->pFrame = pFrame;
/*N*/ }

//-------------------------------------------------------------------------
/*N*/ SfxViewFrame* SfxViewFrame::GetTopViewFrame() const
/*N*/ {
/*N*/     return GetFrame()->GetTopFrame()->GetCurrentViewFrame();
/*N*/ }

//-------------------------------------------------------------------------
//STRIP001 String SfxViewFrame::GetHelpFile_Impl()
//STRIP001 {
//STRIP001     String aHelpFileName = GetObjectShell()->GetFactory().GetHelpFile();
//STRIP001 #ifndef TF_NEWDESKTOP
//STRIP001     DBG_ASSERT( GetObjectShell(), "Kein Dokument!" );
//STRIP001 	Reference< XController >  xController = GetFrame()->GetController();
//STRIP001 	if ( 0 == aHelpFileName.Len() && xController.is() )
//STRIP001 	{
//STRIP001 		if ( GetFrame()->GetFrameInterface()->findFrame(
//STRIP001 				DEFINE_CONST_UNICODE( "StructureView" ), FrameSearchFlag::ALL ).is() )
//STRIP001 			aHelpFileName = DEFINE_CONST_UNICODE( "desktop.hlp" );
//STRIP001 		else
//STRIP001         {
//STRIP001             Reference< ::com::sun::star::beans::XPropertySet > xProp( xController, UNO_QUERY );
//STRIP001             if ( xProp.is() )
//STRIP001             {
//STRIP001                 TRY
//STRIP001                 {
//STRIP001 					Any aAny = xProp->getPropertyValue( ::rtl::OUString::createFromAscii( "HelpFileName" ) );
//STRIP001 					::rtl::OUString sTemp ;
//STRIP001 					aAny >>= sTemp ;
//STRIP001                     aHelpFileName = String( sTemp );
//STRIP001                     return aHelpFileName;
//STRIP001                 }
//STRIP001                 CATCH_ALL()
//STRIP001                 {
//STRIP001                 }
//STRIP001                 END_CATCH;
//STRIP001             }
//STRIP001 
//STRIP001             aHelpFileName = DEFINE_CONST_UNICODE( "schedule.hlp" );
//STRIP001         }
//STRIP001 	}
//STRIP001 #endif
//STRIP001 
//STRIP001 	return aHelpFileName;
//STRIP001 }

//-------------------------------------------------------------------------

/*N*/ SfxCancelManager *SfxViewFrame::GetCancelManager() const

/*  <H3>Description</H3>

    Returns a pointer to the <SfxCancelManager> of the top-view-frame of
    this view-frame.
*/

/*N*/ {
/*N*/ 	return GetTopViewFrame()->GetFrame()->GetCancelManager();
/*N*/ }

/*N*/ void SfxViewFrame::SetWindow_Impl( Window *pWin )
/*N*/ {
/*N*/ 	pImp->pWindow = pWin;
/*N*/ }

/*N*/ Window& SfxViewFrame::GetWindow() const
/*N*/ {
/*N*/ 	return pImp->pWindow ? *pImp->pWindow : GetFrame()->GetWindow();
/*N*/ }

/*?*/ sal_Bool SfxViewFrame::DoClose()
/*?*/ {
/*?*/ 	DBG_BF_ASSERT(0, "STRIP"); return FALSE;//STRIP001 return GetFrame()->DoClose();
/*?*/ }

//STRIP001 void SfxViewFrame::SetIPFrame_Impl( SfxInPlaceFrame *pIPFrame )
//STRIP001 {
//STRIP001 	pImp->pIPFrame = pIPFrame;
//STRIP001 }

//STRIP001 SfxInPlaceFrame* SfxViewFrame::GetIPFrame_Impl() const
//STRIP001 {
//STRIP001 	return pImp->pIPFrame;
//STRIP001 }

/*N*/ String SfxViewFrame::GetActualPresentationURL_Impl() const
/*N*/ {
/*N*/ 	if ( xObjSh.Is() )
/*N*/ 		return xObjSh->GetMedium()->GetName();
/*?*/ 	return pImp->aActualPresentationURL;
/*N*/ }

//STRIP001 void SfxViewFrame::SetModalMode( sal_Bool bModal )
//STRIP001 {
//STRIP001     pImp->bModal = bModal;
//STRIP001     if ( xObjSh.Is() )
//STRIP001     {
//STRIP001         for ( SfxViewFrame* pFrame = SfxViewFrame::GetFirst( xObjSh );
//STRIP001 			  !bModal && pFrame; pFrame = SfxViewFrame::GetNext( *pFrame, xObjSh ) )
//STRIP001             bModal = pFrame->pImp->bModal;
//STRIP001         xObjSh->SetModalMode_Impl( bModal );
//STRIP001     }
//STRIP001 }

/*N*/ BOOL SfxViewFrame::IsInModalMode() const
/*N*/ {
/*N*/     return pImp->bModal || GetFrame()->GetWindow().IsInModalMode();
/*N*/ }

/*N*/ void SfxViewFrame::Resize( BOOL bForce )
/*N*/ {
/*N*/     Size aSize = GetWindow().GetOutputSizePixel();
/*N*/     if ( bForce || aSize != pImp->aSize )
/*N*/     {
/*N*/         pImp->aSize = aSize;
/*N*/         SfxViewShell *pShell = GetViewShell();
/*N*/         if ( pShell )
/*N*/         {
/*N*/             if ( pShell->UseObjectSize() )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(TRUE);
/*N*/             DoAdjustPosSizePixel( pShell, Point(), GetWindow().GetOutputSizePixel() );
/*N*/             if ( pShell->UseObjectSize() )
/*?*/                 {DBG_BF_ASSERT(0, "STRIP");} //STRIP001 ForceOuterResize_Impl(FALSE);
/*N*/             SfxViewFrame* pActFrame = this;
/*N*/             while ( pActFrame->GetActiveChildFrame_Impl() )
/*?*/                 pActFrame = pActFrame->GetActiveChildFrame_Impl();
/*N*/ 
/*N*/             // bugfix #86009#: release objectshell in internal frame causes resize, ViewShell already gone!
/*N*/             SvInPlaceClient *pCli = pActFrame->GetViewShell() ? pActFrame->GetViewShell()->GetIPClient() : NULL;
/*N*/             if ( pCli && pCli->GetProtocol().IsUIActive() )
/*N*/             {
/*?*/                 if ( !GetParentViewFrame() )
/*?*/                     pCli->GetEnv()->GetIPEnv()->DoTopWinResize();
/*?*/                 pCli->GetEnv()->GetIPEnv()->DoDocWinResize();
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ }

#define LINE_SEP 0x0A

//STRIP001 void CutLines( ::rtl::OUString& rStr, sal_Int32 nStartLine, sal_Int32 nLines, BOOL bEraseTrailingEmptyLines )
//STRIP001 {
//STRIP001 	sal_Int32 nStartPos = 0;
//STRIP001 	sal_Int32 nEndPos = 0;
//STRIP001 	sal_Int32 nLine = 0;
//STRIP001 	while ( nLine < nStartLine )
//STRIP001 	{
//STRIP001         nStartPos = rStr.indexOf( LINE_SEP, nStartPos );
//STRIP001         if( nStartPos == -1 )
//STRIP001             break;
//STRIP001 		nStartPos++;	// nicht das \n.
//STRIP001 		nLine++;
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERTWARNING( nStartPos != STRING_NOTFOUND, "CutLines: Startzeile nicht gefunden!" );
//STRIP001 
//STRIP001 	if ( nStartPos != -1 )
//STRIP001 	{
//STRIP001 		nEndPos = nStartPos;
//STRIP001 		for ( sal_Int32 i = 0; i < nLines; i++ )
//STRIP001 			nEndPos = rStr.indexOf( LINE_SEP, nEndPos+1 );
//STRIP001 
//STRIP001 		if ( nEndPos == -1 ) // kann bei letzter Zeile passieren
//STRIP001 			nEndPos = rStr.getLength();
//STRIP001         else
//STRIP001 			nEndPos++;
//STRIP001 
//STRIP001         ::rtl::OUString aEndStr = rStr.copy( nEndPos );
//STRIP001         rStr = rStr.copy( 0, nStartPos );
//STRIP001         rStr += aEndStr;
//STRIP001 	}
//STRIP001 	if ( bEraseTrailingEmptyLines )
//STRIP001 	{
//STRIP001 		sal_Int32 n = nStartPos;
//STRIP001 		sal_Int32 nLen = rStr.getLength();
//STRIP001 		while ( ( n < nLen ) && ( rStr.getStr()[ n ] == LINE_SEP ) )
//STRIP001 			n++;
//STRIP001 
//STRIP001 		if ( n > nStartPos )
//STRIP001         {
//STRIP001             ::rtl::OUString aEndStr = rStr.copy( n );
//STRIP001             rStr = rStr.copy( 0, nStartPos );
//STRIP001             rStr += aEndStr;
//STRIP001         }
//STRIP001 	}
//STRIP001 }

/*
    add new recorded dispatch macro script into the application global basic lib container
    It generates a new unique id for it and insert the macro by using this number as name for
    the modul
 */
//STRIP001 void SfxViewFrame::AddDispatchMacroToBasic_Impl( const ::rtl::OUString& sMacro )
//STRIP001 {
//STRIP001     /*
//STRIP001     // get lib and modul name from dialog
//STRIP001     SfxModule *pMod = GetObjectShell()->GetModule();
//STRIP001     SfxRequest aReq( SID_BASICCHOOSER, SFX_CALLMODE_SYNCHRON, pMod->GetPool() );
//STRIP001     const SfxPoolItem* pRet = pMod->ExecuteSlot( aReq );
//STRIP001     if ( pRet )
//STRIP001         ::rtl::OUString = ((SfxStringItem*)pRet)->GetValue();
//STRIP001     */
//STRIP001     if ( !sMacro.getLength() )
//STRIP001         return;
//STRIP001 
//STRIP001     SfxApplication* pSfxApp = SFX_APP();
//STRIP001     SfxRequest aReq( SID_BASICCHOOSER, SFX_CALLMODE_SYNCHRON, pSfxApp->GetPool() );
//STRIP001     aReq.AppendItem( SfxBoolItem(SID_RECORDMACRO,TRUE) );
//STRIP001     const SfxPoolItem* pRet = SFX_APP()->ExecuteSlot( aReq );
//STRIP001     String aScriptURL;
//STRIP001     if ( pRet )
//STRIP001         aScriptURL = ((SfxStringItem*)pRet)->GetValue();
//STRIP001     if ( aScriptURL.Len() )
//STRIP001     {
//STRIP001 		// parse script URL
//STRIP001         BOOL bFound;
//STRIP001         String aValue;
//STRIP001         INetURLObject aINetScriptURL( aScriptURL );
//STRIP001 
//STRIP001         // get language
//STRIP001         String aLanguage;
//STRIP001         bFound = aINetScriptURL.getParameter( String( RTL_CONSTASCII_USTRINGPARAM("language") ), &aValue );
//STRIP001         if ( bFound )
//STRIP001             aLanguage = aValue;
//STRIP001 
//STRIP001         // get macro
//STRIP001         String aMacro;
//STRIP001         String aLibName;
//STRIP001         String aModuleName;
//STRIP001         String aMacroName;
//STRIP001         bFound = aINetScriptURL.getParameter( String( RTL_CONSTASCII_USTRINGPARAM("macro") ), &aValue );
//STRIP001         if ( bFound )
//STRIP001         {
//STRIP001             aMacro = aValue;
//STRIP001             aLibName    = aMacro.GetToken(0, sal_Unicode('.'));
//STRIP001 		    aModuleName = aMacro.GetToken(1, sal_Unicode('.'));
//STRIP001 		    aMacroName  = aMacro.GetToken(2, sal_Unicode('.'));
//STRIP001         }
//STRIP001 
//STRIP001         // get location
//STRIP001         String aLocation;
//STRIP001         bFound = aINetScriptURL.getParameter( String( RTL_CONSTASCII_USTRINGPARAM("location") ), &aValue );
//STRIP001         if ( bFound )
//STRIP001             aLocation = aValue;
//STRIP001 
//STRIP001 		pSfxApp->EnterBasicCall();
//STRIP001 
//STRIP001 		SfxObjectShell* pShell = 0;
//STRIP001 		BasicManager* pBasMgr = 0;
//STRIP001         if ( aLocation.EqualsIgnoreCaseAscii( "application" ) )
//STRIP001         {
//STRIP001 			// application basic
//STRIP001 			pBasMgr = pSfxApp->GetBasicManager();
//STRIP001 		}
//STRIP001         else if ( aLocation.EqualsIgnoreCaseAscii( "document" ) )
//STRIP001         {
//STRIP001             pBasMgr = GetObjectShell()->GetBasicManager();
//STRIP001 		}
//STRIP001 
//STRIP001         ::rtl::OUString aOUSource;
//STRIP001         if ( pBasMgr)
//STRIP001 		{
//STRIP001 			StarBASIC* pBasic = pBasMgr->GetLib( aLibName );
//STRIP001 			if ( pBasic )
//STRIP001 			{
//STRIP001 				SbModule* pModule = pBasic->FindModule( aModuleName );
//STRIP001 				if ( pModule )
//STRIP001 				{
//STRIP001                     SbMethod* pMethod = (SbMethod*)pModule->GetMethods()->Find( aMacroName, SbxCLASS_METHOD );
//STRIP001                     aOUSource = pModule->GetSource32();
//STRIP001                     USHORT nStart, nEnd;
//STRIP001                     pMethod->GetLineRange( nStart, nEnd );
//STRIP001                     ULONG nlStart = nStart;
//STRIP001                     ULONG nlEnd = nEnd;
//STRIP001                     CutLines( aOUSource, nlStart-1, nlEnd-nlStart+1, TRUE );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001         // open lib container and break operation if it couldn't be opened
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::script::XLibraryContainer > xLibCont;
//STRIP001         if ( aLocation.EqualsIgnoreCaseAscii( "application" ) )
//STRIP001         {
//STRIP001             xLibCont = SFX_APP()->GetBasicContainer();
//STRIP001 		}
//STRIP001         else if ( aLocation.EqualsIgnoreCaseAscii( "document" ) )
//STRIP001         {
//STRIP001             xLibCont = GetObjectShell()->GetBasicContainer();
//STRIP001 		}
//STRIP001 
//STRIP001         if(!xLibCont.is())
//STRIP001         {
//STRIP001             DBG_ERRORFILE("couldn't get access to the basic lib container. Adding of macro isn't possible.");
//STRIP001             return;
//STRIP001         }
//STRIP001 
//STRIP001         // get LibraryContainer
//STRIP001         ::com::sun::star::uno::Any aTemp;
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > xRoot(
//STRIP001                 xLibCont,
//STRIP001                 ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001         ::rtl::OUString sLib( aLibName );
//STRIP001         ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess > xLib;
//STRIP001         if(xRoot->hasByName(sLib))
//STRIP001         {
//STRIP001             // library must be loaded
//STRIP001             aTemp = xRoot->getByName(sLib);
//STRIP001             xLibCont->loadLibrary(sLib);
//STRIP001             aTemp >>= xLib;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             xLib = ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameAccess >(
//STRIP001                         xLibCont->createLibrary(sLib),
//STRIP001                         ::com::sun::star::uno::UNO_QUERY);
//STRIP001         }
//STRIP001 
//STRIP001         // pack the macro as direct usable "sub" routine
//STRIP001         ::rtl::OUString sCode;
//STRIP001         ::rtl::OUStringBuffer sRoutine(10000);
//STRIP001         ::rtl::OUString sMacroName( aMacroName );
//STRIP001         BOOL bReplace = FALSE;
//STRIP001 
//STRIP001         // get module
//STRIP001         ::rtl::OUString sModule( aModuleName );
//STRIP001         if(xLib->hasByName(sModule))
//STRIP001         {
//STRIP001             if ( aOUSource.getLength() )
//STRIP001             {
//STRIP001                 sRoutine.append( aOUSource );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 aTemp = xLib->getByName(sModule);
//STRIP001                 aTemp >>= sCode;
//STRIP001                 sRoutine.append( sCode );
//STRIP001             }
//STRIP001 
//STRIP001             bReplace = TRUE;
//STRIP001         }
//STRIP001 
//STRIP001         // append new method
//STRIP001         sRoutine.appendAscii("\nsub "     );
//STRIP001         sRoutine.append     (sMacroName   );
//STRIP001         sRoutine.appendAscii("\n"         );
//STRIP001         sRoutine.append     (sMacro       );
//STRIP001         sRoutine.appendAscii("\nend sub\n");
//STRIP001 
//STRIP001         // create the modul inside the library and insert the macro routine
//STRIP001         aTemp <<= sRoutine.makeStringAndClear();
//STRIP001         if ( bReplace )
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > xModulCont(
//STRIP001                 xLib,
//STRIP001                 ::com::sun::star::uno::UNO_QUERY);
//STRIP001             xModulCont->replaceByName(sModule,aTemp);
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer > xModulCont(
//STRIP001                 xLib,
//STRIP001                 ::com::sun::star::uno::UNO_QUERY);
//STRIP001             xModulCont->insertByName(sModule,aTemp);
//STRIP001         }
//STRIP001 
//STRIP001         pSfxApp->LeaveBasicCall();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         // add code for "session only" macro
//STRIP001     }
//STRIP001 
//STRIP001     /*
//STRIP001     FILE* pFile = fopen( "macro.bas", "a" );
//STRIP001     fprintf( pFile, "%s", ::rtl::OUStringToOString(sBuffer.makeStringAndClear(),RTL_TEXTENCODING_UTF8).getStr() );
//STRIP001     fclose ( pFile );
//STRIP001     */
//STRIP001 }

/*N*/ void SfxViewFrame::MiscExec_Impl( SfxRequest& rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	DBG_MEMTEST();
//STRIP001 	FASTBOOL bDone = FALSE;
//STRIP001 	switch ( rReq.GetSlot() )
//STRIP001 	{
//STRIP001         case SID_STOP_RECORDING :
//STRIP001         case SID_RECORDMACRO :
//STRIP001         {
//STRIP001             // try to find any active recorder on this frame
//STRIP001             ::rtl::OUString sProperty = ::rtl::OUString::createFromAscii("DispatchRecorderSupplier");
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XFrame > xFrame(
//STRIP001                     GetFrame()->GetFrameInterface(),
//STRIP001                     ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > xSet(xFrame,com::sun::star::uno::UNO_QUERY);
//STRIP001             ::com::sun::star::uno::Any aProp = xSet->getPropertyValue(sProperty);
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier;
//STRIP001             aProp >>= xSupplier;
//STRIP001             ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder > xRecorder;
//STRIP001             if (xSupplier.is())
//STRIP001                 xRecorder = xSupplier->getDispatchRecorder();
//STRIP001 
//STRIP001             BOOL bIsRecording = xRecorder.is();
//STRIP001             SFX_REQUEST_ARG( rReq, pItem, SfxBoolItem, SID_RECORDMACRO, sal_False);
//STRIP001             if ( pItem && pItem->GetValue() == bIsRecording )
//STRIP001                 return;
//STRIP001 
//STRIP001             if ( xRecorder.is() )
//STRIP001             {
//STRIP001                 // disable active recording
//STRIP001                 aProp <<= ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier >();
//STRIP001                 xSet->setPropertyValue(sProperty,aProp);
//STRIP001 
//STRIP001                 SFX_REQUEST_ARG( rReq, pRecordItem, SfxBoolItem, FN_PARAM_1, sal_False);
//STRIP001                 if ( !pRecordItem || !pRecordItem->GetValue() )
//STRIP001                     // insert script into basic library container of application
//STRIP001                     AddDispatchMacroToBasic_Impl(xRecorder->getRecordedMacro());
//STRIP001 
//STRIP001                 xRecorder->endRecording();
//STRIP001                 xRecorder = NULL;
//STRIP001 				GetBindings().SetRecorder_Impl( xRecorder );
//STRIP001 
//STRIP001                 SetChildWindow( SID_RECORDING_FLOATWINDOW, FALSE );
//STRIP001                 if ( rReq.GetSlot() != SID_RECORDMACRO )
//STRIP001                     GetBindings().Invalidate( SID_RECORDMACRO );
//STRIP001             }
//STRIP001             else if ( rReq.GetSlot() == SID_RECORDMACRO )
//STRIP001             {
//STRIP001                 // enable recording
//STRIP001                 ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory > xFactory(
//STRIP001                         ::legacy_binfilters::getLegacyProcessServiceFactory(),
//STRIP001                         ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001                 xRecorder = ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorder >(
//STRIP001                         xFactory->createInstance(::rtl::OUString::createFromAscii("com.sun.star.frame.DispatchRecorder")),
//STRIP001                         ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001                 ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier(
//STRIP001                         xFactory->createInstance(::rtl::OUString::createFromAscii("com.sun.star.frame.DispatchRecorderSupplier")),
//STRIP001                         ::com::sun::star::uno::UNO_QUERY);
//STRIP001 
//STRIP001                 xSupplier->setDispatchRecorder(xRecorder);
//STRIP001                 xRecorder->startRecording(xFrame);
//STRIP001                 aProp <<= xSupplier;
//STRIP001                 xSet->setPropertyValue(sProperty,aProp);
//STRIP001 				GetBindings().SetRecorder_Impl( xRecorder );
//STRIP001                 SetChildWindow( SID_RECORDING_FLOATWINDOW, TRUE );
//STRIP001             }
//STRIP001 
//STRIP001             rReq.Done();
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001 		case SID_TOGGLESTATUSBAR:
//STRIP001 		{
//STRIP001             SfxToolBoxConfig* pTbxCfg = GetObjectShell()->GetToolBoxConfig_Impl();
//STRIP001 
//STRIP001 			// Parameter auswerten
//STRIP001 			SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, rReq.GetSlot(), FALSE);
//STRIP001 			BOOL bShow = pShowItem 	? pShowItem->GetValue()
//STRIP001 									: !pTbxCfg->IsStatusBarVisible();
//STRIP001 			pTbxCfg->SetStatusBarVisible( bShow );
//STRIP001             GetFrame()->GetWorkWindow_Impl()->UpdateObjectBars_Impl();
//STRIP001 			if ( !pShowItem )
//STRIP001 				rReq.AppendItem( SfxBoolItem( SID_TOGGLESTATUSBAR, bShow ) );
//STRIP001 			rReq.Done();
//STRIP001 			break;
//STRIP001 		}
//STRIP001 
//STRIP001 		// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
//STRIP001 		case SID_WIN_FULLSCREEN:
//STRIP001 		{
//STRIP001             SFX_REQUEST_ARG(rReq, pItem, SfxBoolItem, rReq.GetSlot(), FALSE);
//STRIP001             SfxTopViewFrame *pTop= PTR_CAST( SfxTopViewFrame, GetTopViewFrame() );
//STRIP001             if ( pTop )
//STRIP001             {
//STRIP001                 WorkWindow* pWork = (WorkWindow*) pTop->GetTopFrame_Impl()->GetTopWindow_Impl();
//STRIP001                 if ( pWork )
//STRIP001                 {
//STRIP001                     BOOL bNewFullScreenMode = pItem ? pItem->GetValue() : !pWork->IsFullScreenMode();
//STRIP001 					if ( bNewFullScreenMode != pWork->IsFullScreenMode() )
//STRIP001 					{
//STRIP001 	                    pWork->ShowFullScreenMode( bNewFullScreenMode );
//STRIP001 	                    pWork->SetMenuBarMode( bNewFullScreenMode ? MENUBAR_MODE_HIDE : MENUBAR_MODE_NORMAL );
//STRIP001 	                    GetFrame()->GetWorkWindow_Impl()->SetFullScreen_Impl( bNewFullScreenMode );
//STRIP001 	                    if ( !pItem )
//STRIP001 	                        rReq.AppendItem( SfxBoolItem( SID_WIN_FULLSCREEN, bNewFullScreenMode ) );
//STRIP001 	                    rReq.Done();
//STRIP001 					}
//STRIP001 					else
//STRIP001 						rReq.Ignore();
//STRIP001                 }
//STRIP001             }
//STRIP001             else
//STRIP001                 rReq.Ignore();
//STRIP001 
//STRIP001             GetDispatcher()->Update_Impl( TRUE );
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bDone )
//STRIP001 		rReq.Done();
/*N*/ }

/*N*/ void SfxViewFrame::MiscState_Impl(SfxItemSet &rSet)
/*N*/ {
/*N*/ 	DBG_MEMTEST();
/*N*/ 
/*N*/ 	int bSearchedMDI = FALSE;
/*N*/ 	int bFoundNormMDI = FALSE;
/*N*/ 	int bFoundMiniMDI = FALSE;
/*N*/ 	int bFoundNonDesktopMDI = FALSE;
/*N*/ 
/*N*/ 	const USHORT *pRanges = rSet.GetRanges();
/*N*/ 	DBG_ASSERT(pRanges && *pRanges, "Set ohne Bereich");
/*N*/ 	while ( *pRanges )
/*N*/ 	{
/*N*/ 		for(USHORT nWhich = *pRanges++; nWhich <= *pRanges; ++nWhich)
/*N*/ 		{
/*N*/ 			switch(nWhich)
/*N*/ 			{
/*N*/                 case SID_CURRENT_URL:
/*N*/                 {
/*N*/                     // Bei internem InPlace den ContainerFrame nehmen
/*N*/                     SfxViewFrame *pFrame = this;
/*N*/                     if ( pFrame->GetParentViewFrame_Impl() )
/*?*/                         pFrame = pFrame->GetParentViewFrame_Impl();
/*N*/                     rSet.Put( SfxStringItem( nWhich, pFrame->GetActualPresentationURL_Impl() ) );
/*N*/ 	                break;
/*N*/                 }
/*N*/ 
/*N*/                 case SID_RECORDMACRO :
/*N*/                 {
/*N*/ 					const char* pName = GetObjectShell()->GetFactory().GetShortName();
/*N*/ 					if (  strcmp(pName,"swriter") && strcmp(pName,"scalc") )
/*N*/ 					{
/*N*/                         rSet.DisableItem( nWhich );
/*N*/ 						break;
/*N*/ 					}
/*N*/ 
/*N*/                     ::rtl::OUString sProperty = ::rtl::OUString::createFromAscii("DispatchRecorderSupplier");
/*N*/                     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > xSet(
/*N*/                             GetFrame()->GetFrameInterface(),
/*N*/                             ::com::sun::star::uno::UNO_QUERY);
/*N*/ 
/*N*/                     ::com::sun::star::uno::Any aProp = xSet->getPropertyValue(sProperty);
/*N*/                     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier;
/*N*/                     if ( aProp >>= xSupplier )
/*N*/                         rSet.Put( SfxBoolItem( nWhich, xSupplier.is() ) );
/*N*/                     else
/*?*/                         rSet.DisableItem( nWhich );
/*N*/                     break;
/*N*/                 }
/*N*/ 
/*N*/                 case SID_STOP_RECORDING :
/*N*/                 {
/*?*/ 					const char* pName = GetObjectShell()->GetFactory().GetShortName();
/*?*/ 					if (  strcmp(pName,"swriter") && strcmp(pName,"scalc") )
/*?*/ 					{
/*?*/                         rSet.DisableItem( nWhich );
/*?*/ 						break;
/*?*/ 					}
/*?*/ 
/*?*/                     ::rtl::OUString sProperty = ::rtl::OUString::createFromAscii("DispatchRecorderSupplier");
/*?*/                     ::com::sun::star::uno::Reference< ::com::sun::star::beans::XPropertySet > xSet(
/*?*/                             GetFrame()->GetFrameInterface(),
/*?*/                             ::com::sun::star::uno::UNO_QUERY);
/*?*/ 
/*?*/                     ::com::sun::star::uno::Any aProp = xSet->getPropertyValue(sProperty);
/*?*/                     ::com::sun::star::uno::Reference< ::com::sun::star::frame::XDispatchRecorderSupplier > xSupplier;
/*?*/                     if ( !(aProp >>= xSupplier) || !xSupplier.is() )
/*?*/                         rSet.DisableItem( nWhich );
/*?*/                     break;
/*N*/                 }
/*N*/ 
/*N*/ 				case SID_TOGGLESTATUSBAR:
/*N*/ 				{
/*?*/                     rSet.Put( SfxBoolItem( nWhich, GetObjectShell()->GetToolBoxConfig_Impl()->IsStatusBarVisible() ) );
/*?*/ 					break;
/*N*/ 				}
/*N*/ 
/*N*/ 				case SID_WIN_FULLSCREEN:
/*N*/                 {
/*N*/                     SfxTopViewFrame *pTop= PTR_CAST( SfxTopViewFrame, GetTopViewFrame() );
/*N*/                     if ( pTop )
/*N*/                     {
/*N*/                         WorkWindow* pWork = (WorkWindow*) pTop->GetTopFrame_Impl()->GetTopWindow_Impl();
/*N*/                         if ( pWork )
/*N*/                         {
/*N*/                             rSet.Put( SfxBoolItem( nWhich, pWork->IsFullScreenMode() ) );
/*N*/                             break;
/*N*/                         }
/*N*/                     }
/*N*/ 
/*?*/                     rSet.DisableItem( nWhich );
/*N*/ 					break;
/*N*/                 }
/*N*/ 
/*N*/ 				default:
/*N*/ 					//! DBG_ASSERT(FALSE, "Falscher Server fuer GetState");
/*N*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		++pRanges;
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewFrame::ChildWindowExecute( SfxRequest &rReq )

/* 	[Beschreibung]

	Diese Methode kann in der Execute-Methode f"ur das ein- und ausschalten
	von Child-Windows eingesetzt werden, um dieses inkl. API-Anbindung zu
	implementieren.

	Einfach in der IDL als 'ExecuteMethod' eintragen.
*/

/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	// Parameter auswerten
//STRIP001 	USHORT nSID = rReq.GetSlot();
//STRIP001 
//STRIP001 	SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nSID, FALSE);
//STRIP001     if ( nSID == SID_VIEW_DATA_SOURCE_BROWSER )
//STRIP001     {
//STRIP001         Reference < XFrame > xFrame = GetFrame()->GetTopFrame()->GetFrameInterface();
//STRIP001         Reference < XFrame > xBeamer( xFrame->findFrame( DEFINE_CONST_UNICODE("_beamer"), FrameSearchFlag::CHILDREN ) );
//STRIP001         BOOL bShow = FALSE;
//STRIP001         BOOL bHasChild = xBeamer.is();
//STRIP001         bShow = pShowItem ? pShowItem->GetValue() : !bHasChild;
//STRIP001         if ( pShowItem )
//STRIP001         {
//STRIP001             if( bShow == bHasChild )
//STRIP001                 return;
//STRIP001         }
//STRIP001         else
//STRIP001             rReq.AppendItem( SfxBoolItem( nSID, bShow ) );
//STRIP001 
//STRIP001         if ( !bShow )
//STRIP001         {
//STRIP001             SetChildWindow( SID_BROWSER, FALSE );
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             ::com::sun::star::util::URL aTargetURL;
//STRIP001             aTargetURL.Complete = ::rtl::OUString::createFromAscii(".component:DB/DataSourceBrowser");
//STRIP001             Reference < ::com::sun::star::util::XURLTransformer > xTrans( ::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer" )), UNO_QUERY );
//STRIP001             xTrans->parseStrict( aTargetURL );
//STRIP001 
//STRIP001             Reference < XDispatchProvider > xProv( xFrame, UNO_QUERY );
//STRIP001             Reference < ::com::sun::star::frame::XDispatch > xDisp;
//STRIP001             if ( xProv.is() )
//STRIP001                 xDisp = xProv->queryDispatch( aTargetURL, ::rtl::OUString::createFromAscii("_beamer"), 31 );
//STRIP001             if ( xDisp.is() )
//STRIP001             {
//STRIP001                 Sequence < ::com::sun::star::beans::PropertyValue > aArgs(1);
//STRIP001                 ::com::sun::star::beans::PropertyValue* pArg = aArgs.getArray();
//STRIP001                 pArg[0].Name = ::rtl::OUString::createFromAscii("Referer");
//STRIP001                 pArg[0].Value <<= ::rtl::OUString::createFromAscii("private:user");
//STRIP001                 xDisp->dispatch( aTargetURL, aArgs );
//STRIP001             }
//STRIP001         }
//STRIP001 
//STRIP001         rReq.Done();
//STRIP001         return;
//STRIP001     }
//STRIP001 
//STRIP001 	BOOL bShow = FALSE;
//STRIP001 	BOOL bHasChild = HasChildWindow(nSID);
//STRIP001 	bShow = pShowItem ? pShowItem->GetValue() : !bHasChild;
//STRIP001 
//STRIP001 	// ausf"uhren
//STRIP001 	if ( !pShowItem || bShow != bHasChild )
//STRIP001 		ToggleChildWindow( nSID );
//STRIP001 
//STRIP001 	if ( nSID == SID_CUSTOMIZETOOLBOX )
//STRIP001 	{
//STRIP001 		// Provide toolbox type to customize window to preselect it in the modeless dialog
//STRIP001 		SfxToolboxCustomWindow* pTbxCustomWin = (SfxToolboxCustomWindow*)GetChildWindow( nSID );
//STRIP001 		if ( pTbxCustomWin && bShow )
//STRIP001 		{
//STRIP001 			SFX_REQUEST_ARG( rReq, pItem, SfxUInt16Item, SID_CONFIGITEMID, FALSE );
//STRIP001 			if ( pItem )
//STRIP001 			{
//STRIP001 				USHORT nId = pItem->GetValue();
//STRIP001 				pTbxCustomWin->SelectToolbar( nId );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	GetBindings().Invalidate( nSID );
//STRIP001     GetDispatcher()->Update_Impl( TRUE );
//STRIP001 
//STRIP001 	// ggf. recorden
//STRIP001     if ( nSID == SID_HYPERLINK_DIALOG || nSID == SID_SEARCH_DLG )
//STRIP001     {
//STRIP001         rReq.Ignore();
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         rReq.AppendItem( SfxBoolItem( nSID, bShow ) );
//STRIP001         rReq.Done();
//STRIP001     }
/*N*/ }

//--------------------------------------------------------------------

/*N*/ void SfxViewFrame::ChildWindowState( SfxItemSet& rState )

/* 	[Beschreibung]

	Diese Methode kann in der Status-Methode f"ur das Ein- und Ausschalt-
	Zustand von Child-Windows eingesetzt werden, um dieses zu implementieren.

	Einfach in der IDL als 'StateMethod' eintragen.
*/

/*N*/ {
/*N*/ 	SfxWhichIter aIter( rState );
/*N*/ 	for ( USHORT nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
/*N*/ 	{
/*N*/         if ( nSID == SID_VIEW_DATA_SOURCE_BROWSER )
/*N*/         {
/*N*/             rState.Put( SfxBoolItem( nSID, HasChildWindow( SID_BROWSER ) ) );
/*N*/         }
/*N*/         else if ( nSID == SID_HYPERLINK_DIALOG )
/*N*/ 		{
/*N*/ 			const SfxPoolItem* pDummy = NULL;
/*N*/             SfxItemState eState = GetDispatcher()->QueryState( SID_HYPERLINK_SETLINK, pDummy );
/*N*/ 			if ( SFX_ITEM_DISABLED == eState )
/*N*/ 				rState.DisableItem(nSID);
/*N*/ 			else
/*N*/ 			{
/*N*/ 				if ( KnowsChildWindow(nSID) )
/*N*/ 					rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID)) );
/*N*/ 				else
/*?*/ 					rState.DisableItem(nSID);
/*N*/ 			}
/*N*/ 		}
/*N*/         else if ( nSID == SID_BROWSER )
/*N*/ 		{
/*?*/ 			Reference < XFrame > xFrame = GetFrame()->GetTopFrame()->GetFrameInterface()->
/*?*/ 							findFrame( DEFINE_CONST_UNICODE("_beamer"), FrameSearchFlag::CHILDREN );
/*?*/ 			if ( !xFrame.is() )
/*?*/ 				rState.DisableItem( nSID );
/*?*/ 			else if ( KnowsChildWindow(nSID) )
/*?*/ 				rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID) ) );
/*N*/ 		}
/*N*/ 		else if ( KnowsChildWindow(nSID) )
/*N*/ 			rState.Put( SfxBoolItem( nSID, HasChildWindow(nSID) ) );
/*N*/ 		else
/*N*/ 			rState.DisableItem(nSID);
/*N*/ 	}
/*N*/ }

/*N*/ void SfxViewFrame::ToolboxExec_Impl( SfxRequest &rReq )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     // Object-Bar-Id ermitteln
//STRIP001     sal_uInt16 nSID = rReq.GetSlot(), nTbxID;
//STRIP001     SFX_REQUEST_ARG(rReq, pShowItem, SfxBoolItem, nSID, sal_False);
//STRIP001 	BOOL bShow;
//STRIP001 
//STRIP001     if ( nSID == SID_TOGGLE_MENUBAR )
//STRIP001     {
//STRIP001         SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetTopViewFrame() );
//STRIP001         SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
//STRIP001         if ( pTop )
//STRIP001         {
//STRIP001             bShow = pShowItem ? pShowItem->GetValue() : ( pTop->GetMenuBar_Impl() == 0 );
//STRIP001             pTop->SetMenuBarOn_Impl( bShow );
//STRIP001             GetDispatcher()->Update_Impl(sal_True);
//STRIP001         }
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         switch ( nSID )
//STRIP001         {
//STRIP001             case SID_TOGGLEFUNCTIONBAR:     nTbxID = SFX_OBJECTBAR_APPLICATION; break;
//STRIP001             case SID_TOGGLEOBJECTBAR:       nTbxID = SFX_OBJECTBAR_OBJECT; break;
//STRIP001             case SID_TOGGLETOOLBAR:         nTbxID = SFX_OBJECTBAR_TOOLS; break;
//STRIP001             case SID_TOGGLEMACROBAR:        nTbxID = SFX_OBJECTBAR_MACRO; break;
//STRIP001             case SID_TOGGLEOPTIONBAR:       nTbxID = SFX_OBJECTBAR_OPTIONS; break;
//STRIP001             case SID_TOGGLECOMMONTASKBAR:   nTbxID = SFX_OBJECTBAR_COMMONTASK; break;
//STRIP001             case SID_TOGGLENAVBAR:          nTbxID = SFX_OBJECTBAR_NAVIGATION; break;
//STRIP001             //case SID_TOGGLERECORDINGBAR:  nTbxID = SFX_OBJECTBAR_RECORDING; break;
//STRIP001             //case SID_TOGGLEFULLSCREENBAR: nTbxID = SFX_OBJECTBAR_FULLSCREEN; break;
//STRIP001             default:
//STRIP001                 DBG_ERROR( "invalid ObjectBar`s SID" );
//STRIP001         }
//STRIP001 
//STRIP001         // Parameter auswerten
//STRIP001         SfxToolBoxConfig *pTbxConfig = GetObjectShell()->GetToolBoxConfig_Impl();
//STRIP001 
//STRIP001         // ausfuehren
//STRIP001         bShow = pShowItem ? pShowItem->GetValue() : !pTbxConfig->IsToolBoxPositionVisible(nTbxID);
//STRIP001         pTbxConfig->SetToolBoxPositionVisible(nTbxID, bShow);
//STRIP001         GetBindings().Invalidate( nSID );
//STRIP001 
//STRIP001         SfxViewFrame* pViewFrame = SfxViewFrame::GetFirst();
//STRIP001         while ( pViewFrame )
//STRIP001         {
//STRIP001             // update all "final" dispatchers
//STRIP001             if ( !pViewFrame->GetActiveChildFrame_Impl() )
//STRIP001                 pViewFrame->GetDispatcher()->Update_Impl(sal_True);
//STRIP001             pViewFrame = SfxViewFrame::GetNext(*pViewFrame);
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001 	if ( !pShowItem )
//STRIP001 		rReq.AppendItem( SfxBoolItem( nSID, bShow ) );
//STRIP001 	rReq.Done();
/*N*/ }

//------------------------------------------------------------------------


/*N*/ void SfxViewFrame::ToolboxState_Impl( SfxItemSet &rSet )
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001     SfxWhichIter aIter(rSet);
//STRIP001     for ( sal_uInt16 nSID = aIter.FirstWhich(); nSID; nSID = aIter.NextWhich() )
//STRIP001     {
//STRIP001         SfxToolBoxConfig *pTbxConfig = GetObjectShell()->GetToolBoxConfig_Impl();
//STRIP001         switch ( nSID )
//STRIP001         {
//STRIP001             case SID_TOGGLE_MENUBAR:
//STRIP001             {
//STRIP001                 SfxTopViewFrame* pTopView = PTR_CAST( SfxTopViewFrame, GetTopViewFrame() );
//STRIP001                 SfxTopFrame *pTop = pTopView ? pTopView->GetTopFrame_Impl() : NULL;
//STRIP001                 if ( pTop )
//STRIP001                     rSet.Put( SfxBoolItem( nSID, pTop->IsMenuBarOn_Impl() ) );
//STRIP001                 else
//STRIP001                     rSet.DisableItem( nSID );
//STRIP001                 break;
//STRIP001             }
//STRIP001 
//STRIP001             case SID_TOGGLEFUNCTIONBAR:
//STRIP001                     rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                         IsToolBoxPositionVisible(SFX_OBJECTBAR_APPLICATION)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLEOBJECTBAR:
//STRIP001                     rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                         IsToolBoxPositionVisible(SFX_OBJECTBAR_OBJECT)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLEOPTIONBAR:
//STRIP001                     rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                         IsToolBoxPositionVisible(SFX_OBJECTBAR_OPTIONS)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLETOOLBAR:
//STRIP001                 	rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                     	IsToolBoxPositionVisible(SFX_OBJECTBAR_TOOLS)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLEMACROBAR:
//STRIP001                 	rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                     	IsToolBoxPositionVisible(SFX_OBJECTBAR_MACRO)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLECOMMONTASKBAR:
//STRIP001                 	rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                     	IsToolBoxPositionVisible(SFX_OBJECTBAR_COMMONTASK)));
//STRIP001                 break;
//STRIP001 
//STRIP001             case SID_TOGGLENAVBAR:
//STRIP001                 	rSet.Put( SfxBoolItem( nSID, pTbxConfig->
//STRIP001                     	IsToolBoxPositionVisible(SFX_OBJECTBAR_NAVIGATION)));
//STRIP001                 break;
//STRIP001 
//STRIP001             default:
//STRIP001                 DBG_ERROR( "invalid ObjectBar`s SID" );
//STRIP001         }
//STRIP001     }
/*N*/ }

//--------------------------------------------------------------------
/*N*/ SfxWorkWindow* SfxViewFrame::GetWorkWindow_Impl( USHORT nId )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = 0;
/*N*/     if ( IsA( TYPE(SfxInPlaceFrame) ) )
/*N*/ 	{
/*?*/ 		SfxShell* pShell;
/*?*/ 		const SfxSlot* pSlot;
/*?*/         if( !GetDispatcher()->GetShellAndSlot_Impl( nId, &pShell, &pSlot, FALSE, TRUE ) && GetParentViewFrame_Impl() )
/*?*/ 			// Containerslot !
/*?*/             pWork = GetParentViewFrame_Impl()->GetFrame()->GetWorkWindow_Impl();
/*?*/         else
/*?*/             pWork = GetFrame()->GetWorkWindow_Impl();
/*N*/     }
/*N*/     else
/*N*/         pWork = GetFrame()->GetWorkWindow_Impl();
/*N*/ 
/*N*/     return pWork;
/*N*/ }

/*
void SfxViewFrame::SetChildWindow(USHORT nId, BOOL bOn)
{
    SetChildWindow( nId, bOn, TRUE );
}*/

/*N*/ void SfxViewFrame::SetChildWindow(USHORT nId, BOOL bOn, BOOL bSetFocus )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/     if ( pWork )
/*N*/         pWork->SetChildWindow_Impl( nId, bOn, bSetFocus );
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewFrame::ToggleChildWindow(USHORT nId)
//STRIP001 {
//STRIP001     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
//STRIP001     if ( pWork )
//STRIP001         pWork->ToggleChildWindow_Impl( nId, TRUE );
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewFrame::HasChildWindow( USHORT nId )
/*N*/ {
/*N*/ 	SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->HasChildWindow_Impl(nId) : FALSE;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ BOOL SfxViewFrame::KnowsChildWindow( USHORT nId )
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->KnowsChildWindow_Impl(nId) : FALSE;
/*N*/ }

//--------------------------------------------------------------------

//STRIP001 void SfxViewFrame::ShowChildWindow( USHORT nId, BOOL bVisible )
//STRIP001 {
//STRIP001     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
//STRIP001     if ( pWork )
//STRIP001         pWork->ShowChildWindow_Impl(nId, bVisible, TRUE );
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxChildWindow* SfxViewFrame::GetChildWindow(USHORT nId)
/*N*/ {
/*N*/     SfxWorkWindow* pWork = GetWorkWindow_Impl( nId );
/*N*/ 	return pWork ? pWork->GetChildWindow_Impl(nId) : NULL;
/*N*/ }

/*N*/ SfxImageManager* SfxViewFrame::GetImageManager()
/*N*/ {
/*N*/     return GetObjectShell()->GetImageManager_Impl();
/*N*/ }

//STRIP001 SfxMacro* SfxViewFrame::GetRecordingMacro_Impl()
//STRIP001 {
//STRIP001     return pImp->pMacro;
//STRIP001 }
}
